/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.DrivesSpinUpProgressDialog;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.simple.SimpleConfigConstants;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.CapacityHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_ALLOWED_OPS_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_LD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_LD_TARGETID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.spareType_MR_SPARE;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import java.util.ArrayList;
import java.util.Stack;

public class SimpleConfigEngine
extends SimpleConfigConstants {
    AdapterHelper m_objAdapterHelper = null;
    SimpleConfigParams m_objSimpleConfigParams = null;
    MR_CONFIG_DATA m_objMRConfigData = new MR_CONFIG_DATA();
    private Stack<Short> m_freeArrayReferences = null;
    private Stack<Byte> m_stLDTargetID = null;
    private int m_iAdapterType;
    private boolean m_isOldArray = false;
    private CapacityHelper m_capacityHelper = null;
    MR_LD_PROPERTIES m_objLDPropertiesForArray = new MR_LD_PROPERTIES();
    MR_LD_PARAMETERS m_objLDParametersForArray = new MR_LD_PARAMETERS();
    MR_MFC_DEFAULTS m_objMFCDefaults = null;
    private byte[] m_ldTargetId;
    char m_cStripeSize;
    private long m_cacheVolumeSize;
    private long m_bootVolumeSize;
    private long lNumBlocks;

    public SimpleConfigEngine(AdapterHelper adapterHelper) {
        this.m_objAdapterHelper = adapterHelper;
        this.init();
    }

    public SimpleConfigEngine(AdapterHelper adapterHelper, CapacityHelper capacityHelper) {
        this.m_objAdapterHelper = adapterHelper;
        this.m_isOldArray = true;
        this.m_capacityHelper = capacityHelper;
        this.init();
        this.setLDPropsAndParamsForArray(this.m_capacityHelper);
    }

    public String fireConfigCommand() throws VKOperationFailedException {
        String string = "The Virtual drives were successfully created.";
        this.m_objMRConfigData = this.createMRConfigData();
        try {
            if (!this.m_isOldArray) {
                this.spinUpPowerSaveDrives();
            }
            OperationDetails operationDetails = new OperationDetails(1, this.m_objMRConfigData);
            ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).fireConfigOperation(operationDetails);
        }
        catch (Exception exception) {
            string = "Exception while creating configuration";
            exception.printStackTrace();
        }
        return string;
    }

    public MR_CONFIG_DATA createMRConfigData() {
        int n;
        Object object;
        MR_ARRAY[] mR_ARRAYArray;
        if (this.m_isOldArray) {
            mR_ARRAYArray = new MR_ARRAY[]{this.m_capacityHelper.getSLArrayInfo().getarray()};
        } else {
            int n2 = this.m_objSimpleConfigParams.getNumVirtualDrives();
            mR_ARRAYArray = new MR_ARRAY[n2];
            object = this.m_objSimpleConfigParams.getPDListForDriveGroup();
            n = ((ArrayList)object).size() / n2;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>(((ArrayList)object).subList(n3, n3 + n));
                mR_ARRAYArray[i] = this.createMRArray(arrayList);
                n3 += n;
            }
        }
        this.m_objMRConfigData.setarray(mR_ARRAYArray);
        MR_LD_CONFIG[] mR_LD_CONFIGArray = this.m_cacheVolumeSize > 0L ? this.createMRLDConfigsForCSABootVolume(mR_ARRAYArray) : this.createMRLDConfigs(mR_ARRAYArray);
        this.m_objMRConfigData.setld(mR_LD_CONFIGArray);
        if (this.m_objSimpleConfigParams != null) {
            object = this.m_objSimpleConfigParams.getHotSpare();
            n = this.m_objSimpleConfigParams.getNumVirtualDrives();
            if (object != null) {
                MR_SPARE[] mR_SPAREArray = new MR_SPARE[]{this.createMRSpare(mR_ARRAYArray, (PhysicalDriveHelper)object)};
                this.m_objMRConfigData.setspare(mR_SPAREArray);
            }
        }
        return this.m_objMRConfigData;
    }

    public AdapterHelper getAdapterHelper() {
        return this.m_objAdapterHelper;
    }

    public void setSimpleConfigParams(SimpleConfigParams simpleConfigParams) {
        this.m_objSimpleConfigParams = simpleConfigParams;
    }

    public SimpleConfigParams getSimpleConfigParams() {
        return this.m_objSimpleConfigParams;
    }

    public byte getRAIDLevelForExistingArray() {
        byte by = this.m_objLDParametersForArray.getPRL();
        if (by == 17) {
            return 1;
        }
        return by;
    }

    public String getAvailableCapacityForFreeNode() {
        return KernelConstants.getConvertedSize(this.m_capacityHelper.getFreeSpaceInBlocks(1), this.m_capacityHelper.getArrayHelper().getBlockSize());
    }

    public boolean isHotSpareAssignedForExistingArray() {
        return this.m_capacityHelper.getDedicatedSpares() != null && this.m_capacityHelper.getDedicatedSpares().length > 0;
    }

    public String getDriveSecurityForExistingArray() {
        String string = "No encryption";
        byte by = this.m_objLDParametersForArray.getEncryptionType();
        if (by == 1) {
            string = "Full disk encryption (FDE)";
        } else if (by == 2) {
            string = "Controller-based encryption";
        }
        return string;
    }

    public int getNumPDsInExistingArray() {
        return this.m_capacityHelper.getSLArrayInfo().getarray().getnumDrives();
    }

    private void init() {
        this.getFreeArrayReferences();
        this.getFreeLDTargetIDs();
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        this.m_iAdapterType = sASAdapter.getAdapterType();
        if (this.m_iAdapterType == 1) {
            try {
                this.m_objMFCDefaults = sASAdapter.getMFCDefaults();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_cStripeSize = this.m_iAdapterType == 1 ? (char)this.m_objMFCDefaults.getstripeSize() : sASAdapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmax();
    }

    private MR_ARRAY createMRArray(ArrayList<PhysicalDriveHelper> arrayList) {
        short s;
        byte by = (byte)this.m_objAdapterHelper.getAdapterInfo().getmaxArms();
        long l = ((SASPhysicalDrive)arrayList.get(0).getDeviceObject()).getInformation().getcoercedSize();
        pd_MR_ARRAY[] pd_MR_ARRAYArray = new pd_MR_ARRAY[by];
        short s2 = (short)arrayList.size();
        for (s = 0; s < s2; s = (short)(s + 1)) {
            pd_MR_ARRAYArray[s] = this.createPD_MR_ARRAY(arrayList.get(s));
        }
        if (s2 < by) {
            for (s = s2; s < by; s = (short)(s + 1)) {
                pd_MR_ARRAYArray[s] = new pd_MR_ARRAY();
            }
        }
        MR_ARRAY mR_ARRAY = new MR_ARRAY(this.m_freeArrayReferences.pop(), (char)s2, pd_MR_ARRAYArray, l);
        return mR_ARRAY;
    }

    private pd_MR_ARRAY createPD_MR_ARRAY(PhysicalDriveHelper physicalDriveHelper) {
        pd_MR_ARRAY pd_MR_ARRAY2 = new pd_MR_ARRAY((SASPhysicalDrive)physicalDriveHelper.getDeviceObject());
        pd_MR_ARRAY2.setfwState((short)24);
        return pd_MR_ARRAY2;
    }

    private MR_SPARE createMRSpare(MR_ARRAY[] mR_ARRAYArray, PhysicalDriveHelper physicalDriveHelper) {
        int n = Math.min(mR_ARRAYArray.length, 16);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = mR_ARRAYArray[i].getarrayRef();
        }
        SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
        MR_PD_REF mR_PD_REF = new MR_PD_REF(sASPhysicalDrive.getDeviceId(), sASPhysicalDrive.getSeqNum());
        MR_SPARE mR_SPARE = new MR_SPARE(mR_PD_REF);
        mR_SPARE.setarrayRef(sArray, (byte)n);
        spareType_MR_SPARE spareType_MR_SPARE2 = mR_SPARE.getspareType_MR_SPARE1();
        spareType_MR_SPARE2.setisDedicated('\u0001');
        mR_SPARE.setspareType_MR_SPARE1(spareType_MR_SPARE2);
        return mR_SPARE;
    }

    private MR_LD_CONFIG[] createMRLDConfigs(MR_ARRAY[] mR_ARRAYArray) {
        int n = 1;
        long l = 0L;
        long l2 = 0L;
        if (this.m_objSimpleConfigParams != null) {
            n = this.m_objSimpleConfigParams.getNumVirtualDrives();
            char c = mR_ARRAYArray[0].getnumDrives();
            long l3 = this.m_objSimpleConfigParams.getCapacity();
            float f = this.getSizeDistributionFactor(c);
            char c2 = this.getPRL();
            long l4 = 0L;
            long l5 = 0L;
            l4 = c2 != '\u0001' && c2 != '\u0011' ? l3 * (long)c / (long)((int)f) : (long)((float)(l3 * (long)c) / f);
            long l6 = l4;
            long l7 = (long)Math.pow(2.0, this.m_cStripeSize - '\u0001') * 2L;
            long l8 = l6 / (l7 * (long)c) * ((long)c * l7);
            long l9 = l8 / (long)c;
            if (c2 != '\u0001' && c2 != '\u0011') {
                l3 = l9 * (long)((int)f);
                l5 = l3 / (long)((int)f);
            } else {
                l3 = (long)((float)l9 * f);
                l5 = (long)((float)l3 / f);
            }
            l = l5;
        }
        if (this.m_isOldArray) {
            n = 1;
            freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2 = this.m_capacityHelper.getFreeInfoSLArrInfo();
            l2 = freeInfo_SL_ARRAY_INFO_T2.getstartBlock();
            l = freeInfo_SL_ARRAY_INFO_T2.getnumBlocks();
        }
        MR_LD_CONFIG[] mR_LD_CONFIGArray = new MR_LD_CONFIG[n];
        this.m_ldTargetId = new byte[n];
        for (int n2 = 0; n2 < n; n2 = (int)((byte)(n2 + 1))) {
            byte by;
            mR_LD_CONFIGArray[n2] = new MR_LD_CONFIG();
            if (this.m_iAdapterType != 2 && this.m_iAdapterType != 3 && this.m_iAdapterType != 4) {
                mR_LD_CONFIGArray[n2].setproperties(this.getLDProperties());
            }
            mR_LD_CONFIGArray[n2].setparams(this.getLDParameters());
            MR_SPAN mR_SPAN = mR_LD_CONFIGArray[n2].getspan()[0];
            mR_SPAN.setarrayRef(mR_ARRAYArray[n2].getarrayRef());
            mR_SPAN.setstartBlock(l2);
            mR_SPAN.setnumBlocks(l);
            this.m_ldTargetId[n2] = by = this.getLDTargetId();
            mR_LD_CONFIGArray[n2].getproperties().getldRef().settargetId((char)by);
        }
        return mR_LD_CONFIGArray;
    }

    private void getFreeArrayReferences() {
        this.m_freeArrayReferences = new Stack();
        ArrayHelper[] arrayHelperArray = this.m_objAdapterHelper.getArrays();
        byte by = (byte)this.m_objAdapterHelper.getAdapterInfo().getmaxArrays();
        if (arrayHelperArray != null && arrayHelperArray.length > 0) {
            for (byte by2 = (byte)(by - 1); by2 >= 0; by2 = (byte)(by2 - 1)) {
                boolean bl = false;
                for (int n = 0; n < arrayHelperArray.length; n = (int)((short)(n + 1))) {
                    SASArray sASArray = (SASArray)arrayHelperArray[n].getDeviceObject();
                    if (sASArray.getArrayRef() != by2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.m_freeArrayReferences.push(new Short(by2));
            }
        } else {
            for (byte by3 = (byte)(by - 1); by3 >= 0; by3 = (byte)(by3 - 1)) {
                this.m_freeArrayReferences.push(new Short(by3));
            }
        }
    }

    private void getFreeLDTargetIDs() {
        this.m_stLDTargetID = new Stack();
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_objAdapterHelper.getLogicalDrives();
        byte[] byArray = null;
        boolean bl = false;
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = null;
        try {
            mR_LD_TARGETID_LIST = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getUsedLds();
            byArray = mR_LD_TARGETID_LIST.getTargetId();
        }
        catch (Exception exception) {
            byArray = null;
        }
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0) {
            for (byte by = (byte)(this.m_objAdapterHelper.MAX_LOGICAL_DRIVES - 1); by >= 0; by = (byte)(by - 1)) {
                int n;
                if (byArray == null) {
                    for (n = 0; n < logicalDriveHelperArray.length; n = (int)((short)(n + 1))) {
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject();
                        if (sASLogicalDrive.getID() != by) continue;
                        bl = true;
                        break;
                    }
                } else {
                    for (n = 0; n < byArray.length; ++n) {
                        if (byArray[n] != by) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.m_stLDTargetID.push(new Byte(by));
                }
                bl = false;
            }
        } else {
            for (byte by = (byte)(this.m_objAdapterHelper.MAX_LOGICAL_DRIVES - 1); by >= 0; by = (byte)(by - 1)) {
                if (byArray != null) {
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] != by) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    this.m_stLDTargetID.push(new Byte(by));
                }
                bl = false;
            }
        }
    }

    private byte getLDTargetId() {
        return this.m_stLDTargetID.pop();
    }

    private MR_LD_PROPERTIES getLDProperties() {
        int n;
        if (this.m_isOldArray) {
            return this.m_objLDPropertiesForArray;
        }
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        MR_LD_PROPERTIES mR_LD_PROPERTIES = new MR_LD_PROPERTIES();
        boolean bl = false;
        try {
            sASAdapter.getBBUObject();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = false;
        SASAdapter sASAdapter2 = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        if (sASAdapter2.getInformation().gethwPresent_MR_CTRL_INFO().getmemory() != 0) {
            bl2 = true;
        }
        int n2 = 0;
        if (this.m_iAdapterType == 1 && (bl2 || this.m_objAdapterHelper.isSWRController())) {
            n = this.m_objMFCDefaults.getreadAhead();
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 4;
                    break;
                }
                case 2: {
                    n2 = 12;
                }
            }
        }
        n = 0;
        if (this.m_iAdapterType == 1 && (bl2 || this.m_objAdapterHelper.isSWRController())) {
            n = SASKernel.getOemType() == 2561 ? (this.getRAIDLevelForExistingArray() == 0 ? 1 : (this.m_objMFCDefaults.getwriteBack() == 0 ? 0 : (this.m_objMFCDefaults.getcacheWhenBBUBad() == 1 ? 17 : 1))) : (this.m_objMFCDefaults.getwriteBack() == 0 ? 0 : (this.m_objMFCDefaults.getcacheWhenBBUBad() == 1 ? 17 : 1));
        }
        int n3 = 0;
        if (this.m_iAdapterType == 1 && (bl2 || this.m_objAdapterHelper.isSWRController()) && this.m_objMFCDefaults.getcachedIo() == 1) {
            n3 = 96;
        }
        char c = this.m_iAdapterType == 2 || this.m_iAdapterType == 3 || this.m_iAdapterType == 4 ? (char)'\u0000' : (VivaldiStartupDialog.OEM_TYPE == 2561 ? (char)'\u0000' : '\u0002');
        byte by = (byte)(n2 | n | n3);
        mR_LD_PROPERTIES.setdefaultCachePolicy((char)by);
        mR_LD_PROPERTIES.setaccessPolicy('\u0000');
        mR_LD_PROPERTIES.setdiskCachePolicy(c);
        mR_LD_PROPERTIES.setdefaultPSPolicy((byte)0);
        return mR_LD_PROPERTIES;
    }

    private MR_LD_PARAMETERS getLDParameters() {
        if (this.m_isOldArray) {
            return this.m_objLDParametersForArray;
        }
        MR_LD_PARAMETERS mR_LD_PARAMETERS = new MR_LD_PARAMETERS();
        mR_LD_PARAMETERS.setPRL(this.getPRL());
        mR_LD_PARAMETERS.setRLQ(this.getRLQ());
        mR_LD_PARAMETERS.setSRL('\u0000');
        mR_LD_PARAMETERS.setstripeSize(this.m_cStripeSize);
        int n = this.m_objSimpleConfigParams.getPDListForDriveGroup().size() / this.m_objSimpleConfigParams.getNumVirtualDrives();
        mR_LD_PARAMETERS.setnumDrives((char)n);
        mR_LD_PARAMETERS.setspanDepth('\u0001');
        mR_LD_PARAMETERS.setstate('\u0003');
        mR_LD_PARAMETERS.setinitState('\u0001');
        mR_LD_PARAMETERS.setEncryptionType(this.m_objSimpleConfigParams.getDriveSecurityMethod());
        if (this.m_objSimpleConfigParams.isDataProtectionSelected()) {
            mR_LD_PARAMETERS.setPIType((byte)8);
        }
        return mR_LD_PARAMETERS;
    }

    private float getSizeDistributionFactor(int n) {
        float f = 0.0f;
        switch (this.m_objSimpleConfigParams.getRAIDLevel()) {
            case 0: {
                f = (byte)n;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                f = (float)n / 2.0f;
                break;
            }
            case 3: 
            case 4: {
                f = (byte)(n - 1);
                break;
            }
            case 5: 
            case 6: {
                f = (byte)(n - 2);
                break;
            }
        }
        return f;
    }

    private char getPRL() {
        int n = 0;
        switch (this.m_objSimpleConfigParams.getRAIDLevel()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                n = 1;
                int n2 = this.m_objSimpleConfigParams.getPDListForDriveGroup().size() / this.m_objSimpleConfigParams.getNumVirtualDrives();
                if (this.m_iAdapterType == 2 || n2 == 2) break;
                n = 17;
                break;
            }
            case 3: 
            case 4: {
                n = 5;
                break;
            }
            case 5: 
            case 6: {
                n = 6;
                break;
            }
        }
        return (char)n;
    }

    private char getRLQ() {
        int n = this.m_objSimpleConfigParams.getRAIDLevel();
        if (n == 0 || n == 1 || n == 2 || n == 7 || n == 8) {
            return '\u0000';
        }
        return '\u0003';
    }

    private void spinUpPowerSaveDrives() {
        ArrayList<SASPhysicalDrive> arrayList;
        if (this.m_objAdapterHelper.getAdapterInfo().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig() && (arrayList = this.getPDsInPowerSaveMode()).size() > 0) {
            new DrivesSpinUpProgressDialog((SASAdapter)this.m_objAdapterHelper.getDeviceObject(), arrayList);
        }
    }

    private ArrayList<SASPhysicalDrive> getPDsInPowerSaveMode() {
        SASPhysicalDrive sASPhysicalDrive;
        ArrayList<PhysicalDriveHelper> arrayList = this.m_objSimpleConfigParams.getPDListForDriveGroup();
        ArrayList<SASPhysicalDrive> arrayList2 = new ArrayList<SASPhysicalDrive>();
        for (int i = 0; i < arrayList.size(); ++i) {
            sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i).getDeviceObject();
            if (sASPhysicalDrive.getInformation().getPowerState() != 1 && sASPhysicalDrive.getInformation().getdisabledForRemoval() != '\u0001') continue;
            arrayList2.add(sASPhysicalDrive);
        }
        PhysicalDriveHelper physicalDriveHelper = this.m_objSimpleConfigParams.getHotSpare();
        if (physicalDriveHelper != null && ((sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getInformation().getPowerState() == 1 || sASPhysicalDrive.getInformation().getdisabledForRemoval() == '\u0001')) {
            arrayList2.add(sASPhysicalDrive);
        }
        return arrayList2;
    }

    private void setLDPropsAndParamsForArray(CapacityHelper capacityHelper) {
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        try {
            for (SASLogicalDrive sASLogicalDrive : sASAdapter.getSASObjectsArrayList((short)8192)) {
                MR_LD_INFO mR_LD_INFO = sASLogicalDrive.getInformation();
                MR_LD_CONFIG mR_LD_CONFIG = mR_LD_INFO.getldConfig();
                MR_SPAN[] mR_SPANArray = mR_LD_CONFIG.getspan();
                MR_LD_PARAMETERS mR_LD_PARAMETERS = mR_LD_CONFIG.getparams();
                short s = capacityHelper.getArrayRef();
                int n = mR_LD_PARAMETERS.getspanDepth();
                for (int i = 0; i < n; ++i) {
                    if (s != mR_SPANArray[i].getarrayRef()) continue;
                    this.m_objLDPropertiesForArray = mR_LD_CONFIG.getproperties();
                    byte[] byArray = new byte[16];
                    this.m_objLDPropertiesForArray.setname(byArray);
                    this.m_objLDParametersForArray = mR_LD_CONFIG.getparams();
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableSSDCaching() {
        int n;
        MR_LD_ALLOWED_OPS_LIST mR_LD_ALLOWED_OPS_LIST = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getLDAllowedOpsList();
        if (mR_LD_ALLOWED_OPS_LIST == null) {
            return;
        }
        int[] nArray = mR_LD_ALLOWED_OPS_LIST.getMrLDAllowedOps();
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        int n2 = this.m_ldTargetId.length;
        for (n = 0; n < n2; ++n) {
            if (KernelConstants.getBitValue(nArray[this.m_ldTargetId[n]], 14) == 0) continue;
            arrayList.add(this.m_ldTargetId[n]);
        }
        n = arrayList.size();
        if (n > 0) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (Byte)arrayList.get(i);
            }
            try {
                ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).setAssociatedLdIds(byArray);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                CustomMsgBox.errorMsg(vKOperationFailedException);
            }
        }
    }

    public void setCacheAndBootVDSize() {
        this.m_bootVolumeSize = this.m_objSimpleConfigParams.getBootVolumeSize();
        this.m_cacheVolumeSize = this.m_objSimpleConfigParams.getCapacity() - this.m_bootVolumeSize;
    }

    public long getCacheVolumeSize() {
        return this.m_cacheVolumeSize;
    }

    public long getBootVolumeSize() {
        return this.m_bootVolumeSize;
    }

    private MR_LD_CONFIG[] createMRLDConfigsForCSABootVolume(MR_ARRAY[] mR_ARRAYArray) {
        byte by;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        if (this.m_objSimpleConfigParams != null) {
            n = 2;
            char c = mR_ARRAYArray[0].getnumDrives();
            float f = this.getSizeDistributionFactor(c);
            long l5 = (long)((float)(this.m_objSimpleConfigParams.getCapacity() * (long)c) / f);
            long l6 = (long)((float)(this.m_cacheVolumeSize * (long)c) / f);
            long l7 = l5 - l6;
            long l8 = (long)Math.pow(2.0, this.m_cStripeSize - '\u0001') * 2L;
            long l9 = 2048L;
            long l10 = l6 / (l9 * (long)c) * ((long)c * l9);
            long l11 = l5 - l10;
            long l12 = l10 / (long)c;
            long l13 = l11 / (long)c;
            l = l12;
            l3 = l13;
            l4 = l;
        }
        MR_LD_CONFIG[] mR_LD_CONFIGArray = new MR_LD_CONFIG[n];
        this.m_ldTargetId = new byte[n];
        mR_LD_CONFIGArray[0] = new MR_LD_CONFIG();
        mR_LD_CONFIGArray[0].setproperties(this.getLDProperties());
        MR_LD_PARAMETERS mR_LD_PARAMETERS = this.getLDParameters();
        mR_LD_PARAMETERS.setisSSCd((byte)1);
        mR_LD_CONFIGArray[0].setparams(mR_LD_PARAMETERS);
        MR_SPAN mR_SPAN = mR_LD_CONFIGArray[0].getspan()[0];
        mR_SPAN.setarrayRef(mR_ARRAYArray[0].getarrayRef());
        mR_SPAN.setstartBlock(l2);
        mR_SPAN.setnumBlocks(l);
        this.m_ldTargetId[0] = by = this.getLDTargetId();
        mR_LD_CONFIGArray[0].getproperties().getldRef().settargetId((char)by);
        if (n > 1) {
            byte by2;
            mR_LD_CONFIGArray[1] = new MR_LD_CONFIG();
            mR_LD_CONFIGArray[1].setproperties(this.getLDProperties());
            MR_LD_PARAMETERS mR_LD_PARAMETERS2 = this.getLDParameters();
            mR_LD_PARAMETERS2.setisSSCd((byte)0);
            mR_LD_CONFIGArray[1].setparams(mR_LD_PARAMETERS2);
            MR_SPAN mR_SPAN2 = mR_LD_CONFIGArray[1].getspan()[0];
            mR_SPAN2.setarrayRef(mR_ARRAYArray[0].getarrayRef());
            mR_SPAN2.setstartBlock(l4);
            mR_SPAN2.setnumBlocks(l3);
            this.m_ldTargetId[1] = by2 = this.getLDTargetId();
            mR_LD_CONFIGArray[1].getproperties().getldRef().settargetId((char)by2);
        }
        return mR_LD_CONFIGArray;
    }
}

