/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.venus.configuration.simple.SimpleConfigConstants;
import GUIHelper.PhysicalDriveHelper;
import Services.KernelConstants;
import java.util.ArrayList;

public class SimpleConfigParams
extends SimpleConfigConstants {
    private boolean m_isDriveTypeMixingAllowed;
    private boolean m_isDriveTypeMixingSelected;
    private boolean m_isEnablePISelected;
    private int m_iRAIDLevel;
    private PhysicalDriveHelper m_objHotSpare;
    private byte m_iDriveSecurityMethod;
    private int m_iNumVirtualDrives;
    private long m_lCapacity;
    private ArrayList<PhysicalDriveHelper> m_objPDlistForDriveGroup;
    private long m_bootVolumeSize = 0L;

    public SimpleConfigParams(int n, PhysicalDriveHelper physicalDriveHelper, int n2, long l, ArrayList<PhysicalDriveHelper> arrayList) {
        this.m_iRAIDLevel = n;
        this.m_objHotSpare = physicalDriveHelper;
        this.m_iNumVirtualDrives = n2;
        this.m_lCapacity = l;
        this.m_objPDlistForDriveGroup = arrayList;
    }

    public SimpleConfigParams(int n, int n2, long l, ArrayList<PhysicalDriveHelper> arrayList, long l2) {
        this.m_iRAIDLevel = n;
        this.m_iNumVirtualDrives = n2;
        this.m_lCapacity = l;
        this.m_objPDlistForDriveGroup = arrayList;
        this.m_bootVolumeSize = l2;
    }

    public int getRAIDLevel() {
        return this.m_iRAIDLevel;
    }

    public PhysicalDriveHelper getHotSpare() {
        return this.m_objHotSpare;
    }

    public byte getDriveSecurityMethod() {
        return this.m_iDriveSecurityMethod;
    }

    public int getNumVirtualDrives() {
        return this.m_iNumVirtualDrives;
    }

    public long getCapacity() {
        return this.m_lCapacity;
    }

    public ArrayList<PhysicalDriveHelper> getPDListForDriveGroup() {
        return this.m_objPDlistForDriveGroup;
    }

    public short getBlockSize() {
        return this.m_objPDlistForDriveGroup.get(0).getInformation().getUserDataBlockSize();
    }

    public boolean isHotSpareAssigned() {
        return this.m_objHotSpare != null;
    }

    public void setDriveSecurityMethod(byte by) {
        this.m_iDriveSecurityMethod = by;
    }

    public String getDriveSecurityDescription() {
        String string = "No encryption";
        if (this.getDriveSecurityMethod() == 1) {
            string = "Full disk encryption (FDE)";
        } else if (this.getDriveSecurityMethod() == 2) {
            string = "Controller-based encryption";
        }
        return string;
    }

    public long getBootVolumeSize() {
        return this.m_bootVolumeSize;
    }

    public void setIsDriveMixingAllowed(boolean bl) {
        this.m_isDriveTypeMixingAllowed = bl;
    }

    public boolean isDriveMixingAllowed() {
        return this.m_isDriveTypeMixingAllowed;
    }

    public void setIsDriveMixingSelected(boolean bl) {
        this.m_isDriveTypeMixingSelected = bl;
    }

    public boolean isDriveMixingUsed() {
        return this.m_isDriveTypeMixingSelected;
    }

    public boolean isDataProtectionSelected() {
        return this.m_isEnablePISelected;
    }

    public void setIsEnablePISelected(boolean bl) {
        this.m_isEnablePISelected = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Simple Config Parameters : \n");
        stringBuffer.append("RAID level = ").append(this.getRAIDDescription(this.getRAIDLevel())).append("\n");
        if (this.m_objHotSpare != null) {
            stringBuffer.append("Hot Spare = ").append(this.getHotSpare().toString()).append("\n");
        }
        stringBuffer.append("Drive Security = ").append(this.getDriveSecurityDescription()).append("\n");
        stringBuffer.append("Number of vitrual drives = ").append(this.getNumVirtualDrives()).append("\n");
        stringBuffer.append("Capacity = ").append(KernelConstants.getConvertedSize(this.m_lCapacity, this.getPDListForDriveGroup().get(0).getUserDataBlockSize())).append("\n");
        stringBuffer.append("Constituent PDs").append("\n");
        for (int i = 0; i < this.m_objPDlistForDriveGroup.size(); ++i) {
            stringBuffer.append("\t").append(this.m_objPDlistForDriveGroup.get(i).toString()).append("\n");
        }
        if (this.m_bootVolumeSize != 0L) {
            stringBuffer.append("Cache Percentage = ").append(this.m_bootVolumeSize).append("\n");
        }
        return stringBuffer.toString().toUpperCase();
    }

    private String getRAIDDescription(int n) {
        String string = "";
        switch (this.m_iRAIDLevel) {
            case 0: {
                string = "RAID 0";
                break;
            }
            case 1: {
                string = "RAID 1";
                break;
            }
            case 7: {
                string = "RAID 1E";
                break;
            }
            case 8: {
                string = "RAID 10";
                break;
            }
            case 2: {
                string = "RAID 1 WITH HS";
                break;
            }
            case 3: {
                string = "RAID 5";
                break;
            }
            case 4: {
                string = "RAID 5 WITH HS";
                break;
            }
            case 5: {
                string = "RAID 6";
                break;
            }
            case 6: {
                string = "RAID 6 WITH HS";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }
}

