/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUIHelper.AdapterHelper;
import Services.KernelConstants;
import Utils.Resource;

public class SimpleConfigSummaryGenerator {
    private static final String TABS_1 = "\t";
    private static final String TABS_2 = "\t\t";
    private static final String TABS_3 = "\t\t\t";
    private static final String TABS_4 = "\t\t\t\t";
    private static final String NEW_LINE = "\n";
    private SimpleConfigParams m_simpleConfigParams = null;
    private SimpleConfigEngine m_objSimpleConfigEngine = null;
    private AdapterHelper m_AdapterHelper = null;

    public SimpleConfigSummaryGenerator(SimpleConfigParams simpleConfigParams, AdapterHelper adapterHelper) {
        this.m_simpleConfigParams = simpleConfigParams;
        this.m_AdapterHelper = adapterHelper;
    }

    public SimpleConfigSummaryGenerator(SimpleConfigEngine simpleConfigEngine, AdapterHelper adapterHelper) {
        this.m_objSimpleConfigEngine = simpleConfigEngine;
        this.m_AdapterHelper = adapterHelper;
    }

    public String getSummaryForNewDriveGroup() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_simpleConfigParams.isDriveMixingAllowed()) {
            stringBuffer.append(Resource.getString("PROPERTY_DRIVE_TYPE_TEXT", "Drive type") + "mixing:");
            stringBuffer.append(TABS_3);
            stringBuffer.append(this.m_simpleConfigParams.isDriveMixingUsed() ? "Yes" : "No");
            stringBuffer.append(NEW_LINE);
        }
        if (this.m_AdapterHelper.isPIEnabledOnController() && this.m_AdapterHelper.isPISupported()) {
            stringBuffer.append(Resource.getString("DATA_PROTECTION_TEXT", "Data Protection:"));
            if (!VivaldiStartupDialog.isSolaris) {
                stringBuffer.append(TABS_3);
            } else if (this.m_AdapterHelper.isSolaris11()) {
                stringBuffer.append(TABS_3);
            } else {
                stringBuffer.append(TABS_4);
            }
            stringBuffer.append(this.m_simpleConfigParams.isDataProtectionSelected() ? Resource.getString("ENABLED", "Enabled") : Resource.getString("DISABLED", "Disabled"));
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID Level:"));
        stringBuffer.append(TABS_4);
        int n = this.m_simpleConfigParams.getRAIDLevel();
        String string = "0";
        if (n == 2 || n == 1) {
            string = "1";
        } else if (n == 4 || n == 3) {
            string = "5";
        } else if (n == 6 || n == 5) {
            string = "6";
        } else if (n == 7) {
            string = "1E";
        } else if (n == 8) {
            string = "10";
        }
        stringBuffer.append("RAID ");
        stringBuffer.append(string);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("NO_OF_VDRIVES", "Number of " + Resource.getString("VIRTUAL_DRIVES_TEXT", "virtual drives") + " : "));
        if (VivaldiStartupDialog.isWindows) {
            stringBuffer.append(TABS_2);
        } else {
            stringBuffer.append(TABS_3);
        }
        stringBuffer.append(this.m_simpleConfigParams.getNumVirtualDrives());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("CAPACITY_OF_EACH_VD", Resource.getString("CAPACITY_TEXT", "Capacity") + " of each " + Resource.getString("VIRTUAL_DRIVE_TEXT", "virtual drive") + " : "));
        if (VivaldiStartupDialog.isWindows) {
            stringBuffer.append(TABS_2);
        } else if (this.m_AdapterHelper.isSolaris11()) {
            stringBuffer.append(TABS_2);
        } else {
            stringBuffer.append(TABS_3);
        }
        stringBuffer.append(KernelConstants.getConvertedSize(this.m_simpleConfigParams.getCapacity(), this.m_simpleConfigParams.getPDListForDriveGroup().get(0).getUserDataBlockSize()));
        stringBuffer.append(NEW_LINE);
        if (!this.m_AdapterHelper.isSWRController() && this.m_simpleConfigParams.getRAIDLevel() != 0) {
            stringBuffer.append(Resource.getString("PD_STATE_HOTSPARE", "Hot spare") + " : ");
            stringBuffer.append(TABS_4);
            stringBuffer.append(this.m_simpleConfigParams.getHotSpare() != null ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_No_TEXT", "No"));
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_DRIVE_SECURITY_METHOD", "Drive security:"));
        stringBuffer.append(TABS_3);
        stringBuffer.append(this.m_simpleConfigParams.getDriveSecurityDescription());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("SUMMARY_NO_OF_DRIVES_USED", "Number of drives used:"));
        stringBuffer.append(TABS_3);
        stringBuffer.append(this.m_simpleConfigParams.getPDListForDriveGroup().size());
        stringBuffer.append(NEW_LINE);
        return stringBuffer.toString();
    }

    public String getSummaryForExistingDriveGroup() {
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID Level") + " : ");
        stringBuffer.append(TABS_4);
        stringBuffer.append("RAID ");
        stringBuffer.append(this.m_objSimpleConfigEngine.getRAIDLevelForExistingArray());
        stringBuffer.append(NEW_LINE);
        String string = System.getProperty("os.name");
        stringBuffer.append(Resource.getString("NO_OF_VDRIVES", "Number of " + Resource.getString("VIRTUAL_DRIVES_TEXT", "virtual drives") + " : "));
        if (string.contains("Windows")) {
            stringBuffer.append(TABS_2);
        } else {
            stringBuffer.append(TABS_3);
        }
        stringBuffer.append(n);
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("CAPACITY_OF_EACH_VD", Resource.getString("CAPACITY_TEXT", "Capacity") + " of each " + Resource.getString("VIRTUAL_DRIVE_TEXT", "virtual drive") + " : "));
        if (string.contains("Windows")) {
            stringBuffer.append(TABS_2);
        } else {
            stringBuffer.append(TABS_3);
        }
        stringBuffer.append(this.m_objSimpleConfigEngine.getAvailableCapacityForFreeNode());
        stringBuffer.append(NEW_LINE);
        if (!this.m_AdapterHelper.isSWRController() && this.m_objSimpleConfigEngine.getRAIDLevelForExistingArray() != 0) {
            stringBuffer.append(Resource.getString("PD_STATE_HOTSPARE", "Hot spare") + " : ");
            stringBuffer.append(TABS_4);
            stringBuffer.append(this.m_objSimpleConfigEngine.isHotSpareAssignedForExistingArray() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_No_TEXT", "No"));
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(Resource.getString("SUMMARY_TEXT_DRIVE_SECURITY_METHOD", "Drive security method:"));
        stringBuffer.append(TABS_3);
        stringBuffer.append(this.m_objSimpleConfigEngine.getDriveSecurityForExistingArray());
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("SUMMARY_NO_OF_DRIVES_USED", "Number of drives used"));
        stringBuffer.append(TABS_3);
        stringBuffer.append(this.m_objSimpleConfigEngine.getNumPDsInExistingArray());
        stringBuffer.append(NEW_LINE);
        return stringBuffer.toString();
    }
}

