/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.simple.PDGroup;
import GUI.venus.configuration.simple.PDSubgroup;
import GUI.venus.configuration.simple.PDsAndHotspareForDG;
import GUI.venus.configuration.simple.PhysicalDriveGroupsCreator;
import GUI.venus.configuration.simple.PhysicalDriveSubGroups;
import GUI.venus.configuration.simple.PossibleConfigurationsForSubGroup;
import GUI.venus.configuration.simple.SGAndRAIDLevel;
import GUI.venus.configuration.simple.SGRAIDLevelAndNumVD;
import GUI.venus.configuration.simple.SGRAIDLevelNumVDAndCapacity;
import GUI.venus.configuration.simple.SimpleConfigConstants;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.raidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class VirtualDriveSettingsData
extends SimpleConfigConstants {
    private AdapterHelper m_objAdapterHelper = null;
    private int m_iAdapterType;
    private PossibleConfigurationsForSubGroup m_objPossibleConfigsForSubgroup = null;
    private int m_iSubGroupID = 0;
    private int m_iSubGroupWithWastageID = 0;
    private ArrayList<PDGroup> m_objPDGroups = new ArrayList();
    private PDSubgroup m_objSubgroup;
    private ArrayList<ArrayList<PhysicalDriveHelper>> m_objSubGroups = new ArrayList();
    private ArrayList<ArrayList<PhysicalDriveHelper>> m_objSubGroupsWithWastage = new ArrayList();
    private HashMap<PDSubgroup, Vector<Integer>> m_objSubGroupsToRAIDLevelsMap = new HashMap();
    private Vector<Integer> m_objRAIDLevels = new Vector();
    private Vector<Integer> m_objRAIDLevelsWithMixingAndWithoutPI = new Vector();
    private Vector<Integer> m_objRAIDLevelsWithMixingAndWithPI = new Vector();
    private Vector<Integer> m_objRAIDLevelsWithoutMixingAndWithoutPI = new Vector();
    private Vector<Integer> m_objRAIDLevelsWithoutMixingAndWithPI = new Vector();
    private Vector<Integer> m_objRAIDLevelsWithWastage = new Vector();
    private HashMap<SGAndRAIDLevel, Vector<Integer>> m_objSGRAIDLevelToNumVDsMap = new HashMap();
    private HashMap<SGRAIDLevelAndNumVD, Vector<Long>> m_objSGRAIDAndNumVDsToCapacitiesMap = new HashMap();
    private HashMap<SGRAIDLevelNumVDAndCapacity, PDsAndHotspareForDG> m_objSGRAIDParamsToPDsMap = new HashMap();
    private HashMap<Integer, Integer> m_objSGWithWastageToRAIDLevelMap = new HashMap();
    private HashMap<PDSubgroup, PDsAndHotspareForDG> m_objSubGroupToPDsListMap = new HashMap();
    private PDsAndHotspareForDG m_objCandidatePDsAndHotSpare;
    private pdsForRaidLevels_MR_CTRL_INFO m_pdsForRaidLevels = null;
    int m_iRAIDLevel;
    int m_iNumVirtualDrives;
    long m_lCapacity;
    boolean m_isSecuritySelected;
    boolean m_isDriveTypeMixingAllowed;
    boolean m_isDriveTypeMixingSelected;
    boolean m_isEnablePISelected;

    public VirtualDriveSettingsData(AdapterHelper adapterHelper) {
        this.m_objAdapterHelper = adapterHelper;
        this.m_iAdapterType = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getAdapterType();
        this.m_pdsForRaidLevels = this.m_objAdapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        this.findPossibleConfigs();
    }

    public Vector<Integer> getSupportedRAIDLevels() {
        boolean bl;
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        if (this.m_isDriveTypeMixingSelected && !this.m_isEnablePISelected) {
            this.m_objRAIDLevels = this.m_objRAIDLevelsWithMixingAndWithoutPI;
        } else if (this.m_isDriveTypeMixingSelected && this.m_isEnablePISelected) {
            this.m_objRAIDLevels = this.m_objRAIDLevelsWithMixingAndWithPI;
        } else if (!this.m_isDriveTypeMixingSelected && !this.m_isEnablePISelected) {
            this.m_objRAIDLevels = this.m_objRAIDLevelsWithoutMixingAndWithoutPI;
        } else if (!this.m_isDriveTypeMixingSelected && this.m_isEnablePISelected) {
            this.m_objRAIDLevels = this.m_objRAIDLevelsWithMixingAndWithPI;
        }
        Vector<Integer> vector = new Vector<Integer>();
        raidLevels_MR_CTRL_INFO raidLevels_MR_CTRL_INFO2 = this.m_objAdapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO();
        boolean bl2 = bl = this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getdedicatedHotSpares() != 0;
        if (this.m_objRAIDLevels.contains(0) && raidLevels_MR_CTRL_INFO2.getraidLevel_0() != 0) {
            vector.add(0);
        }
        if (this.m_objRAIDLevels.contains(1) && raidLevels_MR_CTRL_INFO2.getraidLevel_1() != 0) {
            vector.add(1);
        }
        if (this.m_objRAIDLevels.contains(2) && raidLevels_MR_CTRL_INFO2.getraidLevel_1() != 0 && bl) {
            vector.add(2);
        }
        if (this.m_objRAIDLevels.contains(3) && raidLevels_MR_CTRL_INFO2.getraidLevel_5() != 0) {
            vector.add(3);
        }
        if (this.m_objRAIDLevels.contains(4) && raidLevels_MR_CTRL_INFO2.getraidLevel_5() != 0 && bl) {
            vector.add(4);
        }
        if (this.m_objRAIDLevels.contains(5) && raidLevels_MR_CTRL_INFO2.getraidLevel_6() != 0) {
            vector.add(5);
        }
        if (this.m_objRAIDLevels.contains(6) && raidLevels_MR_CTRL_INFO2.getraidLevel_6() != 0 && bl) {
            vector.add(6);
        }
        if (sASAdapter.getAdapterType() == 2) {
            if (this.m_objRAIDLevels.contains(7) && raidLevels_MR_CTRL_INFO2.getraidLevel_1E() != 0) {
                vector.add(7);
            }
        } else if (this.m_objRAIDLevels.contains(7) && raidLevels_MR_CTRL_INFO2.getRaidLevel_1E_RLQ0() != 0) {
            vector.add(7);
        }
        if (this.m_objRAIDLevels.contains(8)) {
            vector.add(8);
        }
        return vector;
    }

    public Vector<Integer> getRAIDLevelsWithWastage() {
        return (Vector)this.m_objRAIDLevelsWithWastage.clone();
    }

    public Vector<Integer> getNumVDsForRAIDLevel(int n) {
        int n2;
        int n3;
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.m_objPDGroups.size(); ++i) {
            PDGroup pDGroup = this.m_objPDGroups.get(i);
            ArrayList<PhysicalDriveHelper> arrayList = pDGroup.getPDListForGroup();
            if (arrayList == null || arrayList.size() == 0) continue;
            n3 = pDGroup.getGroupID();
            n2 = pDGroup.getNumSubGroups();
            for (int j = 0; j < n2; ++j) {
                int n4 = j + 1;
                for (SGAndRAIDLevel sGAndRAIDLevel : this.m_objSGRAIDLevelToNumVDsMap.keySet()) {
                    PDSubgroup pDSubgroup = sGAndRAIDLevel.getSubgroup();
                    if (pDSubgroup.getGroupID() != n3 || pDSubgroup.isDriveMixingUsedInGroup() != this.m_isDriveTypeMixingSelected || pDSubgroup.containsOnlyPIDrives() != this.m_isEnablePISelected || pDSubgroup.getSubgroupID() != n4 || sGAndRAIDLevel.getRAIDLevel() != n) continue;
                    Vector<Integer> vector2 = this.m_objSGRAIDLevelToNumVDsMap.get(sGAndRAIDLevel);
                    for (int k = 0; k < vector2.size(); ++k) {
                        int n5 = vector2.get(k);
                        if (vector.contains(n5)) continue;
                        vector.add(n5);
                    }
                }
            }
        }
        Vector vector3 = new Vector();
        char c = this.m_objAdapterHelper.getAdapterInfo().getmaxArrays();
        int n6 = this.m_objAdapterHelper.getArrays().length;
        n3 = c - n6;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            if ((Integer)vector.get(n2) > n3) continue;
            vector3.add(vector.get(n2));
        }
        return (Vector)vector3.clone();
    }

    public void createPDsAndHotSpareList(int n, int n2, long l, boolean bl, boolean bl2) {
        this.m_objSubGroupToPDsListMap.clear();
        for (int i = 0; i < this.m_objPDGroups.size(); ++i) {
            PDGroup pDGroup = this.m_objPDGroups.get(i);
            ArrayList<PhysicalDriveHelper> arrayList = pDGroup.getPDListForGroup();
            if (arrayList == null || arrayList.size() == 0) continue;
            int n3 = pDGroup.getGroupID();
            int n4 = pDGroup.getNumSubGroups();
            for (int j = 0; j < n4; ++j) {
                int n5 = j + 1;
                for (SGRAIDLevelNumVDAndCapacity sGRAIDLevelNumVDAndCapacity : this.m_objSGRAIDParamsToPDsMap.keySet()) {
                    PDSubgroup pDSubgroup = sGRAIDLevelNumVDAndCapacity.getSubgroup();
                    if (pDSubgroup.getGroupID() != n3 || pDSubgroup.isDriveMixingUsedInGroup() != bl || pDSubgroup.containsOnlyPIDrives() != bl2 || pDSubgroup.getSubgroupID() != n5 || sGRAIDLevelNumVDAndCapacity.getRAIDLevel() != n || sGRAIDLevelNumVDAndCapacity.getNumVirtualDrives() != n2 || sGRAIDLevelNumVDAndCapacity.getCapacity() != l) continue;
                    PDsAndHotspareForDG pDsAndHotspareForDG = this.m_objSGRAIDParamsToPDsMap.get(sGRAIDLevelNumVDAndCapacity);
                    this.m_objSubGroupToPDsListMap.put(pDSubgroup, pDsAndHotspareForDG);
                }
            }
        }
    }

    public SimpleConfigParams getSimpleConfigParams() {
        Object object;
        ArrayList<PDsAndHotspareForDG> arrayList = new ArrayList<PDsAndHotspareForDG>();
        this.createPDsAndHotSpareList(this.m_iRAIDLevel, this.m_iNumVirtualDrives, this.m_lCapacity, this.m_isDriveTypeMixingSelected, this.m_isEnablePISelected);
        PDSubgroup object2 = null;
        for (PDSubgroup object3 : this.m_objSubGroupToPDsListMap.keySet()) {
            if (object2 == null) {
                object2 = object3;
                continue;
            }
            if (object3.getGroupID() <= object2.getGroupID()) continue;
            object2 = object3;
        }
        for (PDSubgroup i : this.m_objSubGroupToPDsListMap.keySet()) {
            if (object2 == null || i.getGroupID() != object2.getGroupID()) continue;
            object = this.m_objSubGroupToPDsListMap.get(i);
            arrayList.add((PDsAndHotspareForDG)object);
        }
        this.m_objCandidatePDsAndHotSpare = (PDsAndHotspareForDG)arrayList.get(0);
        for (int arrayList2 = 1; arrayList2 < arrayList.size(); ++arrayList2) {
            object = (PDsAndHotspareForDG)arrayList.get(arrayList2);
            if (((PDsAndHotspareForDG)object).getPDListForDriveGroup().size() >= this.m_objCandidatePDsAndHotSpare.getPDListForDriveGroup().size()) continue;
            this.m_objCandidatePDsAndHotSpare = object;
        }
        ArrayList<PhysicalDriveHelper> arrayList2 = this.m_objCandidatePDsAndHotSpare.getPDListForDriveGroup();
        object = this.m_objCandidatePDsAndHotSpare.getHotspare();
        byte by = this.getDriveSecurityMethod(arrayList2, (PhysicalDriveHelper)object);
        SimpleConfigParams simpleConfigParams = new SimpleConfigParams(this.getSelectedRAIDlevel(), this.m_objCandidatePDsAndHotSpare.getHotspare(), this.getSelectedNumVDs(), this.getSelectedCapacity(), arrayList2);
        simpleConfigParams.setDriveSecurityMethod(by);
        simpleConfigParams.setIsDriveMixingAllowed(this.m_isDriveTypeMixingAllowed);
        simpleConfigParams.setIsDriveMixingSelected(this.m_isDriveTypeMixingSelected);
        simpleConfigParams.setIsEnablePISelected(this.m_isEnablePISelected);
        return simpleConfigParams;
    }

    public void setDriveTypeMixingAllowed(boolean bl) {
        this.m_isDriveTypeMixingAllowed = bl;
    }

    public void setDriveTypeMixingSelected(boolean bl) {
        this.m_isDriveTypeMixingSelected = bl;
    }

    public void setEnablePISelected(boolean bl) {
        this.m_isEnablePISelected = bl;
    }

    public void setSelectedRAIDLevel(int n) {
        this.m_iRAIDLevel = n;
    }

    public void setSelectedNumVDs(int n) {
        this.m_iNumVirtualDrives = n;
    }

    public void setSelectedCapacity(long l) {
        this.m_lCapacity = l;
    }

    public void setSecurity(boolean bl) {
        this.m_isSecuritySelected = bl;
    }

    public int getSelectedRAIDlevel() {
        return this.m_iRAIDLevel;
    }

    public int getSelectedNumVDs() {
        return this.m_iNumVirtualDrives;
    }

    public long getSelectedCapacity() {
        return this.m_lCapacity;
    }

    public byte getDriveSecurityMethod(ArrayList<PhysicalDriveHelper> arrayList, PhysicalDriveHelper physicalDriveHelper) {
        int n = 0;
        if (this.m_isSecuritySelected) {
            MR_CTRL_INFO mR_CTRL_INFO = this.m_objAdapterHelper.getAdapterInfo();
            if (this.m_objAdapterHelper.isSecuritySupported()) {
                if (this.m_objAdapterHelper.isOnlyFDESupported()) {
                    if (this.getFDEPdCount() > 0 && this.isFDEOnlyDriveGroup(arrayList, physicalDriveHelper)) {
                        n = 1;
                    }
                } else if (this.m_objAdapterHelper.isLockKeyAssigned()) {
                    n = this.isFDEOnlyDriveGroup(arrayList, physicalDriveHelper) ? 1 : 2;
                }
            }
        }
        return (byte)n;
    }

    public int getFDEPdCount() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_objAdapterHelper.getUnconfiguredPhysicalDrives();
        int n = 0;
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (!physicalDriveHelperArray[i].isFDECapable() || physicalDriveHelperArray[i].isForeign()) continue;
            ++n;
        }
        return n;
    }

    private void findPossibleConfigs() {
        PhysicalDriveGroupsCreator physicalDriveGroupsCreator = new PhysicalDriveGroupsCreator(this.m_objAdapterHelper);
        this.m_objPDGroups.addAll(physicalDriveGroupsCreator.getPossiblePDGroups(false, false));
        this.m_objPDGroups.addAll(physicalDriveGroupsCreator.getPossiblePDGroups(true, false));
        if (this.m_objAdapterHelper.isPIEnabledOnController() && this.m_objAdapterHelper.isPISupported() && this.m_objAdapterHelper.containsPIDrives()) {
            this.m_objPDGroups.addAll(physicalDriveGroupsCreator.getPossiblePDGroups(false, true));
            this.m_objPDGroups.addAll(physicalDriveGroupsCreator.getPossiblePDGroups(true, true));
        }
        for (int i = 0; i < this.m_objPDGroups.size(); ++i) {
            PDGroup pDGroup = this.m_objPDGroups.get(i);
            ArrayList<PhysicalDriveHelper> arrayList = pDGroup.getPDListForGroup();
            int n = pDGroup.getGroupID();
            boolean bl = pDGroup.isDriveMixingUsed();
            boolean bl2 = pDGroup.containsOnlyPIDrives();
            if (arrayList == null || arrayList.size() == 0) continue;
            this.m_objSubGroups.clear();
            this.m_objSubGroupsWithWastage.clear();
            this.m_objSubGroups = new PhysicalDriveSubGroups(arrayList).getSubGropus();
            this.m_objSubGroupsWithWastage = this.createSubGroupsWithWastage(this.m_objSubGroups, arrayList.size());
            this.m_objSubGroups.addAll(this.m_objSubGroupsWithWastage);
            int n2 = this.m_objSubGroups.size();
            pDGroup.setNumSubGroups(n2);
            for (int j = 0; j < this.m_objSubGroups.size(); ++j) {
                this.m_iSubGroupID = j + 1;
                ArrayList<PhysicalDriveHelper> arrayList2 = this.m_objSubGroups.get(j);
                try {
                    int n3 = this.m_objSGWithWastageToRAIDLevelMap.get(this.m_iSubGroupID);
                    Vector<Integer> vector = new Vector<Integer>();
                    vector.add(n3);
                    this.sortPDsAscending(arrayList2);
                    this.m_objPossibleConfigsForSubgroup = new PossibleConfigurationsForSubGroup(arrayList2, n3);
                    this.m_objSubGroupsToRAIDLevelsMap.put(new PDSubgroup(n, bl, bl2, this.m_iSubGroupID), vector);
                }
                catch (NullPointerException nullPointerException) {
                    this.m_objPossibleConfigsForSubgroup = new PossibleConfigurationsForSubGroup(arrayList2);
                    this.m_objSubGroupsToRAIDLevelsMap.put(new PDSubgroup(n, bl, bl2, this.m_iSubGroupID), this.m_objPossibleConfigsForSubgroup.getSupportedRAIDLevels(arrayList2.size()));
                }
                this.fillVDSettingsHashMaps(pDGroup);
            }
        }
    }

    private void fillVDSettingsHashMaps(PDGroup pDGroup) {
        Vector<Object> vector = new Vector();
        for (PDSubgroup pDSubgroup : this.m_objSubGroupsToRAIDLevelsMap.keySet()) {
            if (pDSubgroup.getGroupID() == pDGroup.getGroupID() && pDSubgroup.isDriveMixingUsedInGroup() == pDGroup.isDriveMixingUsed() && pDSubgroup.containsOnlyPIDrives() == pDGroup.containsOnlyPIDrives() && pDSubgroup.getSubgroupID() == this.m_iSubGroupID) {
                this.m_objSubgroup = pDSubgroup;
                vector = this.m_objSubGroupsToRAIDLevelsMap.get(pDSubgroup);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Vector<Integer> vector2;
                int n = (Integer)vector.get(i);
                if (pDGroup.isDriveMixingUsed() & !pDGroup.containsOnlyPIDrives()) {
                    if (!this.m_objRAIDLevelsWithMixingAndWithoutPI.contains(n)) {
                        this.m_objRAIDLevelsWithMixingAndWithoutPI.add(n);
                    }
                } else if (pDGroup.isDriveMixingUsed() & pDGroup.containsOnlyPIDrives()) {
                    if (!this.m_objRAIDLevelsWithMixingAndWithPI.contains(n)) {
                        this.m_objRAIDLevelsWithMixingAndWithPI.add(n);
                    }
                } else if (!pDGroup.isDriveMixingUsed() & !pDGroup.containsOnlyPIDrives()) {
                    if (!this.m_objRAIDLevelsWithoutMixingAndWithoutPI.contains(n)) {
                        this.m_objRAIDLevelsWithoutMixingAndWithoutPI.add(n);
                    }
                } else if (!pDGroup.isDriveMixingUsed() & pDGroup.containsOnlyPIDrives() && !this.m_objRAIDLevelsWithoutMixingAndWithPI.contains(n)) {
                    this.m_objRAIDLevelsWithoutMixingAndWithPI.add(n);
                }
                if ((vector2 = this.m_objPossibleConfigsForSubgroup.getNumVDsForRAIDLevelForSG(n)) == null) continue;
                this.m_objSGRAIDLevelToNumVDsMap.put(new SGAndRAIDLevel(this.m_objSubgroup, n), vector2);
                for (int j = 0; j < vector2.size(); ++j) {
                    int n2 = vector2.get(j);
                    Vector<Long> vector3 = this.m_objPossibleConfigsForSubgroup.getCapacitiesForRAIDAndNumVDsForSG(n, n2);
                    if (vector3 == null) continue;
                    this.m_objSGRAIDAndNumVDsToCapacitiesMap.put(new SGRAIDLevelAndNumVD(this.m_objSubgroup, n, n2), vector3);
                    for (int k = 0; k < vector3.size(); ++k) {
                        long l = vector3.get(k);
                        PDsAndHotspareForDG pDsAndHotspareForDG = this.m_objPossibleConfigsForSubgroup.getPDsAndHotSpareForRAIDParams(n, n2, l);
                        this.m_objSGRAIDParamsToPDsMap.put(new SGRAIDLevelNumVDAndCapacity(this.m_objSubgroup, n, n2, l), pDsAndHotspareForDG);
                    }
                }
            }
        }
    }

    private boolean isFDEOnlyDriveGroup(ArrayList<PhysicalDriveHelper> arrayList, PhysicalDriveHelper physicalDriveHelper) {
        boolean bl = true;
        if (physicalDriveHelper != null && !physicalDriveHelper.isFDECapable()) {
            bl = false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i).getDeviceObject();
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void sortCapacitiesAscending(Vector<Long> vector) {
        int n = vector.size();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                if (vector.get(j) <= vector.get(j + 1)) continue;
                Collections.swap(vector, j, j + 1);
            }
        }
    }

    private ArrayList<ArrayList<PhysicalDriveHelper>> createSubGroupsWithWastage(ArrayList<ArrayList<PhysicalDriveHelper>> arrayList, int n) {
        int n2;
        int n3 = arrayList.size();
        Vector<Integer> vector = this.getSupportedRAIDLevels(n);
        ArrayList<ArrayList<PhysicalDriveHelper>> arrayList2 = new ArrayList<ArrayList<PhysicalDriveHelper>>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < n3; ++n2) {
            ArrayList<PhysicalDriveHelper> arrayList3 = arrayList.get(n2);
            Vector<Integer> vector3 = this.getSupportedRAIDLevels(arrayList3.size());
            for (int i = 0; i < vector3.size(); ++i) {
                if (vector2.contains(vector3.get(i))) continue;
                vector2.add(vector3.get(i));
            }
        }
        vector.removeAll(vector2);
        this.m_objRAIDLevelsWithWastage = vector;
        this.m_objSGWithWastageToRAIDLevelMap.clear();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            int n4 = vector.get(n2);
            int n5 = this.getMinDrivesForRAIDLevel(n4);
            ArrayList<PhysicalDriveHelper> arrayList4 = new ArrayList<PhysicalDriveHelper>();
            for (int i = this.m_objSubGroups.size() - 1; i >= 0; --i) {
                ArrayList<PhysicalDriveHelper> arrayList5 = this.m_objSubGroups.get(i);
                if (arrayList4.size() >= n5) continue;
                arrayList4.addAll(arrayList5);
            }
            this.m_iSubGroupWithWastageID = this.m_objSubGroups.size() + n2 + 1;
            arrayList2.add(arrayList4);
            this.m_objSGWithWastageToRAIDLevelMap.put(this.m_iSubGroupWithWastageID, n4);
        }
        return arrayList2;
    }

    private Vector<Integer> getSupportedRAIDLevels(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        if (sASAdapter.getAdapterType() == 1) {
            vector.add(0);
            if (n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_1()) {
                vector.add(1);
            }
            if (n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_1() + 1) {
                vector.add(2);
            }
            if (n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_5()) {
                vector.add(3);
            }
            if (n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_5() + 1) {
                vector.add(4);
            }
            if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                if (n >= 4) {
                    vector.add(5);
                }
                if (n >= 5) {
                    vector.add(6);
                }
            } else {
                if (n >= this.m_pdsForRaidLevels.getMinPdRaidLevel_6()) {
                    vector.add(5);
                }
                if (n >= this.m_pdsForRaidLevels.getMinPdRaidLevel_6() + 1) {
                    vector.add(6);
                }
            }
        } else {
            if (n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_0()) {
                vector.add(0);
            }
            if (n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_1()) {
                vector.add(1);
            }
            if (this.m_objAdapterHelper.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getRaidLevel_1E_RLQ0() != 0 && n >= this.m_pdsForRaidLevels.getMinPdRAIDLevel_1E()) {
                vector.add(7);
            }
            if ((sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) && n > this.m_pdsForRaidLevels.getMinPdRAIDLevel_1E() && this.m_objAdapterHelper.treatRAID1EasRAID10()) {
                vector.add(8);
            }
        }
        return vector;
    }

    private int getMinDrivesForRAIDLevel(int n) {
        int n2;
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        switch (n) {
            case 0: {
                n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_0();
                break;
            }
            case 1: {
                n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_1();
                break;
            }
            case 2: {
                n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_1() + 1;
                break;
            }
            case 3: {
                n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_5();
                break;
            }
            case 5: {
                if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                    n2 = 4;
                    break;
                }
                n2 = this.m_pdsForRaidLevels.getMinPdRaidLevel_6();
                break;
            }
            case 7: 
            case 8: {
                if (sASAdapter.getAdapterType() == 2) {
                    n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_1E();
                    break;
                }
                if (this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                    n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_1E();
                    break;
                }
                n2 = 4;
                break;
            }
            case 4: {
                n2 = this.m_pdsForRaidLevels.getMinPdRAIDLevel_5() + 1;
                break;
            }
            case 6: {
                if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                    n2 = 5;
                    break;
                }
                n2 = this.m_pdsForRaidLevels.getMinPdRaidLevel_6() + 1;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    private void sortPDsAscending(ArrayList<PhysicalDriveHelper> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                if (arrayList.get(j).getSize() <= arrayList.get(j + 1).getSize()) continue;
                Collections.swap(arrayList, j, j + 1);
            }
        }
    }

    class CapacitiesForRaidLevelAndNumVDs {
        private Vector<String> capacitiesInUnits = new Vector();
        private Vector<Long> capacitiesInBlocks = new Vector();

        CapacitiesForRaidLevelAndNumVDs(int n, int n2) {
            this.setCapacitiesForRAIDLevelAndNumVDs(n, n2);
        }

        public Vector<String> getCapacitiesInUnits() {
            return this.capacitiesInUnits;
        }

        public Vector<Long> getCapacitiesInBlocks() {
            return this.capacitiesInBlocks;
        }

        public void setCapacitiesForRAIDLevelAndNumVDs(int n, int n2) {
            int n3;
            Vector<Long> vector = new Vector<Long>();
            HashMap<Long, Short> hashMap = new HashMap<Long, Short>();
            for (n3 = 0; n3 < VirtualDriveSettingsData.this.m_objPDGroups.size(); ++n3) {
                PDGroup pDGroup = (PDGroup)VirtualDriveSettingsData.this.m_objPDGroups.get(n3);
                ArrayList<PhysicalDriveHelper> arrayList = pDGroup.getPDListForGroup();
                if (arrayList == null || arrayList.size() == 0) continue;
                int s = pDGroup.getGroupID();
                int l2 = pDGroup.getNumSubGroups();
                short s2 = arrayList.get(0).getUserDataBlockSize();
                for (int i = 0; i < l2; ++i) {
                    int n4 = i + 1;
                    for (SGRAIDLevelAndNumVD sGRAIDLevelAndNumVD : VirtualDriveSettingsData.this.m_objSGRAIDAndNumVDsToCapacitiesMap.keySet()) {
                        PDSubgroup pDSubgroup = sGRAIDLevelAndNumVD.getSubgroup();
                        if (pDSubgroup.getGroupID() != s || pDSubgroup.isDriveMixingUsedInGroup() != VirtualDriveSettingsData.this.m_isDriveTypeMixingSelected || pDSubgroup.containsOnlyPIDrives() != VirtualDriveSettingsData.this.m_isEnablePISelected || pDSubgroup.getSubgroupID() != n4 || sGRAIDLevelAndNumVD.getRAIDLevel() != n || sGRAIDLevelAndNumVD.getNumVirtualDrives() != n2) continue;
                        Vector vector2 = (Vector)VirtualDriveSettingsData.this.m_objSGRAIDAndNumVDsToCapacitiesMap.get(sGRAIDLevelAndNumVD);
                        for (int j = 0; j < vector2.size(); ++j) {
                            long l = (Long)vector2.get(j) * (long)s2;
                            if (vector.contains(l)) continue;
                            vector.add(l);
                            hashMap.put(l, s2);
                        }
                    }
                }
            }
            VirtualDriveSettingsData.this.sortCapacitiesAscending(vector);
            for (n3 = 0; n3 < vector.size(); ++n3) {
                long l = (Long)vector.get(n3);
                short s = (Short)hashMap.get(l);
                long l2 = l / (long)s;
                this.capacitiesInUnits.add(KernelConstants.getConvertedSize(l2, s));
                this.capacitiesInBlocks.add(l2);
            }
        }
    }
}

