/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUI.venus.configuration.simple.VirtualDriveSettingsData;
import GUI.venus.configuration.simple.VirtualDriveSettingsPanel;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.CustomMsgBox;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VirtualDriveSettingsPage
extends DefaultWizardPage
implements HelpInterface {
    private VirtualDriveSettingsData m_objVDSettingsData = null;
    private VirtualDriveSettingsPanel m_virtualDriveSettingsPanel = null;
    Vector<Integer> m_raidVector = new Vector();
    private AdapterHelper m_adapterHelper = null;
    private boolean isCapacitySelected = false;

    @Override
    public JPanel getContentPanel() {
        this.m_adapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        this.m_strHelpFileName = this.m_adapterHelper.isCSA() ? "MSM_CSA_CREATING_A_VIRTUAL_DRIVE_USING_SIMPLE_CONFIGURATION" : (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1 ? "MR_CREATING_A_VIRTUAL_DRIVE_USING_SIMPLE_CONFIGURATION" : "IR_CREATING_A_VIRTUAL_DRIVE_USING_A_SIMPLE_CONFIGURATION");
        this.m_virtualDriveSettingsPanel = new VirtualDriveSettingsPanel(this.m_adapterHelper);
        this.m_objVDSettingsData = this.m_virtualDriveSettingsPanel.getVDSettingsData();
        this.m_virtualDriveSettingsPanel.buildPanel();
        this.isFDESecurityOnlySupported();
        this.m_virtualDriveSettingsPanel.addRaidLevelComboBoxItemListener(new RaidLevelComboItemListener());
        this.m_virtualDriveSettingsPanel.addVirtualDriveComboBoxItemListener(new VirtualDriveComboItemListener());
        this.m_virtualDriveSettingsPanel.addDriveMixingItemListener(new DriveMixingItemListener());
        this.m_virtualDriveSettingsPanel.addDataProtectionItemListener(new DataProtectionItemListener());
        this.m_virtualDriveSettingsPanel.addhotSpareActionListener(new HotSpareActionListener());
        this.m_virtualDriveSettingsPanel.adddriveSecurityItemListener(new DriveSecurityItemListener());
        this.m_virtualDriveSettingsPanel.adddriveTypeMixingItemListener(new DriveTypeMixingItemListener());
        this.m_virtualDriveSettingsPanel.addCapacityComboboxItemListener(new CapacityComboItemListener());
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
        return this.m_virtualDriveSettingsPanel;
    }

    @Override
    public String getPageID() {
        return "VirtualDriveSettingsPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CREATE_VD_SETTINGS_PAGE_TITLE", "Create Virtual Drive - Drive group and Virtual drive settings");
    }

    @Override
    public void cleanUp() {
    }

    public int raidSelected() {
        int n;
        this.m_raidVector = this.m_objVDSettingsData.getSupportedRAIDLevels();
        Vector<Object> vector = new Vector();
        vector = this.m_virtualDriveSettingsPanel.removeHotRAIDs(this.m_raidVector);
        try {
            n = (Integer)vector.get(this.m_virtualDriveSettingsPanel.raidLevelCombo.getSelectedIndex());
        }
        catch (Exception exception) {
            n = (Integer)vector.get(0);
        }
        if (this.m_virtualDriveSettingsPanel.hotSpareCheckbox.isSelected()) {
            if (n == 1) {
                n = 2;
            } else if (n == 3) {
                n = 4;
            } else if (n == 5) {
                n = 6;
            }
        }
        return n;
    }

    public ArrayList<PhysicalDriveHelper> getPDList() {
        int n;
        int n2 = this.raidSelected();
        int n3 = this.m_virtualDriveSettingsPanel.virtualDrivesCombo.getSelectedIndex();
        VirtualDriveSettingsData virtualDriveSettingsData = this.m_objVDSettingsData;
        virtualDriveSettingsData.getClass();
        Vector<Long> vector = virtualDriveSettingsData.new VirtualDriveSettingsData.CapacitiesForRaidLevelAndNumVDs(this.raidSelected(), ++n3).getCapacitiesInBlocks();
        if (vector.size() > 0 && (n = this.m_virtualDriveSettingsPanel.capacityCombo.getSelectedIndex()) >= 0) {
            long l = vector.get(n);
            if (this.m_virtualDriveSettingsPanel.m_isMixingAllowed) {
                boolean bl = this.m_virtualDriveSettingsPanel.driveTypeMixingCheckbox.isSelected();
                this.m_objVDSettingsData.setDriveTypeMixingAllowed(true);
                this.m_objVDSettingsData.setDriveTypeMixingSelected(bl);
            }
            this.m_objVDSettingsData.setSelectedRAIDLevel(n2);
            this.m_objVDSettingsData.setSelectedNumVDs(n3);
            this.m_objVDSettingsData.setSelectedCapacity(l);
            SimpleConfigParams simpleConfigParams = this.m_objVDSettingsData.getSimpleConfigParams();
            ArrayList<PhysicalDriveHelper> arrayList = simpleConfigParams.getPDListForDriveGroup();
            return arrayList;
        }
        return null;
    }

    public void isFDESecurityOnlySupported() {
        ArrayList<PhysicalDriveHelper> arrayList = this.getPDList();
        if (this.m_adapterHelper.isOnlyFDESupported() && arrayList != null) {
            boolean bl = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).isFDECapable()) continue;
                bl = false;
                break;
            }
            if (bl && this.m_adapterHelper.isSecuritySupported() && this.m_adapterHelper.isLockKeyAssigned()) {
                this.m_virtualDriveSettingsPanel.driveSecurityCheckBox.setEnabled(true);
            } else {
                this.m_virtualDriveSettingsPanel.driveSecurityCheckBox.setEnabled(false);
            }
        }
    }

    @Override
    public void onNext() {
        int n = this.raidSelected();
        if (!(n != 1 && n != 8 || this.m_objVDSettingsData.getSimpleConfigParams().getPDListForDriveGroup().size() % 2 != 1 || CustomMsgBox.confirmWithCheck(Resource.getString("MSG_RAID1E_WARNING", "The virtual dirve cannot be migrated to MegaRAID controller. Do you want to continue?")))) {
            this.m_virtualDriveSettingsPanel.raidLevelCombo.setSelectedIndex(0);
            return;
        }
        Vector<Integer> vector = this.m_objVDSettingsData.getNumVDsForRAIDLevel(n);
        int n2 = vector.get(this.m_virtualDriveSettingsPanel.virtualDrivesCombo.getSelectedIndex());
        VirtualDriveSettingsData virtualDriveSettingsData = this.m_objVDSettingsData;
        virtualDriveSettingsData.getClass();
        Vector<Long> vector2 = virtualDriveSettingsData.new VirtualDriveSettingsData.CapacitiesForRaidLevelAndNumVDs(this.raidSelected(), n2).getCapacitiesInBlocks();
        long l = vector2.get(this.m_virtualDriveSettingsPanel.capacityCombo.getSelectedIndex());
        boolean bl = this.m_virtualDriveSettingsPanel.driveSecurityCheckBox.isSelected();
        if (this.m_virtualDriveSettingsPanel.m_isMixingAllowed) {
            boolean bl2 = this.m_virtualDriveSettingsPanel.driveTypeMixingCheckbox.isSelected();
            this.m_objVDSettingsData.setDriveTypeMixingAllowed(true);
            this.m_objVDSettingsData.setDriveTypeMixingSelected(bl2);
        }
        this.m_objVDSettingsData.setSelectedRAIDLevel(n);
        this.m_objVDSettingsData.setSelectedNumVDs(n2);
        this.m_objVDSettingsData.setSelectedCapacity(l);
        this.m_objVDSettingsData.setSecurity(bl);
        PhysicalDriveHelper physicalDriveHelper = null;
        boolean bl3 = false;
        SimpleConfigParams simpleConfigParams = this.m_objVDSettingsData.getSimpleConfigParams();
        if (simpleConfigParams.getDriveSecurityMethod() != 1) {
            physicalDriveHelper = simpleConfigParams.getHotSpare();
            if (physicalDriveHelper != null && physicalDriveHelper.isEncrypted()) {
                bl3 = true;
            } else {
                ArrayList<PhysicalDriveHelper> arrayList = simpleConfigParams.getPDListForDriveGroup();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).isEncrypted()) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl3 && JOptionPane.showConfirmDialog(this, Resource.getString("WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), Resource.getString("TITLE_WARN_REPROVISIONING_ON_SECURED_FDE_DISK"), 0, 2) == 1) {
                return;
            }
        }
        this.m_hmWizardData.put("DriveGroupData", this.m_objVDSettingsData.getSimpleConfigParams());
        super.onNext();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }

    class CapacityComboItemListener
    implements ItemListener {
        CapacityComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList<PhysicalDriveHelper> arrayList;
            if (itemEvent.getStateChange() == 1 && VirtualDriveSettingsPage.this.isCapacitySelected && (arrayList = VirtualDriveSettingsPage.this.getPDList()) != null) {
                long l = arrayList.get(0).getSize();
                long l2 = arrayList.get(arrayList.size() - 1).getSize();
                if ((double)l2 > 1.1 * (double)l) {
                    new CustomMsgBox((Component)VivaldiStartupDialog.mainScreen, (Object)Resource.getString("WASTAGE_OF_SPACE", "The system has detected drives of different size. This will lead to wastage of space in one or more drives."), 1);
                }
            }
            VirtualDriveSettingsPage.this.isFDESecurityOnlySupported();
        }
    }

    class DriveTypeMixingItemListener
    implements ItemListener {
        DriveTypeMixingItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveTypeMixingCheckbox.isSelected()) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveTypeMixingIcon.setIcon(Resource.getImage("DRIVE_TYPE_DISABLE_ICON", "Drive_Type_Dis.png"));
            } else {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveTypeMixingIcon.setIcon(Resource.getImage("DRIVE_TYPE_ENABLE_ICON", "Drive_Type.png"));
            }
        }
    }

    class DriveSecurityItemListener
    implements ItemListener {
        DriveSecurityItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveSecurityCheckBox.isSelected()) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveSecurityIcon.setIcon(Resource.getImage("NO_ENCRYPTION_ICON", "decrypt.png"));
            } else {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveSecurityIcon.setIcon(Resource.getImage("CTRL_ENCRYPTION_ICON", "Encryp.png"));
            }
        }
    }

    class HotSpareActionListener
    implements ActionListener {
        HotSpareActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector<Integer> vector;
            int n = VirtualDriveSettingsPage.this.raidSelected();
            if (!((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareCheckbox.isSelected()) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareIcon.setIcon(Resource.getImage("HOTSPARE_DISABLE_ICON", "HotSpare_New_Dis.png"));
            } else {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareIcon.setIcon(Resource.getImage("HOTSPARE_ENABLE_ICON", "HotSpare_New.png"));
                vector = VirtualDriveSettingsPage.this.m_objVDSettingsData.getRAIDLevelsWithWastage();
                System.out.println("Wastage" + vector.contains(n));
                if (vector.contains(n)) {
                    JOptionPane.showMessageDialog(VirtualDriveSettingsPage.this.m_virtualDriveSettingsPanel, "The system has detected drives of different size. This will lead to wastage of space in one or more drives.");
                }
            }
            vector = VirtualDriveSettingsPage.this.m_objVDSettingsData.getNumVDsForRAIDLevel(n);
            int n2 = vector.get(0);
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.virtualDrivesCombo.removeAllItems();
            for (int i = 0; i < vector.size(); ++i) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.virtualDrivesCombo.addItem(vector.get(i));
            }
        }
    }

    class DataProtectionItemListener
    implements ItemListener {
        DataProtectionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            VirtualDriveSettingsPage.this.m_objVDSettingsData.setEnablePISelected(((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.dataProtectionCheckbox.isSelected());
            VirtualDriveSettingsPage.this.m_raidVector = VirtualDriveSettingsPage.this.m_objVDSettingsData.getSupportedRAIDLevels();
            Vector<Integer> vector = VirtualDriveSettingsPage.this.m_virtualDriveSettingsPanel.removeHotRAIDs(VirtualDriveSettingsPage.this.m_raidVector);
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.raidLevelCombo.removeAllItems();
            for (int i = 0; i < vector.size(); ++i) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.raidLevelCombo.addItem(vector.get(i));
            }
        }
    }

    class DriveMixingItemListener
    implements ItemListener {
        DriveMixingItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            VirtualDriveSettingsPage.this.m_objVDSettingsData.setDriveTypeMixingSelected(((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.driveTypeMixingCheckbox.isSelected());
            VirtualDriveSettingsPage.this.m_raidVector = VirtualDriveSettingsPage.this.m_objVDSettingsData.getSupportedRAIDLevels();
            Vector<Integer> vector = VirtualDriveSettingsPage.this.m_virtualDriveSettingsPanel.removeHotRAIDs(VirtualDriveSettingsPage.this.m_raidVector);
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.raidLevelCombo.removeAllItems();
            for (int i = 0; i < vector.size(); ++i) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.raidLevelCombo.addItem(vector.get(i));
            }
        }
    }

    class VirtualDriveComboItemListener
    implements ItemListener {
        VirtualDriveComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            int n2 = VirtualDriveSettingsPage.this.raidSelected();
            Vector<Integer> vector = VirtualDriveSettingsPage.this.m_objVDSettingsData.getNumVDsForRAIDLevel(n2);
            try {
                n = vector.get(((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.virtualDrivesCombo.getSelectedIndex());
            }
            catch (Exception exception) {
                n = vector.get(0);
            }
            VirtualDriveSettingsData virtualDriveSettingsData = VirtualDriveSettingsPage.this.m_objVDSettingsData;
            virtualDriveSettingsData.getClass();
            Vector<String> vector2 = virtualDriveSettingsData.new VirtualDriveSettingsData.CapacitiesForRaidLevelAndNumVDs(n2, n).getCapacitiesInUnits();
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.capacityCombo.removeAllItems();
            for (int i = 0; i < vector2.size(); ++i) {
                VirtualDriveSettingsPage.this.isCapacitySelected = false;
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.capacityCombo.addItem(vector2.get(i));
            }
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.capacityCombo.setSelectedIndex(vector2.size() - 1);
            VirtualDriveSettingsPage.this.isCapacitySelected = true;
        }
    }

    class RaidLevelComboItemListener
    implements ItemListener {
        RaidLevelComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Vector<Integer> vector;
            boolean bl;
            Vector<Object> vector2 = new Vector();
            vector2 = VirtualDriveSettingsPage.this.m_objVDSettingsData.getSupportedRAIDLevels();
            boolean bl2 = bl = VirtualDriveSettingsPage.this.m_adapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getdedicatedHotSpares() != 0;
            if (bl) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareCheckbox.setSelected(false);
            }
            int n = VirtualDriveSettingsPage.this.raidSelected();
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.raidLevelLabelDescription.setText(VirtualDriveSettingsPage.this.m_virtualDriveSettingsPanel.getRaidLevelDescription(n));
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.raidLevelIcon.setIcon(VirtualDriveSettingsPage.this.m_virtualDriveSettingsPanel.getRaidLevelIcon(n));
            Vector<Integer> vector3 = VirtualDriveSettingsPage.this.m_objVDSettingsData.getNumVDsForRAIDLevel(n);
            ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.virtualDrivesCombo.removeAllItems();
            for (int i = 0; i < vector3.size(); ++i) {
                ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.virtualDrivesCombo.addItem(vector3.get(i));
            }
            if (bl) {
                if (vector2.contains(2) && n == 1 || vector2.contains(4) && n == 3 || vector2.contains(6) && n == 5) {
                    ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareCheckbox.setEnabled(true);
                } else {
                    ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareCheckbox.setSelected(false);
                    ((VirtualDriveSettingsPage)VirtualDriveSettingsPage.this).m_virtualDriveSettingsPanel.hotSpareCheckbox.setEnabled(false);
                }
            }
            if (itemEvent.getStateChange() == 1 && (vector = VirtualDriveSettingsPage.this.m_objVDSettingsData.getRAIDLevelsWithWastage()).contains(n)) {
                new CustomMsgBox((Component)VivaldiStartupDialog.mainScreen, (Object)Resource.getString("WASTAGE_OF_SPACE", "The system has detected drives of different size. This will lead to wastage of space in one or more drives."), 1);
            }
        }
    }
}

