/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.simple;

import GUI.venus.configuration.simple.CapacityComboBoxRenderer;
import GUI.venus.configuration.simple.RAIDComboBoxRenderer;
import GUI.venus.configuration.simple.VirtualDriveSettingsData;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VirtualDriveSettingsPanel
extends JPanel {
    private String[] mnemonics;
    private GridBagConstraints gbc = new GridBagConstraints();
    public JCheckBox hotSpareCheckbox = new JCheckBox();
    public JCheckBox driveTypeMixingCheckbox = new JCheckBox();
    public JCheckBox dataProtectionCheckbox = new JCheckBox();
    public JLabel driveTypeMixingIcon = new JLabel();
    public JLabel raidLevelIcon = new JLabel();
    public JLabel hotSpareIcon = new JLabel();
    public JLabel driveSecurityIcon = new JLabel();
    private JLabel virtualDriveIcon = new JLabel();
    private JLabel capacityIcon = new JLabel();
    final JLabel raidLevelLabelDescription = new JLabel();
    public JCheckBox driveSecurityCheckBox = new JCheckBox();
    private Dimension iconDimensions = new Dimension(32, 32);
    public JComboBox raidLevelCombo = new JComboBox();
    public JComboBox virtualDrivesCombo = new JComboBox();
    public JComboBox capacityCombo = new JComboBox();
    private JCheckBox m_migrateVDCheckBox = new JCheckBox();
    private JCheckBox m_exposetoOS = new JCheckBox();
    private AdapterHelper m_objAdapterHelper = null;
    private VirtualDriveSettingsData m_objVDSettingsData = null;
    public boolean m_isMixingAllowed = false;
    public boolean m_isPISupported = false;
    private boolean m_hotSpare = false;
    private boolean m_driveSecurity = false;
    private int m_iRAIDLevel;
    private int m_iNumVDs;
    private String m_lCapacity;
    public boolean m_ismigrationAllowed = false;
    public boolean m_iexposedtoOs = false;
    private boolean SSD = false;
    private boolean HDD = false;
    private boolean SAS = false;
    private boolean SATA = false;
    private boolean FDE = false;
    private boolean nonFDE = false;
    private boolean BLOCKSIZE_4K = false;
    private boolean BLOCKSIZE_512 = false;

    public VirtualDriveSettingsPanel(AdapterHelper adapterHelper) {
        int n;
        this.m_objAdapterHelper = adapterHelper;
        this.m_objVDSettingsData = new VirtualDriveSettingsData(this.m_objAdapterHelper);
        this.m_isPISupported = this.m_objAdapterHelper.isPIEnabledOnController();
        if (this.m_objAdapterHelper.isSecuritySupported() && this.m_objAdapterHelper.isLockKeyAssigned()) {
            if (this.m_objAdapterHelper.isOnlyFDESupported()) {
                if (this.getFDEPdCount() > 0) {
                    this.m_driveSecurity = true;
                }
            } else {
                this.m_driveSecurity = true;
            }
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_objAdapterHelper.getUnconfiguredPhysicalDrives();
        for (n = 0; n < physicalDriveHelperArray.length; ++n) {
            if (physicalDriveHelperArray[n].getmediaType() == '\u0000') {
                this.HDD = true;
            } else {
                this.SSD = true;
            }
            if (physicalDriveHelperArray[n].getPdType() == 3) {
                this.SATA = true;
            } else {
                this.SAS = true;
            }
            if (physicalDriveHelperArray[n].isFDECapable()) {
                this.FDE = true;
            } else {
                this.nonFDE = true;
            }
            if (physicalDriveHelperArray[n].getUserDataBlockSize() == 4096) {
                this.BLOCKSIZE_4K = true;
                continue;
            }
            this.BLOCKSIZE_512 = true;
        }
        n = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
        int n2 = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
        int n3 = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
        if (((n == 1 || n2 == 1 || n3 == 1) && (this.HDD & this.SSD || this.SAS & this.SATA) || this.FDE & this.nonFDE) && !(this.BLOCKSIZE_4K & this.BLOCKSIZE_512)) {
            this.m_isMixingAllowed = true;
        }
        if (this.m_objAdapterHelper.getAdapterInfo().getmaxHANodes() > 1) {
            this.m_iexposedtoOs = true;
        }
    }

    public void buildPanel() {
        JLabel jLabel;
        Serializable serializable;
        this.setLayout(new GridBagLayout());
        this.gbc.fill = 0;
        this.gbc.anchor = 18;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 4;
        this.gbc.insets = new Insets(0, 15, 20, 0);
        this.add((Component)new JLabel(Resource.getString("VD_SETTINGS_LABEL", "<html>Use the suggested virtual drive settings or change them if needed.</html>")), this.gbc);
        if (this.m_isMixingAllowed) {
            this.gbc.gridx = 0;
            this.gbc.gridy = 1;
            this.gbc.gridwidth = 1;
            this.gbc.insets = new Insets(0, 10, 30, 0);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("MIXING_CHECKBOX", "(U)se the drive type mixing."));
            this.driveTypeMixingCheckbox.setText(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.driveTypeMixingCheckbox.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.add((Component)this.driveTypeMixingCheckbox, this.gbc);
            this.gbc.gridx = 1;
            this.gbc.insets = new Insets(0, 0, 10, 0);
            this.driveTypeMixingIcon.setIcon(Resource.getImage("DRIVE_TYPE_DISABLE_ICON", "Drive_Type_Dis.png"));
            this.driveTypeMixingIcon.setPreferredSize(this.iconDimensions);
            this.add((Component)this.driveTypeMixingIcon, this.gbc);
            this.gbc.gridx = 2;
            this.gbc.insets = new Insets(0, 0, 10, 0);
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(Resource.getString("MIXING_DESC1", "<html>The application has detected "));
            if (this.HDD & this.SSD) {
                ((StringBuffer)serializable).append(Resource.getString("HDD_SSD", "HDD/SSD-"));
            } else if (this.HDD) {
                ((StringBuffer)serializable).append(Resource.getString("HDD", "HDD-"));
            } else {
                ((StringBuffer)serializable).append(Resource.getString("SSD", "SSD-"));
            }
            if (this.SAS & this.SATA) {
                ((StringBuffer)serializable).append(Resource.getString("SAS_SATA", "SAS/SATA-"));
            } else if (this.SAS) {
                ((StringBuffer)serializable).append(Resource.getString("SAS", "SAS-"));
            } else {
                ((StringBuffer)serializable).append(Resource.getString("SATA", "SATA-"));
            }
            if (this.FDE & this.nonFDE) {
                ((StringBuffer)serializable).append(Resource.getString("FDE_NONFDE", "FDE/non-FDE "));
            } else if (this.FDE) {
                ((StringBuffer)serializable).append(Resource.getString("FDE", "FDE "));
            } else {
                ((StringBuffer)serializable).append(Resource.getString("NONFDE", "non-FDE "));
            }
            ((StringBuffer)serializable).append(Resource.getString("MIXING_DESC2", "mixed drives in the controller.Use the check box for<br> drive type mixing if you need.For best result drive type mixing are not recommended.</html>"));
            this.add((Component)new JLabel(((StringBuffer)serializable).toString()), this.gbc);
        }
        if (this.m_isPISupported && this.m_objAdapterHelper.containsPIDrives()) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gbc.gridwidth = 1;
            this.gbc.insets = new Insets(0, 10, 30, 0);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("DATA_PROTECTION_CHECKBOX", "Use data (p)rotection"));
            this.dataProtectionCheckbox.setText(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.dataProtectionCheckbox.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.add((Component)this.dataProtectionCheckbox, this.gbc);
            this.gbc.gridx = 2;
            this.gbc.insets = new Insets(0, 0, 10, 0);
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(Resource.getString("DATA_PROTECTION_DESC", "<html>Data Protection is a guard that detects corruption of data on media; thereby preventing<br>system errors caused by silent data corruption (SDC).</html>"));
            this.add((Component)new JLabel(((StringBuffer)serializable).toString()), this.gbc);
        }
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.gridwidth = 3;
        this.gbc.insets = new Insets(0, 15, 10, 0);
        this.add((Component)new JLabel(Resource.getString("RAID_HEADING", "<html>Pick a RAID level to specify the amount of fault tolerance and performance for the virtual drive(s).</html>")), this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(0, 15, 0, 0);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("RAID_LABEL", "(R)AID level:"));
        serializable = new JLabel(this.mnemonics[0]);
        this.add((Component)serializable, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 3;
        this.gbc.insets = new Insets(0, 15, 20, 0);
        Vector<Integer> vector = this.m_objVDSettingsData.getSupportedRAIDLevels();
        vector = this.removeHotRAIDs(vector);
        this.raidLevelCombo = new JComboBox<Integer>(vector);
        this.raidLevelCombo.setRenderer(new RAIDComboBoxRenderer());
        this.add((Component)this.raidLevelCombo, this.gbc);
        if (this.mnemonics.length == 2) {
            ((JLabel)serializable).setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            ((JLabel)serializable).setLabelFor(this.raidLevelCombo);
        }
        this.m_iRAIDLevel = vector.get(this.raidLevelCombo.getSelectedIndex());
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(0, 0, 10, 0);
        this.raidLevelIcon.setIcon(Resource.getImage("RAID0_ICON", "R0.png"));
        this.raidLevelIcon.setPreferredSize(this.iconDimensions);
        this.add((Component)this.raidLevelIcon, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.insets = new Insets(0, 0, 10, 0);
        this.raidLevelLabelDescription.setText(this.getRaidLevelDescription(0));
        this.add((Component)this.raidLevelLabelDescription, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 10, 15, 50);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("HOTSPARE_CHECBOX", "Assign a h(o)t spare"));
        this.hotSpareCheckbox.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.hotSpareCheckbox.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.add((Component)this.hotSpareCheckbox, this.gbc);
        this.hotSpareCheckbox.setEnabled(false);
        this.gbc.gridx = 1;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.hotSpareIcon.setIcon(Resource.getImage("HOTSPARE_DISABLE_ICON", "HotSpare_New_Dis.png"));
        this.hotSpareIcon.setPreferredSize(this.iconDimensions);
        this.add((Component)this.hotSpareIcon, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.add((Component)new JLabel(Resource.getString("HOTSPARE_DESC", "<html>Hot spare will be assigned depending upon the availability of eligible hot spare candidate drives.A hot <br>spare drive takes over a failed drive and ensures that the data remains intact.</html>")), this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 10, 20, 0);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("SECURITY_CHECKBOX", "Use drive (s)ecurity"));
        this.driveSecurityCheckBox.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.driveSecurityCheckBox.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.add((Component)this.driveSecurityCheckBox, this.gbc);
        if (!this.m_driveSecurity) {
            this.driveSecurityCheckBox.setEnabled(false);
        }
        this.gbc.gridx = 1;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.driveSecurityIcon.setIcon(Resource.getImage("NO_ENCRYPTION_ICON", "decrypt.png"));
        this.driveSecurityIcon.setPreferredSize(this.iconDimensions);
        this.add((Component)this.driveSecurityIcon, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.add((Component)new JLabel(Resource.getString("SECURTIY_DESC", "<html>Drive security method will be assigned depending upon the controller settings.The drive security will<br>make the virtual drive secure by applying encryption logic to the data in the drive</html>")), this.gbc);
        if (this.m_ismigrationAllowed) {
            ++this.gbc.gridy;
            this.gbc.gridx = 0;
            this.gbc.gridwidth = 18;
            this.gbc.insets = new Insets(0, 10, 0, 0);
            this.m_migrateVDCheckBox.setSelected(true);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_MIGRATE_VD", "(M)igrate Virtual Drive(s) on failover"));
            this.m_migrateVDCheckBox.setText(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                this.m_migrateVDCheckBox.setMnemonic(this.mnemonics[1].charAt(0));
            }
            this.add((Component)this.m_migrateVDCheckBox, this.gbc);
            this.gbc.gridx = 2;
            this.gbc.gridwidth = 18;
            jLabel = new JLabel();
            jLabel.setText(Resource.getString("DESC_MIGRATE_VD_SIMPLE"));
            this.add((Component)jLabel, this.gbc);
        }
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 15, 0, 0);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVE_LABEL", "(V)irtual drives:"));
        jLabel = new JLabel(this.mnemonics[0]);
        this.add((Component)jLabel, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(0, 15, 20, 0);
        Vector<Integer> vector2 = this.m_objVDSettingsData.getNumVDsForRAIDLevel(this.m_iRAIDLevel);
        this.virtualDrivesCombo = new JComboBox<Integer>(vector2);
        this.add((Component)this.virtualDrivesCombo, this.gbc);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel.setLabelFor(this.virtualDrivesCombo);
        }
        this.m_iNumVDs = vector2.get(this.virtualDrivesCombo.getSelectedIndex());
        this.gbc.gridx = 1;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.virtualDriveIcon.setIcon(Resource.getImage("VIRTUAL_DRIVE_ICON", "virtualdrive.png"));
        this.virtualDriveIcon.setPreferredSize(this.iconDimensions);
        this.add((Component)this.virtualDriveIcon, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.add((Component)new JLabel(Resource.getString("VIRTUAL_DESC", "<html>Select number of virtual drives to create.</html>")), this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 15, 0, 0);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CAPACITY_LABEL", "(C)apacity:"));
        JLabel jLabel2 = new JLabel(this.mnemonics[0]);
        this.add((Component)jLabel2, this.gbc);
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(0, 15, 50, 0);
        VirtualDriveSettingsData virtualDriveSettingsData = this.m_objVDSettingsData;
        virtualDriveSettingsData.getClass();
        Vector<String> vector3 = virtualDriveSettingsData.new VirtualDriveSettingsData.CapacitiesForRaidLevelAndNumVDs(this.m_iRAIDLevel, this.m_iNumVDs).getCapacitiesInUnits();
        this.capacityCombo = new JComboBox<String>(vector3);
        this.capacityCombo.setRenderer(new CapacityComboBoxRenderer());
        this.capacityCombo.setSelectedIndex(vector3.size() - 1);
        this.add((Component)this.capacityCombo, this.gbc);
        if (this.mnemonics.length == 2) {
            jLabel2.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel2.setLabelFor(this.capacityCombo);
        }
        this.m_lCapacity = vector3.get(this.capacityCombo.getSelectedIndex());
        this.gbc.gridx = 1;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.capacityIcon.setIcon(Resource.getImage("CAPACITY_ICON", "capacity.png"));
        this.capacityIcon.setPreferredSize(this.iconDimensions);
        this.add((Component)this.capacityIcon, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.insets = new Insets(0, 0, 0, 10);
        this.add((Component)new JLabel(Resource.getString("CAPACTIY_DESC", "<html>Select the capacity for the virtual drive(s).Each virtual drive will have the same capacity.</html>")), this.gbc);
    }

    public Vector<Integer> removeHotRAIDs(Vector<Integer> vector) {
        Vector<Object> vector2 = new Vector();
        vector2 = vector;
        if (vector2.contains(2)) {
            vector2.removeElement(2);
        }
        if (vector2.contains(4)) {
            vector2.removeElement(4);
        }
        if (vector2.contains(6)) {
            vector2.removeElement(6);
        }
        return vector2;
    }

    public void addRaidLevelComboBoxItemListener(ItemListener itemListener) {
        this.raidLevelCombo.addItemListener(itemListener);
    }

    public void addVirtualDriveComboBoxItemListener(ItemListener itemListener) {
        this.virtualDrivesCombo.addItemListener(itemListener);
    }

    public void addDriveMixingItemListener(ItemListener itemListener) {
        this.driveTypeMixingCheckbox.addItemListener(itemListener);
    }

    public void addhotSpareActionListener(ActionListener actionListener) {
        this.hotSpareCheckbox.addActionListener(actionListener);
    }

    public void adddriveSecurityItemListener(ItemListener itemListener) {
        this.driveSecurityCheckBox.addItemListener(itemListener);
    }

    public void adddriveTypeMixingItemListener(ItemListener itemListener) {
        this.driveTypeMixingCheckbox.addItemListener(itemListener);
    }

    public void addCapacityComboboxItemListener(ItemListener itemListener) {
        this.capacityCombo.addItemListener(itemListener);
    }

    public void addDataProtectionItemListener(ItemListener itemListener) {
        this.dataProtectionCheckbox.addItemListener(itemListener);
    }

    public VirtualDriveSettingsData getVDSettingsData() {
        return this.m_objVDSettingsData;
    }

    public String getRaidLevelDescription(int n) {
        switch (n) {
            case 0: {
                return Resource.getString("RAID0_DESC", "This RAID level is suitable for high performance with zero data redundancy.Choose this option<br>only for non-critical data.</html>");
            }
            case 1: 
            case 2: {
                return Resource.getString("RAID1_DESC", "<html>\"Disk mirroring\" This RAID level is suitable for high redundancy and performance.</html>");
            }
            case 3: 
            case 4: {
                return Resource.getString("RAID5_DESC", "<html>This RAID level is suitable for multi-user environments(database or file system) with large IO size<br>and high proportion of read activity.</html>");
            }
            case 5: 
            case 6: {
                return Resource.getString("RAID6_DESC", "<html>This RAID level is suitable for environments requiring redundancy protection beyond RAID 5, but not requiring<br> high write performance.</html>");
            }
            case 7: {
                return Resource.getString("RAID1E_DESC", "<html>RAID level that combines RAID 0's striping capabilities with<br>RAID 1's mirroring protection.</html>");
            }
            case 8: {
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
        }
        return "";
    }

    public ImageIcon getRaidLevelIcon(int n) {
        switch (n) {
            case 0: {
                return Resource.getImage("RAID0_ICON", "R0.png");
            }
            case 1: 
            case 2: {
                return Resource.getImage("RAID1_ICON", "R1.png");
            }
            case 3: 
            case 4: {
                return Resource.getImage("RAID5_ICON", "R5.png");
            }
            case 5: 
            case 6: {
                return Resource.getImage("RAID6_ICON", "R6.png");
            }
            case 7: {
                return Resource.getImage("RAID1E_ICON");
            }
            case 8: {
                return Resource.getImage("RAID10_ICON");
            }
        }
        return Resource.getImage("");
    }

    public int getFDEPdCount() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_objAdapterHelper.getUnconfiguredPhysicalDrives();
        int n = 0;
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (!physicalDriveHelperArray[i].isFDECapable() || physicalDriveHelperArray[i].isForeign()) continue;
            ++n;
        }
        return n;
    }
}

