/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.supersizedcache;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.RaidLevelRenderer;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.supersizedcache.SSCDriveGroupsTreePanel;
import GUI.venus.configuration.supersizedcache.SSCPDTableToTreePanel;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class SSCAdvancedDriveGroupSettings {
    public static final byte RAID_LEVEL_SELECT = -1;
    private AdapterHelper m_AdapterHelper = null;
    private JComboBox m_raidLevelCombobox = new JComboBox();
    private DefaultWizardPage m_defWizardPage = null;
    private SSCPDTableToTreePanel m_pdTableToTreePanel = null;
    private SSCDriveGroupsTreePanel m_dgTreePanel = null;
    private JComboBox m_protectionCombobox = new JComboBox();
    private JLabel m_protectionDesc = null;
    private JPanel m_contentPanel = null;
    private AdvanceConfigEngine m_engine = null;
    private byte mfcDisablePI = 1;
    public static final byte PROTECTION_SELECT = 0;
    public static final byte PROTECTED = 1;

    public SSCAdvancedDriveGroupSettings(AdvanceConfigEngine advanceConfigEngine, DefaultWizardPage defaultWizardPage) {
        this.m_engine = advanceConfigEngine;
        this.m_AdapterHelper = advanceConfigEngine.getAdapterHelper();
        this.m_defWizardPage = defaultWizardPage;
        this.initialise();
    }

    public void initialise() {
        this.m_dgTreePanel = new SSCDriveGroupsTreePanel(this.m_AdapterHelper, this.m_raidLevelCombobox, this.m_defWizardPage, this.m_protectionCombobox);
        this.m_pdTableToTreePanel = new SSCPDTableToTreePanel(this.m_engine, this.m_raidLevelCombobox, this.m_dgTreePanel, this.m_defWizardPage);
        this.m_dgTreePanel.addDriveGroupNodeToTree();
        this.m_contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension dimension = new Dimension(230, 25);
        Dimension dimension2 = new Dimension(32, 32);
        final JLabel jLabel = new JLabel();
        RaidLevelComboBoxModel raidLevelComboBoxModel = new RaidLevelComboBoxModel(this.m_AdapterHelper, this.m_pdTableToTreePanel.getUnconfiguredGoodPdListSize(), true);
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.m_contentPanel.add((Component)new JLabel(Resource.getString("PICK_RAID_DESC")), gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        final JLabel jLabel3 = new JLabel();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_RAID_LEVEL_ADG", "(R)AID level:"));
        jLabel2.setText(stringArray[0]);
        jLabel2.setLabelFor(this.m_raidLevelCombobox);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_contentPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.m_raidLevelCombobox.setPreferredSize(dimension);
        this.m_raidLevelCombobox.setModel(raidLevelComboBoxModel);
        this.m_raidLevelCombobox.setRenderer(new RaidLevelRenderer(this.m_AdapterHelper));
        this.m_contentPanel.add((Component)this.m_raidLevelCombobox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel3.setPreferredSize(dimension2);
        jLabel3.setIcon(Resource.getImage(""));
        this.m_contentPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 18;
        jLabel.setText(this.getRaidLevelDescription((byte)-1));
        this.m_contentPanel.add((Component)jLabel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PROTECTED_CACHE", "Protected Cachecade"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ProtectionComboBoxModel protectionComboBoxModel = new ProtectionComboBoxModel(this.m_dgTreePanel.isPICapablePossible());
        this.m_protectionCombobox.setPreferredSize(dimension);
        this.m_protectionCombobox.setModel(protectionComboBoxModel);
        this.m_protectionCombobox.setRenderer(new ProtectionComboBoxRenderer());
        jLabel4.setLabelFor(this.m_protectionCombobox);
        this.m_protectionDesc = new JLabel(Resource.getString("DATA_PROTECTION_DESC", "<html> Data Protection is a guard that detects corruption of data on media; thereby preventing <br>system errors caused by silent data corruption (SDC). </html>"));
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 8;
        this.m_contentPanel.add((Component)this.m_pdTableToTreePanel, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridwidth = 8;
        this.m_contentPanel.add((Component)this.m_dgTreePanel, gridBagConstraints);
        this.m_raidLevelCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (SSCAdvancedDriveGroupSettings.this.m_raidLevelCombobox.getSelectedIndex() != -1) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    Object object;
                    SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.reset();
                    byte by = (Byte)itemEvent.getItem();
                    jLabel.setText(SSCAdvancedDriveGroupSettings.this.getRaidLevelDescription(by));
                    jLabel3.setIcon(SSCAdvancedDriveGroupSettings.this.getRaidLevelIcon(by));
                    DefaultMutableTreeNode defaultMutableTreeNode2 = SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.getLastDgNode();
                    DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
                    if (!driveGroup.isCompleted() && by <= 17 && defaultMutableTreeNode2.getChildCount() == 1 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject()) instanceof Span && defaultMutableTreeNode.getChildCount() == 0) {
                        ((DefaultTreeModel)SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.getDriveGroupsTree().getModel()).removeNodeFromParent(defaultMutableTreeNode);
                    }
                    if (by == -1) {
                        SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.setEnabledAddButton(false);
                        if (SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.getDgCount() > 0 && SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.isPreviousDgNodeCompleted()) {
                            SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.addDriveGroupNodeToTree();
                        }
                    } else if (by >= 0) {
                        Object object2;
                        if (!driveGroup.isCompleted()) {
                            driveGroup.setRaidLevel(by);
                        }
                        boolean bl = true;
                        object = SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.getSelectedNodeFromTree();
                        if (object != null && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof DriveGroup && ((DriveGroup)object2).isCompleted()) {
                            bl = false;
                        }
                        if (SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.isPdSelectedFromTable() && bl) {
                            SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.setEnabledAddButton(true);
                        } else {
                            SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.setEnabledAddButton(false);
                        }
                    }
                }
            }
        });
        this.m_protectionCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((SSCAdvancedDriveGroupSettings)SSCAdvancedDriveGroupSettings.this).m_pdTableToTreePanel.m_unconfiguredDrivesTable.clearSelection();
                DriveGroup driveGroup = SSCAdvancedDriveGroupSettings.this.m_dgTreePanel.getLastDgObject();
                SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().reset();
                if (SSCAdvancedDriveGroupSettings.this.m_protectionCombobox.getSelectedIndex() == 1) {
                    SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredDrivesDisabler().protectedTrigger(SSCAdvancedDriveGroupSettings.this.m_pdTableToTreePanel.getUnconfiguredGoodPdList(), false, true);
                }
            }
        });
    }

    public JPanel getContentPanel() {
        return this.m_contentPanel;
    }

    public SSCDriveGroupsTreePanel getDgTreePanel() {
        return this.m_dgTreePanel;
    }

    private String getRaidLevelDescription(byte by) {
        switch (by) {
            case -1: {
                return Resource.getString("RAID_DESC_SSCD", "<html>Pick a RAID level to specify the amount of fault tolerance and performance for<br>the CacheCade\u2122 virtual drives.</html>");
            }
            case 0: {
                return Resource.getString("RAID0_DESC", "<html>This RAID level is suitable for high performance with zero<br> data redundancy.Choose this option only for non-critical data.</html>");
            }
            case 1: {
                return Resource.getString("RAID1_DESC", "<html>\"Disk mirroring\" This RAID level is suitable for high<br> redundancy and performance.</html>");
            }
            case 17: {
                if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 2) {
                    return Resource.getString("RAID1E_DESC", "<html>RAID level that combines RAID 0's striping capabilities with<br>RAID 1's mirroring protection.</html>");
                }
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
            case 5: {
                return Resource.getString("RAID5_DESC", "<html>This RAID level is suitable for multi-user environments(database <br>or file system) with large IO size and high proportion of read activity.</html>");
            }
            case 6: {
                return Resource.getString("RAID6_DESC", "<html>This RAID level is suitable for environments requiring redundancy<br> protection beyond RAID 5,but not requiring high write performance.</html>");
            }
            case 64: {
                return Resource.getString("RAID00_DESC", "<html>RAID level 00 is a stripe of stripes.</html>");
            }
            case 65: {
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
            case 69: {
                return Resource.getString("RAID50_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed parity of RAID 5.</html>");
            }
            case 70: {
                return Resource.getString("RAID60_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed double parity of RAID 6.</html>");
            }
        }
        return "";
    }

    private ImageIcon getRaidLevelIcon(byte by) {
        switch (by) {
            case -1: {
                return Resource.getImage("");
            }
            case 0: {
                return Resource.getImage("RAID0_ICON");
            }
            case 1: {
                return Resource.getImage("RAID1_ICON");
            }
            case 17: {
                if (((SASAdapter)this.m_AdapterHelper.getDeviceObject()).getAdapterType() == 2) {
                    return Resource.getImage("RAID1E_ICON");
                }
                return Resource.getImage("RAID10_ICON");
            }
            case 5: {
                return Resource.getImage("RAID5_ICON");
            }
            case 6: {
                return Resource.getImage("RAID6_ICON");
            }
            case 64: {
                return Resource.getImage("RAID00_ICON");
            }
            case 65: {
                return Resource.getImage("RAID10_ICON");
            }
            case 69: {
                return Resource.getImage("RAID50_ICON");
            }
            case 70: {
                return Resource.getImage("RAID60_ICON");
            }
        }
        return Resource.getImage("");
    }

    public class ProtectionComboBoxModel
    extends DefaultComboBoxModel {
        public ProtectionComboBoxModel(boolean bl) {
            this.updateModel(bl);
        }

        public void updateModel(boolean bl) {
            if (this.getSize() > 0) {
                this.removeAllElements();
            }
            this.addElement(new Byte(0));
            if (bl) {
                this.addElement(new Byte(1));
            }
        }
    }

    public class ProtectionComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                byte by = (Byte)object;
                if (by == 0) {
                    jLabel.setText(Resource.getString("SELECT", "Select"));
                } else if (by == 1) {
                    jLabel.setText(Resource.getString("PROTECTED", "Protected"));
                }
            }
            return jLabel;
        }
    }
}

