/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.supersizedcache;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import Services.KernelConstants;
import Utils.Resource;
import java.text.MessageFormat;
import java.util.List;

public class SSCConfigSummaryGenerator {
    private static final String TABS_5 = "\t\t\t\t\t";
    private static final String TABS_4 = "\t\t\t\t";
    private static final String TABS_3 = "\t\t\t";
    private static final String TABS_2 = "\t\t";
    private static final String TABS_1 = "\t";
    private static final String NEW_LINE = "\n";
    private AdvanceConfigEngine m_engine = null;
    private AdapterHelper m_adapterHelper = null;

    public SSCConfigSummaryGenerator(AdvanceConfigEngine advanceConfigEngine) {
        this.m_engine = advanceConfigEngine;
        SSCConfigSummaryGenerator sSCConfigSummaryGenerator = this;
        this.m_adapterHelper = sSCConfigSummaryGenerator.m_engine.getAdapterHelper();
    }

    public String getConfigSummaryText() {
        Object[] objectArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
            DriveGroup driveGroup = list.get(n);
            List<VirtualDrive> list2 = driveGroup.getVirtualDrives();
            if (list2 != null && !list2.isEmpty()) {
                stringBuffer.append(Resource.getString("SSC_SUMMARY_TEXT_DG_NAME", "CacheCade\u2122 - SSD Caching Drive group name:"));
                stringBuffer.append(TABS_1);
                stringBuffer.append(driveGroup.getDriveGroupName());
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID level:"));
                stringBuffer.append(TABS_5);
                stringBuffer.append(driveGroup.getRaidLevelString());
                stringBuffer.append(NEW_LINE);
                if (driveGroup.getRaidLevel() <= 17) {
                    stringBuffer.append(Resource.getString("SUMMARY_NO_OF_DRIVES_USED", "Number of drives used:"));
                    stringBuffer.append(TABS_4);
                    stringBuffer.append(driveGroup.getSpans().get(0).getNumberOfDrives());
                }
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY", "Total capacity:"));
                stringBuffer.append(TABS_5);
                long l = driveGroup.getTotalCapacityInBlocks();
                stringBuffer.append(KernelConstants.getConvertedSize(l));
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(Resource.getString("SUMMARY_TEXT_FREE_CAPACITY", "Free capacity:"));
                stringBuffer.append(TABS_5);
                long l2 = driveGroup.getFreeSizeInBlocks();
                stringBuffer.append(KernelConstants.getConvertedSize(l2));
                stringBuffer.append(NEW_LINE);
                if (this.m_adapterHelper.isPIEnabledOnController() && this.m_adapterHelper.isPISupported()) {
                    stringBuffer.append(Resource.getString("DATA_PROTECTION", "Data Protection"));
                    stringBuffer.append(TABS_4);
                    stringBuffer.append(driveGroup.isPIEnabled() ? Resource.getString("ENABLED", "Enabled") : Resource.getString("DISABLED", "Disabled"));
                    stringBuffer.append(NEW_LINE);
                }
                for (int n2 = 0; n2 < list2.size(); n2 = (int)((byte)(n2 + 1))) {
                    stringBuffer.append(NEW_LINE);
                    VirtualDrive virtualDrive = list2.get(n2);
                    objectArray = new Object[]{n2 + 1};
                    stringBuffer.append(MessageFormat.format(Resource.getString("SSC_SUMMARY_TEXT_VD_NAME", "CacheCade\u2122 - SSD Caching Virtual Drive {0} name:"), objectArray));
                    if (VivaldiStartupDialog.isSolaris) {
                        stringBuffer.append(TABS_2);
                    } else {
                        stringBuffer.append(TABS_1);
                    }
                    stringBuffer.append(virtualDrive.getName());
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_CAPACITY", "Capacity:"));
                    stringBuffer.append(TABS_5);
                    long l3 = virtualDrive.getSize();
                    stringBuffer.append(KernelConstants.getConvertedSize(l3));
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getResourceMnemonic(Resource.getString("LABEL_WRITE_POLICY", "(W)rite policy:"))[0]);
                    stringBuffer.append(TABS_5);
                    byte by = virtualDrive.getWritePolicy();
                    String string = "";
                    if (by == 0) {
                        string = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                    } else if (by == 17) {
                        string = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back");
                    } else if (by == 1) {
                        string = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                    }
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        return stringBuffer.toString();
    }
}

