/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.supersizedcache;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.UnconfiguredDrivesDisabler;
import GUI.venus.configuration.advanced.UnconfiguredDrivesTableModel;
import GUI.venus.configuration.advanced.UnconfiguredPdTableCellRender;
import GUI.venus.configuration.supersizedcache.SSCDriveGroupsTreePanel;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SSCPDTableToTreePanel
extends JPanel {
    private AdapterHelper m_AdapterHelper = null;
    private JComboBox m_RaidLevelComboBox = null;
    private SSCDriveGroupsTreePanel m_DgTreePanel = null;
    private DefaultWizardPage m_DefWizardPage = null;
    private boolean m_isPdSelected = false;
    private ArrayList<PhysicalDriveHelper> m_unconfiguredGoodPdList = new ArrayList();
    private String[] mnemonics;
    public JTable m_unconfiguredDrivesTable = null;
    private UnconfiguredDrivesTableModel m_unconfGoodPdTableModel = null;
    private JButton m_addButton = new JButton();
    private JButton m_removeButton = new JButton();
    private ArrayList<PhysicalDriveHelper> m_pdListForThisDriveGroup = new ArrayList();
    private AdvanceConfigEngine m_engine = null;
    private UnconfiguredDrivesDisabler m_unconfDriveDisabler = null;

    public SSCPDTableToTreePanel(AdvanceConfigEngine advanceConfigEngine, JComboBox jComboBox, SSCDriveGroupsTreePanel sSCDriveGroupsTreePanel, DefaultWizardPage defaultWizardPage) {
        this.m_engine = advanceConfigEngine;
        this.m_AdapterHelper = advanceConfigEngine.getAdapterHelper();
        this.m_RaidLevelComboBox = jComboBox;
        this.m_DgTreePanel = sSCDriveGroupsTreePanel;
        this.m_DefWizardPage = defaultWizardPage;
        this.m_DgTreePanel.addTreeSelectionListener(new DriveGroupTreeSelectionListener());
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_AdapterHelper.getUnconfiguredPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (!physicalDriveHelperArray[i].isSSDDrive() || physicalDriveHelperArray[i].isIneligibleForSSCD()) continue;
            this.m_unconfiguredGoodPdList.add(physicalDriveHelperArray[i]);
        }
        this.m_DgTreePanel.setUnconfGoodPdList(this.m_unconfiguredGoodPdList);
        this.m_unconfGoodPdTableModel = new UnconfiguredDrivesTableModel(this.m_unconfiguredGoodPdList);
        sSCDriveGroupsTreePanel.setUnconfGoodPdTableModel(this.m_unconfGoodPdTableModel);
        this.buildPanel();
        this.m_DgTreePanel.setPdTableToTreePanel(this);
    }

    public void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.m_unconfiguredDrivesTable = new JTable(this.m_unconfGoodPdTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n2 == 0) {
                    return ((PhysicalDriveHelper)this.getValueAt(n, n2)).getTextForTable()[0];
                }
                if (n2 == 1) {
                    return this.getValueAt(n, n2).toString();
                }
                if (n2 == 2) {
                    return KernelConstants.getConvertedSize(((Long)this.getValueAt(n, n2)).longValue());
                }
                return "";
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.m_unconfiguredDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.gridwidth = 3;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("SSC_LABEL_SELECT_UG_DRIVES", "Select (U)nconfigured SSD Drives:"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel.setLabelFor(jScrollPane);
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridwidth = 3;
        this.add((Component)jScrollPane, gridBagConstraints);
        this.m_unconfDriveDisabler = new UnconfiguredDrivesDisabler(this.m_unconfiguredDrivesTable, this.m_AdapterHelper);
        this.m_DgTreePanel.setUnconfiguredDrivesDisabler(this.m_unconfDriveDisabler);
        this.m_unconfiguredDrivesTable.setShowGrid(false);
        this.m_unconfiguredDrivesTable.setCellSelectionEnabled(false);
        this.m_unconfiguredDrivesTable.setSelectionMode(2);
        this.m_unconfiguredDrivesTable.setRowSelectionAllowed(true);
        this.m_unconfiguredDrivesTable.setAutoResizeMode(0);
        this.m_unconfiguredDrivesTable.setAutoscrolls(true);
        this.m_unconfiguredDrivesTable.setColumnSelectionAllowed(false);
        this.m_unconfiguredDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_unconfiguredDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_unconfiguredDrivesTable.setAutoCreateRowSorter(true);
        ((TableRowSorter)this.m_unconfiguredDrivesTable.getRowSorter()).setSortable(0, false);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        UnconfiguredPdTableCellRender unconfiguredPdTableCellRender = new UnconfiguredPdTableCellRender();
        this.m_unconfiguredDrivesTable.setDefaultRenderer(PhysicalDriveHelper.class, unconfiguredPdTableCellRender);
        this.m_unconfiguredDrivesTable.setDefaultRenderer(String.class, unconfiguredPdTableCellRender);
        this.m_unconfiguredDrivesTable.setDefaultRenderer(Long.class, unconfiguredPdTableCellRender);
        class UnconfDrivesTableListSelectionListener
        implements ListSelectionListener {
            UnconfDrivesTableListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SSCPDTableToTreePanel.this.m_addButton.setEnabled(true);
                SSCPDTableToTreePanel.this.m_isPdSelected = true;
                int[] nArray = SSCPDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                ArrayList<Integer> arrayList = SSCPDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                for (int i = 0; i < n; ++i) {
                    if (arrayList != null && arrayList.contains(nArray[i])) {
                        ++n2;
                    }
                    nArray[i] = SSCPDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[i]);
                }
                if (nArray.length == 0) {
                    SSCPDTableToTreePanel.this.m_addButton.setEnabled(false);
                } else if ((Byte)SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getSelectedItem() >= 0 && SSCPDTableToTreePanel.this.m_DgTreePanel.canPdsBeAdded(nArray) && n2 != n) {
                    SSCPDTableToTreePanel.this.m_addButton.setEnabled(true);
                } else {
                    SSCPDTableToTreePanel.this.m_addButton.setEnabled(false);
                }
            }
        }
        this.m_unconfiguredDrivesTable.getSelectionModel().addListSelectionListener(new UnconfDrivesTableListSelectionListener());
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_DRIVE", "(A)dd >"));
        this.m_addButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_addButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_addButton.setEnabled(false);
        jPanel.add(this.m_addButton);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_DRIVE", "< Remo(v)e"));
        this.m_removeButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_removeButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        jPanel.add(this.m_removeButton);
        this.add((Component)jPanel, gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                int[] nArray = SSCPDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n2 = nArray.length;
                ArrayList<Integer> arrayList = SSCPDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                boolean bl = false;
                for (n = 0; n < n2; ++n) {
                    bl = arrayList != null && arrayList.contains(nArray[n]);
                    nArray[n] = SSCPDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[n]);
                    if (bl) continue;
                    SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.add(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[n]));
                }
                if (SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0) {
                    for (n = 0; n < n2; ++n) {
                        SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.add(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[n]));
                    }
                }
                for (n = 0; n < SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.size(); ++n) {
                    SSCPDTableToTreePanel.this.m_DgTreePanel.addPdNodeToTree((PhysicalDriveHelper)SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.get(n));
                }
                SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.removeAll(SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup);
                SSCPDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                SSCPDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.clear();
                SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                SSCPDTableToTreePanel.this.m_addButton.setEnabled(false);
                SSCPDTableToTreePanel.this.m_isPdSelected = false;
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSCPDTableToTreePanel.this.m_removeButton.setEnabled(false);
                JTree jTree = SSCPDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof DriveGroup) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    Object object2 = defaultMutableTreeNode2.getUserObject();
                    DriveGroup driveGroup = (DriveGroup)object;
                    if (object2 instanceof PhysicalDriveHelper) {
                        int n;
                        int n2 = defaultMutableTreeNode.getChildCount();
                        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
                        for (n = 0; n < n2; ++n) {
                            defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNodeArray[n].getUserObject();
                            if (SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.contains(physicalDriveHelper)) continue;
                            SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.add(physicalDriveHelper);
                        }
                        SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.addAll(SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup);
                        SSCPDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        SSCPDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        if (!((DriveGroup)object).isCompleted()) {
                            for (n = 0; n < n2; ++n) {
                                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNodeArray[n]);
                            }
                            SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                            ((RaidLevelComboBoxModel)SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(SSCPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                            SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedIndex(0);
                            SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                        } else if (((DriveGroup)object).isCompleted()) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = SSCPDTableToTreePanel.this.m_DgTreePanel.getLastDgNode();
                            byte by = -1;
                            if (((DriveGroup)defaultMutableTreeNode3.getUserObject()).isCompleted()) {
                                SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                ((RaidLevelComboBoxModel)SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(SSCPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                                SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                by = -1;
                            } else {
                                by = SSCPDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                                if (defaultMutableTreeNode3.getChildCount() == 0) {
                                    SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                                    ((RaidLevelComboBoxModel)SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(SSCPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                                    SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                                } else {
                                    SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                                    SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                                }
                            }
                            SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                    } else if (object2 instanceof Span) {
                        // empty if block
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode4 = SSCPDTableToTreePanel.this.m_DgTreePanel.getRootNode();
                    int n = defaultMutableTreeNode4.getChildCount();
                    for (int i = 0; i < n; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(i);
                        DriveGroup driveGroup2 = (DriveGroup)defaultMutableTreeNode5.getUserObject();
                        driveGroup2.setDriveGroupId(i);
                    }
                    SSCPDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(SSCPDTableToTreePanel.this.m_DgTreePanel.getLastDgNode().getPath()));
                    SSCPDTableToTreePanel.this.m_engine.removeDriveGroup((DriveGroup)object);
                    if (SSCPDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() == 1 && SSCPDTableToTreePanel.this.m_DgTreePanel.getLastDgNode().getChildCount() == 0) {
                        SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                    }
                } else if (!(object instanceof Span) && object instanceof PhysicalDriveHelper) {
                    SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.add((PhysicalDriveHelper)object);
                    SSCPDTableToTreePanel.this.m_DgTreePanel.setUnconfGoodPdList(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    SSCPDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    byte by = SSCPDTableToTreePanel.this.m_DgTreePanel.getLastDgObject().getRaidLevel();
                    DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    Object object3 = defaultMutableTreeNode6.getUserObject();
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                    if (object3 instanceof DriveGroup) {
                        SSCPDTableToTreePanel.this.m_DgTreePanel.setEnabledCreateDriveGroupButton(SSCPDTableToTreePanel.this.m_DgTreePanel.isCreateDgForPrlEnabled(defaultMutableTreeNode6));
                        SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(((DriveGroup)object3).getRaidLevel());
                        if (defaultMutableTreeNode6.getChildCount() == 0) {
                            SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                            ((RaidLevelComboBoxModel)SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getModel()).updateRaidLevelModel(SSCPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                            if (SSCPDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() == 0) {
                                SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
                            } else {
                                SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
                            }
                        }
                    } else if (object3 instanceof Span) {
                        // empty if block
                    }
                    SSCPDTableToTreePanel.this.m_DgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode6.getPath()));
                    SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setSelectedItem(by);
                }
                SSCPDTableToTreePanel.this.m_pdListForThisDriveGroup.clear();
            }
        });
    }

    public int getUnconfiguredGoodPdListSize() {
        return this.m_unconfiguredGoodPdList.size();
    }

    public ArrayList<PhysicalDriveHelper> getUnconfiguredGoodPdList() {
        return this.m_unconfiguredGoodPdList;
    }

    public UnconfiguredDrivesDisabler getUnconfiguredDrivesDisabler() {
        return this.m_unconfDriveDisabler;
    }

    public void setEnabledAddButton(boolean bl) {
        this.m_addButton.setEnabled(bl);
    }

    public void setEnabledRemoveButton(boolean bl) {
        this.m_removeButton.setEnabled(bl);
    }

    public boolean isPdSelectedFromTable() {
        return this.m_isPdSelected;
    }

    public void reset() {
        this.m_unconfiguredDrivesTable.clearSelection();
        this.m_isPdSelected = false;
    }

    class DriveGroupTreeSelectionListener
    implements TreeSelectionListener {
        DriveGroupTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object;
            Serializable serializable;
            Object object2;
            if (SSCPDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildCount() == 1 && !((DriveGroup)(object2 = (DriveGroup)((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)SSCPDTableToTreePanel.this.m_DgTreePanel.getRootNode().getChildAt(0))).getUserObject())).isCompleted()) {
                SSCPDTableToTreePanel.this.m_DefWizardPage.setNextButtonStatus(false);
            }
            if ((object = ((DefaultMutableTreeNode)(object2 = (DefaultMutableTreeNode)((TreePath)(serializable = treeSelectionEvent.getPath())).getLastPathComponent())).getUserObject()) instanceof AdapterHelper) {
                SSCPDTableToTreePanel.this.m_removeButton.setEnabled(false);
            } else if (object instanceof DriveGroup) {
                int n = ((DefaultMutableTreeNode)object2).getChildCount();
                if (n == 0) {
                    SSCPDTableToTreePanel.this.m_removeButton.setEnabled(false);
                } else {
                    SSCPDTableToTreePanel.this.m_removeButton.setEnabled(true);
                }
                int[] nArray = SSCPDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = SSCPDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[i]);
                }
                if (SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getSelectedIndex() != -1) {
                    if (((DriveGroup)object).isCompleted()) {
                        SSCPDTableToTreePanel.this.m_addButton.setEnabled(false);
                        SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                    } else if (!((DriveGroup)object).isCompleted()) {
                        if (((DriveGroup)object).getRaidLevel() <= 17) {
                            if (n == 0) {
                                SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(true);
                            } else {
                                SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                            }
                        }
                        if ((Byte)SSCPDTableToTreePanel.this.m_RaidLevelComboBox.getSelectedItem() >= 0 && SSCPDTableToTreePanel.this.m_DgTreePanel.canPdsBeAdded(nArray)) {
                            SSCPDTableToTreePanel.this.m_addButton.setEnabled(true);
                        } else {
                            SSCPDTableToTreePanel.this.m_addButton.setEnabled(false);
                        }
                    }
                }
                if (SSCPDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0 || !SSCPDTableToTreePanel.this.m_DgTreePanel.canMoreDgsBeCreated(false)) {
                    SSCPDTableToTreePanel.this.m_RaidLevelComboBox.setEnabled(false);
                }
            } else if (!(object instanceof Span) && object instanceof PhysicalDriveHelper && (defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent()) != null) {
                Object object3 = defaultMutableTreeNode.getUserObject();
                if (object3 instanceof DriveGroup) {
                    if (!((DriveGroup)object3).isCompleted()) {
                        SSCPDTableToTreePanel.this.m_removeButton.setEnabled(true);
                    } else {
                        SSCPDTableToTreePanel.this.m_removeButton.setEnabled(false);
                    }
                } else if (object3 instanceof Span) {
                    // empty if block
                }
            }
        }
    }
}

