/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.configuration.supersizedcache;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.Capacity;
import GUI.venus.configuration.advanced.DGVDTreePanel;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.SASAdapter.SASAdapter;
import Services.KernelConstants;
import Utils.Resource;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SSCVDCreationPanel
extends JPanel
implements AncestorListener {
    private AdapterHelper m_adapterHelper = null;
    private AdvanceConfigEngine m_engine = null;
    private DGVDTreePanel m_dgTreePanel = null;
    private JTextField m_tfVDName = null;
    private String m_strSuggestedVDName = null;
    private SpinnerNumberModel m_capacitySpinnerModel = null;
    private JSpinner m_capacitySpinner = null;
    private UnitsComboBoxModel m_unitsComboModel = null;
    private JComboBox m_cmbBxUnits = null;
    private int m_iCurrentUnit = 3;
    private double[] m_dMaxSizeAndUnit = null;
    private double[] m_dMinSizeAndUnit = null;
    private byte m_cStripeSize = 0;
    private JComboBox m_cmbBxWritePolicy = null;
    private JLabel m_cmbBxWritePolicyDesc = new JLabel();
    private JButton m_btnCreateVirtualDrive = null;
    private JButton m_btnUpdateVirtualDrive = null;
    private JButton m_btnRemoveVirtualDrive = null;
    private DriveGroup m_selDriveGroup = null;
    private List<ChangeListener> m_changeListeners = null;
    private DriveGroupTreeSelectionListener m_dgTreeSelectionListener = null;
    MR_MFC_DEFAULTS m_objMFCDefaults = null;
    private JLabel m_capacityValueLbl = null;
    private boolean m_cachecadeWritebackSupported = false;
    Object[] m_cmbObjs = null;

    public SSCVDCreationPanel(AdvanceConfigEngine advanceConfigEngine, AdapterHelper adapterHelper) {
        this.m_engine = advanceConfigEngine;
        this.m_adapterHelper = adapterHelper;
        this.m_cachecadeWritebackSupported = adapterHelper.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCWriteBack();
        this.m_cmbObjs = !this.m_cachecadeWritebackSupported ? new Object[]{new Byte(0)} : new Object[]{new Byte(1), new Byte(0), new Byte(17)};
        byte by = this.m_engine.getLDTargetId();
        this.m_strSuggestedVDName = VivaldiStartupDialog.OEM_TYPE == 98761 ? "SSD_Caching_" + by : "CacheCade_" + by;
        this.m_engine.returnLDTargetId(by);
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_selDriveGroup = list.get(0);
        this.m_dgTreePanel = new DGVDTreePanel(this.m_adapterHelper, list, true);
        this.m_dgTreePanel.scrollPane.setPreferredSize(new Dimension(250, 250));
        this.m_dgTreePanel.getDriveGroupTree().getModel().addTreeModelListener(new DriveGroupTreeModelListener());
        this.m_dgTreeSelectionListener = new DriveGroupTreeSelectionListener();
        this.m_dgTreePanel.addTreeSelectionListener(this.m_dgTreeSelectionListener);
        SASAdapter sASAdapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        try {
            this.m_objMFCDefaults = sASAdapter.getMFCDefaults();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_cStripeSize = this.m_objMFCDefaults.getstripeSize();
        this.buildPanel();
    }

    public void initDriveGroups() {
        this.m_dgTreePanel.removeTreeSelectionListener(this.m_dgTreeSelectionListener);
        List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
        this.m_dgTreePanel.initData(list);
        this.m_dgTreePanel.addTreeSelectionListener(this.m_dgTreeSelectionListener);
        this.m_selDriveGroup = list.get(0);
        this.m_dgTreePanel.selectFirstFreeDGNode();
    }

    private void buildPanel() {
        String[] stringArray = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)new JLabel(Resource.getString("SSC_LABEL_SPECIFY_PARAMS", "Specify Parameters for the new CacheCade\u2122 Virtual Drive")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        stringArray = Resource.getResourceMnemonic(Resource.getString("SSC_LABEL_DRIVE_GROUPS", "CacheCade\u2122 Drive (g)roups:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_dgTreePanel.getDriveGroupTree());
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.getVDParamPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.m_dgTreePanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        JPanel jPanel = new JPanel(new FlowLayout(2));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CREATE_VD", "(C)reate Virtual Drive"));
        this.m_btnCreateVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnCreateVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_UPDATE_VD", "(U)pdate Virtual Drive"));
        this.m_btnUpdateVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnUpdateVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add(this.m_btnUpdateVirtualDrive);
        jPanel.add(this.m_btnCreateVirtualDrive);
        this.m_btnCreateVirtualDrive.addActionListener(new CreateVDAction());
        this.m_btnUpdateVirtualDrive.addActionListener(new UpdateVDAction());
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_VD", "(R)emove Virtual Drive"));
        this.m_btnRemoveVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnRemoveVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnRemoveVirtualDrive.addActionListener(new DeleteVDAction());
        this.add((Component)this.m_btnRemoveVirtualDrive, gridBagConstraints);
        JTree jTree = this.m_dgTreePanel.getDriveGroupTree();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof DriveGroup && ((DriveGroup)object).canAddVD()) {
            this.m_btnRemoveVirtualDrive.setEnabled(false);
            this.m_btnCreateVirtualDrive.setEnabled(true);
            this.m_btnUpdateVirtualDrive.setEnabled(false);
        } else {
            this.m_btnRemoveVirtualDrive.setEnabled(false);
            this.m_btnCreateVirtualDrive.setEnabled(false);
            this.m_btnUpdateVirtualDrive.setEnabled(false);
        }
        this.m_btnCreateVirtualDrive.addAncestorListener(this);
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (this.m_btnCreateVirtualDrive.isEnabled()) {
            this.m_btnCreateVirtualDrive.requestFocusInWindow();
        } else {
            this.m_tfVDName.requestFocusInWindow();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    private JPanel getVDParamPanel() {
        String[] stringArray = null;
        byte by = this.m_selDriveGroup.getRaidLevel();
        this.m_tfVDName = new JTextField(15);
        this.m_tfVDName.setText(this.m_strSuggestedVDName);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SSCD_NAME", "Cac(h)eCade\u2122 VD name:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_tfVDName);
        }
        JPanel jPanel = new JPanel(new FlowLayout(3));
        Capacity capacity = this.m_selDriveGroup.getCapacity();
        this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
        this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
        if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
            this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
            this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
        }
        this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
        this.m_unitsComboModel = new UnitsComboBoxModel((int)this.m_dMaxSizeAndUnit[1]);
        this.m_capacitySpinnerModel = new SpinnerNumberModel(this.m_dMaxSizeAndUnit[0], this.m_dMinSizeAndUnit[0], this.m_dMaxSizeAndUnit[0], 1.0);
        this.m_capacitySpinner = new JSpinner(this.m_capacitySpinnerModel);
        this.m_capacitySpinner.setEnabled(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CAPACITY", "Capacit(y):"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel2.setLabelFor(this.m_capacitySpinner);
        }
        this.m_cmbBxUnits = new JComboBox(this.m_unitsComboModel);
        this.m_cmbBxUnits.setRenderer(new UnitsRenderer());
        this.m_cmbBxUnits.addItemListener(new UnitsChangeItemListener());
        this.m_cmbBxUnits.setEnabled(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_UNITS", "Uni(t)s:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel3.setLabelFor(this.m_cmbBxUnits);
        }
        jPanel.add(this.m_capacitySpinner);
        jPanel.add(jLabel3);
        jPanel.add(this.m_cmbBxUnits);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridx = 0;
        int n2 = n;
        n = (byte)(n + 1);
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_tfVDName, gridBagConstraints);
        int n3 = n;
        n = (byte)(n + 1);
        gridBagConstraints.gridy = n3;
        this.m_capacityValueLbl = new JLabel(KernelConstants.getConvertedSize(this.m_selDriveGroup.getCapacity().getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize()));
        jPanel2.add((Component)this.m_capacityValueLbl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.m_cmbBxWritePolicy = new JComboBox();
        if (this.m_cachecadeWritebackSupported) {
            if (by == 0) {
                this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[0]);
                this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[1]);
            } else {
                this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[0]);
                this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[1]);
                this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[2]);
            }
        } else {
            this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[0]);
        }
        this.m_cmbBxWritePolicy.setEnabled(this.m_cachecadeWritebackSupported);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_WRITE_POLICY", "(W)rite policy:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel4.setLabelFor(this.m_cmbBxWritePolicy);
        }
        this.m_cmbBxWritePolicy.setRenderer(new LDWritePolicyRenderer());
        this.m_cmbBxWritePolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SSCVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem() == null) {
                    return;
                }
                byte by = (Byte)SSCVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                String string = null;
                if (by == 0) {
                    string = Resource.getString("CACHECADE_WRITE_THROUGH_SELECTED_DESC", "<html>Write Through means that the cache can only be used for reads.    <br>It will not support any writes.</html>");
                } else if (by == 17) {
                    string = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK_SELECTED_DESC", "<html>Always Write Back means that the cache can be used for both<br>read and write I/O,even if the CacheCade\u2122 Virtual Drive<br>enters into a degraded state (risking data loss).</html>");
                } else if (by == 1) {
                    string = SSCVDCreationPanel.this.m_selDriveGroup.getRaidLevel() == 0 ? Resource.getString("CACHECADE_WRITE_BACK_SELECTED_R0_DESC", "<html>Write Back means that the cache can be used for both read and<br>write I/O.</html>") : Resource.getString("CACHECADE_WRITE_BACK_SELECTED_DESC", "<html>Write Back means that the cache can be used for both read and<br>write I/O.<br><br>Important: If the CacheCade\u2122 Virtual Drive becomes degraded,<br>the policy may temporarily change to read-only.</html>");
                }
                SSCVDCreationPanel.this.m_cmbBxWritePolicyDesc.setText(string);
            }
        });
        if (this.m_cachecadeWritebackSupported && by == 0) {
            this.m_cmbBxWritePolicy.setSelectedIndex(1);
        } else {
            this.m_cmbBxWritePolicy.setSelectedIndex(0);
        }
        int n4 = n;
        n = (byte)(n + 1);
        gridBagConstraints.gridy = n4;
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.m_cmbBxWritePolicy, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        int n5 = n;
        n = (byte)(n + 1);
        gridBagConstraints.gridy = n5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.m_cmbBxWritePolicyDesc, gridBagConstraints);
        return jPanel2;
    }

    private void resetVDPanelToSelectedDriveGroup() {
        if (this.m_engine.canAddNewVirtualDrive() && this.m_dgTreePanel.canCreateSSCD()) {
            this.m_tfVDName.setEnabled(true);
            this.m_cmbBxWritePolicy.setEnabled(true);
            byte by = this.m_engine.getLDTargetId();
            this.m_strSuggestedVDName = VivaldiStartupDialog.OEM_TYPE == 98761 ? "SSD_Caching_" + by : "CacheCade_" + by;
            this.m_engine.returnLDTargetId(by);
            this.m_tfVDName.setText(this.m_strSuggestedVDName);
        } else {
            this.m_tfVDName.setText("");
            this.m_tfVDName.setEnabled(false);
            this.m_cmbBxWritePolicy.setEnabled(false);
        }
        if (!this.m_cachecadeWritebackSupported) {
            this.m_cmbBxWritePolicy.setEnabled(false);
        }
        if (this.m_engine.canAddNewVirtualDrive() && this.m_selDriveGroup.canAddVD()) {
            Capacity capacity = this.m_selDriveGroup.getCapacity();
            this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
            this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
            if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            }
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(this.m_selDriveGroup.getCapacity().getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize()));
            this.m_unitsComboModel.setUnit((int)this.m_dMaxSizeAndUnit[1]);
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            this.m_unitsComboModel.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setValue(this.m_dMaxSizeAndUnit[0]);
        } else {
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(this.m_selDriveGroup.getCapacity().getMaxSizeInBlocks(), this.m_selDriveGroup.getBlockSize()));
            this.m_btnCreateVirtualDrive.setEnabled(false);
        }
    }

    private void resetVDPanelToVirtualDrive(VirtualDrive virtualDrive) {
        this.m_tfVDName.setText(virtualDrive.getName());
        this.m_cmbBxWritePolicy.setSelectedItem(virtualDrive.getWritePolicy());
        long l = virtualDrive.getSize();
        double[] dArray = KernelConstants.getSizeAndUnit(l, this.m_selDriveGroup.getBlockSize());
        Capacity capacity = virtualDrive.getDriveGroup().getCapacity();
        this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks(), this.m_selDriveGroup.getBlockSize());
        if (capacity.getMaxSizeInBlocks() != 0L) {
            this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks() + virtualDrive.getSize(), this.m_selDriveGroup.getBlockSize());
            int n = (int)this.m_dMaxSizeAndUnit[1];
            if (dArray[1] == this.m_dMinSizeAndUnit[1]) {
                this.m_dMaxSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMaxSizeAndUnit[0], (int)this.m_dMaxSizeAndUnit[1], (int)this.m_dMinSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMaxSizeAndUnit[1] = this.m_dMinSizeAndUnit[1];
            } else if (dArray[1] == this.m_dMaxSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            } else {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)dArray[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMaxSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMaxSizeAndUnit[0], (int)this.m_dMaxSizeAndUnit[1], (int)dArray[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = dArray[1];
                this.m_dMaxSizeAndUnit[1] = dArray[1];
            }
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(l, this.m_selDriveGroup.getBlockSize()));
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            double d = KernelConstants.getSizeInSpecifiedUnit(dArray[0], (int)dArray[1], n, this.m_selDriveGroup.getBlockSize());
            if (d == 0.0) {
                --n;
            }
            this.m_unitsComboModel.setUnit(n);
            this.m_cmbBxUnits.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setValue(dArray[0]);
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
        } else {
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(l, this.m_selDriveGroup.getBlockSize()));
            this.m_dMaxSizeAndUnit[0] = dArray[0];
            this.m_dMaxSizeAndUnit[1] = dArray[1];
            if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1], this.m_selDriveGroup.getBlockSize());
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            }
            int n = (int)this.m_dMaxSizeAndUnit[1];
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            this.m_unitsComboModel.setUnit(n);
            this.m_cmbBxUnits.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setValue(dArray[0]);
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
        }
    }

    private void resetPanel() {
        this.m_tfVDName.setText("");
        this.m_tfVDName.setEnabled(false);
        this.m_cmbBxWritePolicy.setEnabled(false);
        this.m_cmbBxWritePolicy.setSelectedIndex(0);
        this.m_capacitySpinnerModel.setValue(0);
        this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(0.0));
    }

    private void generateChangeEvent() {
        if (this.m_changeListeners != null) {
            for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                this.m_changeListeners.get(i).stateChanged(new ChangeEvent(new Boolean(this.isVDsAvailable())));
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new ArrayList<ChangeListener>();
        }
        this.m_changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.m_changeListeners == null || !this.m_changeListeners.contains(changeListener)) {
            return;
        }
        this.m_changeListeners.remove(changeListener);
    }

    public void cleanUp() {
        if (this.m_dgTreePanel != null) {
            this.m_dgTreePanel.removeTreeSelectionListener(this.m_dgTreeSelectionListener);
        }
    }

    public boolean isVDsAvailable() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_dgTreePanel.getDriveGroupTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
            List<VirtualDrive> list = driveGroup.getVirtualDrives();
            if (list == null || list.isEmpty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public JButton getDefaultButton() {
        return this.m_btnCreateVirtualDrive;
    }

    class LDWritePolicyRenderer
    extends DefaultListCellRenderer {
        LDWritePolicyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            if (object != null) {
                byte by = (Byte)object;
                if (by == 0) {
                    string = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                } else if (by == 17) {
                    string = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back");
                } else if (by == 1) {
                    string = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                }
                jLabel.setText(string);
            }
            return jLabel;
        }
    }

    class UnitsChangeItemListener
    implements ItemListener {
        UnitsChangeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            double d;
            int n;
            if (SSCVDCreationPanel.this.m_cmbBxUnits.getSelectedIndex() != -1 && (n = ((Integer)itemEvent.getItem()).intValue()) != SSCVDCreationPanel.this.m_iCurrentUnit && (d = Double.parseDouble(SSCVDCreationPanel.this.m_capacitySpinner.getValue() + "")) > 0.0) {
                double d2 = KernelConstants.getSizeInSpecifiedUnit(d, SSCVDCreationPanel.this.m_iCurrentUnit, n, SSCVDCreationPanel.this.m_selDriveGroup.getBlockSize());
                double d3 = KernelConstants.getSizeInSpecifiedUnit(SSCVDCreationPanel.this.m_dMinSizeAndUnit[0], (int)SSCVDCreationPanel.this.m_dMinSizeAndUnit[1], n, SSCVDCreationPanel.this.m_selDriveGroup.getBlockSize());
                double d4 = KernelConstants.getSizeInSpecifiedUnit(SSCVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)SSCVDCreationPanel.this.m_dMaxSizeAndUnit[1], n, SSCVDCreationPanel.this.m_selDriveGroup.getBlockSize());
                ((SSCVDCreationPanel)SSCVDCreationPanel.this).m_dMinSizeAndUnit[0] = d3;
                ((SSCVDCreationPanel)SSCVDCreationPanel.this).m_dMaxSizeAndUnit[0] = d4;
                ((SSCVDCreationPanel)SSCVDCreationPanel.this).m_dMaxSizeAndUnit[1] = n;
                ((SSCVDCreationPanel)SSCVDCreationPanel.this).m_dMinSizeAndUnit[1] = n;
                SSCVDCreationPanel.this.m_capacitySpinnerModel.setValue(d2);
                SSCVDCreationPanel.this.m_capacitySpinnerModel.setMaximum(Double.valueOf(SSCVDCreationPanel.this.m_dMaxSizeAndUnit[0]));
                SSCVDCreationPanel.this.m_capacitySpinnerModel.setMinimum(Double.valueOf(SSCVDCreationPanel.this.m_dMinSizeAndUnit[0]));
                SSCVDCreationPanel.this.m_iCurrentUnit = n;
            }
        }
    }

    class DeleteVDAction
    implements ActionListener {
        DeleteVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = SSCVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            VirtualDrive virtualDrive = (VirtualDrive)defaultMutableTreeNode.getUserObject();
            SSCVDCreationPanel.this.m_engine.returnLDTargetId(virtualDrive.getTargetId());
            DriveGroup driveGroup = (DriveGroup)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            driveGroup.removeVirtualDrive(virtualDrive);
            SSCVDCreationPanel.this.m_dgTreePanel.removeCurrentlySelectedVirtualDrive();
        }
    }

    class UpdateVDAction
    implements ActionListener {
        UpdateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            Object object;
            Object object2;
            if (((SASAdapter)SSCVDCreationPanel.this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                byte by = (Byte)SSCVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                object2 = null;
                object = null;
                if (by == 17) {
                    object2 = Resource.getString("TITLE_CACHECADE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                    object = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK_SELECTED_WARNING", "<html>Always Write Back means that the cache can be used for both read and write I/O,<br>even if the CacheCade\u2122 Virtual Drive enters into a degraded state (risking data loss).<br><br>Are you sure you want to select Always Write Back mode?<br><br></html>");
                    if (JOptionPane.showConfirmDialog(null, object, (String)object2, 0, 2) != 0) {
                        return;
                    }
                } else if (((VirtualDrive)((DefaultMutableTreeNode)SSCVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree().getLeadSelectionPath().getLastPathComponent()).getUserObject()).getDriveGroup().getRaidLevel() == 0 && by == 1) {
                    object2 = Resource.getString("TITLE_CACHECADE_WRITE_BACK_SELECTED", "Write Back Selected");
                    object = Resource.getString("CACHECADE_WRITE_BACK_SELECTED_WARNING", "<html>Selecting Write Back policy for RAID 0 CacheCade\u2122 SSD-Caching Virtual Drive,<br>may result in data loss, if any of the participating SSD drives fail.<br><br>Are you sure you want to proceed?<br><br></html>");
                    if (JOptionPane.showConfirmDialog(null, object, (String)object2, 0, 2) != 0) {
                        return;
                    }
                }
            }
            JTree jTree = SSCVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            object2 = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            object = (VirtualDrive)((DefaultMutableTreeNode)object2).getUserObject();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            long l2 = ((VirtualDrive)object).getSize();
            String string = SSCVDCreationPanel.this.m_tfVDName.getText().trim();
            if (string.length() == 0) {
                if (VivaldiStartupDialog.OEM_TYPE == 98761) {
                    SSCVDCreationPanel.this.m_strSuggestedVDName = "SSD_Caching_" + ((VirtualDrive)object).getTargetId();
                } else {
                    SSCVDCreationPanel.this.m_strSuggestedVDName = "CacheCade_" + ((VirtualDrive)object).getTargetId();
                }
            }
            ((VirtualDrive)object).setName(string);
            double[] dArray = KernelConstants.getSizeAndUnit(l2, SSCVDCreationPanel.this.m_selDriveGroup.getBlockSize());
            double d = Double.parseDouble(SSCVDCreationPanel.this.m_capacitySpinner.getValue() + "");
            double d2 = ((Integer)SSCVDCreationPanel.this.m_cmbBxUnits.getSelectedItem()).intValue();
            long l3 = KernelConstants.getSizeInBlocks(d, (int)d2, driveGroup.getBlockSize());
            if (dArray[1] != d2) {
                dArray[0] = KernelConstants.getSizeInSpecifiedUnit(dArray[0], (int)dArray[1], (int)d2, SSCVDCreationPanel.this.m_selDriveGroup.getBlockSize());
                dArray[1] = d2;
                if (driveGroup.getFreeSizeInBlocks() != 0L) {
                    long l4 = KernelConstants.getSizeInBlocks(SSCVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)SSCVDCreationPanel.this.m_dMaxSizeAndUnit[1], driveGroup.getBlockSize());
                    if (l3 == l4) {
                        l3 = driveGroup.getFreeSizeInBlocks() + l2;
                    }
                } else if (d == dArray[0]) {
                    l3 = l2;
                }
            } else if (d == dArray[0]) {
                l3 = l2;
            } else if (driveGroup.getFreeSizeInBlocks() != 0L && l3 == (l = KernelConstants.getSizeInBlocks(SSCVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)SSCVDCreationPanel.this.m_dMaxSizeAndUnit[1], driveGroup.getBlockSize()))) {
                l3 = driveGroup.getFreeSizeInBlocks() + l2;
            }
            if (l3 != l2) {
                ((VirtualDrive)object).setSize(l3);
            }
            ((VirtualDrive)object).setWritePolicy((Byte)SSCVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem());
            if (l2 != l3) {
                driveGroup.updateVirtualDrive((VirtualDrive)object, l2);
            }
            SSCVDCreationPanel.this.m_dgTreePanel.updateCurrentlySelectedVirtualDrive();
        }
    }

    class CreateVDAction
    implements ActionListener {
        CreateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            if (((SASAdapter)SSCVDCreationPanel.this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
                byte by = (Byte)SSCVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                object2 = null;
                object = null;
                if (by == 17) {
                    object2 = Resource.getString("TITLE_CACHECADE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                    object = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK_SELECTED_WARNING", "<html>Always Write Back means that the cache can be used for both read and write I/O,<br>even if the CacheCade\u2122 Virtual Drive enters into a degraded state (risking data loss).<br><br>Are you sure you want to select Always Write Back mode?<br><br></html>");
                    if (JOptionPane.showConfirmDialog(null, object, (String)object2, 0, 2) != 0) {
                        return;
                    }
                } else if (((DriveGroup)((DefaultMutableTreeNode)SSCVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree().getLeadSelectionPath().getLastPathComponent()).getUserObject()).getRaidLevel() == 0 && by == 1) {
                    object2 = Resource.getString("TITLE_CACHECADE_WRITE_BACK_SELECTED", "Write Back Selected");
                    object = Resource.getString("CACHECADE_WRITE_BACK_SELECTED_WARNING", "<html>Selecting Write Back policy for RAID 0 CacheCade\u2122 SSD-Caching Virtual Drive,<br>may result in data loss, if any of the participating SSD drives fail.<br><br>Are you sure you want to proceed?<br><br></html>");
                    if (JOptionPane.showConfirmDialog(null, object, (String)object2, 0, 2) != 0) {
                        return;
                    }
                }
            }
            JTree jTree = SSCVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            object2 = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            object = (DriveGroup)((DefaultMutableTreeNode)object2).getUserObject();
            double d = Double.parseDouble(SSCVDCreationPanel.this.m_capacitySpinner.getValue() + "");
            long l = KernelConstants.getSizeInBlocks(d, (Integer)SSCVDCreationPanel.this.m_cmbBxUnits.getSelectedItem(), ((DriveGroup)object).getBlockSize());
            if (l == KernelConstants.getSizeInBlocks(SSCVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)SSCVDCreationPanel.this.m_dMaxSizeAndUnit[1], ((DriveGroup)object).getBlockSize())) {
                l = ((DriveGroup)object).getFreeSizeInBlocks();
            }
            byte by = SSCVDCreationPanel.this.m_engine.getLDTargetId();
            String string = SSCVDCreationPanel.this.m_tfVDName.getText().trim();
            if (string.length() == 0) {
                string = SSCVDCreationPanel.this.m_strSuggestedVDName;
            }
            if (string.length() > 15) {
                string = string.substring(0, 15);
            }
            VirtualDrive virtualDrive = new VirtualDrive((DriveGroup)object, by, l, string, SSCVDCreationPanel.this.m_cStripeSize);
            virtualDrive.setWritePolicy((Byte)SSCVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem());
            ((DriveGroup)object).addVirtualDrive(virtualDrive);
            SSCVDCreationPanel.this.m_dgTreePanel.updateCurrentlySelectedVirtualDrive();
            SSCVDCreationPanel.this.m_dgTreePanel.addVirtualDrive((DefaultMutableTreeNode)object2, virtualDrive);
            SSCVDCreationPanel.this.resetVDPanelToSelectedDriveGroup();
        }
    }

    class DriveGroupTreeSelectionListener
    implements TreeSelectionListener {
        DriveGroupTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof DriveGroup) {
                if (SSCVDCreationPanel.this.m_engine.canAddNewVirtualDrive() && ((DriveGroup)object).canAddVD()) {
                    SSCVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(true);
                    SSCVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                    SSCVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                    SSCVDCreationPanel.this.m_selDriveGroup = (DriveGroup)object;
                    if (SSCVDCreationPanel.this.m_cachecadeWritebackSupported) {
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.removeAllItems();
                        if (SSCVDCreationPanel.this.m_selDriveGroup.getRaidLevel() == 0) {
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[0]);
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[1]);
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(1);
                        } else {
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[0]);
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[1]);
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[2]);
                            SSCVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(0);
                        }
                    }
                    SSCVDCreationPanel.this.m_cmbBxWritePolicy.setEnabled(SSCVDCreationPanel.this.m_cachecadeWritebackSupported);
                    SSCVDCreationPanel.this.resetVDPanelToSelectedDriveGroup();
                } else {
                    SSCVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                    SSCVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                    SSCVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                    SSCVDCreationPanel.this.m_selDriveGroup = (DriveGroup)object;
                    SSCVDCreationPanel.this.resetPanel();
                }
            } else if (object instanceof VirtualDrive) {
                SSCVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                SSCVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(true);
                SSCVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(true);
                SSCVDCreationPanel.this.m_selDriveGroup = ((VirtualDrive)object).getDriveGroup();
                SSCVDCreationPanel.this.m_tfVDName.setEnabled(true);
                VirtualDrive virtualDrive = (VirtualDrive)object;
                if (SSCVDCreationPanel.this.m_cachecadeWritebackSupported) {
                    SSCVDCreationPanel.this.m_cmbBxWritePolicy.removeAllItems();
                    if (virtualDrive.getDriveGroup().getRaidLevel() == 0) {
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[0]);
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[1]);
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(1);
                    } else {
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[0]);
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[1]);
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.addItem(SSCVDCreationPanel.this.m_cmbObjs[2]);
                        SSCVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(0);
                    }
                }
                SSCVDCreationPanel.this.m_cmbBxWritePolicy.setEnabled(SSCVDCreationPanel.this.m_cachecadeWritebackSupported);
                SSCVDCreationPanel.this.resetVDPanelToVirtualDrive(virtualDrive);
            } else {
                SSCVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                SSCVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                SSCVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                SSCVDCreationPanel.this.resetPanel();
            }
        }
    }

    class DriveGroupTreeModelListener
    implements TreeModelListener {
        DriveGroupTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            SSCVDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            SSCVDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            SSCVDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            SSCVDCreationPanel.this.generateChangeEvent();
        }
    }
}

