/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.wizard;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.venus.wizard.IWizardPage;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import Utils.CustomJOptionDialog;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class DefaultWizardPage
extends VivaldiBaseDialog
implements IWizardPage,
ActionListener {
    protected String m_strDesc = null;
    protected HashMap m_hmWizardData = null;
    protected WizardController m_WizardController = null;
    protected boolean m_isFinishWizardPage = false;
    private boolean m_isStartWizardPage = false;
    protected int m_iTrigger = 0;
    public boolean m_iMRpresent = false;
    protected String m_strHelpFileName = "MR_SNAPSHOT_REPOSITORY";
    protected String m_strHelpPage = "MR_SNAPSHOT_REPOSITORY";
    private JButton m_btnNext = null;
    private JButton m_btnBack = null;
    private JButton m_btnCancel = null;
    private JButton m_btnHelp = null;
    private boolean m_nextButtonState = true;
    private boolean m_isPageVisited = false;
    private JButton m_btnDefault = null;
    public static final String WARNING_DIALOG_TITLE = "WarningDialogTitle";
    private String m_strWarningDialogTitle = null;

    @Override
    public abstract JPanel getContentPanel();

    @Override
    public abstract String getPageID();

    @Override
    public abstract String getTitle();

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpPage);
    }

    @Override
    public void showWizardPage() {
        if (!this.m_isPageVisited) {
            String[] stringArray = null;
            JPanel jPanel = new JPanel(new FlowLayout(2));
            String string = Resource.getString("BUTTON_CANCEL_TEXT", "Cancel");
            this.m_btnCancel = new JButton(string);
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_BACK_TEXT", "< (B)ack"));
            this.m_btnBack = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnBack.setMnemonic(stringArray[1].charAt(0));
            }
            stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_HELP_TEXT", "(H)elp"));
            this.m_btnHelp = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnHelp.setMnemonic(stringArray[1].charAt(0));
            }
            this.m_btnHelp.addActionListener(this);
            stringArray = this.m_isFinishWizardPage ? Resource.getResourceMnemonic(Resource.getString("BUTTON_FINISH_TEXT", "(F)inish")) : Resource.getResourceMnemonic(Resource.getString("BUTTON_NEXT_TEXT", "(N)ext >"));
            this.m_btnNext = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnNext.setMnemonic(stringArray[1].charAt(0));
            }
            this.m_btnNext.setEnabled(this.m_nextButtonState);
            this.getRootPane().setDefaultButton(this.m_btnNext);
            jPanel.add(this.m_btnCancel);
            this.m_btnCancel.addActionListener(this);
            if (!this.m_isStartWizardPage) {
                jPanel.add(this.m_btnBack);
                this.m_btnBack.addActionListener(this);
            }
            jPanel.add(this.m_btnNext);
            jPanel.add(this.m_btnHelp);
            this.m_btnNext.addActionListener(this);
            this.contentPane.add((Component)this.getContentPanel(), "Center");
            this.contentPane.add((Component)jPanel, "South");
            this.m_isPageVisited = true;
            this.setResizable(false);
            this.setModal(true);
        }
        this.setTitle(this.getTitle());
        if (this.m_btnDefault != null) {
            this.getRootPane().setDefaultButton(this.m_btnDefault);
        } else {
            this.getRootPane().setDefaultButton(this.m_btnNext);
        }
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public String getDescription() {
        return this.m_strDesc;
    }

    @Override
    public HashMap getwizardData() {
        return this.m_hmWizardData;
    }

    @Override
    public void init(HashMap hashMap) {
        this.m_hmWizardData = hashMap;
        this.m_WizardController = (WizardController)this.m_hmWizardData.get("WizardController");
        this.reinitialise();
    }

    protected void reinitialise() {
    }

    @Override
    public void onBack() {
        this.dispose();
        try {
            this.m_WizardController.showPreviousPage();
        }
        catch (WizardNavigationException wizardNavigationException) {
            wizardNavigationException.printStackTrace();
        }
    }

    @Override
    public void onNext() {
        if (!this.m_isFinishWizardPage) {
            try {
                if (this.m_iTrigger != -1) {
                    this.dispose();
                    this.m_WizardController.showNextPage(this.m_iTrigger);
                }
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
        } else {
            this.dispose();
            this.m_WizardController.cleanUp();
        }
    }

    @Override
    public void onCancel() {
        if (this.warningDialog()) {
            this.dispose();
            this.m_WizardController.cleanUp();
        }
    }

    @Override
    public void cleanUp() {
        this.dispose();
    }

    @Override
    public void onHelp() {
        HelpContext.executeHelpProcess(HelpContextResourse.getHelpPageName(this.m_strHelpFileName));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_btnBack)) {
            this.onBack();
        } else if (actionEvent.getSource().equals(this.m_btnNext)) {
            this.onNext();
        } else if (actionEvent.getSource().equals(this.m_btnCancel)) {
            this.onCancel();
        } else if (actionEvent.getSource().equals(this.m_btnHelp)) {
            this.onHelp();
        }
    }

    public void setNextButtonStatus(boolean bl) {
        this.m_nextButtonState = bl;
        if (this.m_btnNext != null) {
            this.m_btnNext.setEnabled(this.m_nextButtonState);
        }
    }

    public void setDefaultButton(JButton jButton) {
        this.m_btnDefault = jButton;
    }

    @Override
    public void setAsFirstPage(boolean bl) {
        this.m_isStartWizardPage = bl;
    }

    @Override
    protected boolean warningDialog() {
        Image image;
        String string;
        CustomJOptionDialog customJOptionDialog;
        Integer n;
        if (this.m_strWarningDialogTitle == null && this.m_hmWizardData.containsKey(WARNING_DIALOG_TITLE)) {
            this.m_strWarningDialogTitle = this.m_hmWizardData.get(WARNING_DIALOG_TITLE).toString();
        }
        return (n = Integer.valueOf((customJOptionDialog = new CustomJOptionDialog(string = this.m_strWarningDialogTitle != null && this.m_strWarningDialogTitle.length() > 0 ? this.m_strWarningDialogTitle : VivaldiStartupDialog.FRAME_TITLE, image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png")), Resource.getString("CONFIG_CANCEL_MSG", "Are you sure you want to close this wizard?"), 3, 0, 1)).showDialog())) instanceof Integer && n == 0;
    }
}

