/*
 * Decompiled with CFR 0.152.
 */
package GUI.venus.wizard;

import GUI.venus.wizard.IWizardPage;
import GUI.venus.wizard.WizardNavigationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class WizardController {
    public static final String WIZARD_CONTROLLER = "WizardController";
    private HashMap m_hmPageIdClassName = null;
    private HashMap m_hmVisitedPageMap = null;
    private HashMap m_hmPageTransitionMap = new HashMap();
    private HashMap m_hmPreviousPageCache = null;
    private String m_strFirstPageId = null;
    private HashMap m_hmWizardData = null;
    private String m_strCurrentPage = null;

    public WizardController() {
        this.m_hmPageIdClassName = new HashMap();
        this.m_hmVisitedPageMap = new HashMap();
        this.m_hmPreviousPageCache = new HashMap();
        this.m_hmWizardData = new HashMap();
        this.m_hmWizardData.put(WIZARD_CONTROLLER, this);
    }

    public void addPage(String string, String string2) throws WizardNavigationException {
        if (this.m_hmPageIdClassName.containsKey(string2)) {
            throw new WizardNavigationException("Duplicate Page ID found.");
        }
        this.m_hmPageIdClassName.put(string2, string);
    }

    public void addPageTransition(String string, int n, String string2) {
        if (this.m_hmPageTransitionMap.containsKey(string)) {
            PageMap pageMap = new PageMap(n, string2);
            ArrayList arrayList = (ArrayList)this.m_hmPageTransitionMap.get(string);
            arrayList.add(pageMap);
            this.m_hmPageTransitionMap.put(string, arrayList);
        } else {
            PageMap pageMap = new PageMap(n, string2);
            ArrayList<PageMap> arrayList = new ArrayList<PageMap>();
            arrayList.add(pageMap);
            this.m_hmPageTransitionMap.put(string, arrayList);
        }
    }

    public void setFirstPage(String string) {
        this.m_strFirstPageId = string;
    }

    public void launchWizard() throws WizardNavigationException {
        if (this.m_strFirstPageId == null || this.m_strFirstPageId.length() == 0) {
            throw new WizardNavigationException("First page is not set.");
        }
        if (this.m_hmPageIdClassName == null || !this.m_hmPageIdClassName.containsKey(this.m_strFirstPageId)) {
            throw new WizardNavigationException("Page navigations not set correctly.");
        }
        this.loadAndShowPage(this.m_strFirstPageId);
    }

    public void showNextPage(int n) throws WizardNavigationException {
        PageMap pageMap = null;
        ArrayList arrayList = (ArrayList)this.m_hmPageTransitionMap.get(this.m_strCurrentPage);
        for (int i = 0; i < arrayList.size() && (pageMap = (PageMap)arrayList.get(i)).getTrigger() != n; ++i) {
        }
        if (pageMap == null) {
            throw new WizardNavigationException("Page Navigation Error.");
        }
        this.m_hmPreviousPageCache.put(pageMap.getNextPageID(), this.m_strCurrentPage);
        this.loadAndShowPage(pageMap.getNextPageID());
    }

    public void showPreviousPage() throws WizardNavigationException {
        if (this.m_strCurrentPage.equals(this.m_strFirstPageId) || !this.m_hmPreviousPageCache.containsKey(this.m_strCurrentPage)) {
            throw new WizardNavigationException("Page Transition fails.");
        }
        String string = this.m_hmPreviousPageCache.get(this.m_strCurrentPage).toString();
        this.m_hmPreviousPageCache.remove(this.m_strCurrentPage);
        this.loadAndShowPage(string);
    }

    public void cleanUp() {
        Set set = this.m_hmVisitedPageMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IWizardPage iWizardPage = (IWizardPage)this.m_hmVisitedPageMap.get(iterator.next());
            iWizardPage.cleanUp();
        }
    }

    public HashMap getWizardData() {
        return this.m_hmWizardData;
    }

    private void loadAndShowPage(String string) throws WizardNavigationException {
        try {
            if (this.m_hmVisitedPageMap.containsKey(string)) {
                IWizardPage iWizardPage = (IWizardPage)this.m_hmVisitedPageMap.get(string);
                this.m_strCurrentPage = string;
                iWizardPage.init(this.m_hmWizardData);
                iWizardPage.showWizardPage();
            } else {
                String string2 = this.m_hmPageIdClassName.get(string).toString();
                Class<?> clazz = Class.forName(string2);
                IWizardPage iWizardPage = (IWizardPage)clazz.newInstance();
                this.m_strCurrentPage = string;
                this.m_hmVisitedPageMap.put(this.m_strCurrentPage, iWizardPage);
                if (string.equals(this.m_strFirstPageId)) {
                    iWizardPage.setAsFirstPage(true);
                }
                iWizardPage.init(this.m_hmWizardData);
                iWizardPage.showWizardPage();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new WizardNavigationException("First Wizard Page class is not found. Possibly class name is incorrect.", classNotFoundException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new WizardNavigationException("Exception while loading the first page.", exception);
        }
    }

    private class PageMap {
        private int m_iTrigger = 0;
        private String m_strNextPageID = null;

        public PageMap(int n, String string) {
            this.m_iTrigger = n;
            this.m_strNextPageID = string;
        }

        public int getTrigger() {
            return this.m_iTrigger;
        }

        public String getNextPageID() {
            return this.m_strNextPageID;
        }
    }
}

