/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.PremiumFeatures.PFKeyController;
import GUI.PreservedCache.ManagePreservedCacheDialog;
import GUI.PreservedCache.PreservedCachePresent;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.ArrayHelper;
import GUIHelper.BBUHelper;
import GUIHelper.CDROMHelper;
import GUIHelper.CapacityHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.ExpanderHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PeerServerLdHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.PortHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import GUIHelper.ServerObjectHelper;
import GUIHelper.TapeHelper;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IRConfigHelper.IRConfigEngine;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.ADV_SYSTEM_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_CC_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_LOCK_KEY_PARAMS;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_DRV_DRIVER_VERSION;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_FLASH_COMP_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_ALLOWED_OPS_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_TARGETID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_MFG;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PD_PROGRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PR_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_PR_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_MUX_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_PHY_CONNECTION;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_PHY_CONNECTIONS;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_END_DEVICE_NODE_T;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_EXPANDER_NODE_T;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_GENERIC_NODE;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_HEAD_NODE_T;
import SASKernel.LibraryAPI.StoreLib.adapterOperations_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.cluster_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.deviceInterface_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASAdapter.SASBatteryBackUp;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASCDROM;
import SASKernel.SASPhysical.SASEnclosure;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASPhysical.SASTape;
import SASKernel.SASServer;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;
import Snapshot.SnapshotMissedLDsDetailpanel;
import Topology.TopologyHelper;
import Utils.CustomMsgBox;
import Utils.LastScreenPosition;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class AdapterHelper
extends Observable
implements GUIHelperInterface {
    private SASAdapter adapter;
    private MR_CTRL_PROP adapterProperties;
    private MR_CTRL_INFO adapterInfo;
    private ServerObjectHelper parent;
    private PhysicalDriveHelper[] pdHelpers = new PhysicalDriveHelper[0];
    private LogicalDriveHelper[] ldHelpers = new LogicalDriveHelper[0];
    private EnclosureHelper[] encHelpers = new EnclosureHelper[0];
    private PeerServerLdHelper[] peerServerLdHelper = new PeerServerLdHelper[0];
    private ArrayHelper[] arrayHelpers = null;
    private BBUHelper bbuHelper = null;
    private PortHelper[] portHelpers = new PortHelper[0];
    private ArrayList peerLdArrayList = null;
    private TopologyHelper head = null;
    private boolean dirty = false;
    private CDROMHelper[] cdromHelper = new CDROMHelper[0];
    private TapeHelper[] tapeHelper = new TapeHelper[0];
    public static final int[] FW_HEADER_LOCATION = new int[]{0, 32, 65408, 130944};
    public static final String FW_FILE_HEADER_NAME = "APP";
    public final int FW_CHECKWORD_DOBSON = 843206468;
    public final int FW_CHECKWORD_VEGA_ZCR = 843338326;
    public final int FW_CHECKWORD_1078 = 943140913;
    public final int FW_CHECKWORD_2108 = 942682418;
    public short MAX_LOGICAL_DRIVES;
    public short MAX_ARRAYS;
    public short MAX_ROW_SIZE;
    public short MIN_ROW_SIZE;
    public short MAX_LDS_PER_ARRAY;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Controller");
    private BaseConfigEngine m_configEngine = null;
    MR_DRV_DRIVER_VERSION m_drvDriverVersion = null;
    public int[][] phySpeed = new int[8][2];
    private String m_dashboardStatusString = "";
    private String m_dashboardStatusIcon = "";
    private boolean m_isControllerOptimal = false;
    private PFKeyController m_pfkeyHandle = null;
    byte[] m_associatedLdIds = null;
    private boolean m_isSSCEnabled = false;
    List mismatchReasons = null;
    private boolean m_isWarhawk = false;
    private String m_strCDevCapacity = null;
    public static boolean displayed = false;

    public AdapterHelper(SASAdapter sASAdapter, ServerObjectHelper serverObjectHelper) {
        this.adapter = sASAdapter;
        this.parent = serverObjectHelper;
        this.getAdapterProperties();
        this.init();
        if (!this.adapter.isMRApiIncompatible()) {
            sASAdapter.addObserver(this);
        }
        this.m_isSSCEnabled = this.adapterInfo.getMaxSSCsize() > 0;
        this.m_isWarhawk = this.adapter.isWarhawk();
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.adapter;
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer(Resource.zeroTrim(this.adapter.getInformation().getproductName()));
        if (this.adapter.getPciInformation() != null) {
            if (this.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().getHeadLessMode() == 1) {
                stringBuffer.append(Resource.getString("BUS", "(Bus ") + this.adapter.getPciInformation().getbusNumber() + Resource.getString("DEV", ",Dev ") + this.adapter.getPciInformation().getdeviceNumber() + ")" + Resource.getString("SAFE_MODE_TXT", "(Safe Mode)"));
            } else {
                stringBuffer.append(Resource.getString("BUS", "(Bus ") + this.adapter.getPciInformation().getbusNumber() + Resource.getString("DEV", ",Dev ") + this.adapter.getPciInformation().getdeviceNumber() + ")");
            }
        }
        return stringBuffer.toString();
    }

    public PhysicalDriveHelper[] getGlobalSpares() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 2 || !PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equalsIgnoreCase(Resource.getString("PD_STATE_HOTSPARE_GLOBAL", "Global")) || PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equals("")) continue;
            arrayList.add(physicalDriveHelperArray[i]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        PhysicalDriveHelper[] physicalDriveHelperArray2 = new PhysicalDriveHelper[arrayList.size()];
        for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
            physicalDriveHelperArray2[i] = (PhysicalDriveHelper)arrayList.get(i);
        }
        return physicalDriveHelperArray2;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isSecuritySupported()) {
            if (this.isLockKeyAssigned()) {
                return this.getImageIcon(Resource.getString("CONTROLLER_LOCK_IMAGE", "controller_lock.png"));
            }
            return this.getImageIcon(Resource.getString("CONTROLLER_UNLOCK_IMAGE", "controller_unlock.png"));
        }
        return this.getImageIcon(Resource.getString("CONTROLLER_STANDARD_IMAGE", "controller_standard.png"));
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    public String getDashboardStatusString() {
        return this.m_dashboardStatusString;
    }

    public String getDashboardStatusIcon() {
        return this.m_dashboardStatusIcon;
    }

    @Override
    public ArrayList<OperationDetails> getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        if (this.adapter.isMRApiIncompatible()) {
            return arrayList;
        }
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            int n = this.adapter.getInformation().getadapterOperationsEx_MR_CTRL_INFO().getSupportSetLinkSpeed();
            if (n == 0 && menuItemObj2.getSLCmdInt() == 0x7010000) continue;
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                this.addOperation(arrayList, operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                if (operationDetails.getOpcode() == 3) {
                    if (this.adapter.isWarhawk()) {
                        if (operationDetails.getDescription().equals(Resource.getString("FIRMWARE_PACKAGE_UPDATE_DESC_TEXT", " Updates controller firmware package with a specified firmware package image"))) {
                            arrayList.add(operationDetails);
                        }
                    } else if (operationDetails.getDescription().equals(Resource.getString("ADAPTER_OPERATION_4_DESC", "Updates controller firmware with a specified firmware image"))) {
                        arrayList.add(operationDetails);
                    }
                } else {
                    arrayList.add(operationDetails);
                }
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    private void addOperation(ArrayList arrayList, OperationDetails operationDetails) {
        if ((operationDetails.getOpcode() == 17 || operationDetails.getOpcode() == 18) && this.adapter.getAdapterType() == 1) {
            if (this.getNoOfOnlinePds() <= 0 || this.adapter.getPatrolReadProperties().getopMode() == '\u0002') {
                operationDetails.setDisabled(true);
            } else {
                operationDetails.setDisabled(false);
            }
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
        } else if (operationDetails.getOpcode() == 42) {
            if (this.adapter.getAdapterType() == 1 && VivaldiStartupDialog.OEM_TYPE != 2561 && this.adapterInfo.getpdOperations_MR_CTRL_INFO().isSupportPowerState() && !this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().isSSDSmartErEnabled()) {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 43) {
            if (this.adapter.getAdapterType() == 1 && VivaldiStartupDialog.OEM_TYPE != 2561 && this.adapterInfo.getpdOperations_MR_CTRL_INFO().isSupportPowerState() && this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().isSSDSmartErEnabled()) {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 18088704) {
            LogicalDriveHelper[] logicalDriveHelperArray = this.getCCCapableLogicalDrives();
            if (logicalDriveHelperArray != null && logicalDriveHelperArray.length <= 0) {
                operationDetails.setDisabled(true);
            }
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
        } else if (operationDetails.getOpcode() == 33282 && operationDetails.getName().equalsIgnoreCase(Resource.getString("ENABLESMART_TEXT", "Enable S.M.A.R.T"))) {
            byte by = ((SASServer)this.adapter.parent()).getInformation().getSystemType();
            if (VivaldiStartupDialog.OEM_TYPE == 2561 && by == 4) {
                try {
                    byte by2 = this.adapter.getSMARTMode();
                    if (by2 == 1) {
                        operationDetails.setParameter((byte)0);
                        this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
                    }
                }
                catch (VKOperationFailedException vKOperationFailedException) {}
            }
        } else if (operationDetails.getOpcode() == 33282 && operationDetails.getName().equalsIgnoreCase(Resource.getString("DISABLESMART_TEXT", "Disable S.M.A.R.T"))) {
            byte by = ((SASServer)this.adapter.parent()).getInformation().getSystemType();
            if (VivaldiStartupDialog.OEM_TYPE == 2561 && by == 4) {
                try {
                    byte by3 = this.adapter.getSMARTMode();
                    if (by3 == 0) {
                        operationDetails.setParameter((byte)1);
                        this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
                    }
                }
                catch (VKOperationFailedException vKOperationFailedException) {}
            }
        } else {
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
        }
    }

    public void checkAndAddSystemAllowedOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        try {
            if ((operationDetails.getOpcode() & 0x8000) == 32768) {
                if (this.adapter.isKernelOperationAllowed(operationDetails.getOpcode())) {
                    arrayList.add(operationDetails);
                }
            } else if (this.adapter.isOperationAllowed(operationDetails.getOpcode())) {
                arrayList.add(operationDetails);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in adapterhelper ");
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isOperationAllowed(int n) {
        String string = null;
        switch (n) {
            case 17: {
                if (this.getAdapterInfo().getCacheIsPinned() != 0) {
                    new PreservedCachePresent();
                    return false;
                }
                string = Resource.getString("MSG_DISBL_ALARM", "Warning : This will start Patrol Read operation. ");
                if (string == null || JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, string + Resource.getString("MSG_CONFIRM", "Are you sure ?"), Resource.getString("PR_START_TITLE", "Patrol Read Start"), 0, 3) == 0) break;
                return false;
            }
            case 2: {
                string = Resource.getString("MSG_SET_CONTROLLER_PROP", "Warning : This will set controller properties. ");
                if (string == null || JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, string + Resource.getString("MSG_CONFIRM", "Are you sure ?"), Resource.getString("SET_CTRL_TITLE", "Set Controller Property"), 0, 3) == 0) break;
                return false;
            }
            case 27: {
                string = Resource.getString("MSG_SET_CONTROLLER_PROP", "Warning : This will set controller properties. ");
                if (string == null || JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, string + Resource.getString("MSG_CONFIRM", "Are you sure ?"), Resource.getString("SET_CTRL_TITLE", "Set Controller Property"), 0, 3) == 0) break;
                return false;
            }
        }
        return (n & 0x8000) == 32768 ? this.adapter.isKernelOperationAllowed(n) : this.adapter.isOperationAllowed((byte)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void issueOperation(OperationDetails operationDetails) {
        int n;
        String string;
        Object object;
        int n2;
        Object object2;
        if (operationDetails.getOpcode() == 3) {
            Object object3;
            if (this.adapter.getAdapterType() == 1) {
                object2 = null;
                object3 = this.adapterInfo.getimageComponent_MR_CTRL_INFO();
                for (n2 = 0; n2 < ((MR_FLASH_COMP_INFO[])object3).length; ++n2) {
                    if (!new String(((MR_FLASH_COMP_INFO)object3[n2]).getname()).trim().equals(FW_FILE_HEADER_NAME)) continue;
                    object2 = new String(((MR_FLASH_COMP_INFO)object3[n2]).getversion()).trim();
                    break;
                }
                if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_CURRENT_FW_VERSION", "Current firmware version: ") + "" + (String)object2 + "\n\n" + Resource.getString("MSG_CURRENT_FW_VERSION_REPLACEWITH", "Warning: The current firmware version will be replaced with the selected firmware!\nAre you sure?"))) {
                    return;
                }
            } else if (this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4) {
                object2 = null;
                object3 = (String)operationDetails.getParam();
                n2 = ((String)object3).charAt(0);
                String string2 = "";
                object = "";
                string = "";
                String string3 = "";
                MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.adapterInfo.getimageComponent_MR_CTRL_INFO();
                for (n = 0; n < mR_FLASH_COMP_INFOArray.length; ++n) {
                    if (new String(mR_FLASH_COMP_INFOArray[n].getname()).trim().equals(FW_FILE_HEADER_NAME)) {
                        string2 = Resource.getString("CONTOLLER_FIRMWARE", "controller firmware");
                        object = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion());
                        continue;
                    }
                    if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("BIOS")) continue;
                    string3 = Resource.getString("BIOS_TEXT", "BIOS");
                    string = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion());
                }
                if (n2 == 48 ? !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH", "Warning : This will flash the ") + string2 + Resource.getString("CURRENT_VERSION", ". Current version is ") + (String)object + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?")) : (n2 == 49 ? !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH", "Warning : This will flash the ") + string3 + Resource.getString("CURRENT_VERSION", ". Current version is ") + string + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?")) : (n2 == 50 ? !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH_FCODE", "Warning : This will flash the  FCODE") + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?")) : n2 == 51 && !CustomMsgBox.confirmWithCheck(Resource.getString("WARNING_FLASH_EFI_BSD", "Warning : This will flash the  EFI-BSD") + "\n " + Resource.getString("MSG_CONFIRM", "Are you sure ?"))))) {
                    return;
                }
            }
        }
        try {
            VivaldiStartupDialog.mainScreen.busy();
            if (operationDetails.getOpcode() == 41) {
                new ManagePreservedCacheDialog(this);
                return;
            }
            if (operationDetails.getOpcode() == 0x7010000) {
                for (int i = 0; i < this.phySpeed.length; ++i) {
                    if (this.phySpeed[i][0] == this.phySpeed[i][1]) continue;
                    this.adapter.setLinkSpeed(i, this.phySpeed[i][1]);
                }
                object2 = Resource.getString("DESC_REBOOT_AFTER_LINK_SPEED", "Please restart the system for the changes to take effect.Make sure \nto stop all the I/Os and other operations before you restart your\nsystem.");
                JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, Resource.getString("DESC_REBOOT_AFTER_LINK_SPEED", (String)object2), Resource.getString("SYSTEM_RESTART_REQUIRED", "System Restart Required"), 2);
            } else if (operationDetails.getOpcode() == 17) {
                int n3;
                object2 = null;
                boolean bl = true;
                n2 = 0;
                boolean bl2 = false;
                object = new OperationDetails(15, null);
                this.issueOperation((OperationDetails)object);
                String string4 = string = ((OperationDetails)object).getParam() != null ? (MR_PR_PROPERTIES)((OperationDetails)object).getParam() : null;
                if (string != null && (short)((MR_PR_PROPERTIES)((Object)string)).getopMode() == 2) {
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_NO_AVAILABLE_PD_FOUND", "Patrol read is disabled."), Resource.getString("PR_DIS_TITLE", "Patrol Read Disabled"), 0);
                    return;
                }
                if (this.pdHelpers.length <= 0) {
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, Resource.getString("PR_NOT_START_PD", "Patrol read cannot be started because there are no PD available."), Resource.getString("PR_NO_PD_TITLE", "Patrol Read - No PD"), 0);
                    return;
                }
                if (this.ldHelpers.length <= 0 && this.getGlobalSpares() == null) {
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, Resource.getString("PR_NOT_START_PD_CFG", "Patrol read cannot be started because there is no configuration available."), Resource.getString("PR_NO_CONFIG_TITLE", "Patrol Read - No Configuration"), 0);
                    return;
                }
                int n4 = this.arrayHelpers.length;
                int n5 = 0;
                n = 0;
                int n6 = 0;
                for (n3 = 0; n3 < n4; n3 = (int)((short)(n3 + 1))) {
                    int n7;
                    n2 = 0;
                    LogicalDriveHelper[] logicalDriveHelperArray = this.arrayHelpers[n3].getLogicalDriveHelpers();
                    for (n7 = 0; n7 < logicalDriveHelperArray.length; n7 = (int)((short)(n7 + 1))) {
                        if (((SASLogicalDrive)logicalDriveHelperArray[n7].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getcc()) {
                            object2 = Resource.getString("MSG_CC_INPROGRESS", "Operation can not be started while check consistency is in progress !");
                            n2 = 1;
                            break;
                        }
                        if (((SASLogicalDrive)logicalDriveHelperArray[n7].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) {
                            object2 = Resource.getString("MSG_RECON_INPROGRESS", "Operation can not be started while reconstruction is in progress !");
                            bl2 = true;
                            break;
                        }
                        if (!((SASLogicalDrive)logicalDriveHelperArray[n7].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getbgi() && !((SASLogicalDrive)logicalDriveHelperArray[n7].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi()) continue;
                        object2 = Resource.getString("MSG_BGI_INPROGRESS", "Operation cannot be started while initialization is in progress !");
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0 && !bl2) {
                        PhysicalDriveHelper[] physicalDriveHelperArray = this.arrayHelpers[n3].getPhysicalDrives();
                        for (int n8 = 0; n8 < physicalDriveHelperArray.length; n8 = (int)((short)(n8 + 1))) {
                            if (((SASPhysicalDrive)physicalDriveHelperArray[n8].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() == 0) continue;
                            object2 = Resource.getString("MSG_RBLD_INPROGRESS", "Operation can not be started while Rebuild is in progress !");
                            n2 = 1;
                            break;
                        }
                    }
                    if (bl2) {
                        bl = false;
                        break;
                    }
                    if (n2 == 1 && this.arrayHelpers[n3].getDedicatedSpares() == null) {
                        ++n5;
                    }
                    if (!this.isSWRController() || this.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_10() == 0) continue;
                    block18: for (n7 = 0; n7 < logicalDriveHelperArray.length; n7 = (int)((short)(n7 + 1))) {
                        if (logicalDriveHelperArray[n7].getInformation().getldConfig().getparams().getPRL() != 1 || logicalDriveHelperArray[n7].getInformation().getldConfig().getparams().getSRL() != 0 || this.arrayHelpers[n3].getSpanDepth() <= 1) continue;
                        PhysicalDriveHelper[] physicalDriveHelperArray = this.arrayHelpers[n3].getPhysicalDrives();
                        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                            if (((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getrbld() == 0) continue;
                            n6 = this.arrayHelpers[n3].getSpanDepth();
                            ++n;
                            continue block18;
                        }
                    }
                }
                if (n > 0 && n < n6) {
                    for (n3 = 0; n3 < n6 - 1; ++n3) {
                        ++n5;
                    }
                }
                if (n5 == n4) {
                    bl = false;
                }
                if (!bl && this.getGlobalSpares() == null || bl2) {
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, object2, Resource.getString("PR_BACKGROUND_PROCESS_TITLE", "Patrol read - Background process running"), 0);
                    return;
                }
            }
            if (operationDetails.getOpcode() != 17 && operationDetails.getOpcode() == 18) {
                MR_PR_PROPERTIES mR_PR_PROPERTIES;
                object2 = new OperationDetails(15, null);
                this.issueOperation((OperationDetails)object2);
                MR_PR_PROPERTIES mR_PR_PROPERTIES2 = mR_PR_PROPERTIES = ((OperationDetails)object2).getParam() != null ? (MR_PR_PROPERTIES)((OperationDetails)object2).getParam() : null;
                if (mR_PR_PROPERTIES == null || (short)mR_PR_PROPERTIES.getopMode() == 2) {
                    // empty if block
                }
            }
            if (operationDetails.getOpcode() != 0x7010000) {
                this.adapter.fireOperation(operationDetails);
            }
            if (operationDetails.getOpcode() == 3 && this.adapter.getAdapterType() != 2 && this.adapter.getAdapterType() != 3 && this.adapter.getAdapterType() != 4) {
                new CustomMsgBox((Component)VivaldiStartupDialog.mainScreen, (Object)Resource.getString("MSG_FW_REBOOT", "<html>New Firmware Version: {0} <br> is flashed successfully. System reboot is required <br> for  the new Firmware to take effect.</html>"), 2);
            } else if (operationDetails.getOpcode() == 18088704 && ((MR_CC_SCHEDULE_PROPERTIES)(object2 = (MR_CC_SCHEDULE_PROPERTIES)operationDetails.getParam())).getopMode() != 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                long l = gregorianCalendar.getTimeInMillis();
                long l2 = (long)((MR_CC_SCHEDULE_PROPERTIES)object2).getnextExec() * 1000L;
                TimeZone timeZone = TimeZone.getDefault();
                gregorianCalendar.setTimeInMillis(l + l2);
                boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
                if (bl) {
                    n = timeZone.getDSTSavings();
                    gregorianCalendar.setTimeInMillis(l + l2 - (long)n);
                } else {
                    gregorianCalendar.setTimeInMillis(l + l2);
                }
                String string5 = Resource.getString("CC_SCHEDULE_SET_CONFIRM_MSG", "Consistency check is scheduled at");
                string5 = string5 + " " + gregorianCalendar.getTime() + ".";
                JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, string5, Resource.getString("CC_SCH_TITLE", "Consistency Check"), 1);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            CustomMsgBox.errorMsg(vKOperationFailedException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            VivaldiStartupDialog.mainScreen.ready();
        }
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3;
        Object object4;
        PropertyInfo propertyInfo;
        PropertyInfo propertyInfo2;
        Object object5;
        PropertyInfo propertyInfo3;
        Object object6;
        Object object7;
        PropertyInfo propertyInfo4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.adapter.isMRApiBkwdIncompatible()) {
            propertyInfo4 = new PropertyInfo();
            propertyInfo4.name = Resource.getString("MSG_APP_DEGRADE", "Incompatible Controller. Old firmware is being used.");
            propertyInfo4.description = Resource.getString("MSG_APP_DEGRADE", "Incompatible Controller. Old firmware is being used.");
            arrayList.add(propertyInfo4);
        } else if (this.adapter.isMRApiFWDIncompatible()) {
            propertyInfo4 = new PropertyInfo();
            propertyInfo4.name = Resource.getString("MSG_APP_UPGRADE", "Application needs to be upgraded to support this controller.");
            propertyInfo4.description = Resource.getString("MSG_APP_UPGRADE", "Application needs to be upgraded to support this controller.");
            arrayList.add(propertyInfo4);
        }
        if (this.adapter.isMRApiIncompatible()) {
            return arrayList;
        }
        propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        arrayList.add(propertyInfo4);
        PropertyInfo propertyInfo5 = new PropertyInfo();
        propertyInfo5.name = Resource.getString("PROPERTY_PRODUCTNAME_TEXT", "Product Name");
        propertyInfo5.value = Resource.zeroTrim(this.adapterInfo.getproductName());
        propertyInfo5.description = Resource.getString("PROPERTY_PRODUCTNAME_TEXT", "Product Name");
        arrayList.add(propertyInfo5);
        PropertyInfo propertyInfo6 = new PropertyInfo();
        propertyInfo6.name = Resource.getString("PROPERTY_SERIALNO_TEXT", "Serial No");
        propertyInfo6.value = Resource.zeroTrim(this.adapterInfo.getserialNo());
        propertyInfo6.description = Resource.getString("PROPERTY_SERIALNO_TEXT", "Serial No");
        arrayList.add(propertyInfo6);
        PropertyInfo propertyInfo7 = new PropertyInfo();
        propertyInfo7.name = Resource.getString("PROPERTY_VENDORID_TEXT", "Vendor ID");
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.intToByteArray(0, byArray);
        NetworkToJavaConverter.unsignedShortTobyteArray(this.adapterInfo.getpci_MR_CTRL_INFO().getvendorId(), byArray, 0);
        propertyInfo7.value = "0x" + Integer.toHexString(NetworkToJavaConverter.byteArrayToInt(byArray)) + "";
        propertyInfo7.description = Resource.getString("PROPERTY_VENDORID_TEXT", "Vendor ID");
        arrayList.add(propertyInfo7);
        PropertyInfo propertyInfo8 = new PropertyInfo();
        propertyInfo8.name = Resource.getString("PROPERTY_SUBVENDORID_TEXT", "SubVendor ID");
        NetworkToJavaConverter.intToByteArray(0, byArray);
        NetworkToJavaConverter.unsignedShortTobyteArray(this.adapterInfo.getpci_MR_CTRL_INFO().getsubVendorId(), byArray, 0);
        propertyInfo8.value = "0x" + Integer.toHexString(NetworkToJavaConverter.byteArrayToInt(byArray)) + "";
        propertyInfo8.description = Resource.getString("PROPERTY_SUBVENDORID_TEXT", "SubVendor ID");
        arrayList.add(propertyInfo8);
        PropertyInfo propertyInfo9 = new PropertyInfo();
        propertyInfo9.name = Resource.getString("PROPERTY_DEVID_TEXT", "Device ID");
        propertyInfo9.value = "0x" + Integer.toHexString(this.adapterInfo.getpci_MR_CTRL_INFO().getdevId()) + "";
        propertyInfo9.description = Resource.getString("PROPERTY_DEVID_TEXT", "Device ID");
        arrayList.add(propertyInfo9);
        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = null;
        try {
            mR_MFC_DEFAULTS = this.adapter.getMFCDefaults();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        PropertyInfo propertyInfo10 = new PropertyInfo();
        propertyInfo10.name = Resource.getString("PROPERTY_CTRL_SASADDR_TEXT", "SAS Address");
        propertyInfo10.value = this.adapter.getAdapterType() != 2 && this.adapter.getAdapterType() != 3 && this.adapter.getAdapterType() != 4 ? Long.toHexString(mR_MFC_DEFAULTS.getsasAddr()).toUpperCase().trim() : Long.toHexString(this.adapterInfo.gethostInterface_MR_CTRL_INFO().getportAddr()[0]).toUpperCase().trim();
        propertyInfo10.description = Resource.getString("PROPERTY_CTRL_SASADDR_TEXT", "SAS Address");
        arrayList.add(propertyInfo10);
        PropertyInfo propertyInfo11 = new PropertyInfo();
        propertyInfo11.name = Resource.getString("PROPERTY_CTRL_HEADLESS_TEXT", "Boot Error Handling");
        if (this.adapter.getAdapterType() != 2 && this.adapter.getAdapterType() != 3 && this.adapter.getAdapterType() != 4) {
            try {
                byte by = this.adapter.getBIOSData().getcontinueOnError();
                object7 = this.getCOEmessage(Byte.toString(by));
                System.out.println("HeadLess value is" + (String)object7);
                propertyInfo11.value = object7;
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            arrayList.add(propertyInfo11);
            propertyInfo11.description = Resource.getString("PROPERTY_CTRL_HEADLESS_TEXT", "Boot Error Handling");
        }
        PropertyInfo propertyInfo12 = new PropertyInfo();
        propertyInfo12.name = Resource.getString("PROPERTY_DEVICEPORTCOUNT_TEXT", "Device Port Count");
        propertyInfo12.value = this.adapter.getMaxPortCount() + "";
        propertyInfo12.description = Resource.getString("PROPERTY_DEVICEPORTCOUNT_TEXT", "Device Port Count");
        arrayList.add(propertyInfo12);
        object7 = new PropertyInfo();
        ((PropertyInfo)object7).name = Resource.getString("PRPOERTY_HOSTINTERFACE_TEXT", "Host Interface");
        char c = this.adapterInfo.gethostInterface_MR_CTRL_INFO().getHostType();
        switch (c) {
            case '\u0003': {
                ((PropertyInfo)object7).value = Resource.getString("ADAPTER_TYPE_ISCSI", "iSCSI");
                break;
            }
            case '\u0002': {
                ((PropertyInfo)object7).value = Resource.getString("ADAPTER_TYPE_PCIE", "PCIE");
                break;
            }
            case '\u0001': {
                ((PropertyInfo)object7).value = Resource.getString("ADAPTER_TYPE_PCIX", "PCIX");
                break;
            }
            case '\u0004': {
                ((PropertyInfo)object7).value = Resource.getString("ADAPTER_TYPE_SAS_3G", "SAS_3G");
                break;
            }
            default: {
                ((PropertyInfo)object7).value = Resource.getString("ADAPTER_TYPE_ISCSI", "Unknown");
            }
        }
        ((PropertyInfo)object7).description = Resource.getString("PRPOERTY_HOSTINTERFACE_TEXT", "Host Interface");
        arrayList.add(object7);
        PropertyInfo propertyInfo13 = new PropertyInfo();
        propertyInfo13.name = Resource.getString("PROPERTY_METADATA_TEXT", "Metadata Size");
        short s = this.adapterInfo.getddfSize();
        propertyInfo13.value = Integer.toString(s) + " " + "MB";
        arrayList.add(propertyInfo13);
        PropertyInfo propertyInfo14 = new PropertyInfo();
        propertyInfo14.name = Resource.getString("PROPERTY_HOSTPORTCOUNT_TEXT", "Host Port Count");
        propertyInfo14.value = this.adapterInfo.gethostInterface_MR_CTRL_INFO().getportCount() + "";
        propertyInfo14.description = Resource.getString("PROPERTY_HOSTPORTCOUNT_TEXT", "Host Port Count");
        arrayList.add(propertyInfo14);
        if (VivaldiStartupDialog.OEM_TYPE != 2561) {
            try {
                object6 = this.adapter.getFRUProperties();
                if (object6 != null) {
                    propertyInfo3 = new PropertyInfo();
                    propertyInfo3.name = Resource.getString("PROPERTY_FRU_TEXT", "FRU");
                    propertyInfo3.description = Resource.getString("PROPERTY_FRU_TEXT", "FRU");
                    object5 = new String(((MR_MFC_MFG)object6).getrev());
                    propertyInfo3.value = ((String)(object5 = this.formatFRUString((String)object5))).length() > 0 ? ((String)object5).trim() : "";
                    arrayList.add(propertyInfo3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object6 = new PropertyInfo();
        ((PropertyInfo)object6).name = Resource.getString("PROPERTY_ISALARMPRESENT_TEXT", "Alarm Present");
        ((PropertyInfo)object6).value = this.adapterInfo.gethwPresent_MR_CTRL_INFO().getalarm() != 0 ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
        ((PropertyInfo)object6).description = Resource.getString("PROPERTY_ISALARMPRESENT_TEXT", "Alarm Present");
        arrayList.add(object6);
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getalarm() != 0) {
            propertyInfo3 = new PropertyInfo();
            propertyInfo3.name = Resource.getString("PROPERTY_ALARMENABLE_TEXT", "Alarm Enabled");
            propertyInfo3.value = this.adapterProperties.getalarmEnable() != '\u0000' ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
            propertyInfo3.description = Resource.getString("PROPERTY_ALARMENABLE_TEXT", "Alarm Enabled");
            arrayList.add(propertyInfo3);
        }
        propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_CACHEFLUSHINTERVAL_TEXT", "Cache Flush Interval");
        propertyInfo3.value = this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4 ? "NA" : this.adapterProperties.getcacheFlushInterval() + " sec";
        propertyInfo3.description = Resource.getString("PROPERTY_CACHEFLUSHINTERVAL_TEXT", "Cache Flush Interval");
        arrayList.add(propertyInfo3);
        object5 = new PropertyInfo();
        ((PropertyInfo)object5).name = Resource.getString("PROPERTY_COERCIONMODE_TEXT", "Coercion Mode");
        char c2 = this.adapterProperties.getcoercionMode();
        if (this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4) {
            switch (c2) {
                case '\u0000': {
                    ((PropertyInfo)object5).value = Resource.getString("COER_MODE_1GB", "1 GB");
                    break;
                }
                case '\u0001': {
                    ((PropertyInfo)object5).value = Resource.getString("COER_MODE_128MB", "128 MB");
                    break;
                }
                case '\u0002': {
                    ((PropertyInfo)object5).value = "Adaptive Coercion";
                    break;
                }
                case '\u0003': {
                    ((PropertyInfo)object5).value = "Zero Coercion";
                }
            }
        } else {
            switch (c2) {
                case '\u0000': {
                    ((PropertyInfo)object5).value = Resource.getString("COER_MODE_NONE", "None");
                    break;
                }
                case '\u0001': {
                    ((PropertyInfo)object5).value = Resource.getString("COER_MODE_128MB", "128 MB");
                    break;
                }
                case '\u0002': {
                    ((PropertyInfo)object5).value = Resource.getString("COER_MODE_1GB", "1 GB");
                }
            }
        }
        ((PropertyInfo)object5).description = Resource.getString("PROPERTY_COERCIONMODE_TEXT", "Coercion Mode");
        arrayList.add(object5);
        PropertyInfo propertyInfo15 = new PropertyInfo();
        propertyInfo15.name = Resource.getString("PROPERTY_ISBBUPRESENT_TEXT", "BBU Present");
        propertyInfo15.value = this.adapterInfo.gethwPresent_MR_CTRL_INFO().getbbu() == 1 ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_No_TEXT", "No");
        propertyInfo15.description = Resource.getString("PROPERTY_ISBBUPRESENT_TEXT", "BBU Present");
        arrayList.add(propertyInfo15);
        PropertyInfo propertyInfo16 = new PropertyInfo();
        propertyInfo16.name = Resource.getString("PROPERTY_ISNVRAMPRESENT_TEXT", "NVRAM Present");
        propertyInfo16.value = this.adapterInfo.gethwPresent_MR_CTRL_INFO().getnvram() != 0 ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
        propertyInfo16.description = Resource.getString("PROPERTY_ISNVRAMPRESENT_TEXT", "NVRAM Present");
        arrayList.add(propertyInfo16);
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getnvram() != 0 && !this.adapter.isWarhawk()) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROPERTY_NVRAMSIZE_TEXT", "NVRAM Size");
            propertyInfo2.value = this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4 ? "NA" : KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(this.adapterInfo.getnvramSize(), 1));
            propertyInfo2.description = Resource.getString("PROPERTY_NVRAMSIZE_TEXT", "NVRAM Size");
            arrayList.add(propertyInfo2);
        }
        if (this.isSWRController() || this.adapterInfo.gethwPresent_MR_CTRL_INFO().getflash() != 0) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROPERTY_NVDATA_VERSION_TEXT", "NVDATA Version");
            propertyInfo2.description = Resource.getString("PROPERTY_NVDATA_VERSION_TEXT", "NVDATA Version");
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROPERTY_BIOSVERSION_TEXT", "BIOS Version");
            propertyInfo.description = Resource.getString("PROPERTY_BIOSVERSION_TEXT", "BIOS Version");
            object4 = this.adapterInfo.getimageComponent_MR_CTRL_INFO();
            n3 = Math.min(((MR_FLASH_COMP_INFO[])object4).length, this.adapterInfo.getimageComponentCount());
            for (n2 = 0; n2 < n3; ++n2) {
                if (Resource.zeroTrim(object4[n2].getname()).equals("NVDATA")) {
                    propertyInfo2.value = Resource.zeroTrim(object4[n2].getversion());
                    arrayList.add(propertyInfo2);
                    if (this.adapter.getAdapterType() != 3 && this.adapter.getAdapterType() != 4 && !this.adapter.isWarhawk() || propertyInfo2.value == null) continue;
                    object3 = propertyInfo2.value.split("\\.");
                    object2 = new StringBuffer();
                    for (int i = 0; i < ((String[])object3).length; ++i) {
                        int n4 = Integer.parseInt(object3[i]);
                        String string = Integer.toHexString(n4);
                        if (n4 <= 15) {
                            ((StringBuffer)object2).append(0);
                        }
                        ((StringBuffer)object2).append(string.toUpperCase());
                        if (i >= ((String[])object3).length - 1) continue;
                        ((StringBuffer)object2).append('.');
                    }
                    propertyInfo2.value = ((StringBuffer)object2).toString();
                    continue;
                }
                if (!Resource.zeroTrim(object4[n2].getname()).equals("BIOS")) continue;
                propertyInfo.value = Resource.zeroTrim(object4[n2].getversion());
            }
            arrayList.add(propertyInfo);
        }
        propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROPERTY_NCQSTATUS_TEXT", "Native Command Queuing");
        propertyInfo2.value = this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getncqStatus() == 0 ? Resource.getString("PROPERTY_NCQ_ENABLED", "Enabled") : Resource.getString("PROPERTY_NCQ_DISABLED", "Disabled");
        propertyInfo2.description = Resource.getString("PROPERTY_NCQSTATUS_TEXT", "Native Command Queuing");
        arrayList.add(propertyInfo2);
        if (this.adapter.getAdapterType() != 2 && !this.adapter.isWarhawk()) {
            if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getflash() != 0) {
                propertyInfo = new PropertyInfo();
                propertyInfo.name = Resource.getString("PROPERTY_FLASHSIZE_TEXT", "Flash Size");
                propertyInfo.value = this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4 ? "NA" : KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(this.adapterInfo.getflashSize(), 2));
                propertyInfo.description = Resource.getString("PROPERTY_FLASHSIZE_TEXT", "Flash Size");
                arrayList.add(propertyInfo);
            }
            if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getmemory() != 0) {
                propertyInfo = new PropertyInfo();
                propertyInfo.name = Resource.getString("PROPERTY_MEMORYSIZE_TEXT", "Memory Size");
                propertyInfo.value = KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(this.adapterInfo.getmemorySize(), 2));
                propertyInfo.description = Resource.getString("PROPERTY_MEMORYSIZE_TEXT", "Memory Size");
                arrayList.add(propertyInfo);
            }
        }
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getTempSensorROC() != 0) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("ROC_TEMP", "RAID on Chip (ROC) Temperature");
            char c3 = this.adapterInfo.gettemperatureROC();
            if (c3 != '\uffffffff') {
                float f = (float)((double)c3 * 1.8) + 32.0f;
                propertyInfo.value = c3 + " C" + "(" + f + " F" + ")";
                propertyInfo.description = Resource.getString("ROC_TEMP", "RAID on Chip (ROC) Temperature");
                arrayList.add(propertyInfo);
            }
        }
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getTempSensorCtrl() != 0) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("CTRL_TEMP", "Controller Temperature");
            char c4 = this.adapterInfo.gettemperatureCtrl();
            if (c4 != '\uffffffff') {
                float f = (float)((double)c4 * 1.8) + 32.0f;
                propertyInfo.value = c4 + " C" + "(" + f + " F" + ")";
                propertyInfo.description = Resource.getString("CTRL_TEMP", "Controller Temperature");
                arrayList.add(propertyInfo);
            }
        }
        propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("SHIELD_STATE_SUPPORT", "Shield State Supported");
        propertyInfo.value = this.adapterInfo.getadapterOperationsEx_MR_CTRL_INFO().getSupportShieldState() == 1 ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_No_TEXT", "No");
        propertyInfo.description = Resource.getString("SHIELD_STATE_SUPPORT", "Shield State Supported");
        arrayList.add(propertyInfo);
        if (this.adapterInfo.getpdOperations_MR_CTRL_INFO().isSupportPowerState() || this.isPowerSaveSupportedOnConfiguredDrives()) {
            boolean bl = this.adapterInfo.getproperties().getOnOffProperties_MR_CTRL_PROP().isSpinDownUnconfiguredDrivesEnabled();
            n3 = this.adapterInfo.getproperties().getOnOffProperties_MR_CTRL_PROP().isdisableSpinDownHS() ? 1 : 0;
            n2 = this.canVDsBeSpunDown() ? 1 : 0;
            object3 = new PropertyInfo();
            object3.name = Resource.getString("PROP_POWER_STATE_PROP", "<html><b>Power State Properties:</b></html>");
            arrayList.add(object3);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("DS_PROPERTY_UNCONFIGURED_GOOD_SPIN_DOWN", "Power savings on unconfigured drives");
            ((PropertyInfo)object2).value = bl ? Resource.getString("PROPERTY_UNCONFIGURED_GOOD_SPIN_DOWN_ENABLED", "Enabled") : Resource.getString("PROPERTY_UNCONFIGURED_GOOD_SPIN_DOWN_DISABLED", "Disabled");
            ((PropertyInfo)object2).description = Resource.getString("DS_PROPERTY_UNCONFIGURED_GOOD_SPIN_DOWN", "Power savings on unconfigured drives");
            arrayList.add(object2);
            if (this.adapter.getAdapterType() != 1) {
                n3 = 1;
            }
            PropertyInfo propertyInfo17 = new PropertyInfo();
            propertyInfo17.name = Resource.getString("DS_PROPERTY_HOT_SPARE_SPIN_DOWN", "Power savings on hot spares");
            propertyInfo17.value = n3 != 0 ? Resource.getString("PROPERTY_HS_SPIN_DOWN_DISABLED", "Disabled") : Resource.getString("PROPERTY_HS_SPIN_DOWN_ENABLED", "Enabled");
            propertyInfo17.description = Resource.getString("DS_PROPERTY_HOT_SPARE_SPIN_DOWN", "Power savings on hot spares");
            arrayList.add(propertyInfo17);
            if (this.isPowerSaveSupportedOnConfiguredDrives()) {
                PropertyInfo propertyInfo18 = new PropertyInfo();
                propertyInfo18.name = Resource.getString("DS_PS_CONFIG_POLICY", "Power Save Policy for Configured Drives");
                propertyInfo18.value = this.getPowerState();
                propertyInfo18.description = Resource.getString("DS_PS_CONFIG_POLICY", "Power Save Policy for Configured Drives");
                arrayList.add(propertyInfo18);
            }
            if (bl || n3 == 0 || n2 != 0) {
                PropertyInfo propertyInfo19 = new PropertyInfo();
                propertyInfo19.name = Resource.getString("DS_PROPERTY_SPIN_DOWN_TIME", "Drive Standby Time");
                propertyInfo19.value = this.getSpinDownTime();
                propertyInfo19.description = Resource.getString("DS_PROPERTY_SPIN_DOWN_TIME", "Drive Standby Time");
                arrayList.add(propertyInfo19);
            }
            if (n2 != 0 && this.getMFCDefaults().getdisablePowerSavings() != -1 && (this.getMFCDefaults().getdisablePowerSavings() & 0x40) == 64) {
                PropertyInfo propertyInfo20 = new PropertyInfo();
                propertyInfo20.name = Resource.getString("DS_DRIVE_ACTIVE_START_TIME", "Drive Active Start Time");
                int n5 = this.adapterInfo.getproperties().getdisabledLdPSTime() / 60;
                propertyInfo20.value = (n5 < 10 ? "0" : "") + n5 + ":00 " + Resource.getString("HRS", "hrs");
                propertyInfo20.description = Resource.getString("DS_DRIVE_ACTIVE_START_TIME", "Drive Active Start Time");
                arrayList.add(propertyInfo20);
                object = new PropertyInfo();
                ((PropertyInfo)object).name = Resource.getString("DS_DRIVE_ACTIVE_END_TIME", "Drive Active End Time");
                n = this.adapterInfo.getproperties().getdisabledLdPSInterval();
                int n6 = 0;
                n6 = n + n5;
                if (n6 > 24) {
                    n6 = n + n5 - 24;
                }
                if (n6 == 24) {
                    n6 = 0;
                }
                ((PropertyInfo)object).value = (n6 < 10 ? "0" : "") + n6 + ":00 " + Resource.getString("HRS", "hrs");
                ((PropertyInfo)object).description = Resource.getString("DS_DRIVE_ACTIVE_END_TIME", "Drive Active End Time");
                arrayList.add(object);
            }
        }
        if (this.isPISupported()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("DATA_PROTECTION_PROP", "<html><b>Data Protection Properties:</b></html>");
            arrayList.add(object4);
            PropertyInfo propertyInfo21 = new PropertyInfo();
            propertyInfo21.name = Resource.getString("DATA_PROTECTION", "Data Protection");
            propertyInfo21.value = this.isPIEnabledOnController() ? Resource.getString("PROPERTY_HS_SPIN_DOWN_ENABLED", "Enabled") : Resource.getString("PROPERTY_HS_SPIN_DOWN_DISABLED", "Disabled");
            propertyInfo21.description = Resource.getString("DATA_PROTECTION", "Data Protection");
            arrayList.add(propertyInfo21);
        }
        if (this.adapter.isWarhawk()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("WARPDRIVE_PROPERTIES_TEXT", "<html><b>WarpDrive Properties:</b></html>");
            arrayList.add(object4);
            PropertyInfo propertyInfo22 = new PropertyInfo();
            propertyInfo22.name = Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left");
            propertyInfo22.value = this.adapter.getWhDDInfo().getSSDLifeLeft() + " %" + " - " + this.getSSDLifeLeftStatus();
            propertyInfo22.description = Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left");
            arrayList.add(propertyInfo22);
            PropertyInfo propertyInfo23 = new PropertyInfo();
            propertyInfo23.name = Resource.getString("PROPERTY_DD_STATUS_TEXT", "Virtual Drive Status");
            int n7 = this.adapter.getWhDDInfo().getDDStatus();
            if (n7 == 0) {
                propertyInfo23.value = Resource.getString("PROPERTY_DD_STATUS_GOOD_TEXT", "Good");
            } else if (n7 == 1) {
                propertyInfo23.value = Resource.getString("PROPERTY_DD_STATUS_WARNING_TEXT", "Warning");
            } else if (n7 == 2) {
                propertyInfo23.value = Resource.getString("PROPERTY_DD_STATUS_ERROR_TEXT", "Error");
            } else if (n7 == 255) {
                propertyInfo23.value = Resource.getString("PROPERTY_DD_STATUS_UNKNOWN_TEXT", "Unknown");
            }
            propertyInfo23.description = Resource.getString("PROPERTY_DD_STATUS_TEXT", "Virtual Drive Status");
            arrayList.add(propertyInfo23);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("PROPERTY_LIFE_CURVE_STATUS_TEXT", "Life Curve Status");
            ((PropertyInfo)object2).value = this.getLifeCurveStatus();
            ((PropertyInfo)object2).description = Resource.getString("PROPERTY_LIFE_CURVE_STATUS_TEXT", "Life Curve Status");
            arrayList.add(object2);
            PropertyInfo propertyInfo24 = new PropertyInfo();
            propertyInfo24.name = Resource.getString("PROPERTY_AUX_POW_TEXT", "Auxiliary Power");
            short s2 = this.adapter.getWhDDInfo().getAuxiliaryPowerPresent();
            propertyInfo24.value = s2 == 0 ? Resource.getString("PROPERTY_AUX_POW_NOT_PRESENT_TEXT", "Not Present") : (s2 == 1 ? Resource.getString("PROPERTY_AUX_POW_PRESENT_TEXT", "Present") : (s2 == 255 ? Resource.getString("PROPERTY_AUX_POW_NOT_SUPPORTED_TEXT", "Not Supported") : Resource.getString("PROPERTY_DD_UNKNOWN_TEXT", "Unknown")));
            propertyInfo24.description = Resource.getString("PROPERTY_AUX_POW_TEXT", "Auxiliary Power");
            arrayList.add(propertyInfo24);
        }
        if (!this.isSWRController()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROP_FWPROP", "<html><b>Firmware Properties:</b></html>");
            arrayList.add(object4);
            PropertyInfo propertyInfo25 = new PropertyInfo();
            propertyInfo25.name = Resource.getString("PROPERTY_FWPKGVERSION_TEXT", "Firmware Package Version");
            propertyInfo25.value = Resource.zeroTrim(this.adapterInfo.getfwPackageVersion());
            propertyInfo25.description = Resource.getString("PROPERTY_FWPKGVERSION_TEXT", "Firmware Package Version");
            arrayList.add(propertyInfo25);
        }
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getExpander() == 1) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_EXPFWVERSION_TEXT", "Expander Firmware Version");
            ((PropertyInfo)object4).value = Resource.zeroTrim(this.adapterInfo.getExpanderFwVersion());
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_EXPFWVERSION_TEXT", "Expander Firmware Version");
            arrayList.add(object4);
        }
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getflash() != 0) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_FWVERSION_TEXT", "Firmware Version");
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_FWVERSION_TEXT", "Firmware Version");
            PropertyInfo propertyInfo26 = new PropertyInfo();
            propertyInfo26.name = Resource.getString("PROPERTY_FWBUILDTIME_TEXT", "Firmware Build Time");
            propertyInfo26.description = Resource.getString("PROPERTY_FWBUILDTIME_TEXT", "Firmware Build Time");
            MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.adapterInfo.getimageComponent_MR_CTRL_INFO();
            int n8 = Math.min(mR_FLASH_COMP_INFOArray.length, this.adapterInfo.getimageComponentCount());
            for (int i = 0; i < n8; ++i) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals(FW_FILE_HEADER_NAME)) continue;
                ((PropertyInfo)object4).value = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
                propertyInfo26.value = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getbuildDate()) + "  " + Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getbuildTime());
            }
            arrayList.add(object4);
            arrayList.add(propertyInfo26);
        }
        if (((deviceInterface_MR_CTRL_INFO)(object4 = this.adapterInfo.getdeviceInterface_MR_CTRL_INFO())).getportCount() > 0) {
            long[] lArray = ((deviceInterface_MR_CTRL_INFO)object4).getportAddr();
            for (int i = 0; i < Math.min(((deviceInterface_MR_CTRL_INFO)object4).getportCount(), 8); ++i) {
                PropertyInfo propertyInfo27 = new PropertyInfo();
                propertyInfo27.name = Resource.getString("PROPERTY_SASADDR_TEXT", "Backend SAS Address") + " " + i;
                propertyInfo27.description = Resource.getString("PROPERTY_SASADDR_TEXT", "Backend SAS Address") + " " + i;
                propertyInfo27.value = "0x" + Long.toHexString(lArray[i]).toUpperCase().trim();
                arrayList.add(propertyInfo27);
            }
            if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() != 0 && ((deviceInterface_MR_CTRL_INFO)object4).getportCount() > 8) {
                long[] lArray2 = this.adapterInfo.getDeviceInterfacePortAddr2();
                for (int i = 0; i < ((deviceInterface_MR_CTRL_INFO)object4).getportCount() - 8; ++i) {
                    PropertyInfo propertyInfo28 = new PropertyInfo();
                    propertyInfo28.name = Resource.getString("PROPERTY_SASADDR_TEXT", "Backend SAS Address") + " " + (8 + i);
                    propertyInfo28.description = Resource.getString("PROPERTY_SASADDR_TEXT", "Backend SAS Address") + " " + (8 + i);
                    propertyInfo28.value = "0x" + Long.toHexString(lArray2[i]).toUpperCase().trim();
                    arrayList.add(propertyInfo28);
                }
            }
        }
        if (this.adapterInfo.gethwPresent_MR_CTRL_INFO().getmemory() != 0) {
            if (this.adapter.getAdapterType() != 2) {
                PropertyInfo propertyInfo29 = new PropertyInfo();
                propertyInfo29.name = Resource.getString("PROPERTY_MEMCORRECTABLEERRORCOUNT_TEXT", "Correctable Error Count");
                propertyInfo29.value = this.adapterInfo.getmemCorrectableErrorCount() + "";
                propertyInfo29.description = Resource.getString("PROPERTY_MEMCORRECTABLEERRORCOUNT_TEXT", "Correctable ErrorCount");
                arrayList.add(propertyInfo29);
            }
            PropertyInfo propertyInfo30 = new PropertyInfo();
            propertyInfo30.name = Resource.getString("PROPERTY_MEMUMEMORYNCORRECTABLEERRORCOUNT_TEXT", "Memory uncorrectable count");
            propertyInfo30.value = this.adapterInfo.getmemUnCorrectableErrorCount() + "";
            propertyInfo30.description = Resource.getString("PROPERTY_MEMUMEMORYNCORRECTABLEERRORCOUNT_TEXT", "Memory uncorrectable count");
            arrayList.add(propertyInfo30);
        }
        if (this.adapter.getAdapterType() != 2) {
            PropertyInfo propertyInfo31 = new PropertyInfo();
            propertyInfo31.name = Resource.getString("PROPERTY_CLUSTERENABLE_TEXT", "Cluster Enable");
            propertyInfo31.value = this.adapterProperties.getclusterEnable() != '\u0000' ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
            propertyInfo31.description = Resource.getString("PROPERTY_CLUSTERENABLE_TEXT", "Cluster Enable");
            PropertyInfo propertyInfo32 = new PropertyInfo();
            propertyInfo32.name = Resource.getString("PROPERTY_ISCLUSTERACTIVE_TEXT", "Cluster Active");
            propertyInfo32.value = this.adapterInfo.getclusterActive() != '\u0000' ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
            propertyInfo32.description = Resource.getString("PROPERTY_ISCLUSTERACTIVE_TEXT", "Cluster Active");
            PropertyInfo propertyInfo33 = new PropertyInfo();
            propertyInfo33.name = Resource.getString("PROPERTY_SSD_GUARD", "SSD Guard");
            propertyInfo33.value = this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().isSSDSmartErEnabled() ? Resource.getString("PROPERTY_SSD_GUARD_ENABLED", "Enabled") : Resource.getString("PROPERTY_SSD_GUARD_DISABLED", "Disabled");
            arrayList.add(propertyInfo33);
            PropertyInfo propertyInfo34 = new PropertyInfo();
            propertyInfo34.name = Resource.getString("PROPERTY_SSD_CACHE", "SSD Disk Cache Setting");
            propertyInfo34.value = this.adapterInfo.getadapterOperationsEx_MR_CTRL_INFO().getBlockSSDWriteCacheChange() == 0 ? Resource.getString("PROPERTY_SSD_GUARD_ENABLED", "Enabled") : Resource.getString("PROPERTY_SSD_GUARD_DISABLED", "Disabled");
            arrayList.add(propertyInfo34);
            MR_SAS_MUX_LIST mR_SAS_MUX_LIST = this.adapter.getMuxSettings();
            if (mR_SAS_MUX_LIST != null) {
                byte[] byArray2 = mR_SAS_MUX_LIST.getsasMuxMode();
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == 0) continue;
                    object = new PropertyInfo();
                    ((PropertyInfo)object).name = Resource.getString("PROPERTY_MUXSETTING_TEXT", "MUX Setting : Quad " + i);
                    if (byArray2[i] == 3) {
                        ((PropertyInfo)object).value = Resource.getString("PROPERTY_MUXMODE_AUTO_TEXT", "Auto");
                    } else if (byArray2[i] == 2) {
                        ((PropertyInfo)object).value = Resource.getString("PROPERTY_MUXMODE_EXT_TEXT", "External");
                    } else {
                        if (byArray2[i] != 1) continue;
                        ((PropertyInfo)object).value = Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal");
                    }
                    ((PropertyInfo)object).description = Resource.getString("PROPERTY_MUXSETTING_TEXT", "MUX Setting : Quad " + i);
                    arrayList.add(object);
                }
            }
            PropertyInfo propertyInfo35 = new PropertyInfo();
            propertyInfo35.name = Resource.getString("PROPERTY_OFU", "Online Firmware Update");
            propertyInfo35.value = this.adapterInfo.getadapterOperationsEx_MR_CTRL_INFO().getSupportResetNow() == 1 ? Resource.getString("PROPERTY_ENABLED", "Enabled") : Resource.getString("PROPERTY_DISABLED", "Disabled");
            arrayList.add(propertyInfo35);
            PropertyInfo propertyInfo36 = new PropertyInfo();
            propertyInfo36.name = Resource.getString("PROP_DSPROP", "<html><b>Drive Security Properties:</b></html>");
            arrayList.add(propertyInfo36);
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("PROPERTY_DRV_SECURITY_CAPABLE_TEXT", "Drive Security capable");
            ((PropertyInfo)object).description = Resource.getString("PROPERTY_DRV_SECURITY_CAPABLE_TEXT", "Drive Security capable");
            if (this.isSecuritySupported()) {
                ((PropertyInfo)object).value = Resource.getString("PROPERTY_YES_TEXT", "Yes");
                PropertyInfo propertyInfo37 = new PropertyInfo();
                propertyInfo37.name = Resource.getString("PROPERTY_DRV_SECURITY_ENABLED_TEXT", "Drive Security enabled");
                propertyInfo37.description = Resource.getString("PROPERTY_DRV_SECURITY_ENABLED_TEXT", "Drive Security enabled");
                propertyInfo37.value = this.isLockKeyAssigned() ? (VivaldiStartupDialog.OEM_TYPE == 2561 && this.isOnlyFDESupported() ? Resource.getString("PROPERTY_PRESENT_TEXT") : Resource.getString("PROPERTY_YES_TEXT", "Yes")) : (VivaldiStartupDialog.OEM_TYPE == 2561 && this.isOnlyFDESupported() ? Resource.getString("PROPERTY_NONE_TEXT") : Resource.getString("PROPERTY_NO_TEXT", "No"));
                arrayList.add(propertyInfo37);
                if (VivaldiStartupDialog.OEM_TYPE != 2561 || !this.isOnlyFDESupported()) {
                    PropertyInfo propertyInfo38 = new PropertyInfo();
                    propertyInfo38.name = Resource.getString("PROPERTY_DRV_SECURITY_METHOD_TEXT", "Drive security method");
                    propertyInfo38.description = Resource.getString("PROPERTY_DRV_SECURITY_METHOD_TEXT", "Drive security method");
                    propertyInfo38.value = this.getEncryptionMethodDesc();
                    arrayList.add(propertyInfo38);
                }
            } else {
                ((PropertyInfo)object).value = Resource.getString("PROPERTY_NO_TEXT", "No");
            }
            arrayList.add(object);
            if (this.isEKMSPossible()) {
                PropertyInfo propertyInfo39 = new PropertyInfo();
                propertyInfo39.name = Resource.getString("PROPERTY_EKM_SUPPORTED", "EKM Supported");
                propertyInfo39.description = Resource.getString("PROPERTY_EKM_SUPPORTED", "EKM Supported");
                propertyInfo39.value = this.isEKMSupported() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
                arrayList.add(propertyInfo39);
                PropertyInfo propertyInfo40 = new PropertyInfo();
                propertyInfo40.name = Resource.getString("PROPERTY_KEY_MGMT_MODE", "Key Management Mode");
                propertyInfo40.description = Resource.getString("PROPERTY_KEY_MGMT_MODE", "Key Management Mode");
                propertyInfo40.value = this.getKeyManagementMode();
                arrayList.add(propertyInfo40);
            }
        }
        adapterOperations_MR_CTRL_INFO adapterOperations_MR_CTRL_INFO2 = this.adapterInfo.getadapterOperations_MR_CTRL_INFO();
        if (adapterOperations_MR_CTRL_INFO2.getrbldRate() != 0 || adapterOperations_MR_CTRL_INFO2.getpatrolRate() != 0 || adapterOperations_MR_CTRL_INFO2.getreconRate() != 0 || adapterOperations_MR_CTRL_INFO2.getbgiRate() != 0 || adapterOperations_MR_CTRL_INFO2.getccRate() != 0) {
            PropertyInfo propertyInfo41 = new PropertyInfo();
            propertyInfo41.name = Resource.getString("PROP_BOPROP", "<html><b>Background Operation Properties:</b></html>");
            arrayList.add(propertyInfo41);
        }
        if (adapterOperations_MR_CTRL_INFO2.getrbldRate() != 0) {
            PropertyInfo propertyInfo42 = new PropertyInfo();
            propertyInfo42.name = Resource.getString("PROPERTY_REBUILDRATE_TEXT", "Rebuild Rate");
            short s3 = (short)((short)this.adapterProperties.getrebuildRate() >= 0 ? this.adapterProperties.getrebuildRate() : 256 + (short)this.adapterProperties.getrebuildRate());
            propertyInfo42.value = s3 + "";
            propertyInfo42.description = Resource.getString("PROPERTY_REBUILDRATE_TEXT", "Rebuild Rate");
            arrayList.add(propertyInfo42);
        }
        if (adapterOperations_MR_CTRL_INFO2.getpatrolRate() != 0) {
            PropertyInfo propertyInfo43 = new PropertyInfo();
            propertyInfo43.name = Resource.getString("PROPERTY_PATROLREADRATE_TEXT", "Patrol Read Rate");
            propertyInfo43.value = this.adapterProperties.getpatrolReadRate() + "";
            propertyInfo43.description = Resource.getString("PROPERTY_PATROLREADRATE_TEXT", "Patrol Read Rate");
            arrayList.add(propertyInfo43);
        }
        if (adapterOperations_MR_CTRL_INFO2.getreconRate() != 0) {
            PropertyInfo propertyInfo44 = new PropertyInfo();
            propertyInfo44.name = Resource.getString("PROPERTY_RECONRATE_TEXT", "Reconstruction Rate");
            propertyInfo44.value = this.adapterProperties.getreconRate() + "";
            propertyInfo44.description = Resource.getString("PROPERTY_RECONRATE_TEXT", "Reconstruction Rate");
            arrayList.add(propertyInfo44);
        }
        if (adapterOperations_MR_CTRL_INFO2.getbgiRate() != 0) {
            PropertyInfo propertyInfo45 = new PropertyInfo();
            propertyInfo45.name = Resource.getString("PROPERTY_BGIRATE_TEXT", "BGI Rate");
            short s4 = (short)((short)this.adapterProperties.getbgiRate() >= 0 ? this.adapterProperties.getbgiRate() : 256 + (short)this.adapterProperties.getbgiRate());
            propertyInfo45.value = s4 + "";
            propertyInfo45.description = Resource.getString("PROPERTY_BGIRATE_TEXT", "BGI Rate");
            arrayList.add(propertyInfo45);
        }
        if (adapterOperations_MR_CTRL_INFO2.getccRate() != 0) {
            PropertyInfo propertyInfo46 = new PropertyInfo();
            propertyInfo46.name = Resource.getString("PROPERTY_CCRATE_TEXT", "Consistency Check Rate");
            short s5 = (short)((short)this.adapterProperties.getccRate() >= 0 ? this.adapterProperties.getccRate() : 256 + (short)this.adapterProperties.getccRate());
            propertyInfo46.value = s5 + "";
            propertyInfo46.description = Resource.getString("PROPERTY_CCRATE_TEXT", "Consistency Check Rate");
            arrayList.add(propertyInfo46);
        }
        if (adapterOperations_MR_CTRL_INFO2.isSupportSnapshot() && this.isWindowsAndNotDell()) {
            PropertyInfo propertyInfo47 = new PropertyInfo();
            propertyInfo47.name = Resource.getString("PROP_SNAPSHOT_PROP", "<html><b>MegaRAID Recovery Properties:</b></html>");
            arrayList.add(propertyInfo47);
            PropertyInfo propertyInfo48 = new PropertyInfo();
            propertyInfo48.name = Resource.getString("PROPERTY_SNAPSHOTS_TEXT", "MegaRAID Recovery");
            propertyInfo48.value = Resource.getString("PROPERTY_ENABLED", "PROPERTY_ENABLED");
            propertyInfo48.description = Resource.getString("PROPERTY_SNAPSHOTS_TEXT", "MegaRAID Recovery");
            arrayList.add(propertyInfo48);
        }
        if (this.adapterInfo.getmaxHANodes() > 1) {
            PropertyInfo propertyInfo49 = new PropertyInfo();
            propertyInfo49.name = Resource.getString("PROP_HA_CLUSTER", "High Availability Properties:");
            arrayList.add(propertyInfo49);
            PropertyInfo propertyInfo50 = new PropertyInfo();
            propertyInfo50.name = Resource.getString("PROPERTY_CLUSTER_SUPPORTED_TEXT", "Topology Type");
            propertyInfo50.value = this.adapterInfo.getmaxHANodes() > 1 ? Resource.getString("PROPERTY_CLUSTER_SERVER_STORAGE", "Server Storage Cluster") : Resource.getString("PROPERTY_CLUSTER_SERVER_NONE", "None");
            propertyInfo50.description = Resource.getString("PROPERTY_CLUSTER_SUPPORTED_TEXT", "Topology Type");
            arrayList.add(propertyInfo50);
            PropertyInfo propertyInfo51 = new PropertyInfo();
            propertyInfo51.name = Resource.getString("PROPERTY_CLUSTER_HA_NODES", "Maximum Controller Nodes");
            int n9 = this.adapterInfo.getmaxHANodes();
            propertyInfo51.value = new Integer(n9).toString();
            arrayList.add(propertyInfo51);
            PropertyInfo propertyInfo52 = new PropertyInfo();
            propertyInfo52.name = Resource.getString("PROPERTY_CLUSTER_ID", "Domain ID");
            byte[] byArray3 = this.adapterInfo.getClusterId();
            object = "";
            if (propertyInfo52 != null) {
                for (n = 0; n < byArray3.length; ++n) {
                    object = (String)object + NetworkToJavaConverter.byteToHex(byArray3[n]);
                }
            }
            propertyInfo52.value = object;
            arrayList.add(propertyInfo52);
            n = this.adapterInfo.getcluster_MR_CTRL_INFO().getclusterActive() == 1 ? 1 : 0;
            boolean bl = this.adapterInfo.getcluster_MR_CTRL_INFO().getClusterPeerMismatch() == 1;
            PropertyInfo propertyInfo53 = new PropertyInfo();
            propertyInfo53.name = Resource.getString("PROPERTY_CLUSTER_ACTIVE_TEXT", "Peer Controller Status");
            if (n != 0 && !bl) {
                propertyInfo53.value = Resource.getString("HA_ACTIVE", "Active");
            } else if (n == 0) {
                propertyInfo53.value = Resource.getString("HA_INACTIVE", "Inactive");
            } else if (n != 0 && bl) {
                propertyInfo53.value = Resource.getString("HA_INCOMPATIBLE", "Incompatible");
            }
            propertyInfo53.description = Resource.getString("PROPERTY_CLUSTER_ACTIVE_TEXT", "Peer Controller Status");
            arrayList.add(propertyInfo53);
            PropertyInfo propertyInfo54 = new PropertyInfo();
            cluster_MR_CTRL_INFO cluster_MR_CTRL_INFO2 = this.adapterInfo.getcluster_MR_CTRL_INFO();
            propertyInfo54.name = Resource.getString("PROPERTY_CLUSTER_MISMATCH", "Cluster Nodes Compatible");
            String string = Resource.getString("LINK_MISMATCH_LINK", "Details");
            JLabel jLabel = new JLabel();
            jLabel.setText("<html><body>&nbsp&nbsp&nbsp<a href=\"" + string + "\">" + string + "</a></body></html>");
            propertyInfo54.hasLink = false;
            int n10 = this.adapterInfo.getcluster_MR_CTRL_INFO().getClusterPeerMismatch();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (cluster_MR_CTRL_INFO2.getCtrlPropIncompatible() == 1) {
                arrayList2.add(new String(Resource.getString("MISMATCH_CTRL_PROP", "Controller Property Mismatch")));
            }
            if (cluster_MR_CTRL_INFO2.getFwVersionMismatch() == 1) {
                arrayList2.add(new String(Resource.getString("MISMATCH_FW_VERSION", "FW Level Mismatch")));
            }
            if (cluster_MR_CTRL_INFO2.getHwIncompatible() == 1) {
                arrayList2.add(new String(Resource.getString("MISMATCH_CTRL_HARDWARE", "HW Incompatibility ")));
            }
            if (cluster_MR_CTRL_INFO2.getPremiumFeatureMismatch() == 1) {
                arrayList2.add(new String(Resource.getString("MISMATCH_PREMIUM_FEATURE", "Premium Features Mismatch")));
            }
            String string2 = "";
            String string3 = " ";
            PropertyInfo propertyInfo55 = new PropertyInfo();
            if (arrayList2.size() > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (i < 2) {
                        if (i == 0) {
                            string2 = (String)arrayList2.get(i);
                            continue;
                        }
                        string2 = string2 + " / " + (String)arrayList2.get(i);
                        continue;
                    }
                    string3 = i == 2 ? (String)arrayList2.get(i) : string3 + " / " + (String)arrayList2.get(i);
                }
                propertyInfo54.value = string2;
                arrayList.add(propertyInfo54);
                if (arrayList2.size() > 2) {
                    propertyInfo55.value = string3;
                    arrayList.add(propertyInfo55);
                }
            } else {
                propertyInfo54.value = string2 = "None";
                arrayList.add(propertyInfo54);
            }
        }
        if (this.m_isSSCEnabled) {
            PropertyInfo propertyInfo56 = new PropertyInfo();
            propertyInfo56.name = this.isCSA() ? Resource.getString("PROP_CSA_CACHECADE_TEXT", "<html><b>Nytro\u2122 Cache Properties:</b></html>") : Resource.getString("PROP_CACHECADE_PROP", "<html><b>CacheCade\u2122 Properties:</b></html>");
            arrayList.add(propertyInfo56);
            PropertyInfo propertyInfo57 = new PropertyInfo();
            if (this.isCSA()) {
                propertyInfo57.name = Resource.getString("CSA_CACHECADE_TEXT", "Nytro\u2122 Cache");
                propertyInfo57.description = Resource.getString("CSA_CACHECADE_TEXT", "Nytro\u2122 Cache");
            } else {
                propertyInfo57.name = Resource.getString("CACHECADE_TEXT", "CacheCade\u2122 - SSD Caching");
                propertyInfo57.description = Resource.getString("CACHECADE_TEXT", "CacheCade\u2122 - SSD Caching");
            }
            propertyInfo57.value = this.m_isSSCEnabled ? Resource.getString("PROPERTY_ENABLED", "Enabled") : Resource.getString("PROPERTY_DISABLED", "Disabled");
            arrayList.add(propertyInfo57);
            PropertyInfo propertyInfo58 = new PropertyInfo();
            propertyInfo58.name = Resource.getString("PROPERTY_WRITECACHE_CAPABLE_TEXT", "Write Cache Capable");
            propertyInfo58.description = Resource.getString("PROPERTY_WRITECACHE_CAPABLE_TEXT", "Write Cache Capable");
            propertyInfo58.value = this.adapterInfo.getldOperations_MR_CTRL_INFO().isSupportSSCWriteBack() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
            arrayList.add(propertyInfo58);
            PropertyInfo propertyInfo59 = new PropertyInfo();
            propertyInfo59.name = Resource.getString("PROPERTY_TOTAL_CACHE_SIZE", "Total Cache Size");
            propertyInfo59.description = Resource.getString("PROPERTY_TOTAL_CACHE_SIZE", "Total Cache Size");
            propertyInfo59.value = KernelConstants.getConvertedSize(this.getCurrentSSCSizeInBlocks());
            arrayList.add(propertyInfo59);
            PropertyInfo propertyInfo60 = new PropertyInfo();
            propertyInfo60.name = Resource.getString("PROPERTY_MAXIMUM_CACHE_SIZE", "Maximum Cache Size");
            propertyInfo60.description = Resource.getString("PROPERTY_MAXIMUM_CACHE_SIZE", "Maximum Cache Size");
            propertyInfo60.value = KernelConstants.getConvertedSize(this.getMaxSSCSizeInBlocks());
            arrayList.add(propertyInfo60);
        }
        if (this.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportEmergencySpares() != 0) {
            PropertyInfo propertyInfo61 = new PropertyInfo();
            propertyInfo61.name = Resource.getString("PROP_EMERGENCY_PROP", "<html><b>Emergency Spare Properties:</b></html>");
            arrayList.add(propertyInfo61);
            PropertyInfo propertyInfo62 = new PropertyInfo();
            propertyInfo62.name = Resource.getString("PROPERTY_EMERGENCY_SPARE", "Emergency Spare");
            propertyInfo62.value = this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getUseGlobalForEmergency() && this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getuseUnconfiguredForEmergency() ? Resource.getString("PROPERTY_EMERGENCY_UG_AND_GH", "Unconfigured Good & Global Hotspare") : (this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getuseUnconfiguredForEmergency() ? Resource.getString("PROPERTY_EMERGENCY_UG", "Unconfigured Good") : (this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getUseGlobalForEmergency() ? Resource.getString("PROPERTY_EMERGENCY_GH", "Global Hotspare") : Resource.getString("PROPERTY_EMERGENCY_NONE", "None")));
            propertyInfo62.description = Resource.getString("PROPERTY_EMERGENCY_SPARE", "Emergency Spare");
            arrayList.add(propertyInfo62);
            PropertyInfo propertyInfo63 = new PropertyInfo();
            propertyInfo63.name = Resource.getString("PROPERTY_EMERGENCY_SMARTER", "Emergency for SMARTer");
            propertyInfo63.value = this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getUseEmergencyForSMARTer() ? Resource.getString("PROPERTY_EMERGENCY_ENABLED", "Enabled") : Resource.getString("PROPERTY_EMERGENCY_DISABLED", "Disabled");
            propertyInfo63.description = Resource.getString("PROPERTY_EMERGENCY_SMARTER", "Emergency for SMARTer");
            arrayList.add(propertyInfo63);
        }
        return arrayList;
    }

    public void createPhysicalDrives() {
        if (this.pdHelpers != null) {
            for (int i = 0; i < this.pdHelpers.length; ++i) {
                this.pdHelpers[i].deleteObservers();
            }
        }
        try {
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)4096);
            if (arrayList == null || arrayList.size() <= 0) {
                System.out.println("No Physical Drive found on Controller");
                this.pdHelpers = new PhysicalDriveHelper[0];
                return;
            }
            this.pdHelpers = new PhysicalDriveHelper[arrayList.size()];
            for (int i = 0; i < this.pdHelpers.length; ++i) {
                this.pdHelpers[i] = new PhysicalDriveHelper((SASPhysicalDrive)arrayList.get(i), this);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Physical Devices ...");
            exception.printStackTrace();
        }
    }

    public PhysicalDriveHelper[] getPhysicalDrives() {
        return this.pdHelpers;
    }

    public PhysicalDriveHelper[] getLockedPhysicalDrives() {
        int n = 0;
        for (int i = 0; i < this.pdHelpers.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.pdHelpers[i].getDeviceObject();
            boolean bl = sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getLocked();
            if (!bl) continue;
            ++n;
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[n];
        n = 0;
        for (int i = 0; i < this.pdHelpers.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.pdHelpers[i].getDeviceObject();
            boolean bl = sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getLocked();
            if (!bl) continue;
            physicalDriveHelperArray[n] = this.pdHelpers[i];
            ++n;
        }
        return physicalDriveHelperArray;
    }

    public PhysicalDriveHelper[] getPhysicalDrives(int n) {
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        try {
            if (this.pdHelpers == null || this.pdHelpers.length <= 0) {
                return null;
            }
            for (int i = 0; i < this.pdHelpers.length; ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.pdHelpers[i].getDeviceObject();
                if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() == 0) {
                    char c = sASPhysicalDrive.getInformation().getconnectedAdapterPort();
                    if ((1 << n & c) == 0 || NetworkToJavaConverter.unsignedIntToLong(this.pdHelpers[i].getEnclosureID()) != 65535L) continue;
                    arrayList.add(this.pdHelpers[i]);
                    continue;
                }
                if (sASPhysicalDrive.getAddress().getLowerPortNumber() == n && NetworkToJavaConverter.unsignedIntToLong(this.pdHelpers[i].getEnclosureID()) == 65535L) {
                    arrayList.add(this.pdHelpers[i]);
                }
                if (sASPhysicalDrive.getAddress().getUpperPortNumber() != n || NetworkToJavaConverter.unsignedIntToLong(this.pdHelpers[i].getEnclosureID()) != 65535L) continue;
                arrayList.add(this.pdHelpers[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Physical Devices ...");
            exception.printStackTrace();
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[arrayList.size()];
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            physicalDriveHelperArray[i] = (PhysicalDriveHelper)arrayList.get(i);
        }
        return physicalDriveHelperArray;
    }

    public LogicalDriveHelper[] getLogicalDrives() {
        return this.ldHelpers;
    }

    public void createLogicalDrives() {
        if (this.ldHelpers != null) {
            for (int i = 0; i < this.ldHelpers.length; ++i) {
                this.ldHelpers[i].deleteObservers();
            }
        }
        try {
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)8192);
            if (arrayList == null || arrayList.size() <= 0) {
                System.out.println("No Logical Drive found on Controller");
                this.ldHelpers = new LogicalDriveHelper[0];
                return;
            }
            this.ldHelpers = new LogicalDriveHelper[arrayList.size()];
            for (int i = 0; i < this.ldHelpers.length; ++i) {
                this.ldHelpers[i] = new LogicalDriveHelper((SASLogicalDrive)arrayList.get(i), this);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Logical Devices ...");
            exception.printStackTrace();
        }
    }

    public String getCOEmessage(String string) {
        String string2 = null;
        int n = Integer.parseInt(string);
        switch (n) {
            case 0: {
                string2 = Resource.getString("STOP_ON_ERROR", "Stop On Errors");
                break;
            }
            case 1: {
                string2 = Resource.getString("PAUSE_ON_ERROR", "Pause On Errors");
                break;
            }
            case 2: {
                string2 = Resource.getString("IGNORE_ON_ERROR", "Ignore Errors");
                break;
            }
            case 3: {
                string2 = Resource.getString("SAFE_MODE_BOOT", "Safe Mode On Errors");
            }
        }
        return string2;
    }

    public ArrayHelper[] getArrays() {
        return this.arrayHelpers;
    }

    public void createArrays() {
        try {
            int n;
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)16384);
            if (arrayList == null || arrayList.size() <= 0) {
                System.out.println("No Arrays found on Controller");
                this.arrayHelpers = new ArrayHelper[0];
                return;
            }
            this.arrayHelpers = new ArrayHelper[arrayList.size()];
            for (n = 0; n < this.arrayHelpers.length; ++n) {
                this.arrayHelpers[n] = new ArrayHelper((SASArray)arrayList.get(n), this);
            }
            for (n = 0; n < this.arrayHelpers.length; ++n) {
                this.arrayHelpers[n].initSlicedForBootVolume();
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Arrays ...");
            exception.printStackTrace();
        }
    }

    public void createPeerServerLogicalDrives() {
        int n;
        this.peerLdArrayList = new ArrayList();
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = null;
        try {
            mR_LD_TARGETID_LIST = ((SASAdapter)this.getDeviceObject()).getPeerServerLds();
            for (n = 0; n < mR_LD_TARGETID_LIST.getCount(); ++n) {
                this.peerLdArrayList.add(mR_LD_TARGETID_LIST.getTargetId()[n]);
                System.out.println("inside peer peerLogicalDrivesIds" + mR_LD_TARGETID_LIST.getTargetId()[n]);
            }
        }
        catch (Exception exception) {
            mR_LD_TARGETID_LIST = null;
        }
        try {
            if (this.peerLdArrayList == null || this.peerLdArrayList.size() <= 0) {
                System.out.println("No Logical Drive found on Controller");
                this.peerServerLdHelper = new PeerServerLdHelper[0];
                return;
            }
            this.peerServerLdHelper = new PeerServerLdHelper[this.peerLdArrayList.size()];
            for (n = 0; n < this.peerLdArrayList.size(); ++n) {
                this.peerServerLdHelper[n] = new PeerServerLdHelper(this, (Byte)this.peerLdArrayList.get(n));
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Logical Devices ...");
            exception.printStackTrace();
        }
        this.getPeerServersLdAccess();
    }

    public ArrayList getPeerLdArrayList() {
        return this.peerLdArrayList;
    }

    public void setPeerLdArrayList(ArrayList arrayList) {
        this.peerLdArrayList = arrayList;
    }

    public PeerServerLdHelper[] getPeerServerLogicalDrives() {
        return this.peerServerLdHelper;
    }

    public HashMap getPeerServersLdAccess() {
        int n;
        ArrayList arrayList = this.getPeerLdArrayList();
        HashMap hashMap = new HashMap();
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        ArrayList arrayList3 = new ArrayList();
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = null;
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST2 = null;
        try {
            mR_LD_TARGETID_LIST = ((SASAdapter)this.getDeviceObject()).getAllSharedLds();
            for (n = 0; n < mR_LD_TARGETID_LIST.getCount(); ++n) {
                arrayList2.add(mR_LD_TARGETID_LIST.getTargetId()[n]);
                System.out.println("inside peer peerLogicalDrivesIds" + mR_LD_TARGETID_LIST.getTargetId()[n]);
            }
        }
        catch (Exception exception) {
            mR_LD_TARGETID_LIST = null;
        }
        try {
            mR_LD_TARGETID_LIST2 = ((SASAdapter)this.getDeviceObject()).getAllSharedLds();
            for (n = 0; n < mR_LD_TARGETID_LIST2.getCount(); ++n) {
                arrayList2.add(mR_LD_TARGETID_LIST2.getTargetId()[n]);
                System.out.println("inside peer peerLogicalDrivesIds" + mR_LD_TARGETID_LIST2.getTargetId()[n]);
            }
        }
        catch (Exception exception) {
            mR_LD_TARGETID_LIST2 = null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                if (!arrayList.contains(iterator.next())) continue;
                hashMap.put(arrayList.get(i), "Shared");
            }
            Iterator iterator2 = arrayList3.iterator();
            while (iterator2.hasNext()) {
                if (!arrayList.contains(iterator2.next())) continue;
                hashMap.put(arrayList.get(i), "Exclusive");
            }
        }
        return hashMap;
    }

    public PortHelper[] getPorts() {
        return this.portHelpers;
    }

    public void createPorts() {
        int n = Math.max(this.getMaxPortCount(), this.adapter.getPortCount());
        this.adapter.getInformation().getdeviceInterface_MR_CTRL_INFO().setportCount((byte)n);
        this.adapter.setMaxPortCount(n);
        this.portHelpers = new PortHelper[n];
        for (int i = 0; i < this.portHelpers.length; ++i) {
            this.portHelpers[i] = new PortHelper(this, i);
        }
    }

    public int getMaxPortCount() {
        int n = 0;
        try {
            n = Math.max(n, this.getHighestPortFromEnclosureList());
            n = Math.max(n, this.getHighestPortFromPDList());
            n = Math.max(n, this.getHighestPortFromCDROMList());
            n = Math.max(n, this.getHighestPortFromTapeList());
        }
        catch (Exception exception) {
            System.out.println("Exception while finding max port count ...");
            exception.printStackTrace();
            return n;
        }
        return n;
    }

    private int getHighestPortFromEnclosureList() {
        int n = 0;
        try {
            if (this.encHelpers == null || this.encHelpers.length <= 0) {
                return n;
            }
            for (int i = 0; i < this.encHelpers.length; ++i) {
                SASEnclosure sASEnclosure = (SASEnclosure)this.encHelpers[i].getDeviceObject();
                if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() == 0) {
                    int n2 = sASEnclosure.getInformation().getconnectedAdapterPort() & 0xFF;
                    int n3 = 0;
                    if (n2 <= 0) continue;
                    while ((n2 >>= 1) != 0) {
                        ++n3;
                    }
                    n = Math.max(n3 + 1, n);
                    continue;
                }
                n = Math.max(sASEnclosure.getAddress().getLowerPortNumber() + 1, n);
                n = Math.max(sASEnclosure.getAddress().getUpperPortNumber() + 1, n);
            }
        }
        catch (Exception exception) {
            return n;
        }
        return n;
    }

    private int getHighestPortFromPDList() {
        int n = 0;
        try {
            if (this.pdHelpers == null || this.pdHelpers.length <= 0) {
                return n;
            }
            for (int i = 0; i < this.pdHelpers.length; ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.pdHelpers[i].getDeviceObject();
                if (NetworkToJavaConverter.unsignedIntToLong(sASPhysicalDrive.getInformation().getenclDeviceId()) != 65535L) continue;
                if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() == 0) {
                    int n2 = sASPhysicalDrive.getInformation().getconnectedAdapterPort() & 0xFF;
                    int n3 = 0;
                    if (n2 <= 0) continue;
                    while ((n2 >>= 1) != 0) {
                        ++n3;
                    }
                    n = Math.max(n3 + 1, n);
                    continue;
                }
                n = Math.max(sASPhysicalDrive.getAddress().getLowerPortNumber() + 1, n);
                n = Math.max(sASPhysicalDrive.getAddress().getUpperPortNumber() + 1, n);
            }
        }
        catch (Exception exception) {
            return n;
        }
        return n;
    }

    private int getHighestPortFromCDROMList() {
        int n = 0;
        try {
            if (this.cdromHelper == null || this.cdromHelper.length <= 0) {
                return n;
            }
            for (int i = 0; i < this.cdromHelper.length; ++i) {
                SASCDROM sASCDROM = (SASCDROM)this.cdromHelper[i].getDeviceObject();
                if (NetworkToJavaConverter.unsignedIntToLong(sASCDROM.getInformation().getenclDeviceId()) != 65535L) continue;
                if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() == 0) {
                    int n2 = sASCDROM.getInformation().getconnectedAdapterPort() & 0xFF;
                    int n3 = 0;
                    if (n2 <= 0 && NetworkToJavaConverter.unsignedIntToLong(sASCDROM.getInformation().getenclDeviceId()) != 65535L) continue;
                    while ((n2 >>= 1) != 0) {
                        ++n3;
                    }
                    n = Math.max(n3 + 1, n);
                    continue;
                }
                n = Math.max(sASCDROM.getAddress().getLowerPortNumber() + 1, n);
                n = Math.max(sASCDROM.getAddress().getUpperPortNumber() + 1, n);
            }
        }
        catch (Exception exception) {
            return n;
        }
        return n;
    }

    private int getHighestPortFromTapeList() {
        int n = 0;
        try {
            if (this.tapeHelper == null || this.tapeHelper.length <= 0) {
                return n;
            }
            for (int i = 0; i < this.tapeHelper.length; ++i) {
                SASTape sASTape = (SASTape)this.tapeHelper[i].getDeviceObject();
                if (NetworkToJavaConverter.unsignedIntToLong(sASTape.getInformation().getenclDeviceId()) != 65535L) continue;
                if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() == 0) {
                    int n2 = sASTape.getInformation().getconnectedAdapterPort() & 0xFF;
                    int n3 = 0;
                    if (n2 <= 0 && NetworkToJavaConverter.unsignedIntToLong(sASTape.getInformation().getenclDeviceId()) != 65535L) continue;
                    while ((n2 >>= 1) != 0) {
                        ++n3;
                    }
                    n = Math.max(n3 + 1, n);
                    continue;
                }
                n = Math.max(sASTape.getAddress().getLowerPortNumber() + 1, n);
                n = Math.max(sASTape.getAddress().getUpperPortNumber() + 1, n);
            }
        }
        catch (Exception exception) {
            return n;
        }
        return n;
    }

    public BBUHelper getBBU() {
        return this.bbuHelper;
    }

    public void createBBU() {
        if (this.bbuHelper != null) {
            this.bbuHelper.deleteObservers();
        }
        try {
            SASBatteryBackUp sASBatteryBackUp = this.adapter.getBBUObject();
            this.bbuHelper = sASBatteryBackUp != null ? new BBUHelper(this, sASBatteryBackUp) : null;
        }
        catch (Exception exception) {
            this.bbuHelper = null;
        }
    }

    public EnclosureHelper[] getEnclosures() {
        return this.encHelpers;
    }

    public EnclosureHelper[] getEnclosures(int n) {
        ArrayList<EnclosureHelper> arrayList = new ArrayList<EnclosureHelper>();
        try {
            if (this.encHelpers == null || this.encHelpers.length <= 0) {
                return null;
            }
            for (int i = 0; i < this.encHelpers.length; ++i) {
                SASEnclosure sASEnclosure = (SASEnclosure)this.encHelpers[i].getDeviceObject();
                if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() == 0) {
                    char c = sASEnclosure.getInformation().getconnectedAdapterPort();
                    if ((1 << n & c) == 0) continue;
                    arrayList.add(this.encHelpers[i]);
                    continue;
                }
                if (sASEnclosure.getAddress().getLowerPortNumber() == n) {
                    arrayList.add(this.encHelpers[i]);
                }
                if (sASEnclosure.getAddress().getUpperPortNumber() != n) continue;
                arrayList.add(this.encHelpers[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Enclosures ...");
            exception.printStackTrace();
        }
        EnclosureHelper[] enclosureHelperArray = new EnclosureHelper[arrayList.size()];
        for (int i = 0; i < enclosureHelperArray.length; ++i) {
            enclosureHelperArray[i] = (EnclosureHelper)arrayList.get(i);
        }
        return enclosureHelperArray;
    }

    public void createEnclosures() {
        try {
            int n;
            short s = 4109;
            ArrayList arrayList = this.adapter.getSASObjectsArrayList(s);
            short s2 = 4127;
            ArrayList arrayList2 = this.adapter.getSASObjectsArrayList(s2);
            if (arrayList == null && arrayList2 == null || arrayList.size() <= 0 && arrayList2.size() <= 0) {
                this.encHelpers = new EnclosureHelper[0];
                return;
            }
            EnclosureHelper[] enclosureHelperArray = new EnclosureHelper[arrayList.size() + arrayList2.size()];
            int n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                enclosureHelperArray[n2++] = new EnclosureHelper((SASEnclosure)arrayList.get(n), this);
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                if (arrayList == null || arrayList.contains(arrayList2.get(n))) continue;
                enclosureHelperArray[n2++] = new EnclosureHelper((SASEnclosure)arrayList2.get(n), this);
            }
            this.removePartnerEnclosure(enclosureHelperArray);
            this.assignBackplaneID(this.encHelpers);
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Enclosures ...");
            exception.printStackTrace();
        }
    }

    public void createCDROMs() {
        if (this.cdromHelper != null) {
            for (int i = 0; i < this.cdromHelper.length; ++i) {
                this.cdromHelper[i].deleteObservers();
            }
        }
        try {
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)4101);
            if (arrayList == null || arrayList.size() <= 0) {
                System.out.println("No CDROM found on Controller");
                this.cdromHelper = new CDROMHelper[0];
                return;
            }
            this.cdromHelper = new CDROMHelper[arrayList.size()];
            for (int i = 0; i < this.cdromHelper.length; ++i) {
                this.cdromHelper[i] = new CDROMHelper((SASCDROM)arrayList.get(i), this);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding CDROM Devices ...");
            exception.printStackTrace();
        }
    }

    public CDROMHelper[] getGhostCDROMs() {
        if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() != 0) {
            return new CDROMHelper[0];
        }
        ArrayList<CDROMHelper> arrayList = new ArrayList<CDROMHelper>();
        for (int i = 0; i < this.cdromHelper.length; ++i) {
            SASCDROM sASCDROM = (SASCDROM)this.cdromHelper[i].getDeviceObject();
            if (NetworkToJavaConverter.unsignedIntToLong(this.cdromHelper[i].getEnclosureID()) != 65535L || sASCDROM.getInformation().getconnectedAdapterPort() != '\u0000') continue;
            arrayList.add(this.cdromHelper[i]);
        }
        CDROMHelper[] cDROMHelperArray = new CDROMHelper[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            cDROMHelperArray[i] = (CDROMHelper)arrayList.get(i);
        }
        return cDROMHelperArray;
    }

    public CDROMHelper[] getCDROMs() {
        return this.cdromHelper;
    }

    public CDROMHelper[] getCDROMs(int n) {
        ArrayList<CDROMHelper> arrayList = new ArrayList<CDROMHelper>();
        try {
            if (this.cdromHelper == null || this.cdromHelper.length <= 0) {
                return null;
            }
            for (int i = 0; i < this.cdromHelper.length; ++i) {
                SASCDROM sASCDROM = (SASCDROM)this.cdromHelper[i].getDeviceObject();
                char c = sASCDROM.getInformation().getconnectedAdapterPort();
                if ((1 << n & c) == 0 || NetworkToJavaConverter.unsignedIntToLong(this.cdromHelper[i].getEnclosureID()) != 65535L) continue;
                arrayList.add(this.cdromHelper[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Physical Devices ...");
            exception.printStackTrace();
        }
        CDROMHelper[] cDROMHelperArray = new CDROMHelper[arrayList.size()];
        for (int i = 0; i < cDROMHelperArray.length; ++i) {
            cDROMHelperArray[i] = (CDROMHelper)arrayList.get(i);
        }
        return cDROMHelperArray;
    }

    public void createTapes() {
        if (this.tapeHelper != null) {
            for (int i = 0; i < this.tapeHelper.length; ++i) {
                this.tapeHelper[i].deleteObservers();
            }
        }
        try {
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)4097);
            if (arrayList == null || arrayList.size() <= 0) {
                System.out.println("No Tape found on Controller");
                this.tapeHelper = new TapeHelper[0];
                return;
            }
            this.tapeHelper = new TapeHelper[arrayList.size()];
            for (int i = 0; i < this.tapeHelper.length; ++i) {
                this.tapeHelper[i] = new TapeHelper((SASTape)arrayList.get(i), this);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Tape Devices ...");
            exception.printStackTrace();
        }
    }

    public TapeHelper[] getGhostTapes() {
        if (this.adapterInfo.getadapterOperations_MR_CTRL_INFO().getSupportMoreThan8Phys() != 0) {
            return new TapeHelper[0];
        }
        ArrayList<TapeHelper> arrayList = new ArrayList<TapeHelper>();
        for (int i = 0; i < this.tapeHelper.length; ++i) {
            SASTape sASTape = (SASTape)this.tapeHelper[i].getDeviceObject();
            if (NetworkToJavaConverter.unsignedIntToLong(this.tapeHelper[i].getEnclosureID()) != 65535L || sASTape.getInformation().getconnectedAdapterPort() != '\u0000') continue;
            arrayList.add(this.tapeHelper[i]);
        }
        TapeHelper[] tapeHelperArray = new TapeHelper[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            tapeHelperArray[i] = (TapeHelper)arrayList.get(i);
        }
        return tapeHelperArray;
    }

    public TapeHelper[] getTapes() {
        return this.tapeHelper;
    }

    public TapeHelper[] getTapes(int n) {
        ArrayList<TapeHelper> arrayList = new ArrayList<TapeHelper>();
        try {
            if (this.tapeHelper == null || this.tapeHelper.length <= 0) {
                return null;
            }
            for (int i = 0; i < this.tapeHelper.length; ++i) {
                SASTape sASTape = (SASTape)this.tapeHelper[i].getDeviceObject();
                char c = sASTape.getInformation().getconnectedAdapterPort();
                if ((1 << n & c) == 0 || NetworkToJavaConverter.unsignedIntToLong(this.tapeHelper[i].getEnclosureID()) != 65535L) continue;
                arrayList.add(this.tapeHelper[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("ExcepTion while finding Physical Devices ...");
            exception.printStackTrace();
        }
        TapeHelper[] tapeHelperArray = new TapeHelper[arrayList.size()];
        for (int i = 0; i < tapeHelperArray.length; ++i) {
            tapeHelperArray[i] = (TapeHelper)arrayList.get(i);
        }
        return tapeHelperArray;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        if (!(notifyObject.getNotifyObject() instanceof MR_EVT_DETAIL)) {
            return;
        }
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            Object object2;
            switch (mR_EVT_DETAIL.getcode()) {
                case 314: {
                    this.createPhysicalDrives();
                }
                case 308: 
                case 311: 
                case 341: {
                    VivaldiStartupDialog.mainScreen.getPhysicalTree().repaint();
                    VivaldiStartupDialog.mainScreen.getLogicalTree().repaint();
                    break;
                }
                case 338: {
                    if (this.parent.getServerObjectHelperCount() <= 1) break;
                    VivaldiStartupDialog.mainScreen.refreshPeerServerNode();
                    this.init();
                    if (VivaldiStartupDialog.mainScreen == null) {
                        return;
                    }
                    object2 = VivaldiStartupDialog.mainScreen.getLastScreenPosition();
                    VivaldiStartupDialog.mainScreen.refreshVirtualPanel();
                    VivaldiStartupDialog.mainScreen.refreshPhysicalPanel();
                    VivaldiStartupDialog.mainScreen.selectPreviousNode((LastScreenPosition)object2);
                    break;
                }
            }
            if (notifyObject.getNotifyCode() == 0x102001 || notifyObject.getNotifyCode() == 0x102002 || notifyObject.getNotifyCode() == 1056771) {
                if (mR_EVT_DETAIL.getcode() == 463 || mR_EVT_DETAIL.getcode() == 462 || mR_EVT_DETAIL.getcode() == 461 || mR_EVT_DETAIL.getcode() == 460) {
                    VivaldiStartupDialog.mainScreen.refreshPeerServerNode();
                    VivaldiStartupDialog.mainScreen.getPhysicalTree().repaint();
                    VivaldiStartupDialog.mainScreen.getLogicalTree().repaint();
                }
                this.init();
                if (VivaldiStartupDialog.mainScreen == null) {
                    return;
                }
                object2 = VivaldiStartupDialog.mainScreen.getLastScreenPosition();
                VivaldiStartupDialog.mainScreen.refreshVirtualPanel();
                VivaldiStartupDialog.mainScreen.refreshPhysicalPanel();
                VivaldiStartupDialog.mainScreen.selectPreviousNode((LastScreenPosition)object2);
            } else if (notifyObject.getNotifyCode() == 1056772) {
                this.init();
                if (VivaldiStartupDialog.mainScreen == null) {
                    return;
                }
                object2 = VivaldiStartupDialog.mainScreen.getLastScreenPosition();
                VivaldiStartupDialog.mainScreen.refreshVirtualPanel();
                VivaldiStartupDialog.mainScreen.refreshPhysicalPanel();
                VivaldiStartupDialog.mainScreen.selectPreviousNode((LastScreenPosition)object2);
            } else {
                this.getAdapterProperties();
            }
            if (mR_EVT_DETAIL.getcode() == 323 || mR_EVT_DETAIL.getcode() == 296 || mR_EVT_DETAIL.getcode() == 325 || mR_EVT_DETAIL.getcode() == 326 || mR_EVT_DETAIL.getcode() == 220) {
                this.getAdapterProperties();
            }
            if (mR_EVT_DETAIL.getcode() == 341) {
                object2 = new StringBuffer("<html>Controller : " + this.getText());
                ((StringBuffer)object2).append(Resource.getString("CONFIRM_EKM_MODE_ENABLED_DESC", "<br><br>Security is enabled on this controller using Enhanced Key<br>Management (EKM) mode.<br><br></html>"));
                if (JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, object2, Resource.getString("TITLE_CONFIRM_EKM_MODE_ENABLED", "Confirm Enhanced Key Management(EKM) Mode Enabled"), -1, 1) == 0) {
                    return;
                }
            }
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.parent;
    }

    public MR_CTRL_PROP getAdapterProperties() {
        this.adapterInfo = this.adapter.getInformation();
        this.adapterProperties = this.adapterInfo.getproperties();
        return this.adapterProperties;
    }

    public MR_CTRL_INFO getAdapterInfo() {
        return this.adapterInfo;
    }

    public BaseConfigEngine getConfigEngine() throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        this.m_configEngine = this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4 ? new IRConfigEngine(this.adapter) : new ConfigEngine(this.adapter);
        return this.m_configEngine;
    }

    public void init() {
        if (this.adapter.isMRApiIncompatible()) {
            if (this.adapter.isMRApiBkwdIncompatible()) {
                System.out.println("Backward incompatible adapter.App Bkwd Compatibility=0.F/W Bkwd Compatibility=" + this.adapter.getInformation().getMrAPIBkwdCompatibility());
            } else if (this.adapter.isMRApiFWDIncompatible()) {
                System.out.println("Forward incompatible adapter.App Fwd Compatibility=0.F/W Fwd Compatibility=" + this.adapter.getInformation().getMrAPIFwdCompatibility());
            }
            return;
        }
        this.initConstants();
        this.createEnclosures();
        this.createPhysicalDrives();
        this.sortEnclosures(this.encHelpers);
        this.sortPhysicalDrives(this.pdHelpers);
        this.m_associatedLdIds = this.adapter.getAssociatedLdIds();
        this.createLogicalDrives();
        this.createArrays();
        this.createBBU();
        this.createCDROMs();
        this.createTapes();
        if (!displayed) {
            displayed = true;
            try {
                new SnapshotMissedLDsDetailpanel(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getFWVersionFromFile(String string, String string2) {
        byte[] byArray = new byte[4];
        String string3 = "";
        long l = -1L;
        File file = new File(string, string2);
        long l2 = file.length();
        byte[] byArray2 = new byte[(int)l2];
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray2, n, (int)l2);
            int n2 = 0;
            while ((long)n2 < 0L + l2) {
                for (int i = 0; i < FW_HEADER_LOCATION.length; ++i) {
                    String string4;
                    int n3 = n2 + FW_HEADER_LOCATION[i];
                    l = NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n3);
                    if (!this.isValidCheckWord((int)l)) continue;
                    long l3 = 0L;
                    long l4 = 0L;
                    String string5 = "";
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    l3 += l4;
                    string5 = new String(byArray2, n3 + 16, 4).trim();
                    if (!string5.equals(FW_FILE_HEADER_NAME)) continue;
                    n4 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n3 + 20);
                    l4 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n3 + 24);
                    n5 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n3 + 28);
                    n6 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n3 + 32);
                    n7 = (int)NetworkToJavaConverter.byteArrayToUnsignedInt(byArray2, n3 + 36);
                    int n8 = n2 + n6;
                    int n9 = n2 + n7;
                    int n10 = n2 + n5;
                    string3 = string4 = new String(byArray2, n10, 15).trim();
                    n2 = (int)((long)n2 + (l4 - 131072L));
                }
                n2 += 131072;
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    private boolean isValidCheckWord(int n) {
        switch (n) {
            case 843206468: 
            case 843338326: 
            case 942682418: 
            case 943140913: {
                return true;
            }
        }
        return false;
    }

    public void sortPhysicalDrives(PhysicalDriveHelper[] physicalDriveHelperArray) {
        int n;
        Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
        for (n = 0; n < physicalDriveHelperArray.length; ++n) {
            PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray[n];
            vector.add(physicalDriveHelper);
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                if (((PhysicalDriveHelper)vector.get(i)).getInformation().getslotNumber() <= ((PhysicalDriveHelper)vector.get(i + 1)).getInformation().getslotNumber()) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                int n2 = 0;
                int n3 = 0;
                if (((PhysicalDriveHelper)vector.get(i)).getEnclosureHelper() != null) {
                    n2 = ((PhysicalDriveHelper)vector.get(i)).getEnclosureHelper().getEnclIndexInSortedList();
                }
                if (((PhysicalDriveHelper)vector.get(i + 1)).getEnclosureHelper() != null) {
                    n3 = ((PhysicalDriveHelper)vector.get(i + 1)).getEnclosureHelper().getEnclIndexInSortedList();
                }
                if (n2 <= n3) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            physicalDriveHelperArray[n] = (PhysicalDriveHelper)vector.get(n);
        }
    }

    public void notifyMethod(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    private TopologyHelper populateTopologyHelpers(Hashtable hashtable, SL_TOPOLOGY_GENERIC_NODE sL_TOPOLOGY_GENERIC_NODE) {
        if (sL_TOPOLOGY_GENERIC_NODE == null) {
            return null;
        }
        TopologyHelper topologyHelper = null;
        if (hashtable.get(sL_TOPOLOGY_GENERIC_NODE) != null) {
            return (TopologyHelper)hashtable.get(sL_TOPOLOGY_GENERIC_NODE);
        }
        if (sL_TOPOLOGY_GENERIC_NODE instanceof SL_TOPOLOGY_HEAD_NODE_T) {
            topologyHelper = new TopologyHelper(this, sL_TOPOLOGY_GENERIC_NODE);
            hashtable.put(sL_TOPOLOGY_GENERIC_NODE, topologyHelper);
            for (int i = 0; i < sL_TOPOLOGY_GENERIC_NODE.getChildren().length; ++i) {
                TopologyHelper topologyHelper2 = this.populateTopologyHelpers(hashtable, sL_TOPOLOGY_GENERIC_NODE.getChildren()[i]);
                if (topologyHelper2 == null) continue;
                topologyHelper2.getParentList().add(topologyHelper);
                topologyHelper.getChildren().add(topologyHelper2);
            }
        } else if (sL_TOPOLOGY_GENERIC_NODE instanceof SL_TOPOLOGY_EXPANDER_NODE_T) {
            topologyHelper = new TopologyHelper(new ExpanderHelper(this), sL_TOPOLOGY_GENERIC_NODE);
            hashtable.put(sL_TOPOLOGY_GENERIC_NODE, topologyHelper);
            for (int i = 0; i < sL_TOPOLOGY_GENERIC_NODE.getChildren().length; ++i) {
                TopologyHelper topologyHelper3 = this.populateTopologyHelpers(hashtable, sL_TOPOLOGY_GENERIC_NODE.getChildren()[i]);
                if (topologyHelper3 == null) continue;
                topologyHelper3.getParentList().add(topologyHelper);
                topologyHelper.getChildren().add(topologyHelper3);
            }
        } else if (sL_TOPOLOGY_GENERIC_NODE instanceof SL_TOPOLOGY_END_DEVICE_NODE_T) {
            PhysicalDriveHelper physicalDriveHelper = null;
            for (int i = 0; i < this.pdHelpers.length; ++i) {
                if (((SASPhysicalDrive)this.pdHelpers[i].getDeviceObject()).getDeviceId() != ((SL_TOPOLOGY_END_DEVICE_NODE_T)sL_TOPOLOGY_GENERIC_NODE).getDeviceId()) continue;
                physicalDriveHelper = this.pdHelpers[i];
                break;
            }
            if (physicalDriveHelper == null) {
                return null;
            }
            topologyHelper = new TopologyHelper(physicalDriveHelper, sL_TOPOLOGY_GENERIC_NODE);
            hashtable.put(sL_TOPOLOGY_GENERIC_NODE, topologyHelper);
        }
        return topologyHelper;
    }

    private void createTopology() {
        Hashtable hashtable = new Hashtable();
        SL_TOPOLOGY_HEAD_NODE_T sL_TOPOLOGY_HEAD_NODE_T = this.adapter.getTopologyHeadNode();
        this.head = this.populateTopologyHelpers(hashtable, sL_TOPOLOGY_HEAD_NODE_T);
        System.out.println("Created Topology Helpers");
        this.dirty = true;
    }

    public TopologyHelper getTopologyHelper() {
        return this.head;
    }

    public boolean isTopologyDirty() {
        return this.dirty;
    }

    public void cleanTopology() {
        this.dirty = false;
    }

    public MR_CTRL_PROP getCtrlProperties(OperationDetails operationDetails) {
        try {
            return this.adapter.getCtrlProperties(operationDetails);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isLockKeyAssigned() {
        return this.adapter.getInformation().getAdapterStatus_MR_CTRL_INFO().isLockKeyAssigned();
    }

    public boolean isSecuritySupported() {
        return this.adapter.getInformation().getadapterOperations_MR_CTRL_INFO().isSupportSecurity();
    }

    public Vector getSecuredVDList() {
        Vector<String> vector = null;
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDrives();
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0) {
            vector = new Vector<String>();
            for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject();
                MR_LD_PARAMETERS mR_LD_PARAMETERS = sASLogicalDrive.getInformation().getldConfig().getparams();
                if (mR_LD_PARAMETERS.getEncryptionType() != 2) continue;
                vector.add(logicalDriveHelperArray[i].getText());
            }
        }
        return vector;
    }

    public MR_CTRL_LOCK_KEY_PARAMS fireCreateKeyOperation(String string, String string2, String string3, boolean bl) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            if (string3 != null) {
                arrayList.add(string3);
            }
            OperationDetails operationDetails = new OperationDetails(0x1150100, arrayList);
            return this.adapter.createKey(operationDetails, false, bl);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            try {
                this.getDeviceObject().refresh();
            }
            catch (VKNotRespondingException vKNotRespondingException) {
                vKNotRespondingException.printStackTrace();
            }
            catch (VKOperationFailedException vKOperationFailedException2) {
                vKOperationFailedException2.printStackTrace();
            }
            return null;
        }
    }

    public void fireRekeyOperation(String string, String string2, String string3, String string4, boolean bl) throws VKOperationFailedException {
        this.adapter.rekeyController(string, string2, string3, string4, bl);
        try {
            this.getDeviceObject().refresh();
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            vKNotRespondingException.printStackTrace();
        }
    }

    public void fireDestroyKeyOperation() {
        this.adapter.destroyLockKey();
    }

    public String getControllerGeneratedPassPhrase() {
        return this.adapter.suggestPassPhrase();
    }

    public boolean isOnlyFDESupported() {
        return this.adapterProperties.getOnOffProperties_MR_CTRL_PROP().getUseFdeOnly();
    }

    public String getEncryptionMethodDesc() {
        String string = "";
        string = this.isOnlyFDESupported() ? Resource.getString("DESC_ENCR_METHOD_FDE", "FDE Only") : Resource.getString("DESC_ENCR_METHOD_FDE_AND_CTRL", "FDE and Controller-based");
        return string;
    }

    public Vector getFDEEncryptedDriveGroups() {
        Vector<ArrayHelper> vector = new Vector<ArrayHelper>();
        ArrayHelper[] arrayHelperArray = this.getArrays();
        for (int i = 0; i < arrayHelperArray.length; ++i) {
            if (!arrayHelperArray[i].isFDEEncrypted()) continue;
            vector.add(arrayHelperArray[i]);
        }
        return vector;
    }

    public boolean isPassPhraseUsed() {
        return this.getAdapterInfo().getLockKeyBinding() == 2 || this.getAdapterInfo().getLockKeyBinding() == 3;
    }

    public String getKeyIDForController(boolean bl) {
        return this.adapter.getKeyIDForDevice(bl, 65535);
    }

    public Vector getSecuredArrays() {
        Vector<String> vector = null;
        if (this.arrayHelpers != null && this.arrayHelpers.length > 0) {
            vector = new Vector<String>();
            for (int i = 0; i < this.arrayHelpers.length; ++i) {
                if (!this.arrayHelpers[i].isArrayEncrypted()) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Resource.getString("LABEL_DRIVE_GROUP", "Drive Group:"));
                stringBuffer.append(" " + this.arrayHelpers[i].getDeviceObject().getID());
                stringBuffer.append(",");
                stringBuffer.append(Resource.getString("RAID_TEXT", "RAID"));
                stringBuffer.append(" " + this.arrayHelpers[i].getRAIDLevel());
                vector.add(stringBuffer.toString());
            }
        }
        return vector;
    }

    public void sortEnclosures(EnclosureHelper[] enclosureHelperArray) {
        int n;
        Vector<EnclosureHelper> vector = new Vector<EnclosureHelper>();
        for (n = 0; n < enclosureHelperArray.length; ++n) {
            EnclosureHelper enclosureHelper = enclosureHelperArray[n];
            vector.add(enclosureHelper);
            this.setEnclosurePhyNum(enclosureHelper);
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                if (((EnclosureHelper)vector.get(i)).getPhyNum() <= ((EnclosureHelper)vector.get(i + 1)).getPhyNum()) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                if (((EnclosureHelper)vector.get(i)).getEnclConnectorIndex() <= ((EnclosureHelper)vector.get(i + 1)).getEnclConnectorIndex()) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                if (((EnclosureHelper)vector.get(i)).getEnclosurePositionInDaisyChain() <= ((EnclosureHelper)vector.get(i + 1)).getEnclosurePositionInDaisyChain()) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        this.encHelpers = new EnclosureHelper[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.encHelpers[n] = (EnclosureHelper)vector.get(n);
        }
        for (n = 0; n < this.encHelpers.length; ++n) {
            this.encHelpers[n].setEnclIndexInSortedList(n);
        }
    }

    public void removePartnerEnclosure(EnclosureHelper[] enclosureHelperArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = enclosureHelperArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (enclosureHelperArray[n2] == null || (n = ((SASEnclosure)enclosureHelperArray[n2].getDeviceObject()).getInformation().getenclPartnerDeviceId()) == -1) continue;
            for (int i = n2 + 1; i < n4; ++i) {
                short s;
                if (enclosureHelperArray[i] == null || n != (s = ((SASEnclosure)enclosureHelperArray[i].getDeviceObject()).getInformation().getenclDeviceId())) continue;
                if (enclosureHelperArray[n2].getConnectorIndex() == enclosureHelperArray[i].getConnectorIndex()) {
                    if (enclosureHelperArray[n2].getEnclosureStatus().getenclPosition() < enclosureHelperArray[i].getEnclosureStatus().getenclPosition()) {
                        enclosureHelperArray[n2].setPartnerConnectorName(enclosureHelperArray[i].getConnectorname());
                        enclosureHelperArray[i] = null;
                        continue;
                    }
                    if (enclosureHelperArray[n2].getEnclosureStatus().getenclPosition() > enclosureHelperArray[i].getEnclosureStatus().getenclPosition()) {
                        enclosureHelperArray[i].setPartnerConnectorName(enclosureHelperArray[n2].getConnectorname());
                        enclosureHelperArray[n2] = null;
                        continue;
                    }
                    System.out.println("Code should never reach here!!");
                    System.out.println("Both enclosures have the same connectorindex as well as same enclosure position.");
                    continue;
                }
                if (enclosureHelperArray[n2].getConnectorIndex() < enclosureHelperArray[i].getConnectorIndex()) {
                    enclosureHelperArray[n2].setPartnerConnectorName(enclosureHelperArray[i].getConnectorname());
                    enclosureHelperArray[i] = null;
                    continue;
                }
                if (enclosureHelperArray[n2].getConnectorIndex() <= enclosureHelperArray[i].getConnectorIndex()) continue;
                enclosureHelperArray[i].setPartnerConnectorName(enclosureHelperArray[n2].getConnectorname());
                enclosureHelperArray[n2] = null;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (enclosureHelperArray[n2] == null) continue;
            ++n3;
        }
        this.encHelpers = new EnclosureHelper[n3];
        n2 = 0;
        for (n = 0; n < enclosureHelperArray.length; ++n) {
            if (enclosureHelperArray[n] == null) continue;
            this.encHelpers[n2++] = enclosureHelperArray[n];
        }
    }

    public PhysicalDriveHelper[] getForeignPhysicalDrivesInPowerSaveMode() {
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        if (this.pdHelpers != null && this.pdHelpers.length > 0) {
            for (int i = 0; i < this.pdHelpers.length; ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.pdHelpers[i].getDeviceObject();
                MR_PD_INFO mR_PD_INFO = sASPhysicalDrive.getInformation();
                pdType_MR_PD_INFO pdType_MR_PD_INFO2 = mR_PD_INFO.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
                if (mR_PD_INFO.getPowerState() != 1 && mR_PD_INFO.getdisabledForRemoval() != '\u0001' || pdType_MR_PD_INFO2.getisForeign() != 1) continue;
                arrayList.add(this.pdHelpers[i]);
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new PhysicalDriveHelper[arrayList.size()]);
            }
        }
        return null;
    }

    public boolean isDriveMixAllowed(byte by, byte by2, byte by3, byte by4, boolean bl) {
        boolean bl2 = false;
        String string = new String();
        int n = this.getAdapterInfo().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
        int n2 = this.getAdapterInfo().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
        int n3 = this.getAdapterInfo().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
        if (!(this.adapter.getAdapterType() != 2 && this.adapter.getAdapterType() != 3 && this.adapter.getAdapterType() != 4 || by3 == by && by4 == by2)) {
            bl2 = false;
            if (bl) {
                string = Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array.");
            }
        } else if (by == by3 && by2 == by4) {
            return true;
        }
        if (by2 != by4 && n == 0) {
            if (bl) {
                string = Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix") + " " + Resource.getString("TEXT_DRIVE_TYPE_SSD", "SSD") + " " + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with") + " " + Resource.getString("TEXT_DRIVE_TYPE_NON_SSD", "non-SSD") + " " + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives.");
            }
            bl2 = false;
        } else if (n3 == 0 && n2 == 0) {
            boolean bl3 = bl2 = by == by3;
            if (bl && !bl2) {
                string = Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array.");
            }
        } else if (n3 == 0 && n2 != 0) {
            if (by4 != by2 || by4 == 1) {
                return true;
            }
            if (by != by3 && by2 == by4 && by4 != 1) {
                bl2 = false;
                string = Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array.");
            } else if (by != by3 && by4 == 1 && by2 != by4) {
                bl2 = false;
                string = Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix") + " " + Resource.getString("TEXT_DRIVE_TYPE_SSD_SAS", "SSD(SAS)") + " " + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with") + " " + Resource.getString("TEXT_DRIVE_TYPE_SSD_SATA", "SSD(SATA)") + " " + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives.");
            } else {
                bl2 = true;
            }
        } else if (n3 != 0 && n2 == 0) {
            if (by4 != by2 || by2 == 1) {
                return true;
            }
            if (by != by3 && by2 == by4 && by4 == 1) {
                bl2 = false;
                string = Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array.");
            } else if (by != by3 && by4 != 1 && by2 != by4) {
                bl2 = false;
                string = Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix") + " " + Resource.getString("TEXT_DRIVE_TYPE_SSD_SAS", "SSD(SAS)") + " " + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with") + " " + Resource.getString("TEXT_DRIVE_TYPE_SSD_SATA", "SSD(SATA)") + " " + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives.");
            } else {
                bl2 = true;
            }
        } else {
            return n3 != 0 && n2 != 0;
        }
        if (bl && !bl2) {
            new CustomMsgBox(string);
        }
        return bl2;
    }

    public boolean isDriveMixAllowed(SASPhysicalDrive sASPhysicalDrive, SASPhysicalDrive sASPhysicalDrive2, boolean bl) {
        if (sASPhysicalDrive.getState() == 2 && sASPhysicalDrive2.getState() == 2 && PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equalsIgnoreCase(Resource.getString("PD_STATE_HOTSPARE_GLOBAL", "Global")) && PhysicalDriveHelper.getHotspareType(sASPhysicalDrive2).equalsIgnoreCase(Resource.getString("PD_STATE_HOTSPARE_GLOBAL", "Global"))) {
            return true;
        }
        return this.isDriveMixAllowed(sASPhysicalDrive.getDriveType(), sASPhysicalDrive.getMediatype(), sASPhysicalDrive2.getDriveType(), sASPhysicalDrive2.getMediatype(), bl);
    }

    public PhysicalDriveHelper[] getUnconfiguredPhysicalDrives() {
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        if (this.pdHelpers != null) {
            Object object;
            Observable observable;
            int n;
            for (n = 0; n < this.pdHelpers.length; n = (int)((short)(n + 1))) {
                observable = (SASPhysicalDrive)this.pdHelpers[n].getDeviceObject();
                object = ((SASPhysicalDevice)observable).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
                char c = ((SASPhysicalDevice)observable).getInformation().getnotSupported();
                if (((SASPhysicalDrive)observable).getState() != 0 || ((pdType_MR_PD_INFO)object).getisForeign() == 1 || c != '\u0000') continue;
                arrayList.add(this.pdHelpers[n]);
            }
            for (n = arrayList.size() - 1; n >= 0; --n) {
                observable = (PhysicalDriveHelper)arrayList.get(n);
                object = (SASPhysicalDrive)((PhysicalDriveHelper)observable).getDeviceObject();
                MR_PD_PROGRESS mR_PD_PROGRESS = ((SASPhysicalDevice)object).getInformation().getprogInfo();
                if (!((SASPhysicalDrive)object).isOSDrive() && mR_PD_PROGRESS.getactive_MR_PD_PROGRESS1().getErase() == 0) continue;
                arrayList.remove(n);
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new PhysicalDriveHelper[arrayList.size()]);
            }
        }
        return null;
    }

    public boolean treatRAID1EasRAID10() {
        if (this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4 || this.adapter.getAdapterType() == 1) {
            try {
                MR_MFC_DEFAULTS mR_MFC_DEFAULTS = this.adapter.getMFCDefaults();
                return mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public MR_PR_STATUS getPatrolReadStatus() {
        try {
            return this.adapter.getPatrolReadStatus();
        }
        catch (Exception exception) {
            System.out.println(" Get PR status failed");
            return null;
        }
    }

    public int getNoOfOnlinePds() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            pdType_MR_PD_INFO pdType_MR_PD_INFO2 = sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
            if (sASPhysicalDrive.getState() != 2 && sASPhysicalDrive.getState() != 24 || pdType_MR_PD_INFO2.getisForeign() == 1) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isEKMSupported() {
        return this.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportEKM();
    }

    public boolean isRebootRequiredToEnableEKM() {
        return this.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isLockKeyRebootRequired();
    }

    public boolean isEKMCPresent() {
        try {
            if (this.adapter.getBIOSData().getEKMStatus() == 16) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean isBAPresent() {
        try {
            if (this.adapter.getBIOSData().getEKMStatus() == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean isEKMSPossible() {
        return this.isEKMSupported() && (this.isEKMCPresent() || this.isBAPresent());
    }

    private String formatFRUString(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[8];
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= 'a' && c <= 'z') {
                cArray2[i] = c;
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                cArray2[i] = c;
                continue;
            }
            if (c < '0' || c > '9') break;
            cArray2[i] = c;
        }
        String string2 = new String(cArray2);
        return string2;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAnyPDtransitioning() {
        int n = this.pdHelpers.length;
        for (int i = 0; i < n; ++i) {
            if (this.pdHelpers[i].getInformation().getPowerState() != -1) continue;
            return true;
        }
        return false;
    }

    public ArrayList<PhysicalDriveHelper> getTransitioningPDs() {
        int n = this.pdHelpers.length;
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        for (int i = 0; i < n; ++i) {
            if (this.pdHelpers[i].getInformation().getPowerState() != -1) continue;
            arrayList.add(this.pdHelpers[i]);
        }
        return arrayList;
    }

    public PhysicalDriveHelper[] getUnconfiguredGoodSSDDrives() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getUnconfiguredPhysicalDrives();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        if (physicalDriveHelperArray != null) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (!physicalDriveHelperArray[i].isSSDDrive() || physicalDriveHelperArray[i].isIneligibleForSSCD()) continue;
                arrayList.add(physicalDriveHelperArray[i]);
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new PhysicalDriveHelper[arrayList.size()]);
            }
            return null;
        }
        return null;
    }

    public LogicalDriveHelper[] getSSCDs() {
        int n;
        LogicalDriveHelper[] logicalDriveHelperArray = null;
        int n2 = this.ldHelpers.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!this.ldHelpers[n].isSSCD()) continue;
            ++n3;
        }
        n = 0;
        logicalDriveHelperArray = new LogicalDriveHelper[n3];
        for (int i = 0; i < n2; ++i) {
            if (!this.ldHelpers[i].isSSCD()) continue;
            int n4 = n;
            n = (byte)(n + 1);
            logicalDriveHelperArray[n4] = this.ldHelpers[i];
        }
        return logicalDriveHelperArray;
    }

    public long getMaxSSCSizeInBlocks() {
        return (long)((SASAdapter)this.getDeviceObject()).getInformation().getMaxSSCsize() * 2048L * 1024L;
    }

    public long getCurrentSSCSizeInBlocks() {
        return (long)((SASAdapter)this.getDeviceObject()).getInformation().getcurrentSSCsize() * 2048L * 1024L;
    }

    public boolean isWindowsAndNotDell() {
        boolean bl = true;
        String string = ((SASServer)this.adapter.parent()).getInformation().OperatingSystemName();
        if (!(string = string.toLowerCase()).contains("windows") || VivaldiStartupDialog.OEM_TYPE == 2561) {
            return false;
        }
        return bl;
    }

    public boolean isViewOnlyMode() {
        boolean bl = false;
        if (((SASServer)this.adapter.parent()).getAccMode() == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isSolaris11() {
        String string = ((SASServer)this.adapter.parent()).getInformation().OperatingSystemVersion();
        return string.equals("5.11");
    }

    public boolean canVDsBeSpunDown() {
        boolean bl = false;
        try {
            if (this.isPowerSaveSupportedOnConfiguredDrives() && this.adapterProperties.getdefaultLdPSPolicy() != -2) {
                bl = true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    public PhysicalDriveHelper[] getEKMSecuredLockedDrives() {
        int n = 0;
        int n2 = 0;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getLockedPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (!physicalDriveHelperArray[i].isEKMSecuredLockedDrive()) continue;
            ++n2;
        }
        if (n2 > 0) {
            PhysicalDriveHelper[] physicalDriveHelperArray2 = new PhysicalDriveHelper[n2];
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (!physicalDriveHelperArray[i].isEKMSecuredLockedDrive()) continue;
                physicalDriveHelperArray2[n++] = physicalDriveHelperArray[i];
            }
            return physicalDriveHelperArray2;
        }
        return null;
    }

    public PhysicalDriveHelper[] getLKMSecuredLockedDrives() {
        int n = 0;
        int n2 = 0;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getLockedPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].isEKMSecuredLockedDrive()) continue;
            ++n2;
        }
        if (n2 > 0) {
            PhysicalDriveHelper[] physicalDriveHelperArray2 = new PhysicalDriveHelper[n2];
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (physicalDriveHelperArray[i].isEKMSecuredLockedDrive()) continue;
                physicalDriveHelperArray2[n++] = physicalDriveHelperArray[i];
            }
            return physicalDriveHelperArray2;
        }
        return null;
    }

    public String getKeyManagementMode() {
        if (!this.isLockKeyAssigned()) {
            return Resource.getString("TEXT_NOT_APPLICABLE", "N/A");
        }
        if (((SASAdapter)this.getDeviceObject()).getInformation().getLockKeyBinding() == 4) {
            return Resource.getString("TEXT_EKM", "EKM");
        }
        return Resource.getString("TEXT_LKM", "LKM");
    }

    public int getEnclosureCount() {
        EnclosureHelper[] enclosureHelperArray = this.getEnclosures();
        int n = enclosureHelperArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (enclosureHelperArray[i].isBackplane()) continue;
            ++n2;
        }
        return n2;
    }

    public int getBackplaneCount() {
        EnclosureHelper[] enclosureHelperArray = this.getEnclosures();
        int n = enclosureHelperArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PhysicalDriveHelper[] physicalDriveHelperArray;
            if (!enclosureHelperArray[i].isBackplane() || (physicalDriveHelperArray = enclosureHelperArray[i].getPhysicalDrives()) == null || physicalDriveHelperArray.length <= 0) continue;
            ++n2;
        }
        return n2;
    }

    public long getTotalCapacity() {
        long l = 0L;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getInformation().getUserDataBlockSize() != 512) {
                l += sASPhysicalDrive.getInformation().getcoercedSize() * (long)(sASPhysicalDrive.getInformation().getUserDataBlockSize() / 512);
                continue;
            }
            l += sASPhysicalDrive.getInformation().getcoercedSize();
        }
        return l;
    }

    public long getUsedCapacity() {
        long l = 0L;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            pdType_MR_PD_INFO pdType_MR_PD_INFO2 = sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
            if (sASPhysicalDrive.getState() != 2 && sASPhysicalDrive.getState() != 24 || pdType_MR_PD_INFO2.getisForeign() == 1) continue;
            if (sASPhysicalDrive.getInformation().getUserDataBlockSize() != 512) {
                l += sASPhysicalDrive.getInformation().getcoercedSize() * (long)(sASPhysicalDrive.getInformation().getUserDataBlockSize() / 512);
                continue;
            }
            l += sASPhysicalDrive.getInformation().getcoercedSize();
        }
        return l;
    }

    public void updateDashboardStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.adapterInfo.getmemUnCorrectableErrorCount() == 0;
        boolean bl2 = false;
        try {
            MR_BBU_FW_STATUS mR_BBU_FW_STATUS;
            bl2 = this.bbuHelper != null ? !((mR_BBU_FW_STATUS = ((SASBatteryBackUp)this.bbuHelper.getDeviceObject()).getStatus().getMrbbufwStatus()).getpackMissing() | mR_BBU_FW_STATUS.getvoltageLow() | mR_BBU_FW_STATUS.gettemperatureHigh()) : true;
        }
        catch (Exception exception) {
            System.out.println("could not get the BBU status in adapterhelper.");
            exception.printStackTrace();
        }
        if (bl && bl2 && this.isEnclosureOptimal() && this.isPDOptimal() && this.isVDOptimal() && this.isControllerInSafeMode()) {
            this.m_isControllerOptimal = true;
            this.m_dashboardStatusString = Resource.getString("STATUS_OPTIMAL", "Optimal");
            this.m_dashboardStatusIcon = Resource.getString("OPTIMAL_ICON", "Optimal.png");
        } else {
            this.m_isControllerOptimal = false;
            this.m_dashboardStatusString = Resource.getString("STATUS_NEEDS_ATTENTION", "Needs attention");
            this.m_dashboardStatusIcon = Resource.getString("NEEDS_ATTENTION_ICON", "NeedAtten.png");
        }
        if (this.adapter.isWarhawk()) {
            if (this.adapter.getWhDDInfo().isDDStatusGood()) {
                this.m_isControllerOptimal = true;
                this.m_dashboardStatusString = Resource.getString("STATUS_OPTIMAL", "Optimal");
                this.m_dashboardStatusIcon = Resource.getString("OPTIMAL_ICON", "Optimal.png");
            }
            if (this.adapter.getWhDDInfo().isDDStatusWarning()) {
                this.m_isControllerOptimal = false;
                this.m_dashboardStatusString = Resource.getString("STATUS_NEEDS_ATTENTION", "Needs attention");
                this.m_dashboardStatusIcon = Resource.getString("NEEDS_ATTENTION_ICON", "NeedAtten.png");
            }
            if (this.adapter.getWhDDInfo().isDDStatusError() || this.adapter.getWhDDInfo().isDDStatusUnknown()) {
                this.m_isControllerOptimal = false;
                this.m_dashboardStatusString = Resource.getString("STATUS_EXHAUSTED", "Exhausted");
                this.m_dashboardStatusIcon = Resource.getString("EXPIRED_ICON", "Expired.png");
            }
        }
    }

    public boolean isControllerOptimal() {
        return this.m_isControllerOptimal;
    }

    public boolean isPDOptimal() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 17 && sASPhysicalDrive.getState() != 16 && sASPhysicalDrive.getState() != 1) continue;
            return false;
        }
        return true;
    }

    public boolean isEnclosureOptimal() {
        EnclosureHelper[] enclosureHelperArray = this.getEnclosures();
        int n = enclosureHelperArray.length;
        for (int i = 0; i < n; ++i) {
            MR_ENCL_INFO mR_ENCL_INFO;
            SL_ENCL_STATUS_T sL_ENCL_STATUS_T = enclosureHelperArray[i].getEnclosureStatus();
            if (sL_ENCL_STATUS_T == null || (mR_ENCL_INFO = sL_ENCL_STATUS_T.getMR_ENCL_INFO()) == null || mR_ENCL_INFO.getisFault() != '\u0001') continue;
            return false;
        }
        return true;
    }

    public boolean isControllerInSafeMode() {
        int n = this.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().getHeadLessMode();
        System.out.println("INSIDE ADAPHELPER headlessval ==" + n);
        return n != 1;
    }

    public boolean isVDOptimal() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDrives();
        int n = logicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            if (logicalDriveHelperArray[i].getLdParameters().getstate() == '\u0003') continue;
            return false;
        }
        return true;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public void setStatus(int n) {
    }

    public MR_DRV_DRIVER_VERSION getMrDrvDriverVersion() {
        SASServer sASServer = (SASServer)this.adapter.parent();
        if (sASServer.isCIMOMServer()) {
            return null;
        }
        if (this.m_drvDriverVersion == null) {
            OperationDetails operationDetails = new OperationDetails(19, null);
            try {
                this.adapter.fireOperation(operationDetails);
                this.m_drvDriverVersion = (MR_DRV_DRIVER_VERSION)operationDetails.getParam();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.m_drvDriverVersion;
        }
        return this.m_drvDriverVersion;
    }

    public boolean isSWRController() {
        char[] cArray;
        String string;
        MR_DRV_DRIVER_VERSION mR_DRV_DRIVER_VERSION = this.getMrDrvDriverVersion();
        return mR_DRV_DRIVER_VERSION != null && ((string = new String(cArray = mR_DRV_DRIVER_VERSION.getdriverName())).contains("MegaSR") || string.contains("megaSR") || string.contains("megasr"));
    }

    private void assignBackplaneID(EnclosureHelper[] enclosureHelperArray) {
        int n;
        String[] stringArray = new String[]{"A", "B", "C", "D"};
        Vector<EnclosureHelper> vector = new Vector<EnclosureHelper>();
        for (n = 0; n < enclosureHelperArray.length; ++n) {
            if (!enclosureHelperArray[n].isBackplane()) continue;
            vector.add(enclosureHelperArray[n]);
        }
        n = vector.size();
        if (n > 1) {
            int n2;
            for (n2 = 0; n2 < n - 1; ++n2) {
                for (int i = 0; i < n - 1 - n2; ++i) {
                    if (((EnclosureHelper)vector.get(i)).getDeviceID() <= ((EnclosureHelper)vector.get(i + 1)).getDeviceID()) continue;
                    Collections.swap(vector, i, i + 1);
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                ((EnclosureHelper)vector.get(n2)).setBackplaneIdentifier(stringArray[n2]);
            }
        }
    }

    private void setEnclosurePhyNum(EnclosureHelper enclosureHelper) {
        byte[] byArray = ((SASEnclosure)enclosureHelper.getDeviceObject()).getInformation().getpathInfo_MR_PD_INFO1().getconnectorIndex();
        byte by = 0;
        by = byArray[0] != -1 ? byArray[0] : (byArray[1] != -1 ? byArray[1] : (byte)-1);
        MR_SAS_PHY_CONNECTIONS mR_SAS_PHY_CONNECTIONS = this.adapter.getPhyConnections();
        if (mR_SAS_PHY_CONNECTIONS != null) {
            MR_SAS_PHY_CONNECTION[] mR_SAS_PHY_CONNECTIONArray = mR_SAS_PHY_CONNECTIONS.getphy();
            for (int i = 0; i < mR_SAS_PHY_CONNECTIONS.getcount(); ++i) {
                if (mR_SAS_PHY_CONNECTIONArray[i].getConnectorIndex() != by) continue;
                enclosureHelper.setPhyNum(mR_SAS_PHY_CONNECTIONArray[i].getphyIdentifier());
                break;
            }
        }
    }

    public int findunconfiguredAndOnlinePdCnt() {
        int n = 0;
        int n2 = 0;
        if (this.pdHelpers != null) {
            n2 = this.pdHelpers.length;
        }
        for (int i = 0; i < n2; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.pdHelpers[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 0 && sASPhysicalDrive.getState() != 1 && sASPhysicalDrive.getState() != 24 && sASPhysicalDrive.getState() != 2) continue;
            ++n;
        }
        return n;
    }

    public void ctrlDataRefresh() {
        this.adapter.ctrlDataRefresh();
        this.adapterInfo = this.adapter.getInformation();
    }

    public PhysicalDriveHelper[] getSystemDrivesList() {
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        if (this.pdHelpers != null) {
            Object object;
            Observable observable;
            int n;
            for (n = 0; n < this.pdHelpers.length; n = (int)((short)(n + 1))) {
                observable = (SASPhysicalDrive)this.pdHelpers[n].getDeviceObject();
                object = ((SASPhysicalDevice)observable).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
                char c = ((SASPhysicalDevice)observable).getInformation().getnotSupported();
                if (((SASPhysicalDrive)observable).getState() != 64 || ((pdType_MR_PD_INFO)object).getisForeign() == 1 || c != '\u0000') continue;
                arrayList.add(this.pdHelpers[n]);
            }
            for (n = arrayList.size() - 1; n >= 0; --n) {
                observable = (PhysicalDriveHelper)arrayList.get(n);
                object = (SASPhysicalDrive)((PhysicalDriveHelper)observable).getDeviceObject();
                if (!((SASPhysicalDrive)object).isOSDrive()) continue;
                arrayList.remove(n);
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new PhysicalDriveHelper[arrayList.size()]);
            }
        }
        return null;
    }

    public ADV_SYSTEM_INFO getAdvSysInfo() {
        OperationDetails operationDetails = new OperationDetails(60, null);
        try {
            this.adapter.fireOperation(operationDetails);
            ADV_SYSTEM_INFO aDV_SYSTEM_INFO = (ADV_SYSTEM_INFO)operationDetails.getParam();
            System.out.println("Advance System Info:");
            System.out.println(Resource.zeroTrim(aDV_SYSTEM_INFO.getMemStr()));
            System.out.println(Resource.zeroTrim(aDV_SYSTEM_INFO.getOSStr()));
            System.out.println(Resource.zeroTrim(aDV_SYSTEM_INFO.getProcStr()));
            return aDV_SYSTEM_INFO;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vk.GetErrorCode() " + vKOperationFailedException.GetErrorCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public ArrayList<CapacityHelper> getCapacityHelpers() {
        ArrayHelper[] arrayHelperArray = this.getArrays();
        ArrayList<Object> arrayList = new ArrayList();
        ArrayList<CapacityHelper> arrayList2 = new ArrayList<CapacityHelper>();
        for (int i = 0; i < arrayHelperArray.length; ++i) {
            arrayList = arrayHelperArray[i].getCapacityHelpers();
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList2.add((CapacityHelper)arrayList.get(j));
            }
            arrayList.clear();
        }
        return arrayList2;
    }

    protected void initConstants() {
        this.MAX_LOGICAL_DRIVES = (short)this.adapterInfo.getmaxLDs();
        this.MAX_ROW_SIZE = (short)this.adapterInfo.getmaxArms();
        if (this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4) {
            this.MAX_LDS_PER_ARRAY = 1;
            this.MAX_ARRAYS = (short)2;
            this.MIN_ROW_SIZE = (short)2;
        } else {
            this.MAX_LDS_PER_ARRAY = (short)((short)this.adapterInfo.getmaxLDsPerArray() != 0 ? (int)this.adapterInfo.getmaxLDsPerArray() : 16);
            this.MAX_ARRAYS = (short)this.adapterInfo.getmaxArrays();
            this.MIN_ROW_SIZE = 1;
        }
    }

    public MR_MFC_DEFAULTS getMFCDefaults() {
        try {
            return this.adapter.getMFCDefaults();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getPowerState() {
        if (this.isSupportPSMaxWithCache()) {
            switch (this.adapterProperties.getdefaultLdPSPolicy()) {
                case -2: {
                    return Resource.getString("DS_NONE", "None");
                }
                case 1: {
                    return Resource.getString("DS_AUTO", "Auto");
                }
                case 2: {
                    return Resource.getString("DS_MAX", "Max");
                }
                case 6: {
                    return Resource.getString("DS_MAX_NO_CACHE", "Max without Cache");
                }
            }
            return Resource.getString("NO_POWER_SAVE", "No power saving-0x0") + this.adapterProperties.getdefaultLdPSPolicy();
        }
        switch (this.adapterProperties.getdefaultLdPSPolicy()) {
            case -2: {
                return Resource.getString("DS_NONE", "None");
            }
            case 1: 
            case 5: {
                return Resource.getString("DS_AUTO", "Auto");
            }
            case 2: 
            case 6: {
                return Resource.getString("DS_MAX", "Max");
            }
        }
        return Resource.getString("NO_POWER_SAVE", "No power saving-0x0") + this.adapterProperties.getdefaultLdPSPolicy();
    }

    public String getSpinDownTime() {
        short s = this.adapterInfo.getproperties().getspinDownTime();
        if (s == 0) {
            return "0";
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        n = s / 60;
        n2 = s % 60;
        if (n != 0) {
            stringBuffer.append(n);
            stringBuffer.append("hrs ");
        }
        if (n2 != 0) {
            stringBuffer.append(n2);
            stringBuffer.append("mins");
        }
        return stringBuffer.toString();
    }

    public boolean isSupportPSMaxWithCache() {
        return this.adapterInfo.getldOperations_MR_CTRL_INFO().getSupportPSMaxWithCache() != 0;
    }

    public boolean isPIEnabledOnController() {
        return this.adapterInfo.getproperties().getOnOffProperties_MR_CTRL_PROP().getEnablePI() != 0;
    }

    public boolean isPISupported() {
        return this.adapterInfo.getadapterOperationsEx_MR_CTRL_INFO().getSupportPI() != 0;
    }

    public boolean containsPIDrives() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getUnconfiguredPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].isForeign() || physicalDriveHelperArray[i].getInformation().getnotSupported() != '\u0000' || !physicalDriveHelperArray[i].isPDPICapable()) continue;
            return true;
        }
        return false;
    }

    public boolean isPowerSaveSupportedOnConfiguredDrives() {
        return this.adapterInfo.getldOperations_MR_CTRL_INFO().getSupportPowerSavings() != 0;
    }

    public boolean isBreakMirrorSupported() {
        return this.adapterInfo.getldOperations_MR_CTRL_INFO().getSupportBreakMirror() != 0;
    }

    public boolean isAnyReconInProgress() {
        boolean bl = false;
        int n = this.arrayHelpers.length;
        block0: for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            LogicalDriveHelper[] logicalDriveHelperArray = this.arrayHelpers[n2].getLogicalDriveHelpers();
            for (int n3 = 0; n3 < logicalDriveHelperArray.length; n3 = (int)((short)(n3 + 1))) {
                if (!((SASLogicalDrive)logicalDriveHelperArray[n3].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public ArrayList<LogicalDriveHelper> getOfflineWBSSCDlist() {
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        LogicalDriveHelper[] logicalDriveHelperArray = this.getSSCDs();
        if (logicalDriveHelperArray != null) {
            int n = logicalDriveHelperArray.length;
            for (int i = 0; i < n; ++i) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject();
                if (sASLogicalDrive.getInformation().getldConfig().getparams().getstate() == '\u0003' || sASLogicalDrive.getWritePolicy() == 0) continue;
                arrayList.add(logicalDriveHelperArray[i]);
            }
        }
        return arrayList;
    }

    public boolean isSSCEnabled() {
        return this.m_isSSCEnabled;
    }

    public ArrayList<LogicalDriveHelper> getNonSSCDsList() {
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        int n = this.ldHelpers.length;
        for (int i = 0; i < n; ++i) {
            if (this.ldHelpers[i].isSSCD()) continue;
            arrayList.add(this.ldHelpers[i]);
        }
        return arrayList;
    }

    public LogicalDriveHelper[] getCCCapableLogicalDrives() {
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        if (this.ldHelpers != null) {
            int n = this.ldHelpers.length;
            SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
            for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
                if (this.ldHelpers[n2].getLdParameters().getPRL() == 0 || (sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.ldHelpers[n2].getDeviceObject()).getLDAllowedOps()) == null || !sASLogicalDriveOperationsAllowed.isOperationAllowed(6)) continue;
                arrayList.add(this.ldHelpers[n2]);
            }
        }
        return arrayList.toArray(new LogicalDriveHelper[arrayList.size()]);
    }

    public byte[] getAssociatedLdIds() {
        return this.m_associatedLdIds;
    }

    public ArrayList getSSCCacheableLDList(ArrayList arrayList, int n) {
        MR_LD_ALLOWED_OPS_LIST mR_LD_ALLOWED_OPS_LIST = this.adapter.getLDAllowedOpsList();
        ArrayList arrayList2 = new ArrayList();
        if (mR_LD_ALLOWED_OPS_LIST == null) {
            return arrayList2;
        }
        int[] nArray = mR_LD_ALLOWED_OPS_LIST.getMrLDAllowedOps();
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            if (n == 0) {
                n2 = ((SASLogicalDrive)((LogicalDriveHelper)arrayList.get(i)).getDeviceObject()).getID();
            } else if (n == 1) {
                n2 = ((VirtualDrive)arrayList.get(i)).getTargetId();
            }
            if (KernelConstants.getBitValue(nArray[n2], 14) == 0) continue;
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    public ArrayList getDisassociatedSSCLDList(ArrayList arrayList, int n) {
        MR_LD_ALLOWED_OPS_LIST mR_LD_ALLOWED_OPS_LIST = this.adapter.getLDAllowedOpsList();
        ArrayList<LogicalDriveHelper> arrayList2 = new ArrayList<LogicalDriveHelper>();
        if (mR_LD_ALLOWED_OPS_LIST == null) {
            return arrayList2;
        }
        int[] nArray = mR_LD_ALLOWED_OPS_LIST.getMrLDAllowedOps();
        short s = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (n != 0) continue;
            LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)arrayList.get(i);
            s = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID();
            if (!logicalDriveHelper.isLdCached() || KernelConstants.getBitValue(nArray[s], 25) != 0) continue;
            arrayList2.add(logicalDriveHelper);
        }
        return arrayList2;
    }

    public String getLifeCurveStatus() {
        String string;
        block9: {
            string = null;
            ArrayList arrayList = new ArrayList();
            if (this.adapter.isWarhawk()) {
                short s = this.adapter.getWhDDInfo().getLifeCurveStatus();
                if (s == 100) {
                    string = Resource.getString("PROPERTY_NO_SSD_THROTTLING_TEXT", "No SSD is being throttled");
                } else if (s == 90) {
                    int n = 0;
                    try {
                        arrayList = this.adapter.getSASObjectsArrayList((short)4096);
                        for (SASPhysicalDevice sASPhysicalDevice : arrayList) {
                            if (sASPhysicalDevice.getSSDInformation().getLifeCurveStatus() != 90) continue;
                            ++n;
                        }
                        if (n > 1) {
                            string = n + " " + Resource.getString("SSD_TEXT", "SSD") + "s " + Resource.getString("THROTTLING_TEXT", "throttling");
                            break block9;
                        }
                        string = n + " " + Resource.getString("SSD_TEXT", "SSD") + Resource.getString("THROTTLING_TEXT", "throttling");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    string = Resource.getString("PROPERTY_DD_UNKNOWN_TEXT", "Unknown");
                }
            }
        }
        return string;
    }

    public String getSSDLifeLeftStatus() {
        String string = null;
        if (this.adapter.isWarhawk()) {
            int n = this.adapter.getWhDDInfo().getSSDLifeLeft();
            string = n > this.adapter.getWhDDInfo().getDriveLifeWarningThreshold() ? Resource.getString("PROPERTY_SSD_LIFE_LEFT_OPTIMAL_TEXT", "Optimal") : (n <= this.adapter.getWhDDInfo().getDriveLifeWarningThreshold() && n > this.adapter.getWhDDInfo().getDriveLifeErrorThreshold() ? Resource.getString("PROPERTY_SSD_LIFE_LEFT_NEEDS_ATTENTION_TEXT", "Needs Attention") : Resource.getString("STATUS_EXHAUSTED", "Exhausted"));
        }
        return string;
    }

    public boolean isShieldEnable() {
        return this.adapterInfo.getadapterOperationsEx_MR_CTRL_INFO().getSupportShieldState() == 1 && this.getMFCDefaults().isEnableShieldState();
    }

    public boolean isWarhawk() {
        return this.m_isWarhawk;
    }

    public void setCacheDeviceCapacity(String string) {
        this.m_strCDevCapacity = string;
    }

    public String getCacheDeviceCapacity() {
        return this.m_strCDevCapacity;
    }

    public boolean canCreateCSACacheCade() {
        PhysicalDriveHelper[] physicalDriveHelperArray;
        if (this.isCSA() && (physicalDriveHelperArray = this.getUnconfiguredPhysicalDrives()) != null) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (physicalDriveHelperArray[i].getInformation().getproperties_MR_PD_INFO().getIneligibleForSSCD() != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCSA() {
        return this.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getSSMSupport() != 0;
    }

    public ArrayList getCSACacheableLDList(ArrayList arrayList, int n) {
        MR_LD_ALLOWED_OPS_LIST mR_LD_ALLOWED_OPS_LIST = this.adapter.getLDAllowedOpsList();
        ArrayList arrayList2 = new ArrayList();
        if (mR_LD_ALLOWED_OPS_LIST == null) {
            return arrayList2;
        }
        int[] nArray = mR_LD_ALLOWED_OPS_LIST.getMrLDAllowedOps();
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            if (n == 0) {
                n2 = ((SASLogicalDrive)((LogicalDriveHelper)arrayList.get(i)).getDeviceObject()).getID();
            } else if (n == 1) {
                n2 = ((VirtualDrive)arrayList.get(i)).getTargetId();
            }
            if (KernelConstants.getBitValue(nArray[n2], 14) == 0) continue;
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    public ArrayList getDisassociatedCSALDList(ArrayList arrayList, int n) {
        MR_LD_ALLOWED_OPS_LIST mR_LD_ALLOWED_OPS_LIST = this.adapter.getLDAllowedOpsList();
        ArrayList<LogicalDriveHelper> arrayList2 = new ArrayList<LogicalDriveHelper>();
        if (mR_LD_ALLOWED_OPS_LIST == null) {
            return arrayList2;
        }
        int[] nArray = mR_LD_ALLOWED_OPS_LIST.getMrLDAllowedOps();
        short s = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (n != 0) continue;
            LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)arrayList.get(i);
            s = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID();
            if (!logicalDriveHelper.isLdCached() || KernelConstants.getBitValue(nArray[s], 25) != 0) continue;
            arrayList2.add(logicalDriveHelper);
        }
        return arrayList2;
    }

    public ArrayHelper getSlicedForBootVolumeArray() {
        ArrayHelper[] arrayHelperArray = this.getArrays();
        for (int i = 0; i < arrayHelperArray.length; ++i) {
            if (!arrayHelperArray[i].isSlicedForBootVolume()) continue;
            return arrayHelperArray[i];
        }
        return null;
    }
}

