/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.VivaldiStartupDialog;
import GUI.security.ConfirmFDEDialog;
import GUI.security.ConfirmSecureDriveGroupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.CapacityHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.OnOffProperties_MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ArrayHelper
extends Observable
implements GUIHelperInterface {
    private GUIHelperInterface parent;
    private SASArray array;
    private int status = 0;
    private int m_parentIDForSpan;
    private boolean m_isSlicedForBootVolume = false;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Drive Group");

    public ArrayHelper(SASArray sASArray, GUIHelperInterface gUIHelperInterface) {
        this.array = sASArray;
        this.parent = gUIHelperInterface;
        sASArray.addObserver(this);
    }

    public ArrayList<CapacityHelper> getCapacityHelpers() {
        ArrayList<CapacityHelper> arrayList = new ArrayList<CapacityHelper>();
        if (!this.isRebuildInProgress()) {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = null;
            SASArray sASArray = (SASArray)this.getDeviceObject();
            try {
                sL_ARRAY_INFO_T = sASArray.getSLArrayInformation();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            if (sL_ARRAY_INFO_T.getfreeCount() > 0 && sL_ARRAY_INFO_T.getldCount() < ((AdapterHelper)this.parent).MAX_LDS_PER_ARRAY) {
                int n = sL_ARRAY_INFO_T.getfreeCount();
                for (int i = 0; i < n; ++i) {
                    CapacityHelper capacityHelper = new CapacityHelper(sL_ARRAY_INFO_T, i, this);
                    arrayList.add(capacityHelper);
                }
            }
        }
        return arrayList;
    }

    public boolean canAddLd() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        return ((AdapterHelper)this.parent).MAX_LDS_PER_ARRAY - logicalDriveHelperArray.length > 0;
    }

    public LogicalDriveHelper[] getLogicalDriveHelpers() {
        int n;
        LogicalDriveHelper[] logicalDriveHelperArray;
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        LogicalDriveHelper[] logicalDriveHelperArray2 = ((AdapterHelper)this.parent).getLogicalDrives();
        if (logicalDriveHelperArray2 != null && logicalDriveHelperArray2.length > 0) {
            try {
                logicalDriveHelperArray = this.array.getLogicalDriveList();
                for (n = 0; n < logicalDriveHelperArray2.length; ++n) {
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray2[n].getDeviceObject();
                    if (!logicalDriveHelperArray.contains(sASLogicalDrive)) continue;
                    arrayList.add(logicalDriveHelperArray2[n]);
                }
            }
            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                // empty catch block
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            logicalDriveHelperArray = new LogicalDriveHelper[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                logicalDriveHelperArray[n] = (LogicalDriveHelper)arrayList.get(n);
            }
            return logicalDriveHelperArray;
        }
        return null;
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.array;
    }

    @Override
    public String getText() {
        try {
            LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
            if (logicalDriveHelperArray != null) {
                if (this.getSpanDepth() > 1) {
                    return Resource.getString("SPAN_TEXT", "Span") + ": " + this.getID(1);
                }
                if (this.isCSACacheCade()) {
                    return Resource.getString("CSA_CACHECADE_DRIVE_GROUP_TEXT", "Nytro\u2122 Drive Group") + ": " + this.getID(2) + ", " + logicalDriveHelperArray[0].getRaidLevelString();
                }
                if (this.isSSCD()) {
                    if (logicalDriveHelperArray[0].getLdParameters().getPRL() == 0) {
                        return Resource.getString("CACHECADE_TEXT", "CacheCade\u2122 - SSD Caching") + " " + Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + ": " + this.getID(2);
                    }
                    return Resource.getString("CACHECADE_TEXT", "CacheCade\u2122 - SSD Caching") + " " + Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + ": " + this.getID(2) + ", " + logicalDriveHelperArray[0].getRaidLevelString();
                }
                return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + ": " + this.getID(3) + ", " + logicalDriveHelperArray[0].getRaidLevelString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "NA";
    }

    public int getID(int n) {
        ArrayList<Short> arrayList;
        block6: {
            block7: {
                block5: {
                    arrayList = new ArrayList<Short>();
                    if (n != 1) break block5;
                    LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
                    ArrayHelper[] arrayHelperArray = logicalDriveHelperArray[0].getArrays();
                    for (int n2 = 0; n2 < arrayHelperArray.length; n2 = (int)((byte)(n2 + 1))) {
                        arrayList.add(n2, ((SASArray)arrayHelperArray[n2].getDeviceObject()).getID());
                    }
                    break block6;
                }
                if (n != 2) break block7;
                LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.parent).getLogicalDrives();
                int n3 = 0;
                for (int n4 = 0; n4 < logicalDriveHelperArray.length; n4 = (int)((byte)(n4 + 1))) {
                    if (!logicalDriveHelperArray[n4].isSSCD()) continue;
                    ArrayHelper[] arrayHelperArray = logicalDriveHelperArray[n4].getArrays();
                    for (int n5 = 0; n5 < arrayHelperArray.length; n5 = (int)((byte)(n5 + 1))) {
                        if (arrayList.contains(((SASArray)arrayHelperArray[n5].getDeviceObject()).getID())) continue;
                        arrayList.add(n3, ((SASArray)arrayHelperArray[n5].getDeviceObject()).getID());
                        n3 = (byte)(n3 + 1);
                    }
                }
                break block6;
            }
            if (n != 3) break block6;
            LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.parent).getLogicalDrives();
            int n6 = 0;
            for (int n7 = 0; n7 < logicalDriveHelperArray.length; n7 = (int)((byte)(n7 + 1))) {
                if (((SASLogicalDrive)logicalDriveHelperArray[n7].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth() != '\u0001' || logicalDriveHelperArray[n7].isSSCD()) continue;
                ArrayHelper[] arrayHelperArray = logicalDriveHelperArray[n7].getArrays();
                for (int n8 = 0; n8 < arrayHelperArray.length; n8 = (int)((byte)(n8 + 1))) {
                    if (arrayList.contains(((SASArray)arrayHelperArray[n8].getDeviceObject()).getID())) continue;
                    arrayList.add(n6, ((SASArray)arrayHelperArray[n8].getDeviceObject()).getID());
                    n6 = (byte)(n6 + 1);
                }
            }
        }
        return arrayList.indexOf(this.array.getID());
    }

    public String getText(boolean bl) {
        LogicalDriveHelper[] logicalDriveHelperArray;
        if (bl && (logicalDriveHelperArray = this.getLogicalDriveHelpers()) != null) {
            if (this.getSpanDepth() > 1) {
                return Resource.getString("SPAN_TEXT", "Span") + " " + this.array.getID() + ": " + logicalDriveHelperArray[0].getRaidLevelString();
            }
            return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + " " + this.array.getID() + ": " + logicalDriveHelperArray[0].getRaidLevelString();
        }
        return this.getText();
    }

    public int getSpanDepth() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0) {
            return ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth();
        }
        return 0;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 4;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.getSpanDepth() > 1) {
            return this.getImageIcon(Resource.getString("SPAN_IMAGE", "span.png"));
        }
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        if (logicalDriveHelperArray != null) {
            if (this.isSSCD()) {
                return this.getImageIcon(Resource.getString("SSC_GROUP_IMAGE", "sscds_group.png"));
            }
            return this.getImageIcon(Resource.getString("ARRAY_IMAGE", "array.png"));
        }
        return this.getImageIcon(Resource.getString("ARRAY_IMAGE", "array.png"));
    }

    @Override
    public ArrayList getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                this.addOperation(arrayList, operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    private void addOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        if (operationDetails.getOpcode() == 0x30C0000) {
            System.out.println("Inside arrayhelper MR_DCMD_LD_SECURE");
            SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
            try {
                sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.getLogicalDriveHelpers()[0].getDeviceObject()).getAllAllowedOperations();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((AdapterHelper)this.parent).isSecuritySupported() && sASLogicalDriveOperationsAllowed != null && sASLogicalDriveOperationsAllowed.isSecure() && !this.isArrayEncrypted() && this.isFDEOnlyDriveGroup()) {
                arrayList.add(operationDetails);
            }
        } else if (operationDetails.getOpcode() == 51642624) {
            SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
            try {
                sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.getLogicalDriveHelpers()[0].getDeviceObject()).getAllAllowedOperations();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sASLogicalDriveOperationsAllowed.isPIDisable()) {
                arrayList.add(operationDetails);
            }
        }
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return true;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
        try {
            if (operationDetails.getOpcode() == 0x30C0000) {
                Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
                PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.parent).getPhysicalDrives();
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
                    if (sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisGlobalSpare() != 1 || sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                    vector.add(physicalDriveHelperArray[i]);
                }
                VivaldiBaseOptionDialog vivaldiBaseOptionDialog = null;
                vivaldiBaseOptionDialog = vector.size() > 0 ? new ConfirmFDEDialog((Window)VivaldiStartupDialog.mainScreen, vector) : new ConfirmSecureDriveGroupDialog(this);
                if (vivaldiBaseOptionDialog.getSelectedOption() == 0) {
                    this.array.fireOperation(operationDetails);
                }
            } else if (operationDetails.getOpcode() == 51642624) {
                System.out.println("firing DCMD");
                String string = Resource.getString("MSG_DISABLE_DATA_PROTECTION_TITLE", "Confirm Disable Drive Protection");
                String string2 = Resource.getString("DISABLE_DATA_PROTECTION_TEXT", "<html>If you disable data protection on  drive group, you cannot enable it again. Data<br>protection can only be enabled at the time of drive group creation.<br><br>Are you sure you want to disable data protection?</html>");
                if (CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, string2.toString())) {
                    this.array.fireOperation(operationDetails);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        PropertyInfo propertyInfo;
        Object object;
        Object object2;
        PropertyInfo propertyInfo2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        propertyInfo3.value = "";
        arrayList.add(propertyInfo3);
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROPERTY_TOTAL_CAPACITY", "Total Capacity");
        propertyInfo4.value = this.getTotalCapacity();
        propertyInfo4.description = Resource.getString("PROPERTY_TOTAL_CAPACITY", "Total Capacity");
        arrayList.add(propertyInfo4);
        if (this.isAtleastMinimumBlockSizeRemaining()) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROPERTY_FREE_CAPACITY", "Free Capacity");
            propertyInfo2.value = this.getFreeCapacity();
            propertyInfo2.description = Resource.getString("PROPERTY_FREE_CAPACITY", "Free Capacity");
            arrayList.add(propertyInfo2);
        }
        if (((AdapterHelper)this.parent).isSecuritySupported()) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROP_DSPROP", "<html><b>Drive Security Properties:</b></html>");
            propertyInfo2.value = "";
            arrayList.add(propertyInfo2);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("PROPERTY_SECURED", "Secured");
            ((PropertyInfo)object2).value = this.isArrayEncrypted() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_No_TEXT", "No");
            ((PropertyInfo)object2).description = Resource.getString("PROPERTY_SECURED", "Secured");
            arrayList.add(object2);
            object = this.getEncryptionMethod();
            if (object != null) {
                propertyInfo = new PropertyInfo();
                propertyInfo.name = Resource.getString("PROPERTY_DRIVE_SECURITY_METHOD", "Drive security method");
                propertyInfo.value = object;
                propertyInfo.description = Resource.getString("PROPERTY_DRIVE_SECURITY_METHOD", "Drive security method");
                arrayList.add(propertyInfo);
            }
        }
        if (((AdapterHelper)this.parent).isPowerSaveSupportedOnConfiguredDrives()) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROP_POWER_STATE_PROP", "<html><b>Power State Properties:</b></html>");
            arrayList.add(propertyInfo2);
            object2 = this.getLogicalDriveHelpers()[0];
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("DEFAULT_POWER_SAVE_POLICY", "Default Power save policy");
            ((PropertyInfo)object).value = ((LogicalDriveHelper)object2).getDefaultPowerState();
            ((PropertyInfo)object).description = Resource.getString("DEFAULT_POWER_SAVE_POLICY", "Default Power save policy");
            arrayList.add(object);
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("CURRENT_POWER_SAVE_POLICY", "Current Power save policy");
            propertyInfo.value = ((LogicalDriveHelper)object2).getCurrentPowerState();
            propertyInfo.description = Resource.getString("CURRENT_POWER_SAVE_POLICY", "Current Power save policy");
            arrayList.add(propertyInfo);
        }
        if (((AdapterHelper)this.parent).isPIEnabledOnController()) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("DATA_PROTECTION_PROP", "<html><b>Data Protection Properties:</b></html>");
            arrayList.add(propertyInfo2);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("DATA_PROTECTION", "Data Protection");
            ((PropertyInfo)object2).value = this.isArrayPIEnabled() ? Resource.getString("PROPERTY_HS_SPIN_DOWN_ENABLED", "Enabled") : Resource.getString("PROPERTY_HS_SPIN_DOWN_DISABLED", "Disabled");
            ((PropertyInfo)object2).description = Resource.getString("DATA_PROTECTION", "Data Protection");
            arrayList.add(object2);
        }
        return arrayList;
    }

    public byte getDefaultPowerSavePolicy() {
        LogicalDriveHelper logicalDriveHelper = this.getLogicalDriveHelpers()[0];
        return logicalDriveHelper.getdefaultPSPolicy();
    }

    public byte getcurrentPowerSavePolicy() {
        LogicalDriveHelper logicalDriveHelper = this.getLogicalDriveHelpers()[0];
        return logicalDriveHelper.getcurrentPSPolicy();
    }

    public PhysicalDriveHelper[] getPhysicalDrives() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.array.getPhysicalDriveList();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        block0: for (int i = 0; i < sASPhysicalDriveArray.length; ++i) {
            for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                if (sASPhysicalDriveArray[i] != physicalDriveHelperArray[j].getDeviceObject()) continue;
                arrayList.add(physicalDriveHelperArray[j]);
                continue block0;
            }
        }
        PhysicalDriveHelper[] physicalDriveHelperArray2 = arrayList.toArray(new PhysicalDriveHelper[0]);
        PhysicalDriveHelper[] physicalDriveHelperArray3 = this.sortPhysicalDrives(physicalDriveHelperArray2);
        return physicalDriveHelperArray3;
    }

    public ArrayList<PhysicalDriveHelper> getPhysicalDrivesArrayList() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.array.getPhysicalDriveList();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            arrayList.add(physicalDriveHelperArray[i]);
        }
        return arrayList;
    }

    public PhysicalDriveHelper[] getPhysicalDrivesforMissingDrives() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.array.getPhysicalDriveListforMissingDrives();
        PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[sASPhysicalDriveArray.length];
        PhysicalDriveHelper[] physicalDriveHelperArray2 = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        block0: for (int i = 0; i < sASPhysicalDriveArray.length; ++i) {
            for (int j = 0; j < physicalDriveHelperArray2.length; ++j) {
                if (sASPhysicalDriveArray[i] != physicalDriveHelperArray2[j].getDeviceObject()) continue;
                physicalDriveHelperArray[i] = physicalDriveHelperArray2[j];
                continue block0;
            }
        }
        return physicalDriveHelperArray;
    }

    public short getBlockSize() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0) {
            return logicalDriveHelperArray[0].getBlockSize();
        }
        return 512;
    }

    public ArrayList getDegradedArrayPhysicalDrives() {
        ArrayList arrayList = this.array.getPhysicalDriveArrayList();
        ArrayList<PhysicalDriveHelper> arrayList2 = new ArrayList<PhysicalDriveHelper>();
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                if ((SASPhysicalDrive)arrayList.get(i) != physicalDriveHelperArray[j].getDeviceObject()) continue;
                arrayList2.add(physicalDriveHelperArray[j]);
                continue block0;
            }
        }
        return arrayList2;
    }

    public PhysicalDriveHelper[] getDedicatedSpares() {
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        block3: for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 2 || !PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equals(Resource.getString("PD_STATE_HOTSPARE_DEDICATED", "Dedicated")) || PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equals("")) continue;
            try {
                MR_SPARE mR_SPARE = sASPhysicalDrive.getDedicatedHotspareInfo();
                short[] sArray = mR_SPARE.getarrayRef();
                for (int j = 0; j < mR_SPARE.getarrayCount(); ++j) {
                    if (sArray[j] != this.array.getSeqNum()) continue;
                    arrayList.add(physicalDriveHelperArray[i]);
                    continue block3;
                }
                continue;
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                System.out.println("Dedicated Hotspare query failed");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        PhysicalDriveHelper[] physicalDriveHelperArray2 = new PhysicalDriveHelper[arrayList.size()];
        for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
            physicalDriveHelperArray2[i] = (PhysicalDriveHelper)arrayList.get(i);
        }
        return physicalDriveHelperArray2;
    }

    @Override
    public void update(Observable observable, Object object) {
        System.out.println("ArrayHelper.update()");
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL.getcode() == 317 || mR_EVT_DETAIL.getcode() == 316 || mR_EVT_DETAIL.getcode() == 387 || mR_EVT_DETAIL.getcode() == 73) {
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.parent;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.status == 2) {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (this.status == 1) {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    public long getMinSizeForModifySSC() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        if (physicalDriveHelperArray == null || physicalDriveHelperArray.length == 0) {
            return 0L;
        }
        return this.getArraySize() / (long)physicalDriveHelperArray.length;
    }

    public boolean isPDEligibleforDHSP(PhysicalDriveHelper physicalDriveHelper) {
        try {
            SASPhysicalDrive[] sASPhysicalDriveArray;
            if (this.isSSCD()) {
                if (!physicalDriveHelper.isSSDDrive()) {
                    return false;
                }
                if (physicalDriveHelper.isSSDDrive() && physicalDriveHelper.isIneligibleForSSCD()) {
                    return false;
                }
            }
            ArrayList arrayList = this.array.getLogicalDriveList();
            for (SASLogicalDrive sASLogicalDrive : arrayList) {
                sASPhysicalDriveArray = sASLogicalDrive.getRAIDLevelInfo();
                if (sASPhysicalDriveArray.getPRL() >= 1) continue;
                return false;
            }
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.getLogicalDriveHelpers()[0].getDeviceObject();
            if (sASLogicalDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) {
                return false;
            }
            if (((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getcoercedSize() < this.array.getSize()) {
                return false;
            }
            byte by = this.getLogicalDriveHelpers()[0].getEncryptionType();
            if (!physicalDriveHelper.isFDECapable()) {
                if (by == 1) {
                    return false;
                }
                if (this.isFDEOnlyDriveGroup() && by == 0) {
                    return false;
                }
            }
            if (!physicalDriveHelper.isPDPICapable() && this.isArrayPIEnabled()) {
                return false;
            }
            sASPhysicalDriveArray = this.array.getPhysicalDriveList();
            int n = ((SASAdapter)((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
            int n2 = ((SASAdapter)((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
            int n3 = ((SASAdapter)((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
            for (int i = 0; i < sASPhysicalDriveArray.length; ++i) {
                if (sASPhysicalDriveArray[i].getMediatype() == 0 && ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getMediatype() == 0 ? n2 == 0 && sASPhysicalDriveArray[i].getDriveType() != ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getDriveType() : (sASPhysicalDriveArray[i].getMediatype() == 0 && ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getMediatype() == 1 ? n == 0 : (sASPhysicalDriveArray[i].getMediatype() == 1 && ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getMediatype() == 0 ? n == 0 : sASPhysicalDriveArray[i].getMediatype() == 1 && ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getMediatype() == 1 && n3 == 0 && sASPhysicalDriveArray[i].getDriveType() != ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getDriveType()))) {
                    return false;
                }
                if (physicalDriveHelper.getUserDataBlockSize() == sASPhysicalDriveArray[i].getInformation().getUserDataBlockSize()) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isFDEEncrypted() {
        try {
            ArrayList arrayList = this.array.getLogicalDriveList();
            if (arrayList != null && arrayList.size() > 0) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
                return sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType() == 1;
            }
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        return false;
    }

    public boolean isFDEOnlyDriveGroup() {
        boolean bl = true;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].isFDECapable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isArrayEncrypted() {
        try {
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.array.getLogicalDriveList().get(0);
            byte by = sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType();
            return by != 0;
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
            return false;
        }
    }

    public String getEncryptionMethod() {
        String string = null;
        AdapterHelper adapterHelper = (AdapterHelper)this.parent;
        MR_CTRL_INFO mR_CTRL_INFO = ((SASAdapter)adapterHelper.getDeviceObject()).getInformation();
        OnOffProperties_MR_CTRL_PROP onOffProperties_MR_CTRL_PROP = mR_CTRL_INFO.getproperties().getOnOffProperties_MR_CTRL_PROP();
        if (this.isArrayEncrypted() && !onOffProperties_MR_CTRL_PROP.getUseFdeOnly() && adapterHelper.isSecuritySupported()) {
            long l = this.array.getSize();
            try {
                ArrayList arrayList = this.array.getLogicalDriveList();
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
                byte by = sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType();
                if (by == 2) {
                    string = Resource.getString("PROP_ENCRYPTION_TYPE_CTRL_BASED", "Controller-based encryption");
                } else if (by == 1) {
                    string = Resource.getString("PROP_ENCRYPTION_TYPE_FDE_BASED", "Full disk encryption");
                }
            }
            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                vKObjectNotPresentException.printStackTrace();
            }
        }
        return string;
    }

    public String getFreeCapacity() {
        String string = null;
        ArrayList arrayList = this.array.getPhysicalDriveArrayList();
        int n = arrayList.size();
        short s = this.getBlockSize();
        System.out.println("arr blkSize" + s);
        try {
            long l = this.array.getSLArrayInformation().gettotalBlocks();
            long l2 = this.array.getSLArrayInformation().getusedBlocks();
            if (this.array.getRAIDLevelInfo().getPRL() == 0) {
                string = KernelConstants.getConvertedSize(l - l2, s);
            } else if (this.array.getRAIDLevelInfo().getPRL() == 1 || this.array.getRAIDLevelInfo().getPRL() == 17) {
                string = KernelConstants.getConvertedSize((l - l2) / 2L, s);
            } else if (this.array.getRAIDLevelInfo().getPRL() == 5) {
                string = KernelConstants.getConvertedSize((long)(n - 1) * (l - l2) / (long)n, s);
            } else if (this.array.getRAIDLevelInfo().getPRL() == 6) {
                string = KernelConstants.getConvertedSize((long)(n - 2) * (l - l2) / (long)n, s);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
        return string;
    }

    public int getNoOfHoles() {
        try {
            return this.array.getSLArrayInformation().getfreeCount();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public long getArraySize() {
        long l = 0L;
        try {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = this.array.getSLArrayInformation();
            return sL_ARRAY_INFO_T.gettotalBlocks();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return l;
        }
    }

    public String getTotalCapacity() {
        String string = null;
        ArrayList arrayList = this.array.getPhysicalDriveArrayList();
        int n = arrayList.size();
        short s = this.getBlockSize();
        System.out.println("arr blkSize" + s);
        try {
            long l = this.array.getSLArrayInformation().gettotalBlocks();
            long l2 = this.array.getSLArrayInformation().getusedBlocks();
            if (this.array.getRAIDLevelInfo().getPRL() == 0 || this.isR1ECDriveGroup()) {
                string = KernelConstants.getConvertedSize(l, s);
            } else if (this.array.getRAIDLevelInfo().getPRL() == 1 || this.array.getRAIDLevelInfo().getPRL() == 17) {
                string = KernelConstants.getConvertedSize(l / 2L, s);
            } else if (this.array.getRAIDLevelInfo().getPRL() == 5) {
                string = KernelConstants.getConvertedSize((long)(n - 1) * l / (long)n, s);
            } else if (this.array.getRAIDLevelInfo().getPRL() == 6) {
                string = KernelConstants.getConvertedSize((long)(n - 2) * l / (long)n, s);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
        return string;
    }

    public String getRAIDLevel() {
        String string = null;
        try {
            ArrayList arrayList = this.array.getLogicalDriveList();
            if (arrayList != null && arrayList.size() > 0) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
                string = new String("" + sASLogicalDrive.getInformation().getldConfig().getparams().getPRL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private boolean isRebuildInProgressInThisArray() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getDeviceObject().getState() != 20) continue;
            return true;
        }
        return false;
    }

    public boolean isRebuildInProgress() {
        boolean bl = this.isRebuildInProgressInThisArray();
        if (this.getSpanDepth() == 1) {
            return bl;
        }
        if (!bl) {
            LogicalDriveHelper logicalDriveHelper = this.getLogicalDriveHelpers()[0];
            if (logicalDriveHelper != null) {
                ArrayHelper[] arrayHelperArray = logicalDriveHelper.getArrays();
                for (int i = 0; i < arrayHelperArray.length; ++i) {
                    if (arrayHelperArray[i] == null || arrayHelperArray[i].equals(this) || !arrayHelperArray[i].isRebuildInProgressInThisArray()) continue;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public long getRaidSpecificFreeSpaceInBlocks(int n) {
        int n2 = this.array.getPhysicalDriveArrayList().size();
        int n3 = this.getSpanDepth();
        try {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = this.array.getSLArrayInformation();
            long l = sL_ARRAY_INFO_T.getfreeInfo_SL_ARRAY_INFO_T()[n].getnumBlocks() * (long)n2;
            byte by = this.array.getRAIDLevelInfo().getPRL();
            if (by == 0) {
                return l * (long)n3;
            }
            if (by == 1 || by == 17) {
                return l / 2L * (long)n3;
            }
            if (by == 5) {
                return l * (long)(n2 - 1) / (long)n2 * (long)n3;
            }
            if (by == 6) {
                return l * (long)(n2 - 2) / (long)n2 * (long)n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0L;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSRArray() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        for (int n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
            if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getsnapshotRepository() != 1) continue;
            return true;
        }
        return false;
    }

    public long getNewMinSizeOfArray() {
        long l = this.array.getSize();
        long l2 = 0L;
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0 && physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject();
            char c = ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getInformation().getldConfig().getparams().getstate();
            if ((c == '\u0001' || c == '\u0002') && physicalDriveHelperArray.length < this.array.getInformation().getnumDrives()) {
                return l;
            }
            ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>();
            for (int n = 0; n < physicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[n].getDeviceObject();
                long l3 = sASPhysicalDrive.getInformation().getcoercedSize();
                if (l3 <= l) {
                    return l;
                }
                arrayList.add(sASPhysicalDrive);
            }
            if (arrayList.size() > 0) {
                long l4 = ((SASPhysicalDrive)arrayList.get(0)).getInformation().getcoercedSize();
                for (int n = 1; n < arrayList.size(); n = (int)((byte)(n + 1))) {
                    long l5 = ((SASPhysicalDrive)arrayList.get(n)).getInformation().getcoercedSize();
                    if (l5 >= l4) continue;
                    l4 = l5;
                }
                l2 = l4;
            } else {
                l2 = l;
            }
        } else {
            System.err.println("Logical Drive or Physical Drive Helpers are null for the array helper: " + this);
            return l;
        }
        return l2;
    }

    public boolean canExpand() {
        long l = this.getMinDHSPSize();
        if (l != 0L) {
            return l > this.array.getSize() && this.getNewMinSizeOfArray() > this.array.getSize();
        }
        return this.getNewMinSizeOfArray() > this.array.getSize();
    }

    public long getMinDHSPSize() {
        long l = 0L;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getDedicatedSpares();
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            l = physicalDriveHelperArray[0].getInformation().getcoercedSize();
            int n = physicalDriveHelperArray.length;
            for (int i = 1; i < n; ++i) {
                long l2 = physicalDriveHelperArray[i].getInformation().getcoercedSize();
                if (l2 >= l) continue;
                l = l2;
            }
        }
        return l;
    }

    public boolean canExpandSSCD(long l) {
        AdapterHelper adapterHelper = (AdapterHelper)this.getParent();
        ArrayHelper[] arrayHelperArray = adapterHelper.getArrays();
        long l2 = 0L;
        for (int n = 0; n < arrayHelperArray.length; n = (int)((byte)(n + 1))) {
            if (!arrayHelperArray[n].isSSCD()) continue;
            l2 += ((SASArray)arrayHelperArray[n].getDeviceObject()).getSize();
        }
        return l2 + l <= adapterHelper.getMaxSSCSizeInBlocks();
    }

    public boolean canSSCBeModified() {
        return this.isAddSSDsPossible() || this.isRemoveSSDsPossible();
    }

    public boolean isRemoveSSDsPossible() {
        return this.getPhysicalDrives().length > 1;
    }

    public boolean isAddSSDsPossible() {
        if (this.getPhysicalDrives().length < 32) {
            ArrayHelper[] arrayHelperArray = ((AdapterHelper)this.parent).getArrays();
            long l = 0L;
            for (int n = 0; n < arrayHelperArray.length; n = (int)((byte)(n + 1))) {
                if (!arrayHelperArray[n].isSSCD()) continue;
                l += arrayHelperArray[n].getArraySize();
            }
            if (l + this.getMinSizeForModifySSC() <= ((AdapterHelper)this.parent).getMaxSSCSizeInBlocks() && this.isUnconfGoodSSDAvailable(this.getMinSizeForModifySSC())) {
                return true;
            }
        }
        return false;
    }

    public boolean isUnconfGoodSSDAvailable(long l) {
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.parent).getPhysicalDrives();
        int n = 0;
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getStatus() != 0 || physicalDriveHelperArray[i].getmediaType() != '\u0001' || physicalDriveHelperArray[i].getSize() < l) continue;
            ++n;
        }
        return n > 0;
    }

    public boolean isArrayPIEnabled() {
        LogicalDriveHelper logicalDriveHelper = this.getLogicalDriveHelpers()[0];
        return logicalDriveHelper.isLDPIEnabled();
    }

    public PhysicalDriveHelper[] sortPhysicalDrives(PhysicalDriveHelper[] physicalDriveHelperArray) {
        int n;
        Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
        for (n = 0; n < physicalDriveHelperArray.length; ++n) {
            PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray[n];
            vector.add(physicalDriveHelper);
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                if (((PhysicalDriveHelper)vector.get(i)).getInformation().getslotNumber() <= ((PhysicalDriveHelper)vector.get(i + 1)).getInformation().getslotNumber()) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                int n2 = 0;
                int n3 = 0;
                if (((PhysicalDriveHelper)vector.get(i)).getEnclosureHelper() != null) {
                    n2 = ((PhysicalDriveHelper)vector.get(i)).getEnclosureHelper().getEnclIndexInSortedList();
                }
                if (((PhysicalDriveHelper)vector.get(i + 1)).getEnclosureHelper() != null) {
                    n3 = ((PhysicalDriveHelper)vector.get(i + 1)).getEnclosureHelper().getEnclIndexInSortedList();
                }
                if (n2 <= n3) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            physicalDriveHelperArray[n] = (PhysicalDriveHelper)vector.get(n);
        }
        return physicalDriveHelperArray;
    }

    public void setParentIdForSpan(int n) {
        this.m_parentIDForSpan = n;
    }

    public int getParentIDForSpan() {
        return this.m_parentIDForSpan;
    }

    public boolean isSSCD() {
        return this.getLogicalDriveHelpers()[0].isSSCD();
    }

    public boolean isCSACacheCade() {
        return this.getLogicalDriveHelpers()[0].isCSACacheCade();
    }

    public boolean isSlicedForBootVolume() {
        return this.m_isSlicedForBootVolume;
    }

    public void initSlicedForBootVolume() {
        LogicalDriveHelper[] logicalDriveHelperArray;
        if (((AdapterHelper)this.parent).isCSA() && (logicalDriveHelperArray = this.getLogicalDriveHelpers())[0].isCSACacheCade() && (logicalDriveHelperArray.length > 1 || logicalDriveHelperArray.length == 1 && this.getNoOfHoles() > 0)) {
            this.m_isSlicedForBootVolume = true;
        }
    }

    public boolean isHolePartOfSlicedBootVolume() {
        return ((AdapterHelper)this.parent).isCSA() && this.isCSACacheCade();
    }

    public boolean isR1ECDriveGroup() {
        MR_LD_PARAMETERS mR_LD_PARAMETERS;
        LogicalDriveHelper logicalDriveHelper = this.getLogicalDriveHelpers()[0];
        return logicalDriveHelper != null && (mR_LD_PARAMETERS = logicalDriveHelper.getLDParameters()) != null && mR_LD_PARAMETERS.getisSSCD() == 2;
    }

    public boolean isAtleastMinimumBlockSizeRemaining() {
        try {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = this.array.getSLArrayInformation();
            long l = this.array.getMinimumBlockSize();
            if (sL_ARRAY_INFO_T.getfreeCount() > 0) {
                return sL_ARRAY_INFO_T.gettotalBlocks() - sL_ARRAY_INFO_T.getusedBlocks() >= l;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

