/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.PreservedCache.PreservedCachePresent;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.Constants.MR_BBU_TYPE;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_CAPACITY_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_MODE;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_STATE;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_IBBU_STATE;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASAdapter.SASBBUInformation;
import SASKernel.SASAdapter.SASBatteryBackUp;
import Services.NetworkToJavaConverter;
import Utils.CustomMsgBox;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BBUHelper
extends Observable
implements GUIHelperInterface {
    private int status = 0;
    private SASBatteryBackUp BBU;
    private SASBBUInformation BBUInfo;
    private AdapterHelper adapter;
    ArrayList<PropertyInfo> advancedPropList;
    MR_BBU_STATE mrBBUState = null;
    public static final int MAX_POSTPONE_LEARN_DELAY_INTERVAL = 168;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("BBU");
    private int MR_BBU_STATUS_BAD_FOR_IBBU = 3187;
    private int MR_BBU_STATUS_BAD_FOR_BBU = 3073;
    private int MR_BBU_STATUS_BAD_FOR_TMMC = 215619;
    private int MR_BBU_STATUS_BAD_FOR_IBBU08 = 3075;

    public BBUHelper(AdapterHelper adapterHelper, SASBatteryBackUp sASBatteryBackUp) {
        this.BBU = sASBatteryBackUp;
        this.adapter = adapterHelper;
        this.BBUInfo = sASBatteryBackUp.getInformation();
        sASBatteryBackUp.addObserver(this);
        try {
            this.mrBBUState = this.BBU.getStatus().getMr_bbu_status_detail().getMR_BBU_STATE();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
            return;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return;
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            vKNotRespondingException.printStackTrace();
            return;
        }
    }

    public SASBBUInformation getbbuInfo() {
        return this.BBUInfo;
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.BBU;
    }

    @Override
    public String getText() {
        return Resource.getString("BBU_TEXT", "Battery Backup Unit");
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 7;
    }

    public SASBBUInformation getBBUInfo() {
        return this.BBUInfo;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getImageIcon(Resource.getString("BATTERY_IMAGE", "battery.png"));
    }

    @Override
    public ArrayList<OperationDetails> getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                this.addOperation(arrayList, operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    private void addOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        MR_BBU_STATE mR_BBU_STATE = null;
        MR_BBU_TYPE mR_BBU_TYPE = new MR_BBU_TYPE();
        MR_BBU_STATUS mR_BBU_STATUS = null;
        mR_BBU_STATUS = this.BBUInfo.getStatus();
        try {
            mR_BBU_STATE = this.BBU.getStatus().getMr_bbu_status_detail().getMR_BBU_STATE();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
            return;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return;
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            vKNotRespondingException.printStackTrace();
            return;
        }
        if (mR_BBU_STATE != null && mR_BBU_STATE.getAutoLearnModeSupport() == '\u0000') {
            return;
        }
        arrayList.add(operationDetails);
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void issueOperation(OperationDetails operationDetails) {
        try {
            VivaldiStartupDialog.mainScreen.busy();
            switch (operationDetails.getOpcode()) {
                case 5: {
                    this.BBU.fireOperation(operationDetails);
                    this.BBU.refresh();
                    this.BBUInfo = this.BBU.getInformation();
                    this.setChanged();
                    return;
                }
                case 4: {
                    this.BBU.refresh();
                    this.BBUInfo = this.BBU.getInformation();
                    this.setChanged();
                    this.notifyObservers();
                    return;
                }
                case 3: {
                    if (this.adapter.getAdapterInfo().getCacheIsPinned() == 0 || this.adapter.getAdapterInfo().getCacheIsPinned() == 1 && this.BBUInfo.getStatus().getbatteryType() == '\u0006') {
                        this.BBU.fireOperation(operationDetails);
                        return;
                    } else {
                        new PreservedCachePresent();
                        return;
                    }
                }
                default: {
                    this.BBU.fireOperation(operationDetails);
                    return;
                }
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            Object object = vKOperationFailedException.GetObject();
            if (object instanceof MR_BBU_FW_STATUS) {
                String string = Resource.getString("MSG_LEARN_CYCLE1", "You cannot start a learn cycle at this time because ");
                MR_BBU_FW_STATUS mR_BBU_FW_STATUS = (MR_BBU_FW_STATUS)object;
                string = mR_BBU_FW_STATUS.getpackMissing() ? string + Resource.getString("MSG_LEARN_CYCLE2", "the battery pack is not connected to the controller") : (mR_BBU_FW_STATUS.getvoltageLow() ? string + Resource.getString("MSG_LEARN_CYCLE3", "the battery backup unit's voltage is low") : (mR_BBU_FW_STATUS.gettemperatureHigh() ? string + Resource.getString("MSG_LEARN_CYCLE4", "the battery backup unit is over temperature") : (mR_BBU_FW_STATUS.getchargeActive() ? string + Resource.getString("MSG_LEARN_CYCLE5", "the battery backup unit is charging") : (mR_BBU_FW_STATUS.getdischargeActive() ? string + Resource.getString("MSG_LEARN_CYCLE6", "the battery backup unit is discharging") : (mR_BBU_FW_STATUS.getlearnCycleRequested() ? string + Resource.getString("MSG_LEARN_CYCLE7", "a learn cycle has already been requested") : (mR_BBU_FW_STATUS.getlearnCycleActive() ? string + Resource.getString("MSG_LEARN_CYCLE8", "a learn cycle is already in progress") : (mR_BBU_FW_STATUS.getlearnCycleFailed() ? string + Resource.getString("MSG_LEARN_CYCLE9", "there was a failure") : (mR_BBU_FW_STATUS.getlearnCycleTimeout() ? string + Resource.getString("MSG_LEARN_CYCLE10", "the learn cycle timed out") : (mR_BBU_FW_STATUS.geti2cErrorsDetected() ? string + Resource.getString("MSG_LEARN_CYCLE11", "an I2C error was detected") : Resource.getString("MSG_LEARN_CYCLE12", "BBU is not in a state to start a learn cycle"))))))))));
                new CustomMsgBox(string);
            } else {
                CustomMsgBox.errorMsg(vKOperationFailedException);
            }
            vKOperationFailedException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            VivaldiStartupDialog.mainScreen.ready();
        }
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList<PropertyInfo> getPropertyList() {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        this.advancedPropList = new ArrayList();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.description = propertyInfo.name = Resource.getString("BBU_TYPE", "Type");
        char c = this.BBUInfo.getStatus().getbatteryType();
        int n = this.BBUInfo.getStatus().getsubType();
        propertyInfo.value = this.getBatteryType();
        arrayList.add(propertyInfo);
        if (!this.getBatteryType().equalsIgnoreCase("No Battery") || !this.getBatteryType().equalsIgnoreCase("UnKnown")) {
            PropertyInfo propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("BBU_STATUS_HELPER", "Status");
            propertyInfo2.description = propertyInfo.name;
            propertyInfo2.value = this.getBatteryStatus();
            arrayList.add(propertyInfo2);
            if (!this.getBatteryStatus().equalsIgnoreCase("Missing")) {
                Object object;
                Object object2;
                Object object3;
                PropertyInfo propertyInfo3;
                PropertyInfo propertyInfo4;
                PropertyInfo propertyInfo5;
                Object object4;
                Object object5;
                int n2;
                if (this.BBUInfo.getProperties().getbbuMode() != 0 && ((SASAdapter)this.adapter.getDeviceObject()).getBbuModes() != null && (n2 = ((SASAdapter)this.adapter.getDeviceObject()).getBbuModes().getCount()) != 0) {
                    System.out.println("BBUInfo.getProperties().getbbuMode()" + this.BBUInfo.getProperties().getbbuMode());
                    byte by = this.BBUInfo.getProperties().getbbuMode();
                    object5 = new PropertyInfo();
                    ((PropertyInfo)object5).name = Resource.getString("BBU_DESIGN_MODE", "Design Mode");
                    ((PropertyInfo)object5).value = this.getdesignMode();
                    arrayList.add((PropertyInfo)object5);
                }
                PropertyInfo propertyInfo6 = new PropertyInfo();
                float f = (float)((double)this.BBUInfo.getStatus().gettemperature() * 1.8) + 32.0f;
                propertyInfo6.description = propertyInfo6.name = Resource.getString("BBU_TEMP_STATUS", "Temperature");
                object5 = this.BBUInfo.getStatus().getMrbbufwStatus();
                String string = ((MR_BBU_FW_STATUS)object5).gettemperatureHigh() ? "High" : "Normal";
                propertyInfo6.value = string + " [" + (float)this.BBUInfo.getStatus().gettemperature() + " C " + "(" + f + " F" + ") ]";
                arrayList.add(propertyInfo6);
                MR_IBBU_STATE mR_IBBU_STATE = this.BBUInfo.getStatus().getMr_bbu_status_detail().getMR_iBBU_STATE();
                PropertyInfo propertyInfo7 = null;
                if (c == '\u0001' || c == '\u0004' || c == '\u0005' && mR_IBBU_STATE.getRetentionTime() > 0) {
                    propertyInfo7 = new PropertyInfo();
                    propertyInfo7.description = propertyInfo7.name = Resource.getString("BBU_RETENTION_TIME", "Retention Time");
                    if (mR_IBBU_STATE.getRetentionTime() >= 48) {
                        propertyInfo7.value = "48+ Hours";
                    } else if (mR_IBBU_STATE.getRetentionTime() < 48 && mR_IBBU_STATE.getRetentionTime() > 0) {
                        propertyInfo7.value = mR_IBBU_STATE.getRetentionTime() + " " + "Hours";
                    } else if (mR_IBBU_STATE.getRetentionTime() == 0) {
                        propertyInfo7.value = Resource.getString("PROPERTY_UNKNOWN_TEXT", "Unknown");
                    }
                    arrayList.add(propertyInfo7);
                }
                PropertyInfo propertyInfo8 = null;
                if (c != '\u0006') {
                    object4 = this.BBUInfo.getCapacityInfo();
                    propertyInfo8 = new PropertyInfo();
                    propertyInfo8.description = propertyInfo8.name = Resource.getString("BBU_RELCHARGE_STATE", "Charge");
                    propertyInfo8.value = ((MR_BBU_CAPACITY_INFO)object4).getrelativeStateOfCharge() > 100 ? "100%" : ((MR_BBU_CAPACITY_INFO)object4).getrelativeStateOfCharge() + " %";
                    arrayList.add(propertyInfo8);
                }
                object4 = null;
                if (c == '\u0006') {
                    object4 = new PropertyInfo();
                    ((PropertyInfo)object4).description = ((PropertyInfo)object4).name = Resource.getString("TMMC_BBU_CAPACITANCE", "Capacitance");
                    ((PropertyInfo)object4).value = this.BBUInfo.getStatus().getMr_bbu_status_detail().getMR_TMMC_STATE().getcapacitance() > 100 ? "100%" : this.BBUInfo.getStatus().getMr_bbu_status_detail().getMR_TMMC_STATE().getcapacitance() + "%";
                    arrayList.add((PropertyInfo)object4);
                }
                PropertyInfo propertyInfo9 = new PropertyInfo();
                propertyInfo9.description = propertyInfo9.name = Resource.getString("BBU_CHARGING_STATUS", "Charging Status");
                propertyInfo9.value = ((MR_BBU_FW_STATUS)object5).getchargeActive() ? (c == '\u0006' ? Resource.getString("BBU_CHARGING", "Charging") : Resource.getString("BBU_CHARGING", "Charging") + this.getEstimatedTimeTorecharge()) : (((MR_BBU_FW_STATUS)object5).getdischargeActive() ? (c == '\u0006' ? Resource.getString("BBU_CHARGING_DISCHARGING", "Discharging") : Resource.getString("BBU_CHARGING_DISCHARGING", "Discharging") + this.getAverageTimetoEmpty()) : Resource.getString("PROP_NONE", "None"));
                arrayList.add(propertyInfo9);
                PropertyInfo propertyInfo10 = new PropertyInfo();
                propertyInfo10.description = propertyInfo10.name = Resource.getString("PROPERTY_MFG_NAME", "Manufacturer");
                String string2 = new String(this.BBUInfo.getDesignInfo().getmfgName());
                if (string2 != null && !string2.trim().equals("")) {
                    propertyInfo10.value = string2.trim();
                    this.advancedPropList.add(propertyInfo10);
                }
                PropertyInfo propertyInfo11 = new PropertyInfo();
                propertyInfo11.description = propertyInfo11.name = Resource.getString("PROPERTY_SNUMBER", "Serial Number");
                propertyInfo11.value = String.valueOf(this.BBUInfo.getDesignInfo().getserialNumber());
                this.advancedPropList.add(propertyInfo11);
                PropertyInfo propertyInfo12 = new PropertyInfo();
                propertyInfo12.description = propertyInfo12.name = Resource.getString("PROPERTY_MFG_DATE", "Date of Manufacture");
                propertyInfo12.value = new String(this.BBUInfo.getDesignInfo().mfgDate());
                this.advancedPropList.add(propertyInfo12);
                PropertyInfo propertyInfo13 = new PropertyInfo();
                propertyInfo13.description = propertyInfo13.name = Resource.getString("PROPERTY_FWVERSION_TEXT", "Firmware Version");
                String string3 = new String(this.BBUInfo.getDesignInfo().getModuleVersion());
                if (string3 != null && !string3.trim().equals("")) {
                    propertyInfo13.value = string3.trim();
                    this.advancedPropList.add(propertyInfo13);
                }
                if (!this.getOperationalState()) {
                    this.advancedPropList.add(propertyInfo2);
                    propertyInfo5 = new PropertyInfo();
                    propertyInfo5.value = this.getreasonForBatteryStatus();
                    this.advancedPropList.add(propertyInfo5);
                } else {
                    this.advancedPropList.add(propertyInfo2);
                }
                propertyInfo5 = new PropertyInfo();
                propertyInfo5.description = propertyInfo5.name = Resource.getString("BBU_VOLTAGE_STATUS", "Voltage");
                propertyInfo5.value = this.BBUInfo.getStatus().getvoltage() + " mV";
                this.advancedPropList.add(propertyInfo5);
                PropertyInfo propertyInfo14 = new PropertyInfo();
                propertyInfo14.description = propertyInfo14.name = Resource.getString("BBU_CURRENT_STATUS", "Current");
                propertyInfo14.value = this.BBUInfo.getStatus().getcurrent() + " mA";
                this.advancedPropList.add(propertyInfo14);
                if (c == '\u0006') {
                    propertyInfo4 = new PropertyInfo();
                    propertyInfo4.description = propertyInfo4.name = Resource.getString("BBU_DESIGN_CAPACITY", "Design Capacity");
                    propertyInfo4.value = this.BBUInfo.getDesignInfo().getdesignCapacity() + " Joules";
                    this.advancedPropList.add(propertyInfo4);
                    propertyInfo3 = new PropertyInfo();
                    propertyInfo3.description = propertyInfo3.name = Resource.getString("BBU_REM_CAPACITY", "Remaining Capacity");
                    propertyInfo3.value = this.BBUInfo.getStatus().getMr_bbu_status_detail().getMR_TMMC_STATE().getComputedPackEnergy() + " Joules";
                    this.advancedPropList.add(propertyInfo3);
                } else {
                    propertyInfo4 = new PropertyInfo();
                    propertyInfo4.description = propertyInfo4.name = Resource.getString("BBU_DESIGN_CAPACITY", "Design Capacity");
                    propertyInfo4.value = this.BBUInfo.getDesignInfo().getdesignCapacity() + " mAh";
                    this.advancedPropList.add(propertyInfo4);
                    propertyInfo3 = new PropertyInfo();
                    propertyInfo3.value = this.BBUInfo.getCapacityInfo().getfullChargeCapacity() + " mAh";
                    propertyInfo3.description = propertyInfo3.name = Resource.getString("BBU_FULL_CAPACITY", "Full Capacity");
                    this.advancedPropList.add(propertyInfo3);
                    PropertyInfo propertyInfo15 = new PropertyInfo();
                    propertyInfo15.value = this.BBUInfo.getCapacityInfo().getremainingCapacity() + " mAh";
                    propertyInfo15.description = propertyInfo15.name = Resource.getString("BBU_REM_CAPACITY", "Remaining Capacity");
                    this.advancedPropList.add(propertyInfo15);
                    PropertyInfo propertyInfo16 = new PropertyInfo();
                    propertyInfo16.description = propertyInfo16.name = Resource.getString("BBU_MAX_ERROR", "Expected Margin of Error");
                    propertyInfo16.value = this.BBUInfo.getCapacityInfo().getmaxError() + " %";
                    this.advancedPropList.add(propertyInfo16);
                }
                if (c != '\u0006') {
                    propertyInfo4 = new PropertyInfo();
                    propertyInfo4.description = propertyInfo4.name = Resource.getString("BBU_CYCLE_COUNT", "Completed Discharge Cycles");
                    propertyInfo4.value = this.BBUInfo.getCapacityInfo().getcycleCount() + "";
                    this.advancedPropList.add(propertyInfo4);
                }
                propertyInfo4 = new PropertyInfo();
                propertyInfo4.description = propertyInfo4.name = Resource.getString("AUTO_LEARN_TEXT", "Automatic Learn Mode");
                byte by = this.BBUInfo.getProperties().getautoLearnMode();
                if (this.BBUInfo.getDesignInfo().gettransparentLearns() == '\u0001' && by == 0) {
                    propertyInfo4.value = Resource.getString("TRANPARENT_TEXT", "Transparent");
                } else if (by == 0) {
                    propertyInfo4.value = Resource.getString("AUTO_LEARN_ENABLED", "Enabled") + " (" + Resource.getString("BBU_AUTOLEARN_PERIOD", "Learn Period ") + ": " + BBUHelper.getDaysFromSeconds(this.BBUInfo.getProperties().getautoLearnPeriod()) + " " + Resource.getString("TXT_DAYS", " Days") + ")";
                } else if (by == 2) {
                    propertyInfo4.value = Resource.getString("AUTO_LEARN_WARN", "Warn Via Event");
                } else if (by == 1) {
                    propertyInfo4.value = Resource.getString("AUTO_LEARN_DISABLED", "Disabled");
                }
                this.advancedPropList.add(propertyInfo4);
                short s = NetworkToJavaConverter.getUnsignedVal(this.BBUInfo.getProperties().getLeanDelayInterval());
                long l = (long)this.BBUInfo.getProperties().getnextLeanTime() * 1000L;
                int n3 = s / 24;
                int n4 = s % 24;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE,");
                if (by != 1 && l != 0L) {
                    object3 = new PropertyInfo();
                    object2 = new PropertyInfo();
                    if (by == 2) {
                        ((PropertyInfo)object3).name = Resource.getString("BBU_NEXTEVENT_GENERATION", "Next Event Generation Time");
                    } else if (by == 0) {
                        ((PropertyInfo)object3).name = Resource.getString("BBU_NEXTLEARN_CYCLE", "Next Learn Cycle Time");
                    }
                    ((PropertyInfo)object3).description = ((PropertyInfo)object3).name;
                    try {
                        object = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                        System.out.println("(BBUInfo.getProperties().getnextLeanTime()):" + this.BBUInfo.getProperties().getnextLeanTime());
                        long l2 = ((Calendar)object).getTimeInMillis();
                        TimeZone timeZone = TimeZone.getDefault();
                        ((Calendar)object).setTimeInMillis(l2 + l);
                        boolean bl = timeZone.inDaylightTime(((Calendar)object).getTime());
                        System.out.println("dstSavings:" + bl);
                        if (bl) {
                            int n5 = timeZone.getDSTSavings();
                            ((Calendar)object).setTimeInMillis(l2 + l - (long)n5 + (long)(s * 60 * 60 * 1000));
                        } else {
                            ((Calendar)object).setTimeInMillis(l2 + l + (long)(s * 60 * 60 * 1000));
                        }
                        String string4 = null;
                        String string5 = null;
                        if (by == 2) {
                            string5 = Resource.getString("BBU_NEXTEVENT_GENERATION", "Next Event Generation Time:");
                        } else if (by == 0) {
                            string5 = Resource.getString("BBU_NEXTLEARN_CYCLE", "Next Learn Cycle Time");
                        }
                        Date date = ((Calendar)object).getTime();
                        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("EEE, MMMM dd,yyyy 'at' HH:mm:ss");
                        if (by == 0) {
                            string4 = n3 != 0 && n4 == 0 ? Resource.getString("INCLUDING", "(including") + " " + n3 + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_DELAY", "delay)") : (n3 == 0 && n4 != 0 ? Resource.getString("INCLUDING", "(including") + " " + " " + n4 + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)") : Resource.getString("INCLUDING", "(including") + " " + n3 + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_AND", "and") + " " + n4 + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)"));
                        } else if (by == 2) {
                            string4 = n3 != 0 && n4 == 0 ? Resource.getString("INCLUDING", "(including") + " " + n3 + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_DELAY", "delay)") : (n3 == 0 && n4 != 0 ? Resource.getString("INCLUDING", "(including") + " " + " " + n4 + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)") : Resource.getString("INCLUDING", "(including") + " " + n3 + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_AND", "and") + " " + n4 + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)"));
                        } else if (by == 1) {
                            string4 = Resource.getString("COER_MODE_NONE", "None");
                        }
                        if (date == null) {
                            string4 = Resource.getString("COER_MODE_NONE", "None");
                        } else {
                            ((PropertyInfo)object3).value = simpleDateFormat2.format(date);
                        }
                        if (n3 != 0 || n4 != 0) {
                            ((PropertyInfo)object2).value = string4;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        ((PropertyInfo)object3).value = "";
                    }
                    this.advancedPropList.add((PropertyInfo)object3);
                    this.advancedPropList.add((PropertyInfo)object2);
                }
                object3 = Resource.getString("ADVANCED_PROPERTIES_TEXT", "Advanced Properties");
                object2 = new JLabel("<html><body>&nbsp&nbsp&nbsp<a href=\"" + (String)object3 + "\">" + (String)object3 + "</a></body></html>");
                object = new PropertyInfo();
                ((PropertyInfo)object).isnameHyperLink = true;
                ((PropertyInfo)object).name = object3;
                ((PropertyInfo)object).setGuiHelperObj(this);
                ((PropertyInfo)object).description = ((PropertyInfo)object).name;
                arrayList.add((PropertyInfo)object);
                this.setadvancedPropList(this.advancedPropList);
            }
        }
        return arrayList;
    }

    public ArrayList<PropertyInfo> getadvancedPropList() {
        this.getPropertyList();
        return this.advancedPropList;
    }

    public void setadvancedPropList(ArrayList<PropertyInfo> arrayList) {
    }

    private boolean getOperationalState() {
        char c = this.BBUInfo.getStatus().getbatteryType();
        int n = this.BBUInfo.getStatus().getMrbbufwStatus().getW();
        return c == '\u0002' ? (n & this.MR_BBU_STATUS_BAD_FOR_BBU) == 0 : (c == '\u0001' || c == '\u0004' ? (n & this.MR_BBU_STATUS_BAD_FOR_IBBU) == 0 : (c == '\u0006' ? (n & this.MR_BBU_STATUS_BAD_FOR_TMMC) == 0 : c == '\u0005' && (n & this.MR_BBU_STATUS_BAD_FOR_IBBU08) == 0));
    }

    public String getdesignMode() {
        String string = "";
        int n = ((SASAdapter)this.adapter.getDeviceObject()).getBbuModes().getCount();
        MR_BBU_MODE[] mR_BBU_MODEArray = ((SASAdapter)this.adapter.getDeviceObject()).getBbuModes().getBbuModeList();
        String string2 = new String("1-12");
        String string3 = Resource.getString("NON_TRANPARENT_TEXT", "non-Transparent");
        String string4 = Resource.getString("BBU_MODERATE", "moderate");
        for (int i = 0; i < n; ++i) {
            if (mR_BBU_MODEArray[i].getBbuModeId() != this.BBUInfo.getProperties().getbbuMode()) continue;
            if (mR_BBU_MODEArray[i].getRetentionTime() == 12) {
                string2 = "12+";
            } else if (mR_BBU_MODEArray[i].getRetentionTime() == 24) {
                string2 = "24+";
            } else if (mR_BBU_MODEArray[i].getRetentionTime() == 48) {
                string2 = "48+";
            }
            string3 = mR_BBU_MODEArray[i].getTransparentLearn() == 1 ? Resource.getString("TRANPARENT_TEXT", "transparent") : Resource.getString("NON_TRANPARENT_TEXT", "non-Transparent");
            if (mR_BBU_MODEArray[i].getServiceLife() == 1) {
                string4 = Resource.getString("BBU_MODERATE", "moderate");
                continue;
            }
            if (mR_BBU_MODEArray[i].getServiceLife() == 3) {
                string4 = Resource.getString("BBU_BALANCED", "balanced");
                continue;
            }
            if (mR_BBU_MODEArray[i].getServiceLife() != 5) continue;
            string4 = Resource.getString("BBU_BEST", "best");
        }
        Object[] objectArray = new Object[]{new String(string2), new String(string3), new String(string4)};
        string = MessageFormat.format(Resource.getString("BBU_RETENTION_DESC", "<html>{0} Hrs Retention with a {1} learn cycle and {2} service life</html>"), objectArray);
        return string;
    }

    public String getEstimatedTimeTorecharge() {
        MR_BBU_CAPACITY_INFO mR_BBU_CAPACITY_INFO = this.BBUInfo.getCapacityInfo();
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.unsignedShortTobyteArray(mR_BBU_CAPACITY_INFO.getaverageTimeToFull(), byArray, 0);
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        String string = "";
        string = n == 65535 ? "" : "(" + Resource.getString("BBU_AVGTIMEFULL_CAPACITY", "Estimated time to full recharge:") + ": " + this.getTimeinDHMFormat(n) + ")";
        return string;
    }

    public String getAverageTimetoEmpty() {
        MR_BBU_CAPACITY_INFO mR_BBU_CAPACITY_INFO = this.BBUInfo.getCapacityInfo();
        byte[] byArray = new byte[4];
        String string = "";
        NetworkToJavaConverter.unsignedShortTobyteArray(mR_BBU_CAPACITY_INFO.getaverageTimeToEmpty(), byArray, 0);
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        string = n == 65535 ? "" : "(" + Resource.getString("BBU_AVGTIMEEMPTY_CAPACITY", "Average Time to Empty:") + ": " + this.getTimeinDHMFormat(n) + ")";
        return string;
    }

    public String getTimeinDHMFormat(int n) {
        String string = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = n / 1440;
        n3 = n % 1440 / 60;
        n4 = n % 1440 % 60;
        if (n2 != 0 && n3 != 0 && n4 != 0) {
            string = n2 + " Days, " + n3 + " Hours, " + n4 + " Mins";
        } else if (n3 != 0 && n2 != 0) {
            string = n2 + " Days, " + n3 + " Hours ";
        } else if (n4 != 0 && n2 != 0) {
            string = n2 + " Days, " + n4 + " Mins";
        } else if (n4 != 0 && n3 != 0) {
            string = n3 + " Hours, " + n4 + " Mins";
        } else if (n2 != 0) {
            string = n2 + " Days";
        } else if (n3 != 0) {
            string = n3 + " Hours";
        } else if (n4 != 0) {
            string = n4 + " Mins";
        } else if (n3 == 0 && n2 == 0 && n4 == 0) {
            string = "NA";
        }
        return string;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("BBUHelper Received AEN : " + new String(mR_EVT_DETAIL.getdescription()).trim());
            int n = mR_EVT_DETAIL.getcode();
            switch (n) {
                case 141: 
                case 161: {
                    ((AdapterHelper)this.getParent()).notifyMethod(object);
                    VivaldiStartupDialog.mainScreen.getPhysicalTree().repaint();
                    break;
                }
                case 147: 
                case 148: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 306: 
                case 449: {
                    this.BBUInfo = this.BBU.getInformation();
                    System.out.println("in MR_EVT_BBU_PROPERTIES_CHANGED of BBUHelper");
                    ((AdapterHelper)this.getParent()).notifyMethod(object);
                    if (VivaldiStartupDialog.mainScreen == null) break;
                    VivaldiStartupDialog.mainScreen.getPhysicalTree().repaint();
                    break;
                }
            }
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.adapter;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.getStatus() == 2) {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (this.getStatus() == 1) {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        if (this.getStatus() == 0) {
            return this.getImageIcon(Resource.getString("OPTIMAL_IMAGE", "Optimal.png"));
        }
        if (this.status == 3) {
            return this.getImageIcon(Resource.getString("NEEDS_ATTENTION_IMAGE", "needatn.jpg"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    public int getAutoLearnPeriod() {
        return this.BBUInfo.getProperties().getautoLearnPeriod();
    }

    public int getNextLearnTime() {
        return this.BBUInfo.getProperties().getnextLeanTime();
    }

    public String getBatteryType() {
        String string = null;
        char c = this.BBUInfo.getStatus().getbatteryType();
        int n = this.BBUInfo.getStatus().getsubType();
        if (c < '\u0005') {
            if (c == '\u0002') {
                string = Resource.getString("BBU_TYPE_BBU", "BBU");
            } else if (c == '\u0001') {
                string = Resource.getString("IBBU_TEXT", "IBBU");
            } else if (c == '\u0003') {
                string = Resource.getString("ZCR_LEGACY_TEXT", "ZCR Legacy");
            } else if (c == '\u0004') {
                string = Resource.getString("ITBBU_TEXT", "ITBBU");
            }
        } else if (c == '\u0005') {
            String string2;
            string = n == 0 ? Resource.getString("IBBU08_TEXT", "IBBU08") : (string2 = new String(this.BBUInfo.getDesignInfo().getdeviceName()).trim());
        } else if (c == '\u0006') {
            String string3 = new String(this.BBUInfo.getDesignInfo().getdeviceName());
            if (string3 != null && !string3.trim().equals("")) {
                string = string3.trim();
            }
        } else {
            string = c == '\u0000' ? Resource.getString("NOBBU_TEXT", "No Battery") : Resource.getString("KNOWNBAT_TEXT", "UnKnown");
        }
        return string;
    }

    public String getBatteryStatus() {
        MR_BBU_FW_STATUS mR_BBU_FW_STATUS = this.BBUInfo.getStatus().getMrbbufwStatus();
        char c = this.BBUInfo.getStatus().getbatteryType();
        if (this.adapter.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getbbu() == 0 || mR_BBU_FW_STATUS.getpackMissing() || this.BBUInfo.getStatus().getbatteryType() == '\u0000') {
            return Resource.getString("BBU_MISSING", "Missing");
        }
        if (this.getOperationalState()) {
            return Resource.getString("STATUS_OPTIMAL", "Optimal");
        }
        if (mR_BBU_FW_STATUS.getreplacePack() && !mR_BBU_FW_STATUS.getlearnCycleRequested() && c != '\u0006' || c == '\u0006' && mR_BBU_FW_STATUS.getnoSpace() || !mR_BBU_FW_STATUS.getlearnCycleActive() && !mR_BBU_FW_STATUS.getchargeActive() && mR_BBU_FW_STATUS.getvoltageLow()) {
            return Resource.getString("BBU_FAILED", "Failed");
        }
        if (mR_BBU_FW_STATUS.getlearnCycleActive() && !mR_BBU_FW_STATUS.gettransparentLearn()) {
            return Resource.getString("BBU_LEARN", "Learning");
        }
        if (!mR_BBU_FW_STATUS.getlearnCycleActive() || mR_BBU_FW_STATUS.getpremiumFeatureReqd() || mR_BBU_FW_STATUS.getlearnCycleRequested() || mR_BBU_FW_STATUS.getmicrocodeUpdateReqd() || mR_BBU_FW_STATUS.getpredictiveFailure()) {
            return Resource.getString("BBU_DEGRADED", " Degraded (Needs Attention)");
        }
        if (mR_BBU_FW_STATUS.getremainingCapacityLow() && mR_BBU_FW_STATUS.getchargeActive()) {
            return Resource.getString("BBU_DEGRADED_CHARGING", "Degraded (Charging)");
        }
        if (mR_BBU_FW_STATUS.geti2cErrorsDetected()) {
            return Resource.getString("BBU_DEGRADED_COMFAILURE", "Degraded (Communication Failure)");
        }
        return Resource.getString("KNOWNBAT_TEXT", "UnKnown");
    }

    public String getreasonForBatteryStatus() {
        String string = null;
        MR_BBU_FW_STATUS mR_BBU_FW_STATUS = this.BBUInfo.getStatus().getMrbbufwStatus();
        if (mR_BBU_FW_STATUS.getreplacePack() && !mR_BBU_FW_STATUS.getlearnCycleRequested()) {
            string = Resource.getString("BBU_FAILED_REASON", "The battery has been failed. Please replace the battery pack");
        } else if (mR_BBU_FW_STATUS.getlearnCycleActive() && !mR_BBU_FW_STATUS.gettransparentLearn()) {
            string = Resource.getString("BBU_LEARN_REASON", "Write-cache is currently not supported because a learn cycle is in progress, but battery will return to optimal once the learn cycle completes.");
        } else if (!mR_BBU_FW_STATUS.getlearnCycleActive() && mR_BBU_FW_STATUS.getlearnCycleRequested()) {
            string = Resource.getString("BBU_DEGRADED_MANUAL_LEARN", "Start a manual learn to recondition the battery");
        } else if (mR_BBU_FW_STATUS.getpremiumFeatureReqd()) {
            string = Resource.getString("BBU_PREMIUM_REQUIRED", "Requires premium feature activation. In order to activate choose MegaRAID Advanced Software Options from the controller menu.");
        } else if (mR_BBU_FW_STATUS.getmicrocodeUpdateReqd()) {
            string = Resource.getString("BBU_DEGRADED_MICRO", "The firmware of the battery is corrupted. It is recommended to update the battery firmware");
        } else if (mR_BBU_FW_STATUS.getpredictiveFailure()) {
            string = Resource.getString("BBU_DEGRADED_FAILURE", "The battery is nearing the end of life. It can still support the minimum Data retention time");
        }
        return string;
    }

    static int getDaysFromSeconds(int n) {
        return Math.round((float)n / 86400.0f);
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

