/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUIHelper.ArrayHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SL_LD_INFO_T;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;

public class CapacityHelper {
    private SL_ARRAY_INFO_T m_SLarrayInfo;
    private freeInfo_SL_ARRAY_INFO_T m_FreeInfoSLArrayInfo;
    int m_freeIndex;
    ArrayHelper m_arrayHelper;

    public CapacityHelper(SL_ARRAY_INFO_T sL_ARRAY_INFO_T, int n, ArrayHelper arrayHelper) {
        this.m_SLarrayInfo = sL_ARRAY_INFO_T;
        this.m_freeIndex = n;
        freeInfo_SL_ARRAY_INFO_T[] freeInfo_SL_ARRAY_INFO_TArray = this.m_SLarrayInfo.getfreeInfo_SL_ARRAY_INFO_T();
        this.m_FreeInfoSLArrayInfo = freeInfo_SL_ARRAY_INFO_TArray[this.m_freeIndex];
        this.m_arrayHelper = arrayHelper;
    }

    public SL_ARRAY_INFO_T getSLArrayInfo() {
        return this.m_SLarrayInfo;
    }

    public freeInfo_SL_ARRAY_INFO_T getFreeInfoSLArrInfo() {
        return this.m_FreeInfoSLArrayInfo;
    }

    public int getFreeIndex() {
        return this.m_freeIndex;
    }

    public short getArrayRef() {
        return this.m_SLarrayInfo.getarray().getarrayRef();
    }

    public int getRAIDLevelInfo() {
        SL_LD_INFO_T[] sL_LD_INFO_TArray = this.m_SLarrayInfo.getldInfo();
        return sL_LD_INFO_TArray[0].getPRL();
    }

    public PhysicalDriveHelper[] getDedicatedSpares() {
        return this.m_arrayHelper.getDedicatedSpares();
    }

    public long getFreeSpaceInBlocks(int n) {
        int n2 = this.getRAIDLevelInfo();
        char c = this.m_SLarrayInfo.getarray().getnumDrives();
        long l = this.m_FreeInfoSLArrayInfo.getnumBlocks() * (long)c;
        if (n2 == 0) {
            return l * (long)n;
        }
        if (n2 == 1 || n2 == 17) {
            return l / 2L * (long)n;
        }
        if (n2 == 5) {
            return l * (long)(c - '\u0001') / (long)c * (long)n;
        }
        if (n2 == 6) {
            return l * (long)(c - 2) / (long)c * (long)n;
        }
        return 0L;
    }

    public short getUserDataBlockSize() {
        return this.m_arrayHelper.getBlockSize();
    }

    public ArrayHelper getArrayHelper() {
        return this.m_arrayHelper;
    }
}

