/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.CCOH.CCOHDeviceHelper;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PeerServerLdHelper;
import GUIHelper.ProgressInfo;
import SASKernel.ISASObject;
import SASKernel.Operations.OperationDetails;
import Utils.Resource;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.ImageIcon;

public class ContainerNodeHelper
extends Observable
implements GUIHelperInterface {
    private GUIHelperInterface m_object;
    private int CallerIdentifier;
    private String m_capacity;
    private int spannedDriveGroupCount;
    private AdapterHelper m_adapter;
    private ArrayHelper m_arrayHelper = null;
    private int m_holeid = 0;
    private CCOHDeviceHelper m_objCachedDeviceHelper = null;
    private PeerServerLdHelper m_PeerLdHelper = null;
    public static final int TYPE_CONTAINER_VIRTUALDRIVES = 1;
    public static final int TYPE_CONTAINER_DRIVES = 2;
    public static final int TYPE_CONTAINER_DEDICATEDHOTSPARES = 3;
    public static final int TYPE_CONTAINER_GLOBALHOTSPARES = 4;
    public static final int TYPE_CONTAINER_TOTAL_FREE_CAPACITY = 5;
    public static final int TYPE_CONTAINER_UNCONFIGUREDDRIVES = 6;
    public static final int TYPE_CONTAINER_CAPACITY = 8;
    public static final int TYPE_CONTAINER_SSCD = 9;
    public static final int TYPE_CONTAINER_CACHED_DEVICE = 10;

    public ContainerNodeHelper(GUIHelperInterface gUIHelperInterface, int n) {
        this.m_object = gUIHelperInterface;
        this.CallerIdentifier = n;
    }

    public ContainerNodeHelper(GUIHelperInterface gUIHelperInterface, String string, int n, int n2) {
        this.m_object = gUIHelperInterface;
        this.m_arrayHelper = (ArrayHelper)gUIHelperInterface;
        this.m_capacity = string;
        this.CallerIdentifier = n;
        this.m_adapter = (AdapterHelper)((ArrayHelper)gUIHelperInterface).getParent();
        this.m_holeid = n2;
    }

    public ContainerNodeHelper(GUIHelperInterface gUIHelperInterface, int n, int n2) {
        this.m_object = gUIHelperInterface;
        this.spannedDriveGroupCount = n;
        this.CallerIdentifier = n2;
    }

    public ContainerNodeHelper(PeerServerLdHelper peerServerLdHelper, int n, boolean bl) {
        this.m_PeerLdHelper = peerServerLdHelper;
        this.CallerIdentifier = n;
    }

    public ContainerNodeHelper(int n, CCOHDeviceHelper cCOHDeviceHelper) {
        this.m_objCachedDeviceHelper = cCOHDeviceHelper;
        this.CallerIdentifier = n;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public String getText() {
        switch (this.CallerIdentifier) {
            case 1: {
                return Resource.getString("VIRTUAL_DRIVES_TEXT", "Virtual Drives");
            }
            case 2: {
                return Resource.getString("DRIVES_TEXT", "Drives");
            }
            case 3: {
                return Resource.getString("DEDICATED_HOT_SPARES_TEXT", "Dedicated Hot Spares");
            }
            case 4: {
                return Resource.getString("GLOBAL_HOT_SPARES_TEXT", "Global Hot Spares");
            }
            case 5: {
                return Resource.getString("TOTAL_FREE_CAPACITY_TEXT", "Total Free Capacity") + ": " + this.m_capacity;
            }
            case 6: {
                return Resource.getString("UNCONFIGURED_DRIVES_TEXT", "Unconfigured Drives");
            }
            case 8: {
                return Resource.getString("CAPACITY_TEXT", "Capacity") + ": " + this.m_capacity;
            }
            case 9: {
                return Resource.getString("CACHECADE_TEXT", "CacheCade\u2122");
            }
            case 10: {
                return this.m_objCachedDeviceHelper.getText();
            }
            case 16: {
                return this.m_PeerLdHelper.getText();
            }
        }
        return "";
    }

    @Override
    public byte getType() {
        return 11;
    }

    @Override
    public ImageIcon getIcon() {
        switch (this.CallerIdentifier) {
            case 1: {
                return this.getImageIcon(Resource.getString("VOLUMES_IMAGE", "volumes.png"));
            }
            case 2: {
                return this.getImageIcon(Resource.getString("CONFIGURED_DRIVES_IMAGE", "configured_drives.png"));
            }
            case 3: {
                return this.getImageIcon(Resource.getString("HOTSPARES_IMAGE", "hotspares.png"));
            }
            case 4: {
                return this.getImageIcon(Resource.getString("HOTSPARES_GLOBAL_IMAGE", "hotspares_global.png"));
            }
            case 5: {
                return this.getImageIcon(Resource.getString("FREE_CAPACITY_TOTAL_IMAGE", "free_capacity_total.png"));
            }
            case 6: {
                return this.getImageIcon(Resource.getString("UNCONFIGURED_DRIVES_IMAGE", "unconfigured_drives.png"));
            }
            case 8: {
                return this.getImageIcon(Resource.getString("FREE_CAPACITY_IMAGE", "free_capacity.png"));
            }
            case 9: {
                return this.getImageIcon(Resource.getString("SSC_GROUP_IMAGE", "sscds_group.png"));
            }
            case 10: {
                return this.getImageIcon(Resource.getString("CONTROLLER_STANDARD_IMAGE", "controller_standard.png"));
            }
            case 16: {
                return this.getImageIcon(Resource.getString("VOLUME_IMAGE", "volume.png"));
            }
        }
        return null;
    }

    @Override
    public ISASObject getDeviceObject() {
        return null;
    }

    @Override
    public ArrayList getOperationList() {
        return null;
    }

    @Override
    public GUIHelperInterface getParent() {
        return null;
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        return null;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public void setStatus(int n) {
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public int getCallerIdentifier() {
        return this.CallerIdentifier;
    }

    public AdapterHelper getAdapterHelper() {
        return this.m_adapter;
    }

    public ArrayHelper getArrayHelper() {
        return this.m_arrayHelper;
    }

    public int getHoleid() {
        return this.m_holeid;
    }

    public GUIHelperInterface getObHelperInterface() {
        return this.m_object;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

