/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUIHelper.AdapterHelper;
import GUIHelper.CDROMHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import GUIHelper.TapeHelper;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTORS;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTOR_INFO;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_EX_T;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_SCSI_PASSTHRU_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASEnclosure;
import Utils.Resource;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.ImageIcon;

public class EnclosureHelper
extends Observable
implements GUIHelperInterface {
    private AdapterHelper m_adapter;
    private int status = 0;
    private SASEnclosure m_sasEnclosure;
    private SL_ENCL_STATUS_T m_enclStatus;
    private SL_ENCL_STATUS_EX_T m_enclStatusExT = null;
    private String m_strBackplaneID = null;
    private int m_iPhyNum = -1;
    private String m_strPartnerEnclConnectorName = null;
    private boolean m_isDellMultipathEnclosure;
    private int m_iEnclosurePositionInDaisyChain;
    private int m_iEnclIndexInSortedList;

    public EnclosureHelper(SASEnclosure sASEnclosure, AdapterHelper adapterHelper) {
        this.m_adapter = adapterHelper;
        this.m_sasEnclosure = sASEnclosure;
        this.m_enclStatus = sASEnclosure.getStatusInformation();
        this.m_enclStatusExT = sASEnclosure.getEnclosureStatusExT();
        sASEnclosure.addObserver(this);
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.m_sasEnclosure;
    }

    public boolean isBackplane() {
        MR_ENCL_INFO mR_ENCL_INFO = this.m_sasEnclosure.getEnclInfo();
        if (mR_ENCL_INFO != null) {
            char c = mR_ENCL_INFO.getenclConnectorIndex();
            char c2 = mR_ENCL_INFO.gettype();
            if ((c & 0xFF) == 255 && c2 == '\u0003') {
                return true;
            }
        }
        return false;
    }

    public int getConnectorIndex() {
        char c = '\u0000';
        if (this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportMultipath() != 0) {
            byte[] byArray = this.m_sasEnclosure.getInformation().getpathInfo_MR_PD_INFO1().getconnectorIndex();
            if (byArray[0] != -1) {
                c = byArray[0];
            } else if (byArray[1] != -1) {
                c = byArray[1];
            }
        } else {
            c = this.m_sasEnclosure.getStatusInformation().getenclConnectorIndex();
        }
        return c;
    }

    public int getEnclConnectorIndex() {
        MR_ENCL_INFO mR_ENCL_INFO = this.m_sasEnclosure.getEnclInfo();
        if (mR_ENCL_INFO != null) {
            char c = mR_ENCL_INFO.getenclConnectorIndex();
            if ((c & 0xFF) == 255) {
                PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
                if (physicalDriveHelperArray.length > 0) {
                    int n = physicalDriveHelperArray[0].getConnectorIndex();
                    for (int i = 1; i < physicalDriveHelperArray.length; ++i) {
                        n = Math.min(n, physicalDriveHelperArray[i].getConnectorIndex());
                    }
                    return n;
                }
            } else {
                return this.getConnectorIndex();
            }
        }
        return -1;
    }

    public String getConnectorname() {
        MR_SAS_CONNECTOR_INFO[] mR_SAS_CONNECTOR_INFOArray;
        String string = null;
        int n = this.getConnectorIndex();
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = ((SASAdapter)this.m_adapter.getDeviceObject()).getConnector();
        if (mR_SAS_CONNECTORS != null && (mR_SAS_CONNECTOR_INFOArray = mR_SAS_CONNECTORS.getConnectors()) != null) {
            string = n < mR_SAS_CONNECTOR_INFOArray.length ? Resource.zeroTrim(mR_SAS_CONNECTOR_INFOArray[n].getName()) : (n == 65535 ? Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal") : Resource.getString("PDTYPE_UNKNOWN", "Unknown"));
        }
        return string;
    }

    public String getenclLocation() {
        MR_SAS_CONNECTOR_INFO[] mR_SAS_CONNECTOR_INFOArray;
        String string = null;
        byte by = 0;
        int n = this.getConnectorIndex();
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = ((SASAdapter)this.m_adapter.getDeviceObject()).getConnector();
        if (mR_SAS_CONNECTORS != null && (mR_SAS_CONNECTOR_INFOArray = mR_SAS_CONNECTORS.getConnectors()) != null) {
            if (n < mR_SAS_CONNECTOR_INFOArray.length) {
                by = mR_SAS_CONNECTOR_INFOArray[n].getLocation();
                if (by == 0) {
                    string = Resource.getString("PDTYPE_UNKNOWN", "Unknown");
                } else if (by == 2) {
                    string = Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal");
                } else if (by == 3) {
                    string = Resource.getString("PROPERTY_MUXMODE_EXT_TEXT", "External");
                }
            } else {
                string = n == 65535 ? Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal") : Resource.getString("PDTYPE_UNKNOWN", "Unknown");
            }
        }
        return string;
    }

    public int getenclosureLocation() {
        MR_SAS_CONNECTOR_INFO[] mR_SAS_CONNECTOR_INFOArray;
        int n = this.getConnectorIndex();
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = ((SASAdapter)this.m_adapter.getDeviceObject()).getConnector();
        if (mR_SAS_CONNECTORS != null && (mR_SAS_CONNECTOR_INFOArray = mR_SAS_CONNECTORS.getConnectors()) != null && n < mR_SAS_CONNECTOR_INFOArray.length) {
            return mR_SAS_CONNECTOR_INFOArray[n].getLocation();
        }
        return 0;
    }

    public boolean isMultiPath() {
        boolean bl = false;
        if (this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportMultipath() != 0) {
            if (this.m_sasEnclosure.getInformation().getenclPartnerDeviceId() != -1) {
                bl = true;
            } else {
                byte[] byArray = this.m_sasEnclosure.getInformation().getpathInfo_MR_PD_INFO1().getconnectorIndex();
                if (byArray[0] != -1 && byArray[1] != -1) {
                    this.m_isDellMultipathEnclosure = true;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isDaisyChain() {
        char c;
        boolean bl = false;
        EnclosureHelper[] enclosureHelperArray = this.m_adapter.getEnclosures();
        boolean bl2 = false;
        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = this.m_adapter.getMFCDefaults();
        if (mR_MFC_DEFAULTS != null) {
            bl2 = mR_MFC_DEFAULTS.isZeroBasedEnclEnumeration();
        }
        char c2 = c = bl2 ? (char)'\u0000' : '\u0001';
        if (enclosureHelperArray.length < 2) {
            bl = false;
        } else {
            String string = this.getConnectorname();
            block0: for (int i = 0; i < enclosureHelperArray.length; ++i) {
                SASEnclosure sASEnclosure = (SASEnclosure)enclosureHelperArray[i].getDeviceObject();
                if (sASEnclosure == null || sASEnclosure.getStatusInformation().getenclPosition() <= c) continue;
                if (this.isMultiPath()) {
                    bl = true;
                    break;
                }
                String string2 = null;
                for (int j = 0; j < enclosureHelperArray.length; ++j) {
                    if (this.equals(enclosureHelperArray[j]) || !string.equals(string2 = enclosureHelperArray[j].getConnectorname())) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        return bl;
    }

    @Override
    public String getText() {
        String string = null;
        if (this.isBackplane()) {
            string = Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane");
            if (this.m_strBackplaneID != null) {
                string = string + " " + this.getBackplaneIdentifier();
            }
        } else if (((SASAdapter)this.m_adapter.getDeviceObject()).getAdapterType() == 1) {
            if (this.isDaisyChain()) {
                string = this.m_sasEnclosure.getProductInfo() + " (" + this.m_sasEnclosure.getDeviceId() + "), ";
                if (this.m_enclStatus.getMR_ENCL_INFO() != null && (this.m_enclStatus.getMR_ENCL_INFO().getenclConnectorIndex() & 0xFF) != 255) {
                    string = string + Resource.getString("PROPERTY_CONNECTOR_TEXT", "Connector") + ": " + this.getConnectorNameText() + ", ";
                }
                string = string + Resource.getString("ENCL_POSITION_TEXT", "Position") + ": " + this.m_enclStatus.getenclPosition() + "";
            } else {
                string = this.m_sasEnclosure.getProductInfo() + " (" + this.m_sasEnclosure.getDeviceId() + ")";
                if (this.m_enclStatus.getMR_ENCL_INFO() != null && (this.m_enclStatus.getMR_ENCL_INFO().getenclConnectorIndex() & 0xFF) != 255) {
                    string = string + ", " + Resource.getString("PROPERTY_CONNECTOR_TEXT", "Connector") + ": " + this.getConnectorNameText();
                }
            }
        } else {
            string = Resource.getString("ENCLOSURE_TEXT", "Enclosure") + " (" + this.m_sasEnclosure.getDeviceId() + ")";
        }
        return string;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 6;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isBackplane()) {
            return this.getImageIcon(Resource.getString("BACKPLANE_IMAGE", "backplane.png"));
        }
        return this.getImageIcon(Resource.getString("ENCLOSURE_IMAGE", "enclosure.png"));
    }

    @Override
    public ArrayList getOperationList() {
        return null;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROPERTY_VENDORID_TEXT", "Vendor ID");
        propertyInfo.description = Resource.getString("PROPERTY_VENDORID_TEXT", "Vendor ID");
        propertyInfo.value = this.m_sasEnclosure.getVendorInfo();
        arrayList.add(propertyInfo);
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROPERTY_ENCLOSUREID_TEXT", "Enclosure ID");
        propertyInfo2.value = "" + this.m_sasEnclosure.getDeviceId();
        propertyInfo2.description = Resource.getString("PROPERTY_ENCLOSUREID_TEXT", "Enclosure ID");
        arrayList.add(propertyInfo2);
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_SERIAL_NO_TEXT", "Serial Number");
        propertyInfo3.value = "" + this.m_sasEnclosure.getSerialNumber();
        propertyInfo3.description = Resource.getString("PROPERTY_SERIAL_NO_TEXT", "Serial Number");
        arrayList.add(propertyInfo3);
        if (!(this.isBackplane() || this.m_sasEnclosure.getVendorInfo().trim().compareToIgnoreCase("IBM") != 0 || this.m_sasEnclosure.getProductInfo().trim().compareToIgnoreCase("EXP2512") != 0 && this.m_sasEnclosure.getProductInfo().trim().compareToIgnoreCase("EXP2524") != 0)) {
            object4 = this.getstdInquiryData((byte)-1);
            object3 = this.getZoningMode((byte)-1);
            object2 = new String((byte[])object4, 26, 6).trim();
            object = new String((byte[])object3, 8, 4).trim();
            String string = new String((byte[])object4, 8, 8).trim();
            PropertyInfo propertyInfo4 = new PropertyInfo();
            propertyInfo4.name = Resource.getString("PROPERTY_ESM_SERIAL_NO_TEXT", "ESM Serial Number");
            propertyInfo4.value = "" + (String)object2;
            propertyInfo4.description = Resource.getString("PROPERTY_ESM_SERIAL_NO_TEXT", "ESM Serial Number");
            arrayList.add(propertyInfo4);
            PropertyInfo propertyInfo5 = new PropertyInfo();
            propertyInfo5.name = Resource.getString("PROPERTY_FRU_INFO_TEXT", "FRU Info");
            propertyInfo5.value = "" + string;
            propertyInfo5.description = Resource.getString("PROPERTY_FRU_INFO_TEXT", "FRU Info");
            arrayList.add(propertyInfo5);
            PropertyInfo propertyInfo6 = new PropertyInfo();
            propertyInfo6.name = Resource.getString("PROPERTY_ZONING_MODE_TEXT", "Zoning Mode");
            propertyInfo6.value = "" + ((String)object).toString();
            propertyInfo6.description = Resource.getString("PROPERTY_ZONING_MODE_TEXT", "ESM Zoning Mode");
            arrayList.add(propertyInfo6);
        }
        if (this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportEnclEnumeration() != 0 && ((SASAdapter)this.m_adapter.getDeviceObject()).getAdapterType() == 1) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_ENCLOSUREMODEL_TEXT", "Enclosure Model");
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_ENCLOSUREMODEL_TEXT", "Enclosure Model");
            ((PropertyInfo)object4).value = this.isBackplane() ? Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane") : this.m_sasEnclosure.getProductInfo();
            arrayList.add(object4);
        }
        if (((SASAdapter)this.m_adapter.getDeviceObject()).getAdapterType() == 1) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_ENCLLOCATION_TEXT", "Enclosure Location");
            ((PropertyInfo)object4).value = this.getenclLocation();
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_ENCLLOCATION_TEXT", "Enclosure Location");
            arrayList.add(object4);
        }
        if (this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportEnclEnumeration() != 0 && this.isDaisyChain() && ((SASAdapter)this.m_adapter.getDeviceObject()).getAdapterType() == 1) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_ENCLPOSITION_TEXT", "Enclosure Position");
            ((PropertyInfo)object4).value = this.m_enclStatus.getenclPosition() + "";
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_ENCLPOSITION_TEXT", "Enclosure Position");
            arrayList.add(object4);
        }
        if (this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportEnclEnumeration() != 0 && ((SASAdapter)this.m_adapter.getDeviceObject()).getAdapterType() == 1 && this.m_enclStatus.getMR_ENCL_INFO() != null && (this.m_enclStatus.getMR_ENCL_INFO().getenclConnectorIndex() & 0xFF) != 255) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_CONNECTOR_TEXT", "Connector");
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_CONNECTOR_TEXT", "Connector");
            ((PropertyInfo)object4).value = this.getConnectorNameText();
            arrayList.add(object4);
        }
        if (!this.isBackplane()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_SLOTNUMBER_TEXT", "Number of Slots");
            ((PropertyInfo)object4).value = this.m_enclStatus.getslotCount() + "";
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_SLOTNUMBER_TEXT", "Number of Slots");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            object3.name = Resource.getString("PROPERTY_PRODREVLEVEL_TEXT", "Product Revision Level");
            object3.description = Resource.getString("PROPERTY_PRODREVLEVEL_TEXT", "Product Revision Level");
            object3.value = this.m_sasEnclosure.getProductRevisionLevel();
            arrayList.add(object3);
        }
        if (!this.isBackplane()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROP_COMPPROP", "<html><b>Component Properties:</b></html>");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            object3.name = Resource.getString("PROPERTY_FANNUMBER_TEXT", "Number of Fans");
            object3.value = this.m_enclStatus.getfanCount() + "";
            object3.description = Resource.getString("PROPERTY_FANNUMBER_TEXT", "Number of Fans");
            arrayList.add(object3);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("PROPERTY_PSUPPLYNUMBER_TEXT", "Number of Power Supplies");
            ((PropertyInfo)object2).value = this.m_enclStatus.getpsCount() + "";
            ((PropertyInfo)object2).description = Resource.getString("PROPERTY_PSUPPLYNUMBER_TEXT", "Number of Power Supplies");
            arrayList.add(object2);
            if (this.m_enclStatusExT != null) {
                object = new PropertyInfo();
                ((PropertyInfo)object).name = Resource.getString("PROPERTY_VOLTAGE_SENSOR_COUNT");
                ((PropertyInfo)object).value = "" + this.m_enclStatusExT.getVoltageSensorCount();
                ((PropertyInfo)object).description = Resource.getString("PROPERTY_VOLTAGE_SENSOR_COUNT");
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public byte[] getstdInquiryData(byte by) {
        byte[] byArray = new byte[6];
        byArray[0] = 18;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[4] = by;
        int n = 255;
        SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.m_enclStatus.getMR_ENCL_INFO().getdeviceId(), 1, 0, 2, 10, byArray, n, new byte[n]);
        try {
            SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T2 = ((SASAdapter)this.m_sasEnclosure.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
            byte[] byArray2 = sL_SCSI_PASSTHRU_T2.getdata();
            return byArray2;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
    }

    public byte[] getZoningMode(byte by) {
        byte[] byArray = new byte[6];
        byArray[0] = 18;
        byArray[1] = 1;
        byArray[2] = -61;
        byArray[4] = by;
        int n = 255;
        SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.m_enclStatus.getMR_ENCL_INFO().getdeviceId(), 1, 0, 2, 10, byArray, n, new byte[n]);
        try {
            SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T2 = ((SASAdapter)this.m_sasEnclosure.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
            byte[] byArray2 = sL_SCSI_PASSTHRU_T2.getdata();
            return byArray2;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
    }

    public PhysicalDriveHelper[] getPhysicalDrives() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapter.getPhysicalDrives();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        short s = -10000;
        boolean bl = false;
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            for (int j = 0; j < this.m_adapter.getEnclosures().length; ++j) {
                SASEnclosure sASEnclosure = (SASEnclosure)this.m_adapter.getEnclosures()[j].getDeviceObject();
                if (sASEnclosure == null || sASEnclosure.getStatusInformation() == null) continue;
                try {
                    short s2 = sASEnclosure.getInformation().getenclPartnerDeviceId();
                    if (s == s2) {
                        bl = false;
                        continue;
                    }
                    s = s2;
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string = this.m_sasEnclosure.getProductInfo().trim();
            if (bl && this.m_sasEnclosure.getDeviceId() != 252 && !string.equals("NEM Plus")) {
                arrayList.add(physicalDriveHelperArray[i]);
                continue;
            }
            if (physicalDriveHelperArray[i].getEnclosureID() != this.m_sasEnclosure.getDeviceId() || string.equals("NEM Plus")) continue;
            arrayList.add(physicalDriveHelperArray[i]);
        }
        PhysicalDriveHelper[] physicalDriveHelperArray2 = new PhysicalDriveHelper[arrayList.size()];
        for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
            physicalDriveHelperArray2[i] = (PhysicalDriveHelper)arrayList.get(i);
        }
        return physicalDriveHelperArray2;
    }

    public CDROMHelper[] getCDROMs() {
        CDROMHelper[] cDROMHelperArray = this.m_adapter.getCDROMs();
        ArrayList<CDROMHelper> arrayList = new ArrayList<CDROMHelper>();
        for (int i = 0; i < cDROMHelperArray.length; ++i) {
            if (cDROMHelperArray[i].getEnclosureID() != this.m_sasEnclosure.getDeviceId()) continue;
            arrayList.add(cDROMHelperArray[i]);
        }
        CDROMHelper[] cDROMHelperArray2 = new CDROMHelper[arrayList.size()];
        for (int i = 0; i < cDROMHelperArray2.length; ++i) {
            cDROMHelperArray2[i] = (CDROMHelper)arrayList.get(i);
        }
        return cDROMHelperArray2;
    }

    public TapeHelper[] getTapes() {
        TapeHelper[] tapeHelperArray = this.m_adapter.getTapes();
        ArrayList<TapeHelper> arrayList = new ArrayList<TapeHelper>();
        for (int i = 0; i < tapeHelperArray.length; ++i) {
            if (tapeHelperArray[i].getEnclosureID() != this.m_sasEnclosure.getDeviceId()) continue;
            arrayList.add(tapeHelperArray[i]);
        }
        TapeHelper[] tapeHelperArray2 = new TapeHelper[arrayList.size()];
        for (int i = 0; i < tapeHelperArray2.length; ++i) {
            tapeHelperArray2[i] = (TapeHelper)arrayList.get(i);
        }
        return tapeHelperArray2;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("ENCLHelper Received AEN : " + new String(mR_EVT_DETAIL.getdescription()).trim());
        }
        this.m_enclStatus = this.m_sasEnclosure.getStatusInformation();
        this.m_enclStatusExT = this.m_sasEnclosure.getEnclosureStatusExT();
        this.setChanged();
        this.notifyObservers(object);
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.m_adapter;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.status == 2) {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (this.status == 1) {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        if (this.status == 3) {
            return this.getImageIcon(Resource.getString("NEEDS_ATTENTION_IMAGE", "needatn.jpg"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    public int getFanNumber() {
        return this.m_enclStatus.getfanCount();
    }

    public int getPowerSupplyNumber() {
        return this.m_enclStatus.getpsCount();
    }

    public boolean isVirtual() {
        return this.m_sasEnclosure.getInformation().getscsiDevType() == '\u001f';
    }

    public SL_ENCL_STATUS_EX_T getEnclosureStatusEx() {
        return this.m_enclStatusExT;
    }

    public SL_ENCL_STATUS_T getEnclosureStatus() {
        return this.m_enclStatus;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getEnclosureProductName() {
        if (this.m_adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportEnclEnumeration() != 0 && ((SASAdapter)this.m_adapter.getDeviceObject()).getAdapterType() == 1) {
            if (this.isBackplane()) {
                return Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane");
            }
            return this.m_sasEnclosure.getProductInfo();
        }
        return null;
    }

    public String getEnclosureType() {
        char c = this.m_sasEnclosure.getEnclInfo().gettype();
        if (c == '\u0000') {
            return Resource.getString("ENCL_TYPE_UNKNOWN", "Unknown");
        }
        if (c == '\u0001') {
            return Resource.getString("ENCL_TYPE_SAFTE", "Safte");
        }
        if (c == '\u0002') {
            return Resource.getString("ENCL_TYPE_SES", "Ses");
        }
        if (c == '\u0003') {
            return Resource.getString("ENCL_TYPE_SGPIO", "Sgpio");
        }
        return "";
    }

    public String getEnclosureStatusFault() {
        if (this.m_sasEnclosure.getEnclInfo().getisFault() == '\u0001') {
            return Resource.getString("ENCL_FAULTY", "Faulty");
        }
        return Resource.getString("ENCL_OK", "OK");
    }

    private String getPartnerConnectorName() {
        return this.m_strPartnerEnclConnectorName;
    }

    public String getConnectorNameText() {
        if (this.isMultiPath()) {
            String string = this.getConnectorname();
            String string2 = this.getPartnerConnectorName();
            if (string2 == null) {
                if (this.m_isDellMultipathEnclosure) {
                    return this.getConnectorNameForMultipathDellEncl();
                }
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = string.compareToIgnoreCase(string2) < 0 ? new StringBuffer(string).append(" & ").append(string2) : new StringBuffer(string2).append(" & ").append(string);
            return stringBuffer.toString();
        }
        return this.getConnectorname();
    }

    public void setPartnerConnectorName(String string) {
        this.m_strPartnerEnclConnectorName = string;
    }

    public void setBackplaneIdentifier(String string) {
        this.m_strBackplaneID = string;
    }

    public String getBackplaneIdentifier() {
        return this.m_strBackplaneID;
    }

    public short getDeviceID() {
        return this.m_sasEnclosure.getDeviceId();
    }

    public void setPhyNum(int n) {
        this.m_iPhyNum = n;
    }

    public int getPhyNum() {
        return this.m_iPhyNum;
    }

    public String getConnectorNameForMultipathDellEncl() {
        MR_SAS_CONNECTOR_INFO[] mR_SAS_CONNECTOR_INFOArray;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = ((SASAdapter)this.m_adapter.getDeviceObject()).getConnector();
        if (mR_SAS_CONNECTORS != null && (mR_SAS_CONNECTOR_INFOArray = mR_SAS_CONNECTORS.getConnectors()) != null) {
            String string2 = Resource.zeroTrim(mR_SAS_CONNECTOR_INFOArray[0].getName());
            String string3 = Resource.zeroTrim(mR_SAS_CONNECTOR_INFOArray[1].getName());
            if (string3 != null) {
                stringBuffer = string2.compareToIgnoreCase(string3) < 0 ? new StringBuffer(string2).append(" & ").append(string3) : new StringBuffer(string3).append(" & ").append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public int getEnclosurePositionInDaisyChain() {
        if (this.isDaisyChain()) {
            this.m_iEnclosurePositionInDaisyChain = this.m_enclStatus.getenclPosition();
        }
        return this.m_iEnclosurePositionInDaisyChain;
    }

    public void setEnclIndexInSortedList(int n) {
        this.m_iEnclIndexInSortedList = n;
    }

    public int getEnclIndexInSortedList() {
        return this.m_iEnclIndexInSortedList;
    }
}

