/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.PreservedCache.PreservedCachePresent;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_LD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PARAMETERS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PIT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROGRESS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_REPOSITORY_SPACE;
import SASKernel.LibraryAPI.StoreLib.MR_LD_TARGETID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_RECON;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_EX_T;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_DETAILS_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.raidLevels_MR_CTRL_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASServer;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;
import Utils.CustomMsgBox;
import Utils.DoubleIcons;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import java.awt.Image;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LogicalDriveHelper
extends Observable
implements GUIHelperInterface {
    private GUIHelperInterface parent;
    private SASLogicalDrive ldrive;
    private MR_LD_INFO ldInfo;
    private MR_LD_PROPERTIES ldProp;
    private MR_LD_PARAMETERS ldParam;
    private MR_LD_PIT_INFO[] ldallPitInfo = null;
    SASLogicalDriveOperationsAllowed allowedOps;
    private String[] mnemonics;
    private char mnemonicChar = (char)32;
    private OperationDetails tempOPD = null;
    private int m_numHoles = 0;
    private int m_totalHoleSize = 0;
    private boolean m_isLDCached = false;
    private static String[][] STRIPE_SIZE_ARR = new String[][]{{"LD_STRIPE_SIZE_512", "512 Byte"}, {"LD_STRIPE_SIZE_1K", "1 KB"}, {"LD_STRIPE_SIZE_2K", "2 KB"}, {"LD_STRIPE_SIZE_4K", "4 KB"}, {"LD_STRIPE_SIZE_8K", "8 KB"}, {"LD_STRIPE_SIZE_16K", "16 KB"}, {"LD_STRIPE_SIZE_32K", "32 KB"}, {"LD_STRIPE_SIZE_64K", "64 KB"}, {"LD_STRIPE_SIZE_128K", "128 KB"}, {"LD_STRIPE_SIZE_256K", "256 KB"}, {"LD_STRIPE_SIZE_512K", "512 KB"}, {"LD_STRIPE_SIZE_1M", "1 MB"}, {"LD_STRIPE_SIZE_2M", "2 MB"}, {"LD_STRIPE_SIZE_4M", "4 MB"}};
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Virtual Drive");
    private boolean isWarhawk;

    public LogicalDriveHelper(SASLogicalDrive sASLogicalDrive, GUIHelperInterface gUIHelperInterface) {
        SASAdapter sASAdapter;
        this.ldrive = sASLogicalDrive;
        this.ldInfo = this.ldrive.getInformation();
        this.ldProp = this.ldInfo.getldConfig().getproperties();
        this.ldParam = this.ldInfo.getldConfig().getparams();
        if (this.ldInfo.getldConfig().getparams().getSnapshotEnabled() == 1) {
            this.ldallPitInfo = sASLogicalDrive.getSnapshotInformation().getLdPitInfo();
        }
        this.parent = gUIHelperInterface;
        this.m_isLDCached = this.getLdCached();
        sASLogicalDrive.addObserver(this);
        this.isWarhawk = false;
        if (this.parent.getDeviceObject() instanceof SASAdapter && (sASAdapter = (SASAdapter)this.parent.getDeviceObject()).isWarhawk()) {
            this.isWarhawk = true;
        }
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.ldrive;
    }

    public short getBlockSize() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPDListInLd();
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            return physicalDriveHelperArray[0].getUserDataBlockSize();
        }
        return 512;
    }

    @Override
    public String getText() {
        String string = this.ldrive.getName();
        if (this.ldInfo.getsnapshotRepository() == 1) {
            if (string.length() > 0 && Resource.isLocaleSupportedForOEM()) {
                return Resource.getString("REPOSITORY_VIRTUAL_DRIVE_TEXT", "Snapshot Repository") + ": " + this.ldrive.getID() + ", " + string + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState();
            }
            return Resource.getString("REPOSITORY_VIRTUAL_DRIVE_TEXT", "Snapshot Repository") + ": " + this.ldrive.getID() + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState();
        }
        if (this.ldParam.getisSSCD() != 0) {
            if (this.isCSACacheCade()) {
                return Resource.getString("CSA_CACHECADE_VIRTUAL_DRIVE_TEXT", "CSA CacheCade Virtual Drive") + ": " + this.ldrive.getID() + ", " + string + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize()) + ", " + this.getState();
            }
            if (string.length() > 0 && Resource.isLocaleSupportedForOEM()) {
                return Resource.getString("SSCD_TEXT", "CacheCade\u2122 Virtual Drive") + ": " + this.ldrive.getID() + ", " + string + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState();
            }
            return Resource.getString("SSCD_TEXT", "CacheCade\u2122 Virtual Drive") + ": " + this.ldrive.getID() + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState();
        }
        if (this.isBlockedDueToSSCDOffline() || this.isBlockedDueToPeerUnavailability()) {
            if (string.length() > 0 && Resource.isLocaleSupportedForOEM()) {
                return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + this.ldrive.getID() + ", " + string + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState() + " - " + Resource.getString("ACCESS_BLOCKED_TEXT", "Access Blocked");
            }
            return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + this.ldrive.getID() + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState() + " - " + Resource.getString("ACCESS_BLOCKED_TEXT", "Access Blocked");
        }
        if (string.length() > 0 && Resource.isLocaleSupportedForOEM()) {
            return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + this.ldrive.getID() + ", " + string + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState();
        }
        return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + this.ldrive.getID() + ", " + KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize()) + ", " + this.getState();
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return "<html>" + this.getText() + "</html>";
    }

    public MR_LD_PARAMETERS getLdParameters() {
        return this.ldParam;
    }

    public String getState() {
        char c = this.ldParam.getstate();
        if (c == '\u0002') {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (c == '\u0000') {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (c == '\u0001') {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (c == '\u0003') {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public ImageIcon getIcon() {
        ImageIcon imageIcon = null;
        imageIcon = this.ldInfo.getsnapshotRepository() == 1 ? this.getImageIcon(Resource.getString("VOLUME_REPOSITORY_IMAGE", "volume_snapshot.png")) : (this.isSSCD() ? this.getImageIcon(Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png")) : (this.isBlockedDueToSSCDOffline() || this.isBlockedDueToPeerUnavailability() ? new DoubleIcons(this.getImageIcon(Resource.getString("VOLUME_IMAGE", "volume.png")), this.getImageIcon(Resource.getString("NEEDS_ATTENTION_ICON", "NeedAtten.png")), 1) : this.getImageIcon(Resource.getString("VOLUME_IMAGE", "volume.png"))));
        if (this.isVDinTransitioningState()) {
            return new DoubleIcons(imageIcon, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("POWER_STATE_TRANSITIONING_IMAGE", "transitioning_icon.gif")))), 1);
        }
        if (this.ldInfo.getPowerState() != 0) {
            return new DoubleIcons(imageIcon, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("POWER_SAVE_IMAGE", "psave.png")))), 1);
        }
        return imageIcon;
    }

    @Override
    public ArrayList<OperationDetails> getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        try {
            this.allowedOps = this.ldrive.getAllAllowedOperations();
        }
        catch (Exception exception) {
            System.out.println("Allowed Operation is not available !");
            exception.printStackTrace();
            return arrayList;
        }
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                this.addOperation(arrayList, operationDetails);
            } else if (operationDetails.getOpcode() == 1162 || operationDetails.getOpcode() == 1163 || operationDetails.getOpcode() == 1165) {
                operationDetails.setDummyCmd(true);
                this.addOperation(arrayList, operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addOperation(ArrayList arrayList, OperationDetails operationDetails) {
        if (operationDetails.getOpcode() == 0x30E0000) {
            if (this.ldrive.getSupportLDBBM() != 1 || this.badBlocksExistMethod() != 1) return;
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            return;
        } else if (operationDetails.getDescription() == Resource.getString("LDRIVE_OPERATION_FORMAT_VD_DESC", "Format Virtual Drive")) {
            SASAdapter sASAdapter = (SASAdapter)this.ldrive.parent();
            if (!sASAdapter.isWarhawk()) {
                return;
            }
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            return;
        } else if (operationDetails.getOpcode() == 12) {
            if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() != 4) return;
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            return;
        } else if (operationDetails.getOpcode() == 2 && operationDetails.getDescription() == Resource.getString("TEXT_RENAME_VD", "Rename Virtual Drive")) {
            if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 4) {
                return;
            }
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            return;
        } else if (operationDetails.getOpcode() == 1162) {
            if (!((AdapterHelper)this.parent).getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation() || !this.allowedOps.isSSCCacheable() || this.isLdCached()) {
                return;
            }
            arrayList.add(operationDetails);
            return;
        } else if (operationDetails.getOpcode() == 1163) {
            if (!(((AdapterHelper)this.parent).getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation() && this.allowedOps.isdisassociatedSSC() && this.isLdCached())) {
                return;
            }
            arrayList.add(operationDetails);
            return;
        } else if (operationDetails.getOpcode() == 1165) {
            if (!this.isBlockedDueToSSCDOffline() && !this.isBlockedDueToPeerUnavailability()) return;
            arrayList.add(operationDetails);
            return;
        } else {
            if (operationDetails.getOpcode() == 2 && this.ldParam.getisSSCD() == 2) {
                return;
            }
            if (operationDetails.getOpcode() == 3 && this.getArrays()[0].isSlicedForBootVolume()) {
                return;
            }
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
        }
    }

    public void checkAndAddSystemAllowedOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        try {
            if (this.allowedOps.isOperationAllowed((short)operationDetails.getOpcode())) {
                arrayList.add(operationDetails);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isOperationAllowed(int n) {
        StringBuffer stringBuffer;
        String string;
        SASAdapter sASAdapter = (SASAdapter)this.parent.getDeviceObject();
        if (sASAdapter.isWarhawk() && n == 1) {
            string = null;
            stringBuffer = null;
            stringBuffer = new StringBuffer(Resource.getString("MSG_FORMAT_TEXT1", "<html>You have chosen to format Virtual Disk"));
            stringBuffer.append(" " + this.ldrive.getID() + ".  ");
            stringBuffer.append(Resource.getString("MSG_DELETELD_TEXT2", "All data<br> on the virtual disk will be lost"));
            if (this.ldParam.getPinnedCacheState() != 0) {
                stringBuffer.append(" " + Resource.getString("MSG_DELETELD_TEXT3", "and the preserved<br> cache for this virtual disk will be discarded"));
            }
            stringBuffer.append(".<br><br>" + Resource.getString("MSG_FORMAT_TEXT2", "Are you sure you want to format Virtual Disk") + " " + this.ldrive.getID() + "?</html>");
            string = Resource.getString("MSG_FORMAT_CONFIRM_TITLE", "Confirm Format Virtual Disk");
            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, stringBuffer.toString())) {
                return false;
            }
            if (!this.isSSCD() && this.isOSDrive()) {
                new CustomMsgBox(Resource.getString("MSG_OS_LD_FORMAT", "This is an OS drive. This virtual drive cannot be formated."));
                return false;
            }
        }
        if (n == 3) {
            string = null;
            stringBuffer = null;
            if (this.getArrays()[0].isSlicedForBootVolume()) {
                return false;
            }
            if (this.ldParam.getSnapshotEnabled() == 1) {
                stringBuffer = new StringBuffer(Resource.getString("MSG_SNAP_ENABLED_LD", "<html>You cannot delete") + " ");
                stringBuffer.append(this.ldrive.getName() + " ");
                stringBuffer.append(Resource.getString("MSG_SNAP_ENABLED_CONT", "because MegaRAID Recovery is currently<br>"));
                new CustomMsgBox(stringBuffer.toString());
                return false;
            }
            if (this.isCSACacheCade()) {
                stringBuffer = new StringBuffer(Resource.getString("MSG_DELETE_CSA_TEXT1", "<html>You have chosen to delete Nytro\u2122 Cache Drive"));
                stringBuffer.append(" ").append(this.ldrive.getID()).append(".  ");
                stringBuffer.append(Resource.getString("MSG_DELETE_CSA_TEXT2", " All data<br> on the Nytro\u2122 Cache Drive will be lost"));
                if (this.ldParam.getPinnedCacheState() != 0) {
                    stringBuffer.append(" ").append(Resource.getString("MSG_DELETE_CSA_TEXT3", "and the preserved<br> cache for this Nytro\u2122 Cache Drive will be discarded"));
                }
                stringBuffer.append(".<br><br>");
                stringBuffer.append(Resource.getString("MSG_DELETE_CSA_TEXT4", "Are you sure you want to delete Nytro\u2122 Cache Drive"));
                stringBuffer.append(" ").append(this.ldrive.getID()).append("?</html>");
                string = Resource.getString("MSG_DELETE_CSA_CONFIRM_TITLE", "Delete Nytro\u2122 Cache Drive - Confirmation");
            } else if (this.isSSCD()) {
                stringBuffer = new StringBuffer(Resource.getString("MSG_DELETESSCD_TEXT1", "<html>You have chosen to delete CacheCade\u2122 Virtual Drive"));
                stringBuffer.append(" " + this.ldrive.getID() + ".  ");
                stringBuffer.append(Resource.getString("MSG_DELETESSCD_TEXT2", "All data<br> on the CacheCade\u2122 Virtual Drive will be lost"));
                if (this.ldParam.getPinnedCacheState() != 0) {
                    stringBuffer.append(" " + Resource.getString("MSG_DELETESSCD_TEXT3", "and the preserved<br> cache for this CacheCade\u2122 Virtual Drive will be discarded"));
                }
                stringBuffer.append(".<br><br>" + Resource.getString("MSG_DELETESSCD_TEXT4", "Are you sure you want to delete CacheCade\u2122 Virtual Drive") + " " + this.ldrive.getID() + "?</html>");
                string = Resource.getString("MSG_DELETESSCD_CONFIRM_TITLE", "Confirm Delete CacheCade\u2122 Virtual Drive");
            } else {
                stringBuffer = new StringBuffer(Resource.getString("MSG_DELETELD_TEXT1", "<html>You have chosen to delete Virtual Disk"));
                stringBuffer.append(" " + this.ldrive.getID() + ".  ");
                stringBuffer.append(Resource.getString("MSG_DELETELD_TEXT2", "All data<br> on the virtual disk will be lost"));
                if (this.ldParam.getPinnedCacheState() != 0) {
                    stringBuffer.append(" " + Resource.getString("MSG_DELETELD_TEXT3", "and the preserved<br> cache for this virtual disk will be discarded"));
                }
                stringBuffer.append(".<br><br>" + Resource.getString("MSG_DELETELD_TEXT4", "Are you sure you want to delete Virtual Disk") + " " + this.ldrive.getID() + "?</html>");
                string = Resource.getString("MSG_DELETELD_CONFIRM_TITLE", "Confirm Delete Virtual Disk");
            }
            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, stringBuffer.toString())) {
                return false;
            }
            if (!this.isSSCD() && this.isOSDrive()) {
                new CustomMsgBox(Resource.getString("MSG_OS_LD", "This is an OS drive. This virtual drive cannot be deleted."));
                return false;
            }
        } else if (n == 2) {
            if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_SETLDPROP_CONFIRM", "Warning : This will set Virtual Disk properties ! Are you sure ?"))) {
                return false;
            }
        } else if (n == 9) {
            if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_LDINIT_DATA_LOST", "Initialization will result in data loss on the selected Virtual Disk(s). Proceed ?"))) {
                return false;
            }
            if (this.isOSDrive()) {
                new CustomMsgBox(Resource.getString("MSG_OS_LD_INIT", "This is an OS drive. This virtual drive cannot be initialized."));
                return false;
            }
        } else if (!(n != 12 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() != 4 || CustomMsgBox.confirmWithCheck(Resource.getString("MSG_VOLUME_EXPANSION_WARNING", "<html>It is advisable to backup the data before you proceed. <br>This operation cannot be stopped once started. <br><br>Do you want to continue?</html>")))) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void issueOperation(OperationDetails operationDetails) {
        try {
            VivaldiStartupDialog.mainScreen.busy();
            if (this.ldParam.getPinnedCacheState() != 0 && (operationDetails.getOpcode() == 6 || operationDetails.getOpcode() == 9 || operationDetails.getOpcode() == 12)) {
                new PreservedCachePresent();
            } else if (operationDetails.getOpcode() == 6) {
                LogicalDriveHelper logicalDriveHelper = this;
                if (((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getldConfig().getparams().getISConsistent() == '\u0000' && ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                    if (!CustomMsgBox.confirm(new JFrame(), Resource.getString("MSG_LDCC_NOT_INIT", "<html>The virtual disk has not been initialized.  Running a consistency check may result in<br> inconsistent messages in the log.  Are you sure you want to continue?<html>"))) {
                        return;
                    }
                    this.ldrive.fireOperation(operationDetails);
                } else {
                    this.ldrive.fireOperation(operationDetails);
                }
            } else if (operationDetails.getOpcode() == 12 && (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 4)) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.getDeviceObject();
                MR_RECON mR_RECON = new MR_RECON();
                mR_RECON.setldRef(sASLogicalDrive.getInformation().getldConfig().getproperties().getldRef());
                mR_RECON.setoperation((byte)0);
                operationDetails.setParameter(mR_RECON);
                this.ldrive.fireOperation(operationDetails);
            } else if (operationDetails.getOpcode() == 3 && !this.isSSCD() && this.ldrive.getAllAllowedOperations().isForceDeleteLD()) {
                this.ldrive.deleteLD(operationDetails.isForceClear() ? 1 : 0);
            } else {
                this.ldrive.fireOperation(operationDetails);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            CustomMsgBox.errorMsg(vKOperationFailedException);
            vKOperationFailedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            VivaldiStartupDialog.mainScreen.ready();
        }
    }

    @Override
    public ProgressInfo getProgressInfo() {
        MR_LD_PROGRESS mR_LD_PROGRESS = this.ldInfo.getprogInfo();
        ProgressInfo progressInfo = new ProgressInfo();
        SASAdapter sASAdapter = (SASAdapter)this.parent.getDeviceObject();
        int n = sASAdapter.getInformation().getadapterOperationsEx_MR_CTRL_INFO().getSupportPointInTimeProgress();
        if (mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().getbgi()) {
            progressInfo.opCode = 9;
            progressInfo.value = mR_LD_PROGRESS.getbgi().getprogress();
            progressInfo.text = Resource.getString("OPERATION_BGI_TEXT", "Background Initialize");
            progressInfo.abortOpCode = 7;
            if (n == 1) {
                float f = mR_LD_PROGRESS.getbgi().getprogress();
                int n2 = mR_LD_PROGRESS.getbgi().getelapsedSecs();
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getbgi().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n2;
            } else {
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getbgi().getelapsedSecs();
                progressInfo.estimatedSecs = mR_LD_PROGRESS.getbgi().getEstimatedSecs();
            }
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().getcc()) {
            progressInfo.opCode = 6;
            progressInfo.value = mR_LD_PROGRESS.getcc().getprogress();
            progressInfo.text = Resource.getString("OPERATION_CC_TEXT", "Check Consistency");
            progressInfo.abortOpCode = 7;
            if (n == 1) {
                float f = mR_LD_PROGRESS.getcc().getprogress();
                int n3 = mR_LD_PROGRESS.getcc().getelapsedSecs();
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getcc().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n3;
            } else {
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getcc().getelapsedSecs();
                progressInfo.estimatedSecs = mR_LD_PROGRESS.getcc().getEstimatedSecs();
            }
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().getrecon()) {
            progressInfo.opCode = 12;
            progressInfo.value = mR_LD_PROGRESS.getrecon().getprogress();
            progressInfo.text = Resource.getString("OPERATION_RECON_TEXT", "Reconstruction");
            progressInfo.abortOpCode = -1;
            if (n == 1) {
                float f = mR_LD_PROGRESS.getrecon().getprogress();
                int n4 = mR_LD_PROGRESS.getrecon().getelapsedSecs();
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getrecon().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n4;
            } else {
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getrecon().getelapsedSecs();
                progressInfo.estimatedSecs = mR_LD_PROGRESS.getrecon().getEstimatedSecs();
            }
            progressInfo.text = ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 4 ? Resource.getString("OPERATION_OCE_TEXT", "Capacity Expansion.") : Resource.getString("OPERATION_RECON_TEXT", "Reconstruction");
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().getfgi()) {
            progressInfo.opCode = 9;
            progressInfo.value = mR_LD_PROGRESS.getfgi().getprogress();
            progressInfo.text = Resource.getString("OPERATION_FGI_TEXT", "Foreground Initialize");
            progressInfo.abortOpCode = 10;
            if (n == 1) {
                float f = mR_LD_PROGRESS.getfgi().getprogress();
                int n5 = mR_LD_PROGRESS.getfgi().getelapsedSecs();
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getfgi().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n5;
            } else {
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getfgi().getelapsedSecs();
                progressInfo.estimatedSecs = mR_LD_PROGRESS.getfgi().getEstimatedSecs();
            }
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().geterase()) {
            progressInfo.opCode = 0x3130100;
            progressInfo.value = mR_LD_PROGRESS.getErase().getprogress();
            progressInfo.text = "Virtual Drive Erase";
            progressInfo.abortOpCode = 51577344;
            if (n == 1) {
                float f = mR_LD_PROGRESS.getErase().getprogress();
                int n6 = mR_LD_PROGRESS.getErase().getelapsedSecs();
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getErase().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n6;
            } else {
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getErase().getelapsedSecs();
                progressInfo.estimatedSecs = mR_LD_PROGRESS.getErase().getEstimatedSecs();
            }
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getpause_MR_LD_PROGRESS1().getcc()) {
            progressInfo.opCode = 51511808;
            progressInfo.text = Resource.getString("CC_PAUSED", "Check Consistency has been suspended");
            progressInfo.abortOpCode = 7;
            progressInfo.state = mR_LD_PROGRESS.getpause_MR_LD_PROGRESS1().getcc();
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getpause_MR_LD_PROGRESS1().getbgi()) {
            progressInfo.opCode = 51511808;
            progressInfo.text = Resource.getString("BGI_PAUSED", "Background Initialization has been suspended");
            progressInfo.abortOpCode = 7;
            progressInfo.state = mR_LD_PROGRESS.getpause_MR_LD_PROGRESS1().getbgi();
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getpause_MR_LD_PROGRESS1().getrecon()) {
            progressInfo.opCode = 51511552;
            progressInfo.text = Resource.getString("RECONSTRUCTION_PAUSED", "Reconstruction has been suspended");
            progressInfo.abortOpCode = -1;
            progressInfo.state = mR_LD_PROGRESS.getpause_MR_LD_PROGRESS1().getrecon();
            return progressInfo;
        }
        if (mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().getdisassociate()) {
            progressInfo.value = mR_LD_PROGRESS.getdisassociate().getprogress();
            progressInfo.text = Resource.getString("OPERATION_DISASSOCIATE_TEXT", "Removing associations");
            progressInfo.abortOpCode = -1;
            if (n == 1) {
                float f = mR_LD_PROGRESS.getdisassociate().getprogress();
                int n7 = mR_LD_PROGRESS.getdisassociate().getelapsedSecs();
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getdisassociate().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n7;
            } else {
                progressInfo.elapsedSecs = mR_LD_PROGRESS.getdisassociate().getelapsedSecs();
                progressInfo.estimatedSecs = mR_LD_PROGRESS.getdisassociate().getEstimatedSecs();
            }
            return progressInfo;
        }
        return null;
    }

    public String getRAIDLevel() {
        char c = this.ldParam.getnumDrives();
        SASAdapter sASAdapter = (SASAdapter)this.parent.getDeviceObject();
        if (sASAdapter.getAdapterType() == 3 || sASAdapter.getAdapterType() == 4) {
            if (this.ldParam.getPRL() == 17) {
                try {
                    MR_MFC_DEFAULTS mR_MFC_DEFAULTS = sASAdapter.getMFCDefaults();
                    if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1 && c % 2 == 0) {
                        return "10";
                    }
                    return "1E";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "1";
                }
            }
            return this.ldParam.getPRL() + "";
        }
        raidLevels_MR_CTRL_INFO raidLevels_MR_CTRL_INFO2 = sASAdapter.getInformation().getraidLevels_MR_CTRL_INFO();
        if (this.ldParam.getPRL() == 1 && c > '\u0002') {
            return "1E";
        }
        if (this.ldParam.getPRL() == 0 && this.ldrive.getArrayCount() > 1) {
            return this.ldParam.getPRL() + "0";
        }
        if (this.ldParam.getPRL() == 0) {
            return this.ldParam.getPRL() + "";
        }
        if (raidLevels_MR_CTRL_INFO2.getSRL_03() != 0 && this.ldrive.getArrayCount() > 1) {
            if (this.ldParam.getPRL() == 17) {
                return "10";
            }
            return this.ldParam.getPRL() + "0";
        }
        if (raidLevels_MR_CTRL_INFO2.getSRL_03() == 0 && this.ldrive.getArrayCount() > 1) {
            if (this.ldParam.getPRL() == 17) {
                return "10";
            }
            return this.ldParam.getPRL() + "0";
        }
        if (this.ldParam.getSRL() == 1) {
            return this.ldParam.getPRL() + "1";
        }
        if (this.ldParam.getPRL() == 17) {
            try {
                MR_MFC_DEFAULTS mR_MFC_DEFAULTS = sASAdapter.getMFCDefaults();
                if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1) {
                    return "10";
                }
                return "1";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "1";
            }
        }
        return this.ldParam.getPRL() + "";
    }

    public String getRaidLevelString() {
        if (this.ldParam.getisSSCD() == 2) {
            return Resource.getString("RAID_LEVEL_EC", "R1-EC");
        }
        return Resource.getString("RAID_LEVEL_TEXT", "RAID") + " " + this.getRAIDLevel();
    }

    public String getDataSpace(String string) {
        String string2 = null;
        long l = 0L;
        long l2 = this.ldInfo.getsize();
        char c = this.ldParam.getnumDrives();
        char c2 = this.ldParam.getspanDepth();
        float f = this.getminDriveSize();
        switch (Integer.parseInt(string)) {
            case 1: {
                l = l2 / 2L;
                string2 = Long.toString(l);
                break;
            }
            case 5: {
                l = (long)(c - '\u0001') * l2 / (long)c;
                string2 = Long.toString(l);
                break;
            }
            case 6: {
                l = (long)(c - 2) * l2 / (long)c;
                string2 = Long.toString(l);
                break;
            }
            case 50: {
                l = (long)((c - '\u0001') / c * c2) * l2;
                string2 = Long.toString(l);
                break;
            }
            case 60: {
                l = (long)((c - 2) / c * c2) * l2;
                string2 = Long.toString(l);
                break;
            }
            case 10: {
                l = (long)(c2 / 2) * l2;
                string2 = Long.toString(l);
            }
        }
        if (string == "1E") {
            l = l2 / 2L;
            string2 = Long.toString(l);
        }
        String string3 = KernelConstants.getConvertedSize(l, this.getBlockSize());
        return string3;
    }

    public String getParityinformation(String string) {
        String string2 = null;
        char c = this.ldParam.getnumDrives();
        char c2 = this.ldParam.getspanDepth();
        long l = 0L;
        long l2 = this.ldInfo.getsize();
        float f = this.getminDriveSize();
        System.out.println("SIZE of minimum PD's in GB is::" + f);
        if (string == "1E") {
            l = l2;
            string2 = Long.toString(l);
        } else {
            switch (Integer.parseInt(string)) {
                case 1: {
                    l = l2;
                    string2 = Long.toString(l);
                    break;
                }
                case 5: {
                    l = l2 / (long)(c - '\u0001');
                    string2 = Long.toString(l);
                    break;
                }
                case 6: {
                    l = l2 / (long)(c - 2) * 2L;
                    string2 = Long.toString(l);
                    break;
                }
                case 50: {
                    l = l2 / (long)c2 / (long)(c - '\u0001') * (long)c2;
                    string2 = Long.toString(l);
                    break;
                }
                case 60: {
                    l = l2 / (long)(c - 2) * (long)c2;
                    string2 = Long.toString(l);
                    break;
                }
                case 10: {
                    l = l2;
                    string2 = Long.toString(l);
                }
            }
        }
        string2 = KernelConstants.getConvertedSize(l, this.getBlockSize());
        return string2;
    }

    public float getminDriveSize() {
        int n;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPDListInLd();
        float[] fArray = new float[physicalDriveHelperArray.length];
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < physicalDriveHelperArray.length; ++n) {
            long l = ((SASPhysicalDrive)physicalDriveHelperArray[n].getDeviceObject()).getInformation().getcoercedSize();
            float f3 = (float)l / 2097152.0f;
            String string = String.valueOf(l);
            String string2 = KernelConstants.getConvertedSize(l, this.getBlockSize());
            fArray[n] = f3;
            System.out.println("SIZE of PD's are::" + f3);
        }
        f2 = fArray[0];
        for (n = 0; n < fArray.length; ++n) {
            if (!(fArray[n] < f2)) continue;
            f2 = fArray[n];
        }
        System.out.println("SIZE of minimum PD's in GB is::" + f2);
        return f2;
    }

    @Override
    public ArrayList getPropertyList() {
        AdapterHelper adapterHelper;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PropertyInfo propertyInfo;
        PropertyInfo propertyInfo2;
        PhysicalDriveHelper[] physicalDriveHelperArray;
        Object object5;
        String string;
        PropertyInfo propertyInfo3;
        Object object6;
        if (this.isCSACacheCade()) {
            return this.getCSACacheCadePropList();
        }
        if (this.isSSCD()) {
            return this.getSSCDPropertyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        arrayList.add(propertyInfo4);
        if (!this.isWarhawk) {
            object6 = new PropertyInfo();
            ((PropertyInfo)object6).name = Resource.getString("PROPERTY_RAIDLEVEL_TEXT", "RAID Level");
            ((PropertyInfo)object6).value = this.getRAIDLevel();
            ((PropertyInfo)object6).description = Resource.getString("PROPERTY_RAIDLEVEL_TEXT", "RAID Level");
            arrayList.add(object6);
        }
        if (this.ldrive.getName().length() > 0) {
            object6 = new PropertyInfo();
            ((PropertyInfo)object6).name = Resource.getString("PROPERTY_LDRIVENAME_TEXT", "Name");
            ((PropertyInfo)object6).value = this.ldrive.getName();
            ((PropertyInfo)object6).description = Resource.getString("PROPERTY_LDRIVENAME_TEXT", "Name");
            arrayList.add(object6);
        }
        if (((SASAdapter)(object6 = (SASAdapter)this.parent.getDeviceObject())).getInformation().getmaxHANodes() > 1) {
            propertyInfo3 = new PropertyInfo();
            propertyInfo3.name = Resource.getString("PROPERTY_GUID_TEXT", "GUID");
            string = "";
            if (this.ldrive.getGuiId() != null) {
                object5 = this.ldrive.getGuiId();
                if (object5 != null) {
                    for (int i = 0; i < ((byte[])object5).length; ++i) {
                        string = string + NetworkToJavaConverter.byteToHex(object5[i]);
                    }
                }
                propertyInfo3.value = string;
                propertyInfo3.description = Resource.getString("PROPERTY_GUID_TEXT", "GUID");
                arrayList.add(propertyInfo3);
                physicalDriveHelperArray = new PropertyInfo();
                physicalDriveHelperArray.name = Resource.getString("PROPERTY_EXPOSETOOS_TEXT", "Host Access Policy");
                String string2 = Resource.getString("PROPERTY_EXCLUSIVE_TEXT", "Exclusive");
                string2 = this.ldProp.getnonShared() != 1 ? Resource.getString("PROPERTY_SHARED_TEXT", "Shared") : (this.ldInfo.getPeerHasExclusiveAccess() == 1 ? Resource.getString("PROPERTY_EXCLUSIVE_PEER_TEXT", "Exclusive to Peer Controller") : Resource.getString("PROPERTY_EXCLUSIVE_TEXT", "Exclusive"));
                physicalDriveHelperArray.value = string2;
                physicalDriveHelperArray.description = Resource.getString("PROPERTY_EXPOSETOOS_TEXT", "Host Access Policy");
                arrayList.add(physicalDriveHelperArray);
            }
        }
        propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_LDRIVESIZE_TEXT", "Size");
        propertyInfo3.value = KernelConstants.getConvertedSize(this.ldInfo.getsize(), this.getBlockSize());
        propertyInfo3.description = Resource.getString("PROPERTY_LDRIVESIZE_TEXT", "Size");
        arrayList.add(propertyInfo3);
        string = this.getRAIDLevel();
        if (!string.equals("0")) {
            object5 = new PropertyInfo();
            System.out.println("RAID VERSION:" + string);
            object5.name = string.equals("1") || string.equals("10") || string.equals("1E") ? Resource.getString("PROPERTY_LDRIVE_MIRROR_SPACE_TEXT", "Mirror Data Size") : Resource.getString("PROPERTY_LDRIVE_PARITY_SPACE_TEXT", "Parity Size");
            object5.value = this.getParityinformation(string);
            object5.description = string.equals("1") || string.equals("10") || string.equals("1E") ? Resource.getString("PROPERTY_LDRIVE_MIRROR_SPACE_TEXT", "Mirror Data Size") : Resource.getString("PROPERTY_LDRIVE_PARITY_SPACE_TEXT", "Parity Size");
            arrayList.add(object5);
        }
        object5 = new PropertyInfo();
        object5.name = Resource.getString("PROPERTY_STRIPESIZE_TEXT", "Stripe Size");
        physicalDriveHelperArray = this.getPDListInLd();
        char c = this.ldParam.getstripeSize();
        short s = physicalDriveHelperArray[0].getUserDataBlockSize();
        object5.value = LogicalDriveHelper.getFormattedStripeSize((byte)c);
        object5.description = Resource.getString("PROPERTY_STRIPESIZE_TEXT", "Stripe Size");
        arrayList.add(object5);
        PropertyInfo propertyInfo5 = new PropertyInfo();
        propertyInfo5.name = Resource.getString("PROPERTY_STATE_TEXT", "State");
        propertyInfo5.value = this.getState();
        propertyInfo5.description = Resource.getString("PROPERTY_STATE_TEXT", "State");
        arrayList.add(propertyInfo5);
        boolean bl = this.isControllerIntegratedRaidType();
        if (this.ldrive.getSupportLDBBM() == 1) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.description = propertyInfo2.name = Resource.getString("PROPERTY_BAD_BLOCKS_EXIST_METHOD_TEXT", "Bad Blocks");
            propertyInfo2.value = this.badBlocksExistMethod() == 1 ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
            arrayList.add(propertyInfo2);
        }
        propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROP_IOC", "<html><b>IO and Cache Policies:</b></html>");
        if (!this.isWarhawk) {
            arrayList.add(propertyInfo2);
        }
        if (bl && !this.isWarhawk) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROPERTY_ACCESSPOLICY_TEXT", "Access Policy");
            propertyInfo.value = this.getAccessPolicyString(this.ldProp.getaccessPolicy());
            propertyInfo.description = Resource.getString("PROPERTY_ACCESSPOLICY_TEXT", "Access Policy");
            arrayList.add(propertyInfo);
        }
        if (!this.isWarhawk) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROPERTY_DISKCACHEPOLICY_TEXT", "Disk Cache Policy");
            byte by = ((SASAdapter)this.ldrive.parent()).getAdapterType();
            if (by == 2) {
                if (this.isVDCompriseOfSASDrives()) {
                    switch (this.ldProp.getdiskCachePolicy()) {
                        case '\u0001': {
                            propertyInfo.value = Resource.getString("PD_CACHE_ENABLE", "Enable");
                            break;
                        }
                        case '\u0002': {
                            propertyInfo.value = Resource.getString("PD_CACHE_DISABLE", "Disable");
                            break;
                        }
                        default: {
                            propertyInfo.value = "";
                            break;
                        }
                    }
                } else if (this.isVDCompriseOfSATADrives()) {
                    switch (this.ldProp.getdiskCachePolicy()) {
                        case '\u0001': {
                            propertyInfo.value = Resource.getString("PD_CACHE_ENABLE", "Enable");
                            break;
                        }
                        case '\u0002': {
                            propertyInfo.value = Resource.getString("PD_CACHE_DISABLE", "Disable");
                            break;
                        }
                        default: {
                            propertyInfo.value = "";
                            break;
                        }
                    }
                }
            } else {
                switch (this.ldProp.getdiskCachePolicy()) {
                    case '\u0000': {
                        propertyInfo.value = Resource.getString("PD_CACHE_UNCHANGED", "Unchanged");
                        break;
                    }
                    case '\u0001': {
                        propertyInfo.value = Resource.getString("PD_CACHE_ENABLE", "Enable");
                        break;
                    }
                    case '\u0002': {
                        propertyInfo.value = Resource.getString("PD_CACHE_DISABLE", "Disable");
                        break;
                    }
                    default: {
                        propertyInfo.value = "";
                    }
                }
                if (this.isVDCompriseOfSSDDrives(this) && ((SASAdapter)this.parent.getDeviceObject()).getInformation().getadapterOperationsEx_MR_CTRL_INFO().getBlockSSDWriteCacheChange() == 1) {
                    propertyInfo.value = Resource.getString("PD_CACHE_UNCHANGED", "Unchanged");
                }
            }
            propertyInfo.description = propertyInfo.name;
            arrayList.add(propertyInfo);
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_READPOLICY_TEXT", "Read Policy");
            switch (this.ldrive.getReadPolicy()) {
                case 12: {
                    ((PropertyInfo)object4).value = Resource.getString("READ_AHEAD_ALWAYS", "Read Ahead Always");
                    break;
                }
                case 4: {
                    ((PropertyInfo)object4).value = Resource.getString("READ_AHEAD_ALWAYS", "Read Ahead Always");
                    break;
                }
                default: {
                    ((PropertyInfo)object4).value = Resource.getString("READ_AHEAD_NONE", "No Read Ahead");
                }
            }
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_READPOLICY_TEXT", "Read Policy");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = Resource.getString("PROPERTY_IOPOLICY_TEXT_2", "IO Policy");
            switch (this.ldrive.getIOCachePolicy()) {
                case 96: {
                    ((PropertyInfo)object3).value = Resource.getString("IOPOLICY_CACHED", "Cached IO");
                    break;
                }
                case 0: {
                    ((PropertyInfo)object3).value = Resource.getString("IOPOLICY_DIRECT", "Direct IO");
                    break;
                }
                default: {
                    ((PropertyInfo)object3).value = "";
                }
            }
            ((PropertyInfo)object3).description = Resource.getString("PROPERTY_IOPOLICY_TEXT_2", "IO Policy");
            arrayList.add(object3);
        }
        propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROP_WPOLICY", "<html><b>Write Policy:</b></html>");
        if (!this.isWarhawk) {
            arrayList.add(propertyInfo);
        }
        if (!bl) {
            PropertyInfo propertyInfo6 = new PropertyInfo();
            propertyInfo6.name = Resource.getString("PROPERTY_CURWRITEPOLICY_TEXT", "Current Write Policy");
            switch (this.ldrive.getWritePolicy()) {
                case 2: {
                    propertyInfo6.value = Resource.getString("WRITEPOLICY_WRITE_ADAPTIVE", "Write Adaptive");
                    break;
                }
                case 1: {
                    propertyInfo6.value = Resource.getString("WRITEPOLICY_WRITE_BACK", "Write Back");
                    break;
                }
                case 0: {
                    propertyInfo6.value = Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through");
                    break;
                }
                case 16: {
                    propertyInfo6.value = Resource.getString("WRITEPOLICY_WRITE_BACK", "Write Back");
                    break;
                }
                default: {
                    propertyInfo6.value = "";
                }
            }
            propertyInfo6.description = Resource.getString("PROPERTY_CURWRITEPOLICY_TEXT", "Current Write Policy");
            arrayList.add(propertyInfo6);
        }
        if (!this.isWarhawk) {
            PropertyInfo propertyInfo7 = new PropertyInfo();
            propertyInfo7.name = bl ? Resource.getString("PROPERTY_WRITEPOLICY_TEXT", "Write Policy") : Resource.getString("PROPERTY_DEFWRITEPOLICY_TEXT", "Default Write Policy");
            switch (this.ldrive.getDefaultWritePolicy()) {
                case 2: {
                    propertyInfo7.value = Resource.getString("WRITEPOLICY_WRITE_ADAPTIVE", "Write Adaptive");
                    break;
                }
                case 1: {
                    propertyInfo7.value = Resource.getString("WRITEPOLICY_WRITE_BACK_WITH_BBU", "Write Back with BBU");
                    break;
                }
                case 0: {
                    propertyInfo7.value = Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through");
                    break;
                }
                case 17: {
                    propertyInfo7.value = Resource.getString("WRITEPOLICY_ALWAYS_WRITE_BACK", "Always Write Back");
                    break;
                }
                default: {
                    propertyInfo7.value = "";
                }
            }
            propertyInfo7.description = Resource.getString("PROPERTY_WRITEPOLICY_TEXT", "Default Write Policy");
            arrayList.add(propertyInfo7);
        }
        if (this.ldrive.getDefaultWritePolicy() == 1 && this.ldrive.getWritePolicy() == 0) {
            PropertyInfo propertyInfo8 = new PropertyInfo();
            object4 = (AdapterHelper)this.getParent();
            object3 = null;
            propertyInfo8.name = Resource.getString("REASON_FOR_DIFFERENCE_IN_WRITE_POLICY", "Reason for difference in Write Policy");
            if (((AdapterHelper)object4).getAdapterInfo().gethwPresent_MR_CTRL_INFO().getbbu() == 0 || ((AdapterHelper)object4).getBBU() == null) {
                object3 = Resource.getString("BBU_NOT_INSTALLED", " BBU is not installed");
            } else {
                object2 = (SASAdapter)((AdapterHelper)object4).getDeviceObject();
                object = null;
                int n = 5;
                try {
                    n = ((SASAdapter)object2).getBBUObject().getInformation().getStatus().getbatteryType();
                    object = ((SASAdapter)object2).getBBUObject().getStatus().getMrbbufwStatus();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object != null) {
                    if (((MR_BBU_FW_STATUS)object).getreplacePack()) {
                        object3 = Resource.getString("BBU_IS_FAILED", "BBU is failed");
                    }
                    if (((MR_BBU_FW_STATUS)object).getremainingCapacityLow()) {
                        object3 = Resource.getString("BBU_IS_DISCHARGED", "BBU is discharged");
                    }
                    if (n == 1 && (((MR_BBU_FW_STATUS)object).getlearnCycleRequested() || ((MR_BBU_FW_STATUS)object).getlearnCycleActive() || ((MR_BBU_FW_STATUS)object).getdischargeActive())) {
                        object3 = Resource.getString("BBU_IN_RE-LEARN_CYCLE", "BBU in re-learn cycle");
                    }
                    if (n == 6) {
                        if (((MR_BBU_FW_STATUS)object).getpremiumFeatureReqd()) {
                            object3 = Resource.getString("TMMC_CACHE_VAULT_DEACTIVATED", "CacheVault option is deactivated");
                        }
                        if (((MR_BBU_FW_STATUS)object).getpackMissing()) {
                            object3 = Resource.getString("TMMC_BBU_NOT_INSTALLED", "BBU is not installed");
                        }
                        if (((MR_BBU_FW_STATUS)object).getreplacePack() || ((MR_BBU_FW_STATUS)object).getremainingCapacityLow() || ((MR_BBU_FW_STATUS)object).getvoltageLow()) {
                            object3 = Resource.getString("TMMC_BBU_FAILED", "BBU has failed");
                        }
                        if (((MR_BBU_FW_STATUS)object).getlearnCycleActive() || ((MR_BBU_FW_STATUS)object).getlearnCycleRequested() || ((MR_BBU_FW_STATUS)object).getdischargeActive()) {
                            object3 = Resource.getString("TMMC_BBU_RELEARN_CYCLE", "BBU is in re-learn cycle");
                        }
                        if (((MR_BBU_FW_STATUS)object).geti2cErrorsDetected()) {
                            object3 = Resource.getString("TMMC_COMMUNICATION_FAULT", "Communication Fault");
                        }
                        if (((MR_BBU_FW_STATUS)object).getnoSpace()) {
                            object3 = Resource.getString("TMMC_NO_SPACE", "No space on flash for CacheVault");
                        }
                        if (((MR_BBU_FW_STATUS)object).getmicrocodeUpdateReqd()) {
                            object3 = Resource.getString("TMMC_MODULE_MICROCODE_UPDATE", "Module Microcode update is required");
                        }
                    }
                }
                if (((AdapterHelper)object4).isAnyReconInProgress()) {
                    object3 = Resource.getString("RECONSTRUCTION_IS_IN_PROGRESS");
                }
                if (((AdapterHelper)object4).getAdapterInfo().getCacheIsPinned() != 0) {
                    object3 = Resource.getString("PINNED_CACHE_IS_PRESENT_ON_THE_CONTROLLER", "Pinned cache is present on the controller");
                }
                propertyInfo8.value = object3;
                if (object3 != null) {
                    arrayList.add(propertyInfo8);
                }
            }
        }
        if (!bl) {
            PropertyInfo propertyInfo9 = new PropertyInfo();
            propertyInfo9.name = Resource.getString("PROP_APOLICY", "<html><b>Access Policy:</b></html>");
            arrayList.add(propertyInfo9);
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROPERTY_CURACCESSPOLICY_TEXT", "Current Access Policy");
            if (this.ldParam.getAccessPolicyStatus() == 0) {
                ((PropertyInfo)object4).value = this.getAccessPolicyString(this.ldProp.getaccessPolicy());
            } else if (this.ldParam.getAccessPolicyStatus() != 0) {
                ((PropertyInfo)object4).value = this.getAccessPolicyString(this.ldParam.getCurrentAccessPolicy());
            }
            ((PropertyInfo)object4).description = Resource.getString("PROPERTY_CURACCESSPOLICY_TEXT", "Current Access Policy");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = Resource.getString("PROPERTY_DEFACCESSPOLICY_TEXT", "Default Access Policy");
            ((PropertyInfo)object3).description = Resource.getString("PROPERTY_DEFACCESSPOLICY_TEXT", "Default Access Policy");
            ((PropertyInfo)object3).value = this.getAccessPolicyString(this.ldProp.getaccessPolicy());
            arrayList.add(object3);
            if (this.isBlockedDueToSSCDOffline()) {
                object2 = new PropertyInfo();
                ((PropertyInfo)object2).description = ((PropertyInfo)object2).name = Resource.getString("REASON_FOR_DIFFERENCE_IN_ACCESS_POLICY", "Reason for difference in Access Policy");
                ((PropertyInfo)object2).value = ((AdapterHelper)this.parent).isCSA() ? Resource.getString("CSA_CACHE_IS_OFFLINE", "Associated Nytro Cache drive is offline") : Resource.getString("CACHE_IS_OFFLINE", "Associated CacheCade\u2122 - SSD Caching virtual drive is offline");
                arrayList.add(object2);
            }
            if (this.isBlockedDueToPeerUnavailability()) {
                object2 = new PropertyInfo();
                ((PropertyInfo)object2).description = ((PropertyInfo)object2).name = Resource.getString("REASON_FOR_DIFFERENCE_IN_ACCESS_POLICY", "Reason for difference in Access Policy");
                ((PropertyInfo)object2).value = Resource.getString("CACHE_IS_OFFLINE_VD_UNAVAILABLE", "Pinned Cache for the VD is unavailable");
                arrayList.add(object2);
            }
        }
        if ((adapterHelper = (AdapterHelper)this.getParent()).isSecuritySupported()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROP_DSPROP", "<html><b>Drive Security Properties:</b></html>");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).description = ((PropertyInfo)object3).name = Resource.getString("PROPERTY_SECURED_TEXT", "Secured");
            ((PropertyInfo)object3).value = "";
            ((PropertyInfo)object3).value = VivaldiStartupDialog.OEM_TYPE == 2561 && adapterHelper.isOnlyFDESupported() ? (!this.isVDCompriseOfFDECapableDrives() ? Resource.getString("PROPERTY_N/A_TEXT") : (this.isEncrypted() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No"))) : (this.isEncrypted() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No"));
            arrayList.add(object3);
            if (this.isEncrypted() && !adapterHelper.isOnlyFDESupported()) {
                object2 = new PropertyInfo();
                ((PropertyInfo)object2).description = ((PropertyInfo)object2).name = Resource.getString("PROPERTY_DRV_SECURITY_METHOD_TEXT", "Drive security method");
                ((PropertyInfo)object2).value = this.getEncryptionMethod();
                arrayList.add(object2);
            }
        }
        if (((AdapterHelper)this.parent).isPowerSaveSupportedOnConfiguredDrives()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROP_POWER_STATE_PROP", "<html><b>Power State Properties:</b></html>");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = Resource.getString("DEFAULT_POWER_SAVE_POLICY", "Default Power save policy");
            ((PropertyInfo)object3).value = this.getDefaultPowerState();
            ((PropertyInfo)object3).description = Resource.getString("DEFAULT_POWER_SAVE_POLICY", "Default Power save policy");
            arrayList.add(object3);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("CURRENT_POWER_SAVE_POLICY", "Current Power save policy");
            ((PropertyInfo)object2).value = this.getCurrentPowerState();
            ((PropertyInfo)object2).description = Resource.getString("CURRENT_POWER_SAVE_POLICY", "Current Power save policy");
            arrayList.add(object2);
        }
        if (((AdapterHelper)this.parent).isPIEnabledOnController()) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("DATA_PROTECTION_PROP", "<html><b>Data Protection Properties:</b></html>");
            arrayList.add(object4);
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = Resource.getString("DATA_PROTECTION", "Data Protection");
            ((PropertyInfo)object3).value = this.isLDPIEnabled() ? Resource.getString("PROPERTY_HS_SPIN_DOWN_ENABLED", "Enabled") : Resource.getString("PROPERTY_HS_SPIN_DOWN_DISABLED", "Disabled");
            ((PropertyInfo)object3).description = Resource.getString("DATA_PROTECTION", "Data Protection");
            arrayList.add(object3);
        }
        object4 = new PropertyInfo();
        ((PropertyInfo)object4).name = Resource.getString("PROPERTY_SPIN_UP_IN_60_SEC_TEXT", "Spin up in 1 minute");
        ((PropertyInfo)object4).value = "No";
        ((PropertyInfo)object4).description = Resource.getString("PROPERTY_SPIN_UP_IN_60_SEC_TEXT", "Spin up in 1 minute");
        if (this.ldParam.getSnapshotEnabled() == 1) {
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = "<html><b>" + Resource.getString("SNAP_BASE_DETAILS", "Snapshot Base Details") + ": </b></html>";
            arrayList.add(object3);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).description = ((PropertyInfo)object2).name = Resource.getString("ASSOCIATED_REPOSITORY", "Associated Repository: ");
            ((PropertyInfo)object2).value = this.getRepository().getText();
            arrayList.add(object2);
            object = new PropertyInfo();
            ((PropertyInfo)object).description = ((PropertyInfo)object).name = Resource.getString("SNAPSHOT_STATE", "Snapshot State");
            ((PropertyInfo)object).value = this.ldrive.getSnapshotInformation().getState() == 0 ? Resource.getString("SNAPSHOT_STATE_OPERATIONAL", "Operational") : Resource.getString("SNAPSHOT_STATE_NONOPERATIONAL", "Non Operational");
            arrayList.add(object);
            PropertyInfo propertyInfo10 = new PropertyInfo();
            propertyInfo10.description = propertyInfo10.name = Resource.getString("CAPACITY_LEFT", "Capacity Left");
            double d = this.ldrive.getSnapshotInformation().getCapacityLeft();
            d *= 100.0;
            long l = this.ldrive.getSnapshotInformation().getParams().getSize();
            l *= (long)(d /= 65535.0);
            propertyInfo10.value = KernelConstants.getConvertedSize(l /= 100L, this.getBlockSize()) + "";
            arrayList.add(propertyInfo10);
            PropertyInfo propertyInfo11 = new PropertyInfo();
            propertyInfo11.description = propertyInfo11.name = Resource.getString("AUTO_SNAP", "Snapshot on Reboot");
            propertyInfo11.value = this.ldProp.getautoSnapshot() == 1 ? Resource.getString("PROPERTY_ENABLED", "Enabled") : Resource.getString("PROPERTY_DISABLED", "Disabled");
            arrayList.add(propertyInfo11);
            PropertyInfo propertyInfo12 = new PropertyInfo();
            propertyInfo12.description = propertyInfo12.name = Resource.getString("AUTO_DOS", "Auto Delection of oldest Snapshot");
            propertyInfo12.value = this.ldProp.getdisableAutoDeleteOldestPIT() == 0 ? Resource.getString("PROPERTY_ENABLED", "Enabled") : Resource.getString("PROPERTY_DISABLED", "Disabled");
            arrayList.add(propertyInfo12);
            PropertyInfo propertyInfo13 = new PropertyInfo();
            propertyInfo13.description = propertyInfo13.name = Resource.getString("PROPERTY_OS_DISK_NAME", "OS disk name");
            String string3 = " ";
            try {
                string3 = new String(this.getOSDiskName(this.ldrive.getID())).trim() + "";
            }
            catch (Exception exception) {
                string3 = " ";
            }
            propertyInfo13.value = string3;
            arrayList.add(propertyInfo13);
        }
        if (((AdapterHelper)this.parent).isCSA()) {
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = Resource.getString("PROP_CSA_CACHECADE_CACHING", "<html><b>Nytro\u2122 Cache:</b></html>");
            arrayList.add(object3);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).description = ((PropertyInfo)object2).name = Resource.getString("PROP_CACHING", "Nytro\u2122 Cache");
            if (this.isLdCached()) {
                ((PropertyInfo)object2).value = Resource.getString("PROPERTY_ENABLED", "Enabled");
                arrayList.add(object2);
                short s2 = ((AdapterHelper)this.parent).getAdapterInfo().getcurrentSSCsize();
                PropertyInfo propertyInfo14 = new PropertyInfo();
                propertyInfo14.description = propertyInfo14.name = Resource.getString("PROP_CACHED", "Cached");
                if (s2 == 0) {
                    propertyInfo14.value = Resource.getString("PROPERTY_NO_TEXT", "No");
                    propertyInfo14.hasTooltip = true;
                    propertyInfo14.tooltipValue = "?";
                    propertyInfo14.tooltip = ((AdapterHelper)this.parent).isCSA() ? Resource.getString("PROP_CSA_CACHEPOOL_MISSING", "There are no available Nytro\u2122 Cache Drives in the Configuration.") : Resource.getString("PROP_CACHEPOOL_MISSING", "There are no available CacheCade\u2122 SSD-Caching Virtual Drives in the Configuration.");
                } else {
                    propertyInfo14.value = Resource.getString("PROPERTY_YES_TEXT", "Yes");
                }
                arrayList.add(propertyInfo14);
                if (s2 > 0) {
                    PropertyInfo propertyInfo15 = new PropertyInfo();
                    propertyInfo15.description = propertyInfo15.name = Resource.getString("PROP_CSA_CACHECADE_TYPE", "Nytro\u2122 Cache Type");
                    propertyInfo15.value = ((AdapterHelper)this.parent).getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isSSCPolicyWB() ? Resource.getString("PROP_READ_WRITE", "Read and Write") : Resource.getString("PROP_READ_ONLY", "Read only");
                    arrayList.add(propertyInfo15);
                }
            } else {
                ((PropertyInfo)object2).value = Resource.getString("PROPERTY_DISABLED", "Disabled");
                arrayList.add(object2);
            }
        } else if (((AdapterHelper)this.parent).isSSCEnabled() && ((AdapterHelper)this.parent).getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation()) {
            object3 = new PropertyInfo();
            ((PropertyInfo)object3).name = Resource.getString("PROP_CACHECADE_CACHING", "<html><b>CacheCade\u2122  Caching:</b></html>");
            arrayList.add(object3);
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).description = ((PropertyInfo)object2).name = Resource.getString("PROP_SSD_CACHING", "SSD Caching");
            if (this.isLdCached()) {
                ((PropertyInfo)object2).value = Resource.getString("PROPERTY_ENABLED", "Enabled");
                arrayList.add(object2);
                short s3 = ((AdapterHelper)this.parent).getAdapterInfo().getcurrentSSCsize();
                PropertyInfo propertyInfo16 = new PropertyInfo();
                propertyInfo16.description = propertyInfo16.name = Resource.getString("PROP_CACHED", "Cached");
                if (s3 == 0) {
                    propertyInfo16.value = Resource.getString("PROPERTY_NO_TEXT", "No");
                    propertyInfo16.hasTooltip = true;
                    propertyInfo16.tooltipValue = "?";
                    propertyInfo16.tooltip = Resource.getString("PROP_CACHEPOOL_MISSING", "There are no available CacheCade\u2122 SSD-Caching Virtual Drives in the Configuration.");
                } else {
                    propertyInfo16.value = Resource.getString("PROPERTY_YES_TEXT", "Yes");
                }
                arrayList.add(propertyInfo16);
                if (s3 > 0) {
                    PropertyInfo propertyInfo17 = new PropertyInfo();
                    propertyInfo17.description = propertyInfo17.name = Resource.getString("PROP_CACHECADE_TYPE", "CacheCade\u2122  Type");
                    propertyInfo17.value = ((AdapterHelper)this.parent).getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isSSCPolicyWB() ? Resource.getString("PROP_READ_WRITE", "Read and Write") : Resource.getString("PROP_READ_ONLY", "Read only");
                    arrayList.add(propertyInfo17);
                }
            } else {
                ((PropertyInfo)object2).value = Resource.getString("PROPERTY_DISABLED", "Disabled");
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    public LogicalDriveHelper getRepository() {
        if (this.ldrive.getSnapshotInformation() == null) {
            return null;
        }
        byte by = this.ldrive.getSnapshotInformation().getParams().getTargetIDforSnapshot();
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.getParent()).getLogicalDrives();
        for (int n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
            if (by != ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getID()) continue;
            return logicalDriveHelperArray[n];
        }
        return null;
    }

    private String getAccessPolicyString(int n) {
        switch (n) {
            case 2: {
                return Resource.getString("LD_ACCESS_RDONLY", "Read Only");
            }
            case 0: {
                return Resource.getString("LD_ACCESS_RDWRITE", "Read Write");
            }
            case 3: {
                return Resource.getString("LD_ACCESS_BLOCKED", "Blocked");
            }
        }
        return "";
    }

    @Override
    public void update(Observable observable, Object object) {
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        JOptionPane jOptionPane = null;
        String string = null;
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("LDHelper Received AEN : " + new String(mR_EVT_DETAIL.getdescription()).trim());
        }
        System.out.println("eventCode " + n);
        this.ldInfo = this.ldrive.getInformation();
        this.ldProp = this.ldInfo.getldConfig().getproperties();
        this.ldParam = this.ldInfo.getldConfig().getparams();
        if (this.ldInfo.getldConfig().getparams().getSnapshotEnabled() == 1) {
            this.ldallPitInfo = this.ldrive.getSnapshotInformation().getLdPitInfo();
        }
        switch (n) {
            case 73: 
            case 346: 
            case 347: {
                this.updateLogicalTrees();
                break;
            }
            case 81: {
                this.updateTrees();
                break;
            }
            case 348: {
                jOptionPane = new JOptionPane(Resource.getString("NO_SPACE"), 0);
                string = Resource.getString("SNAPSHOT_DISABLED_TITLE", "Snapshots Disabled.");
                JDialog jDialog = jOptionPane.createDialog(string);
                jDialog.setModal(false);
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                break;
            }
            case 358: {
                float f = 100.0f;
                Object[] objectArray = new Object[1];
                StringBuffer stringBuffer = new StringBuffer();
                objectArray[0] = stringBuffer.append(" " + f + "%");
                String string2 = MessageFormat.format(Resource.getString("NO_REP_SPACE_NEW"), objectArray);
                jOptionPane = new JOptionPane(string2, 2);
                string = Resource.getString("RUNNING_OUT_OF_SPACE_TITLE", "Runing Out Of Space");
                JDialog jDialog = jOptionPane.createDialog(string);
                jDialog.setModal(false);
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                break;
            }
            case 357: {
                float f = 80.0f;
                Object[] objectArray = new Object[1];
                StringBuffer stringBuffer = new StringBuffer();
                objectArray[0] = stringBuffer.append(" " + f + "%");
                String string3 = MessageFormat.format(Resource.getString("NO_REP_SPACE_NEW"), objectArray);
                jOptionPane = new JOptionPane(string3, 2);
                string = Resource.getString("RUNNING_OUT_OF_SPACE_TITLE", "Runing Out Of Space");
                JDialog jDialog = jOptionPane.createDialog(string);
                jDialog.setModal(false);
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                break;
            }
            case 376: {
                float f = 95.0f;
                Object[] objectArray = new Object[1];
                StringBuffer stringBuffer = new StringBuffer();
                objectArray[0] = stringBuffer.append(" " + f + "%");
                String string4 = MessageFormat.format(Resource.getString("NO_REP_SPACE_NEW"), objectArray);
                jOptionPane = new JOptionPane(string4, 2);
                string = Resource.getString("RUNNING_OUT_OF_SPACE_TITLE", "Runing Out Of Space");
                JDialog jDialog = jOptionPane.createDialog(string);
                jDialog.setModal(false);
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                break;
            }
            case 360: {
                float f = 100.0f;
                StringBuffer stringBuffer = new StringBuffer();
                Object[] objectArray = new Object[]{stringBuffer.append(" " + f + "%")};
                String string5 = MessageFormat.format(Resource.getString("NO_REP_SPACE_NEW"), objectArray);
                jOptionPane = new JOptionPane(stringBuffer.toString(), 2);
                string = Resource.getString("RUNNING_OUT_OF_SPACE_TITLE", "Runing Out Of Space");
                JDialog jDialog = jOptionPane.createDialog(string);
                jDialog.setModal(false);
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                break;
            }
            case 359: {
                float f = 80.0f;
                StringBuffer stringBuffer = new StringBuffer();
                Object[] objectArray = new Object[]{stringBuffer.append(" " + f + "%")};
                String string6 = MessageFormat.format(Resource.getString("NO_REP_SPACE_NEW"), objectArray);
                jOptionPane = new JOptionPane(string6, 2);
                string = Resource.getString("RUNNING_OUT_OF_SPACE_TITLE", "Runing Out Of Space");
                JDialog jDialog = jOptionPane.createDialog(string);
                jDialog.setModal(false);
                jDialog.setIconImage(image);
                jDialog.setVisible(true);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers(object);
    }

    private void updateTrees() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VivaldiStartupDialog.mainScreen.getPhysicalTree().updateUI();
                VivaldiStartupDialog.mainScreen.getLogicalTree().updateUI();
            }
        });
    }

    private void updateLogicalTrees() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VivaldiStartupDialog.mainScreen.getLogicalTree().updateUI();
            }
        });
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.parent;
    }

    public ArrayHelper[] getArrays() {
        ArrayList arrayList = this.ldrive.getSASArrayList();
        ArrayHelper[] arrayHelperArray = new ArrayHelper[arrayList.size()];
        int n = 0;
        ArrayHelper[] arrayHelperArray2 = ((AdapterHelper)this.parent).getArrays();
        for (int i = 0; i < arrayHelperArray2.length; ++i) {
            if (!arrayList.contains(arrayHelperArray2[i].getDeviceObject())) continue;
            arrayHelperArray[n++] = arrayHelperArray2[i];
        }
        return arrayHelperArray;
    }

    public Vector getDiskDetails() {
        return this.ldrive.getGraphicalLayoutInformation();
    }

    @Override
    public ImageIcon getStatusIcon() {
        char c = this.ldParam.getstate();
        if (c == '\u0002') {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (c == '\u0000') {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        if (c == '\u0001') {
            return this.getImageIcon(Resource.getString("PARTIAL_DEGRADED_IMAGE", "partialdegraded.png"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.ldParam.getstate();
    }

    @Override
    public void setStatus(int n) {
    }

    public SASLogicalDriveOperationsAllowed getAllowedOperations() {
        if (this.allowedOps == null) {
            this.allowedOps = this.ldrive.getLDAllowedOps();
        }
        return this.allowedOps;
    }

    public static String getFormattedStripeSize(byte by) {
        return Resource.getString(STRIPE_SIZE_ARR[by][0], STRIPE_SIZE_ARR[by][1]);
    }

    public boolean isOSDrive() {
        boolean bl = false;
        if (this.ldInfo.getsnapshotRepository() == 1) {
            return false;
        }
        try {
            SL_PARTITION_INFO_T sL_PARTITION_INFO_T = this.ldrive.getPartitionInfo();
            SL_PARTITION_DETAILS_T[] sL_PARTITION_DETAILS_TArray = sL_PARTITION_INFO_T.getPartitionDetails();
            for (int i = 0; i < sL_PARTITION_INFO_T.getPartitionCount(); ++i) {
                if (sL_PARTITION_DETAILS_TArray[i].getBootIndicator() != 1) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    public boolean isOSDrive(SL_DRIVE_DISTRIBUTION_T sL_DRIVE_DISTRIBUTION_T) {
        for (int i = 0; i < sL_DRIVE_DISTRIBUTION_T.getmappedDevicesCount(); ++i) {
            if (sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getdriveId() != this.ldrive.getID()) continue;
            int n = sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getosDriveNumber();
            try {
                SL_PARTITION_INFO_T sL_PARTITION_INFO_T = ((SASServer)this.ldrive.parent().parent()).getPartitionInfo(((SASAdapter)this.ldrive.parent()).getReceiverWWN(), n, this.ldrive.getID(), ((SASAdapter)this.ldrive.parent()).getCtrlID());
                SL_PARTITION_DETAILS_T[] sL_PARTITION_DETAILS_TArray = sL_PARTITION_INFO_T.getPartitionDetails();
                for (int j = 0; j < sL_PARTITION_INFO_T.getPartitionCount(); ++j) {
                    if (sL_PARTITION_DETAILS_TArray[j].getBootIndicator() != 1) continue;
                    return true;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isOSDrive(SL_DRIVE_DISTRIBUTION_EX_T sL_DRIVE_DISTRIBUTION_EX_T) {
        for (int i = 0; i < sL_DRIVE_DISTRIBUTION_EX_T.getmappedDevicesCount(); ++i) {
            if (sL_DRIVE_DISTRIBUTION_EX_T.getmappedDriveInfo()[i].getdriveId() != this.ldrive.getID()) continue;
            int n = sL_DRIVE_DISTRIBUTION_EX_T.getmappedDriveInfo()[i].getosDriveNumber();
            try {
                SL_PARTITION_INFO_T sL_PARTITION_INFO_T = ((SASServer)this.ldrive.parent().parent()).getPartitionInfo(((SASAdapter)this.ldrive.parent()).getReceiverWWN(), n, this.ldrive.getID(), ((SASAdapter)this.ldrive.parent()).getCtrlID());
                SL_PARTITION_DETAILS_T[] sL_PARTITION_DETAILS_TArray = sL_PARTITION_INFO_T.getPartitionDetails();
                for (int j = 0; j < sL_PARTITION_INFO_T.getPartitionCount(); ++j) {
                    if (sL_PARTITION_DETAILS_TArray[j].getBootIndicator() != 1) continue;
                    return true;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isVDCompriseOfFDECapableDrives() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPDListInLd();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            return false;
        }
        return true;
    }

    private boolean isVDCompriseOfSSDDrives(LogicalDriveHelper logicalDriveHelper) {
        boolean bl = false;
        PhysicalDriveHelper[] physicalDriveHelperArray = logicalDriveHelper.getPDListInLd();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getmediaType() != '\u0001') continue;
            bl = true;
            return true;
        }
        return bl;
    }

    private boolean isVDCompriseOfSASDrives() {
        boolean bl = true;
        ArrayList arrayList = this.ldrive.getConstituentPDList();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                if (sASPhysicalDrive == null) continue;
                if (sASPhysicalDrive.getDriveType() == 2) {
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isVDCompriseOfSATADrives() {
        boolean bl = true;
        ArrayList arrayList = this.ldrive.getConstituentPDList();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                if (sASPhysicalDrive == null) continue;
                if (sASPhysicalDrive.getDriveType() == 3) {
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public byte getEncryptionType() {
        return this.ldParam.getEncryptionType();
    }

    public boolean isEncrypted() {
        byte by = this.getEncryptionType();
        return by != 0;
    }

    private String getEncryptionMethod() {
        byte by = this.getEncryptionType();
        String string = "";
        if (by == 2) {
            string = Resource.getString("DESC_ENCRYPTION_METHOD_CTRL", "Controller-based encryption");
        } else if (by == 1) {
            string = Resource.getString("DESC_ENCRYPTION_METHOD_FDE", "Full disk encryption");
        }
        return string;
    }

    public PhysicalDriveHelper[] getPDListInLd() {
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        ArrayHelper[] arrayHelperArray = this.getArrays();
        for (int n = 0; n < arrayHelperArray.length; n = (int)((short)(n + 1))) {
            if (arrayHelperArray[n] == null) continue;
            PhysicalDriveHelper[] physicalDriveHelperArray = arrayHelperArray[n].getPhysicalDrives();
            for (int n2 = 0; n2 < physicalDriveHelperArray.length; n2 = (int)((short)(n2 + 1))) {
                if (physicalDriveHelperArray[n2] == null) continue;
                arrayList.add(physicalDriveHelperArray[n2]);
            }
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[arrayList.size()];
        arrayList.toArray(physicalDriveHelperArray);
        return physicalDriveHelperArray;
    }

    public boolean getPDListInLd_ssd() {
        ArrayList arrayList = new ArrayList();
        ArrayHelper[] arrayHelperArray = this.getArrays();
        for (int n = 0; n < arrayHelperArray.length; n = (int)((short)(n + 1))) {
            PhysicalDriveHelper[] physicalDriveHelperArray = arrayHelperArray[n].getPhysicalDrives();
            for (int n2 = 0; n2 < physicalDriveHelperArray.length; n2 = (int)((short)(n2 + 1))) {
                if (physicalDriveHelperArray[n2] == null || physicalDriveHelperArray[n2].getmediaType() != '\u0001') continue;
                return true;
            }
        }
        return false;
    }

    private int badBlocksExistMethod() {
        return this.ldParam.getBadBlocksExist();
    }

    public ArrayList getSnapshotPropertyList() {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        ArrayList<String> arrayList2 = this.getLDsInRepository();
        boolean bl = this.isDriveCleanUpPossible();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        propertyInfo.description = Resource.getString("PROP_GENERAL", "<html><b>General</b></html>");
        arrayList.add(propertyInfo);
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROPERTY_REPOSITORY_TEXT", "Repository");
        propertyInfo2.value = this.getSnapshotText(this);
        propertyInfo2.description = Resource.getString("PROPERTY_REPOSITORY_TEXT", "Repository");
        arrayList.add(propertyInfo2);
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_TOTAL_CAPACITY_TEXT", "Total capacity");
        propertyInfo3.value = KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize());
        propertyInfo3.description = Resource.getString("PROPERTY_TOTAL_CAPACITY_TEXT", "Total capacity");
        arrayList.add(propertyInfo3);
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("CAPACITY_USED", "Capacity used");
        propertyInfo4.value = KernelConstants.getConvertedSize(this.getCapacityUsed(), this.getBlockSize()) + "(" + String.format("%.5g%n", Float.valueOf(this.getPercentCapacityUsed())) + "%)";
        propertyInfo4.description = Resource.getString("CAPACITY_USED", "Capacity used");
        arrayList.add(propertyInfo4);
        PropertyInfo propertyInfo5 = new PropertyInfo();
        propertyInfo5.name = Resource.getString("CAPACITY_REMAINING", "Capacity remaining");
        propertyInfo5.value = KernelConstants.getConvertedSize(this.ldrive.getSize() - this.getCapacityUsed(), this.getBlockSize()) + "(" + String.format("%.5g%n", Float.valueOf(100.0f - this.getPercentCapacityUsed())) + "%)";
        propertyInfo5.description = Resource.getString("CAPACITY_REMAINING", "Capacity remaining");
        arrayList.add(propertyInfo5);
        PropertyInfo propertyInfo6 = new PropertyInfo();
        propertyInfo6.name = Resource.getString("PROPERTY_DRIVE_CLEAN_UP_TEXT", "Drive clean up(Garbage collection)");
        propertyInfo6.value = bl ? Resource.getString("TEXT_POSSIBLE", "Possible") + "" : Resource.getString("TEXT_NOT_POSSIBLE", "NOT Possible") + "";
        propertyInfo6.description = Resource.getString("PROPERTY_DRIVE_CLEAN_UP_TEXT", "Drive clean up(Garbage collection)");
        PropertyInfo propertyInfo7 = new PropertyInfo();
        propertyInfo7.name = Resource.getString("PROPERTY_NUM_HOLES_TEXT", "Number of Holes");
        propertyInfo7.value = this.m_numHoles + "";
        propertyInfo7.description = Resource.getString("PROPERTY_NUM_HOLES_TEXT", "Number of Holes");
        PropertyInfo propertyInfo8 = new PropertyInfo();
        propertyInfo8.name = Resource.getString("PROPERTY_ASSOCIATED_BASEVD_TEXT", "<html><b>Associated base virtual drives:</b></html>");
        arrayList.add(propertyInfo8);
        for (int n = 0; n < arrayList2.size(); n = (int)((byte)(n + 1))) {
            PropertyInfo propertyInfo9 = new PropertyInfo();
            propertyInfo9.name = Resource.getString("PROPERTY_BASEVD_TEXT", "Base virtual drive");
            propertyInfo9.value = arrayList2.get(n);
            propertyInfo9.description = Resource.getString("PROPERTY_BASEVD_TEXT", "Base virtual drive");
            arrayList.add(propertyInfo9);
        }
        return arrayList;
    }

    public boolean isDriveCleanUpPossible() {
        int n;
        boolean bl = false;
        this.m_totalHoleSize = 0;
        MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
        mR_LD_SNAPSHOT_REPOSITORY_SPACE = this.ldrive.getSnapshotRepositorySpace();
        if (mR_LD_SNAPSHOT_REPOSITORY_SPACE == null) {
            return bl;
        }
        this.m_numHoles = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
        for (n = 0; n < this.m_numHoles; n = (int)((byte)(n + 1))) {
            this.m_totalHoleSize = 0;
            this.m_totalHoleSize = (int)((long)this.m_totalHoleSize + mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[n].getHoleSize());
        }
        for (n = 0; n < this.m_numHoles; n = (int)((byte)(n + 1))) {
            if (mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[n].getHoleRecoverable() != 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ArrayList<String> getLDsInRepository() {
        int n;
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = null;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        mR_LD_TARGETID_LIST = this.ldrive.getSnapshotRepositoryLds();
        if (mR_LD_TARGETID_LIST == null) {
            return null;
        }
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.getParent()).getLogicalDrives();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int n2 = 0; n2 < mR_LD_TARGETID_LIST.getCount(); n2 = (int)((byte)(n2 + 1))) {
            for (n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
                if (mR_LD_TARGETID_LIST.getTargetId()[n2] != ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getID() || arrayList.contains(mR_LD_TARGETID_LIST.getTargetId()[n2])) continue;
                arrayList2.add(this.getSnapshotText(logicalDriveHelperArray[n]));
                arrayList.add(mR_LD_TARGETID_LIST.getTargetId()[n2]);
            }
        }
        MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
        mR_LD_SNAPSHOT_REPOSITORY_SPACE = this.ldrive.getSnapshotRepositorySpace();
        this.m_numHoles = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
        for (n = 0; n < this.m_numHoles; n = (int)((byte)(n + 1))) {
            if (mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[n].getHoleRecoverable() != 1 || arrayList.contains(mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[n].getSourceTargetId())) continue;
            arrayList2.add("Virtual Drive: " + mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[n].getSourceTargetId() + ":" + Resource.getString("LDRIVE_MISSING", "Missing"));
            arrayList.add(mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[n].getSourceTargetId());
        }
        return arrayList2;
    }

    public float getPercentCapacityUsed() {
        float f = 0.0f;
        f = (float)this.m_totalHoleSize * 100.0f / (float)(this.ldrive.getSize() / 2048L);
        return f;
    }

    public long getCapacityUsed() {
        return KernelConstants.getSizeInBlocks(this.m_totalHoleSize, 2, this.getBlockSize());
    }

    public String getSnapshotText(LogicalDriveHelper logicalDriveHelper) {
        StringBuffer stringBuffer = null;
        stringBuffer = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsnapshotRepository() == 1 ? new StringBuffer(Resource.getString("REPOSITORY_VIRTUAL_DRIVE_TEXT", "Snapshot Repository") + ": " + ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID()) : new StringBuffer(Resource.getString("BASE_VIRTUAL_DRIVE_TEXT", "Snapshot Base") + ": " + ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID());
        if (((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName() != null && ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName().length() != 0) {
            stringBuffer.append(", ");
            stringBuffer.append(((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName());
        }
        return stringBuffer.toString();
    }

    public int getNumHoles() {
        return this.m_numHoles;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getOSDiskName(short s) {
        OperationDetails operationDetails = new OperationDetails(12, null);
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = (byte)s;
        operationDetails.setParameter(byArray);
        try {
            ((SASAdapter)this.getDeviceObject().parent()).fireOperation(operationDetails);
            SL_DRIVE_DISTRIBUTION_T sL_DRIVE_DISTRIBUTION_T = (SL_DRIVE_DISTRIBUTION_T)operationDetails.getParam();
            for (int i = 0; i < sL_DRIVE_DISTRIBUTION_T.getmappedDevicesCount(); ++i) {
                if (sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getdriveId() != s) continue;
                byte[] byArray2 = sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getosDiskName();
                return byArray2;
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vk.GetErrorCode() " + vKOperationFailedException.GetErrorCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void delay(int n) {
        for (int i = 1; i <= n; ++i) {
            double d = Math.PI * Math.PI;
        }
    }

    public ArrayList getSSCDPropertyList() {
        PropertyInfo propertyInfo;
        PropertyInfo propertyInfo2;
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        arrayList.add(propertyInfo3);
        if (this.ldrive.getName().length() > 0) {
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROPERTY_SSCD_NAME_TEXT", "CacheCade\u2122 Name");
            propertyInfo2.value = this.ldrive.getName();
            propertyInfo2.description = Resource.getString("PROPERTY_SSCD_NAME_TEXT", "CacheCade\u2122 Name");
            arrayList.add(propertyInfo2);
        }
        propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROP_CACHECADE_STATE", "State");
        propertyInfo2.value = this.getState();
        propertyInfo2.description = Resource.getString("PROP_CACHECADE_STATE", "State");
        arrayList.add(propertyInfo2);
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROPERTY_RAIDLEVEL_TEXT", "RAID Level");
        propertyInfo4.value = this.getRaidLevelString();
        propertyInfo4.description = Resource.getString("PROPERTY_RAIDLEVEL_TEXT", "RAID Level");
        arrayList.add(propertyInfo4);
        PropertyInfo propertyInfo5 = new PropertyInfo();
        propertyInfo5.name = Resource.getString("PROPERTY_LDRIVESIZE_TEXT", "Size");
        propertyInfo5.value = KernelConstants.getConvertedSize(this.ldInfo.getsize(), this.getBlockSize());
        propertyInfo5.description = Resource.getString("PROPERTY_LDRIVESIZE_TEXT", "Size");
        arrayList.add(propertyInfo5);
        PropertyInfo propertyInfo6 = new PropertyInfo();
        propertyInfo6.name = Resource.getString("PROP_WPOLICY", "<html><b>Write Policy:</b></html>");
        arrayList.add(propertyInfo6);
        boolean bl = this.isControllerIntegratedRaidType();
        if (!bl) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROPERTY_CURWRITEPOLICY_TEXT", "Current Write Policy");
            switch (this.ldrive.getWritePolicy()) {
                case 1: {
                    propertyInfo.value = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                    break;
                }
                case 0: {
                    propertyInfo.value = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                    break;
                }
                case 17: {
                    propertyInfo.value = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back");
                    break;
                }
                default: {
                    propertyInfo.value = "";
                }
            }
            propertyInfo.description = Resource.getString("PROPERTY_CURWRITEPOLICY_TEXT", "Current Write Policy");
            arrayList.add(propertyInfo);
        }
        propertyInfo = new PropertyInfo();
        propertyInfo.name = bl ? Resource.getString("PROPERTY_WRITEPOLICY_TEXT", "Write Policy") : Resource.getString("PROPERTY_DEFWRITEPOLICY_TEXT", "Default Write Policy");
        switch (this.ldrive.getDefaultWritePolicy()) {
            case 1: {
                propertyInfo.value = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                break;
            }
            case 0: {
                propertyInfo.value = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                break;
            }
            case 17: {
                propertyInfo.value = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back");
                break;
            }
            default: {
                propertyInfo.value = "";
            }
        }
        propertyInfo.description = Resource.getString("PROPERTY_WRITEPOLICY_TEXT", "Default Write Policy");
        arrayList.add(propertyInfo);
        ArrayList<LogicalDriveHelper> arrayList2 = this.getLdsAssociatedToSSCD();
        if (arrayList2 != null && arrayList2.size() > 0) {
            PropertyInfo propertyInfo7 = new PropertyInfo();
            propertyInfo7.name = Resource.getString("PROP_ASSOCIATE_VD", "<html><b>Associated Virtual Drive(s):</b></html>");
            arrayList.add(propertyInfo7);
            for (int n = 0; n < arrayList2.size(); n = (int)((byte)(n + 1))) {
                PropertyInfo propertyInfo8 = new PropertyInfo();
                propertyInfo8.name = arrayList2.get(n).getText();
                propertyInfo8.value = " ";
                propertyInfo8.description = arrayList2.get(n).getText();
                arrayList.add(propertyInfo8);
            }
        }
        return arrayList;
    }

    public boolean isSSCD() {
        return this.ldParam.getisSSCD() != 0;
    }

    public ArrayList<LogicalDriveHelper> getLdsAssociatedToSSCD() {
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.getParent()).getLogicalDrives();
        byte[] byArray = ((AdapterHelper)this.parent).getAssociatedLdIds();
        if (byArray != null && byArray.length > 0) {
            block0: for (int n = 0; n < byArray.length; n = (int)((byte)(n + 1))) {
                for (int n2 = 0; n2 < logicalDriveHelperArray.length; n2 = (int)((byte)(n2 + 1))) {
                    if (logicalDriveHelperArray[n2].getDeviceObject().getID() != byArray[n]) continue;
                    arrayList.add(logicalDriveHelperArray[n2]);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    public boolean getLdCached() {
        byte[] byArray = ((AdapterHelper)this.parent).getAssociatedLdIds();
        if (byArray != null && byArray.length > 0) {
            for (int n = 0; n < byArray.length; n = (int)((byte)(n + 1))) {
                if (this.ldrive.getID() != byArray[n]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLdCached() {
        return this.m_isLDCached;
    }

    public boolean canExpand() {
        block6: {
            MR_CTRL_INFO mR_CTRL_INFO = ((AdapterHelper)this.parent).getAdapterInfo();
            if (mR_CTRL_INFO.getadapterOperations_MR_CTRL_INFO().isSupportOCEwithNoDriveAddition() && this.allowedOps != null) {
                try {
                    this.allowedOps = this.ldrive.getAllAllowedOperations();
                    if (!this.allowedOps.isStartRecon()) break block6;
                    SASArray sASArray = (SASArray)this.getArrays()[0].getDeviceObject();
                    SL_ARRAY_INFO_T sL_ARRAY_INFO_T = sASArray.getSLArrayInformation();
                    MR_SPAN mR_SPAN = this.ldInfo.getldConfig().getspan()[0];
                    if (sL_ARRAY_INFO_T.getfreeCount() > 0) {
                        if (mR_SPAN.getstartBlock() == 0L) {
                            return true;
                        }
                        long l = mR_SPAN.getstartBlock() + mR_SPAN.getnumBlocks();
                        freeInfo_SL_ARRAY_INFO_T[] freeInfo_SL_ARRAY_INFO_TArray = sL_ARRAY_INFO_T.getfreeInfo_SL_ARRAY_INFO_T();
                        for (int n = 0; n < sL_ARRAY_INFO_T.getfreeCount(); n = (int)((byte)(n + 1))) {
                            if (freeInfo_SL_ARRAY_INFO_TArray[n].getstartBlock() < l) continue;
                            return true;
                        }
                        break block6;
                    }
                    ArrayHelper arrayHelper = this.getArrays()[0];
                    return arrayHelper.canExpand();
                }
                catch (Exception exception) {
                    System.out.println("Allowed Operation is not available !");
                    exception.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public String getDefaultPowerState() {
        if (((AdapterHelper)this.parent).isSupportPSMaxWithCache()) {
            switch (this.ldProp.getdefaultPSPolicy()) {
                case 0: {
                    return Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined");
                }
                case -2: {
                    return Resource.getString("DS_NONE", "None");
                }
                case 1: {
                    return Resource.getString("DS_AUTO", "Auto");
                }
                case 2: {
                    return Resource.getString("DS_MAX", "Max");
                }
                case 6: {
                    return Resource.getString("DS_MAX_NO_CACHE", "Max without Cache");
                }
            }
            return Resource.getString("TOOLTIP_POWER_SAVINGS_LEVEL_NONE", "No power saving");
        }
        switch (this.ldProp.getdefaultPSPolicy()) {
            case 0: {
                return Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined");
            }
            case -2: {
                return Resource.getString("DS_NONE", "None");
            }
            case 1: 
            case 5: {
                return Resource.getString("DS_AUTO", "Auto");
            }
            case 2: 
            case 6: {
                return Resource.getString("DS_MAX", "Max");
            }
        }
        return Resource.getString("TOOLTIP_POWER_SAVINGS_LEVEL_NONE", "No power saving");
    }

    public String getCurrentPowerState() {
        if (((AdapterHelper)this.parent).isSupportPSMaxWithCache()) {
            switch (this.ldProp.getcurrentPSPolicy()) {
                case 0: {
                    return Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined");
                }
                case -2: {
                    return Resource.getString("DS_NONE", "None");
                }
                case 1: {
                    return Resource.getString("DS_AUTO", "Auto");
                }
                case 2: {
                    return Resource.getString("DS_MAX", "Max");
                }
                case 6: {
                    return Resource.getString("DS_MAX_NO_CACHE", "Max without Cache");
                }
            }
            return Resource.getString("TOOLTIP_POWER_SAVINGS_LEVEL_NONE", "No power saving");
        }
        switch (this.ldProp.getcurrentPSPolicy()) {
            case 0: {
                return Resource.getString("DS_CTRL_DEF_TEXT", "Controller Defined");
            }
            case -2: {
                return Resource.getString("DS_NONE", "None");
            }
            case 1: 
            case 5: {
                return Resource.getString("DS_AUTO", "Auto");
            }
            case 2: 
            case 6: {
                return Resource.getString("DS_MAX", "Max");
            }
        }
        return Resource.getString("TOOLTIP_POWER_SAVINGS_LEVEL_NONE", "No power saving");
    }

    public boolean isVDinTransitioningState() {
        return false;
    }

    public String getVDname() {
        return this.ldrive.getName();
    }

    public String getVDsize() {
        return KernelConstants.getConvertedSize(this.ldrive.getSize(), this.getBlockSize());
    }

    public String getSnapshotEnabled() {
        if (this.ldParam.getSnapshotEnabled() == 1) {
            return Resource.getString("TEXT_YES", "YES");
        }
        return Resource.getString("TEXT_NO", "NO");
    }

    private boolean isControllerIntegratedRaidType() {
        byte by = ((SASAdapter)this.parent.getDeviceObject()).getAdapterType();
        boolean bl = by == 2 || by == 3 || by == 4;
        return bl;
    }

    public byte getpowerSavingOptions() {
        return this.ldParam.getpowerSavingOptions();
    }

    public byte getdefaultPSPolicy() {
        return this.ldProp.getdefaultPSPolicy();
    }

    public byte getcurrentPSPolicy() {
        return this.ldProp.getcurrentPSPolicy();
    }

    public boolean isLDPIEnabled() {
        return this.ldParam.getPIEnabled() != 0;
    }

    public MR_LD_PARAMETERS getLDParameters() {
        return this.ldParam;
    }

    public boolean isOperationAllowed(OperationDetails operationDetails) {
        if (operationDetails.getOpcode() == 3 && this.getArrays()[0].isSlicedForBootVolume()) {
            return false;
        }
        if (this.isOSDrive()) {
            new CustomMsgBox(Resource.getString("MSG_OS_LD_FORMAT", "This is an OS drive. This virtual drive cannot be formated."));
            return false;
        }
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer(Resource.getString("MSG_DELETELD_TEXT1", "<html>You have chosen to delete Virtual Disk"));
        stringBuffer.append(" " + this.ldrive.getID() + ".  ");
        stringBuffer.append(Resource.getString("MSG_DELETELD_TEXT2", "All data<br> on the virtual disk will be lost"));
        if (this.ldParam.getPinnedCacheState() != 0) {
            stringBuffer.append(" " + Resource.getString("MSG_DELETELD_TEXT3", "and the preserved<br> cache for this virtual disk will be discarded"));
        }
        stringBuffer.append(".");
        if (((AdapterHelper)this.parent).isCSA()) {
            stringBuffer.append(Resource.getString("CSA_MSG_DELETE_LD_TEXT", "<br><br>The delete operation may take some time due to <br>Nytro\u2122 Caching. You may force the delete to <br>complete quickly, but that will result in a <br>permanent loss of any cached data.<br>"));
        } else {
            stringBuffer.append(Resource.getString("MSG_DELETELD_TEXT5", "<br><br>The delete operation may take some time due to<br>SSD caching. You may force the delete to complete<br>quickly, but that will result in a permanent loss of<br>any cached data.<br>") + "</html>");
        }
        String string = Resource.getString("FORCE_CLEAR_TEXT", "(F)orce the delete to complete quickly (not recommended)");
        String string2 = " " + Resource.getString("MSG_DELETELD_TEXT4", "Are you sure you want to delete Virtual Disk") + " " + this.ldrive.getID() + "?";
        String string3 = Resource.getString("MSG_DELETELD_CONFIRM_TITLE", "Confirm Delete Virtual Disk");
        boolean[] blArray = CustomMsgBox.confirmWithForceCheck(VivaldiStartupDialog.mainScreen, string3, stringBuffer.toString(), string, string2, "MR_DELETING_A_VIRTUAL_DRIVE_WITH_SSD_CACHING_ENABLED");
        operationDetails.setForceClear(blArray[0]);
        return blArray[1];
    }

    public boolean isBlockedDueToSSCDOffline() {
        return !this.isControllerIntegratedRaidType() && !this.isSSCD() && this.ldParam.getCurrentAccessPolicy() == 3 && this.ldProp.getaccessPolicy() != '\u0003' && this.ldParam.getAccessPolicyStatus() == 1;
    }

    public boolean isBlockedDueToPeerUnavailability() {
        return this.ldParam.getCurrentAccessPolicy() == 3 && this.ldProp.getaccessPolicy() != '\u0003' && this.ldParam.getAccessPolicyStatus() == 2;
    }

    public String getSSCDShortText() {
        if (this.isCSACacheCade()) {
            return Resource.getString("CSA_CACHECADE_VIRTUAL_DRIVE_TEXT", "Nytro\u2122 Cache Drive") + " " + this.ldrive.getID();
        }
        return Resource.getString("SSCD_TEXT", "CacheCade\u2122 Virtual Drive") + " " + this.ldrive.getID();
    }

    public MR_LD_INFO getInformation() {
        return this.ldInfo;
    }

    public String getWWID() {
        String string = new String(this.ldInfo.getlogicalVPDPage83());
        if (string != null && !string.trim().equals("")) {
            return string.trim();
        }
        return "";
    }

    public boolean isCSACacheCade() {
        if (!this.isSSCD()) {
            return false;
        }
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPDListInLd();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getmediaType() != '\u0002') continue;
            return true;
        }
        return false;
    }

    public ArrayList getCSACacheCadePropList() {
        PropertyInfo propertyInfo;
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        arrayList.add(propertyInfo2);
        if (this.ldrive.getName().length() > 0) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROPERTY_CSA_CACHECADE_NAME_TEXT", "Nytro\u2122 Cache Drive Name");
            propertyInfo.value = this.ldrive.getName();
            propertyInfo.description = Resource.getString("PROPERTY_CSA_CACHECADE_NAME_TEXT", "Nytro\u2122 Cache Drive Name");
            arrayList.add(propertyInfo);
        }
        propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROP_CACHECADE_STATE", "State");
        propertyInfo.value = this.getState();
        propertyInfo.description = Resource.getString("PROP_CACHECADE_STATE", "State");
        arrayList.add(propertyInfo);
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_RAIDLEVEL_TEXT", "RAID Level");
        propertyInfo3.value = this.getRaidLevelString();
        propertyInfo3.description = Resource.getString("PROPERTY_RAIDLEVEL_TEXT", "RAID Level");
        arrayList.add(propertyInfo3);
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROPERTY_LDRIVESIZE_TEXT", "Size");
        propertyInfo4.value = KernelConstants.getConvertedSize(this.ldInfo.getsize());
        propertyInfo4.description = Resource.getString("PROPERTY_LDRIVESIZE_TEXT", "Size");
        arrayList.add(propertyInfo4);
        PropertyInfo propertyInfo5 = new PropertyInfo();
        propertyInfo5.name = Resource.getString("PROP_WPOLICY", "<html><b>Write Policy:</b></html>");
        arrayList.add(propertyInfo5);
        PropertyInfo propertyInfo6 = new PropertyInfo();
        propertyInfo6.name = Resource.getString("PROPERTY_CURWRITEPOLICY_TEXT", "Current Write Policy");
        switch (this.ldrive.getWritePolicy()) {
            case 1: {
                propertyInfo6.value = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                break;
            }
            case 0: {
                propertyInfo6.value = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                break;
            }
            case 17: {
                propertyInfo6.value = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back");
                break;
            }
            default: {
                propertyInfo6.value = "";
            }
        }
        propertyInfo6.description = Resource.getString("PROPERTY_CURWRITEPOLICY_TEXT", "Current Write Policy");
        arrayList.add(propertyInfo6);
        PropertyInfo propertyInfo7 = new PropertyInfo();
        propertyInfo7.name = Resource.getString("PROPERTY_WRITEPOLICY_TEXT", "Write Policy");
        switch (this.ldrive.getDefaultWritePolicy()) {
            case 1: {
                propertyInfo7.value = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                break;
            }
            case 0: {
                propertyInfo7.value = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                break;
            }
            case 17: {
                propertyInfo7.value = Resource.getString("CACHECADE_ALWAYS_WRITE_BACK", "Always Write Back");
                break;
            }
            default: {
                propertyInfo7.value = "";
            }
        }
        propertyInfo7.description = Resource.getString("PROPERTY_WRITEPOLICY_TEXT", "Default Write Policy");
        arrayList.add(propertyInfo7);
        ArrayList<LogicalDriveHelper> arrayList2 = this.getLdsAssociatedToSSCD();
        if (arrayList2 != null && arrayList2.size() > 0) {
            PropertyInfo propertyInfo8 = new PropertyInfo();
            propertyInfo8.name = Resource.getString("PROP_ASSOCIATE_VD", "<html><b>Associated Virtual Drive(s):</b></html>");
            arrayList.add(propertyInfo8);
            for (int n = 0; n < arrayList2.size(); n = (int)((byte)(n + 1))) {
                PropertyInfo propertyInfo9 = new PropertyInfo();
                propertyInfo9.name = arrayList2.get(n).getText();
                propertyInfo9.value = " ";
                propertyInfo9.description = arrayList2.get(n).getText();
                arrayList.add(propertyInfo9);
            }
        }
        return arrayList;
    }
}

