/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASPhysical.SASPhysicalDriveOperationsAllowed;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class OperationProgressBar
extends JPanel
implements Observer {
    private GUIHelperInterface helper;
    private ProgressInfo info;
    private JPanel timePanel;
    private JLabel elapsedTime;
    private JLabel estimatedTime;
    private JPanel progPanel;
    GridBagConstraints gbc;
    private JLabel opName;
    private JProgressBar pBar;
    private JButton abortButton;
    private JButton suspendButton;
    private JButton resumeButton;
    private JButton suspendorresumeButton;
    private boolean fullAccess;
    public static boolean temp = true;
    public static boolean m_paused = false;
    public static boolean m_suspendOperationAllowed = false;
    public static boolean m_resumeOperationAllowed = false;

    public OperationProgressBar(GUIHelperInterface gUIHelperInterface) {
        String string;
        block5: {
            this.timePanel = new JPanel(new GridLayout(2, 1, 0, 0));
            this.progPanel = new JPanel();
            this.gbc = new GridBagConstraints();
            this.opName = new JLabel();
            this.pBar = new JProgressBar(0, 100);
            this.abortButton = new JButton(Resource.getString("BUTTON_ABORT_TEXT", "Abort"));
            this.suspendButton = new JButton(Resource.getString("BUTTON_SUSPEND_TEXT", "Suspend"));
            this.resumeButton = new JButton(Resource.getString("BUTTON_RESUME_TEXT", "Resume"));
            this.fullAccess = false;
            this.helper = gUIHelperInterface;
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.progPanel.setOpaque(false);
            this.progPanel.add(this.opName);
            this.pBar.setStringPainted(true);
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gbc.anchor = 11;
            this.add((Component)this.progPanel, this.gbc);
            string = null;
            this.fullAccess = MainFrame.fullAccess;
            if (this.helper instanceof PhysicalDriveHelper) {
                try {
                    if (this.helper.getProgressInfo().opCode == 34275584) {
                        string = ((PhysicalDriveHelper)this.helper).getCopyBackPDText();
                        break block5;
                    }
                    string = ((PhysicalDriveHelper)this.helper).getText(true);
                }
                catch (Exception exception) {
                    string = ((PhysicalDriveHelper)this.helper).getText(true);
                }
            } else {
                string = this.helper.getText();
            }
        }
        this.setBorder(BorderFactory.createTitledBorder(string));
        this.setToolTipText(string);
        this.refresh();
        ((Observable)((Object)this.helper)).addObserver(this);
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CustomMsgBox.confirm(Resource.getString("MSG_ABORTPROG_CONFIRM", "Do you want to abort this operation ?"))) {
                    return;
                }
                OperationProgressBar.this.kill();
            }
        });
        this.suspendButton.setVisible(this.fullAccess);
        this.suspendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CustomMsgBox.confirm(Resource.getString("MSG_SUSPEND_PROG_CONFIRM", "Do you want to Suspend this operation ?"))) {
                    return;
                }
                OperationProgressBar.this.suspendresume(false);
            }
        });
        this.resumeButton.setVisible(this.fullAccess);
        this.resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CustomMsgBox.confirm(Resource.getString("MSG_RESUMEPROG_CONFIRM", "Do you want to Resume this operation ?"))) {
                    return;
                }
                OperationProgressBar.this.suspendresume(true);
            }
        });
    }

    public boolean canKill() {
        return this.info.abortOpCode != -1 && this.info.opCode != 12 && this.abortButton != null && this.helper.isOperationAllowed(this.info.abortOpCode);
    }

    public void kill() {
        if (!this.canKill()) {
            if (this.info.text != null) {
                new CustomMsgBox(this.info.text + " " + Resource.getString("MSG_CANNOT_ABORT", "can not be aborted !"));
            } else {
                new CustomMsgBox(Resource.getString("MSG_CANNOT_ABORT_OP", "The operation can not be aborted !"));
            }
            return;
        }
        this.busy();
        OperationDetails operationDetails = new OperationDetails(this.info.abortOpCode, null);
        this.helper.issueOperation(operationDetails);
        ((Observable)((Object)this.helper)).deleteObserver(this);
        this.ready();
    }

    public boolean cansuspendresumeall() {
        return this.info.opCode != 12 && this.resumeButton != null && this.suspendButton != null;
    }

    public void PRprogRemove() {
        if (this.helper instanceof PhysicalDriveHelper && ((SASPhysicalDrive)this.helper.getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() == 1) {
            this.removeProgforPR();
        }
    }

    public void PRprogAdd() {
        if (this.helper instanceof PhysicalDriveHelper && ((SASPhysicalDrive)this.helper.getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() == 1) {
            this.addProgforPR();
        }
    }

    public void suspendresume(boolean bl) {
        if (this.helper instanceof LogicalDriveHelper) {
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.helper.getDeviceObject();
            if (this.checkIfPaused()) {
                if (this.info.opCode == 51511808) {
                    sASLogicalDrive.suspendcc(bl);
                } else if (this.info.opCode == 51511552) {
                    sASLogicalDrive.suspendRecon(bl);
                }
            } else if (this.info.opCode == 6 || this.info.opCode == 9) {
                sASLogicalDrive.suspendcc(bl);
            } else if (this.info.opCode == 12) {
                sASLogicalDrive.suspendRecon(bl);
            }
        } else if (this.helper instanceof PhysicalDriveHelper) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.helper.getDeviceObject();
            if (this.checkIfPaused()) {
                if (this.info.opCode == 0x20E0200) {
                    sASPhysicalDrive.suspendCopyback(bl);
                } else if (this.info.opCode == 34472192) {
                    sASPhysicalDrive.suspendRebuild(bl);
                }
            } else if (this.info.opCode == 34275584) {
                sASPhysicalDrive.suspendCopyback(bl);
            } else if (this.info.opCode == 5) {
                sASPhysicalDrive.suspendRebuild(bl);
            }
        }
    }

    private synchronized void refresh() {
        try {
            this.info = this.helper.getProgressInfo();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.setVisible(false);
            return;
        }
        SASAdapter sASAdapter = (SASAdapter)this.helper.getDeviceObject().parent();
        int n = sASAdapter.getInformation().getadapterOperationsEx_MR_CTRL_INFO().getSupportPointInTimeProgress();
        if (this.info.state) {
            this.progPanel.remove(this.pBar);
        } else {
            this.progPanel.add(this.pBar);
        }
        this.opName.setText(this.info.text);
        this.pBar.setValue((int)this.info.value);
        this.pBar.setToolTipText(this.info.value + " %");
        if (!this.info.state) {
            if (this.info.estimatedSecs > 0) {
                if (this.elapsedTime == null && this.estimatedTime == null) {
                    this.timePanel.setOpaque(false);
                    JPanel jPanel = new JPanel();
                    jPanel.setOpaque(false);
                    if (n != 1) {
                        this.elapsedTime = new JLabel();
                        jPanel.add(this.elapsedTime);
                        this.timePanel.add(jPanel);
                    }
                    JPanel jPanel2 = new JPanel();
                    jPanel2.setOpaque(false);
                    this.estimatedTime = new JLabel();
                    jPanel2.add(this.estimatedTime);
                    this.timePanel.add(jPanel2);
                    this.gbc.gridx = 0;
                    this.gbc.gridy = 1;
                    this.add((Component)this.timePanel, this.gbc);
                }
                if (n != 1) {
                    this.elapsedTime.setText(Resource.getString("LABEL_ELAPSED_TEXT", "Elapsed time : ") + this.timeToText(this.info.elapsedSecs));
                }
                this.estimatedTime.setText(Resource.getString("LABEL_ESTIMATED_TEXT", "Estimated time left : ") + this.timeToText(this.info.estimatedSecs));
            }
        } else {
            this.remove(this.timePanel);
        }
        if (this.checkIfAbortOperationAllowed()) {
            this.abortButton.setVisible(this.fullAccess);
            this.progPanel.add(this.abortButton);
        } else {
            this.progPanel.remove(this.abortButton);
        }
        if (((AdapterHelper)this.helper.getParent()).getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0 && this.info.opCode != 12) {
            m_paused = this.checkIfPaused();
            m_suspendOperationAllowed = this.checkIfSuspendOperationAllowed();
            m_resumeOperationAllowed = this.checkIfResumeOperationAllowed();
            if (m_paused) {
                if (m_resumeOperationAllowed) {
                    this.progPanel.add(this.resumeButton);
                    this.progPanel.remove(this.suspendButton);
                }
            } else if (m_suspendOperationAllowed) {
                this.progPanel.add(this.suspendButton);
                this.progPanel.remove(this.resumeButton);
            }
        }
        this.validate();
        this.repaint();
    }

    private boolean checkIfAbortOperationAllowed() {
        boolean bl = true;
        try {
            if (this.helper.getType() == 3) {
                bl = ((SASLogicalDrive)this.helper.getDeviceObject()).getAllAllowedOperations().isOperationAllowed((short)this.info.abortOpCode);
            } else if (this.helper.getType() == 2) {
                bl = ((SASPhysicalDrive)this.helper.getDeviceObject()).getAllAllowedOperations().isOperationAllowed((short)this.info.abortOpCode);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return this.info.abortOpCode != -1 && this.info.opCode != 12 && this.helper.isOperationAllowed(this.info.abortOpCode) && bl;
    }

    private boolean checkIfResumeOperationAllowed() {
        if (this.helper instanceof LogicalDriveHelper) {
            SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
            try {
                sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.helper.getDeviceObject()).getAllAllowedOperations();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                vKInvalidOperationException.printStackTrace();
            }
            catch (VKNotRespondingException vKNotRespondingException) {
                vKNotRespondingException.printStackTrace();
            }
            if (sASLogicalDriveOperationsAllowed.isresumeCCBGI()) {
                return true;
            }
        } else if (this.helper instanceof PhysicalDriveHelper) {
            SASPhysicalDriveOperationsAllowed sASPhysicalDriveOperationsAllowed = null;
            try {
                sASPhysicalDriveOperationsAllowed = ((SASPhysicalDrive)this.helper.getDeviceObject()).getAllAllowedOperations();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                vKInvalidOperationException.printStackTrace();
            }
            catch (VKNotRespondingException vKNotRespondingException) {
                vKNotRespondingException.printStackTrace();
            }
            if (sASPhysicalDriveOperationsAllowed.isResumeCopyback()) {
                return true;
            }
            if (sASPhysicalDriveOperationsAllowed.isResumeRebuild()) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIfSuspendOperationAllowed() {
        if (this.helper instanceof LogicalDriveHelper) {
            SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
            try {
                sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.helper.getDeviceObject()).getAllAllowedOperations();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                vKInvalidOperationException.printStackTrace();
            }
            catch (VKNotRespondingException vKNotRespondingException) {
                vKNotRespondingException.printStackTrace();
            }
            if (sASLogicalDriveOperationsAllowed.issuspendCCBGI()) {
                return true;
            }
        } else if (this.helper instanceof PhysicalDriveHelper) {
            SASPhysicalDriveOperationsAllowed sASPhysicalDriveOperationsAllowed = null;
            try {
                sASPhysicalDriveOperationsAllowed = ((SASPhysicalDrive)this.helper.getDeviceObject()).getAllAllowedOperations();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                vKInvalidOperationException.printStackTrace();
            }
            catch (VKNotRespondingException vKNotRespondingException) {
                vKNotRespondingException.printStackTrace();
            }
            if (sASPhysicalDriveOperationsAllowed.isSuspendCopyback()) {
                return true;
            }
            if (sASPhysicalDriveOperationsAllowed.isSuspendRebuild()) {
                return true;
            }
        }
        return false;
    }

    public boolean checkIfPaused() {
        return this.info.state;
    }

    public void busy() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void ready() {
        this.setCursor(Cursor.getDefaultCursor());
        this.setEnabled(true);
    }

    public String timeToText(int n) {
        if (VivaldiStartupDialog.OEM_TYPE == 2561) {
            if (n >= 0) {
                DecimalFormat decimalFormat = new DecimalFormat("00");
                if (n / 86400 > 0) {
                    int n2 = n / 86400;
                    return n2 + ":" + decimalFormat.format((n %= 86400) / 3600) + ":" + decimalFormat.format(n % 3600 / 60) + ":" + decimalFormat.format(n % 60);
                }
                return decimalFormat.format(n / 3600) + ":" + decimalFormat.format(n % 3600 / 60) + ":" + decimalFormat.format(n % 60);
            }
            return "";
        }
        if (n >= 0) {
            String string = "";
            if (n / 86400 > 0) {
                string = string + n / 86400 + Resource.getString("TXT_PROGRESS_DAYS ", " Day(s) ");
                n %= 86400;
            }
            if (n / 3600 > 0) {
                string = string + n / 3600 + Resource.getString("TXT_PROGRESS_HRS", " Hours ");
            }
            if (n % 3600 / 60 > 0) {
                string = string + n % 3600 / 60 + Resource.getString("TXT_PROGRESS_MIN", " Mins ");
            }
            if (n % 60 > 0) {
                string = string + n % 60 + Resource.getString("TXT_PROGRESS_SEC", " Secs ");
            }
            return string;
        }
        return "";
    }

    public void remove() {
        if (this.helper instanceof LogicalDriveHelper) {
            ((LogicalDriveHelper)this.helper).deleteObserver(this);
        } else if (this.helper instanceof PhysicalDriveHelper) {
            ((PhysicalDriveHelper)this.helper).deleteObserver(this);
        }
        this.pBar.setValue(0);
        this.pBar.setVisible(false);
    }

    public void removeSuspendButton() {
        this.progPanel.remove(this.pBar);
        this.progPanel.remove(this.suspendButton);
        this.remove(this.timePanel);
        try {
            this.info = this.helper.getProgressInfo();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.setVisible(false);
            return;
        }
        this.opName.setText(this.info.text + ":");
        if (this.checkIfAbortOperationAllowed()) {
            this.progPanel.add(this.abortButton);
        } else {
            this.progPanel.remove(this.abortButton);
        }
        m_paused = this.checkIfPaused();
        m_resumeOperationAllowed = this.checkIfResumeOperationAllowed();
        if (m_paused && m_resumeOperationAllowed) {
            this.progPanel.add(this.resumeButton);
        }
        this.abortButton.setVisible(true);
        this.resumeButton.setVisible(true);
        this.updateUI();
        this.validate();
        this.repaint();
    }

    public void removeResumeButton() {
        this.progPanel.remove(this.resumeButton);
        try {
            this.info = this.helper.getProgressInfo();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.setVisible(false);
            return;
        }
        this.opName.setText(this.info.text);
        this.progPanel.add(this.pBar);
        if (this.checkIfAbortOperationAllowed()) {
            this.progPanel.add(this.abortButton);
        } else {
            this.progPanel.remove(this.abortButton);
        }
        m_paused = this.checkIfPaused();
        m_suspendOperationAllowed = this.checkIfSuspendOperationAllowed();
        if (!m_paused && m_suspendOperationAllowed) {
            this.progPanel.add(this.suspendButton);
        }
        this.suspendButton.setVisible(true);
        this.add((Component)this.timePanel, this.gbc);
        this.updateUI();
        this.validate();
        this.repaint();
    }

    public void removeProgforPR() {
        this.progPanel.remove(this.pBar);
        this.remove(this.timePanel);
        try {
            this.info = this.helper.getProgressInfo();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.setVisible(false);
            return;
        }
        this.opName.setText(Resource.getString("PATROL_PAUSED", "Patrol Read has been suspended"));
        this.updateUI();
        this.validate();
        this.repaint();
    }

    public void addProgforPR() {
        try {
            this.info = this.helper.getProgressInfo();
            this.setVisible(true);
        }
        catch (Exception exception) {
            this.setVisible(false);
            return;
        }
        this.opName.setText(this.info.text);
        this.progPanel.add(this.pBar);
        this.add((Component)this.timePanel, this.gbc);
        this.updateUI();
        this.validate();
        this.repaint();
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        block0 : switch (mR_EVT_DETAIL.getargType()) {
            case '\u0007': 
            case '\u000e': {
                this.refresh();
                break;
            }
            default: {
                switch (mR_EVT_DETAIL.getcode()) {
                    case 407: 
                    case 409: 
                    case 411: 
                    case 412: 
                    case 413: {
                        this.removeSuspendButton();
                        break block0;
                    }
                    case 78: 
                    case 104: 
                    case 280: 
                    case 408: 
                    case 410: {
                        this.removeResumeButton();
                        break block0;
                    }
                    case 114: {
                        if (this.helper.getType() != 2 || ((SASPhysicalDrive)this.helper.getDeviceObject()).getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() != 1) break block0;
                        this.removeResumeButton();
                        break block0;
                    }
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 419: {
                        break block0;
                    }
                }
            }
        }
    }
}

