/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.VivaldiStartupDialog;
import GUI.security.ConfirmSecureEraseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PD_PROGRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_SMART_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTORS;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTOR_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SL_SCSI_PASSTHRU_T;
import SASKernel.LibraryAPI.StoreLib.pci_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.properties_MR_PD_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASEnclosure;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASPhysical.SASPhysicalDriveOperationsAllowed;
import SASKernel.SASServer;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.DoubleIcons;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class PhysicalDriveHelper
extends Observable
implements GUIHelperInterface {
    private short deviceID;
    private AdapterHelper parent;
    private MR_PD_INFO pdInfo;
    private int enclosureID;
    private SASPhysicalDrive phDevice;
    private SASPhysicalDriveOperationsAllowed allowedOp;
    private OperationDetails tempOPD = null;
    private EnclosureHelper enclosureHelper = null;
    private MR_CTRL_INFO adapterInfo;
    private MR_CTRL_PROP adapterProperties;
    private SASAdapter sasAdapter;
    private boolean m_isDedicatedHotSpare = false;
    private ArrayHelper m_arrayHelper = null;
    MR_PD_SMART_INFO m_objSMARTInfo;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Physical Drive");
    private int m_opList_size = 0;

    public PhysicalDriveHelper(SASPhysicalDrive sASPhysicalDrive, AdapterHelper adapterHelper) {
        this.phDevice = sASPhysicalDrive;
        this.deviceID = sASPhysicalDrive.getDeviceId();
        this.parent = adapterHelper;
        this.pdInfo = sASPhysicalDrive.getInformation();
        short s = this.pdInfo.getenclDeviceId();
        short s2 = this.pdInfo.getenclPartnerDeviceId();
        EnclosureHelper[] enclosureHelperArray = this.parent.getEnclosures();
        for (int i = 0; i < enclosureHelperArray.length; ++i) {
            SASEnclosure sASEnclosure = (SASEnclosure)enclosureHelperArray[i].getDeviceObject();
            if (sASEnclosure.getInformation().getenclDeviceId() == s) {
                this.enclosureHelper = enclosureHelperArray[i];
                this.enclosureID = s;
                break;
            }
            if (s2 == -1 || sASEnclosure.getInformation().getenclDeviceId() != s2) continue;
            this.enclosureHelper = enclosureHelperArray[i];
            this.enclosureID = s2;
            break;
        }
        if (this.enclosureHelper == null) {
            this.enclosureID = s;
        }
        sASPhysicalDrive.addObserver(this);
    }

    public EnclosureHelper getEnclosureHelper() {
        return this.enclosureHelper;
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.phDevice;
    }

    public MR_PD_INFO getInformation() {
        return this.pdInfo;
    }

    public short getDeviceID() {
        return this.deviceID;
    }

    public int getConnectorIndex() {
        int n = 0;
        if (this.parent.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportMultipath() != 0) {
            byte[] byArray = this.phDevice.getInformation().getpathInfo_MR_PD_INFO1().getconnectorIndex();
            if (byArray[0] != -1) {
                n = byArray[0];
            } else if (byArray[1] != -1) {
                n = byArray[1];
            }
        } else if (this.enclosureHelper != null) {
            n = ((SASEnclosure)this.enclosureHelper.getDeviceObject()).getStatusInformation().getenclConnectorIndex();
        }
        return n;
    }

    public String getConnectorname() {
        MR_SAS_CONNECTOR_INFO[] mR_SAS_CONNECTOR_INFOArray;
        Object object;
        String string = null;
        Object object2 = '\u0000';
        if (this.parent.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getsupportMultipath() == 0) {
            if (this.enclosureHelper != null) {
                object2 = ((SASEnclosure)this.enclosureHelper.getDeviceObject()).getStatusInformation().getenclConnectorIndex();
            }
        } else {
            if (this.enclosureHelper != null && this.enclosureHelper.isMultiPath()) {
                return this.enclosureHelper.getConnectorNameText();
            }
            object = this.phDevice.getInformation().getpathInfo_MR_PD_INFO1().getconnectorIndex();
            if (object[0] != -1) {
                object2 = object[0];
            } else if (object[1] != -1) {
                object2 = object[1];
            }
        }
        if ((object = ((SASAdapter)this.parent.getDeviceObject()).getConnector()) != null && (mR_SAS_CONNECTOR_INFOArray = ((MR_SAS_CONNECTORS)object).getConnectors()) != null) {
            string = object2 < mR_SAS_CONNECTOR_INFOArray.length ? Resource.zeroTrim(mR_SAS_CONNECTOR_INFOArray[object2].getName()) : (object2 == 65535 ? Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal") : Resource.getString("PDTYPE_UNKNOWN", "Unknown"));
        }
        return string;
    }

    public String getenclLocation() {
        MR_SAS_CONNECTOR_INFO[] mR_SAS_CONNECTOR_INFOArray;
        String string = null;
        byte by = 0;
        int n = this.getConnectorIndex();
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = ((SASAdapter)this.parent.getDeviceObject()).getConnector();
        if (mR_SAS_CONNECTORS != null && (mR_SAS_CONNECTOR_INFOArray = mR_SAS_CONNECTORS.getConnectors()) != null) {
            if (n < mR_SAS_CONNECTOR_INFOArray.length) {
                by = mR_SAS_CONNECTOR_INFOArray[n].getLocation();
                if (by == 0) {
                    string = Resource.getString("PDTYPE_UNKNOWN", "Unknown");
                } else if (by == 2) {
                    string = Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal");
                } else if (by == 3) {
                    string = Resource.getString("PROPERTY_MUXMODE_EXT_TEXT", "External");
                }
            } else {
                string = n == 65535 ? Resource.getString("PROPERTY_MUXMODE_INT_TEXT", "Internal") : Resource.getString("PDTYPE_UNKNOWN", "Unknown");
            }
        }
        return string;
    }

    public String getPosition() {
        String string = "";
        if (this.enclosureHelper != null) {
            string = "" + ((SASEnclosure)this.enclosureHelper.getDeviceObject()).getStatusInformation().getenclPosition();
        }
        return string;
    }

    public String getPDDriveType() {
        String string = null;
        switch (this.phDevice.getDriveType()) {
            case 1: {
                string = Resource.getString("PDTYPE_SCSI", "SCSI");
                break;
            }
            case 3: {
                string = Resource.getString("PDTYPE_SATA", "SATA");
                break;
            }
            case 2: {
                string = Resource.getString("PDTYPE_SAS", "SAS");
                break;
            }
            case 4: {
                string = Resource.getString("PDTYPE_FC", "Fibre Channel");
                break;
            }
            default: {
                string = Resource.getString("PDTYPE_UNKNOWN", "Unknown");
            }
        }
        return string;
    }

    public byte getPdType() {
        return this.phDevice.getDriveType();
    }

    public short getUserDataBlockSize() {
        return this.phDevice.getInformation().getUserDataBlockSize();
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.phDevice.getInformation().getslotNumber();
        short s = this.pdInfo.getUserDataBlockSize();
        stringBuffer.append(Resource.getString("ENCL_SLOT_TEXT", "Slot"));
        stringBuffer.append(": ");
        stringBuffer.append((int)c);
        stringBuffer.append(", ");
        if (this.pdInfo.getmediatype() == '\u0001') {
            stringBuffer.append(Resource.getString("SSD_TEXT", "SSD"));
            stringBuffer.append(" (");
            stringBuffer.append(this.getPDDriveType());
            stringBuffer.append(")");
        } else if (this.pdInfo.getmediatype() == '\u0002') {
            stringBuffer.append(Resource.getString("DFF_TEXT", "Nytro Flash Module"));
            stringBuffer.append(" (");
            stringBuffer.append(this.getPDDriveType());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.getPDDriveType());
        }
        stringBuffer.append(", ");
        stringBuffer.append(KernelConstants.getConvertedSize(this.pdInfo.getrawSize(), this.getUserDataBlockSize()));
        stringBuffer.append(", ");
        stringBuffer.append(this.stateInfo());
        stringBuffer.append(this.getState());
        if (s == 4096) {
            stringBuffer.append(",");
            stringBuffer.append("(4 KB)");
        } else {
            stringBuffer.append(",");
            stringBuffer.append("(512 B)");
        }
        String string = this.getPowerState();
        if (!string.equalsIgnoreCase("")) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getText(boolean bl) {
        if (bl) {
            SASEnclosure sASEnclosure;
            StringBuffer stringBuffer = new StringBuffer();
            SASEnclosure sASEnclosure2 = sASEnclosure = this.enclosureHelper != null ? (SASEnclosure)this.enclosureHelper.getDeviceObject() : null;
            if (sASEnclosure != null) {
                if (this.enclosureHelper.isBackplane()) {
                    stringBuffer.append(Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane"));
                    String string = this.enclosureHelper.getBackplaneIdentifier();
                    if (string != null) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(", ");
                } else if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                    stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                    stringBuffer.append(": ");
                    stringBuffer.append(sASEnclosure.getProductInfo());
                    stringBuffer.append(" (");
                    stringBuffer.append(sASEnclosure.getDeviceId());
                    stringBuffer.append("), ");
                } else {
                    stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                    stringBuffer.append(" (");
                    stringBuffer.append(sASEnclosure.getDeviceId());
                    stringBuffer.append("), ");
                }
            }
            char c = this.phDevice.getInformation().getslotNumber();
            short s = this.pdInfo.getUserDataBlockSize();
            stringBuffer.append(Resource.getString("ENCL_SLOT_TEXT", "Slot"));
            stringBuffer.append(": ");
            stringBuffer.append((int)c);
            stringBuffer.append(", ");
            if (this.pdInfo.getmediatype() == '\u0001') {
                stringBuffer.append(Resource.getString("SSD_TEXT", "SSD"));
                stringBuffer.append(" (");
                stringBuffer.append(this.getPDDriveType());
                stringBuffer.append(")");
            } else if (this.pdInfo.getmediatype() == '\u0002') {
                stringBuffer.append(Resource.getString("DFF_TEXT", "Nytro Flash Module"));
                stringBuffer.append(" (");
                stringBuffer.append(this.getPDDriveType());
                stringBuffer.append(")");
            } else {
                stringBuffer.append(this.getPDDriveType());
            }
            stringBuffer.append(", ");
            stringBuffer.append(KernelConstants.getConvertedSize(this.pdInfo.getrawSize(), this.getUserDataBlockSize()));
            stringBuffer.append(", ");
            stringBuffer.append(this.stateInfo());
            stringBuffer.append(this.getState());
            if (s == 4096) {
                stringBuffer.append(",");
                stringBuffer.append("(4 KB)");
            } else {
                stringBuffer.append(",");
                stringBuffer.append("(512 B)");
            }
            String string = this.getPowerState();
            if (!string.equalsIgnoreCase("")) {
                stringBuffer.append(" - ");
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return this.getText();
    }

    public String getPowerState() {
        if (this.pdInfo.getdisabledForRemoval() == '\u0001') {
            return Resource.getString("PROPERTY_READY_TO_REMOVE", "Ready To Remove");
        }
        if (this.pdInfo.getPowerState() == 1) {
            return Resource.getString("PROPERTY_POWER_SAVE", "Powersave");
        }
        return "";
    }

    public StringBuffer getTextForeign() {
        SASEnclosure sASEnclosure;
        StringBuffer stringBuffer = new StringBuffer();
        SASEnclosure sASEnclosure2 = sASEnclosure = this.enclosureHelper != null ? (SASEnclosure)this.enclosureHelper.getDeviceObject() : null;
        if (sASEnclosure != null) {
            if (this.enclosureHelper.isBackplane()) {
                stringBuffer.append(Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane"));
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            } else if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                stringBuffer.append(": ");
                stringBuffer.append(sASEnclosure.getProductInfo());
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            } else {
                stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            }
        }
        char c = this.phDevice.getInformation().getslotNumber();
        stringBuffer.append(Resource.getString("ENCL_SLOT_TEXT", "Slot"));
        stringBuffer.append(": ");
        stringBuffer.append((int)c);
        stringBuffer.append(", ");
        if (this.pdInfo.getmediatype() == '\u0001') {
            stringBuffer.append(Resource.getString("SSD_TEXT", "SSD"));
            stringBuffer.append(" (");
            stringBuffer.append(this.getPDDriveType());
            stringBuffer.append(")");
        } else if (this.pdInfo.getmediatype() == '\u0002') {
            stringBuffer.append(Resource.getString("DFF_TEXT", "Nytro Flash Module"));
            stringBuffer.append(" (");
            stringBuffer.append(this.getPDDriveType());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.getPDDriveType());
        }
        stringBuffer.append(", ");
        stringBuffer.append(KernelConstants.getConvertedSize(this.pdInfo.getrawSize(), this.getUserDataBlockSize()));
        stringBuffer.append(", ");
        stringBuffer.append(this.stateInfo());
        return stringBuffer;
    }

    public String stateInfo() {
        pdType_MR_PD_INFO pdType_MR_PD_INFO2 = this.phDevice.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
        if (pdType_MR_PD_INFO2.getisForeign() == 1) {
            return "(" + Resource.getString("LABEL_FOREIGN_STATE_TEXT", "Foreign") + ") ";
        }
        return "";
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    private String getHotspareState() {
        String string = Resource.getString("PD_STATE_HOTSPARE", "Hot Spare");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        ArrayHelper[] arrayHelperArray = null;
        if (this.parent != null) {
            arrayHelperArray = this.parent.getArrays();
        }
        try {
            MR_SPARE[] mR_SPAREArray = ((SASAdapter)this.phDevice.parent()).readSpareInfo();
            for (int i = 0; i < mR_SPAREArray.length; ++i) {
                if (mR_SPAREArray[i].getref().getdeviceId() != this.phDevice.getDeviceId()) continue;
                string2 = mR_SPAREArray[i].getspareType_MR_SPARE1().getisDedicated() == '\u0001' ? Resource.getString("PD_STATE_HOTSPARE_DEDICATED", "Dedicated") : Resource.getString("PD_STATE_HOTSPARE_GLOBAL", "Global");
                string3 = mR_SPAREArray[i].getspareType_MR_SPARE1().getisEnclAffinity() != '\u0000' ? "(" + Resource.getString("PD_STATE_HOTSPARE_AFFINITY", "Affinity") + ")" : "";
                int n = 0;
                if (VivaldiStartupDialog.mainScreen != null) {
                    n = VivaldiStartupDialog.mainScreen.getSelectedView();
                }
                if (mR_SPAREArray[i].getspareType_MR_SPARE1().getisDedicated() == '\u0001' || n != 1 || this.m_arrayHelper == null) continue;
                long l = ((SASArray)this.m_arrayHelper.getDeviceObject()).getInformation().getsize();
                if (this.pdInfo.getrawSize() >= l) continue;
                string4 = Resource.getString("PD_STATE_HOTSPARE_UNUSABLE", "Unusable");
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = string2 + " " + string + " " + string4;
        return string;
    }

    public static String getHotspareType(SASPhysicalDrive sASPhysicalDrive) {
        String string = "";
        try {
            MR_SPARE[] mR_SPAREArray = ((SASAdapter)sASPhysicalDrive.parent()).readSpareInfo();
            for (int i = 0; i < mR_SPAREArray.length; ++i) {
                if (mR_SPAREArray[i].getref().getdeviceId() != sASPhysicalDrive.getDeviceId()) continue;
                string = mR_SPAREArray[i].getspareType_MR_SPARE1().getisDedicated() == '\u0001' ? Resource.getString("PD_STATE_HOTSPARE_DEDICATED", "Dedicated") : Resource.getString("PD_STATE_HOTSPARE_GLOBAL", "Global");
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string.trim();
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.pdInfo.getPowerState() == -1) {
            return new DoubleIcons(this.getImageIcon(this.getIcon(this.phDevice)), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("POWER_STATE_TRANSITIONING_IMAGE", "transitioning_icon.gif")))), 1);
        }
        if (this.pdInfo.getdisabledForRemoval() == '\u0001' || this.pdInfo.getPowerState() == 1) {
            return new DoubleIcons(this.getImageIcon(this.getIcon(this.phDevice)), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("POWER_SAVE_IMAGE", "psave.png")))), 1);
        }
        return this.getImageIcon(this.getIcon(this.phDevice));
    }

    public String getState() {
        short s = this.phDevice.getState();
        if (s == 17) {
            return Resource.getString("PD_STATE_FAILED", "Failed");
        }
        if (s == 2) {
            return this.getHotspareState();
        }
        if (s == 16) {
            return Resource.getString("PD_STATE_OFFLINE", "Offline");
        }
        if (s == 24) {
            return this.getCopyBackState();
        }
        if (s == 20) {
            return Resource.getString("PD_STATE_REBUILD", "Rebuild");
        }
        if (s == 1) {
            if (this.phDevice.getInformation().getnotSupported() == '\u0001') {
                return Resource.getString("PD_STATE_UNCONF_BAD_UNSUPPORTED", "Unconfigured Bad (Unsupported)");
            }
            return Resource.getString("PD_STATE_UNCONFBAD", "Unconfigured Bad");
        }
        if (s == 0) {
            if (this.phDevice.getInformation().getnotSupported() == '\u0001') {
                return Resource.getString("PD_STATE_UNCONF_GOOD_UNSUPPORTED", "Unconfigured Good (Unsupported)");
            }
            return Resource.getString("PD_STATE_UNCONFGOOD", "Unconfigured Good");
        }
        if (s == 32) {
            return this.getCopyBackState();
        }
        if (s == 64) {
            return Resource.getString("PD_STATE_SYSTEM", "System");
        }
        if (s == 144 || s == 192) {
            if (this.phDevice.getSMARTInfo().getLockedUp() != 0) {
                return "Configured - Shielded & Locked";
            }
            return Resource.getString("PD_STATE_SHIELD_CONFIGURED", "Configured - Shielded");
        }
        if (s == 130) {
            return Resource.getString("PD_STATE_SHIELD_HOTSPARE", "Hotspare - Shielded");
        }
        if (s == 128) {
            return Resource.getString("PD_STATE_SHIELD_UNCONFIGURED", "Unconfigured - Shielded");
        }
        return null;
    }

    public String getIcon(SASPhysicalDrive sASPhysicalDrive) {
        pdType_MR_PD_INFO pdType_MR_PD_INFO2 = sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
        boolean bl = sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable();
        if (sASPhysicalDrive.getInformation().getnotSupported() == '\u0001') {
            return Resource.getString("NON_CERTIFIED_DRIVE_IMAGE", "non_supported_pd.png");
        }
        if (pdType_MR_PD_INFO2.getisForeign() == 1) {
            return Resource.getString("FOREIGN_DRIVE_UNCONFIGURED_IMAGE", "foreign_drive_unconfigured.png");
        }
        if (sASPhysicalDrive.getState() == 2) {
            String string = PhysicalDriveHelper.getHotspareType(sASPhysicalDrive);
            if (string.equals(Resource.getString("PD_STATE_HOTSPARE_DEDICATED"))) {
                if (bl) {
                    return Resource.getString("HOTSPARE_FDE_IMAGE", "hotspare_fde.png");
                }
                return Resource.getString("HOTSPARE_IMAGE", "hotspare.png");
            }
            if (string.equals(Resource.getString("PD_STATE_HOTSPARE_GLOBAL"))) {
                if (bl) {
                    return Resource.getString("HOTSPARE_GLOBAL_FDE_IMAGE", "hotspare_global_fde.png");
                }
                return Resource.getString("HOTSPARE_GLOBAL_IMAGE", "hotspare_global.png");
            }
        } else {
            if (sASPhysicalDrive.getState() == 20) {
                return Resource.getString("REBUILD_IMAGE", "rebuild.png");
            }
            if (sASPhysicalDrive.getState() == 0 || sASPhysicalDrive.getState() == 1) {
                if (bl) {
                    return Resource.getString("DRIVE_FDE_UNLOCK_IMAGE", "fde_unlock.png");
                }
                return Resource.getString("UNCONFIGURED_IMAGE", "unconfigured.png");
            }
            if (sASPhysicalDrive.getState() == 24) {
                if (bl) {
                    if (this.isEncrypted()) {
                        return Resource.getString("DRIVE_FDE_LOCK_IMAGE", "fde_locked.png");
                    }
                    return Resource.getString("DRIVE_FDE_UNLOCK_IMAGE", "fde_unlock.png");
                }
                return Resource.getString("CONFIGURED_IMAGE", "configured.png");
            }
            if (sASPhysicalDrive.getState() == 16 || sASPhysicalDrive.getState() == 17 || sASPhysicalDrive.getState() == 1) {
                return Resource.getString("CONFIGURED_IMAGE", "configured.png");
            }
            if (sASPhysicalDrive.getState() == 64) {
                return Resource.getString("PHDRIVE_IMAGE", "phdrive.png");
            }
        }
        return Resource.getString("CONFIGURED_IMAGE", "configured.png");
    }

    @Override
    public ArrayList<OperationDetails> getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        try {
            this.phDevice.updateAllAllowedOperations();
            this.allowedOp = this.phDevice.getAllAllowedOperations();
        }
        catch (Exception exception) {
            System.out.println("Allowed Operation is not available !");
            exception.printStackTrace();
            return arrayList;
        }
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Comparable<Boolean> comparable = menuItemObj2.getParamKey().equals("NOVALUE") ? null : (menuItemObj2.getParamKey().equals("Boolean.TRUE") ? (Comparable<Boolean>)Boolean.TRUE : (Comparable<Boolean>)new Integer(menuItemObj2.getParamKeyInt()));
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, comparable);
            if (menuItemObj2.isSLCmd()) {
                this.addOperation(arrayList, operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        this.m_opList_size = arrayList.size();
        return arrayList;
    }

    private void addOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        byte by = ((SASAdapter)this.parent.getDeviceObject()).getAdapterType();
        if (operationDetails.getDescription() == Resource.getString("PHDRIVE_OPERATION_FORMAT_DESC", "Format Physical Drive")) {
            SASAdapter sASAdapter = (SASAdapter)this.parent.getDeviceObject();
            if (sASAdapter.isWarhawk()) {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
            return;
        }
        if (operationDetails.getOpcode() == 3) {
            if (this.isReplaceMisingDriveAllowed()) {
                operationDetails.setParameter(Boolean.TRUE);
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 20) {
            if (this.phDevice.getState() == 0 && this.parent.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getglobalHotSpares() != 0) {
                if (by == 3 || by == 4) {
                    operationDetails.setOpcode(10);
                    this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
                } else if (by == 2) {
                    if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                        pci_MR_CTRL_INFO pci_MR_CTRL_INFO2 = this.parent.getAdapterInfo().getpci_MR_CTRL_INFO();
                        if (pci_MR_CTRL_INFO2.getvendorId() == 4096 && pci_MR_CTRL_INFO2.getdevId() == 88 && pci_MR_CTRL_INFO2.getsubVendorId() == 4136 && (pci_MR_CTRL_INFO2.getsubDevId() == 541 || pci_MR_CTRL_INFO2.getsubDevId() == 7950)) {
                            operationDetails.setOpcode(10);
                            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
                        }
                    } else {
                        operationDetails.setOpcode(10);
                        this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
                    }
                } else {
                    operationDetails.setOpcode(10);
                    this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
                }
            }
        } else if (operationDetails.getOpcode() == 21) {
            if (this.phDevice.getState() == 0 && this.parent.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getdedicatedHotSpares() != 0 && VivaldiStartupDialog.OEM_TYPE != 2561) {
                operationDetails.setParameter(Boolean.TRUE);
                operationDetails.setOpcode(11);
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 14) {
            if (this.pdInfo.getdisabledForRemoval() != '\u0001' && this.pdInfo.getPowerState() != 1 && this.phDevice.getState() != 64) {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 15) {
            if (this.pdInfo.getdisabledForRemoval() == '\u0001') {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 33541 || operationDetails.getOpcode() == 33540) {
            byte by2 = ((SASServer)this.phDevice.parent().parent()).getInformation().getSystemType();
            if (VivaldiStartupDialog.OEM_TYPE == 2561 && by2 == 4) {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 19) {
            byte by3 = ((Integer)operationDetails.getParam()).byteValue();
            if (this.phDevice.getState() == 1 && by3 == 0) {
                arrayList.add(operationDetails);
                return;
            }
            if (this.phDevice.getState() == 0 && by3 == 1) {
                if (this.allowedOp.isMakeSystemSupported()) {
                    arrayList.add(operationDetails);
                    return;
                }
            } else if (this.phDevice.getState() == 64 && by3 == 2 && this.parent.getAdapterProperties().getOnOffProperties_MR_CTRL_PROP().getEnableJBOD() == 1) {
                if (this.parent.findunconfiguredAndOnlinePdCnt() < this.adapterInfo.getmaxConfigurablePds()) {
                    arrayList.add(operationDetails);
                }
                return;
            }
        } else if (operationDetails.getOpcode() == 34275584) {
            Vector vector;
            if (this.allowedOp.isOperationAllowed(34275584) && (vector = this.getEligibleCopyBackDrives()) != null && vector.size() > 0 && this.phDevice.getState() == 24 && ((SASAdapter)((SASPhysicalDrive)this.getDeviceObject()).parent()).getAdapterType() == 1) {
                this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
            }
        } else if (operationDetails.getOpcode() == 34341632) {
            if (this.allowedOp.isReprovisionAllowed()) {
                arrayList.add(operationDetails);
                return;
            }
            if (this.parent.isSecuritySupported() && this.pdInfo.getSecurity_MR_PD_INFO().getForeign() && this.pdInfo.getSecurity_MR_PD_INFO().getLocked()) {
                operationDetails.setOpcode(34341120);
                arrayList.add(operationDetails);
                return;
            }
        } else {
            this.checkAndAddSystemAllowedOperation(arrayList, operationDetails);
        }
    }

    public void checkAndAddSystemAllowedOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        try {
            if ((operationDetails.getOpcode() & 0x8000) == 32768) {
                if (this.phDevice.isKernelOperationAllowed(operationDetails.getOpcode())) {
                    arrayList.add(operationDetails);
                }
            } else if (this.allowedOp.isOperationAllowed(operationDetails.getOpcode())) {
                arrayList.add(operationDetails);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isOperationAllowed(int n) {
        Object object;
        SASAdapter sASAdapter = (SASAdapter)this.parent.getDeviceObject();
        if (sASAdapter.isWarhawk() && n == 0) {
            object = null;
            StringBuffer stringBuffer = null;
            stringBuffer = new StringBuffer(Resource.getString("MSG_FORMAT_TEXT3", "<html>You have chosen to format Physical Disk"));
            stringBuffer.append(" " + this.phDevice.getID() + ".  ");
            stringBuffer.append(Resource.getString("MSG_PD_FORMAT_WARNING", "All data<br> on the Physical disk will be lost"));
            stringBuffer.append(".<br><br>" + Resource.getString("MSG_FORMAT_TEXT4", "Are you sure you want to format Physical Disk") + " " + this.phDevice.getID() + "?</html>");
            object = Resource.getString("MSG_PD_FORMAT_CONFIRM_TITLE", "Confirm Format Physical Disk");
            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, (String)object, stringBuffer.toString())) {
                return false;
            }
        }
        if (n == 2) {
            if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_PDOFFLINE_CONFIRM", "Warning : This will make the Physical Drive Offline ! Are you sure ?"))) {
                return false;
            }
            if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_DATA_BAKUP", "It is advisable to backup data before this operation . Are you ready ?"))) {
                return false;
            }
        }
        if (n == 1 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_PDONLINE_CONFIRM", "Warning : Forcing a failed physical disk to Online will result in changing the virtual disk state.\nThis disk will immediately start participating in the virtual disk operations and may lead to data corruption.\n\nAre you sure you want to continue? "))) {
            return false;
        }
        if (n == 4 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_PDMISSING_CONFIRM", "Warning : This will mark the Physical Drive as Missing ! Are you sure ?"))) {
            return false;
        }
        if (n == 13 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_PDREMOVEHSP_CONFIRM", "Warning : This will remove the hotspare drive ! Are you sure ?"))) {
            return false;
        }
        if (n == 5 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_PDREBUILD_CONFIRM", "Warning : This will rebuild the Physical Drive ! Are you sure ?"))) {
            return false;
        }
        if (n == 34341632 || n == 34341120) {
            object = new ConfirmSecureEraseDialog(this);
            ((ConfirmSecureEraseDialog)object).buildUI();
            return ((VivaldiBaseOptionDialog)object).getSelectedOption() == 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void issueOperation(OperationDetails operationDetails) {
        if (operationDetails.getOpcode() != 11 && operationDetails.getOpcode() != 21 && operationDetails.getOpcode() == 19) {
            byte by = ((Integer)operationDetails.getParam()).byteValue();
            if (this.phDevice.getState() == 64 && by == 2 && this.isOSDrive(this.phDevice) && !CustomMsgBox.confirmWithCheck("This is an OS drive. Are you sure you want to continue?")) {
                return;
            }
        }
        try {
            VivaldiStartupDialog.mainScreen.busy();
            this.phDevice.fireOperation(operationDetails);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            switch (operationDetails.getOpcode()) {
                case 11: {
                    if (vKOperationFailedException.GetErrorCode() == 109) {
                        new CustomMsgBox(Resource.getString("MSG_DEDICATEDHSP_NOT_ALLOWED_HA", "A Dedicated Hot Spare can only be assigned to drive groups that possess a common VD."));
                        break;
                    }
                    new CustomMsgBox(Resource.getString("MSG_DEDICATEDHSP_FAILED", "Can not make dedicated hotspare : Error Code : ") + "0x" + vKOperationFailedException.GetErrorCode());
                    break;
                }
                case 0x4040000: {
                    if (((MR_SPARE)operationDetails.getParam()).getspareType_MR_SPARE1().getisDedicated() == '\u0001') {
                        operationDetails.setOpcode(21);
                    } else if (((MR_SPARE)operationDetails.getParam()).getspareType_MR_SPARE1().getisDedicated() == '\u0000') {
                        operationDetails.setOpcode(20);
                    }
                    CustomMsgBox.errorMsg(vKOperationFailedException);
                    break;
                }
                case 34275584: {
                    CustomMsgBox.errorMsg(vKOperationFailedException);
                    operationDetails.setParameter(vKOperationFailedException);
                    break;
                }
                default: {
                    String string = Resource.getString("MSG_UNKNOWN_ERROR", "Operation Failed") + " : ErrorCode = " + "0x" + Integer.toHexString(vKOperationFailedException.GetErrorCode());
                    new CustomMsgBox(string);
                }
            }
            vKOperationFailedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            VivaldiStartupDialog.mainScreen.ready();
        }
    }

    @Override
    public ProgressInfo getProgressInfo() {
        MR_PD_PROGRESS mR_PD_PROGRESS = this.pdInfo.getprogInfo();
        ProgressInfo progressInfo = new ProgressInfo();
        SASAdapter sASAdapter = (SASAdapter)this.parent.getDeviceObject();
        int n = sASAdapter.getInformation().getadapterOperationsEx_MR_CTRL_INFO().getSupportPointInTimeProgress();
        if (mR_PD_PROGRESS.getactive_MR_PD_PROGRESS1().getclear() == 1 && this.phDevice.getState() == 0) {
            progressInfo.value = mR_PD_PROGRESS.getclear().getprogress();
            progressInfo.text = Resource.getString("OPERATION_CLEAR_TEXT", "Clear");
            progressInfo.abortOpCode = -1;
            progressInfo.opCode = -1;
            if (n == 1) {
                float f = mR_PD_PROGRESS.getclear().getprogress();
                int n2 = mR_PD_PROGRESS.getclear().getelapsedSecs();
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getclear().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n2;
            } else {
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getclear().getelapsedSecs();
                progressInfo.estimatedSecs = mR_PD_PROGRESS.getclear().getEstimatedSecs();
            }
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getactive_MR_PD_PROGRESS1().getpatrol() == 1) {
            progressInfo.value = mR_PD_PROGRESS.getpatrol().getprogress();
            progressInfo.text = Resource.getString("OPERATION_PATROLREAD_TEXT", "Patrol Read");
            progressInfo.opCode = -1;
            progressInfo.abortOpCode = -1;
            if (n == 1) {
                float f = mR_PD_PROGRESS.getpatrol().getprogress();
                int n3 = mR_PD_PROGRESS.getpatrol().getelapsedSecs();
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getpatrol().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n3;
            } else {
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getpatrol().getelapsedSecs();
                progressInfo.estimatedSecs = mR_PD_PROGRESS.getpatrol().getEstimatedSecs();
            }
            if (this.parent.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0) {
                progressInfo.state = mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getpatrol();
                if (progressInfo.state) {
                    progressInfo.opCode = 17237504;
                    progressInfo.text = Resource.getString("PATROL_PAUSED", "Patrol Read has been suspended");
                }
            }
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getactive_MR_PD_PROGRESS1().getrbld() == 1) {
            progressInfo.opCode = 5;
            progressInfo.value = mR_PD_PROGRESS.getrbld().getprogress();
            progressInfo.text = Resource.getString("OPERATION_REBUILD_TEXT", "Rebuild");
            progressInfo.abortOpCode = 6;
            if (n == 1) {
                float f = mR_PD_PROGRESS.getrbld().getprogress();
                int n4 = mR_PD_PROGRESS.getrbld().getelapsedSecs();
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getrbld().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n4;
            } else {
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getrbld().getelapsedSecs();
                progressInfo.estimatedSecs = mR_PD_PROGRESS.getrbld().getEstimatedSecs();
            }
            if (this.parent.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0) {
                progressInfo.state = mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getrbld();
                if (progressInfo.state) {
                    progressInfo.opCode = 34472192;
                    progressInfo.text = Resource.getString("REBUILD_PAUSED", "Rebuild has been suspended");
                }
            }
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getactive_MR_PD_PROGRESS1().getCopyBack() != 0) {
            String string = this.getCopyBackState();
            progressInfo.opCode = 34275584;
            progressInfo.value = mR_PD_PROGRESS.getrbld().getprogress();
            progressInfo.text = string;
            progressInfo.abortOpCode = 0x20B0200;
            if (n == 1) {
                float f = mR_PD_PROGRESS.getrbld().getprogress();
                int n5 = mR_PD_PROGRESS.getrbld().getelapsedSecs();
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getrbld().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n5;
            } else {
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getrbld().getelapsedSecs();
                progressInfo.estimatedSecs = mR_PD_PROGRESS.getrbld().getEstimatedSecs();
            }
            if (this.parent.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0) {
                progressInfo.state = mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getCopyBack();
                if (progressInfo.state) {
                    progressInfo.opCode = 0x20E0200;
                    progressInfo.text = Resource.getString("REPLACE_DRIVE_OPERATION_PAUSED", "Replace Drive Operation has been suspended");
                }
            }
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getactive_MR_PD_PROGRESS1().getErase() != 0) {
            progressInfo.opCode = 34537728;
            progressInfo.value = mR_PD_PROGRESS.getErase().getprogress();
            progressInfo.text = Resource.getString("PROP_DRIVE_ERASE", "Drive Erase");
            progressInfo.abortOpCode = 0x20F0200;
            if (n == 1) {
                float f = mR_PD_PROGRESS.getErase().getprogress();
                int n6 = mR_PD_PROGRESS.getErase().getelapsedSecs();
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getErase().getelapsedSecs();
                progressInfo.estimatedSecs = (100 - (int)f) * n6;
            } else {
                progressInfo.elapsedSecs = mR_PD_PROGRESS.getErase().getelapsedSecs();
                progressInfo.estimatedSecs = mR_PD_PROGRESS.getErase().getEstimatedSecs();
            }
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getrbld()) {
            progressInfo.opCode = 34472192;
            progressInfo.text = Resource.getString("REBUILD_PAUSED", "Rebuild has been suspended");
            progressInfo.abortOpCode = 6;
            progressInfo.state = mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getrbld();
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getCopyBack()) {
            String string = this.getCopyBackState();
            progressInfo.opCode = 0x20E0200;
            progressInfo.text = Resource.getString("REPLACE_DRIVE_OPERATION_PAUSED", "Replace Drive Operation has been suspended");
            progressInfo.abortOpCode = 6;
            progressInfo.state = mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getCopyBack();
            return progressInfo;
        }
        if (mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getpatrol()) {
            progressInfo.opCode = 17237504;
            progressInfo.text = Resource.getString("PATROL_PAUSED", "Patrol Read has been suspended");
            progressInfo.abortOpCode = 6;
            progressInfo.state = mR_PD_PROGRESS.getpause_MR_PD_PROGRESS1().getpatrol();
            return progressInfo;
        }
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        PropertyInfo propertyInfo;
        PropertyInfo propertyInfo2;
        PropertyInfo propertyInfo3;
        Object object;
        PropertyInfo propertyInfo4;
        Object object2;
        Object object3;
        int n;
        PropertyInfo propertyInfo5;
        Object object4;
        PropertyInfo propertyInfo6;
        short s;
        Object object5;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyInfo propertyInfo7 = new PropertyInfo();
        propertyInfo7.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        arrayList.add(propertyInfo7);
        if (this.parent.getDeviceObject() instanceof SASAdapter) {
            Object object6;
            object5 = (SASAdapter)this.parent.getDeviceObject();
            this.m_objSMARTInfo = this.phDevice.getSMARTInfo();
            if (this.m_objSMARTInfo != null) {
                int n2 = this.m_objSMARTInfo.getLifeLeft();
                if (n2 != -1) {
                    object6 = "Optimal";
                    if (n2 < this.m_objSMARTInfo.getLifeLeftErrorThreshold()) {
                        object6 = "Critical";
                    } else if (n2 < this.m_objSMARTInfo.getLifeLeftWarningThreshold()) {
                        object6 = "Warning";
                    }
                    PropertyInfo propertyInfo8 = new PropertyInfo();
                    propertyInfo8.name = Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left");
                    propertyInfo8.value = n2 + " %";
                    if (this.parent.isCSA()) {
                        propertyInfo8.value = propertyInfo8.value + " - " + (String)object6;
                    }
                    propertyInfo8.description = Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left");
                    arrayList.add(propertyInfo8);
                }
                object6 = new PropertyInfo();
                ((PropertyInfo)object6).name = Resource.getString("PROPERTY_NMR_THERMAL_IO_THROTTLING_STATUS", "Thermal I/O Throttling Status");
                s = this.m_objSMARTInfo.getThermalThrottle();
                ((PropertyInfo)object6).value = s == 0 ? Resource.getString("NMR_THERMAL_IO_THROTTLING_VAL_OPTIMAL", "Optimal, No I/O Throttling") : Resource.getString("NMR_THERMAL_IO_THROTTLING_VAL_ACTIVE", "Active");
                ((PropertyInfo)object6).description = Resource.getString("PROPERTY_NMR_THERMAL_IO_THROTTLING_STATUS", "Thermal I/O Throttling Status");
                arrayList.add(object6);
            } else if (((SASAdapter)object5).isWarhawk()) {
                PropertyInfo propertyInfo9 = new PropertyInfo();
                propertyInfo9.name = Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left");
                propertyInfo9.value = this.phDevice.getSSDInformation().getSSDLifeLeft() + " %" + " - " + this.getSSDLifeLeftStatus();
                propertyInfo9.description = Resource.getString("PROPERTY_SSD_LIFE_LEFT_TEXT", "SSD Life Left");
                arrayList.add(propertyInfo9);
                object6 = new PropertyInfo();
                ((PropertyInfo)object6).name = Resource.getString("PROPERTY_SSD_LOCATION_TEXT", "Current Location of SSD");
                s = this.phDevice.getSSDInformation().getLocation();
                if (s == 0) {
                    ((PropertyInfo)object6).value = Resource.getString("PROPERTY_SSD_LOCATION_LOWER_TEXT", "Lower") + " - " + this.phDevice.getSSDInformation().getCage();
                }
                if (s == 1) {
                    ((PropertyInfo)object6).value = Resource.getString("PROPERTY_SSD_LOCATION_UPPER_TEXT", "Upper") + " - " + this.phDevice.getSSDInformation().getCage();
                }
                ((PropertyInfo)object6).description = Resource.getString("PROPERTY_SSD_LOCATION_TEXT", "Current Location of SSD");
                arrayList.add(object6);
            }
        }
        object5 = new PropertyInfo();
        ((PropertyInfo)object5).name = Resource.getString("PROPERTY_USABLE_CAPACITY_TEXT", "Usable Capacity");
        ((PropertyInfo)object5).value = KernelConstants.getConvertedSize(this.pdInfo.getcoercedSize(), this.getUserDataBlockSize());
        ((PropertyInfo)object5).description = Resource.getString("PROPERTY_USABLE_CAPACITY_TEXT", "Usable Capacity");
        arrayList.add(object5);
        PropertyInfo propertyInfo10 = new PropertyInfo();
        propertyInfo10.name = Resource.getString("PROPERTY_RAW_CAPACITY_TEXT", "Raw Capacity");
        propertyInfo10.value = KernelConstants.getConvertedSize(this.pdInfo.getrawSize(), this.getUserDataBlockSize());
        propertyInfo10.description = Resource.getString("PROPERTY_RAW_CAPACITY_TEXT", "Raw Capacity");
        arrayList.add(propertyInfo10);
        short s2 = this.pdInfo.getUserDataBlockSize();
        s = this.pdInfo.getEmulatedBlockSize();
        PropertyInfo propertyInfo11 = new PropertyInfo();
        propertyInfo11.name = Resource.getString("PROPERTY_LOGICAL_SECTOR_SIZE_TEXT", "Logical Sector Size");
        propertyInfo11.value = s2 < 1024 ? new Short(s2).toString() + " " + Resource.getString("STRING_BYTE", "B") : new Short((short)(s2 / 1024)).toString() + " " + Resource.getString("STRING_KILO_BYTE", "KB");
        propertyInfo11.description = Resource.getString("PROPERTY_LOGICAL_SECTOR_SIZE_TEXT", "Logical Sector Size");
        arrayList.add(propertyInfo11);
        PropertyInfo propertyInfo12 = new PropertyInfo();
        propertyInfo12.name = Resource.getString("PROPERTY_PHYSICAL_SECTOR_SIZE_TEXT", "Physical Sector Size");
        short s3 = (short)(s2 * (1 << s));
        propertyInfo12.value = s3 < 1024 ? new Short(s3).toString() + " " + Resource.getString("STRING_BYTE", "B") : new Short((short)(s3 / 1024)).toString() + " " + Resource.getString("STRING_KILO_BYTE", "KB");
        propertyInfo12.description = Resource.getString("PROPERTY_PHYSICAL_SECTOR_SIZE_TEXT", "Physical Sector Size");
        arrayList.add(propertyInfo12);
        pdType_MR_PD_INFO pdType_MR_PD_INFO2 = this.phDevice.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
        if (pdType_MR_PD_INFO2.getisForeign() == 1 && (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 4)) {
            propertyInfo6 = new PropertyInfo();
            propertyInfo6.name = Resource.getString("PROPERTY_IMPORTABLE_TEXT");
            propertyInfo6.value = this.getImportableValue();
            propertyInfo6.description = Resource.getString("PROPERTY_IMPORTABLE_TEXT");
            arrayList.add(propertyInfo6);
        }
        if ((((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 4) && this.pdInfo.getNotCertified() != 0) {
            propertyInfo6 = new PropertyInfo();
            propertyInfo6.name = Resource.getString("PROPERTY_CERTIFIED_TEXT", "Certified");
            propertyInfo6.value = Resource.getString("PROPERTY_NO_TEXT", "No");
            propertyInfo6.description = Resource.getString("PROPERTY_CERTIFIED_TEXT");
            arrayList.add(propertyInfo6);
        } else if (this.pdInfo.getnotSupported() == '\u0000' && (char)this.pdInfo.getNotCertified() == '\u0001') {
            propertyInfo6 = new PropertyInfo();
            propertyInfo6.name = Resource.getString("PROPERTY_CERTIFIED_TEXT", "Certified");
            propertyInfo6.value = Resource.getString("PROPERTY_NO_TEXT", "No");
            propertyInfo6.description = Resource.getString("PROPERTY_CERTIFIED_TEXT", "Certified");
            arrayList.add(propertyInfo6);
        }
        propertyInfo6 = new PropertyInfo();
        propertyInfo6.name = Resource.getString("PROPERTY_PRODUCTID_TEXT", "Product ID");
        propertyInfo6.value = this.phDevice.getProductInfo();
        propertyInfo6.description = Resource.getString("PROPERTY_PRODUCTID_TEXT", "Product ID");
        arrayList.add(propertyInfo6);
        PropertyInfo propertyInfo13 = new PropertyInfo();
        propertyInfo13.name = Resource.getString("PROPERTY_VENDORINFO_TEXT", "Vendor ID");
        propertyInfo13.value = this.phDevice.getVendorInfo();
        propertyInfo13.description = Resource.getString("PROPERTY_VENDORINFO_TEXT", "Vendor ID");
        arrayList.add(propertyInfo13);
        PropertyInfo propertyInfo14 = new PropertyInfo();
        propertyInfo14.name = Resource.getString("PROPERTY_SERIAL_NUMBER_TEXT", "Serial Number");
        byte[] byArray = this.getVPDPage80();
        if (byArray != null && byArray[1] == -128) {
            byte by = byArray[3];
            object4 = new String(byArray, 4, (int)by).trim();
            propertyInfo14.value = "" + (String)object4;
            propertyInfo14.description = Resource.getString("PROPERTY_SERIAL_NUMBER_TEXT", "Serial Number");
            arrayList.add(propertyInfo14);
        } else {
            propertyInfo14.value = this.phDevice.getSerialNumber();
            arrayList.add(propertyInfo14);
        }
        PropertyInfo propertyInfo15 = new PropertyInfo();
        propertyInfo15.name = Resource.getString("PROPERTY_DEVICEID_TEXT", "Device ID");
        propertyInfo15.value = this.phDevice.getDeviceId() + "";
        propertyInfo15.description = Resource.getString("PROPERTY_DEVICEID_TEXT", "Device ID");
        arrayList.add(propertyInfo15);
        object4 = new PropertyInfo();
        ((PropertyInfo)object4).name = Resource.getString("PROPERTY_STATUS_TEXT", "Status");
        ((PropertyInfo)object4).value = this.getState();
        ((PropertyInfo)object4).description = Resource.getString("PROPERTY_STATUS_TEXT", "Status");
        arrayList.add(object4);
        PropertyInfo propertyInfo16 = new PropertyInfo();
        propertyInfo16.name = Resource.getString("PROPERTY_PD_SHARED_TEXT", "Shared");
        String string = this.getInformation().isSharedPD() != false ? "Yes" : "No";
        propertyInfo16.value = string;
        propertyInfo16.description = Resource.getString("PROPERTY_PD_SHARED_TEXT", "Shared");
        if (this.pdInfo.getmediatype() == '\u0001') {
            propertyInfo5 = new PropertyInfo();
            propertyInfo5.name = Resource.getString("PROPERTY_DRIVE_TYPE_TEXT", "Drive Type");
            propertyInfo5.value = Resource.getString("PROPERTY_SOLID_STATE_DRIVE_TEXT", "Solid State Drive") + " (" + this.getPDDriveType() + ")";
            propertyInfo5.description = Resource.getString("PROPERTY_DRIVE_TYPE_TEXT", "Drive Type");
            arrayList.add(propertyInfo5);
        }
        if (VivaldiStartupDialog.OEM_TYPE == 2561 || ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
            propertyInfo5 = new PropertyInfo();
            propertyInfo5.name = Resource.getString("PROPERTY_DEVICESPEED_TEXT", "Drive Speed");
            propertyInfo5.value = this.getDeviceLinkSpeed(this.pdInfo.getdeviceSpeed());
            propertyInfo5.description = Resource.getString("PROPERTY_DEVICESPEED_TEXT", "Drive Speed");
            arrayList.add(propertyInfo5);
        }
        propertyInfo5 = new PropertyInfo();
        propertyInfo5.name = Resource.getString("PROPERTY_LINKSPEED_TEXT", "Negotiated Link Speed");
        propertyInfo5.value = this.getDeviceLinkSpeed(this.pdInfo.getlinkSpeed());
        propertyInfo5.description = Resource.getString("PROPERTY_LINKSPEED_TEXT", "Negotiated Link Speed");
        arrayList.add(propertyInfo5);
        PropertyInfo propertyInfo17 = new PropertyInfo();
        propertyInfo17.name = Resource.getString("PROP_SCSIDEVTYPE_TEXT", "SCSI Device Type");
        char c = this.pdInfo.getscsiDevType();
        if (c == '\u0005') {
            propertyInfo17.value = Resource.getString("DEV_CDROM_TEXT", "CDROM");
        } else if (c == '\u0000') {
            propertyInfo17.value = Resource.getString("DEV_DIRECT_TEXT", "Disk");
        } else if (c == '\u0001') {
            propertyInfo17.value = Resource.getString("DEV_TAPE_TEXT", "TAPE");
        }
        propertyInfo17.description = Resource.getString("PROP_SCSIDEVTYPE_TEXT", "SCSI Device Type");
        arrayList.add(propertyInfo17);
        int n3 = this.pdInfo.getpathInfo_MR_PD_INFO1().getcount();
        for (n = 0; n < n3; ++n) {
            PropertyInfo propertyInfo18 = new PropertyInfo();
            propertyInfo18.name = Resource.getString("PROP_PDSASADDR_TEXT", "SAS Address") + " " + n;
            propertyInfo18.value = n < this.pdInfo.getpathInfo_MR_PD_INFO1().getsasAddr().length ? "0x" + Long.toHexString(this.pdInfo.getpathInfo_MR_PD_INFO1().getsasAddr()[n]).toUpperCase() : "";
            propertyInfo18.description = propertyInfo18.name;
            arrayList.add(propertyInfo18);
        }
        if (this.m_objSMARTInfo != null) {
            n = this.pdInfo.gettemperature();
            float f = (float)((double)n * 1.8) + 32.0f;
            object3 = "Optimal";
            if (n > this.m_objSMARTInfo.getTemperatureErrorThreshold()) {
                object3 = "Critical";
            } else if (n > this.m_objSMARTInfo.getTemperatureWarningThreshold()) {
                object3 = "Warning";
            }
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
            ((PropertyInfo)object2).description = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
            ((PropertyInfo)object2).value = n + " C" + "(" + f + " F" + ")";
            if (this.parent.isCSA()) {
                ((PropertyInfo)object2).value = ((PropertyInfo)object2).value + " - " + (String)object3;
            }
            arrayList.add(object2);
        } else {
            this.adapterInfo = this.parent.getAdapterInfo();
            if (this.adapterInfo.getpdOperations_MR_CTRL_INFO().isSupportTemperature()) {
                n = this.pdInfo.gettemperature();
                if (n != -1) {
                    float f = (float)((double)n * 1.8) + 32.0f;
                    object3 = new PropertyInfo();
                    ((PropertyInfo)object3).name = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
                    ((PropertyInfo)object3).description = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
                    ((PropertyInfo)object3).value = n + " C" + "(" + f + " F" + ")";
                    arrayList.add(object3);
                } else if (this.pdInfo.getPowerState() == 0 && (n = this.getTemperature()) != -1) {
                    float f = (float)((double)n * 1.8) + 32.0f;
                    object3 = new PropertyInfo();
                    ((PropertyInfo)object3).name = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
                    ((PropertyInfo)object3).description = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
                    ((PropertyInfo)object3).value = n + " C" + "(" + f + " F" + ")";
                    arrayList.add(object3);
                }
            } else if (this.pdInfo.getPowerState() == 0 && (n = this.getTemperature()) != -1) {
                float f = (float)((double)n * 1.8) + 32.0f;
                object3 = new PropertyInfo();
                ((PropertyInfo)object3).name = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
                ((PropertyInfo)object3).description = Resource.getString("PROPERTY_PD_TEMPERATURE", "Temperature");
                ((PropertyInfo)object3).value = n + " C" + "(" + f + " F" + ")";
                arrayList.add(object3);
            }
        }
        PropertyInfo propertyInfo19 = new PropertyInfo();
        propertyInfo19.name = Resource.getString("PROPERTY_POWER_STATUS", "Power Status");
        propertyInfo19.description = Resource.getString("PROPERTY_POWER_STATUS", "Power Status");
        propertyInfo19.value = this.pdInfo.getPowerState() == 0 ? Resource.getString("PROPERTY_POWERSAVE_ON", "On") : (this.pdInfo.getPowerState() == -1 ? Resource.getString("PROPERTY_TRANSITIONING", "Transitioning") : (this.pdInfo.getPowerState() == 1 || this.pdInfo.getdisabledForRemoval() == '\u0001' ? Resource.getString("PROPERTY_POWER_SAVE", "Powersave") : Resource.getString("PROPERTY_POWERSAVE_ON", "On")));
        arrayList.add(propertyInfo19);
        short s4 = this.phDevice.getState();
        boolean bl = false;
        if (this.phDevice.getState() == 2 && ((String)(object2 = PhysicalDriveHelper.getHotspareType(this.phDevice))).equals(Resource.getString("PD_STATE_HOTSPARE_GLOBAL"))) {
            bl = true;
        }
        if (this.parent.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportEmergencySpares() != 0 && this.phDevice.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getinVD() == 1) {
            object2 = new PropertyInfo();
            ((PropertyInfo)object2).name = Resource.getString("PROPERTY_EMERGENCY_SPARE", "Emergency Spare");
            ((PropertyInfo)object2).description = Resource.getString("PROPERTY_EMERGENCY_HOTSPARE", "Emergency Hotspare");
            ((PropertyInfo)object2).value = this.pdInfo.getproperties_MR_PD_INFO().isEmergencySpare() ? Resource.getString("PROPERTY_EMERGENCY_YES", "Yes") : Resource.getString("PROPERTY_EMERGENCY_NO", "No");
            arrayList.add(object2);
            propertyInfo4 = new PropertyInfo();
            propertyInfo19.name = Resource.getString("PROPERTY_COMMISSIONED_HOTSPARE", "Commissioned Hotspare");
            propertyInfo19.description = Resource.getString("PROPERTY_COMMISSIONED_HOTSPARE", "Commissioned Hotspare");
            object = this.pdInfo.getproperties_MR_PD_INFO();
            propertyInfo19.value = ((properties_MR_PD_INFO)object).isCommissionedSpare() ? Resource.getString("PROPERTY_COMMISSIONED_YES", "Yes") : Resource.getString("PROPERTY_COMMISSIONED_No", "No");
            arrayList.add(propertyInfo4);
        }
        object2 = new PropertyInfo();
        ((PropertyInfo)object2).name = Resource.getString("PROPERTY_REVLEVEL_TEXT", "Revision Level");
        ((PropertyInfo)object2).value = this.phDevice.getProductRevisionLevel();
        ((PropertyInfo)object2).description = Resource.getString("PROPERTY_REVLEVEL_TEXT", "Revision Level");
        arrayList.add(object2);
        propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROPERTY_MEDIACOUNT_TEXT", "Media Error Count");
        propertyInfo4.value = this.pdInfo.getmediaErrCount() + "";
        propertyInfo4.description = Resource.getString("PROPERTY_MEDIACOUNT_TEXT", "Media Error Count");
        arrayList.add(propertyInfo4);
        if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() != 3 && ((SASAdapter)this.parent.getDeviceObject()).getAdapterType() != 4) {
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("PROPERTY_PREDFAILCOUNT_TEXT", "Pred Fail Count");
            ((PropertyInfo)object).value = this.pdInfo.getpredFailCount() + "";
            ((PropertyInfo)object).description = Resource.getString("PROPERTY_PREDFAILCOUNT_TEXT", "Pred Fail Count");
            arrayList.add(object);
        }
        if (this.enclosureID != -1) {
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("PROP_ECLPROP", "<html><b>Enclosure Properties:</b></html>");
            arrayList.add(object);
            propertyInfo3 = new PropertyInfo();
            propertyInfo3.name = Resource.getString("PROPERTY_ENCLOSUREID_TEXT", "Enclosure ID");
            propertyInfo3.description = Resource.getString("PROPERTY_ENCLOSUREID_TEXT", "Enclosure ID");
            propertyInfo3.value = "" + this.enclosureID;
            arrayList.add(propertyInfo3);
            if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                propertyInfo2 = new PropertyInfo();
                propertyInfo2.name = Resource.getString("PROPERTY_ENCLOSUREMODEL_TEXT", "Enclosure Model");
                propertyInfo2.description = Resource.getString("PROPERTY_ENCLOSUREMODEL_TEXT", "Enclosure Model");
                if (this.enclosureHelper != null) {
                    propertyInfo2.value = this.enclosureHelper.isBackplane() ? Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane") : ((SASEnclosure)this.enclosureHelper.getDeviceObject()).getProductInfo();
                }
                arrayList.add(propertyInfo2);
            }
            if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                propertyInfo2 = new PropertyInfo();
                propertyInfo2.name = Resource.getString("PROPERTY_ENCLLOCATION_TEXT", "Enclosure Location");
                propertyInfo2.value = this.getenclLocation();
                propertyInfo2.description = Resource.getString("PROPERTY_ENCLLOCATION_TEXT", "Enclosure Location");
                arrayList.add(propertyInfo2);
            }
            if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1 && this.enclosureHelper != null && this.enclosureHelper.isDaisyChain()) {
                propertyInfo2 = new PropertyInfo();
                propertyInfo2.name = Resource.getString("PROPERTY_ENCLPOSITION_TEXT", "Enclosure Position");
                propertyInfo2.value = "" + this.getPosition();
                propertyInfo2.description = Resource.getString("PROPERTY_ENCLPOSITION_TEXT", "Enclosure Position");
                arrayList.add(propertyInfo2);
            }
            if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                propertyInfo2 = new PropertyInfo();
                propertyInfo2.name = Resource.getString("PROPERTY_CONNECTOR_TEXT", "Connector");
                propertyInfo2.value = this.getConnectorname();
                propertyInfo2.description = Resource.getString("PROPERTY_CONNECTOR_TEXT", "Connector");
                arrayList.add(propertyInfo2);
            }
        }
        if (this.parent.getDeviceObject() instanceof SASAdapter && ((SASAdapter)(object = (SASAdapter)this.parent.getDeviceObject())).isWarhawk()) {
            propertyInfo3 = new PropertyInfo();
            propertyInfo3.name = Resource.getString("PROPERTY_SSD_TEMPERATURE_TEXT", "Temperature (in Celsius)");
            propertyInfo3.value = Short.toString(this.phDevice.getSSDInformation().getTemperature());
            propertyInfo3.description = Resource.getString("PROPERTY_SSD_TEMPERATURE_TEXT", "Temperature (in Celsius)");
            arrayList.add(propertyInfo3);
            propertyInfo2 = new PropertyInfo();
            propertyInfo2.name = Resource.getString("PROPERTY_SSD_FLASH_TYPE_TEXT", "SSD Flash Type");
            short s5 = this.phDevice.getSSDInformation().getFlashType();
            switch (s5) {
                case 255: {
                    propertyInfo2.value = Resource.getString("PROPERTY_SL_WH_FLASHTYPE_UNKNOWN_TEXT", "Unknown");
                    break;
                }
                case 0: {
                    propertyInfo2.value = Resource.getString("PROPERTY_SL_WH_FLASHTYPE_SLC_TEXT", "SLC");
                    break;
                }
                case 1: {
                    propertyInfo2.value = Resource.getString("PROPERTY_SL_WH_FLASHTYPE_MLC_TEXT", "MLC");
                    break;
                }
                case 2: {
                    propertyInfo2.value = Resource.getString("PROPERTY_SL_WH_FLASHTYPE_EMLC_TEXT", "EMLC");
                    break;
                }
            }
            propertyInfo2.description = Resource.getString("PROPERTY_SSD_LOCATION_TEXT", "Current Location of SSD");
            arrayList.add(propertyInfo2);
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROPERTY_LIFE_CURVE_STATUS_TEXT", "Life Curve Status");
            short s6 = ((SASAdapter)object).getWhDDInfo().getLifeCurveStatus();
            propertyInfo.value = s6 == 100 ? Resource.getString("NO_THROTTLING_TEXT", "No Throttling") : (s6 == 90 ? Resource.getString("THROTTLING_TEXT", "Throttling") : Resource.getString("PROPERTY_DD_UNKNOWN_TEXT", "Unknown"));
            propertyInfo.description = Resource.getString("PROPERTY_LIFE_CURVE_STATUS_TEXT", "Life Curve Status");
            arrayList.add(propertyInfo);
        }
        object = new PropertyInfo();
        ((PropertyInfo)object).name = Resource.getString("PROPERTY_SLOT_NUMBER", "Slot Number");
        ((PropertyInfo)object).value = "" + this.pdInfo.getslotNumber();
        ((PropertyInfo)object).description = ((PropertyInfo)object).name;
        arrayList.add(object);
        propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROP_DSPROP", "<html><b>Drive Security Properties:</b></html>");
        arrayList.add(propertyInfo3);
        propertyInfo2 = new PropertyInfo();
        propertyInfo2.description = propertyInfo2.name = Resource.getString("PROPERTY_FDE_CAPABLE_TEXT", "Full Disk Encryption capable");
        propertyInfo2.value = this.isFDECapable() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No");
        arrayList.add(propertyInfo2);
        if (this.parent.isSecuritySupported()) {
            PropertyInfo propertyInfo20 = new PropertyInfo();
            propertyInfo20.description = propertyInfo20.name = Resource.getString("PROPERTY_SECURED_TEXT", "Secured");
            propertyInfo20.value = "";
            propertyInfo20.value = VivaldiStartupDialog.OEM_TYPE == 2561 && this.parent.isOnlyFDESupported() ? (!((SASPhysicalDrive)this.getDeviceObject()).getInformation().getSecurity_MR_PD_INFO().getFDECapable() ? Resource.getString("PROPERTY_N/A_TEXT") : (this.isEncrypted() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No"))) : (this.isEncrypted() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_NO_TEXT", "No"));
            arrayList.add(propertyInfo20);
        }
        if (this.parent.isSecuritySupported() && !this.parent.isOnlyFDESupported() && this.isEncrypted() && this.phDevice.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisForeign() != 1) {
            PropertyInfo propertyInfo21 = new PropertyInfo();
            propertyInfo21.description = propertyInfo21.name = Resource.getString("PROPERTY_DRV_SECURITY_METHOD_TEXT", "Drive security method");
            propertyInfo21.value = this.getEncryptionMethodDesc();
            arrayList.add(propertyInfo21);
        }
        PropertyInfo propertyInfo22 = new PropertyInfo();
        propertyInfo22.name = Resource.getString("DATA_PROTECTION_PROP", "<html><b>Data Protection Properties:</b></html>");
        arrayList.add(propertyInfo22);
        propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("DATA_PROTECTION", "Data Protection");
        propertyInfo.value = this.isPDPICapable() ? Resource.getString("CAPABLE", "Capable") : Resource.getString("INCAPABLE", "Incapable");
        propertyInfo.description = Resource.getString("DATA_PROTECTION", "Data Protection");
        arrayList.add(propertyInfo);
        if (this.isPDPICapable()) {
            PropertyInfo propertyInfo23 = new PropertyInfo();
            propertyInfo23.name = Resource.getString("DATA_PROTECTION_TYPE", "Data Protection Type");
            propertyInfo23.value = this.dataProtectionType();
            propertyInfo23.description = Resource.getString("DATA_PROTECTION_TYPE", "Data Protection Type");
            arrayList.add(propertyInfo23);
        }
        if (this.parent.isShieldEnable()) {
            PropertyInfo propertyInfo24 = new PropertyInfo();
            propertyInfo24.name = Resource.getString("PROPERTY_SHIELD_COUNTER", "Shield Counter");
            propertyInfo24.value = this.pdInfo.getShieldCounter() + "";
            propertyInfo24.description = Resource.getString("PROPERTY_SHIELD_COUNTER", "Shield Counter");
            arrayList.add(propertyInfo24);
            PropertyInfo propertyInfo25 = new PropertyInfo();
            propertyInfo25.name = Resource.getString("PROPERTY_DIAG_COMP_TIME", "Diagnostics Complete Date");
            MR_TIME_STAMP mR_TIME_STAMP = this.pdInfo.getShieldDiagCompletionTime();
            if (mR_TIME_STAMP.getday() != 0) {
                propertyInfo25.value = mR_TIME_STAMP.getday() + "-" + mR_TIME_STAMP.getmonth() + "-" + mR_TIME_STAMP.getyear();
                propertyInfo25.description = Resource.getString("PROPERTY_DIAG_COMP_TIME", "Diagnostics Complete Date");
                arrayList.add(propertyInfo25);
            }
        }
        return arrayList;
    }

    public byte[] getVPDPage80() {
        byte[] byArray = new byte[]{18, 1, -128, 0, 32, 0};
        int n = 256;
        SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.phDevice.getDeviceId(), 1, 0, 2, 10, byArray, n, new byte[n]);
        System.out.println("After SCSI Passthrough!!!" + sL_SCSI_PASSTHRU_T.getdata().toString());
        try {
            SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T2 = ((SASAdapter)this.phDevice.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
            byte[] byArray2 = sL_SCSI_PASSTHRU_T2.getdata();
            return byArray2;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
    }

    public String getImportableValue() {
        try {
            pdType_MR_PD_INFO pdType_MR_PD_INFO2 = this.phDevice.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
            if (pdType_MR_PD_INFO2.getisForeign() == 1 && this.phDevice.getAllAllowedOperations().isforeignImportNotAllowed()) {
                return Resource.getString("PROPERTY_NO_TEXT", "No");
            }
            return Resource.getString("PROPERTY_YES_TEXT", "Yes");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        this.pdInfo = this.phDevice.getInformation();
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        switch (n) {
            case 91: 
            case 104: 
            case 112: 
            case 114: 
            case 115: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 288: 
            case 289: 
            case 293: 
            case 294: 
            case 295: 
            case 318: 
            case 320: 
            case 331: 
            case 405: 
            case 406: 
            case 412: 
            case 413: 
            case 417: 
            case 418: 
            case 482: 
            case 483: {
                this.parent.notifyMethod(object);
                VivaldiStartupDialog.mainScreen.getPhysicalTree().repaint();
                VivaldiStartupDialog.mainScreen.getLogicalTree().repaint();
                break;
            }
            case 303: {
                this.parent.notifyMethod(object);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers(object);
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.parent;
    }

    public Vector getUsageDetails() {
        try {
            return this.phDevice.getGraphicalLayoutInformation();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getEnclosureID() {
        return this.enclosureID;
    }

    @Override
    public ImageIcon getStatusIcon() {
        switch (this.phDevice.getState()) {
            case 1: 
            case 16: 
            case 17: 
            case 128: 
            case 130: 
            case 144: 
            case 192: {
                return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
            }
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.phDevice.getState();
    }

    @Override
    public void setStatus(int n) {
    }

    private String getCopyBackState() {
        String string = null;
        short s = this.phDevice.getState();
        if (s == 24) {
            PhysicalDriveHelper physicalDriveHelper = this.getCopyBackDestinationPDHelper();
            if (physicalDriveHelper != null) {
                string = Resource.getString("OPERATION_COPYBACK_REPLACED_TEXT", "Replacing with ");
                string = string + physicalDriveHelper.getCopyBackPDText();
            } else {
                string = Resource.getString("PD_STATE_ONLINE", "Online");
            }
        } else if (s == 32) {
            PhysicalDriveHelper physicalDriveHelper = this.getCopyBackSourceHelper();
            if (physicalDriveHelper != null) {
                string = Resource.getString("REPLACING_PHYSICAL_DRIVE_INPROGRESS", "Replacing ");
                string = string + physicalDriveHelper.getCopyBackPDText();
            } else {
                string = Resource.getString("REPLACING_PHYSICAL_DRIVE_INPROGRESS", "Replacing ");
            }
        }
        return string;
    }

    public Vector getEligibleCopyBackDrives() {
        Vector<PhysicalDriveHelper> vector;
        block19: {
            MR_SPARE[] mR_SPAREArray = null;
            vector = null;
            SASArray sASArray = this.phDevice.getSASArray();
            ArrayList arrayList = this.phDevice.getLogicalDriveList();
            if (this.phDevice.getState() != 24 || sASArray == null || arrayList == null || arrayList.size() == 0) {
                return null;
            }
            ArrayHelper arrayHelper = null;
            ArrayHelper[] arrayHelperArray = this.parent.getArrays();
            for (int n = 0; n < arrayHelperArray.length; n = (int)((short)(n + 1))) {
                if (!arrayHelperArray[n].getDeviceObject().equals(sASArray)) continue;
                arrayHelper = arrayHelperArray[n];
                break;
            }
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
            ArrayList arrayList2 = sASLogicalDrive.getConstituentPDList();
            int n = 0;
            for (int n2 = 0; n2 < arrayList2.size(); n2 = (int)((short)(n2 + 1))) {
                if (arrayList2.get(n2) == null) continue;
                ++n;
            }
            SASPhysicalDrive[] sASPhysicalDriveArray = new SASPhysicalDrive[n];
            n = 0;
            for (int n3 = 0; n3 < arrayList2.size(); n3 = (int)((short)(n3 + 1))) {
                if (arrayList2.get(n3) == null) continue;
                sASPhysicalDriveArray[n] = (SASPhysicalDrive)arrayList2.get(n3);
                ++n;
            }
            AdapterHelper adapterHelper = (AdapterHelper)this.getParent();
            PhysicalDriveHelper[] physicalDriveHelperArray = adapterHelper.getPhysicalDrives();
            int n4 = ((SASAdapter)this.phDevice.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
            int n5 = ((SASAdapter)this.phDevice.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
            int n6 = ((SASAdapter)this.phDevice.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
            long l = sASArray.getSmallestPDSize();
            mR_SPAREArray = ((SASAdapter)this.phDevice.parent()).getMrConfigData().getspare();
            boolean bl = false;
            if (physicalDriveHelperArray == null || physicalDriveHelperArray.length <= 0) break block19;
            vector = new Vector<PhysicalDriveHelper>();
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                int n7;
                SASPhysicalDrive sASPhysicalDrive;
                block20: {
                    block23: {
                        block21: {
                            block24: {
                                block22: {
                                    sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
                                    if (sASPhysicalDrive.getState() != 0 || sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisForeign() == 1) break block20;
                                    if (sASPhysicalDrive.getInformation().getcoercedSize() < l) continue;
                                    bl = true;
                                    if (arrayHelper == null || !arrayHelper.isSSCD()) break block21;
                                    if (physicalDriveHelperArray[i].isSSDDrive()) break block22;
                                    bl = false;
                                    break block23;
                                }
                                if (!physicalDriveHelperArray[i].isSSDDrive() || !physicalDriveHelperArray[i].isIneligibleForSSCD()) break block24;
                                bl = false;
                                break block23;
                            }
                            if (this.phDevice.getDriveType() == sASPhysicalDrive.getDriveType() || n6 != 0) break block23;
                            bl = false;
                            break block23;
                        }
                        for (n7 = 0; n7 < sASPhysicalDriveArray.length; n7 = (int)((short)(n7 + 1))) {
                            if (physicalDriveHelperArray[i].getInformation().getUserDataBlockSize() != sASPhysicalDriveArray[n7].getInformation().getUserDataBlockSize()) {
                                bl = false;
                                break;
                            }
                            if (physicalDriveHelperArray[i].getmediaType() == '\u0000' && sASPhysicalDriveArray[n7].getMediatype() == 0) {
                                if (n5 != 0 || sASPhysicalDrive.getDriveType() == sASPhysicalDriveArray[n7].getDriveType()) continue;
                                bl = false;
                                break;
                            }
                            if (physicalDriveHelperArray[i].getmediaType() == '\u0000' && sASPhysicalDriveArray[n7].getMediatype() == 1) {
                                if (n4 != 0) continue;
                                bl = false;
                                break;
                            }
                            if (physicalDriveHelperArray[i].getmediaType() == '\u0001' && sASPhysicalDriveArray[n7].getMediatype() == 0) {
                                if (n4 != 0) continue;
                                bl = false;
                                break;
                            }
                            if (physicalDriveHelperArray[i].getmediaType() != '\u0001' || sASPhysicalDriveArray[n7].getMediatype() != 1 || n6 != 0 || sASPhysicalDrive.getDriveType() == sASPhysicalDriveArray[n7].getDriveType()) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl && this.getEncryptionMethod() != 0 && arrayHelper != null && arrayHelper.isFDEOnlyDriveGroup()) {
                        bl = physicalDriveHelperArray[i].isFDECapable();
                    }
                    if (bl && arrayHelper.isArrayPIEnabled()) {
                        bl = physicalDriveHelperArray[i].isPDPICapable();
                    }
                    if (!bl) continue;
                    vector.add(physicalDriveHelperArray[i]);
                    continue;
                }
                if (sASPhysicalDrive.getState() != 2 || sASPhysicalDrive.getInformation().getcoercedSize() < l) continue;
                if (this.isHotSpareDedicatedToThisPDArray(sASPhysicalDrive)) {
                    vector.add(physicalDriveHelperArray[i]);
                    continue;
                }
                if (mR_SPAREArray == null || mR_SPAREArray.length <= 0) continue;
                for (n7 = 0; n7 < mR_SPAREArray.length; ++n7) {
                    bl = true;
                    if (mR_SPAREArray[n7].getref().getdeviceId() != sASPhysicalDrive.getDeviceId() || mR_SPAREArray[n7].getspareType_MR_SPARE1().getisDedicated() == '\u0001') continue;
                    if (mR_SPAREArray[n7].getspareType_MR_SPARE1().getisEnclAffinity() != '\u0000') {
                        // empty if block
                    }
                    if (this.getEncryptionMethod() != 0 && arrayHelper != null && arrayHelper.isFDEOnlyDriveGroup()) {
                        bl = physicalDriveHelperArray[i].isFDECapable();
                    }
                    if (physicalDriveHelperArray[i].getUserDataBlockSize() != this.phDevice.getInformation().getUserDataBlockSize()) {
                        bl = false;
                    }
                    if (!bl || !adapterHelper.isDriveMixAllowed(sASPhysicalDrive, this.phDevice, false)) continue;
                    vector.add(physicalDriveHelperArray[i]);
                }
            }
        }
        Vector<PhysicalDriveHelper> vector2 = new Vector<PhysicalDriveHelper>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)vector.get(i);
                if (physicalDriveHelper.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getErase() != 0) continue;
                vector2.add(physicalDriveHelper);
            }
        }
        return vector2;
    }

    public PhysicalDriveHelper getCopyBackDestinationPDHelper() {
        if (this.pdInfo == null || this.parent == null) {
            return null;
        }
        PhysicalDriveHelper physicalDriveHelper = null;
        short s = this.pdInfo.getcopyBackPartnerId();
        PhysicalDriveHelper[] physicalDriveHelperArray = this.parent.getPhysicalDrives();
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                MR_PD_INFO mR_PD_INFO;
                if (physicalDriveHelperArray[i].getDeviceObject().getState() != 32 || (mR_PD_INFO = ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation()).getcopyBackPartnerId() != this.phDevice.getDeviceId()) continue;
                physicalDriveHelper = physicalDriveHelperArray[i];
                break;
            }
        }
        return physicalDriveHelper;
    }

    public PhysicalDriveHelper getCopyBackSourceHelper() {
        if (this.pdInfo == null || this.parent == null) {
            return null;
        }
        PhysicalDriveHelper physicalDriveHelper = null;
        short s = this.pdInfo.getcopyBackPartnerId();
        PhysicalDriveHelper[] physicalDriveHelperArray = this.parent.getPhysicalDrives();
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                MR_PD_INFO mR_PD_INFO;
                if (physicalDriveHelperArray[i].getDeviceObject().getState() != 24 || (mR_PD_INFO = ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation()).getcopyBackPartnerId() != this.phDevice.getDeviceId()) continue;
                physicalDriveHelper = physicalDriveHelperArray[i];
                break;
            }
        }
        return physicalDriveHelper;
    }

    private boolean isHotSpareDedicatedToThisPDArray(SASPhysicalDrive sASPhysicalDrive) {
        ArrayList arrayList;
        boolean bl = false;
        SASArray sASArray = this.phDevice.getSASArray();
        if (sASArray != null && (arrayList = sASArray.getDedicatedPhysicalDriveList()) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)arrayList.get(i);
                if (sASPhysicalDrive2.getDeviceId() != sASPhysicalDrive.getDeviceId()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isFDECapable() {
        return this.pdInfo.getSecurity_MR_PD_INFO().getFDECapable();
    }

    public boolean isSecureForeign() {
        return this.pdInfo.getSecurity_MR_PD_INFO().getForeign();
    }

    public boolean isSecureLocked() {
        return this.pdInfo.getSecurity_MR_PD_INFO().getLocked();
    }

    public byte getEncryptionMethod() {
        byte by = 0;
        try {
            SASArray sASArray = this.phDevice.getSASArray();
            if (sASArray != null) {
                ArrayList arrayList = sASArray.getLogicalDriveList();
                if (arrayList.iterator().hasNext()) {
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.iterator().next();
                    by = sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType();
                }
            } else if (this.isEncrypted() && this.phDevice.getInformation().getSecurity_MR_PD_INFO().getFdeEnabled()) {
                by = 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return by;
    }

    public boolean isEncrypted() {
        return this.phDevice.getInformation().getSecurity_MR_PD_INFO().getSecured();
    }

    public String getEncryptionMethodDesc() {
        String string = "";
        byte by = this.getEncryptionMethod();
        if (by == 1) {
            string = Resource.getString("DESC_ENCRYPTION_METHOD_FDE", "Full disk encryption");
        } else if (by == 2) {
            string = Resource.getString("DESC_ENCRYPTION_METHOD_CTRL", "Controller-based encryption");
        }
        return string;
    }

    public String getCopyBackPDText() {
        SASEnclosure sASEnclosure;
        StringBuffer stringBuffer = new StringBuffer();
        SASEnclosure sASEnclosure2 = sASEnclosure = this.enclosureHelper != null ? (SASEnclosure)this.enclosureHelper.getDeviceObject() : null;
        if (sASEnclosure != null) {
            if (this.enclosureHelper.isBackplane()) {
                stringBuffer.append(Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane"));
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            } else if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                stringBuffer.append(": ");
                stringBuffer.append(sASEnclosure.getProductInfo());
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            } else {
                stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            }
        }
        char c = this.phDevice.getInformation().getslotNumber();
        stringBuffer.append(Resource.getString("ENCL_SLOT_TEXT", "Slot"));
        stringBuffer.append(": ");
        stringBuffer.append((int)c);
        stringBuffer.append(", ");
        if (this.pdInfo.getmediatype() == '\u0001') {
            stringBuffer.append(Resource.getString("SSD_TEXT", "SSD"));
            stringBuffer.append(" (");
            stringBuffer.append(this.getPDDriveType());
            stringBuffer.append(")");
        } else if (this.pdInfo.getmediatype() == '\u0002') {
            stringBuffer.append(Resource.getString("DFF_TEXT", "Nytro Flash Module"));
            stringBuffer.append(" (");
            stringBuffer.append(this.getPDDriveType());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(this.getPDDriveType());
        }
        stringBuffer.append(", ");
        stringBuffer.append(KernelConstants.getConvertedSize(this.pdInfo.getrawSize(), this.getUserDataBlockSize()));
        String string = this.getPowerState();
        if (!string.equalsIgnoreCase("")) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setArrayHelper(ArrayHelper arrayHelper) {
        this.m_arrayHelper = arrayHelper;
    }

    public char getmediaType() {
        return this.pdInfo.getmediatype();
    }

    private boolean isReplaceMisingDriveAllowed() {
        ArrayHelper[] arrayHelperArray = this.parent.getArrays();
        int n = ((SASAdapter)this.phDevice.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
        int n2 = ((SASAdapter)this.phDevice.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
        int n3 = ((SASAdapter)this.phDevice.parent()).getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
        boolean bl = false;
        for (int n4 = 0; n4 < arrayHelperArray.length; n4 = (int)((short)(n4 + 1))) {
            if (!((SASArray)arrayHelperArray[n4].getDeviceObject()).checkForMissingPhysicalDrive() || this.phDevice.getSize() < arrayHelperArray[n4].getDeviceObject().getSize()) continue;
            bl = true;
            if (arrayHelperArray[n4].isArrayEncrypted() && arrayHelperArray[n4].isFDEOnlyDriveGroup() && !this.isFDECapable()) {
                bl = false;
            }
            if (bl) {
                PhysicalDriveHelper[] physicalDriveHelperArray = arrayHelperArray[n4].getPhysicalDrives();
                for (int n5 = 0; n5 < physicalDriveHelperArray.length; n5 = (int)((short)(n5 + 1))) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[n5].getDeviceObject();
                    if (sASPhysicalDrive.getInformation().getUserDataBlockSize() != this.phDevice.getInformation().getUserDataBlockSize()) {
                        bl = false;
                        break;
                    }
                    if (sASPhysicalDrive.getMediatype() == 0 && this.phDevice.getMediatype() == 0) {
                        if (n2 != 0 || sASPhysicalDrive.getDriveType() == this.phDevice.getDriveType()) continue;
                        bl = false;
                        break;
                    }
                    if (sASPhysicalDrive.getMediatype() == 0 && this.phDevice.getMediatype() == 1) {
                        if (n != 0) continue;
                        bl = false;
                        break;
                    }
                    if (sASPhysicalDrive.getMediatype() == 1 && this.phDevice.getMediatype() == 0) {
                        if (n != 0) continue;
                        bl = false;
                        break;
                    }
                    if (sASPhysicalDrive.getMediatype() != 1 || this.phDevice.getMediatype() != 1) continue;
                    if (arrayHelperArray[n4].isSSCD() && this.isIneligibleForSSCD()) {
                        bl = false;
                        break;
                    }
                    if (n3 != 0 || sASPhysicalDrive.getDriveType() == this.phDevice.getDriveType()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public int getTemperature() {
        OperationDetails operationDetails = new OperationDetails(21, null);
        try {
            return this.phDevice.fireOperation(operationDetails);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getDeviceLinkSpeed(int n) {
        switch (n) {
            case 1: {
                return "1.5 Gbps";
            }
            case 2: {
                return "3.0 Gbps";
            }
            case 3: {
                return "6.0 Gbps";
            }
            case 4: {
                return "12.0 Gbps";
            }
            case 0: {
                return "UNKNOWN";
            }
        }
        return "";
    }

    public void setAsDedicatedHotSpare(boolean bl) {
        this.m_isDedicatedHotSpare = bl;
    }

    public boolean isDedicatedHotSpare() {
        return this.m_isDedicatedHotSpare;
    }

    public String[] getTextForTable() {
        SASEnclosure sASEnclosure;
        String[] stringArray = new String[3];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        SASEnclosure sASEnclosure2 = sASEnclosure = this.enclosureHelper != null ? (SASEnclosure)this.enclosureHelper.getDeviceObject() : null;
        if (sASEnclosure != null) {
            if (this.enclosureHelper.isBackplane()) {
                stringBuffer.append(Resource.getString("ENCL_BACKPLANE_TEXT", "Backplane"));
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            } else if (((SASAdapter)this.parent.getDeviceObject()).getAdapterType() == 1) {
                stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                stringBuffer.append(": ");
                stringBuffer.append(sASEnclosure.getProductInfo());
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            } else {
                stringBuffer.append(Resource.getString("ENCLOSURE_TEXT", "Enclosure"));
                stringBuffer.append(" (");
                stringBuffer.append(sASEnclosure.getDeviceId());
                stringBuffer.append("), ");
            }
        }
        char c = this.phDevice.getInformation().getslotNumber();
        stringBuffer.append(Resource.getString("ENCL_SLOT_TEXT", "Slot"));
        stringBuffer.append(": ");
        stringBuffer.append((int)c);
        stringArray[0] = stringBuffer.toString();
        if (this.pdInfo.getmediatype() == '\u0001') {
            stringBuffer2.append(Resource.getString("SSD_TEXT", "SSD"));
            stringBuffer2.append(" (");
            stringBuffer2.append(this.getPDDriveType());
            stringBuffer2.append(")");
        } else if (this.pdInfo.getmediatype() == '\u0002') {
            stringBuffer2.append(Resource.getString("DFF_TEXT", "Nytro Flash Module"));
            stringBuffer2.append(" (");
            stringBuffer2.append(this.getPDDriveType());
            stringBuffer2.append(")");
        } else {
            stringBuffer2.append(this.getPDDriveType());
        }
        stringArray[1] = stringBuffer2.toString();
        stringArray[2] = KernelConstants.getConvertedSize(this.pdInfo.getrawSize(), this.getUserDataBlockSize());
        return stringArray;
    }

    public long getSize() {
        return this.phDevice.getInformation().getcoercedSize();
    }

    public boolean isSSDDrive() {
        return this.getmediaType() == '\u0001';
    }

    public boolean isIneligibleForSSCD() {
        return this.pdInfo.getproperties_MR_PD_INFO().isIneligibleForSSCD();
    }

    public boolean isSASDrive() {
        return this.phDevice.getDriveType() == 2;
    }

    public boolean isForeign() {
        pdType_MR_PD_INFO pdType_MR_PD_INFO2 = this.phDevice.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
        return pdType_MR_PD_INFO2.getisForeign() == 1;
    }

    public boolean isOSDrive(SASPhysicalDrive sASPhysicalDrive) {
        OperationDetails operationDetails = new OperationDetails(21, null);
        try {
            this.getParent().getDeviceObject().fireOperation(operationDetails);
            SL_DRIVE_DISTRIBUTION_T sL_DRIVE_DISTRIBUTION_T = (SL_DRIVE_DISTRIBUTION_T)operationDetails.getParam();
            for (int i = 0; i < sL_DRIVE_DISTRIBUTION_T.getmappedDevicesCount(); ++i) {
                if (sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getdriveId() != sASPhysicalDrive.getDeviceId()) continue;
                SL_PARTITION_INFO_T sL_PARTITION_INFO_T = sASPhysicalDrive.getPartitionInfo(sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getosDriveNumber());
                for (int j = 0; j < sL_PARTITION_INFO_T.getPartitionCount(); ++j) {
                    if (sL_PARTITION_INFO_T.getPartitionDetails()[j].getBootIndicator() != 1) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isEKMSecuredLockedDrive() {
        return this.phDevice.getInformation().getSecurity_MR_PD_INFO().isEKMNeeded();
    }

    public String getProductID() {
        return this.phDevice.getProductInfo();
    }

    public String getVendorID() {
        return this.phDevice.getVendorInfo();
    }

    public String getPDPowerState() {
        if (this.pdInfo.getPowerState() == 0) {
            return Resource.getString("PROPERTY_POWERSAVE_ON", "On");
        }
        if (this.pdInfo.getPowerState() == -1) {
            return Resource.getString("PROPERTY_TRANSITIONING", "Transitioning");
        }
        if (this.pdInfo.getPowerState() == 1 || this.pdInfo.getdisabledForRemoval() == '\u0001') {
            return Resource.getString("PROPERTY_POWER_SAVE", "Powersave");
        }
        return Resource.getString("PROPERTY_POWERSAVE_ON", "On");
    }

    public int getM_opList_size() {
        return this.m_opList_size;
    }

    public boolean isPDPICapable() {
        properties_MR_PD_INFO properties_MR_PD_INFO2 = this.pdInfo.getproperties_MR_PD_INFO();
        return properties_MR_PD_INFO2 != null && properties_MR_PD_INFO2.getPiEligible() != 0;
    }

    public String dataProtectionType() {
        int n = 0;
        properties_MR_PD_INFO properties_MR_PD_INFO2 = this.pdInfo.getproperties_MR_PD_INFO();
        if (properties_MR_PD_INFO2 != null) {
            n = properties_MR_PD_INFO2.getPiType();
        }
        switch (n) {
            case 0: {
                return Resource.getString("NONE", "None");
            }
            case 1: {
                return Resource.getString("TYPE1", "Type1");
            }
            case 2: {
                return Resource.getString("TYPE2", "Type2");
            }
            case 3: {
                return Resource.getString("TYPE3", "Type3");
            }
        }
        return " ";
    }

    public String getSSDLifeLeftStatus() {
        SASAdapter sASAdapter;
        String string = null;
        if (this.parent.getDeviceObject() instanceof SASAdapter && (sASAdapter = (SASAdapter)this.parent.getDeviceObject()).isWarhawk()) {
            int n = this.phDevice.getSSDInformation().getSSDLifeLeft();
            string = n > this.phDevice.getSSDInformation().getDriveLifeWarningThreshold() ? Resource.getString("PROPERTY_SSD_LIFE_LEFT_OPTIMAL_TEXT", "Optimal") : (n <= this.phDevice.getSSDInformation().getDriveLifeWarningThreshold() && n > this.phDevice.getSSDInformation().getDriveLifeErrorThreshold() ? Resource.getString("PROPERTY_SSD_LIFE_LEFT_NEEDS_ATTENTION_TEXT", "Needs Attention") : Resource.getString("STATUS_EXHAUSTED", "Exhausted"));
        }
        return string;
    }

    public boolean isEligibleForLd() {
        return this.getInformation().getproperties_MR_PD_INFO().getIneligibleForLd() == 0;
    }
}

