/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUIHelper.AdapterHelper;
import GUIHelper.CDROMHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.TapeHelper;
import SASKernel.ISASObject;
import SASKernel.Operations.OperationDetails;
import Services.NetworkToJavaConverter;
import Utils.Resource;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.ImageIcon;

public class PortHelper
extends Observable
implements GUIHelperInterface {
    private int port_id;
    private AdapterHelper adapter;
    private int status = 0;

    public PortHelper(AdapterHelper adapterHelper, int n) {
        this.port_id = n;
        this.adapter = adapterHelper;
    }

    @Override
    public ISASObject getDeviceObject() {
        return null;
    }

    @Override
    public String getText() {
        return Resource.getString("PORT_TEXT", "Port") + " " + this.port_id;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getImageIcon(Resource.getString("PORT_IMAGE", "port.jpg"));
    }

    @Override
    public ArrayList getOperationList() {
        return null;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public EnclosureHelper[] getEnclosures() {
        return this.adapter.getEnclosures(this.port_id);
    }

    public PhysicalDriveHelper[] getPhysicalDrives() {
        return this.adapter.getPhysicalDrives(this.port_id);
    }

    public CDROMHelper[] getCDROMs() {
        return this.adapter.getCDROMs(this.port_id);
    }

    public TapeHelper[] getTapes() {
        TapeHelper[] tapeHelperArray = this.adapter.getTapes();
        ArrayList<TapeHelper> arrayList = new ArrayList<TapeHelper>();
        for (int i = 0; i < tapeHelperArray.length; ++i) {
            if (NetworkToJavaConverter.unsignedIntToLong(tapeHelperArray[i].getEnclosureID()) != 65535L) continue;
            arrayList.add(tapeHelperArray[i]);
        }
        TapeHelper[] tapeHelperArray2 = new TapeHelper[arrayList.size()];
        for (int i = 0; i < tapeHelperArray2.length; ++i) {
            tapeHelperArray2[i] = (TapeHelper)arrayList.get(i);
        }
        return tapeHelperArray2;
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.adapter;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.getStatus() == 2) {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (this.getStatus() == 1) {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

