/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import GUIHelper.GUIHelperInterface;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import GUIHelper.ServerObjectHelper;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import Utils.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.ImageIcon;

public class SasClusterObjectHelper
extends Observable
implements GUIHelperInterface {
    SASKernel kernel = null;
    private ServerObjectHelper[] ser = null;
    private ArrayList servers = null;
    public SASServer loggedInServer = null;
    private SASKernel saskernel = null;
    private ArrayList haDomainServers = null;
    private String clusterId = null;
    private boolean isLoggedinServer = true;
    ArrayList adapList = null;
    int peerNodeActive = 0;
    ServerObjectHelper loggedInServerObjHelper = null;

    public SasClusterObjectHelper() {
        try {
            this.kernel = SASKernel.getInstance();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        this.loggedInServer = this.kernel.getLoggedinServer();
        this.adapList = this.loggedInServer.getAdapterArrayList();
        ArrayList arrayList = new ArrayList();
        arrayList = this.kernel.getLoggedinServer().getInformation().getClusterList();
        for (String this.clusterId : arrayList) {
        }
        for (int i = 0; i < this.adapList.size(); ++i) {
            this.peerNodeActive = ((SASAdapter)this.adapList.get(i)).getInformation().getcluster_MR_CTRL_INFO().getclusterActive();
        }
        this.setPeerNodeActive(this.peerNodeActive);
        this.CreateserverObjectHelpers();
    }

    public SASServer getLoggedInServer() {
        return this.loggedInServer;
    }

    public void setLoggedInServer(SASServer sASServer) {
        this.loggedInServer = sASServer;
    }

    public void CreateserverObjectHelpers() {
        if (this.servers != null) {
            this.servers.clear();
        }
        this.servers = this.kernel.getSASServerArrayList();
        this.haDomainServers = new ArrayList();
        if (this.peerNodeActive == 1) {
            ArrayList arrayList = new ArrayList();
            if (this.loggedInServer.getInformation().ismaxHaNodes()) {
                this.haDomainServers.add(this.loggedInServer);
                for (int i = 0; i < this.servers.size(); ++i) {
                    SASServer sASServer = (SASServer)this.servers.get(i);
                    if (!sASServer.getInformation().ismaxHaNodes()) continue;
                    arrayList = sASServer.getInformation().getClusterList();
                    Iterator iterator = arrayList.iterator();
                    String string = null;
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                    }
                    if (!this.clusterId.equals(string) || sASServer == this.loggedInServer) continue;
                    this.haDomainServers.add(sASServer);
                }
            }
        } else {
            this.haDomainServers.clear();
            this.haDomainServers.add(this.loggedInServer);
        }
        if (this.servers == null || this.servers.size() <= 0) {
            System.out.println("No Server found !");
            this.ser = new ServerObjectHelper[0];
            return;
        }
        this.ser = new ServerObjectHelper[this.haDomainServers.size()];
        for (int i = 0; i < this.ser.length; ++i) {
            if (this.kernel.getLoggedinServer() == this.haDomainServers.get(i)) {
                this.isLoggedinServer = true;
                this.ser[i] = new ServerObjectHelper((SASServer)this.haDomainServers.get(i));
                this.loggedInServerObjHelper = this.ser[i];
                continue;
            }
            this.isLoggedinServer = false;
            this.ser[i] = new ServerObjectHelper((SASServer)this.haDomainServers.get(i), this.isLoggedinServer, this.loggedInServer, this.getServerHelpers().length);
        }
    }

    public ServerObjectHelper getLoggedInServerObjHelper() {
        return this.loggedInServerObjHelper;
    }

    public void setLoggedInServerObjHelper(ServerObjectHelper serverObjectHelper) {
        this.loggedInServerObjHelper = serverObjectHelper;
    }

    public ServerObjectHelper[] getServerHelpers() {
        return this.ser;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            switch (n) {
                default: 
            }
        }
    }

    public int getPeerNodeActive() {
        return this.peerNodeActive;
    }

    public void setPeerNodeActive(int n) {
        this.peerNodeActive = n;
    }

    @Override
    public String getText() {
        return Resource.getString("SERVER_DOMAIN", "Server Domain") + ":" + this.clusterId;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 15;
    }

    @Override
    public GUIHelperInterface getParent() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    @Override
    public ArrayList getOperationList() {
        return null;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROPERTY_CLUSTER_ID", "DomainId");
        propertyInfo.value = this.clusterId;
        propertyInfo.description = Resource.getString("PROPERTY_HOSTNAME_TEXT", "DomainId");
        arrayList.add(propertyInfo);
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("NO_SEREVRS_TAGGED", "No. of Servers Tagged");
        String string = null;
        for (int i = 0; i < this.adapList.size(); ++i) {
            string = ((SASAdapter)this.adapList.get(i)).getInformation().getmaxHANodes() + "";
        }
        propertyInfo2.value = string;
        propertyInfo2.description = Resource.getString("NO_SEREVRS_TAGGED", "No. of Servers Tagged");
        arrayList.add(propertyInfo2);
        return arrayList;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public void setStatus(int n) {
    }

    @Override
    public ISASObject getDeviceObject() {
        return null;
    }
}

