/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PeerVirtualAdapterHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CONFIG_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_LIST_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASServer;
import SASKernel.SASServerInfo;
import SASKernel.VirtualAdapter;
import Topology.TopologyHelper;
import Utils.CustomMsgBox;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class ServerObjectHelper
extends Observable
implements GUIHelperInterface {
    private SASServer server;
    private SASServerInfo serverInfo;
    private int status = 0;
    private boolean m_isCCOHinitialised = false;
    private boolean m_isLoggedinServer = true;
    private static int ServerObjectHelperCount = 1;
    private AdapterHelper[] adap = null;
    private CCOHVirtualAdapterHelper m_ccohVirtualAdapHelper = null;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Server");
    PeerVirtualAdapterHelper[] vadap = null;
    TopologyHelper head = null;

    public ServerObjectHelper(SASServer sASServer) {
        this.server = sASServer;
        this.init();
        this.serverInfo = this.server.getInformation();
        sASServer.addObserver(this);
    }

    public ServerObjectHelper(SASServer sASServer, boolean bl, SASServer sASServer2, int n) {
        this.m_isLoggedinServer = bl;
        this.server = sASServer;
        ServerObjectHelperCount = n;
        this.serverInfo = this.server.getInformation();
        this.createPeerAdapterHelpers(sASServer2);
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.server;
    }

    public void init() {
        this.createAdapterHelpers();
        VirtualAdapter virtualAdapter = this.server.getCCOHVirtualAdapter();
        if (virtualAdapter != null) {
            this.m_isCCOHinitialised = true;
            this.createCCOHVirtualAdapterHelper(virtualAdapter);
        } else {
            this.m_isCCOHinitialised = false;
        }
    }

    @Override
    public String getText() {
        return this.serverInfo.getHostName();
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getImageIcon(Resource.getString("SERVER_IMAGE", "server.png"));
    }

    @Override
    public ArrayList getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        if (m_arrayMenuItem == null) {
            System.out.println("/*****Server Menu : Xml is not populated correctly*******/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                arrayList.add(operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROPERTY_HOSTNAME_TEXT", "Host Name");
        propertyInfo.value = this.serverInfo.getHostName() + "";
        propertyInfo.description = Resource.getString("PROPERTY_HOSTNAME_TEXT", "Host Name");
        arrayList.add(propertyInfo);
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROPERTY_HOSTIP_TEXT", "IP Address");
        propertyInfo2.value = this.serverInfo.getIP() + "";
        propertyInfo2.description = Resource.getString("PROPERTY_HOSTIP_TEXT", "IP Address");
        arrayList.add(propertyInfo2);
        if (!this.server.isCIMOMServer()) {
            Object object;
            PropertyInfo propertyInfo3 = new PropertyInfo();
            propertyInfo3.name = Resource.getString("PROPERTY_HOSTOS_TEXT", "Operating System");
            propertyInfo3.value = this.serverInfo.OperatingSystemName();
            if (propertyInfo3.value == null) {
                propertyInfo3.value = Resource.getString("VALUE_NOT_AVAILABLE", "Not Available");
            } else if (VivaldiStartupDialog.OEM_TYPE == 2561 && ((StringTokenizer)(object = new StringTokenizer(propertyInfo3.value))).countTokens() > 0) {
                propertyInfo3.value = ((StringTokenizer)object).nextToken();
            }
            propertyInfo3.description = Resource.getString("PROPERTY_HOSTOS_TEXT", "Operating System");
            arrayList.add(propertyInfo3);
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("PROPERTY_HOSTOSVER_TEXT", "OS Version");
            ((PropertyInfo)object).value = this.serverInfo.OperatingSystemVersion();
            if (((PropertyInfo)object).value == null) {
                ((PropertyInfo)object).value = Resource.getString("VALUE_NOT_AVAILABLE", "Not Available");
            }
            ((PropertyInfo)object).description = Resource.getString("PROPERTY_HOSTOSVER_TEXT", "OS Version");
            arrayList.add(object);
            PropertyInfo propertyInfo4 = new PropertyInfo();
            propertyInfo4.name = Resource.getString("PROPERTY_HOSTOSARCH_TEXT", "OS Architecture");
            propertyInfo4.value = this.serverInfo.OperatingSystemArch();
            if (propertyInfo4.value == null) {
                propertyInfo4.value = Resource.getString("VALUE_NOT_AVAILABLE", "Not Available");
            }
            propertyInfo4.description = Resource.getString("PROPERTY_HOSTOSARCH_TEXT", "OS Architecture");
            arrayList.add(propertyInfo4);
        }
        return arrayList;
    }

    public void createAdapterHelpers() {
        ArrayList arrayList = this.server.getAdapterArrayList();
        if (arrayList == null || arrayList.size() <= 0) {
            System.out.println("No Adapter found !");
            this.adap = new AdapterHelper[0];
            return;
        }
        this.adap = new AdapterHelper[arrayList.size()];
        for (int i = 0; i < this.adap.length; ++i) {
            this.adap[i] = new AdapterHelper((SASAdapter)arrayList.get(i), this);
        }
    }

    public void createPeerAdapterHelpers(SASServer sASServer) {
        this.vadap = new PeerVirtualAdapterHelper[1];
        this.vadap[0] = new PeerVirtualAdapterHelper(this, sASServer);
    }

    public AdapterHelper[] getAdapterHelpers() {
        return this.adap;
    }

    public PeerVirtualAdapterHelper[] getPeerVirtualAdapterHelpers() {
        return this.vadap;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        switch (notifyObject.getNotifyCode()) {
            case 0x101001: {
                break;
            }
            case 0x101002: {
                new CustomMsgBox(Resource.getString("MSG_PROTOCOL_ERROR", "Fatal Error : Network protocol error !"));
                System.exit(0);
                break;
            }
            case 4099: {
                VivaldiStartupDialog.mainScreen.requestPoll();
                break;
            }
            case 4101: {
                break;
            }
            default: {
                this.serverInfo = this.server.getInformation();
            }
        }
    }

    @Override
    public GUIHelperInterface getParent() {
        return null;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.getStatus() == 2) {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (this.getStatus() == 1) {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        if (this.getStatus() == 3) {
            return this.getImageIcon(Resource.getString("NEEDS_ATTENTION_IMAGE", "needatn.jpg"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    public TopologyHelper getTopologyHelper(boolean bl) {
        int n;
        if (!bl) {
            for (n = 0; n < this.adap.length && !this.adap[n].isTopologyDirty(); ++n) {
            }
            if (n == this.adap.length) {
                return this.head;
            }
        }
        this.head = new TopologyHelper(this, null);
        for (n = 0; n < this.adap.length; ++n) {
            this.head.getChildren().add(this.adap[n].getTopologyHelper());
            this.adap[n].getTopologyHelper().getParentList().add(this.head);
        }
        return this.head;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isCCOHinitialised() {
        return this.m_isCCOHinitialised;
    }

    public void createCCOHVirtualAdapterHelper(VirtualAdapter virtualAdapter) {
        this.m_ccohVirtualAdapHelper = new CCOHVirtualAdapterHelper(virtualAdapter, this);
    }

    public CCOHVirtualAdapterHelper getCCOHVirtualAdapHelper() {
        return this.m_ccohVirtualAdapHelper;
    }

    public boolean canCreateCacheGroup() {
        SL_CCOH_CONFIG_T sL_CCOH_CONFIG_T;
        SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T;
        return this.m_isCCOHinitialised && (sL_CCOH_DEV_LIST_T = ((VirtualAdapter)this.m_ccohVirtualAdapHelper.getDeviceObject()).getCCOHCDs()) != null && sL_CCOH_DEV_LIST_T.getCount() != 0 && (sL_CCOH_CONFIG_T = this.m_ccohVirtualAdapHelper.getCCOHConfig()) == null && ((VirtualAdapter)this.m_ccohVirtualAdapHelper.getDeviceObject()).isCCOHLicenseFound();
    }

    public int getServerObjectHelperCount() {
        return ServerObjectHelperCount;
    }

    public void setServerObjectHelperCount(int n) {
        ServerObjectHelperCount = n;
    }

    public boolean isM_isLoggedinServer() {
        return this.m_isLoggedinServer;
    }

    public void setM_isLoggedinServer(boolean bl) {
        this.m_isLoggedinServer = bl;
    }
}

