/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUI.VivaldiStartupDialog;
import GUI.security.ConfirmFDEDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.OnOffProperties_MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class SpannedDriveGroupHelper
extends Observable
implements GUIHelperInterface {
    private GUIHelperInterface parent;
    private SASArray array;
    private int status = 0;
    private int m_parentIDForSpan;
    private int spannedDriveGroupCount;
    private int CallerIdentifier;
    private AdapterHelper adapter = null;
    private ArrayHelper m_arrayHelper = null;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Spanned Drive Group");

    public SpannedDriveGroupHelper(GUIHelperInterface gUIHelperInterface, int n, int n2) {
        this.parent = gUIHelperInterface;
        this.spannedDriveGroupCount = n;
        this.CallerIdentifier = n2;
    }

    public GUIHelperInterface getObHelperInterface() {
        return this.parent;
    }

    public LogicalDriveHelper[] getLogicalDriveHelpers() {
        int n;
        LogicalDriveHelper[] logicalDriveHelperArray;
        ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
        SASAdapter sASAdapter = (SASAdapter)((SASArray)((ArrayHelper)this.parent).getDeviceObject()).parent();
        LogicalDriveHelper[] logicalDriveHelperArray2 = ((ArrayHelper)this.parent).getLogicalDriveHelpers();
        SASArray sASArray = (SASArray)((ArrayHelper)this.parent).getDeviceObject();
        if (logicalDriveHelperArray2 != null && logicalDriveHelperArray2.length > 0) {
            try {
                logicalDriveHelperArray = sASArray.getLogicalDriveList();
                for (n = 0; n < logicalDriveHelperArray2.length; ++n) {
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelperArray2[n].getDeviceObject();
                    if (!logicalDriveHelperArray.contains(sASLogicalDrive)) continue;
                    arrayList.add(logicalDriveHelperArray2[n]);
                }
            }
            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                // empty catch block
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            logicalDriveHelperArray = new LogicalDriveHelper[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                logicalDriveHelperArray[n] = (LogicalDriveHelper)arrayList.get(n);
            }
            return logicalDriveHelperArray;
        }
        return null;
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.array;
    }

    @Override
    public String getText() {
        System.out.println(" SDG getText");
        LogicalDriveHelper[] logicalDriveHelperArray = ((ArrayHelper)this.parent).getLogicalDriveHelpers();
        return Resource.getString("SPANNED_DRIVE_GROUP_TEXT", "Spanned Drive Group") + ": " + this.spannedDriveGroupCount + ", " + logicalDriveHelperArray[0].getRaidLevelString();
    }

    public int getSpanDepth() {
        LogicalDriveHelper[] logicalDriveHelperArray = ((ArrayHelper)this.parent).getLogicalDriveHelpers();
        if (logicalDriveHelperArray != null && logicalDriveHelperArray.length > 0) {
            return ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth();
        }
        return 0;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public byte getType() {
        return 13;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getImageIcon(Resource.getString("ARRAY_IMAGE", "array.png"));
    }

    @Override
    public ArrayList getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                this.addOperation(arrayList, operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    private void addOperation(ArrayList<OperationDetails> arrayList, OperationDetails operationDetails) {
        if (operationDetails.getOpcode() == 0x30C0000) {
            System.out.println("Inside arrayhelper MR_DCMD_LD_SECURE");
            SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
            try {
                sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)this.getLogicalDriveHelpers()[0].getDeviceObject()).getAllAllowedOperations();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((AdapterHelper)this.parent).isSecuritySupported() && sASLogicalDriveOperationsAllowed != null && sASLogicalDriveOperationsAllowed.isSecure() && !this.isArrayEncrypted() && this.isFDEOnlyDriveGroup()) {
                arrayList.add(operationDetails);
            }
        } else if (operationDetails.getOpcode() == 51642624 && this.isArrayPIEnabled() && this.getSpanDepth() == 1) {
            arrayList.add(operationDetails);
        }
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return true;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
        try {
            if (operationDetails.getOpcode() == 0x30C0000) {
                Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
                PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.parent).getPhysicalDrives();
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
                    if (sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisGlobalSpare() != 1 || sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                    vector.add(physicalDriveHelperArray[i]);
                }
                VivaldiBaseOptionDialog vivaldiBaseOptionDialog = null;
                if (vector.size() > 0) {
                    vivaldiBaseOptionDialog = new ConfirmFDEDialog((Window)VivaldiStartupDialog.mainScreen, vector);
                }
                if (vivaldiBaseOptionDialog != null && vivaldiBaseOptionDialog.getSelectedOption() == 0) {
                    this.array.fireOperation(operationDetails);
                }
            } else if (operationDetails.getOpcode() == 51642624) {
                System.out.println("firing DCMD");
                String string = Resource.getString("MSG_DISABLE_DATA_PROTECTION_TITLE", "Confirm Disable Drive Protection");
                System.out.println("firing DCMD");
                String string2 = Resource.getString("DISABLE_DATA_PROTECTION_TEXT", "<html>If you disable data protection on  drive group, you cannot enable it again. Data<br>protection can only be enabled at the time of drive group creation.<br><br>Are you sure you want to disable data protection?</html>");
                if (CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, string2.toString())) {
                    this.array.fireOperation(operationDetails);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        Object object;
        PropertyInfo propertyInfo;
        System.out.println("getPropertyList()");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        propertyInfo2.value = "";
        arrayList.add(propertyInfo2);
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_TOTAL_CAPACITY", "Total Capacity");
        System.out.println("getTotalCapacity" + this.getTotalCapacity());
        propertyInfo3.value = this.getTotalCapacity();
        propertyInfo3.description = Resource.getString("PROPERTY_TOTAL_CAPACITY", "Total Capacity");
        arrayList.add(propertyInfo3);
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROPERTY_FREE_CAPACITY", "Free Capacity");
        propertyInfo4.value = this.getFreeCapacity();
        propertyInfo4.description = Resource.getString("PROPERTY_FREE_CAPACITY", "Free Capacity");
        arrayList.add(propertyInfo4);
        SASArray sASArray = (SASArray)((ArrayHelper)this.parent).getDeviceObject();
        LogicalDriveHelper[] logicalDriveHelperArray = ((ArrayHelper)this.parent).getLogicalDriveHelpers();
        SASAdapter sASAdapter = (SASAdapter)((SASArray)((ArrayHelper)this.parent).getDeviceObject()).parent();
        boolean bl = sASAdapter.getInformation().getadapterOperations_MR_CTRL_INFO().isSupportSecurity();
        int n = sASAdapter.getInformation().getldOperations_MR_CTRL_INFO().getSupportPowerSavings();
        if (sASAdapter.getInformation().getadapterOperations_MR_CTRL_INFO().isSupportSecurity()) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROP_DSPROP", "<html><b>Drive Security Properties:</b></html>");
            propertyInfo.value = "";
            arrayList.add(propertyInfo);
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("PROPERTY_SECURED", "Secured");
            ((PropertyInfo)object).value = this.isArrayEncrypted() ? Resource.getString("PROPERTY_YES_TEXT", "Yes") : Resource.getString("PROPERTY_No_TEXT", "No");
            ((PropertyInfo)object).description = Resource.getString("PROPERTY_SECURED", "Secured");
            arrayList.add(object);
        }
        if (sASAdapter.getInformation().getldOperations_MR_CTRL_INFO().getSupportPowerSavings() != 0) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("PROP_POWER_STATE_PROP", "<html><b>Power State Properties:</b></html>");
            arrayList.add(propertyInfo);
            object = logicalDriveHelperArray[0];
            PropertyInfo propertyInfo5 = new PropertyInfo();
            propertyInfo5.name = Resource.getString("DEFAULT_POWER_SAVE_POLICY", "Default Power save policy");
            propertyInfo5.value = ((LogicalDriveHelper)object).getDefaultPowerState();
            propertyInfo5.description = Resource.getString("DEFAULT_POWER_SAVE_POLICY", "Default Power save policy");
            arrayList.add(propertyInfo5);
            PropertyInfo propertyInfo6 = new PropertyInfo();
            propertyInfo6.name = Resource.getString("CURRENT_POWER_SAVE_POLICY", "Current Power save policy");
            propertyInfo6.value = ((LogicalDriveHelper)object).getCurrentPowerState();
            propertyInfo6.description = Resource.getString("CURRENT_POWER_SAVE_POLICY", "Current Power save policy");
            arrayList.add(propertyInfo6);
        }
        if (sASAdapter.getInformation().getproperties().getOnOffProperties_MR_CTRL_PROP().getEnablePI() != 0) {
            propertyInfo = new PropertyInfo();
            propertyInfo.name = Resource.getString("DATA_PROTECTION_PROP", "<html><b>Data Protection Properties:</b></html>");
            arrayList.add(propertyInfo);
            object = new PropertyInfo();
            ((PropertyInfo)object).name = Resource.getString("DATA_PROTECTION", "Data Protection");
            ((PropertyInfo)object).value = this.isArrayPIEnabled() ? Resource.getString("PROPERTY_HS_SPIN_DOWN_ENABLED", "Enabled") : Resource.getString("PROPERTY_HS_SPIN_DOWN_DISABLED", "Disabled");
            ((PropertyInfo)object).description = Resource.getString("DATA_PROTECTION", "Data Protection");
            arrayList.add(object);
        }
        return arrayList;
    }

    public PhysicalDriveHelper[] getPhysicalDrives() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.array.getPhysicalDriveList();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        block0: for (int i = 0; i < sASPhysicalDriveArray.length; ++i) {
            for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                if (sASPhysicalDriveArray[i] != physicalDriveHelperArray[j].getDeviceObject()) continue;
                arrayList.add(physicalDriveHelperArray[j]);
                continue block0;
            }
        }
        PhysicalDriveHelper[] physicalDriveHelperArray2 = arrayList.toArray(new PhysicalDriveHelper[0]);
        PhysicalDriveHelper[] physicalDriveHelperArray3 = this.sortPhysicalDrives(physicalDriveHelperArray2);
        return physicalDriveHelperArray3;
    }

    public ArrayList<PhysicalDriveHelper> getPhysicalDrivesArrayList() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.array.getPhysicalDriveList();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            arrayList.add(physicalDriveHelperArray[i]);
        }
        return arrayList;
    }

    public PhysicalDriveHelper[] getPhysicalDrivesforMissingDrives() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.array.getPhysicalDriveListforMissingDrives();
        PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[sASPhysicalDriveArray.length];
        PhysicalDriveHelper[] physicalDriveHelperArray2 = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        block0: for (int i = 0; i < sASPhysicalDriveArray.length; ++i) {
            for (int j = 0; j < physicalDriveHelperArray2.length; ++j) {
                if (sASPhysicalDriveArray[i] != physicalDriveHelperArray2[j].getDeviceObject()) continue;
                physicalDriveHelperArray[i] = physicalDriveHelperArray2[j];
                continue block0;
            }
        }
        return physicalDriveHelperArray;
    }

    public ArrayList getDegradedArrayPhysicalDrives() {
        ArrayList arrayList = this.array.getPhysicalDriveArrayList();
        ArrayList<PhysicalDriveHelper> arrayList2 = new ArrayList<PhysicalDriveHelper>();
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                if ((SASPhysicalDrive)arrayList.get(i) != physicalDriveHelperArray[j].getDeviceObject()) continue;
                arrayList2.add(physicalDriveHelperArray[j]);
                continue block0;
            }
        }
        return arrayList2;
    }

    public PhysicalDriveHelper[] getDedicatedSpares() {
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.getParent()).getPhysicalDrives();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        block3: for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (sASPhysicalDrive.getState() != 2 || !PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equals(Resource.getString("PD_STATE_HOTSPARE_DEDICATED", "Dedicated")) || PhysicalDriveHelper.getHotspareType(sASPhysicalDrive).equals("")) continue;
            try {
                MR_SPARE mR_SPARE = sASPhysicalDrive.getDedicatedHotspareInfo();
                short[] sArray = mR_SPARE.getarrayRef();
                for (int j = 0; j < mR_SPARE.getarrayCount(); ++j) {
                    if (sArray[j] != this.array.getSeqNum()) continue;
                    arrayList.add(physicalDriveHelperArray[i]);
                    continue block3;
                }
                continue;
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                System.out.println("Dedicated Hotspare query failed");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        PhysicalDriveHelper[] physicalDriveHelperArray2 = new PhysicalDriveHelper[arrayList.size()];
        for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
            physicalDriveHelperArray2[i] = (PhysicalDriveHelper)arrayList.get(i);
        }
        return physicalDriveHelperArray2;
    }

    @Override
    public void update(Observable observable, Object object) {
        System.out.println("ArrayHelper.update()");
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL.getcode() == 317 || mR_EVT_DETAIL.getcode() == 316 || mR_EVT_DETAIL.getcode() == 387 || mR_EVT_DETAIL.getcode() == 73) {
            // empty if block
        }
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.parent;
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (this.status == 2) {
            return this.getImageIcon(Resource.getString("DEGRADED_IMAGE", "degraded.png"));
        }
        if (this.status == 1) {
            return this.getImageIcon(Resource.getString("FAILED_IMAGE", "failed.png"));
        }
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    public long getMinSizeForModifySSC() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        if (physicalDriveHelperArray == null || physicalDriveHelperArray.length == 0) {
            return 0L;
        }
        return this.getArraySize() / (long)physicalDriveHelperArray.length;
    }

    public boolean isFDEEncrypted() {
        try {
            ArrayList arrayList = this.array.getLogicalDriveList();
            if (arrayList != null && arrayList.size() > 0) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
                return sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType() == 1;
            }
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        return false;
    }

    public boolean isFDEOnlyDriveGroup() {
        boolean bl = true;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].isFDECapable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isArrayEncrypted() {
        try {
            SASArray sASArray = (SASArray)((ArrayHelper)this.parent).getDeviceObject();
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)sASArray.getLogicalDriveList().get(0);
            byte by = sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType();
            return by != 0;
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
            return false;
        }
    }

    public String getEncryptionMethod() {
        String string = null;
        SASArray sASArray = (SASArray)((ArrayHelper)this.parent).getDeviceObject();
        AdapterHelper adapterHelper = (AdapterHelper)this.parent;
        MR_CTRL_INFO mR_CTRL_INFO = ((SASAdapter)adapterHelper.getDeviceObject()).getInformation();
        OnOffProperties_MR_CTRL_PROP onOffProperties_MR_CTRL_PROP = mR_CTRL_INFO.getproperties().getOnOffProperties_MR_CTRL_PROP();
        if (this.isArrayEncrypted() && !onOffProperties_MR_CTRL_PROP.getUseFdeOnly() && adapterHelper.isSecuritySupported()) {
            long l = sASArray.getSize();
            try {
                ArrayList arrayList = sASArray.getLogicalDriveList();
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
                byte by = sASLogicalDrive.getInformation().getldConfig().getparams().getEncryptionType();
                if (by == 2) {
                    string = Resource.getString("PROP_ENCRYPTION_TYPE_CTRL_BASED", "Controller-based encryption");
                } else if (by == 1) {
                    string = Resource.getString("PROP_ENCRYPTION_TYPE_FDE_BASED", "Full disk encryption");
                }
            }
            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                vKObjectNotPresentException.printStackTrace();
            }
        }
        return string;
    }

    public String getFreeCapacity() {
        SASArray sASArray = (SASArray)((ArrayHelper)this.parent).getDeviceObject();
        String string = null;
        ArrayList arrayList = sASArray.getPhysicalDriveArrayList();
        int n = arrayList.size();
        short s = ((ArrayHelper)this.parent).getBlockSize();
        try {
            long l = sASArray.getSLArrayInformation().gettotalBlocks();
            long l2 = sASArray.getSLArrayInformation().getusedBlocks();
            long l3 = ((ArrayHelper)this.parent).getSpanDepth();
            if (sASArray.getRAIDLevelInfo().getPRL() == 0) {
                string = KernelConstants.getConvertedSize((l - l2) * l3, s);
            } else if (sASArray.getRAIDLevelInfo().getPRL() == 1 || sASArray.getRAIDLevelInfo().getPRL() == 17) {
                string = KernelConstants.getConvertedSize((l - l2) * l3 / 2L, s);
            } else if (sASArray.getRAIDLevelInfo().getPRL() == 5) {
                string = KernelConstants.getConvertedSize((long)(n - 1) * (l - l2) * l3 / (long)n, s);
            } else if (sASArray.getRAIDLevelInfo().getPRL() == 6) {
                string = KernelConstants.getConvertedSize((long)(n - 2) * (l - l2) * l3 / (long)n, s);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
        System.out.println("strFreeCapacity" + string);
        return string;
    }

    public int getNoOfHoles() {
        try {
            return this.array.getSLArrayInformation().getfreeCount();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public long getArraySize() {
        long l = 0L;
        try {
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = this.array.getSLArrayInformation();
            return sL_ARRAY_INFO_T.gettotalBlocks();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return l;
        }
    }

    public String getTotalCapacity() {
        SASArray sASArray = (SASArray)((ArrayHelper)this.parent).getDeviceObject();
        String string = null;
        ArrayList arrayList = sASArray.getPhysicalDriveArrayList();
        int n = arrayList.size();
        try {
            long l = (long)((ArrayHelper)this.parent).getSpanDepth() * sASArray.getSLArrayInformation().gettotalBlocks();
            long l2 = sASArray.getSLArrayInformation().getusedBlocks();
            short s = ((ArrayHelper)this.parent).getBlockSize();
            if (sASArray.getRAIDLevelInfo().getPRL() == 0) {
                string = KernelConstants.getConvertedSize(l, s);
            } else if (sASArray.getRAIDLevelInfo().getPRL() == 1 || sASArray.getRAIDLevelInfo().getPRL() == 17) {
                string = KernelConstants.getConvertedSize(l / 2L, s);
            } else if (sASArray.getRAIDLevelInfo().getPRL() == 5) {
                string = KernelConstants.getConvertedSize((long)(n - 1) * l / (long)n, s);
            } else if (sASArray.getRAIDLevelInfo().getPRL() == 6) {
                string = KernelConstants.getConvertedSize((long)(n - 2) * l / (long)n, s);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
        System.out.println("strFreeCapacity" + string);
        return string;
    }

    public String getRAIDLevel() {
        String string = null;
        try {
            ArrayList arrayList = this.array.getLogicalDriveList();
            if (arrayList != null && arrayList.size() > 0) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)arrayList.get(0);
                string = new String("" + sASLogicalDrive.getInformation().getldConfig().getparams().getPRL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private boolean isRebuildInProgressInThisArray() {
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getDeviceObject().getState() != 20) continue;
            return true;
        }
        return false;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSRArray() {
        LogicalDriveHelper[] logicalDriveHelperArray = this.getLogicalDriveHelpers();
        for (int n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
            if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getsnapshotRepository() != 1) continue;
            return true;
        }
        return false;
    }

    public long getMinDHSPSize() {
        long l = 0L;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getDedicatedSpares();
        if (physicalDriveHelperArray != null && physicalDriveHelperArray.length > 0) {
            l = physicalDriveHelperArray[0].getInformation().getcoercedSize();
            int n = physicalDriveHelperArray.length;
            for (int i = 1; i < n; ++i) {
                long l2 = physicalDriveHelperArray[i].getInformation().getcoercedSize();
                if (l2 >= l) continue;
                l = l2;
            }
        }
        return l;
    }

    public boolean canExpandSSCD(long l) {
        AdapterHelper adapterHelper = (AdapterHelper)this.getParent();
        ArrayHelper[] arrayHelperArray = adapterHelper.getArrays();
        long l2 = 0L;
        for (int n = 0; n < arrayHelperArray.length; n = (int)((byte)(n + 1))) {
            if (!arrayHelperArray[n].isSSCD()) continue;
            l2 += ((SASArray)arrayHelperArray[n].getDeviceObject()).getSize();
        }
        return l2 + l <= adapterHelper.getMaxSSCSizeInBlocks();
    }

    public boolean canSSCBeModified() {
        return this.isAddSSDsPossible() || this.isRemoveSSDsPossible();
    }

    public boolean isRemoveSSDsPossible() {
        return this.getPhysicalDrives().length > 1;
    }

    public boolean isAddSSDsPossible() {
        if (this.getPhysicalDrives().length < 32) {
            ArrayHelper[] arrayHelperArray = ((AdapterHelper)this.parent).getArrays();
            long l = 0L;
            for (int n = 0; n < arrayHelperArray.length; n = (int)((byte)(n + 1))) {
                if (!arrayHelperArray[n].isSSCD()) continue;
                l += arrayHelperArray[n].getArraySize();
            }
            if (l + this.getMinSizeForModifySSC() <= ((AdapterHelper)this.parent).getMaxSSCSizeInBlocks() && this.isUnconfGoodSSDAvailable(this.getMinSizeForModifySSC())) {
                return true;
            }
        }
        return false;
    }

    public boolean isUnconfGoodSSDAvailable(long l) {
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.parent).getPhysicalDrives();
        int n = 0;
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getStatus() != 0 || physicalDriveHelperArray[i].getmediaType() != '\u0001' || physicalDriveHelperArray[i].getSize() < l) continue;
            ++n;
        }
        return n > 0;
    }

    public boolean isArrayPIEnabled() {
        LogicalDriveHelper logicalDriveHelper = this.getLogicalDriveHelpers()[0];
        return logicalDriveHelper.isLDPIEnabled();
    }

    public PhysicalDriveHelper[] sortPhysicalDrives(PhysicalDriveHelper[] physicalDriveHelperArray) {
        int n;
        Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
        for (n = 0; n < physicalDriveHelperArray.length; ++n) {
            PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray[n];
            vector.add(physicalDriveHelper);
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                if (((PhysicalDriveHelper)vector.get(i)).getInformation().getslotNumber() <= ((PhysicalDriveHelper)vector.get(i + 1)).getInformation().getslotNumber()) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            for (int i = 0; i < vector.size() - 1 - n; ++i) {
                int n2 = 0;
                int n3 = 0;
                if (((PhysicalDriveHelper)vector.get(i)).getEnclosureHelper() != null) {
                    n2 = ((PhysicalDriveHelper)vector.get(i)).getEnclosureHelper().getEnclIndexInSortedList();
                }
                if (((PhysicalDriveHelper)vector.get(i + 1)).getEnclosureHelper() != null) {
                    n3 = ((PhysicalDriveHelper)vector.get(i + 1)).getEnclosureHelper().getEnclIndexInSortedList();
                }
                if (n2 <= n3) continue;
                Collections.swap(vector, i, i + 1);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            physicalDriveHelperArray[n] = (PhysicalDriveHelper)vector.get(n);
        }
        return physicalDriveHelperArray;
    }

    public void setParentIdForSpan(int n) {
        this.m_parentIDForSpan = n;
    }

    public int getParentIDForSpan() {
        return this.m_parentIDForSpan;
    }

    public boolean isSSCD() {
        return this.getLogicalDriveHelpers()[0].isSSCD();
    }
}

