/*
 * Decompiled with CFR 0.152.
 */
package GUIHelper;

import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASPhysical.SASTape;
import Utils.Resource;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.ImageIcon;

public class TapeHelper
extends Observable
implements GUIHelperInterface {
    private int ph_id;
    private short deviceID;
    private AdapterHelper parent;
    private MR_PD_INFO pdInfo;
    private int enclosureID;
    private SASTape phDevice;

    public TapeHelper(SASTape sASTape, AdapterHelper adapterHelper) {
        this.phDevice = sASTape;
        this.ph_id = sASTape.getID();
        this.deviceID = sASTape.getDeviceId();
        this.parent = adapterHelper;
        this.pdInfo = sASTape.getInformation();
        this.enclosureID = this.pdInfo.getenclDeviceId();
        sASTape.addObserver(this);
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.phDevice;
    }

    @Override
    public String getText() {
        return Resource.getString("DEV_TAPE_TEXT", "TAPE") + ": " + this.deviceID + ", " + this.getTapeType() + ", " + this.phDevice.getProductInfo();
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String getDescription() {
        return "<html>" + this.getText() + "</html>";
    }

    public String getState() {
        return null;
    }

    @Override
    public byte getType() {
        return 10;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getImageIcon(Resource.getString("TAPE_IMAGE", "tape.png"));
    }

    public int getEnclosureID() {
        return this.enclosureID;
    }

    @Override
    public ArrayList getOperationList() {
        return null;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROPERTY_PRODUCTINFO_TEXT", "Product Info");
        propertyInfo.value = this.phDevice.getProductInfo();
        propertyInfo.description = Resource.getString("PROPERTY_PRODUCTINFO_TEXT", "Product Info");
        arrayList.add(propertyInfo);
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = Resource.getString("PROPERTY_DEVICEID_TEXT", "Device ID");
        propertyInfo2.value = this.phDevice.getDeviceId() + "";
        propertyInfo2.description = Resource.getString("PROPERTY_DEVICEID_TEXT", "Device ID");
        arrayList.add(propertyInfo2);
        PropertyInfo propertyInfo3 = new PropertyInfo();
        propertyInfo3.name = Resource.getString("PROPERTY_VENDORINFO_TEXT", "Vendor ID");
        propertyInfo3.value = this.phDevice.getVendorInfo();
        propertyInfo3.description = Resource.getString("PROPERTY_VENDORINFO_TEXT", "Vendor ID");
        arrayList.add(propertyInfo3);
        PropertyInfo propertyInfo4 = new PropertyInfo();
        propertyInfo4.name = Resource.getString("PROP_SCSIDEVTYPE_TEXT", "SCSI Device Type");
        char c = this.pdInfo.getscsiDevType();
        if (c == '\u0005') {
            propertyInfo4.value = Resource.getString("DEV_CDROM_TEXT", "CDROM");
        } else if (c == '\u0000') {
            propertyInfo4.value = Resource.getString("DEV_DIRECT_TEXT", "Disk");
        } else if (c == '\u0001') {
            propertyInfo4.value = Resource.getString("DEV_TAPE_TEXT", "TAPE");
        }
        propertyInfo4.description = Resource.getString("PROP_SCSIDEVTYPE_TEXT", "SCSI Device Type");
        arrayList.add(propertyInfo4);
        int n = this.pdInfo.getpathInfo_MR_PD_INFO1().getcount();
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo5 = new PropertyInfo();
            propertyInfo5.name = Resource.getString("PROP_PDSASADDR_TEXT", "SAS Address") + " " + i;
            propertyInfo5.value = i < this.pdInfo.getpathInfo_MR_PD_INFO1().getsasAddr().length ? "0x" + Long.toHexString(this.pdInfo.getpathInfo_MR_PD_INFO1().getsasAddr()[i]).toUpperCase() : "";
            propertyInfo5.description = propertyInfo5.name;
            arrayList.add(propertyInfo5);
        }
        PropertyInfo propertyInfo6 = new PropertyInfo();
        propertyInfo6.name = Resource.getString("PROPERTY_REVLEVEL_TEXT", "Revision Level");
        propertyInfo6.value = this.phDevice.getProductRevisionLevel();
        propertyInfo6.description = Resource.getString("PROPERTY_REVLEVEL_TEXT", "Revision Level");
        arrayList.add(propertyInfo6);
        return arrayList;
    }

    public String getScsiDeviceType() {
        char c = this.pdInfo.getscsiDevType();
        if (c == '\u0005') {
            return Resource.getString("DEV_CDROM_TEXT", "CDROM");
        }
        if (c == '\u0000') {
            return Resource.getString("DEV_DIRECT_TEXT", "Disk");
        }
        if (c == '\u0001') {
            return Resource.getString("DEV_TAPE_TEXT", "TAPE");
        }
        return "";
    }

    @Override
    public void setStatus(int n) {
    }

    @Override
    public int getStatus() {
        return this.phDevice.getState();
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.parent;
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTapeType() {
        String string = null;
        switch (this.phDevice.getDriveType()) {
            case 1: {
                string = Resource.getString("PDTYPE_SCSI", "SCSI");
                break;
            }
            case 3: {
                string = Resource.getString("PDTYPE_SATA", "SATA");
                break;
            }
            case 2: {
                string = Resource.getString("PDTYPE_SAS", "SAS");
                break;
            }
            case 4: {
                string = Resource.getString("PDTYPE_FC", "Fibre Channel");
                break;
            }
            default: {
                string = Resource.getString("PDTYPE_UNKNOWN", "Unknown");
            }
        }
        return string;
    }
}

