/*
 * Decompiled with CFR 0.152.
 */
package SASKernel;

import Services.NetworkPacket;
import Services.NetworkToJavaConverter;

public class ClientInfo {
    public static final int MAJOR_NUMBER = 1;
    public static final int MINOR_NUMBER = 0;
    public static final int LISTEN_PORT = 0;
    public static final int CLIENTINFO_LENGTH = 512;
    private int MajorNumber = 1;
    private int MinorNumber = 0;
    private int listenPort = 0;
    private String WWN = null;
    private String version = "2.56";
    private String description = "SASKernel:: Core Application Kernel Engine";

    public ClientInfo() {
    }

    public ClientInfo(byte[] byArray, int n) {
        byte[] byArray2 = new byte[512];
        System.arraycopy(byArray, n, byArray2, 0, 512);
        this.createInfo(byArray2);
    }

    public int getMajorNumber() {
        return this.MajorNumber;
    }

    public void setMajorNumber(int n) {
        this.MajorNumber = n;
    }

    public int getMinorNumber() {
        return this.MinorNumber;
    }

    public void setMinorNumber(int n) {
        this.MinorNumber = n;
    }

    public void setWWN(String string) {
        this.WWN = string;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int n) {
        this.listenPort = n;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(byte[] byArray, int n, int n2) {
        this.version = new String(byArray, n, n2);
    }

    public void setDescription(byte[] byArray, int n, int n2) {
        this.description = new String(byArray, n, n2);
    }

    public String getWWN() {
        return this.WWN;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[512];
        int n = 0;
        NetworkToJavaConverter.intToByteArray(this.MajorNumber, byArray);
        NetworkToJavaConverter.intToByteArray(this.MinorNumber, byArray, n += 4);
        byte[] byArray2 = this.version.getBytes();
        System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length >= 32 ? 32 : byArray2.length);
        NetworkToJavaConverter.intToByteArray(this.listenPort, byArray, n += 32);
        byte[] byArray3 = this.description.getBytes();
        System.arraycopy(byArray3, 0, byArray, n += 4, byArray3.length >= 256 ? 256 : byArray3.length);
        return byArray;
    }

    private void createInfo(byte[] byArray) {
        this.setMajorNumber(NetworkToJavaConverter.byteArrayToInt(byArray, 0));
        this.setMinorNumber(NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        this.setListenPort(NetworkToJavaConverter.byteArrayToInt(byArray, 8));
        this.setWWN(NetworkPacket.convertByteArrayToWWNString(byArray, 12));
        this.setVersion(byArray, 36, 32);
        this.setDescription(byArray, 68, 256);
    }
}

