/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import SASKernel.ConfigurationHelpers.ArrayData;

public class ArrayHoleData {
    private ArrayData aryData;
    private int freeIndex;

    public ArrayHoleData(ArrayData arrayData, int n) {
        this.aryData = arrayData;
        this.freeIndex = n;
    }

    public ArrayData getArrayData() {
        return this.aryData;
    }

    public int getFreeIndex() {
        return this.freeIndex;
    }

    public void setFreeIndex(int n) {
        this.freeIndex = n;
    }

    public long getRaidSpecificFreeSpaceInBlocks(int n) {
        if (this.aryData.getLogicalDriveCount() > 0) {
            long l = this.aryData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[this.freeIndex].getnumBlocks() * (long)this.aryData.getRowSize();
            byte by = this.aryData.getRAIDLevelInfo().getPRL();
            int n2 = this.aryData.getRowSize();
            if (by == 0) {
                return l * (long)n;
            }
            if (by == 1 || by == 17) {
                return l / 2L * (long)n;
            }
            if (by == 5) {
                return l * (long)(n2 - 1) / (long)n2 * (long)n;
            }
            if (by == 6) {
                return l * (long)(n2 - 2) / (long)n2 * (long)n;
            }
        } else {
            return this.aryData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[this.freeIndex].getactualNumBlocks() * (long)this.aryData.getRowSize();
        }
        return 0L;
    }

    protected long getFreeSpaceTotalSizeInBlocks() {
        if (this.aryData.getLogicalDriveCount() > 0) {
            return this.aryData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[this.freeIndex].getnumBlocks() * (long)this.aryData.getRowSize();
        }
        return this.aryData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[this.freeIndex].getactualNumBlocks() * (long)this.aryData.getRowSize();
    }

    protected long getFreeSpaceStartBlock() {
        return this.aryData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[this.freeIndex].getstartBlock();
    }
}

