/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.AssistedConfigRAIDLevelAndSizeInfo;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.ConfigurationHelpers.RAIDLevelAndSize;
import SASKernel.ConfigurationHelpers.RAIDParameters;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;
import java.util.ListIterator;

public class AssistedConfigEngine
extends ConfigEngine {
    private int redundancy;
    private int arrayoption;
    private int hintLdNumber;
    public static final int REDUNDANCY_ONLY = 1;
    public static final int NO_REDUNDANCY = 2;
    public static final int REDUNDANCY_IF_POSSIBLE = 3;
    public static final int EXISTING_ARRAY_ONLY = 1;
    public static final int NEW_ARRAY_ONLY = 2;
    public static final int ALL_ARRAYS = 3;
    private static final String LD_NAME = "Guided VD ";
    private ArrayList listOfArrayHolesToMakeNewLd = null;
    private ArrayList existingHolesInfo = null;
    private int m_iEncryptionMethod;

    public AssistedConfigEngine(SASAdapter sASAdapter) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        super(sASAdapter);
    }

    public boolean isRedundancyPossible() {
        if (this.getUnconfiguredPDList().size() > 1) {
            return true;
        }
        ArrayList arrayList = this.getArraysWithFreeSpaceRemaining();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayData arrayData = (ArrayData)arrayList.get(i);
            if (!(arrayData.getRAIDLevelInfo() == null ? arrayData.getRowSize() > 1 : arrayData.getRAIDLevelInfo().getPRL() != 0)) continue;
            return true;
        }
        return false;
    }

    public boolean isNoRedundancyPossible() {
        if (this.getUnconfiguredPDList().size() > 0) {
            return true;
        }
        ArrayList arrayList = this.getArraysWithFreeSpaceRemaining();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayData arrayData = (ArrayData)arrayList.get(i);
            if (arrayData.getRAIDLevelInfo().getPRL() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isThereDrivesOfUnEqualSizes() {
        ArrayList arrayList = this.getUnconfiguredPDList();
        long l = 0L;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)listIterator.next();
            if (l == 0L) {
                l = sASPhysicalDrive.getSize();
                continue;
            }
            if (sASPhysicalDrive.getSize() == l) continue;
            return false;
        }
        return true;
    }

    public void setAssistedConfigOptions(int n, int n2) throws IlligalConfigOperationException, MaxConfigLimitCrossedException {
        ArrayList arrayList = new ArrayList(this.getUnconfiguredPDList());
        if ((n2 & 2) != 0 && arrayList.size() > 0) {
            int n3;
            int n4 = arrayList.size() / (n == 1 && this.getMaxFWSupportedPRL() == 1 ? 2 : 8);
            if (n4 < this.getCurrentAdapter().getInformation().getmaxLDs() / this.getMaxLDsperArray()) {
                n4 = this.getCurrentAdapter().getInformation().getmaxLDs() / this.getMaxLDsperArray();
            }
            if ((n3 = arrayList.size() / n4) < 3) {
                n3 = 3;
            }
            if (n3 < 0) {
                n3 = 1;
            }
            n4 = (int)Math.ceil((double)arrayList.size() / (double)n3);
            int n5 = 0;
            int n6 = 0;
            ArrayList arrayList2 = new ArrayList(n3);
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get(i));
                if (n4 - n6 <= 1 || ++n5 != n3) continue;
                this.createNewArray(arrayList2);
                ++n6;
                arrayList2.clear();
                n5 = 0;
            }
            if (arrayList2.size() > 0) {
                this.createNewArray(arrayList2);
            }
        }
        this.redundancy = n;
        this.arrayoption = n2;
    }

    private int getMaxLDsperArray() {
        char c = '\u0000';
        c = this.getCurrentAdapter().getInformation().getmaxLDsPerArray();
        if (c != '\u0000') {
            return c;
        }
        return 16;
    }

    public void setAssistedConfigOptions(int n, int n2, int n3, byte by) throws IlligalConfigOperationException, MaxConfigLimitCrossedException {
        ArrayList arrayList = new ArrayList(this.getUnconfiguredPDList());
        this.hintLdNumber = n3;
        if ((n2 & 2) != 0 && arrayList.size() > 0) {
            ArrayList arrayList2;
            int n4;
            ArrayList arrayList3;
            boolean bl = by == 1;
            int n5 = (int)Math.ceil((double)n3 / (double)this.getMaxLDsperArray());
            int n6 = arrayList.size() / n5;
            if (n == 1 && this.getMaxFWSupportedPRL() == 1) {
                n6 = 2;
            }
            if (n6 < 2 && n == 1) {
                n6 = arrayList.size() != 3 ? 2 : 3;
            }
            if (n6 <= 0) {
                n6 = 1;
            }
            n6 = Math.min(MAX_ROW_SIZE, n6);
            if (bl) {
                arrayList3 = new ArrayList();
                ArrayList arrayList4 = (ArrayList)this.getUnconfiguredPDList().clone();
                for (int i = 0; i < arrayList4.size(); ++i) {
                    if (!((SASPhysicalDrive)arrayList4.get(i)).getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                    arrayList3.add(arrayList4.get(i));
                }
                if (arrayList3.size() > 0) {
                    arrayList4.removeAll(arrayList3);
                    n5 = (int)Math.ceil((double)arrayList3.size() / (double)n6);
                }
                n5 += (int)Math.ceil((double)arrayList4.size() / (double)n6);
            } else {
                if (this.getCurrentAdapter().getInformation().getAdapterStatus_MR_CTRL_INFO().isLockKeyAssigned()) {
                    arrayList3 = new ArrayList();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                        if (!sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getSecured()) continue;
                        arrayList3.add(sASPhysicalDrive);
                    }
                    if (arrayList3.size() > 0 && arrayList3.size() < arrayList.size()) {
                        arrayList.removeAll(arrayList3);
                    }
                }
                n5 = Math.min(n5, (int)Math.ceil((double)arrayList.size() / (double)n6));
            }
            if (n == 1 && arrayList.size() - (n5 - 1) * n6 == 1 && n5 > 1 && this.getMaxFWSupportedPRL() != 1) {
                --n5;
            }
            int n7 = 0;
            int n8 = 0;
            ArrayList<SASPhysicalDrive> arrayList5 = new ArrayList<SASPhysicalDrive>(n6);
            ArrayList<SASPhysicalDrive> arrayList6 = new ArrayList<SASPhysicalDrive>();
            ArrayList arrayList7 = new ArrayList();
            if (bl) {
                Object object;
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    object = (SASPhysicalDrive)arrayList.get(n4);
                    if (!((SASPhysicalDevice)object).getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                    arrayList5.add((SASPhysicalDrive)object);
                    arrayList6.add((SASPhysicalDrive)object);
                    if (n5 - n8 <= 0 || ++n7 != n6) continue;
                    this.createNewArray(arrayList5);
                    ++n8;
                    arrayList5.clear();
                    n7 = 0;
                }
                if (arrayList5.size() > 0) {
                    this.createNewArray(arrayList5);
                    ++n8;
                }
                arrayList7 = (ArrayList)this.getNewArraysCreated().clone();
                for (n4 = 0; n4 < arrayList7.size(); ++n4) {
                    object = (ArrayData)arrayList7.get(n4);
                    ((ArrayData)object).setEncryptionType((byte)1);
                }
                arrayList5.clear();
                n8 = 0;
                arrayList.removeAll(arrayList6);
            }
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                arrayList5.add((SASPhysicalDrive)arrayList.get(n4));
                if (n5 - n8 <= 0 || ++n7 != n6) continue;
                this.createNewArray(arrayList5);
                ++n8;
                arrayList5.clear();
                n7 = 0;
            }
            if (arrayList5.size() > 0) {
                this.createNewArray(arrayList5);
                ++n8;
            }
            if ((arrayList2 = (ArrayList)this.getNewArraysCreated().clone()) != null) {
                arrayList2.removeAll(arrayList7);
            }
            if (bl) {
                by = !this.getCurrentAdapter().getInformation().getproperties().getOnOffProperties_MR_CTRL_PROP().getUseFdeOnly() ? (byte)2 : (byte)0;
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((ArrayData)arrayList2.get(i)).setEncryptionType(by);
                }
            }
        }
        this.redundancy = n;
        this.arrayoption = n2;
    }

    public ArrayList getRAIDLevelAndSize() throws IlligalConfigOperationException {
        int n;
        Object object;
        int n2;
        Object object2;
        int n3;
        AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo = null;
        ArrayList<AssistedConfigRAIDLevelAndSizeInfo> arrayList = new ArrayList<AssistedConfigRAIDLevelAndSizeInfo>();
        ArrayList arrayList2 = this.getArraysWithFreeSpaceRemaining();
        this.existingHolesInfo = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            boolean bl = false;
            object2 = (ArrayData)arrayList2.get(n3);
            if (!((ArrayData)object2).isOld()) continue;
            ArrayList<ArrayData> arrayList4 = new ArrayList<ArrayData>();
            if ((this.arrayoption & 1) == 0 && ((ArrayData)object2).isOld() || (this.arrayoption & 2) == 0 && !((ArrayData)object2).isOld()) continue;
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                if (!((ArrayList)arrayList3.get(n2)).contains(object2)) continue;
                bl = true;
            }
            if (bl) continue;
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                ArrayData arrayData = (ArrayData)arrayList2.get(n2);
                if (!((ArrayData)object2).canSpan(arrayData)) continue;
                arrayList4.add(arrayData);
            }
            arrayList3.add(arrayList4);
        }
        this.listOfArrayHolesToMakeNewLd = new ArrayList();
        for (n3 = 0; n3 < arrayList3.size(); ++n3) {
            object2 = (ArrayList)arrayList3.get(n3);
            int n4 = ((ArrayData)((ArrayList)object2).get(0)).getSLArrayInfoT().getfreeCount();
            n2 = 0;
            for (int i = 0; i < n4; ++i) {
                object = new ArrayList<ArrayHoleData>();
                for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                    ArrayData arrayData = (ArrayData)((ArrayList)object2).get(n);
                    ArrayHoleData arrayHoleData = new ArrayHoleData(arrayData, n2);
                    ((ArrayList)object).add(arrayHoleData);
                }
                this.listOfArrayHolesToMakeNewLd.add(object);
                ++n2;
            }
        }
        for (n3 = 0; n3 < this.listOfArrayHolesToMakeNewLd.size(); ++n3) {
            object2 = (ArrayList)this.listOfArrayHolesToMakeNewLd.get(n3);
            ArrayList arrayList5 = this.getPossibleRAIDLevelAndSize((ArrayList)object2);
            n2 = -1;
            byte by = ((ArrayHoleData)((ArrayList)object2).get(0)).getArrayData().getGUIRAIDLevel();
            for (int i = 0; i < arrayList5.size(); ++i) {
                if (((RAIDLevelAndSize)arrayList5.get(i)).getGUIRAIDLevel() != by) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                n2 = 0;
            }
            object = (RAIDLevelAndSize)arrayList5.get(n2);
            n = 0;
            assistedConfigRAIDLevelAndSizeInfo = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((AssistedConfigRAIDLevelAndSizeInfo)arrayList.get(i)).getRaidLevel() != ((RAIDLevelAndSize)object).getGUIRAIDLevel()) continue;
                assistedConfigRAIDLevelAndSizeInfo = (AssistedConfigRAIDLevelAndSizeInfo)arrayList.get(i);
                n = 1;
            }
            if (assistedConfigRAIDLevelAndSizeInfo == null) {
                assistedConfigRAIDLevelAndSizeInfo = new AssistedConfigRAIDLevelAndSizeInfo(((RAIDLevelAndSize)object).getGUIRAIDLevel());
            }
            this.existingHolesInfo.add(new RAIDLevelAndSize(((RAIDLevelAndSize)object).getGUIRAIDLevel(), ((RAIDLevelAndSize)object).getMinSizeInBlocks(), ((RAIDLevelAndSize)object).getMaxSizeInBlocks()));
            assistedConfigRAIDLevelAndSizeInfo.addHoleIndex(n3);
            assistedConfigRAIDLevelAndSizeInfo.addMaxSizeInBlocks(((RAIDLevelAndSize)object).getMaxSizeInBlocks());
            if (((RAIDLevelAndSize)object).getMinSizeInBlocks() < assistedConfigRAIDLevelAndSizeInfo.getMinSizeInBlocks() || assistedConfigRAIDLevelAndSizeInfo.getMinSizeInBlocks() == 0L) {
                assistedConfigRAIDLevelAndSizeInfo.setMinSizeInBlocks(((RAIDLevelAndSize)object).getMinSizeInBlocks());
            }
            assistedConfigRAIDLevelAndSizeInfo.addToListOfArrayHolesForExistingRAIDLevel((ArrayList)object2);
            if (n != 0) continue;
            arrayList.add(assistedConfigRAIDLevelAndSizeInfo);
        }
        ArrayList arrayList6 = this.getRAIDLevelAndSizeFromNewArray();
        for (int i = 0; i < arrayList6.size(); ++i) {
            arrayList.add((AssistedConfigRAIDLevelAndSizeInfo)arrayList6.get(i));
        }
        return arrayList;
    }

    public ArrayList getRAIDLevelAndSizeFromNewArray() throws IlligalConfigOperationException {
        AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo = null;
        AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo2 = null;
        AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo3 = null;
        ArrayList arrayList = this.getArraysWithFreeSpaceRemaining();
        assistedConfigRAIDLevelAndSizeInfo = new AssistedConfigRAIDLevelAndSizeInfo(0);
        assistedConfigRAIDLevelAndSizeInfo2 = new AssistedConfigRAIDLevelAndSizeInfo(1);
        assistedConfigRAIDLevelAndSizeInfo3 = new AssistedConfigRAIDLevelAndSizeInfo(5);
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayData arrayData = (ArrayData)arrayList.get(i);
            if (arrayData.isOld() || (this.arrayoption & 1) == 0 && arrayData.isOld() || (this.arrayoption & 2) == 0 && !arrayData.isOld()) continue;
            block1: for (int j = 0; j < arrayData.getSLArrayInfoT().getfreeCount(); ++j) {
                ArrayHoleData arrayHoleData = new ArrayHoleData(arrayData, j);
                ArrayList<ArrayHoleData> arrayList2 = new ArrayList<ArrayHoleData>(1);
                arrayList2.add(arrayHoleData);
                ArrayList arrayList3 = this.getPossibleRAIDLevelAndSize(arrayList2);
                for (int k = 0; k < arrayList3.size(); ++k) {
                    RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)arrayList3.get(k);
                    if (rAIDLevelAndSize.getFWPRL() == 0 && (this.redundancy == 2 || this.redundancy == 3 && arrayList3.size() == 1)) {
                        assistedConfigRAIDLevelAndSizeInfo.addMaxSizeInBlocks(rAIDLevelAndSize.getMaxSizeInBlocks());
                        if (rAIDLevelAndSize.getMinSizeInBlocks() < assistedConfigRAIDLevelAndSizeInfo.getMinSizeInBlocks() || assistedConfigRAIDLevelAndSizeInfo.getMinSizeInBlocks() == 0L) {
                            assistedConfigRAIDLevelAndSizeInfo.setMinSizeInBlocks(rAIDLevelAndSize.getMinSizeInBlocks());
                        }
                        assistedConfigRAIDLevelAndSizeInfo.addToListOfArrays(arrayHoleData.getArrayData());
                        continue block1;
                    }
                    if (rAIDLevelAndSize.getFWPRL() == 1 && (this.redundancy & 1) != 0) {
                        assistedConfigRAIDLevelAndSizeInfo2.addMaxSizeInBlocks(rAIDLevelAndSize.getMaxSizeInBlocks());
                        if (rAIDLevelAndSize.getMinSizeInBlocks() < assistedConfigRAIDLevelAndSizeInfo2.getMinSizeInBlocks() || assistedConfigRAIDLevelAndSizeInfo2.getMinSizeInBlocks() == 0L) {
                            assistedConfigRAIDLevelAndSizeInfo2.setMinSizeInBlocks(rAIDLevelAndSize.getMinSizeInBlocks());
                        }
                        assistedConfigRAIDLevelAndSizeInfo2.addToListOfArrays(arrayHoleData.getArrayData());
                        continue block1;
                    }
                    if (rAIDLevelAndSize.getFWPRL() != 5 || (this.redundancy & 1) == 0) continue;
                    assistedConfigRAIDLevelAndSizeInfo3.addMaxSizeInBlocks(rAIDLevelAndSize.getMaxSizeInBlocks());
                    if (rAIDLevelAndSize.getMinSizeInBlocks() < assistedConfigRAIDLevelAndSizeInfo3.getMinSizeInBlocks() || assistedConfigRAIDLevelAndSizeInfo3.getMinSizeInBlocks() == 0L) {
                        assistedConfigRAIDLevelAndSizeInfo3.setMinSizeInBlocks(rAIDLevelAndSize.getMinSizeInBlocks());
                    }
                    assistedConfigRAIDLevelAndSizeInfo3.addToListOfArrays(arrayHoleData.getArrayData());
                    continue block1;
                }
            }
        }
        ArrayList<AssistedConfigRAIDLevelAndSizeInfo> arrayList4 = new ArrayList<AssistedConfigRAIDLevelAndSizeInfo>();
        if (assistedConfigRAIDLevelAndSizeInfo.getMaxSizeInBlocks() != 0L) {
            arrayList4.add(assistedConfigRAIDLevelAndSizeInfo);
        }
        if (assistedConfigRAIDLevelAndSizeInfo2.getMaxSizeInBlocks() != 0L) {
            arrayList4.add(assistedConfigRAIDLevelAndSizeInfo2);
        }
        if (assistedConfigRAIDLevelAndSizeInfo3.getMaxSizeInBlocks() != 0L) {
            arrayList4.add(assistedConfigRAIDLevelAndSizeInfo3);
        }
        return arrayList4;
    }

    public boolean checkDDFParitition(AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo) {
        ArrayList arrayList = assistedConfigRAIDLevelAndSizeInfo.getListOfArrays();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayData arrayData = (ArrayData)arrayList.get(i);
                if (arrayData.getSLArrayInfoT().getldCount() + arrayData.getLdMapSize() <= 16 || this.getCurrentAdapter().getInformation().getmaxLDsPerArray() != '@' || this.getCurrentAdapter().getInformation().getpartitionsInDDF() != '\u0010') continue;
                return true;
            }
        }
        return false;
    }

    public void createLogicalDrives(AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo, int n, String string) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        ArrayList arrayList;
        ArrayHoleData arrayHoleData;
        int n2;
        int n3;
        Object object;
        int n4;
        long l = assistedConfigRAIDLevelAndSizeInfo.getSelectedSizeInBlocks();
        int n5 = 0;
        long l2 = 0L;
        long l3 = l;
        long l4 = assistedConfigRAIDLevelAndSizeInfo.getSelectedSizeInBlocks() * 100L / assistedConfigRAIDLevelAndSizeInfo.getMaxSizeInBlocks();
        ArrayList arrayList2 = assistedConfigRAIDLevelAndSizeInfo.getListOfArrayHolesForExistingRAIDLevel();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (arrayList2.size() > 0) {
            n6 = assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives() % arrayList2.size();
            n7 = (assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives() - n6) / arrayList2.size();
        }
        if (n7 < 1) {
            n7 = 1;
        }
        ArrayList arrayList3 = assistedConfigRAIDLevelAndSizeInfo.getHoleIndexs();
        int[] nArray = new int[arrayList2.size()];
        int[] nArray2 = new int[arrayList2.size()];
        int n9 = 0;
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            object = (ArrayList)arrayList2.get(n4);
            n8 = n7 + n9;
            if (n4 == arrayList2.size() - 1) {
                n8 += n6;
            }
            if (n8 > (n3 = ((ArrayHoleData)((ArrayList)object).get(0)).getArrayData().getMaxLDSThatCanBeAddedToThisArray())) {
                n9 = n8 - n3;
                n8 = n3;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (n9 <= nArray2[n2]) {
                        int n10 = n2;
                        nArray[n10] = nArray[n10] + n9;
                        int n11 = n2;
                        nArray2[n11] = nArray2[n11] - n9;
                        continue;
                    }
                    int n12 = n2;
                    nArray[n12] = nArray[n12] + nArray2[n2];
                    nArray2[n2] = 0;
                    n9 -= nArray2[n2];
                }
            }
            nArray2[n4] = n3 - n8;
            nArray[n4] = n8;
        }
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            object = (ArrayList)arrayList2.get(n4);
            if (n4 == arrayList2.size() - 1) {
                n7 += n6;
            }
            n8 = nArray[n4];
            for (n3 = 0; n3 < ((ArrayList)object).size(); ++n3) {
                ((ArrayHoleData)((ArrayList)object).get(n3)).setFreeIndex(0);
            }
            n3 = (Integer)arrayList3.get(n4);
            l2 = ((RAIDLevelAndSize)this.existingHolesInfo.get(n3)).getMaxSizeInBlocks() / (long)n8;
            l2 = l2 * l4 / 100L;
            for (n2 = 0; n2 < n8; ++n2) {
                byte by = 0;
                while (this.getOccupiedLDIDList()[by] != 0) {
                    by = (byte)(by + 1);
                }
                arrayHoleData = (ArrayHoleData)((ArrayList)object).get(0);
                ArrayData arrayData = arrayHoleData.getArrayData();
                LDData lDData = new LDData((ArrayList)object, assistedConfigRAIDLevelAndSizeInfo.getRaidLevel(), l2, this, by, (byte)n);
                lDData.setName(string + by);
                lDData.setInitState((byte)1);
                lDData.setEncryptionType((char)arrayData.getEncryptionType());
                RAIDParameters rAIDParameters = RAIDParameters.getDefaultParams(SASKernel.getOemType(), this.getmfcDefaults(), this.adapter, lDData.getGUIRAIDLavel());
                lDData.setStripeSize(rAIDParameters.getStripeSize());
                lDData.setPolicy(rAIDParameters.getReadPolicy(), rAIDParameters.getWritePolicy(), rAIDParameters.getIoPolicy(), (byte)0, (byte)2);
                this.addNewLD(lDData);
                if (++n5 == assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives()) break;
                l3 -= lDData.getSizeInBlocks();
            }
            if (n5 == assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives()) break;
        }
        if ((arrayList = assistedConfigRAIDLevelAndSizeInfo.getListOfArrays()).size() < 1) {
            return;
        }
        object = new short[arrayList.size()];
        n3 = 0;
        for (n2 = 0; n2 < assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives(); ++n2) {
            while (true) {
                ArrayData arrayData;
                if (n3 == arrayList.size()) {
                    n3 = 0;
                }
                if ((arrayData = (ArrayData)arrayList.get(n3)).getMaxLDSThatCanBeAddedToThisArray() > object[n3]) break;
                ++n3;
            }
            Object object2 = object;
            int n13 = n3++;
            object2[n13] = (short)(object2[n13] + true);
        }
        block8: for (n2 = 0; n2 < arrayList.size() && n5 < assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives(); ++n2) {
            ArrayData arrayData = (ArrayData)arrayList.get(n2);
            while (n5 < assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives()) {
                Object object3;
                long l5 = l / (long)(assistedConfigRAIDLevelAndSizeInfo.getSelectedNumLogicalDrives() - n5);
                if (!arrayData.canAddLd() || object[n2] <= 0) continue block8;
                arrayHoleData = new ArrayHoleData(arrayData, 0);
                Object object4 = object;
                int n14 = n2;
                object4[n14] = (short)(object4[n14] - true);
                long l6 = 0L;
                for (int i = 0; i < arrayData.getSLArrayInfoT().getfreeCount(); ++i) {
                    l6 += LDData.convertSizeToRAIDSize(arrayData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[i].getnumBlocks() * (long)arrayData.getRowSize(), assistedConfigRAIDLevelAndSizeInfo.getRaidLevel(), arrayData.getRowSize());
                }
                long l7 = LDData.convertSizeToRAIDSize(arrayHoleData.getFreeSpaceTotalSizeInBlocks(), assistedConfigRAIDLevelAndSizeInfo.getRaidLevel(), arrayHoleData.getArrayData().getRowSize());
                long l8 = Math.min(l7, l6 / (long)object3);
                l8 = Math.min(l8, l5);
                byte by = 0;
                while (this.getOccupiedLDIDList()[by] != 0) {
                    by = (byte)(by + 1);
                }
                ArrayList<ArrayHoleData> arrayList4 = new ArrayList<ArrayHoleData>(1);
                arrayList4.add(arrayHoleData);
                LDData lDData = new LDData(arrayList4, assistedConfigRAIDLevelAndSizeInfo.getRaidLevel(), l8, this, by, (byte)n);
                lDData.setName(string + by);
                lDData.setInitState((byte)1);
                lDData.setEncryptionType((char)arrayData.getEncryptionType());
                lDData.setStripeSize((byte)n);
                lDData.setPolicy((byte)12, (byte)1, (byte)96, (byte)0, (byte)1);
                this.addNewLD(lDData);
                ++n5;
                l -= lDData.getSizeInBlocks();
            }
        }
    }

    public int getHintLDNumber() {
        return this.hintLdNumber;
    }
}

