/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.ConfigurationHelpers.RAIDLevelAndSize;
import SASKernel.ConfigurationHelpers.SpareData;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.raidLevels_MR_CTRL_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class ConfigEngine
extends BaseConfigEngine {
    public ConfigEngine(SASAdapter sASAdapter) throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        super(sASAdapter);
    }

    @Override
    protected void init() throws ConfigurationNotAllowedException, IlligalConfigOperationException {
        int n;
        for (n = 0; this.actArrayObjectList != null && n < this.actArrayObjectList.size(); ++n) {
            SASArray sASArray;
            SL_ARRAY_INFO_T sL_ARRAY_INFO_T = null;
            SASArray sASArray2 = (SASArray)this.actArrayObjectList.get(n);
            try {
                sL_ARRAY_INFO_T = sASArray2.getSLArrayInformation();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                throw new ConfigurationNotAllowedException();
            }
            if (sL_ARRAY_INFO_T.getfreeCount() <= 0 || sL_ARRAY_INFO_T.getldCount() >= MAX_LDS_PER_ARRAY) continue;
            ArrayData arrayData = new ArrayData(sL_ARRAY_INFO_T, new ArrayList<SASPhysicalDrive>(Arrays.asList(((SASArray)this.actArrayObjectList.get(n)).getPhysicalDriveList())), true, this);
            arrayData.purgeTooSmallAFreeSpace();
            if (arrayData.getSLArrayInfoT().getfreeCount() <= 0 || (sASArray = (SASArray)this.actArrayObjectList.get(n)).isRebuildInProgress()) continue;
            arrayData.addToArrayList(this.oldArrayWithSpaceList);
            arrayData.setOldSparesDedicatedToThisArray(((SASArray)this.actArrayObjectList.get(n)).getDedicatedPhysicalDriveList());
            arrayData.setRAIDLevelInfo(sASArray2.getRAIDLevelInfo());
        }
        for (n = 0; n < this.actLdObjectList.size(); ++n) {
            this.occupiedTargetIDList[((SASLogicalDrive)this.actLdObjectList.get((int)n)).getID()] = 1;
        }
    }

    private ArrayList getListOfArrayWithSpaceInASingleLD(ArrayData arrayData) {
        ArrayList<ArrayData> arrayList = new ArrayList<ArrayData>();
        short s = arrayData.getSLArrayInfoT().getarray().getarrayRef();
        for (int i = 0; i < this.actLdObjectList.size(); ++i) {
            int n;
            ArrayList arrayList2 = ((SASLogicalDrive)this.actLdObjectList.get(i)).getSASArrayList();
            boolean bl = false;
            for (n = 0; n < arrayList2.size(); ++n) {
                if (((SASArray)arrayList2.get(n)).getArrayRef() != s) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            for (n = 0; n < arrayList2.size(); ++n) {
                arrayList.add(this.getArrayDataIfArrayRefMatched(((SASArray)arrayList2.get(n)).getArrayRef()));
            }
            break;
        }
        return arrayList;
    }

    private ArrayData getArrayDataIfArrayRefMatched(short s) {
        for (int i = 0; i < this.oldArrayWithSpaceList.size(); ++i) {
            if (((ArrayData)this.oldArrayWithSpaceList.get(i)).getSLArrayInfoT().getarray().getarrayRef() != s) continue;
            return (ArrayData)this.oldArrayWithSpaceList.get(i);
        }
        return null;
    }

    private void modifyBiggerArrayHolesWithMinHole(ArrayList arrayList) {
        long l = -1L;
        int n = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((ArrayData)arrayList.get(i) == null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (arrayList.get(j) == null) continue;
                    this.oldArrayWithSpaceList.remove(arrayList.get(j));
                }
                return;
            }
            if (i == 0) {
                l = ((ArrayData)arrayList.get(i)).getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[0].getnumBlocks();
                continue;
            }
            if (((ArrayData)arrayList.get(i)).getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[0].getnumBlocks() >= l) continue;
            l = ((ArrayData)arrayList.get(i)).getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[0].getnumBlocks();
            n = i;
        }
        if (n != -1) {
            ArrayData arrayData = (ArrayData)arrayList.get(n);
            freeInfo_SL_ARRAY_INFO_T[] freeInfo_SL_ARRAY_INFO_TArray = arrayData.getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T();
            for (int i = 0; i < arrayData.getSLArrayInfoT().getfreeCount(); ++i) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    ((ArrayData)arrayList.get(j)).getSLArrayInfoT().getfreeInfo_SL_ARRAY_INFO_T()[i].setnumBlocks(freeInfo_SL_ARRAY_INFO_TArray[i].getnumBlocks());
                }
            }
        }
    }

    @Override
    public ArrayData createNewArray(ArrayList arrayList) throws MaxConfigLimitCrossedException, IlligalConfigOperationException {
        if (arrayList.size() > MAX_ROW_SIZE) {
            throw new MaxConfigLimitCrossedException();
        }
        if (this.actArrayObjectList.size() + this.newArrayCreatedList.size() >= MAX_ARRAYS) {
            throw new MaxConfigLimitCrossedException();
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        Object object = arrayList2.listIterator();
        while (object.hasNext()) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)object.next();
            if (this.freePDList.remove(sASPhysicalDrive)) continue;
            throw new IlligalConfigOperationException();
        }
        object = this.createNewArrayFromPDList(arrayList2);
        ((ArrayData)object).addToArrayList(this.newArrayCreatedList);
        return object;
    }

    private ArrayData createNewArrayFromPDList(ArrayList arrayList) throws MaxConfigLimitCrossedException {
        Object object;
        int n;
        pd_MR_ARRAY[] pd_MR_ARRAYArray = new pd_MR_ARRAY[MAX_ROW_SIZE];
        long l = ((SASPhysicalDrive)arrayList.get(0)).getInformation().getcoercedSize();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (SASPhysicalDrive)arrayList.get(n);
            l = Math.min(l, ((SASPhysicalDevice)object).getInformation().getcoercedSize());
            pd_MR_ARRAY pd_MR_ARRAY2 = new pd_MR_ARRAY((SASPhysicalDevice)object);
            pd_MR_ARRAY2.setfwState((short)24);
            pd_MR_ARRAYArray[n] = pd_MR_ARRAY2;
        }
        for (n = arrayList.size(); n < MAX_ROW_SIZE; ++n) {
            pd_MR_ARRAYArray[n] = new pd_MR_ARRAY();
        }
        MR_ARRAY mR_ARRAY = new MR_ARRAY(this.allocArrayRef(), (char)arrayList.size(), pd_MR_ARRAYArray, l);
        object = new ArrayData(new SL_ARRAY_INFO_T(mR_ARRAY), arrayList, false, this);
        return object;
    }

    @Override
    public ArrayList getPossibleRAIDLevelAndSize(ArrayList arrayList) throws IlligalConfigOperationException {
        Object object;
        ArrayList<RAIDLevelAndSize> arrayList2 = new ArrayList<RAIDLevelAndSize>();
        if (arrayList.size() == 0) {
            throw new IlligalConfigOperationException();
        }
        ArrayHoleData arrayHoleData = (ArrayHoleData)arrayList.get(0);
        ArrayData arrayData = arrayHoleData.getArrayData();
        Object object2 = arrayList.listIterator();
        while (object2.hasNext()) {
            object = (ArrayHoleData)object2.next();
            if (arrayData.canSpan(((ArrayHoleData)object).getArrayData())) continue;
            throw new IlligalConfigOperationException();
        }
        object2 = this.adapter.getInformation().getraidLevels_MR_CTRL_INFO();
        object = this.adapter.getInformation().getpdsForRaidLevels_MR_CTRL_INFO();
        long l = ((ArrayHoleData)arrayList.get(0)).getFreeSpaceTotalSizeInBlocks();
        for (int i = 1; i < arrayList.size(); ++i) {
            l = Math.min(l, ((ArrayHoleData)arrayList.get(i)).getFreeSpaceTotalSizeInBlocks());
        }
        long l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks();
        if (l2 <= 2048L) {
            l2 = 2048L;
        }
        long l3 = 0L;
        long l4 = l3 = l * (long)arrayList.size();
        if (l3 >= l2 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_0() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 0) && arrayList.size() > 1 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_00_unsupported() == 0 && SASKernel.getOemType() != 2561) {
            arrayList2.add(new RAIDLevelAndSize(64, l2, l3));
        }
        if (l3 >= l2 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_0() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 0) && arrayList.size() == 1) {
            arrayList2.add(new RAIDLevelAndSize(0, l2, l3));
        }
        if (arrayHoleData.getArrayData().getRowSize() == 2 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_1() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 1) && arrayList.size() == 1) {
            l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() / 2L;
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = arrayHoleData.getFreeSpaceTotalSizeInBlocks() / 2L) >= l2) {
                arrayList2.add(new RAIDLevelAndSize(1, l2, l3));
            }
        } else if (arrayList.size() == 1 && ((pdsForRaidLevels_MR_CTRL_INFO)object).getMinPdRaidLevel_1E_RLQ0() >= 4 && ((pdsForRaidLevels_MR_CTRL_INFO)object).getMinPdRaidLevel_1E0_RLQ0() >= 8 && arrayHoleData.getArrayData().getRowSize() > 2 && arrayHoleData.getArrayData().getRowSize() % 2 == 0 && ((raidLevels_MR_CTRL_INFO)object2).getRaidLevel_1E_RLQ0() != 0 && ((raidLevels_MR_CTRL_INFO)object2).getRaidLevel_1E0_RLQ0() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 17) && SASKernel.getOemType() != 2561) {
            l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() / 2L;
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = arrayHoleData.getFreeSpaceTotalSizeInBlocks() / 2L) >= l2) {
                arrayList2.add(new RAIDLevelAndSize(17, l2, l3));
            }
        } else if (arrayList.size() > 1 && ((pdsForRaidLevels_MR_CTRL_INFO)object).getMinPdRaidLevel_1E_RLQ0() >= 4 && ((pdsForRaidLevels_MR_CTRL_INFO)object).getMinPdRaidLevel_1E0_RLQ0() >= 8 && arrayHoleData.getArrayData().getRowSize() > 2 && arrayHoleData.getArrayData().getRowSize() % 2 == 0 && ((raidLevels_MR_CTRL_INFO)object2).getRaidLevel_1E_RLQ0() != 0 && ((raidLevels_MR_CTRL_INFO)object2).getRaidLevel_1E0_RLQ0() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 17)) {
            l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() * (long)arrayList.size();
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = l4 / 2L) >= l2) {
                arrayList2.add(new RAIDLevelAndSize(81, l2, l3));
            }
        }
        if (arrayHoleData.getArrayData().getRowSize() == 2 && arrayList.size() > 1 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_10() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 1)) {
            l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() * (long)arrayList.size();
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = l4 / 2L) >= l2) {
                arrayList2.add(new RAIDLevelAndSize(65, l2, l3));
            }
        }
        float f = (float)(arrayHoleData.getArrayData().getRowSize() - 1) / (float)arrayHoleData.getArrayData().getRowSize();
        if (arrayHoleData.getArrayData().getRowSize() > 2 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_5() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 5) && arrayList.size() == 1) {
            l2 = (long)((float)arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() * f);
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = (long)((float)arrayHoleData.getFreeSpaceTotalSizeInBlocks() * f)) >= l2) {
                arrayList2.add(new RAIDLevelAndSize(5, l2, l3));
            }
        }
        if (arrayHoleData.getArrayData().getRowSize() > 2 && arrayList.size() > 1 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_50() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 5)) {
            l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() * (long)arrayList.size();
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = (long)((float)l4 * f)) >= l2) {
                arrayList2.add(new RAIDLevelAndSize(69, l2, l3));
            }
        }
        f = (float)(arrayHoleData.getArrayData().getRowSize() - 2) / (float)arrayHoleData.getArrayData().getRowSize();
        if ((SASKernel.getOemType() != 2561 && arrayHoleData.getArrayData().getRowSize() > 2 || SASKernel.getOemType() == 2561 && arrayHoleData.getArrayData().getRowSize() > 3) && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_6() != 0 && (arrayData.getRAIDLevelInfo() == null || arrayData.getRAIDLevelInfo().getPRL() == 6)) {
            l2 = (long)((float)arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() * f);
            if (l2 <= 2048L) {
                l2 = 2048L;
            }
            if ((l3 = (long)((float)arrayHoleData.getFreeSpaceTotalSizeInBlocks() * f)) >= l2 && arrayList.size() == 1) {
                arrayList2.add(new RAIDLevelAndSize(6, l2, l3));
            }
            if (arrayList.size() > 1 && ((raidLevels_MR_CTRL_INFO)object2).getraidLevel_60() != 0) {
                l2 = arrayHoleData.getArrayData().minRAID0LDSizeForThisArrayInBlocks() * (long)arrayList.size();
                if (l2 <= 2048L) {
                    l2 = 2048L;
                }
                if ((l3 = (long)((float)l4 * f)) >= l2) {
                    arrayList2.add(new RAIDLevelAndSize(70, l2, l3));
                }
            }
        }
        return arrayList2;
    }

    @Override
    public void writeConfiguration() throws IlligalConfigOperationException, InternalDataStructureCorruptionException, VKNotRespondingException, VKInvalidOperationException, VKOperationFailedException {
        Object object;
        MR_SPAN[] mR_SPANArray;
        int n;
        int n2;
        Object object2;
        int n3;
        if (this.newLDCreatedList.size() == 0) {
            throw new IlligalConfigOperationException();
        }
        ArrayList arrayList = new ArrayList();
        byte[] byArray = new byte[MAX_ARRAYS];
        for (n3 = 0; n3 < this.newArrayCreatedList.size(); ++n3) {
            if (((ArrayData)this.newArrayCreatedList.get(n3)).isAnyLDDefinedOnThisArray()) continue;
            arrayList.add(this.newArrayCreatedList.get(n3));
        }
        for (n3 = 0; n3 < this.oldArrayWithSpaceList.size(); ++n3) {
            if (!((ArrayData)this.oldArrayWithSpaceList.get(n3)).isAnyLDDefinedOnThisArray()) {
                arrayList.add(this.oldArrayWithSpaceList.get(n3));
                continue;
            }
            byArray[((ArrayData)this.oldArrayWithSpaceList.get((int)n3)).getSLArrayInfoT().getarray().getarrayRef()] = 1;
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            object2 = (ArrayData)arrayList.get(n3);
            if (((ArrayData)object2).isOld()) {
                ((ArrayData)object2).removeOldArray();
                continue;
            }
            ((ArrayData)object2).deleteNewArray();
        }
        ArrayList arrayList2 = new ArrayList();
        object2 = this.hotSpareList.iterator();
        while (object2.hasNext()) {
            SpareData spareData = (SpareData)object2.next();
            if (spareData.isThisOneNewlyReferencingAnyArray()) {
                arrayList2.addAll(spareData.getUnreferencedArrays(byArray));
                continue;
            }
            object2.remove();
        }
        this.fixArrayRefsInLDs();
        Collections.sort(this.newArrayCreatedList, new Comparator(){

            public int compare(Object object, Object object2) {
                ArrayData arrayData = (ArrayData)object;
                ArrayData arrayData2 = (ArrayData)object2;
                return arrayData.getSLArrayInfoT().getarray().getarrayRef() - arrayData2.getSLArrayInfoT().getarray().getarrayRef();
            }
        });
        object2 = new MR_CONFIG_DATA();
        int n4 = this.oldArrayWithSpaceList.size() + this.newArrayCreatedList.size() + arrayList2.size();
        if (n4 == 0) {
            throw new InternalDataStructureCorruptionException();
        }
        MR_ARRAY[] mR_ARRAYArray = new MR_ARRAY[n4];
        int n5 = 0;
        for (n2 = 0; n2 < this.oldArrayWithSpaceList.size(); ++n2) {
            mR_ARRAYArray[n5++] = ((ArrayData)this.oldArrayWithSpaceList.get(n2)).getSLArrayInfoT().getarray();
        }
        for (n2 = 0; n2 < this.newArrayCreatedList.size(); ++n2) {
            mR_ARRAYArray[n5++] = ((ArrayData)this.newArrayCreatedList.get(n2)).getSLArrayInfoT().getarray();
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            mR_ARRAYArray[n5++] = (MR_ARRAY)arrayList2.get(n2);
        }
        n2 = this.newLDCreatedList.size();
        MR_LD_CONFIG[] mR_LD_CONFIGArray = new MR_LD_CONFIG[n2];
        for (n = 0; n < n2; ++n) {
            mR_SPANArray = (MR_SPAN[])this.newLDCreatedList.get(n);
            ArrayList arrayList3 = mR_SPANArray.constituentArrayHoles();
            object = null;
            if (arrayList3 != null && arrayList3.size() > 0) {
                ArrayHoleData arrayHoleData = (ArrayHoleData)arrayList3.get(0);
                object = arrayHoleData.getArrayData();
            }
            mR_LD_CONFIGArray[n] = mR_SPANArray.ld_config;
            if (object == null) continue;
            mR_LD_CONFIGArray[n].getparams().setEncryptionType(((ArrayData)object).getEncryptionType());
        }
        if (n4 > 1) {
            for (n = 0; n < mR_LD_CONFIGArray.length; ++n) {
                int n6;
                mR_SPANArray = mR_LD_CONFIGArray[n].getspan();
                int n7 = mR_LD_CONFIGArray[n].getparams().getspanDepth();
                object = new MR_ARRAY[n7];
                int n8 = 0;
                block9: for (n6 = 0; n6 < n7; ++n6) {
                    for (int i = 0; i < n4; ++i) {
                        if (mR_ARRAYArray[i].getarrayRef() != mR_SPANArray[n6].getarrayRef()) continue;
                        object[n8++] = mR_ARRAYArray[i];
                        continue block9;
                    }
                }
                n6 = n8;
                long l = ((MR_ARRAY)object[0]).getsize();
                for (n8 = 1; n8 < n6; ++n8) {
                    l = Math.min(l, ((MR_ARRAY)object[n8]).getsize());
                }
                for (n8 = 0; n8 < n6; ++n8) {
                    if (((MR_ARRAY)object[n8]).getsize() <= l) continue;
                    ((MR_ARRAY)object[n8]).setsize(l);
                }
            }
        }
        MR_SPARE[] mR_SPAREArray = new MR_SPARE[this.hotSpareList.size()];
        for (int i = 0; i < this.hotSpareList.size(); ++i) {
            mR_SPAREArray[i] = ((SpareData)this.hotSpareList.get(i)).buildMR_SPARE();
        }
        ((MR_CONFIG_DATA)object2).setarray(mR_ARRAYArray);
        ((MR_CONFIG_DATA)object2).setld(mR_LD_CONFIGArray);
        if (this.hotSpareList.size() > 0) {
            ((MR_CONFIG_DATA)object2).setspare(mR_SPAREArray);
        }
        this.adapter.fireConfigOperation(new OperationDetails(1, object2));
    }

    private void fixArrayRefsInLDs() {
        for (int i = 0; i < this.newLDCreatedList.size(); ++i) {
            ((LDData)this.newLDCreatedList.get(i)).updateArrayRefInformation();
        }
    }

    public ArrayList getHotsparesThatCanBeMadeDedicatedToMoreArrays() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.hotSpareList.size(); ++i) {
            if (!((SpareData)this.hotSpareList.get(i)).canThisPDBeDedicatedToMoreArrays()) continue;
            arrayList.add(this.hotSpareList.get(i));
        }
        return arrayList;
    }

    protected void addToSpareList(SpareData spareData) throws InternalDataStructureCorruptionException {
        if (!this.freePDList.remove(spareData.getSASPhysicalDrive())) {
            throw new InternalDataStructureCorruptionException();
        }
        this.hotSpareList.add(spareData);
    }

    protected void returnSpareAsReady(SpareData spareData) throws InternalDataStructureCorruptionException {
        if (!this.hotSpareList.remove(spareData)) {
            throw new InternalDataStructureCorruptionException();
        }
        this.freePDList.add(spareData.getSASPhysicalDrive());
    }
}

