/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.InternalDataStructureCorruptionException;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.freeInfo_SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.raidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.DDFRAIDLevelInfo;
import java.util.ArrayList;
import java.util.ListIterator;

public class LDData {
    private ArrayList arrayHolesOfWhichLDisPart = new ArrayList();
    protected ArrayList containedIn = null;
    public MR_LD_CONFIG ld_config = new MR_LD_CONFIG();
    protected SASAdapter Adapter;
    private long finalLDSizeInBlocks;
    private int sizeDistributionFactor = 1;
    protected BaseConfigEngine engine;
    protected byte guiRAIDLevel;
    protected DDFRAIDLevelInfo raidLevelInfoForLD;

    public LDData(ArrayList arrayList, byte by, long l, BaseConfigEngine baseConfigEngine, byte by2) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        this.engine = baseConfigEngine;
        this.Adapter = baseConfigEngine.getCurrentAdapter();
        raidLevels_MR_CTRL_INFO raidLevels_MR_CTRL_INFO2 = this.Adapter.getInformation().getraidLevels_MR_CTRL_INFO();
        this.guiRAIDLevel = by;
        ArrayHoleData arrayHoleData = (ArrayHoleData)arrayList.get(0);
        byte by3 = 0;
        byte by4 = (byte)(by & 0xFFFFFFBF);
        byte by5 = 0;
        this.sizeDistributionFactor = 1;
        this.finalLDSizeInBlocks = 0L;
        switch (by4) {
            case 0: {
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize();
                break;
            }
            case 1: {
                if (arrayHoleData.getArrayData().getRowSize() != 2) {
                    throw new IlligalConfigOperationException();
                }
                this.sizeDistributionFactor = 1;
                break;
            }
            case 5: {
                if (arrayHoleData.getArrayData().getRowSize() <= 2) {
                    throw new IlligalConfigOperationException();
                }
                by3 = 3;
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize() - 1;
                break;
            }
            case 6: {
                if (arrayHoleData.getArrayData().getRowSize() <= 2) {
                    throw new IlligalConfigOperationException();
                }
                by3 = 3;
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize() - 2;
                break;
            }
            case 17: {
                if (arrayHoleData.getArrayData().getRowSize() >= 3) break;
                throw new IlligalConfigOperationException();
            }
            default: {
                throw new IlligalConfigOperationException();
            }
        }
        this.raidLevelInfoForLD = new DDFRAIDLevelInfo(by4, by5, by3);
        long l2 = l * (long)arrayHoleData.getArrayData().getRowSize() / (long)this.sizeDistributionFactor;
        byte by6 = by4;
        if (by4 == 17) {
            by4 = 1;
            l2 = l * 2L;
        }
        long l3 = 8192 * arrayHoleData.getArrayData().getRowSize();
        int n = 0;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            if (l2 < l3) {
                listIterator.next();
                listIterator.remove();
                continue;
            }
            ArrayHoleData arrayHoleData2 = (ArrayHoleData)listIterator.next();
            arrayHoleData2.getArrayData().setGuiRAIDLevel(by);
            if (arrayHoleData2.getArrayData().getRAIDLevelInfo() != null && !arrayHoleData2.getArrayData().getRAIDLevelInfo().equals(this.raidLevelInfoForLD)) {
                throw new IlligalConfigOperationException();
            }
            if (n >= 8) {
                throw new IlligalConfigOperationException();
            }
            if (!arrayHoleData2.getArrayData().canAddLd()) {
                throw new IlligalConfigOperationException();
            }
            arrayHoleData2.getArrayData().addLogicalDrive(this, arrayHoleData2.getFreeIndex(), l2);
            freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2 = arrayHoleData2.getArrayData().getFreeSpaceOccupiedByLD(this);
            l2 -= freeInfo_SL_ARRAY_INFO_T2.getnumBlocks() * (long)arrayHoleData2.getArrayData().getRowSize();
            this.arrayHolesOfWhichLDisPart.add(arrayHoleData2);
            this.ld_config.getspan()[n].setstartBlock(freeInfo_SL_ARRAY_INFO_T2.getstartBlock());
            long l4 = freeInfo_SL_ARRAY_INFO_T2.getnumBlocks();
            this.ld_config.getspan()[n].setnumBlocks(l4);
            this.ld_config.getspan()[n].setarrayRef(arrayHoleData2.getArrayData().getSLArrayInfoT().getarray().getarrayRef());
            this.finalLDSizeInBlocks = by6 == 17 ? (this.finalLDSizeInBlocks += this.ld_config.getspan()[n].getnumBlocks() * (long)arrayHoleData.getArrayData().getRowSize() / 2L) : (this.finalLDSizeInBlocks += this.ld_config.getspan()[n].getnumBlocks() * (long)this.sizeDistributionFactor);
            ++n;
        }
        if (l2 >= l3) {
            throw new IlligalConfigOperationException();
        }
        if (arrayHoleData.getArrayData().getRowSize() > 2 && by == 17 && baseConfigEngine.getCurrentAdapter().getAdapterType() == 3 || baseConfigEngine.getCurrentAdapter().getAdapterType() == 4) {
            this.ld_config.getparams().setPRL('\u0011');
        } else {
            this.ld_config.getparams().setPRL((char)by4);
        }
        this.ld_config.getparams().setRLQ((char)by3);
        this.ld_config.getparams().setSRL((char)by5);
        this.ld_config.getparams().setnumDrives((char)arrayHoleData.getArrayData().getRowSize());
        this.ld_config.getparams().setspanDepth((char)this.arrayHolesOfWhichLDisPart.size());
        this.ld_config.getparams().setstate('\u0003');
        this.ld_config.getproperties().getldRef().settargetId((char)by2);
    }

    public LDData(ArrayList arrayList, byte by, long l, BaseConfigEngine baseConfigEngine, byte by2, byte by3) throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        int n;
        this.engine = baseConfigEngine;
        this.Adapter = baseConfigEngine.getCurrentAdapter();
        raidLevels_MR_CTRL_INFO raidLevels_MR_CTRL_INFO2 = this.Adapter.getInformation().getraidLevels_MR_CTRL_INFO();
        this.guiRAIDLevel = by;
        ArrayHoleData arrayHoleData = (ArrayHoleData)arrayList.get(0);
        byte by4 = 0;
        byte by5 = (byte)(by & 0xFFFFFFBF);
        byte by6 = 0;
        this.sizeDistributionFactor = 1;
        this.finalLDSizeInBlocks = 0L;
        switch (by5) {
            case 0: {
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize();
                break;
            }
            case 1: {
                if (arrayHoleData.getArrayData().getRowSize() != 2) {
                    throw new IlligalConfigOperationException();
                }
                this.sizeDistributionFactor = 1;
                break;
            }
            case 5: {
                if (arrayHoleData.getArrayData().getRowSize() <= 2) {
                    throw new IlligalConfigOperationException();
                }
                by4 = 3;
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize() - 1;
                break;
            }
            case 6: {
                if (arrayHoleData.getArrayData().getRowSize() <= 2) {
                    throw new IlligalConfigOperationException();
                }
                by4 = 3;
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize() - 2;
                break;
            }
            case 17: {
                if (arrayHoleData.getArrayData().getRowSize() < 2) {
                    throw new IlligalConfigOperationException();
                }
                this.sizeDistributionFactor = arrayHoleData.getArrayData().getRowSize() / 2;
                break;
            }
            default: {
                throw new IlligalConfigOperationException();
            }
        }
        this.raidLevelInfoForLD = new DDFRAIDLevelInfo(by5, by6, by4);
        long l2 = l * (long)arrayHoleData.getArrayData().getRowSize() / (long)this.sizeDistributionFactor;
        long l3 = 8192 * arrayHoleData.getArrayData().getRowSize();
        long l4 = l2 / (long)arrayList.size();
        long l5 = ((ArrayHoleData)arrayList.get(0)).getFreeSpaceTotalSizeInBlocks();
        for (n = 1; n < arrayList.size(); ++n) {
            l5 = Math.min(l5, ((ArrayHoleData)arrayList.get(n)).getFreeSpaceTotalSizeInBlocks());
        }
        n = 0;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            if (l2 < l3) {
                listIterator.next();
                listIterator.remove();
                continue;
            }
            ArrayHoleData arrayHoleData2 = (ArrayHoleData)listIterator.next();
            if (arrayHoleData2.getArrayData().getRAIDLevelInfo() != null && !arrayHoleData2.getArrayData().getRAIDLevelInfo().equals(this.raidLevelInfoForLD)) {
                throw new IlligalConfigOperationException();
            }
            if (n >= 8) {
                throw new IlligalConfigOperationException();
            }
            if (!arrayHoleData2.getArrayData().canAddLd()) {
                throw new IlligalConfigOperationException();
            }
            long l6 = l5;
            if (arrayList.size() > 1) {
                arrayHoleData2.getArrayData().addLogicalDrive(this, arrayHoleData2.getFreeIndex(), l4, by3, l6);
            } else {
                arrayHoleData2.getArrayData().addLogicalDrive(this, arrayHoleData2.getFreeIndex(), l2, by3, l6);
            }
            arrayHoleData2.getArrayData().setGuiRAIDLevel(by);
            freeInfo_SL_ARRAY_INFO_T freeInfo_SL_ARRAY_INFO_T2 = arrayHoleData2.getArrayData().getFreeSpaceOccupiedByLD(this);
            long l7 = freeInfo_SL_ARRAY_INFO_T2.getnumBlocks();
            l2 -= l7 * (long)arrayHoleData2.getArrayData().getRowSize();
            this.arrayHolesOfWhichLDisPart.add(arrayHoleData2);
            this.ld_config.getspan()[n].setstartBlock(freeInfo_SL_ARRAY_INFO_T2.getstartBlock());
            long l8 = l7;
            this.ld_config.getspan()[n].setnumBlocks(l8);
            this.ld_config.getspan()[n].setarrayRef(arrayHoleData2.getArrayData().getSLArrayInfoT().getarray().getarrayRef());
            this.finalLDSizeInBlocks += this.ld_config.getspan()[n].getnumBlocks() * (long)this.sizeDistributionFactor;
            ++n;
        }
        if (l2 >= l3) {
            throw new IlligalConfigOperationException();
        }
        this.ld_config.getparams().setPRL((char)by5);
        this.ld_config.getparams().setRLQ((char)by4);
        this.ld_config.getparams().setSRL((char)by6);
        this.ld_config.getparams().setnumDrives((char)arrayHoleData.getArrayData().getRowSize());
        this.ld_config.getparams().setspanDepth((char)this.arrayHolesOfWhichLDisPart.size());
        this.ld_config.getparams().setstate('\u0003');
        this.ld_config.getproperties().getldRef().settargetId((char)by2);
    }

    public void setName(String string) throws IlligalConfigOperationException {
        byte[] byArray = string.getBytes();
        if (byArray.length > 15) {
            throw new IlligalConfigOperationException();
        }
        System.arraycopy(byArray, 0, this.ld_config.getproperties().getname(), 0, byArray.length < 15 ? byArray.length : 15);
    }

    public void setStripeSize(byte by) throws IlligalConfigOperationException {
        if (by < this.Adapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmin() || by > this.Adapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmax()) {
            throw new IlligalConfigOperationException();
        }
        this.ld_config.getparams().setstripeSize((char)by);
    }

    public void setPolicy(byte by, byte by2, byte by3, byte by4, byte by5) throws IlligalConfigOperationException {
        byte by6 = (byte)(by | by2 | by3);
        this.ld_config.getproperties().setdefaultCachePolicy((char)by6);
        this.ld_config.getproperties().setaccessPolicy((char)by4);
        this.ld_config.getproperties().setdiskCachePolicy((char)by5);
    }

    public void setDiskCachePolicy(byte by) throws IlligalConfigOperationException {
        this.ld_config.getproperties().setdiskCachePolicy((char)by);
    }

    public void setInitState(byte by) throws IlligalConfigOperationException {
        if (by >= 0 && by <= 2) {
            this.ld_config.getparams().setinitState((char)by);
        }
    }

    public void setEncryptionType(char c) {
        ArrayList arrayList = this.constituentArrayHoles();
        if (arrayList != null && arrayList.size() > 0) {
            ArrayHoleData arrayHoleData = (ArrayHoleData)arrayList.get(0);
            ArrayData arrayData = arrayHoleData.getArrayData();
            if (c >= '\u0000' && c <= '\u0002') {
                arrayData.setEncryptionType((byte)c);
            }
        }
    }

    public void deleteNewLD() throws IlligalConfigOperationException, InternalDataStructureCorruptionException {
        if (!this.containedIn.remove(this)) {
            throw new IlligalConfigOperationException();
        }
        for (int i = 0; i < this.arrayHolesOfWhichLDisPart.size(); ++i) {
            ((ArrayHoleData)this.arrayHolesOfWhichLDisPart.get(i)).getArrayData().returnLDSpace(this);
        }
        this.arrayHolesOfWhichLDisPart = null;
        this.engine.freeLDID(this.ld_config.getproperties().getldRef().gettargetId());
    }

    protected void addToList(ArrayList arrayList) {
        arrayList.add(this);
        this.containedIn = arrayList;
    }

    protected void updateArrayRefInformation() {
        for (int i = 0; i < this.arrayHolesOfWhichLDisPart.size(); ++i) {
            short s = ((ArrayHoleData)this.arrayHolesOfWhichLDisPart.get(i)).getArrayData().getSLArrayInfoT().getarray().getarrayRef();
            this.ld_config.getspan()[i].setarrayRef(s);
        }
    }

    public ArrayList constituentArrayHoles() {
        return this.arrayHolesOfWhichLDisPart;
    }

    public long getSizeInBlocks() {
        return this.finalLDSizeInBlocks;
    }

    public String getLDName() {
        return new String(this.ld_config.getproperties().getname()).trim();
    }

    public byte getLDID() {
        return (byte)this.ld_config.getproperties().getldRef().gettargetId();
    }

    static long convertSizeToRAIDSize(long l, byte by, int n) throws IlligalConfigOperationException {
        float f;
        switch (by & 0xFFFFFFBF) {
            case 0: {
                f = 1.0f;
                break;
            }
            case 1: {
                if (n != 2) {
                    throw new IlligalConfigOperationException();
                }
                f = 0.5f;
                break;
            }
            case 5: {
                if (n <= 2) {
                    throw new IlligalConfigOperationException();
                }
                f = (float)(n - 1) / (float)n;
                break;
            }
            default: {
                throw new IlligalConfigOperationException();
            }
        }
        return (long)((float)l * f);
    }

    public byte getGUIRAIDLavel() {
        return this.guiRAIDLevel;
    }

    DDFRAIDLevelInfo getRAIDLevelInfo() {
        return this.raidLevelInfoForLD;
    }

    public SASAdapter getAdapter() {
        return this.Adapter;
    }

    public MR_LD_CONFIG getLdConfig() {
        return this.ld_config;
    }
}

