/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.ConfigurationHelpers;

import KernelExceptions.VKObjectNotPresentException;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASServer;

public class RAIDParameters {
    private byte stripeSize;
    private byte readPolicy;
    private byte writePolicy;
    private byte PRL;
    private byte SRL;
    private byte RLQ;
    private byte initState;
    private byte diskCachePolicy;
    private byte accessPolicy;
    private byte ioPolicy;

    public RAIDParameters(MR_MFC_DEFAULTS mR_MFC_DEFAULTS) {
        this.setIoPolicy(mR_MFC_DEFAULTS.getcachedIo() == 1 ? (byte)96 : 0);
        switch (mR_MFC_DEFAULTS.getreadAhead()) {
            case 1: {
                this.setReadPolicy((byte)4);
                break;
            }
            case 2: {
                this.setReadPolicy((byte)12);
                break;
            }
            default: {
                this.setReadPolicy((byte)0);
            }
        }
        this.setWritePolicy(mR_MFC_DEFAULTS.getwriteBack() == 1 ? (byte)1 : 0);
        this.setStripeSize(mR_MFC_DEFAULTS.getstripeSize());
    }

    public byte getStripeSize() {
        return this.stripeSize;
    }

    public byte getReadPolicy() {
        return this.readPolicy;
    }

    public byte getWritePolicy() {
        return this.writePolicy;
    }

    public byte getIoPolicy() {
        return this.ioPolicy;
    }

    public byte getInitState() {
        return this.initState;
    }

    public byte getDiskCachePolicy() {
        return this.diskCachePolicy;
    }

    public byte getAccessPolicy() {
        return this.accessPolicy;
    }

    public byte getRLQ() {
        return this.RLQ;
    }

    public byte getSRL() {
        return this.SRL;
    }

    public byte getPRL() {
        return this.PRL;
    }

    public void setStripeSize(byte by) {
        this.stripeSize = by;
    }

    public void setReadPolicy(byte by) {
        this.readPolicy = by;
    }

    public void setWritePolicy(byte by) {
        this.writePolicy = by;
    }

    public void setIoPolicy(byte by) {
        this.ioPolicy = by;
    }

    public void setInitState(byte by) {
        this.initState = by;
    }

    public void setDiskCachePolicy(byte by) {
        this.diskCachePolicy = by;
    }

    public void setAccessPolicy(byte by) {
        this.accessPolicy = by;
    }

    public void setRLQ(byte by) {
        this.RLQ = by;
    }

    public void setSRL(byte by) {
        this.SRL = by;
    }

    public void setPRL(byte by) {
        this.PRL = by;
    }

    public static RAIDParameters getDefaultParams(int n, MR_MFC_DEFAULTS mR_MFC_DEFAULTS, SASAdapter sASAdapter, int n2) {
        RAIDParameters rAIDParameters = new RAIDParameters(mR_MFC_DEFAULTS);
        byte by = ((SASServer)sASAdapter.parent()).getInformation().getSystemType();
        switch (n) {
            case 2561: {
                if (by == 8) {
                    rAIDParameters.setWritePolicy((byte)0);
                } else if (by == 4) {
                    if (n2 == 0) {
                        rAIDParameters.setWritePolicy((byte)1);
                    } else {
                        rAIDParameters.setWritePolicy((byte)0);
                    }
                } else {
                    return RAIDParameters.getDefaultParams(71244, mR_MFC_DEFAULTS, sASAdapter, n2);
                }
                return rAIDParameters;
            }
        }
        boolean bl = false;
        try {
            sASAdapter.getBBUObject();
            bl = true;
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        if (!bl && mR_MFC_DEFAULTS.getcacheWhenBBUBad() == 0) {
            rAIDParameters.setWritePolicy((byte)0);
        }
        return rAIDParameters;
    }
}

