/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib.Constants;

import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class SL_CCOH_DEV_CONTENT {
    private int value = 0;
    private int priorityValue = 0;
    private boolean noContentDetected;
    private boolean contentUnknown;
    private boolean mbr;
    private boolean swap;
    private boolean lvm2Member;
    private boolean fileSystem;
    private boolean foreign;

    public SL_CCOH_DEV_CONTENT(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        this.value = NetworkToJavaConverter.byteArrayToInt(byArray, n);
        if (this.value == 0) {
            this.setNoContentDetected(true);
            return;
        }
        int n2 = 0;
        this.setContentUnknown(KernelConstants.getBitValue(this.value, n2));
        this.setMbr(KernelConstants.getBitValue(this.value, ++n2));
        this.setSwap(KernelConstants.getBitValue(this.value, ++n2));
        this.setLvm2Member(KernelConstants.getBitValue(this.value, ++n2));
        this.setFileSystem(KernelConstants.getBitValue(this.value, ++n2));
        this.setForeign(KernelConstants.getBitValue(this.value, ++n2));
        ++n2;
        this.initialisePriorityValue();
    }

    public int getValueInInt() {
        return this.value;
    }

    public int getPriorityValue() {
        return this.priorityValue;
    }

    private void initialisePriorityValue() {
        if (this.isNoContentDetected()) {
            this.priorityValue = 0;
        } else {
            if (this.isContentUnknown()) {
                ++this.priorityValue;
            }
            if (this.isFileSystem()) {
                this.priorityValue += 2;
            }
            if (this.isLvm2Member()) {
                this.priorityValue += 4;
            }
            if (this.isSwap()) {
                this.priorityValue += 8;
            }
            if (this.isMbr()) {
                this.priorityValue += 16;
            }
        }
    }

    public boolean isNoContentDetected() {
        return this.noContentDetected;
    }

    public void setNoContentDetected(boolean bl) {
        this.noContentDetected = bl;
    }

    public boolean isContentUnknown() {
        return this.contentUnknown;
    }

    public void setContentUnknown(int n) {
        this.contentUnknown = n != 0;
    }

    public boolean isMbr() {
        return this.mbr;
    }

    public void setMbr(int n) {
        this.mbr = n != 0;
    }

    public boolean isSwap() {
        return this.swap;
    }

    public void setSwap(int n) {
        this.swap = n != 0;
    }

    public boolean isLvm2Member() {
        return this.lvm2Member;
    }

    public void setLvm2Member(int n) {
        this.lvm2Member = n != 0;
    }

    public boolean isFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(int n) {
        this.fileSystem = n != 0;
    }

    public boolean isForeign() {
        return this.foreign;
    }

    public void setForeign(int n) {
        this.foreign = n != 0;
    }
}

