/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import Services.NetworkToJavaConverter;

public class MR_CONFIG_DATA {
    private int size;
    private short arrayCount;
    private short arraySize;
    private short logDrvCount;
    private short logDrvSize;
    private short sparesCount;
    private short sparesSize;
    private byte[] reserved = new byte[16];
    private MR_ARRAY[] array;
    private MR_LD_CONFIG[] ld;
    private MR_SPARE[] spare;

    public MR_CONFIG_DATA(byte[] byArray, int n) {
        int n2;
        boolean bl = false;
        this.size = NetworkToJavaConverter.byteArrayToInt(byArray, n);
        this.arrayCount = NetworkToJavaConverter.byteArrayToShort(byArray, n += 4);
        this.arraySize = NetworkToJavaConverter.byteArrayToShort(byArray, n += 2);
        this.logDrvCount = NetworkToJavaConverter.byteArrayToShort(byArray, n += 2);
        this.logDrvSize = NetworkToJavaConverter.byteArrayToShort(byArray, n += 2);
        this.sparesCount = NetworkToJavaConverter.byteArrayToShort(byArray, n += 2);
        this.sparesSize = NetworkToJavaConverter.byteArrayToShort(byArray, n += 2);
        n += 2;
        n += 16;
        this.array = new MR_ARRAY[this.getarrayCount()];
        for (n2 = 0; n2 < this.array.length; ++n2) {
            this.array[n2] = new MR_ARRAY(byArray, n);
            n += this.getarraySize();
        }
        this.ld = new MR_LD_CONFIG[this.getlogDrvCount()];
        for (n2 = 0; n2 < this.ld.length; ++n2) {
            this.ld[n2] = new MR_LD_CONFIG(byArray, n);
            n += this.getlogDrvSize();
        }
        this.spare = new MR_SPARE[this.getsparesCount()];
        for (n2 = 0; n2 < this.spare.length; ++n2) {
            this.spare[n2] = new MR_SPARE(byArray, n);
            n += this.getsparesSize();
        }
    }

    public MR_CONFIG_DATA() {
        this.size = 32;
        this.sparesSize = (short)40;
        this.sparesCount = 0;
    }

    public int getsize() {
        return this.size;
    }

    public short getarrayCount() {
        return this.arrayCount;
    }

    public short getarraySize() {
        return this.arraySize;
    }

    public short getlogDrvCount() {
        return this.logDrvCount;
    }

    public short getlogDrvSize() {
        return this.logDrvSize;
    }

    public short getsparesCount() {
        return this.sparesCount;
    }

    public short getsparesSize() {
        return this.sparesSize;
    }

    public byte[] getreserved() {
        return this.reserved;
    }

    public MR_ARRAY[] getarray() {
        return this.array;
    }

    public MR_LD_CONFIG[] getld() {
        return this.ld;
    }

    public MR_SPARE[] getspare() {
        return this.spare;
    }

    public byte[] getByteArray() {
        int n;
        byte[] byArray = new byte[this.getsize()];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(this.getsize(), byArray, n2);
        NetworkToJavaConverter.shortTobyteArray(this.getarrayCount(), byArray, n2 += 4);
        NetworkToJavaConverter.shortTobyteArray(this.getarraySize(), byArray, n2 += 2);
        NetworkToJavaConverter.shortTobyteArray(this.getlogDrvCount(), byArray, n2 += 2);
        NetworkToJavaConverter.shortTobyteArray(this.getlogDrvSize(), byArray, n2 += 2);
        NetworkToJavaConverter.shortTobyteArray(this.getsparesCount(), byArray, n2 += 2);
        NetworkToJavaConverter.shortTobyteArray(this.getsparesSize(), byArray, n2 += 2);
        n2 += 18;
        for (n = 0; n < this.arrayCount; ++n) {
            System.arraycopy(this.array[n].getByteArray(), 0, byArray, n2, this.arraySize);
            n2 += this.arraySize;
        }
        for (n = 0; n < this.logDrvCount; ++n) {
            System.arraycopy(this.ld[n].getByteArray(), 0, byArray, n2, this.logDrvSize);
            n2 += this.logDrvSize;
        }
        for (n = 0; n < this.sparesCount; ++n) {
            System.arraycopy(this.spare[n].getByteArray(), 0, byArray, n2, this.sparesSize);
            n2 += this.sparesSize;
        }
        return byArray;
    }

    public void setarray(MR_ARRAY[] mR_ARRAYArray) {
        this.size -= this.arrayCount * this.arraySize;
        this.arraySize = (short)mR_ARRAYArray[0].getByteArray().length;
        this.arrayCount = (short)mR_ARRAYArray.length;
        this.array = mR_ARRAYArray;
        this.size += this.arrayCount * this.arraySize;
    }

    public void setld(MR_LD_CONFIG[] mR_LD_CONFIGArray) {
        this.size -= this.logDrvCount * this.logDrvSize;
        this.logDrvSize = (short)mR_LD_CONFIGArray[0].getByteArray().length;
        this.logDrvCount = (short)mR_LD_CONFIGArray.length;
        this.ld = mR_LD_CONFIGArray;
        this.size += this.logDrvCount * this.logDrvSize;
    }

    public void setspare(MR_SPARE[] mR_SPAREArray) {
        this.size -= this.sparesCount * this.sparesSize;
        this.sparesSize = (short)mR_SPAREArray[0].getByteArray().length;
        this.sparesCount = (short)mR_SPAREArray.length;
        this.spare = mR_SPAREArray;
        this.size += this.sparesCount * this.sparesSize;
    }
}

