/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.MR_LD_REF;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class MR_LD_PROPERTIES {
    private MR_LD_REF ldRef;
    private byte[] name = new byte[16];
    private char defaultCachePolicy;
    private char accessPolicy;
    private char diskCachePolicy;
    private char currentCachePolicy;
    private char noBGI;
    private byte autoSnapshot;
    private byte disableAutoDeleteOldestPIT;
    private byte nonShared;
    private byte defaultPSPolicy;
    private byte currentPSPolicy;
    private byte[] reserved = new byte[4];

    public MR_LD_PROPERTIES(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        if (this.ldRef == null) {
            this.ldRef = new MR_LD_REF(byArray, n);
        } else {
            this.ldRef.update(byArray, n);
        }
        n += 4;
        for (int i = 0; i < this.name.length && byArray[n + i] != 0; ++i) {
            this.name[i] = byArray[n + i];
        }
        this.defaultCachePolicy = (char)byArray[n += 16];
        this.accessPolicy = (char)byArray[++n];
        this.diskCachePolicy = (char)byArray[++n];
        this.currentCachePolicy = (char)byArray[++n];
        this.noBGI = (char)byArray[++n];
        this.autoSnapshot = KernelConstants.getBitValue(byArray[++n], 0);
        this.disableAutoDeleteOldestPIT = KernelConstants.getBitValue(byArray[n], 1);
        this.nonShared = KernelConstants.getBitValue(byArray[n], 2);
        this.defaultPSPolicy = byArray[++n];
        this.currentPSPolicy = byArray[++n];
        n += 4;
    }

    public MR_LD_PROPERTIES() {
        this.ldRef = new MR_LD_REF();
    }

    public MR_LD_REF getldRef() {
        return this.ldRef;
    }

    public byte[] getname() {
        return this.name;
    }

    public char getdefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public char getaccessPolicy() {
        return this.accessPolicy;
    }

    public char getdiskCachePolicy() {
        return this.diskCachePolicy;
    }

    public char getcurrentCachePolicy() {
        return this.currentCachePolicy;
    }

    public char getnoBGI() {
        return this.noBGI;
    }

    public byte getautoSnapshot() {
        return this.autoSnapshot;
    }

    public byte getdisableAutoDeleteOldestPIT() {
        return this.disableAutoDeleteOldestPIT;
    }

    public byte getdefaultPSPolicy() {
        return this.defaultPSPolicy;
    }

    public byte getcurrentPSPolicy() {
        return this.currentPSPolicy;
    }

    public byte getnonShared() {
        return this.nonShared;
    }

    public byte[] getreserved() {
        return this.reserved;
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[32];
        int n = 0;
        System.arraycopy(this.getldRef().getByteArray(), 0, byArray, n, 4);
        System.arraycopy(this.getname(), 0, byArray, n += 4, 16);
        byArray[n += 16] = (byte)this.getdefaultCachePolicy();
        byArray[++n] = (byte)this.getaccessPolicy();
        byArray[++n] = (byte)this.getdiskCachePolicy();
        byArray[++n] = (byte)this.getcurrentCachePolicy();
        byArray[++n] = (byte)this.getnoBGI();
        byArray[++n] = (byte)(this.getautoSnapshot() | this.getdisableAutoDeleteOldestPIT() << 1 | this.getnonShared() << 2);
        byArray[++n] = this.getdefaultPSPolicy();
        byArray[++n] = this.getcurrentPSPolicy();
        ++n;
        n += 4;
        return byArray;
    }

    public void setldRef(MR_LD_REF mR_LD_REF) {
        this.ldRef = mR_LD_REF;
    }

    public void setname(byte[] byArray) {
        for (int i = 0; i < 16; i += 4) {
            NetworkToJavaConverter.intToByteArray(0, this.name, i);
        }
        System.arraycopy(byArray, 0, this.name, 0, Math.min(byArray.length, this.name.length));
    }

    public void setdefaultCachePolicy(char c) {
        this.defaultCachePolicy = c;
    }

    public void setaccessPolicy(char c) {
        this.accessPolicy = c;
    }

    public void setdiskCachePolicy(char c) {
        this.diskCachePolicy = c;
    }

    public void setcurrentCachePolicy(char c) {
        this.currentCachePolicy = c;
    }

    public void setnoBGI(char c) {
        this.noBGI = c;
    }

    public void setautoSnapshot(byte by) {
        this.autoSnapshot = by;
    }

    public void setdisableAutoDeleteOldestPIT(byte by) {
        this.disableAutoDeleteOldestPIT = by;
    }

    public void setdefaultPSPolicy(byte by) {
        this.defaultPSPolicy = by;
    }

    public void setdcurrentPSPolicy(byte by) {
        this.currentPSPolicy = by;
    }

    public void setreserved(byte[] byArray) {
        this.reserved = byArray;
    }

    public void setnonShared(byte by) {
        this.nonShared = by;
    }
}

