/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class MR_SAS_PHY_CONNECTION {
    private long sasAddr;
    private char phyIdentifier;
    private byte[] reserved2 = new byte[2];
    private byte connectorIndex;
    private byte deviceType;
    private byte deviceIsSata;
    private byte smpInitiator;
    private byte stpInitiator;
    private byte sspInitiator;
    private byte smpTarget;
    private byte stpTarget;
    private byte sspTarget;
    private byte disabled;
    private byte sasPortNumber;
    private byte sasPortNumberValid;
    private byte linkSpeedControl;
    private int reserved1;

    public MR_SAS_PHY_CONNECTION(byte[] byArray, int n) {
        int n2 = 0;
        this.setsasAddr(NetworkToJavaConverter.byteArrayToLong(byArray, n));
        this.phyIdentifier = (char)byArray[n += 8];
        this.connectorIndex = byArray[n += 3];
        int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, ++n);
        this.deviceType = (byte)KernelConstants.getBitsValue(n3, (short)n2, (short)(n2 + 2));
        this.deviceIsSata = KernelConstants.getBitValue(n3, n2 += 3);
        this.smpInitiator = KernelConstants.getBitValue(n3, ++n2);
        this.stpInitiator = KernelConstants.getBitValue(n3, ++n2);
        this.sspInitiator = KernelConstants.getBitValue(n3, ++n2);
        this.smpTarget = KernelConstants.getBitValue(n3, ++n2);
        this.stpTarget = KernelConstants.getBitValue(n3, ++n2);
        this.sspTarget = KernelConstants.getBitValue(n3, ++n2);
        this.disabled = KernelConstants.getBitValue(n3, ++n2);
        this.sasPortNumber = (byte)KernelConstants.getBitsValue(n3, (short)(++n2), (short)(n2 + 6));
        this.sasPortNumberValid = KernelConstants.getBitValue(n3, n2 += 7);
        ++n2;
        this.linkSpeedControl = (byte)(n3 >> 18 & 0xFF);
        n2 += 8;
    }

    public long getsasAddr() {
        return this.sasAddr;
    }

    public char getphyIdentifier() {
        return this.phyIdentifier;
    }

    private byte[] getreserved2() {
        return this.reserved2;
    }

    public byte getConnectorIndex() {
        return this.connectorIndex;
    }

    public int getdeviceType() {
        return this.deviceType;
    }

    public int getdeviceIsSata() {
        return this.deviceIsSata;
    }

    public int getsmpInitiator() {
        return this.smpInitiator;
    }

    public int getstpInitiator() {
        return this.stpInitiator;
    }

    public int getsspInitiator() {
        return this.sspInitiator;
    }

    public int getsmpTarget() {
        return this.smpTarget;
    }

    public int getstpTarget() {
        return this.stpTarget;
    }

    public int getsspTarget() {
        return this.sspTarget;
    }

    public int getdisabled() {
        return this.disabled;
    }

    private int getreserved1() {
        return this.reserved1;
    }

    public int getsasPortNumber() {
        return this.sasPortNumber;
    }

    public int getsasPortNumberValid() {
        return this.sasPortNumberValid;
    }

    public int getlinkSpeedControl() {
        return this.linkSpeedControl;
    }

    private void setsasAddr(long l) {
        this.sasAddr = l;
    }

    private void setphyIdentifier(char c) {
        this.phyIdentifier = c;
    }

    private void setreserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    private void setdeviceType(byte by) {
        this.deviceType = by;
    }

    private void setdeviceIsSata(byte by) {
        this.deviceIsSata = by;
    }

    private void setsmpInitiator(byte by) {
        this.smpInitiator = by;
    }

    private void setstpInitiator(byte by) {
        this.stpInitiator = by;
    }

    private void setsspInitiator(byte by) {
        this.sspInitiator = by;
    }

    private void setsmpTarget(byte by) {
        this.smpTarget = by;
    }

    private void setstpTarget(byte by) {
        this.stpTarget = by;
    }

    private void setsspTarget(byte by) {
        this.sspTarget = by;
    }

    private void setdisabled(byte by) {
        this.disabled = by;
    }

    private void setsasPortNumber(byte by) {
        this.sasPortNumber = by;
    }

    private void setsasPortNumberValid(byte by) {
        this.sasPortNumberValid = by;
    }

    private void setlinkSpeedControl(byte by) {
        this.linkSpeedControl = by;
    }

    private void setreserved1(int n) {
        this.reserved1 = n;
    }
}

