/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.SL_ALARM_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_DEVICE_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_FAN_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_POWER_SUPPLY_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_TEMP_SENSOR_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SL_VOLTAGE_SENSOR_STATUS_T;
import Services.VivaldiDataInputStream;
import java.io.IOException;

public class SL_ENCL_STATUS_EX_T {
    private int m_iSize = 0;
    private byte m_deviceCount = 0;
    private byte m_powerSupplyCount = 0;
    private byte m_coolingCount = 0;
    private byte m_tempSensorCount = 0;
    private byte m_doorLockCount = 0;
    private byte m_alarmCount = 0;
    private byte m_sesCtrlElecCount = 0;
    private byte m_sccCtrlElecCount = 0;
    private byte m_nonVolatileCacheCount = 0;
    private byte m_invalidOpReasonCount = 0;
    private byte m_upsCount = 0;
    private byte m_displayCount = 0;
    private byte m_keyPadEntryCount = 0;
    private byte m_enclElementCount = 0;
    private byte m_scsiTransceiverPortCount = 0;
    private byte m_languageCount = 0;
    private byte m_comPortCount = 0;
    private byte m_voltageSensorCount = 0;
    private SL_DEVICE_STATUS_T[] m_slDeviceStatus = null;
    private SL_POWER_SUPPLY_STATUS_T[] m_slPowerSupplyStatus = null;
    private SL_FAN_STATUS_T[] m_slFanStatus = null;
    private SL_TEMP_SENSOR_STATUS_T[] m_slTempSensorStatus = null;
    private SL_ALARM_STATUS_T[] m_slAlarmStatus = null;
    private SL_VOLTAGE_SENSOR_STATUS_T[] m_slVoltageSensorStatus = null;

    public SL_ENCL_STATUS_EX_T(byte[] byArray, int n) {
        this.update(byArray, n);
    }

    public void update(byte[] byArray, int n) {
        VivaldiDataInputStream vivaldiDataInputStream = new VivaldiDataInputStream(byArray);
        try {
            byte by;
            vivaldiDataInputStream.skipBytes(n);
            this.m_iSize = vivaldiDataInputStream.readInt();
            vivaldiDataInputStream.skipBytes(2);
            this.m_deviceCount = vivaldiDataInputStream.readByte();
            this.m_powerSupplyCount = vivaldiDataInputStream.readByte();
            this.m_coolingCount = vivaldiDataInputStream.readByte();
            this.m_tempSensorCount = vivaldiDataInputStream.readByte();
            this.m_doorLockCount = vivaldiDataInputStream.readByte();
            this.m_alarmCount = vivaldiDataInputStream.readByte();
            this.m_sesCtrlElecCount = vivaldiDataInputStream.readByte();
            this.m_sccCtrlElecCount = vivaldiDataInputStream.readByte();
            this.m_nonVolatileCacheCount = vivaldiDataInputStream.readByte();
            this.m_invalidOpReasonCount = vivaldiDataInputStream.readByte();
            this.m_upsCount = vivaldiDataInputStream.readByte();
            this.m_displayCount = vivaldiDataInputStream.readByte();
            this.m_keyPadEntryCount = vivaldiDataInputStream.readByte();
            this.m_enclElementCount = vivaldiDataInputStream.readByte();
            this.m_scsiTransceiverPortCount = vivaldiDataInputStream.readByte();
            this.m_languageCount = vivaldiDataInputStream.readByte();
            this.m_comPortCount = vivaldiDataInputStream.readByte();
            this.m_voltageSensorCount = vivaldiDataInputStream.readByte();
            vivaldiDataInputStream.skipBytes(7);
            vivaldiDataInputStream.skipBytes(101);
            this.m_slDeviceStatus = new SL_DEVICE_STATUS_T[this.m_deviceCount];
            for (by = 0; by < this.m_deviceCount; by = (byte)(by + 1)) {
                this.m_slDeviceStatus[by] = new SL_DEVICE_STATUS_T(byArray, vivaldiDataInputStream.getPosition());
                vivaldiDataInputStream.skipBytes(8);
            }
            this.m_slPowerSupplyStatus = new SL_POWER_SUPPLY_STATUS_T[this.m_powerSupplyCount];
            for (by = 0; by < this.m_powerSupplyCount; by = (byte)(by + 1)) {
                this.m_slPowerSupplyStatus[by] = new SL_POWER_SUPPLY_STATUS_T(byArray, vivaldiDataInputStream.getPosition());
                vivaldiDataInputStream.skipBytes(8);
            }
            this.m_slFanStatus = new SL_FAN_STATUS_T[this.m_coolingCount];
            for (by = 0; by < this.m_coolingCount; by = (byte)(by + 1)) {
                this.m_slFanStatus[by] = new SL_FAN_STATUS_T(byArray, vivaldiDataInputStream.getPosition());
                vivaldiDataInputStream.skipBytes(8);
            }
            this.m_slTempSensorStatus = new SL_TEMP_SENSOR_STATUS_T[this.m_tempSensorCount];
            for (by = 0; by < this.m_tempSensorCount; by = (byte)(by + 1)) {
                this.m_slTempSensorStatus[by] = new SL_TEMP_SENSOR_STATUS_T(byArray, vivaldiDataInputStream.getPosition());
                vivaldiDataInputStream.skipBytes(8);
            }
            vivaldiDataInputStream.skipBytes(this.m_doorLockCount * 8);
            this.m_slAlarmStatus = new SL_ALARM_STATUS_T[this.m_alarmCount];
            for (by = 0; by < this.m_alarmCount; by = (byte)(by + 1)) {
                this.m_slAlarmStatus[by] = new SL_ALARM_STATUS_T(byArray, vivaldiDataInputStream.getPosition());
                vivaldiDataInputStream.skipBytes(8);
            }
            vivaldiDataInputStream.skipBytes(this.m_sesCtrlElecCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_sccCtrlElecCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_nonVolatileCacheCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_invalidOpReasonCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_upsCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_displayCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_keyPadEntryCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_enclElementCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_scsiTransceiverPortCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_languageCount * 8);
            vivaldiDataInputStream.skipBytes(this.m_comPortCount * 8);
            this.m_slVoltageSensorStatus = new SL_VOLTAGE_SENSOR_STATUS_T[this.m_voltageSensorCount];
            for (by = 0; by < this.m_voltageSensorCount; by = (byte)(by + 1)) {
                this.m_slVoltageSensorStatus[by] = new SL_VOLTAGE_SENSOR_STATUS_T(byArray, vivaldiDataInputStream.getPosition());
                vivaldiDataInputStream.skipBytes(8);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte getTemperatureSensorCount() {
        return this.m_tempSensorCount;
    }

    public byte getFanCount() {
        return this.m_coolingCount;
    }

    public byte getPowerSupplyCount() {
        return this.m_powerSupplyCount;
    }

    public byte getVoltageSensorCount() {
        return this.m_voltageSensorCount;
    }

    public SL_DEVICE_STATUS_T[] getDeviceStatus() {
        return this.m_slDeviceStatus;
    }

    public SL_POWER_SUPPLY_STATUS_T[] getPowerSupplyStatus() {
        return this.m_slPowerSupplyStatus;
    }

    public SL_FAN_STATUS_T[] getCoolingStatus() {
        return this.m_slFanStatus;
    }

    public SL_TEMP_SENSOR_STATUS_T[] getTemperatureSensorStatus() {
        return this.m_slTempSensorStatus;
    }

    public SL_VOLTAGE_SENSOR_STATUS_T[] getVoltageSensorStatus() {
        return this.m_slVoltageSensorStatus;
    }

    public int getSize() {
        return this.m_iSize;
    }
}

