/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_END_DEVICE_NODE_T;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_EXPANDER_NODE_T;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_GENERIC_NODE;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_HEAD_PHY_T;
import Services.NetworkToJavaConverter;

public class SL_TOPOLOGY_HEAD_NODE_T
extends SL_TOPOLOGY_GENERIC_NODE {
    private byte deviceType;
    private byte reserved;
    private short totalSize;
    private byte[] reserved1 = new byte[3];
    private byte numPhy;
    private SL_TOPOLOGY_HEAD_PHY_T[] phyList = new SL_TOPOLOGY_HEAD_PHY_T[16];

    public SL_TOPOLOGY_HEAD_NODE_T(byte[] byArray, int n) {
        int n2;
        this.setStartpos(n);
        this.deviceType = byArray[n];
        ++n;
        this.totalSize = NetworkToJavaConverter.byteArrayToShort(byArray, ++n);
        n += 2;
        this.numPhy = byArray[n += 3];
        ++n;
        for (n2 = 0; n2 < this.phyList.length; ++n2) {
            this.phyList[n2] = new SL_TOPOLOGY_HEAD_PHY_T(byArray, n);
            n += 8;
        }
        this.children = new SL_TOPOLOGY_GENERIC_NODE[this.phyList.length];
        block5: for (n2 = 0; n2 < this.children.length; ++n2) {
            switch (this.phyList[n2].getAttachedDeviceType()) {
                case 4: {
                    this.children[n2] = new SL_TOPOLOGY_END_DEVICE_NODE_T(byArray, this.phyList[n2].getAttachedDeviceOffset() + startpos);
                    continue block5;
                }
                case 2: 
                case 3: {
                    this.children[n2] = SL_TOPOLOGY_EXPANDER_NODE_T.getInstance(byArray, this.phyList[n2].getAttachedDeviceOffset() + startpos);
                }
            }
        }
    }

    public byte getDeviceType() {
        return this.deviceType;
    }

    public short getTotalSize() {
        return this.totalSize;
    }

    public byte getNumPhy() {
        return this.numPhy;
    }

    public SL_TOPOLOGY_HEAD_PHY_T[] getPhyList() {
        return this.phyList;
    }

    private void setStartpos(int n) {
        startpos = n;
    }
}

