/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.LibraryAPI.StoreLib;

import Services.NetworkToJavaConverter;

public class SL_WH_DD_INFO {
    public static final short AUX_POW_NOT_PRESENT = 0;
    public static final short AUX_POW_PRESENT = 1;
    public static final short AUX_POW_NOT_SUPPORTED = 255;
    public static final short SSD_THROTTLING = 90;
    public static final short NO_SSD_THROTTLING = 100;
    public static final int SL_WH_DD_STATUS_GOOD = 0;
    public static final int SL_WH_DD_STATUS_WARNING = 1;
    public static final int SL_WH_DD_STATUS_ERROR = 2;
    public static final int SL_WH_DD_STATUS_UNKNOWN = 255;
    private short AuxiliaryPowerPresent;
    private short LifeCurveStatus;
    private int SSDLifeLeft;
    private int DDStatus;
    private byte LifeLeftWarningThreshold;
    private byte LifeLeftErrorThreshold;
    private short TemperatureWarningThreshold;
    private short TemperatureErrorThreshold;
    private short Temperature;
    private short Reserved1;

    public SL_WH_DD_INFO(byte[] byArray, int n) {
        int n2 = n;
        this.setAuxiliaryPowerPresent(NetworkToJavaConverter.byteArrayToShort(byArray, n2));
        this.setLifeCurveStatus(NetworkToJavaConverter.byteArrayToShort(byArray, n2 += 2));
        this.setSSDLifeLeft(NetworkToJavaConverter.byteArrayToInt(byArray, n2 += 2));
        this.setDDStatus(NetworkToJavaConverter.byteArrayToInt(byArray, n2 += 4));
        this.setDriveLifeWarningThreshold(byArray[n2 += 4]);
        this.setDriveLifeErrorThreshold(byArray[++n2]);
        this.setTemperatureWarningThreshold(NetworkToJavaConverter.byteArrayToShort(byArray, ++n2));
        this.setTemperatureErrorThreshold(NetworkToJavaConverter.byteArrayToShort(byArray, n2 += 2));
        this.setTemperature(NetworkToJavaConverter.byteArrayToShort(byArray, n2 += 2));
        this.setReserved1(NetworkToJavaConverter.byteArrayToShort(byArray, n2 += 2));
        n2 += 2;
    }

    public short getAuxiliaryPowerPresent() {
        return this.AuxiliaryPowerPresent;
    }

    public void setAuxiliaryPowerPresent(short s) {
        this.AuxiliaryPowerPresent = s;
    }

    public short getLifeCurveStatus() {
        return this.LifeCurveStatus;
    }

    public void setLifeCurveStatus(short s) {
        this.LifeCurveStatus = s;
    }

    public int getSSDLifeLeft() {
        return this.SSDLifeLeft;
    }

    public void setSSDLifeLeft(int n) {
        this.SSDLifeLeft = n;
    }

    public int getDDStatus() {
        return this.DDStatus;
    }

    public void setDDStatus(int n) {
        this.DDStatus = n;
    }

    public int getDriveLifeWarningThreshold() {
        return this.LifeLeftWarningThreshold;
    }

    public void setDriveLifeWarningThreshold(byte by) {
        this.LifeLeftWarningThreshold = by;
    }

    public int getDriveLifeErrorThreshold() {
        return this.LifeLeftErrorThreshold;
    }

    public void setDriveLifeErrorThreshold(byte by) {
        this.LifeLeftErrorThreshold = by;
    }

    public short getReserved1() {
        return this.Reserved1;
    }

    public void setReserved1(short s) {
        this.Reserved1 = s;
    }

    public boolean isDriveLifeLeftOptimal() {
        boolean bl = false;
        if (this.SSDLifeLeft > this.LifeLeftWarningThreshold) {
            bl = true;
        }
        return bl;
    }

    public boolean isDriveLifeLeftNeedsAttention() {
        boolean bl = false;
        if (this.SSDLifeLeft <= this.LifeLeftWarningThreshold && this.SSDLifeLeft > this.LifeLeftErrorThreshold) {
            bl = true;
        }
        return bl;
    }

    public boolean isDriveLifeLeftExhausted() {
        boolean bl = false;
        if (this.SSDLifeLeft <= this.LifeLeftErrorThreshold) {
            bl = true;
        }
        return bl;
    }

    public boolean isDDStatusGood() {
        boolean bl = this.DDStatus == 0;
        return bl;
    }

    public boolean isDDStatusWarning() {
        boolean bl = this.DDStatus == 1;
        return bl;
    }

    public boolean isDDStatusError() {
        boolean bl = this.DDStatus == 2;
        return bl;
    }

    public boolean isDDStatusUnknown() {
        boolean bl = this.DDStatus == 255;
        return bl;
    }

    public short getTemperatureWarningThreshold() {
        return this.TemperatureWarningThreshold;
    }

    public void setTemperatureWarningThreshold(short s) {
        this.TemperatureWarningThreshold = s;
    }

    public short getTemperatureErrorThreshold() {
        return this.TemperatureErrorThreshold;
    }

    public void setTemperatureErrorThreshold(short s) {
        this.TemperatureErrorThreshold = s;
    }

    public short getTemperature() {
        return this.Temperature;
    }

    public void setTemperature(short s) {
        this.Temperature = s;
    }
}

