/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASAdapter;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.debuglogger.Logger;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import KernelServices.SimpleStatusNotification;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.ADV_SYSTEM_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_MODES_GET;
import SASKernel.LibraryAPI.StoreLib.MR_BIOS_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_CC_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_ALLOWED_OPS;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_LOCK_KEY_FROM_ESCROW;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_LOCK_KEY_PARAMS;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_LOCK_KEY_PASSPHRASE;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_PROP;
import SASKernel.LibraryAPI.StoreLib.MR_DRV_DRIVER_VERSION;
import SASKernel.LibraryAPI.StoreLib.MR_DRV_PCI_INFORMATION;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_CLASS_LOCALE;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LOG_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_FOREIGN_CFG_GUIDS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_ALLOWED_OPS_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_LD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_ALL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_PIT_VIEW_PARAMS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_TARGETID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_MFG;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_MFG_2;
import SASKernel.LibraryAPI.StoreLib.MR_PD_ADDRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_DEVICEID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PF_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PF_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_PREMIUM_FEATURE_SET;
import SASKernel.LibraryAPI.StoreLib.MR_PR_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_PR_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTORS;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_MUX_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_PHY_CONNECTIONS;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.MR_TTY_DATA;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_EX_T;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_T;
import SASKernel.LibraryAPI.StoreLib.SL_SCSI_PASSTHRU_T;
import SASKernel.LibraryAPI.StoreLib.SL_STP_PASSTHRU_T;
import SASKernel.LibraryAPI.StoreLib.SL_TOPOLOGY_HEAD_NODE_T;
import SASKernel.LibraryAPI.StoreLib.SL_WH_DD_INFO;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.LibraryAPI.StoreLib.pdState_args_MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.security_MR_PD_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASBatteryBackUp;
import SASKernel.SASKernel;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASCDROM;
import SASKernel.SASPhysical.SASEnclosure;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASPhysical.SASProcessor;
import SASKernel.SASPhysical.SASTape;
import SASKernel.SASServer;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;

public class SASAdapter
extends Observable
implements ISASObject,
AENHandlerInterface,
Observer {
    public static final short SAS_OBJECT_PHYSICAL_DEVICE = 4096;
    public static final short SAS_OBJECT_PHYSICAL_DISKS = 4096;
    public static final short SAS_OBJECT_PHYSICAL_ENCLOSURES = 4109;
    public static final short SAS_OBJECT_VIRTUAL_ENCLOSURES = 4127;
    public static final short SAS_OBJECT_PHYSICAL_CDROM = 4101;
    public static final short SAS_OBJECT_PHYSICAL_TAPE = 4097;
    public static final short SAS_OBJECT_PHYSICAL_PROCESSOR = 4099;
    public static final short SAS_OBJECT_PHYSICAL_ALL_DEVICES = 4352;
    public static final short SAS_OBJECT_LOGICAL_DEVICE = 8192;
    public static final short SAS_OBJECT_ARRAY = 16384;
    public static final byte ADAPTER_UNKNOWN = 0;
    public static final byte ADAPTER_SAS_MEGARAID = 1;
    public static final byte ADAPTER_SAS_IR = 2;
    public static final byte ADAPTER_SAS_IR2 = 3;
    public static final byte ADAPTER_SAS_IR3 = 4;
    public static final int LIBTYPE_SAS_MEGARAID = 0;
    public static final int LIBTYPE_SAS_IR = 0x1000000;
    public static final int LIBTYPE_SAS_IR2 = 0x2000000;
    public static final int LIBTYPE_SAS_IR3 = 0x4000000;
    public static final int LIBTYPE_MASK = -16777216;
    public static final byte SMART_MODE_6 = 0;
    public static final byte SMART_MODE_DISABLE = 1;
    public static final byte SMART_MODE_2 = 2;
    public static final byte SMART_MODE_DEFAULT = 0;
    private MR_CTRL_INFO mrControllerInfo = null;
    private MR_CTRL_INFO dup_mrControllerInfo = null;
    private SL_WH_DD_INFO whDDInfo = null;
    private SL_WH_DD_INFO dup_whDDInfo = null;
    private SL_TOPOLOGY_HEAD_NODE_T topologyHeadNode = null;
    private SL_TOPOLOGY_HEAD_NODE_T dup_topologyHeadNode = null;
    private MR_SAS_MUX_LIST muxSettings = null;
    private MR_SAS_CONNECTORS sasConnector = null;
    private MR_DRV_PCI_INFORMATION mrControllerPciInfo = null;
    private SASBatteryBackUp sasBBU = null;
    private String serialNo;
    private SASServer sasServer;
    private short ID;
    private int ctrlID;
    private int displayID;
    private byte adpType = 1;
    private int libType = 0;
    private ArrayList uniqueAENIDList = new ArrayList();
    MR_EVT_LOG_INFO mrEvtLogInfo = null;
    private ArrayList pdObjectArrayList;
    private ArrayList ldObjectArrayList;
    private ArrayList arObjectArrayList;
    private ArrayList dup_pdObjectArrayList = new ArrayList();
    private ArrayList dup_ldObjectArrayList = new ArrayList();
    private ArrayList dup_arObjectArrayList = new ArrayList();
    private String receiverWWN;
    private int maxPortCount = 0;
    private MR_MFC_DEFAULTS mfcDef = null;
    private MR_PR_STATUS m_PR_Status = null;
    private MR_PR_PROPERTIES m_PR_Prop = null;
    private MR_CC_SCHEDULE_PROPERTIES m_MR_CC_Sch_Prop = null;
    public static short MAX_LOGICAL_DRIVES1;
    private MR_CONFIG_DATA mrConfigData = null;
    private int m_OldSequenceNum = 0;

    public SASAdapter(int n, int n2, SASServer sASServer, String string) throws VKNotRespondingException, VKOperationFailedException {
        this.ID = (short)n;
        this.ctrlID = n2;
        this.sasServer = sASServer;
        this.receiverWWN = string;
        this.addObserver(sASServer);
        this.refresh();
    }

    public SASAdapter(int n, int n2, SASServer sASServer, String string, byte by, int n3) throws VKNotRespondingException, VKOperationFailedException {
        this.adpType = by;
        this.setLibType(this.adpType);
        this.ID = (short)n;
        this.ctrlID = n2;
        this.sasServer = sASServer;
        this.displayID = n3;
        this.receiverWWN = string;
        this.addObserver(sASServer);
        this.refresh();
    }

    public boolean checkSetLinkSpeedSupport() {
        int n;
        boolean bl = false;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x7050000);
        sL_DCMD_INPUT_T.setflags('\u0001');
        byte[] byArray = new byte[]{17, -1};
        int[] nArray = new int[3];
        nArray[0] = byArray[0] + (byArray[1] << 8);
        sL_DCMD_INPUT_T.setmbox(nArray);
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        try {
            n = this.dcmdSetLinkOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            n = 1;
        }
        bl = n == 0;
        return bl;
    }

    public int dcmdSetLinkOperation(byte[] byArray) throws VKOperationFailedException {
        if (this.isMRApiIncompatible()) {
            throw new VKOperationFailedException(1);
        }
        int n = 1;
        try {
            NetworkDataPacket networkDataPacket = this.storeLibOperation((byte)6, byArray.length, byArray, new OperationDetails(3, null));
            n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer(), 0);
            System.arraycopy(networkDataPacket.getDataBuffer(), 44, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != 0) {
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    public static NetworkDataPacket getBufferforControllerList() {
        NetworkDataPacket networkDataPacket = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
        return networkDataPacket;
    }

    @Override
    public short getID() {
        return this.ID;
    }

    public int getDisplayID() {
        return this.displayID;
    }

    @Override
    public short getSeqNum() {
        return this.getInformation().getproperties().getseqNum();
    }

    @Override
    public ISASObject next() {
        return null;
    }

    public int readLDCount() {
        return this.ldObjectArrayList.size();
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return this.sasServer;
    }

    public byte getPortCount() {
        return this.getInformation().getdeviceInterface_MR_CTRL_INFO().getportCount();
    }

    public byte getMaxPortCount() {
        return (byte)Math.max((byte)this.maxPortCount, this.getInformation().getdeviceInterface_MR_CTRL_INFO().getportCount());
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        this.createPciInfo();
        this.createInformation();
        if (this.isMRApiIncompatible()) {
            return true;
        }
        this.createPDList();
        this.readConfigInformation();
        this.createBBUInformation();
        this.createTopologyInfo();
        this.createMuxSettings();
        this.createConnectorInfo();
        this.StoreAENSequenceInfo();
        return false;
    }

    public void ctrlDataRefresh() {
        this.createInformation();
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        boolean bl = true;
        switch (n) {
            case 7: {
                if (this.getInformation().gethwPresent_MR_CTRL_INFO().getalarm() != 0) break;
                bl = false;
                break;
            }
            case 40: {
                if (this.getInformation().getpdOperations_MR_CTRL_INFO().isSupportPowerState()) break;
                bl = false;
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 14: 
            case 15: {
                if (this.adpType != 2 && this.adpType != 3 && this.adpType != 4) break;
                bl = false;
                break;
            }
            case 8: 
            case 9: {
                if (this.adpType == 2 || this.adpType == 3 || this.adpType == 4 || this.getInformation().gethwPresent_MR_CTRL_INFO().getalarm() == 0) {
                    bl = false;
                    break;
                }
                if (((SASServer)this.parent()).getAccMode() == 1) {
                    bl = false;
                    break;
                }
                if (this.getInformation().getproperties().getalarmEnable() == '\u0001') {
                    bl = n == 9;
                    break;
                }
                bl = n != 9;
                break;
            }
            case 10: {
                bl = this.getInformation().gethwPresent_MR_CTRL_INFO().getalarm() == 1 && this.getInformation().getproperties().getalarmEnable() == '\u0001';
                break;
            }
            case 2: {
                if (this.adpType != 2 && this.adpType != 3 && this.adpType != 4) break;
                bl = false;
                break;
            }
            case 27: {
                if (this.adpType != 2 && this.adpType != 3 && this.adpType != 4) break;
                bl = false;
                break;
            }
            case 3: {
                if (this.getInformation().gethwPresent_MR_CTRL_INFO().getflash() == 0) {
                    bl = false;
                    break;
                }
                if (((SASServer)this.parent()).getAccMode() == 1) {
                    bl = false;
                }
                if (SASKernel.getOemType() != 2561) break;
                bl = false;
                break;
            }
            case 17: 
            case 18: {
                if (this.adpType == 2 || this.adpType == 3 || this.adpType == 4) {
                    bl = false;
                    break;
                }
                if (((SASServer)this.parent()).getAccMode() == 1) {
                    return false;
                }
                if (this.getInformation().getadapterOperations_MR_CTRL_INFO().getpatrolRate() == 0) {
                    bl = false;
                    break;
                }
                try {
                    this.createPatrolReadStatus();
                    switch (this.m_PR_Status.getstate()) {
                        case '\u0000': 
                        case '\u00ff': {
                            if (n != 18) break;
                            bl = false;
                            break;
                        }
                        case '\u0001': 
                        case '\u0002': {
                            if (n != 17) break;
                            bl = false;
                        }
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 16: {
                if (this.adpType == 2 || this.adpType == 3 || this.adpType == 4) {
                    bl = false;
                    break;
                }
                if (((SASServer)this.parent()).getAccMode() == 1) {
                    return false;
                }
                if (this.getInformation().getadapterOperations_MR_CTRL_INFO().getpatrolRate() != 0) break;
                bl = false;
                break;
            }
            case 18088704: {
                if (this.adpType == 2 || this.adpType == 3 || this.adpType == 4) {
                    bl = false;
                    break;
                }
                if (this.getCCSchProperties() != null) {
                    if (this.getCCSchProperties().getopMode() == 0) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 0x1020200: {
                try {
                    if (this.getInformation().getadapterOperations_MR_CTRL_INFO().getAbortCCOnError() != 0) break;
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    public MR_PR_STATUS createPatrolReadStatus() {
        if (this.m_PR_Status != null) {
            return this.m_PR_Status;
        }
        try {
            this.m_PR_Status = this.getPatrolReadStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_PR_Status;
    }

    private MR_PR_PROPERTIES createPatrolReadProperties() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        MR_PR_PROPERTIES mR_PR_PROPERTIES = null;
        OperationDetails operationDetails = new OperationDetails(15, "", "", null);
        this.fireOperation(operationDetails);
        mR_PR_PROPERTIES = (MR_PR_PROPERTIES)operationDetails.getParam();
        return mR_PR_PROPERTIES;
    }

    public MR_CC_SCHEDULE_PROPERTIES getCCSchProperties() {
        this.createCCSchProperties();
        return this.m_MR_CC_Sch_Prop;
    }

    private void createCCSchProperties() {
        if (this.m_MR_CC_Sch_Prop != null) {
            return;
        }
        try {
            this.m_MR_CC_Sch_Prop = this.getScheduleCCProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isKernelOperationAllowed(int n) {
        boolean bl = true;
        switch (n) {
            case 33281: {
                break;
            }
        }
        return bl;
    }

    @Override
    public void notifyMethod(Object object) {
        if (!(object instanceof NotifyObject)) {
            return;
        }
        if ((((NotifyObject)object).getNotifyCode() >> 20 & SASKernel.getNotificationLevel()) == 0) {
            return;
        }
        this.setChanged();
        this.notifyObservers(object);
    }

    public int getCtrlID() {
        return this.ctrlID;
    }

    public ISASObject[] getSASObjectsList(short s) throws VKObjectNotPresentException {
        int n = 0;
        if ((s & 0x1000) != 0) {
            return this.getSASPDObjects(s);
        }
        if ((s & 0x2000) != 0) {
            ISASObject[] iSASObjectArray = new ISASObject[this.dup_ldObjectArrayList.size()];
            ListIterator listIterator = this.dup_ldObjectArrayList.listIterator();
            while (listIterator.hasNext()) {
                iSASObjectArray[n] = (SASLogicalDrive)listIterator.next();
                ++n;
            }
            return iSASObjectArray;
        }
        if ((s & 0x4000) != 0) {
            ISASObject[] iSASObjectArray = new ISASObject[this.dup_arObjectArrayList.size()];
            ListIterator listIterator = this.arObjectArrayList.listIterator();
            while (listIterator.hasNext()) {
                iSASObjectArray[n] = (SASArray)listIterator.next();
                ++n;
            }
            return iSASObjectArray;
        }
        throw new VKObjectNotPresentException(-1);
    }

    private ISASObject[] getSASPDObjectWithType(short s) {
        SASPhysicalDevice sASPhysicalDevice;
        ISASObject[] iSASObjectArray = null;
        int n = 0;
        int n2 = 0;
        ListIterator listIterator = this.dup_pdObjectArrayList.listIterator();
        while (listIterator.hasNext()) {
            sASPhysicalDevice = (SASPhysicalDevice)listIterator.next();
            if (sASPhysicalDevice.getInformation().getscsiDevType() != s) continue;
            ++n2;
        }
        iSASObjectArray = new ISASObject[n2];
        listIterator = this.dup_pdObjectArrayList.listIterator();
        while (listIterator.hasNext()) {
            sASPhysicalDevice = (SASPhysicalDevice)listIterator.next();
            if (sASPhysicalDevice.getInformation().getscsiDevType() != s) continue;
            iSASObjectArray[n++] = sASPhysicalDevice;
        }
        return iSASObjectArray;
    }

    private ISASObject[] getSASPDObjects(short s) throws VKObjectNotPresentException {
        ISASObject[] iSASObjectArray = null;
        int n = 0;
        switch (s) {
            case 4352: {
                iSASObjectArray = new SASPhysicalDevice[this.dup_pdObjectArrayList.size()];
                Iterator iterator = this.dup_pdObjectArrayList.iterator();
                while (iterator.hasNext()) {
                    iSASObjectArray[n++] = (SASPhysicalDevice)iterator.next();
                }
                return iSASObjectArray;
            }
            case 4096: {
                iSASObjectArray = this.getSASPDObjectWithType((short)0);
                break;
            }
            case 4109: {
                iSASObjectArray = this.getSASPDObjectWithType((short)13);
                break;
            }
            case 4101: {
                iSASObjectArray = this.getSASPDObjectWithType((short)5);
                break;
            }
            case 4097: {
                iSASObjectArray = this.getSASPDObjectWithType((short)1);
                break;
            }
            case 4099: {
                iSASObjectArray = this.getSASPDObjectWithType((short)3);
                break;
            }
            default: {
                throw new VKObjectNotPresentException(-1);
            }
        }
        return iSASObjectArray;
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        return ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
    }

    public String getReceiverWWN() {
        return this.receiverWWN;
    }

    private void StoreAENSequenceInfo() {
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.getCtrlID(), 20).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n != 0) {
                System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n));
                return;
            }
            this.mrEvtLogInfo = new MR_EVT_LOG_INFO(byArray, 44);
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            this.mrEvtLogInfo = null;
            return;
        }
    }

    private void registerWithEventClass(int n, short s, byte by) {
        byte[] byArray = new byte[316];
        byArray[4] = 0;
        byArray[5] = 1;
        NetworkToJavaConverter.intToByteArray(this.getCtrlID(), byArray, 8);
        NetworkToJavaConverter.intToByteArray(112, byArray, 20);
        NetworkToJavaConverter.intToByteArray(72, byArray, 32);
        int n2 = 116;
        NetworkToJavaConverter.intToByteArray(1, byArray, n2);
        NetworkToJavaConverter.intToByteArray(this.getCtrlID(), byArray, n2 + 4);
        NetworkToJavaConverter.unsignedShortTobyteArray(s, byArray, n2 + 8);
        byArray[n2 + 11] = by;
        NetworkToJavaConverter.intToByteArray(n, byArray, n2 + 12);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byArray = networkDataPacket.getDataBuffer();
        int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
        int n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 44);
        System.out.println("********************************* ");
        System.out.println("Number of Controller registered for AEN= " + n4);
        this.uniqueAENIDList.add(new Integer(NetworkToJavaConverter.byteArrayToInt(byArray, 112)));
    }

    private void unRegisterAEN() {
        byte[] byArray = new byte[48];
        ListIterator listIterator = this.uniqueAENIDList.listIterator();
        while (listIterator.hasNext()) {
            int n;
            byArray[4] = 0;
            byArray[5] = 2;
            NetworkToJavaConverter.intToByteArray(this.getCtrlID(), byArray, 8);
            NetworkToJavaConverter.intToByteArray(4, byArray, 32);
            NetworkToJavaConverter.intToByteArray((Integer)listIterator.next(), byArray, 20);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
            try {
                ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if ((n = NetworkToJavaConverter.byteArrayToInt(byArray = networkDataPacket.getDataBuffer(), 0)) != 0) continue;
            ((SASServer)this.parent()).unRegisterForAEN(this);
        }
    }

    @Override
    public synchronized boolean handleAEN(Object object) {
        int n;
        NetworkPacket networkPacket = (NetworkPacket)object;
        byte[] byArray = networkPacket.getDatabuffer();
        short s = NetworkToJavaConverter.byteArrayToShort(byArray, 0);
        if (s != 0) {
            System.out.println("AEN CallBack Error = " + s);
        }
        if (((n = NetworkToJavaConverter.byteArrayToInt(byArray, 4)) & 0xFF000000) != this.getLibType()) {
            return false;
        }
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
        if (!this.isAENIDExists(n2)) {
            return false;
        }
        MR_EVT_DETAIL mR_EVT_DETAIL = new MR_EVT_DETAIL(byArray, 12);
        this.processAllAEN(mR_EVT_DETAIL);
        return true;
    }

    public synchronized void createInformation() {
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(1, 0, this.getCtrlID(), 2048).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            int n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer());
            byte[] byArray = networkDataPacket.getDataBuffer();
            byte[] byArray2 = new byte[2048];
            System.arraycopy(byArray, 44, byArray2, 0, byArray2.length);
            this.dup_mrControllerInfo = this.mrControllerInfo = new MR_CTRL_INFO(byArray2, 0);
            if (this.isWarhawk()) {
                networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(10, 2, this.getCtrlID(), 22).getByteArray());
                try {
                    ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
                    int n2 = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer());
                    byte[] byArray3 = networkDataPacket.getDataBuffer();
                    byte[] byArray4 = new byte[22];
                    System.arraycopy(byArray3, 44, byArray4, 0, byArray4.length);
                    this.dup_whDDInfo = this.whDDInfo = new SL_WH_DD_INFO(byArray4, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 8193, this.dup_mrControllerInfo)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createPciInfo() {
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(1, 11, this.getCtrlID(), 112).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            int n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer());
            byte[] byArray = networkDataPacket.getDataBuffer();
            byte[] byArray2 = new byte[112];
            System.arraycopy(byArray, 44, byArray2, 0, byArray2.length);
            this.mrControllerPciInfo = new MR_DRV_PCI_INFORMATION(byArray2, 0);
        }
        catch (Exception exception) {
            this.mrControllerPciInfo = null;
            exception.printStackTrace();
        }
    }

    private void createMuxSettings() {
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(72);
            sL_DCMD_INPUT_T.setopCode(117571840);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setpData(new byte[5]);
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            this.muxSettings = new MR_SAS_MUX_LIST(byArray, 32);
        }
        catch (Exception exception) {
            this.muxSettings = null;
        }
    }

    private void createConnectorInfo() {
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setopCode(0x7030000);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setpData(new byte[168]);
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            this.sasConnector = new MR_SAS_CONNECTORS(byArray, 32);
        }
        catch (Exception exception) {
            this.sasConnector = null;
        }
    }

    private int fireDCMDFlashCtrlFirmware(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = byArray.length;
        n = this.openFlash(n2);
        if (0 != n) {
            return n;
        }
        int n3 = 0;
        n = this.downloadFlashImage(n2, byArray);
        if (0 != n) {
            n3 = this.closeFlash();
            if (0 != n3) {
                // empty if block
            }
            return n;
        }
        n = this.actualFlash();
        if (0 != n) {
            n3 = this.closeFlash();
            if (0 != n3) {
                // empty if block
            }
            return n;
        }
        this.closeFlash();
        return n;
    }

    public int openMRCtrlFirmwareImage(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = byArray.length;
        n = this.openFlash(n2);
        if (0 != n) {
            return n;
        }
        return n;
    }

    public int downloadMRCtrlFirmwareImage(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = byArray.length;
        n = this.downloadFlashImage(n2, byArray);
        if (0 != n) {
            this.closeFlash();
            return n;
        }
        return n;
    }

    public int flashMRCtrlFirmwareImage(byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        if (!bl) {
            n2 = this.actualFlash();
            if (0 != n2) {
                n = this.closeFlash();
                if (0 != n) {
                    // empty if block
                }
                return n2;
            }
        } else {
            try {
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(17761024);
                sL_DCMD_INPUT_T.setflags('\u0000');
                int[] nArray = new int[3];
                nArray[0] = bl2 ? 1 : 0;
                sL_DCMD_INPUT_T.setmbox(nArray);
                this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
                this.closeFlash();
                return vKOperationFailedException.GetErrorCode();
            }
        }
        return n2;
    }

    private int openFlash(int n) {
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setopCode(0x10F0100);
            sL_DCMD_INPUT_T.setflags('\u0000');
            int[] nArray = new int[3];
            nArray[0] = n;
            sL_DCMD_INPUT_T.setmbox(nArray);
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return vKOperationFailedException.GetErrorCode();
        }
        return 0;
    }

    private int downloadFlashImage(int n, byte[] byArray) {
        int n2 = 32768;
        int n3 = 0;
        int n4 = 0;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17760768);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int n5 = n / n2;
        for (int i = 0; i < n5; ++i) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n4, byArray2, 0, n2);
            sL_DCMD_INPUT_T.setdataTransferLength(n2);
            sL_DCMD_INPUT_T.setpData(byArray2);
            int[] nArray = new int[3];
            nArray[0] = n2 * i;
            sL_DCMD_INPUT_T.setmbox(nArray);
            try {
                this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
                n3 = vKOperationFailedException.GetErrorCode();
                break;
            }
            n4 += n2;
        }
        return n3;
    }

    public int closeFlash() {
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setopCode(17761280);
            sL_DCMD_INPUT_T.setflags('\u0000');
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return vKOperationFailedException.GetErrorCode();
        }
        return 0;
    }

    private int actualFlash() {
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setopCode(17761024);
            sL_DCMD_INPUT_T.setflags('\u0000');
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return vKOperationFailedException.GetErrorCode();
        }
        return 0;
    }

    public MR_SAS_MUX_LIST getMuxSettings() {
        return this.muxSettings;
    }

    public MR_SAS_CONNECTORS getConnector() {
        return this.sasConnector;
    }

    private void createPDList() {
        int n = 8;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(1, 4, this.getCtrlID(), 8 + 24 * n).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            short s = NetworkToJavaConverter.byteArrayToInt(byArray, 48);
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(1, 4, this.getCtrlID(), 8 + 24 * s).getByteArray());
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            this.pdObjectArrayList = new ArrayList(s);
            this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 8194, new Integer(s))));
            Logger.getInstance().log("------->>>> Number of PD Found = " + s, "KERNEL", "INFO");
            for (short s2 = 0; s2 < s; s2 = (short)((short)(s2 + 1))) {
                MR_PD_ADDRESS mR_PD_ADDRESS = new MR_PD_ADDRESS(byArray, 52 + s2 * 24);
                try {
                    switch (mR_PD_ADDRESS.getscsiDevType()) {
                        case '\u0000': {
                            this.pdObjectArrayList.add(new SASPhysicalDrive(s2, mR_PD_ADDRESS.getdeviceId(), (ISASObject)this, mR_PD_ADDRESS));
                            break;
                        }
                        case '\u0005': {
                            this.pdObjectArrayList.add(new SASCDROM(s2, mR_PD_ADDRESS.getdeviceId(), (ISASObject)this, mR_PD_ADDRESS));
                            break;
                        }
                        case '\u0001': {
                            this.pdObjectArrayList.add(new SASTape(s2, mR_PD_ADDRESS.getdeviceId(), (ISASObject)this, mR_PD_ADDRESS));
                            break;
                        }
                        case '\r': 
                        case '\u001f': {
                            this.pdObjectArrayList.add(new SASEnclosure(s2, mR_PD_ADDRESS.getdeviceId(), (ISASObject)this, mR_PD_ADDRESS));
                            break;
                        }
                        case '\u0003': {
                            this.pdObjectArrayList.add(new SASProcessor(s2, mR_PD_ADDRESS.getdeviceId(), this, mR_PD_ADDRESS));
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.cloneArrayList(this.pdObjectArrayList, this.dup_pdObjectArrayList);
    }

    private void createEnclosure(short s) {
        short s2 = this.getInformation().getMaxPDs();
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(1, 4, this.getCtrlID(), 8 + 24 * s2).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            short s3 = NetworkToJavaConverter.byteArrayToInt(byArray, 48);
            this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 8194, new Integer(s3))));
            Logger.getInstance().log("------->>>> Number of PD Found = " + s3, "KERNEL", "INFO");
            for (short s4 = 0; s4 < s3; s4 = (short)((short)(s4 + 1))) {
                MR_PD_ADDRESS mR_PD_ADDRESS = new MR_PD_ADDRESS(byArray, 52 + s4 * 24);
                if (mR_PD_ADDRESS.getdeviceId() != s) continue;
                try {
                    switch (mR_PD_ADDRESS.getscsiDevType()) {
                        case '\r': 
                        case '\u001f': {
                            this.pdObjectArrayList.add(new SASEnclosure(s4, mR_PD_ADDRESS.getdeviceId(), (ISASObject)this, mR_PD_ADDRESS));
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cloneArrayList(this.pdObjectArrayList, this.dup_pdObjectArrayList);
    }

    private void createTopologyInfo() {
        OperationDetails operationDetails = new OperationDetails(6, null);
        try {
            this.fireOperation(operationDetails);
            this.dup_topologyHeadNode = this.topologyHeadNode = (SL_TOPOLOGY_HEAD_NODE_T)operationDetails.getParam();
        }
        catch (Exception exception) {
            System.out.println("Exception while creating topology structure");
            exception.printStackTrace();
        }
    }

    public SL_TOPOLOGY_HEAD_NODE_T getTopologyHeadNode() {
        return this.dup_topologyHeadNode;
    }

    public MR_CTRL_INFO getInformation() {
        return this.dup_mrControllerInfo;
    }

    public MR_DRV_PCI_INFORMATION getPciInformation() {
        return this.mrControllerPciInfo;
    }

    private void readConfigInformation() throws VKNotRespondingException, VKOperationFailedException {
        NetworkDataPacket networkDataPacket = this.getConfigInformation(0);
        byte[] byArray = networkDataPacket.getDataBuffer();
        this.mrConfigData = new MR_CONFIG_DATA(byArray, 44);
        this.arObjectArrayList = new ArrayList(this.mrConfigData.getarrayCount());
        MR_ARRAY[] mR_ARRAYArray = this.mrConfigData.getarray();
        for (short s = 0; s < this.mrConfigData.getarrayCount(); s = (short)(s + 1)) {
            this.arObjectArrayList.add(new SASArray(s, this, mR_ARRAYArray[s]));
        }
        this.cloneArrayList(this.arObjectArrayList, this.dup_arObjectArrayList);
        this.ldObjectArrayList = new ArrayList(this.mrConfigData.getlogDrvCount());
        MR_LD_CONFIG[] mR_LD_CONFIGArray = this.mrConfigData.getld();
        for (short s = 0; s < this.mrConfigData.getlogDrvCount(); s = (short)(s + 1)) {
            try {
                this.ldObjectArrayList.add(new SASLogicalDrive((short)mR_LD_CONFIGArray[s].getproperties().getldRef().gettargetId(), this));
                continue;
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
        }
        this.cloneArrayList(this.ldObjectArrayList, this.dup_ldObjectArrayList);
        this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 8195, new Integer(this.dup_ldObjectArrayList.size()))));
    }

    public MR_SPARE[] readSpareInfo() throws VKNotRespondingException, VKOperationFailedException {
        return this.mrConfigData.getspare();
    }

    private NetworkDataPacket getConfigInformation(int n) throws VKOperationFailedException {
        return this.getConfigInformation(n, (byte)0);
    }

    private NetworkDataPacket getConfigInformation(OperationDetails operationDetails) throws VKOperationFailedException {
        NetworkDataPacket networkDataPacket;
        block12: {
            if (operationDetails.getParam() == null) {
                return this.getConfigInformation(0, (byte)operationDetails.getOpcode());
            }
            byte[] byArray = new byte[8];
            NetworkToJavaConverter.shortTobyteArray((Short)operationDetails.getParam(), byArray, 0);
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(4, (byte)operationDetails.getOpcode(), this.getCtrlID(), byArray, 616).getByteArray());
            try {
                ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                if (n != 0) {
                    throw new VKOperationFailedException(n);
                }
                int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 44);
                if (n2 > 616) {
                    if (operationDetails.getOpcode() == 5) {
                        SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(4, (byte)operationDetails.getOpcode(), this.getCtrlID(), byArray, n2);
                        networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
                        try {
                            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
                            byArray2 = networkDataPacket.getDataBuffer();
                            n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                            if (n != 0) {
                                throw new VKOperationFailedException(n);
                            }
                            break block12;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block12;
                    }
                    networkDataPacket = this.getConfigInformation(n2, (byte)operationDetails.getOpcode());
                    break block12;
                }
                SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(4, (byte)operationDetails.getOpcode(), this.getCtrlID(), byArray, n2);
                networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
                try {
                    ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
                    byArray2 = networkDataPacket.getDataBuffer();
                    n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                    if (n != 0) {
                        throw new VKOperationFailedException(n);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return networkDataPacket;
    }

    private NetworkDataPacket getConfigInformation(int n, byte by) throws VKOperationFailedException {
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(4, by, this.getCtrlID(), n == 0 ? 616 : n).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n2 != 0) {
                throw new VKOperationFailedException(n2);
            }
            int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 44);
            if (n3 > Math.max(616, n)) {
                networkDataPacket = this.getConfigInformation(n3, by);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return networkDataPacket;
    }

    private NetworkDataPacket storeLibControllerOperation(int n, byte[] byArray, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        byte by = 1;
        return this.storeLibOperation(by, n, byArray, operationDetails);
    }

    private NetworkDataPacket storeLibControllerOperation(int n, byte[] byArray, byte[] byArray2, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        byte by = 1;
        return this.storeLibOperation(by, n, byArray, byArray2, operationDetails);
    }

    protected NetworkDataPacket storeLibOperation(byte by, int n, byte[] byArray, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray2 = new byte[8];
        NetworkToJavaConverter.unsignedShortTobyteArray(this.getSeqNum(), byArray2, 0);
        try {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(by, (byte)operationDetails.getOpcode(), this.getCtrlID(), byArray2, n, byArray).getByteArray());
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return networkDataPacket;
    }

    protected NetworkDataPacket storeLibOperation(byte by, int n, byte[] byArray, byte[] byArray2, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray3 = new byte[8];
        NetworkToJavaConverter.unsignedShortTobyteArray(this.getSeqNum(), byArray3, 0);
        try {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(by, (byte)operationDetails.getOpcode(), this.getCtrlID(), byArray3, byArray2, n, byArray).getByteArray());
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return networkDataPacket;
    }

    protected NetworkDataPacket storeLibOperation(byte by, int n, byte[] byArray, short s, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray2 = new byte[8];
        NetworkToJavaConverter.unsignedShortTobyteArray(s, byArray2, 0);
        try {
            SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(by, (byte)operationDetails.getOpcode(), this.getCtrlID(), byArray2, n, byArray);
            networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return networkDataPacket;
    }

    public int flashFWOperation(byte[] byArray, byte[] byArray2, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        int n = 1;
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray3 = null;
        byte[] byArray4 = byArray;
        byte[] byArray5 = byArray2;
        if (this.sasServer.isCIMOMServer() && this.adpType == 1) {
            n = this.fireDCMDFlashCtrlFirmware(byArray4, byArray5);
        } else {
            networkDataPacket = this.storeLibControllerOperation(byArray4.length, byArray4, byArray5, operationDetails);
            byArray3 = networkDataPacket.getDataBuffer();
            n = NetworkToJavaConverter.byteArrayToInt(byArray3);
        }
        if (n == 0 && (this.getAdapterType() == 2 || this.getAdapterType() == 3 || this.getAdapterType() == 4)) {
            OperationDetails operationDetails2 = new OperationDetails(26, null);
            networkDataPacket = this.storeLibControllerOperation(0, null, operationDetails2);
            byArray3 = networkDataPacket.getDataBuffer();
            n = NetworkToJavaConverter.byteArrayToInt(byArray3);
        }
        if (n != 0) {
            System.out.println("SASAdapter.fireOperation()->retval = " + n);
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        if (this.isMRApiIncompatible() && operationDetails.getOpcode() != 0) {
            throw new VKOperationFailedException(4113);
        }
        int n = 1;
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray = null;
        switch (operationDetails.getOpcode()) {
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                networkDataPacket = this.storeLibControllerOperation(0, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 18: {
                networkDataPacket = this.storeLibControllerOperation(0, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n != 39) break;
                n = 0;
                break;
            }
            case 3: {
                Object object;
                byte[] byArray2 = null;
                byte[] byArray3 = new byte[8];
                try {
                    object = (String)operationDetails.getParam();
                    byArray3[0] = ((String)object).charAt(0) == '1' ? 1 : (((String)object).charAt(0) == '3' ? 3 : (((String)object).charAt(0) == '2' ? 2 : 0));
                    String string = ((String)object).substring(1, ((String)object).length());
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                    byArray2 = new byte[(int)fileInputStream.getChannel().size()];
                    dataInputStream.readFully(byArray2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new VKOperationFailedException(4096);
                }
                if (this.sasServer.isCIMOMServer() && this.adpType == 1) {
                    n = this.fireDCMDFlashCtrlFirmware(byArray2, byArray3);
                } else {
                    networkDataPacket = this.storeLibControllerOperation(byArray2.length, byArray2, byArray3, operationDetails);
                    byArray = networkDataPacket.getDataBuffer();
                    n = NetworkToJavaConverter.byteArrayToInt(byArray);
                }
                if (n != 0 || this.getAdapterType() != 2 && this.getAdapterType() != 3 && this.getAdapterType() != 4) break;
                object = new OperationDetails(26, null);
                networkDataPacket = this.storeLibControllerOperation(0, null, (OperationDetails)object);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 16: {
                networkDataPacket = this.storeLibControllerOperation(208, ((MR_PR_PROPERTIES)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 19: {
                networkDataPacket = this.storeLibControllerOperation(112, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_DRV_DRIVER_VERSION mR_DRV_DRIVER_VERSION = new MR_DRV_DRIVER_VERSION(byArray, 44);
                operationDetails.setParameter(mR_DRV_DRIVER_VERSION);
                break;
            }
            case 15: {
                networkDataPacket = this.storeLibControllerOperation(208, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_PR_PROPERTIES mR_PR_PROPERTIES = new MR_PR_PROPERTIES(byArray, 44);
                operationDetails.setParameter(mR_PR_PROPERTIES);
                break;
            }
            case 18088704: {
                try {
                    this.setScheduleCCProperties(operationDetails);
                    n = 0;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    n = vKOperationFailedException.GetErrorCode();
                    this.m_MR_CC_Sch_Prop = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 18088448: {
                try {
                    this.createCCSchProperties();
                    operationDetails.setParameter(this.m_MR_CC_Sch_Prop);
                    n = 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 0x1020200: {
                n = this.setCtrlProperties(operationDetails);
                break;
            }
            case 1: {
                networkDataPacket = this.storeLibControllerOperation(64, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_CTRL_PROP mR_CTRL_PROP = new MR_CTRL_PROP(byArray, 44);
                operationDetails.setParameter(mR_CTRL_PROP);
                break;
            }
            case 40: {
                operationDetails.setOpcode(2);
                networkDataPacket = this.storeLibControllerOperation(64, ((MR_CTRL_PROP)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                operationDetails.setOpcode(40);
                break;
            }
            case 2: {
                networkDataPacket = this.storeLibControllerOperation(64, ((MR_CTRL_PROP)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 27: {
                operationDetails.setOpcode(2);
                networkDataPacket = this.storeLibControllerOperation(64, ((MR_CTRL_PROP)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 42: {
                operationDetails.setOpcode(2);
                MR_CTRL_PROP mR_CTRL_PROP = this.mrControllerInfo.getproperties();
                mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setSSDSmartErEnabled(1);
                operationDetails.setParameter(mR_CTRL_PROP);
                networkDataPacket = this.storeLibControllerOperation(64, ((MR_CTRL_PROP)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 43: {
                operationDetails.setOpcode(2);
                MR_CTRL_PROP mR_CTRL_PROP = this.mrControllerInfo.getproperties();
                mR_CTRL_PROP.getOnOffProperties_MR_CTRL_PROP().setSSDSmartErEnabled(0);
                operationDetails.setParameter(mR_CTRL_PROP);
                networkDataPacket = this.storeLibControllerOperation(64, ((MR_CTRL_PROP)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 6: {
                networkDataPacket = this.storeLibControllerOperation(16384, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                SL_TOPOLOGY_HEAD_NODE_T sL_TOPOLOGY_HEAD_NODE_T = new SL_TOPOLOGY_HEAD_NODE_T(byArray, 44);
                operationDetails.setParameter(sL_TOPOLOGY_HEAD_NODE_T);
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 21: {
                networkDataPacket = operationDetails.getParam() != null ? this.storeLibControllerOperation(9220, null, (byte[])operationDetails.getParam(), operationDetails) : this.storeLibControllerOperation(9220, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                SL_DRIVE_DISTRIBUTION_T sL_DRIVE_DISTRIBUTION_T = new SL_DRIVE_DISTRIBUTION_T(byArray, 44);
                operationDetails.setParameter(sL_DRIVE_DISTRIBUTION_T);
                break;
            }
            case 60: {
                networkDataPacket = this.storeLibControllerOperation(320, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                ADV_SYSTEM_INFO aDV_SYSTEM_INFO = new ADV_SYSTEM_INFO(byArray, 44);
                operationDetails.setParameter(aDV_SYSTEM_INFO);
                break;
            }
            case 24: 
            case 25: {
                networkDataPacket = operationDetails.getParam() != null ? this.storeLibControllerOperation(70660, null, (byte[])operationDetails.getParam(), operationDetails) : this.storeLibControllerOperation(70660, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                SL_DRIVE_DISTRIBUTION_EX_T sL_DRIVE_DISTRIBUTION_EX_T = new SL_DRIVE_DISTRIBUTION_EX_T(byArray, 44);
                operationDetails.setParameter(sL_DRIVE_DISTRIBUTION_EX_T);
                break;
            }
            case 14: {
                networkDataPacket = this.storeLibControllerOperation(16, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_PR_STATUS mR_PR_STATUS = new MR_PR_STATUS(byArray, 44);
                operationDetails.setParameter(mR_PR_STATUS);
                break;
            }
            case 5: {
                networkDataPacket = this.storeLibControllerOperation(4616, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_ENCL_LIST mR_ENCL_LIST = new MR_ENCL_LIST(byArray, 44);
                operationDetails.setParameter(mR_ENCL_LIST);
                break;
            }
            case 33281: {
                operationDetails.setParameter(new Byte(this.getSMARTMode()));
                n = 0;
                break;
            }
            case 33282: {
                Byte by = (Byte)operationDetails.getParam();
                this.setSMARTMode(by);
                n = 0;
                break;
            }
            case 17695489: {
                System.out.println("Inside case MR_DCMD.MR_DCMD_CTRL_MFC_MFG_GET:");
                byte[] byArray4 = new byte[32];
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(17695489);
                sL_DCMD_INPUT_T.setflags('\u0002');
                sL_DCMD_INPUT_T.setpData(new byte[32]);
                try {
                    byte[] byArray5 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                    operationDetails.setParameter(new MR_MFC_MFG(byArray5, 32));
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    operationDetails.setParameter(null);
                }
                break;
            }
            case 18155520: {
                System.out.println("in MR_DCMD_CTRL_LOCK_KEY_FROM_ESCROW");
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(18155520);
                sL_DCMD_INPUT_T.setflags('\u0001');
                MR_CTRL_LOCK_KEY_FROM_ESCROW mR_CTRL_LOCK_KEY_FROM_ESCROW = new MR_CTRL_LOCK_KEY_FROM_ESCROW();
                MR_CTRL_LOCK_KEY_PASSPHRASE mR_CTRL_LOCK_KEY_PASSPHRASE = new MR_CTRL_LOCK_KEY_PASSPHRASE();
                mR_CTRL_LOCK_KEY_PASSPHRASE.setPassPhrase(operationDetails.getParam().toString().getBytes());
                mR_CTRL_LOCK_KEY_FROM_ESCROW.setLockKeyPassPhrase(mR_CTRL_LOCK_KEY_PASSPHRASE);
                sL_DCMD_INPUT_T.setpData(mR_CTRL_LOCK_KEY_FROM_ESCROW.getByteArray());
                int[] nArray = new int[3];
                nArray[0] = 0;
                sL_DCMD_INPUT_T.setmbox(nArray);
                try {
                    byte[] byArray6 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                    n = 0;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    vKOperationFailedException.printStackTrace();
                    System.out.println("Exception occured while firing operation.");
                    throw vKOperationFailedException;
                }
            }
            case 0x30D0000: {
                try {
                    operationDetails.setParameter(new Long(this.getPinnedCacheList()));
                    n = 0;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    n = vKOperationFailedException.GetErrorCode();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 51183872: {
                try {
                    this.discardPinnedCache(operationDetails);
                    n = 0;
                    break;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    n = vKOperationFailedException.GetErrorCode();
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (n != 0) {
            System.out.println("SASAdapter.fireOperation()->retval = " + n);
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    private NetworkDataPacket storeLibConfigOperation(int n, byte[] byArray, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        return this.storeLibOperation((byte)4, n, byArray, operationDetails);
    }

    public int fireConfigOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        if (this.isMRApiIncompatible()) {
            throw new VKOperationFailedException(4113);
        }
        int n = 1;
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray = null;
        switch (operationDetails.getOpcode()) {
            case 2: {
                networkDataPacket = this.storeLibConfigOperation(0, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 0: {
                networkDataPacket = this.getConfigInformation(0, (byte)operationDetails.getOpcode());
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_CONFIG_DATA mR_CONFIG_DATA = new MR_CONFIG_DATA(byArray, 44);
                operationDetails.setParameter(mR_CONFIG_DATA);
                break;
            }
            case 4: 
            case 5: {
                networkDataPacket = this.getConfigInformation(operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_CONFIG_DATA mR_CONFIG_DATA = new MR_CONFIG_DATA(byArray, 44);
                operationDetails.setParameter(mR_CONFIG_DATA);
                break;
            }
            case 9: {
                networkDataPacket = this.storeLibConfigOperation(4, null, operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                Integer n2 = new Integer(NetworkToJavaConverter.byteArrayToInt(byArray, 44));
                operationDetails.setParameter(n2);
                break;
            }
            case 1: {
                networkDataPacket = this.storeLibConfigOperation(((MR_CONFIG_DATA)operationDetails.getParam()).getByteArray().length, ((MR_CONFIG_DATA)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 3: {
                networkDataPacket = this.storeLibConfigOperation(196, new byte[196], operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_FOREIGN_CFG_GUIDS mR_FOREIGN_CFG_GUIDS = new MR_FOREIGN_CFG_GUIDS(byArray, 44);
                operationDetails.setParameter(mR_FOREIGN_CFG_GUIDS);
                break;
            }
            case 7: {
                networkDataPacket = this.storeLibOperation((byte)4, 0, null, (Short)operationDetails.getParam(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 6: {
                ArrayList arrayList = (ArrayList)operationDetails.getParam();
                networkDataPacket = this.storeLibOperation((byte)4, ((MR_CONFIG_DATA)arrayList.get(0)).getByteArray().length, ((MR_CONFIG_DATA)arrayList.get(0)).getByteArray(), (Short)arrayList.get(1), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 10: {
                networkDataPacket = this.storeLibConfigOperation(((MR_ARRAY)operationDetails.getParam()).getByteArray().length, ((MR_ARRAY)operationDetails.getParam()).getByteArray(), operationDetails);
                byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
            }
        }
        if (n != 0) {
            System.out.println("SASAdapter.fireConfigOperation()->retval = " + n);
            throw new VKOperationFailedException(n, (short)operationDetails.getOpcode());
        }
        return n;
    }

    public MR_CC_SCHEDULE_PROPERTIES getScheduleCCProperties() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        MR_CC_SCHEDULE_PROPERTIES mR_CC_SCHEDULE_PROPERTIES = null;
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(72);
            sL_DCMD_INPUT_T.setopCode(18088448);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setpData(new byte[168]);
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            mR_CC_SCHEDULE_PROPERTIES = new MR_CC_SCHEDULE_PROPERTIES(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            mR_CC_SCHEDULE_PROPERTIES = null;
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            mR_CC_SCHEDULE_PROPERTIES = null;
        }
        return mR_CC_SCHEDULE_PROPERTIES;
    }

    public long getPinnedCacheList() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        long l = 0L;
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(72);
            sL_DCMD_INPUT_T.setopCode(0x30D0000);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setpData(new byte[72]);
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            l = NetworkToJavaConverter.byteArrayToLong(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            l = 0L;
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            l = 0L;
        }
        return l;
    }

    public int discardPinnedCache(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51183872);
        sL_DCMD_INPUT_T.setflags('\u0000');
        Integer n = (int)((Integer)operationDetails.getParam());
        int[] nArray = new int[3];
        nArray[0] = n;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray);
        return n2;
    }

    public MR_MFC_MFG getFRUProperties() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        MR_MFC_MFG mR_MFC_MFG = null;
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(32);
            sL_DCMD_INPUT_T.setopCode(17695489);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setpData(new byte[32]);
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            mR_MFC_MFG = new MR_MFC_MFG(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            mR_MFC_MFG = null;
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            mR_MFC_MFG = null;
        }
        return mR_MFC_MFG;
    }

    public MR_MFC_MFG_2 getBatteryFRUProperties() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        MR_MFC_MFG_2 mR_MFC_MFG_2 = null;
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(32);
            sL_DCMD_INPUT_T.setflags('\u0002');
            sL_DCMD_INPUT_T.setopCode(17695490);
            sL_DCMD_INPUT_T.setpData(new byte[32]);
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            mR_MFC_MFG_2 = new MR_MFC_MFG_2(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mR_MFC_MFG_2;
    }

    public int setCtrlProperties(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        operationDetails.setOpcode(2);
        NetworkDataPacket networkDataPacket = this.storeLibControllerOperation(64, ((MR_CTRL_PROP)operationDetails.getParam()).getByteArray(), operationDetails);
        byte[] byArray = networkDataPacket.getDataBuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        return n;
    }

    public MR_CTRL_PROP getCtrlProperties(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[64]);
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        MR_CTRL_PROP mR_CTRL_PROP = new MR_CTRL_PROP(byArray, 32);
        return mR_CTRL_PROP;
    }

    public int setScheduleCCProperties(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
        sL_DCMD_INPUT_T.setflags('\u0001');
        sL_DCMD_INPUT_T.setpData(((MR_CC_SCHEDULE_PROPERTIES)operationDetails.getParam()).getByteArray());
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        return n;
    }

    public MR_PR_PROPERTIES getPatrolReadProperties() {
        if (this.m_PR_Prop != null) {
            return this.m_PR_Prop;
        }
        try {
            this.m_PR_Prop = this.createPatrolReadProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_PR_Prop;
    }

    public MR_PR_STATUS getPatrolReadStatus() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        MR_PR_STATUS mR_PR_STATUS = null;
        OperationDetails operationDetails = new OperationDetails(14, "", "", null);
        this.fireOperation(operationDetails);
        mR_PR_STATUS = (MR_PR_STATUS)operationDetails.getParam();
        return mR_PR_STATUS;
    }

    private void createBBUInformation() {
        try {
            this.sasBBU = new SASBatteryBackUp(this);
            this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 8196, null)));
        }
        catch (Exception exception) {
            this.sasBBU = null;
        }
    }

    public SASBatteryBackUp getBBUObject() throws VKObjectNotPresentException {
        if (this.sasBBU == null) {
            throw new VKObjectNotPresentException(8);
        }
        return this.sasBBU;
    }

    public int firePassThruCMD(int n) {
        if (this.isMRApiIncompatible()) {
            return 1;
        }
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray = new byte[76 + n];
        byArray[4] = 6;
        byArray[5] = 3;
        NetworkToJavaConverter.intToByteArray(this.getCtrlID(), byArray, 8);
        NetworkToJavaConverter.intToByteArray(32, byArray, 32);
        NetworkDataPacket networkDataPacket2 = new NetworkDataPacket(byArray);
        try {
            this.processCommand(networkDataPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void cleanUPLogicalList() {
        if (this.ldObjectArrayList != null && this.ldObjectArrayList.size() != 0) {
            Iterator iterator = this.ldObjectArrayList.iterator();
            while (iterator.hasNext()) {
                ((SASLogicalDrive)iterator.next()).deleteObservers();
                iterator.remove();
            }
        }
    }

    public void cleanUPArrayList() {
        if (this.arObjectArrayList != null && this.arObjectArrayList.size() != 0) {
            Iterator iterator = this.arObjectArrayList.iterator();
            while (iterator.hasNext()) {
                ((SASArray)iterator.next()).deleteObservers();
                iterator.remove();
            }
        }
    }

    public void cleanUPPhysicalList() {
        if (this.pdObjectArrayList != null && this.pdObjectArrayList.size() != 0) {
            Iterator iterator = this.pdObjectArrayList.iterator();
            while (iterator.hasNext()) {
                ((SASPhysicalDevice)iterator.next()).deleteObservers();
                iterator.remove();
            }
        }
    }

    public void cleanUpBBUInformation() {
        if (this.sasBBU != null) {
            this.sasBBU.deleteObservers();
        }
    }

    public void cleanUP(short s) {
        this.deleteObservers();
        this.unRegisterAEN();
        if ((s & 0x1000) != 0) {
            this.cleanUPPhysicalList();
        }
        if ((s & 0x2000) != 0) {
            this.cleanUPLogicalList();
        }
        if ((s & 0x4000) != 0) {
            this.cleanUPArrayList();
        }
    }

    public boolean processAllAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        boolean bl;
        if (mR_EVT_DETAIL.getcode() == 35) {
            this.m_PR_Status.setstate('\u0000');
        }
        boolean bl2 = this.adpType == 2 || this.adpType == 3 || this.adpType == 4;
        boolean bl3 = bl = mR_EVT_DETAIL.getcl().geteventClass() != -1;
        if (mR_EVT_DETAIL.getseqNum() <= this.m_OldSequenceNum) {
            if (bl2) {
                if (bl) {
                    return true;
                }
            } else {
                return true;
            }
        }
        switch (mR_EVT_DETAIL.getcode()) {
            case 4: 
            case 487: {
                this.processConfigAEN(mR_EVT_DETAIL);
                return true;
            }
            case 114: 
            case 115: {
                pdState_args_MR_EVT_DETAIL pdState_args_MR_EVT_DETAIL2 = mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1();
                if (pdState_args_MR_EVT_DETAIL2 == null || !(pdState_args_MR_EVT_DETAIL2.getprevState() == 0 && pdState_args_MR_EVT_DETAIL2.getnewState() == 24 || pdState_args_MR_EVT_DETAIL2.getprevState() == 2 && pdState_args_MR_EVT_DETAIL2.getnewState() == 20) && (pdState_args_MR_EVT_DETAIL2.getprevState() != 20 || pdState_args_MR_EVT_DETAIL2.getnewState() != 2)) break;
                this.processConfigAEN(mR_EVT_DETAIL);
                return true;
            }
            case 323: 
            case 325: 
            case 326: {
                this.processLogicalDriveAEN(mR_EVT_DETAIL);
            }
        }
        block5 : switch (mR_EVT_DETAIL.getcl().getlocale()) {
            case 64: {
                this.processConfigAEN(mR_EVT_DETAIL);
                break;
            }
            case 8: {
                this.processBBUAEN(mR_EVT_DETAIL);
                break;
            }
            case 128: {
                this.processClusterAEN(mR_EVT_DETAIL);
            }
            case 130: {
                this.processClusterAEN(mR_EVT_DETAIL);
            }
            case 32: {
                this.processControllerAEN(mR_EVT_DETAIL);
                break;
            }
            case 4: {
                switch (mR_EVT_DETAIL.getcode()) {
                    case 166: 
                    case 167: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 190: {
                        this.processConfigAEN(mR_EVT_DETAIL);
                        break block5;
                    }
                }
                this.processEnclosureAEN(mR_EVT_DETAIL);
                break;
            }
            case 1: 
            case 65: {
                if (mR_EVT_DETAIL.getcode() == 346 || mR_EVT_DETAIL.getcode() == 347) {
                    this.processConfigAEN(mR_EVT_DETAIL);
                    break;
                }
                this.processLogicalDriveAEN(mR_EVT_DETAIL);
                break;
            }
            case 2: {
                this.processPhysicalDriveAEN(mR_EVT_DETAIL);
                break;
            }
            case 16: {
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (mR_EVT_DETAIL.getcode() == 139 || mR_EVT_DETAIL.getcode() == 138) {
                    this.processLogicalDriveAEN(mR_EVT_DETAIL);
                    break;
                }
                if (mR_EVT_DETAIL.getcode() != 132 && mR_EVT_DETAIL.getcode() != 133 && mR_EVT_DETAIL.getcode() != 135 && mR_EVT_DETAIL.getcode() != 136 && mR_EVT_DETAIL.getcode() != 405 && mR_EVT_DETAIL.getcode() != 406 && mR_EVT_DETAIL.getcode() != 231 && mR_EVT_DETAIL.getcode() != 232) break;
                this.processPhysicalDriveAEN(mR_EVT_DETAIL);
            }
        }
        return true;
    }

    public boolean processConfigAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        this.storeLatestSequenceNumber();
        switch (mR_EVT_DETAIL.getcode()) {
            case 137: {
                return true;
            }
        }
        NotifyObject notifyObject = null;
        NotifyObject notifyObject2 = null;
        try {
            this.cleanUPPhysicalList();
            this.createPDList();
            this.cleanUPLogicalList();
            this.cleanUPArrayList();
            this.createInformation();
            this.readConfigInformation();
            notifyObject = new NotifyObject(0x102001, mR_EVT_DETAIL);
            if (mR_EVT_DETAIL.getcode() == 112 || mR_EVT_DETAIL.getcode() == 91) {
                notifyObject2 = new NotifyObject(0x102002, mR_EVT_DETAIL);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (notifyObject != null) {
            this.notifyMethod(notifyObject);
        }
        if (notifyObject2 != null) {
            this.notifyMethod(notifyObject2);
        }
        return true;
    }

    public boolean processLogicalDriveAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        NotifyObject notifyObject = null;
        block5 : switch (mR_EVT_DETAIL.getcode()) {
            case 74: 
            case 75: {
                ListIterator listIterator = this.dup_ldObjectArrayList.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)listIterator.next();
                        if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getld() == null || sASLogicalDrive.getID() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getld().gettargetId()) continue;
                        sASLogicalDrive.handleAEN(mR_EVT_DETAIL);
                        this.cleanUPLogicalList();
                        this.cleanUPArrayList();
                        this.readConfigInformation();
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                notifyObject = new NotifyObject(1056772, mR_EVT_DETAIL);
                break;
            }
            case 139: 
            case 377: {
                this.processConfigAEN(mR_EVT_DETAIL);
                break;
            }
            case 460: 
            case 461: {
                break;
            }
            case 54: 
            case 73: 
            case 81: 
            case 399: {
                this.processConfigAEN(mR_EVT_DETAIL);
                break;
            }
            case 138: 
            case 323: 
            case 325: 
            case 443: 
            case 444: {
                try {
                    this.cleanUPLogicalList();
                    this.cleanUPArrayList();
                    this.readConfigInformation();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                notifyObject = new NotifyObject(1056772, mR_EVT_DETAIL);
                break;
            }
            case 326: {
                try {
                    this.createInformation();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            default: {
                ListIterator listIterator = this.dup_ldObjectArrayList.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        int n;
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)listIterator.next();
                        if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getld() != null) {
                            if (sASLogicalDrive.getID() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getld().gettargetId()) continue;
                            System.out.println("mrEventDetail.getargs_MR_EVT_DETAIL1().getld().gettargetId() " + mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getld().gettargetId());
                            sASLogicalDrive.handleAEN(mR_EVT_DETAIL);
                            break block5;
                        }
                        if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getMR_EVT_ARGS_LD_PIT() != null) {
                            System.out.println("mrEventDetail.getargType " + mR_EVT_DETAIL.getargType());
                            if (sASLogicalDrive.getID() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getMR_EVT_ARGS_LD_PIT().getLd().gettargetId()) continue;
                            System.out.println("mrEventDetail.getargs_MR_EVT_DETAIL1().getMR_EVT_ARGS_LD_PIT().getLd().gettargetId() " + mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getMR_EVT_ARGS_LD_PIT().getLd().gettargetId());
                            sASLogicalDrive.handleAEN(mR_EVT_DETAIL);
                            break block5;
                        }
                        if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getView_args_MR_EVT_DETAIL1() != null) {
                            System.out.println("mrEventDetail.getargType " + mR_EVT_DETAIL.getargType());
                            if (sASLogicalDrive.getID() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getView_args_MR_EVT_DETAIL1().getLd().gettargetId()) continue;
                            sASLogicalDrive.handleAEN(mR_EVT_DETAIL);
                            break block5;
                        }
                        if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getLD_ld_MR_EVT_DETAIL1() != null) {
                            System.out.println("mrEventDetail.getargType " + mR_EVT_DETAIL.getargType());
                            if (sASLogicalDrive.getID() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getLD_ld_MR_EVT_DETAIL1().getLd().gettargetId()) continue;
                            sASLogicalDrive.handleAEN(mR_EVT_DETAIL);
                            break block5;
                        }
                        if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgsBitmap() == null) continue;
                        MAX_LOGICAL_DRIVES1 = (short)this.getInformation().getmaxLDs();
                        int[] nArray = new int[MAX_LOGICAL_DRIVES1];
                        char[] cArray = mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgsBitmap().getEvtBitmap();
                        int n2 = mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgsBitmap().getCount();
                        int n3 = 0;
                        for (n = 0; n < n2; ++n) {
                            for (int n4 = 0; n4 < 8; n4 = (int)((byte)(n4 + 1))) {
                                if ((cArray[n] & 1 << n4) <= 0) continue;
                                nArray[n3++] = n * 8 + n4;
                            }
                        }
                        n = 0;
                        if (n >= n3 || sASLogicalDrive.getID() != nArray[n]) continue;
                        System.out.println("Schedule properties changed LDs are " + nArray[n]);
                        sASLogicalDrive.handleAEN(mR_EVT_DETAIL);
                    }
                    catch (NullPointerException nullPointerException) {
                        return false;
                    }
                }
                break block5;
            }
        }
        if (notifyObject != null) {
            this.notifyMethod(notifyObject);
        }
        return true;
    }

    public boolean processPhysicalDriveAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        NotifyObject notifyObject = null;
        block9 : switch (mR_EVT_DETAIL.getcode()) {
            case 134: 
            case 137: {
                return true;
            }
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 231: 
            case 232: 
            case 405: 
            case 406: {
                try {
                    this.cleanUPPhysicalList();
                    this.createPDList();
                    this.cleanUPLogicalList();
                    this.cleanUPArrayList();
                    this.readConfigInformation();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("(mrEventDetail.getargs_MR_EVT_DETAIL1().getArgs_pd_Spare() :" + mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgs_pd_Spare());
                if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgs_pd_Spare() != null && mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgs_pd_Spare().getPd() != null) {
                    ListIterator listIterator = this.dup_pdObjectArrayList.listIterator();
                    while (listIterator.hasNext()) {
                        try {
                            SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)listIterator.next();
                            if (sASPhysicalDevice.getDeviceId() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgs_pd_Spare().getPd().getdeviceId()) continue;
                            sASPhysicalDevice.handleAEN(mR_EVT_DETAIL);
                        }
                        catch (Exception exception) {}
                    }
                }
                notifyObject = new NotifyObject(1056772, mR_EVT_DETAIL);
                break;
            }
            case 288: 
            case 289: {
                if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getPdPath_args_MR_EVT_DETAIL1() == null) break;
                ListIterator listIterator = this.dup_pdObjectArrayList.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)listIterator.next();
                        if (sASPhysicalDevice.getDeviceId() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getPdPath_args_MR_EVT_DETAIL1().getpd().getdeviceId()) continue;
                        sASPhysicalDevice.handleAEN(mR_EVT_DETAIL);
                        break block9;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                break;
            }
            case 91: 
            case 463: {
                this.cleanUPPhysicalList();
                this.createPDList();
                try {
                    this.cleanUPLogicalList();
                    this.cleanUPArrayList();
                    this.readConfigInformation();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (mR_EVT_DETAIL.getcode() == 463) break;
                notifyObject = new NotifyObject(0x102002, mR_EVT_DETAIL);
                break;
            }
            case 112: 
            case 462: {
                if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpd() != null) {
                    for (int i = 0; i < this.dup_pdObjectArrayList.size(); ++i) {
                        SASPhysicalDrive sASPhysicalDrive = null;
                        try {
                            if (!(this.dup_pdObjectArrayList.get(i) instanceof SASPhysicalDrive)) {
                                this.cleanUPPhysicalList();
                                this.createPDList();
                                break;
                            }
                            sASPhysicalDrive = (SASPhysicalDrive)this.dup_pdObjectArrayList.get(i);
                            if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpd() == null) continue;
                            if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpd().getdeviceId() == -1) {
                                this.createPDList();
                                continue;
                            }
                            if (sASPhysicalDrive.getAddress().getdeviceId() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpd().getdeviceId()) continue;
                            sASPhysicalDrive.deleteObservers();
                            this.pdObjectArrayList.remove(this.pdObjectArrayList.indexOf(sASPhysicalDrive));
                            this.cloneArrayList(this.pdObjectArrayList, this.dup_pdObjectArrayList);
                            break;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (mR_EVT_DETAIL.getcode() == 462) break;
                notifyObject = new NotifyObject(0x102002, mR_EVT_DETAIL);
                break;
            }
            case 276: 
            case 277: 
            case 281: 
            case 282: 
            case 293: 
            case 294: 
            case 295: {
                ListIterator listIterator = this.dup_pdObjectArrayList.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)listIterator.next();
                        if (sASPhysicalDevice.getDeviceId() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgs_pd_pd().getDestPd().getdeviceId()) continue;
                        sASPhysicalDevice.handleAEN(mR_EVT_DETAIL);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                break;
            }
            case 278: {
                try {
                    this.cleanUPPhysicalList();
                    this.createPDList();
                    this.cleanUPLogicalList();
                    this.cleanUPArrayList();
                    this.readConfigInformation();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                notifyObject = new NotifyObject(1056772, mR_EVT_DETAIL);
                break;
            }
            case 280: {
                ListIterator listIterator = this.dup_pdObjectArrayList.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)listIterator.next();
                        if (sASPhysicalDevice.getDeviceId() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getArgs_pd_pd().getDestPd().getdeviceId()) continue;
                        sASPhysicalDevice.handleAEN(mR_EVT_DETAIL);
                        break block9;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                break;
            }
            default: {
                Object object = this.dup_pdObjectArrayList.listIterator();
                while (object.hasNext()) {
                    try {
                        SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)object.next();
                        if (sASPhysicalDevice.getDeviceId() != mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpd().getdeviceId()) continue;
                        sASPhysicalDevice.handleAEN(mR_EVT_DETAIL);
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                if (mR_EVT_DETAIL.getcode() != 115 && mR_EVT_DETAIL.getcode() != 114 || (((pdState_args_MR_EVT_DETAIL)(object = mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1())).getprevState() != 0 || ((pdState_args_MR_EVT_DETAIL)object).getnewState() != 64) && (((pdState_args_MR_EVT_DETAIL)object).getprevState() != 64 || ((pdState_args_MR_EVT_DETAIL)object).getnewState() != 0)) break;
                this.processConfigAEN(mR_EVT_DETAIL);
            }
        }
        if (notifyObject != null) {
            this.notifyMethod(notifyObject);
        }
        return true;
    }

    public boolean processEnclosureAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        for (int i = 0; i < this.dup_pdObjectArrayList.size(); ++i) {
            SASEnclosure sASEnclosure = null;
            try {
                if (!(this.dup_pdObjectArrayList.get(i) instanceof SASEnclosure)) continue;
                sASEnclosure = (SASEnclosure)this.dup_pdObjectArrayList.get(i);
                if (mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpd().getdeviceId() != sASEnclosure.getDeviceId()) continue;
                sASEnclosure.handleAEN(mR_EVT_DETAIL);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public boolean processBBUAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        NotifyObject notifyObject = null;
        switch (mR_EVT_DETAIL.getcode()) {
            case 141: 
            case 161: {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.cleanUpBBUInformation();
                this.createBBUInformation();
                notifyObject = new NotifyObject(1056771, mR_EVT_DETAIL);
                break;
            }
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 306: 
            case 449: {
                System.out.println("in MR_EVT_BBU_PROPERTIES_CHANGED");
                notifyObject = new NotifyObject(2101251, mR_EVT_DETAIL);
                this.sasBBU.handleAEN(mR_EVT_DETAIL);
                break;
            }
        }
        if (notifyObject != null) {
            this.notifyMethod(notifyObject);
        }
        return true;
    }

    public boolean processClusterAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        switch (mR_EVT_DETAIL.getcode()) {
            case 462: 
            case 463: {
                this.processPhysicalDriveAEN(mR_EVT_DETAIL);
            }
            case 469: 
            case 470: 
            case 471: 
            case 473: 
            case 474: {
                this.processControllerAEN(mR_EVT_DETAIL);
                this.createInformation();
            }
        }
        return true;
    }

    public boolean processControllerAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        NotifyObject notifyObject = null;
        switch (mR_EVT_DETAIL.getcode()) {
            case 220: 
            case 296: 
            case 323: 
            case 324: 
            case 325: {
                try {
                    this.createInformation();
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
            case 7: {
                this.getInformation().getproperties().setalarmEnable('\u0000');
                break;
            }
            case 8: {
                this.getInformation().getproperties().setalarmEnable('\u0001');
                break;
            }
            case 9: {
                this.getInformation().getproperties().setbgiRate((char)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getrate());
                break;
            }
            case 40: {
                this.getInformation().getproperties().setrebuildRate((char)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getrate());
                break;
            }
            case 14: {
                this.getInformation().getproperties().setccRate((char)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getrate());
                break;
            }
            case 37: {
                this.getInformation().getproperties().setpatrolReadRate((char)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getrate());
                break;
            }
            case 41: {
                this.getInformation().getproperties().setreconRate((char)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getrate());
                break;
            }
            case 304: {
                try {
                    this.m_PR_Prop = this.createPatrolReadProperties();
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    vKOperationFailedException.printStackTrace();
                }
                catch (VKInvalidOperationException vKInvalidOperationException) {
                    vKInvalidOperationException.printStackTrace();
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    vKNotRespondingException.printStackTrace();
                }
                break;
            }
            case 338: {
                this.processConfigAEN(mR_EVT_DETAIL);
                break;
            }
            case 28: {
                this.getInformation().getproperties().setcacheFlushInterval((char)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getrate());
                break;
            }
            case 21: {
                this.getInformation().gethwPresent_MR_CTRL_INFO().setflash(0);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                this.getInformation().gethwPresent_MR_CTRL_INFO().setflash(1);
                break;
            }
            case 22: {
                this.getInformation().gethwPresent_MR_CTRL_INFO().setflash(1);
                break;
            }
            case 35: {
                break;
            }
            case 39: {
                this.m_PR_Status.setstate('\u0002');
                break;
            }
            case 314: {
                int n = this.dup_pdObjectArrayList.size();
                for (int i = 0; i < n; ++i) {
                    SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)this.dup_pdObjectArrayList.get(i);
                    MR_PD_INFO mR_PD_INFO = sASPhysicalDevice.getInformation();
                    security_MR_PD_INFO security_MR_PD_INFO2 = mR_PD_INFO.getSecurity_MR_PD_INFO();
                    if (mR_PD_INFO.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisForeign() != 1 || !security_MR_PD_INFO2.getFDECapable() || security_MR_PD_INFO2.getLocked()) continue;
                    security_MR_PD_INFO2.setLocked((short)1);
                    notifyObject = new NotifyObject(0x102000 | mR_EVT_DETAIL.getcode(), mR_EVT_DETAIL);
                    sASPhysicalDevice.notifyMethod(notifyObject);
                }
                this.getInformation().getAdapterStatus_MR_CTRL_INFO().setLockKeyAssigned(0);
                break;
            }
            case 309: {
                this.getInformation().getAdapterStatus_MR_CTRL_INFO().setLockKeyNotBackedUp(0);
                return true;
            }
            case 308: {
                this.getInformation().getAdapterStatus_MR_CTRL_INFO().setLockKeyAssigned(1);
                break;
            }
            case 303: 
            case 65522: 
            case 65523: 
            case 65525: 
            case 65526: 
            case 65532: 
            case 65533: 
            case 65534: 
            case 65535: {
                this.createInformation();
                int n = this.dup_pdObjectArrayList.size();
                for (int i = 0; i < n; ++i) {
                    SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)this.dup_pdObjectArrayList.get(i);
                    notifyObject = new NotifyObject(0x102000 | mR_EVT_DETAIL.getcode(), mR_EVT_DETAIL);
                    sASPhysicalDevice.notifyMethod(notifyObject);
                }
                break;
            }
            case 36: {
                int n = this.dup_pdObjectArrayList.size();
                for (int i = 0; i < n; ++i) {
                    SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)this.dup_pdObjectArrayList.get(i);
                    if (sASPhysicalDevice.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) continue;
                    sASPhysicalDevice.getInformation().getprogInfo().getpause_MR_PD_PROGRESS1().setpatrol(1);
                }
                break;
            }
            case 38: {
                int n = this.dup_pdObjectArrayList.size();
                for (int i = 0; i < n; ++i) {
                    SASPhysicalDevice sASPhysicalDevice = (SASPhysicalDevice)this.dup_pdObjectArrayList.get(i);
                    if (sASPhysicalDevice.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) continue;
                    sASPhysicalDevice.getInformation().getprogInfo().getpause_MR_PD_PROGRESS1().setpatrol(0);
                    sASPhysicalDevice.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().setpatrol(1);
                }
                break;
            }
            default: {
                return false;
            }
        }
        notifyObject = new NotifyObject(0x102000 | mR_EVT_DETAIL.getargType(), mR_EVT_DETAIL);
        if (notifyObject != null) {
            this.notifyMethod(notifyObject);
        }
        return true;
    }

    public ArrayList getSASObjectsArrayList(short s) throws VKObjectNotPresentException {
        if ((s & 0x1000) != 0) {
            return this.getSASPDObjectsArrayList(s);
        }
        if ((s & 0x2000) != 0) {
            return new ArrayList(this.dup_ldObjectArrayList);
        }
        if ((s & 0x4000) != 0) {
            return new ArrayList(this.dup_arObjectArrayList);
        }
        throw new VKObjectNotPresentException(-1);
    }

    private ArrayList getSASPDObjectArrayListWithType(short s) {
        ArrayList<SASPhysicalDevice> arrayList = new ArrayList<SASPhysicalDevice>();
        for (SASPhysicalDevice sASPhysicalDevice : this.dup_pdObjectArrayList) {
            if (sASPhysicalDevice.getInformation().getscsiDevType() != s) continue;
            arrayList.add(sASPhysicalDevice);
        }
        return arrayList;
    }

    public ArrayList getSASPDObjectsArrayList(short s) throws VKObjectNotPresentException {
        ArrayList arrayList = null;
        switch (s) {
            case 4352: {
                arrayList = new ArrayList(this.dup_pdObjectArrayList);
                break;
            }
            case 4096: {
                arrayList = this.getSASPDObjectArrayListWithType((short)0);
                break;
            }
            case 4109: {
                arrayList = this.getSASPDObjectArrayListWithType((short)13);
                break;
            }
            case 4127: {
                arrayList = this.getSASPDObjectArrayListWithType((short)31);
                break;
            }
            case 4101: {
                arrayList = this.getSASPDObjectArrayListWithType((short)5);
                break;
            }
            case 4097: {
                arrayList = this.getSASPDObjectArrayListWithType((short)1);
                break;
            }
            case 4099: {
                arrayList = this.getSASPDObjectArrayListWithType((short)3);
                break;
            }
            default: {
                throw new VKObjectNotPresentException(-1);
            }
        }
        return arrayList;
    }

    private synchronized void cloneArrayList(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2 != null) {
            arrayList2.clear();
        } else {
            arrayList2 = new ArrayList();
        }
        arrayList2.ensureCapacity(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next());
        }
    }

    private boolean isAENIDExists(int n) {
        Iterator iterator = this.uniqueAENIDList.iterator();
        while (iterator.hasNext()) {
            if (n != (Integer)iterator.next()) continue;
            return true;
        }
        return false;
    }

    public byte getAdapterType() {
        return this.adpType;
    }

    public byte[] dcmdPassthruOperation(byte[] byArray) throws VKOperationFailedException {
        if (this.isMRApiIncompatible()) {
            throw new VKOperationFailedException(1);
        }
        int n = 1;
        try {
            NetworkDataPacket networkDataPacket = this.storeLibOperation((byte)6, byArray.length, byArray, new OperationDetails(3, null));
            n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer(), 0);
            System.arraycopy(networkDataPacket.getDataBuffer(), 44, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != 0) {
            System.out.println("retVal=" + n);
            throw new VKOperationFailedException(n);
        }
        return byArray;
    }

    public byte[] dcmdPassthruPFKeyOperation(byte[] byArray) throws VKOperationFailedException {
        if (this.isMRApiIncompatible()) {
            throw new VKOperationFailedException(1);
        }
        int n = 1;
        byte[] byArray2 = new byte[1];
        try {
            NetworkDataPacket networkDataPacket = this.storeLibOperation((byte)6, byArray.length, byArray, new OperationDetails(3, null));
            n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer(), 0);
            byArray2 = new byte[networkDataPacket.getDataBuffer().length];
            System.arraycopy(networkDataPacket.getDataBuffer(), 0, byArray2, 0, networkDataPacket.getDataBuffer().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("inside dcmd:" + n);
        if (n != 0 && n != 89) {
            throw new VKOperationFailedException(n);
        }
        return byArray2;
    }

    public SL_SCSI_PASSTHRU_T scsiPassthruOperation(SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T) throws VKOperationFailedException {
        if (this.isMRApiIncompatible()) {
            throw new VKOperationFailedException(1);
        }
        int n = 1;
        byte[] byArray = sL_SCSI_PASSTHRU_T.getByteArray();
        try {
            NetworkDataPacket networkDataPacket = this.storeLibOperation((byte)6, byArray.length, byArray, sL_SCSI_PASSTHRU_T.gettargetId(), new OperationDetails(0, null));
            n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer(), 0);
            System.arraycopy(networkDataPacket.getDataBuffer(), 44, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != 0) {
            throw new VKOperationFailedException(n);
        }
        sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(byArray, 0);
        if (sL_SCSI_PASSTHRU_T.getscsiStatus() != 0 || sL_SCSI_PASSTHRU_T.getpRequestSenseData()[0] != 0) {
            throw new VKOperationFailedException(4126, sL_SCSI_PASSTHRU_T);
        }
        return sL_SCSI_PASSTHRU_T;
    }

    public SL_STP_PASSTHRU_T stpPassthruOperation(SL_STP_PASSTHRU_T sL_STP_PASSTHRU_T) throws VKOperationFailedException {
        if (this.isMRApiIncompatible()) {
            throw new VKOperationFailedException(1);
        }
        int n = 1;
        byte[] byArray = sL_STP_PASSTHRU_T.getByteArray();
        try {
            NetworkDataPacket networkDataPacket = this.storeLibOperation((byte)6, byArray.length, byArray, sL_STP_PASSTHRU_T.gettargetId(), new OperationDetails(2, null));
            n = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer(), 0);
            System.arraycopy(networkDataPacket.getDataBuffer(), 44, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n != 0) {
            throw new VKOperationFailedException(n);
        }
        System.out.println("data.length " + byArray.length);
        sL_STP_PASSTHRU_T = new SL_STP_PASSTHRU_T(byArray, 0);
        return sL_STP_PASSTHRU_T;
    }

    public MR_BIOS_DATA getBIOSData() throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x10C0100);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[64]);
        int[] nArray = new int[3];
        sL_DCMD_INPUT_T.setmbox(nArray);
        MR_BIOS_DATA mR_BIOS_DATA = null;
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        mR_BIOS_DATA = new MR_BIOS_DATA(byArray, 32);
        return mR_BIOS_DATA;
    }

    public MR_MFC_DEFAULTS getMFCDefaults() throws VKOperationFailedException {
        if (this.mfcDef != null) {
            return this.mfcDef;
        }
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17695233);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[72]);
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        this.mfcDef = new MR_MFC_DEFAULTS(byArray, 32);
        return this.mfcDef;
    }

    private void setMFCDefaults(MR_MFC_DEFAULTS mR_MFC_DEFAULTS) throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17695234);
        sL_DCMD_INPUT_T.setflags('\u0001');
        sL_DCMD_INPUT_T.setpData(mR_MFC_DEFAULTS.getByteArray());
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
    }

    public byte getSMARTMode() throws VKOperationFailedException {
        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = this.getMFCDefaults();
        return mR_MFC_DEFAULTS.getsmartMode();
    }

    public void setSMARTMode(byte by) throws VKOperationFailedException {
        MR_MFC_DEFAULTS mR_MFC_DEFAULTS = this.getMFCDefaults();
        mR_MFC_DEFAULTS.setsmartMode(by);
        this.setMFCDefaults(mR_MFC_DEFAULTS);
    }

    public boolean RegistrationCommandForAEN() {
        boolean bl = false;
        if (this.mrEvtLogInfo != null) {
            this.registerWithEventClass(this.mrEvtLogInfo.getnewestSeqNum() + 1, (short)-1, (byte)-1);
            ((SASServer)this.parent()).registerForAEN(this);
            bl = true;
        }
        return bl;
    }

    private void setLibType(byte by) {
        if (by == 1) {
            this.libType = 0;
        } else if (by == 2) {
            this.libType = 0x1000000;
        } else if (by == 3) {
            this.libType = 0x2000000;
        } else if (by == 4) {
            this.libType = 0x4000000;
        }
    }

    public int getLibType() {
        return this.libType;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof NotifyObject)) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        switch (notifyObject.getNotifyCode()) {
            case 2101251: 
            case 0x401004: {
                this.notifyMethod(object);
                break;
            }
        }
    }

    public boolean isMRApiIncompatible() {
        return this.isMRApiFWDIncompatible() || this.isMRApiBkwdIncompatible();
    }

    public boolean isMRApiFWDIncompatible() {
        if (this.adpType != 1) {
            return false;
        }
        return this.dup_mrControllerInfo.getMrAPIFwdCompatibility() > 0;
    }

    public boolean isMRApiBkwdIncompatible() {
        if (this.adpType != 1) {
            return false;
        }
        return this.dup_mrControllerInfo.getMrAPIBkwdCompatibility() < 0;
    }

    public void setMaxPortCount(int n) {
        this.maxPortCount = n;
    }

    public MR_CTRL_LOCK_KEY_PARAMS createKey(OperationDetails operationDetails, boolean bl, boolean bl2) throws VKOperationFailedException {
        ArrayList arrayList = (ArrayList)operationDetails.getParam();
        String string = arrayList.get(0) != null ? arrayList.get(0).toString() : null;
        String string2 = arrayList.get(1) != null ? arrayList.get(1).toString() : null;
        System.out.println("createKey:" + string2);
        String string3 = null;
        if (arrayList.size() == 3) {
            string3 = arrayList.get(2).toString();
        }
        MR_CTRL_LOCK_KEY_PARAMS mR_CTRL_LOCK_KEY_PARAMS = new MR_CTRL_LOCK_KEY_PARAMS();
        MR_CTRL_LOCK_KEY_PASSPHRASE mR_CTRL_LOCK_KEY_PASSPHRASE = new MR_CTRL_LOCK_KEY_PASSPHRASE();
        if (string2 != null) {
            mR_CTRL_LOCK_KEY_PASSPHRASE.setPassPhrase(string2.getBytes());
        }
        mR_CTRL_LOCK_KEY_PARAMS.setLockKeyPassPhrase(mR_CTRL_LOCK_KEY_PASSPHRASE);
        MR_CTRL_LOCK_KEY_PASSPHRASE mR_CTRL_LOCK_KEY_PASSPHRASE2 = new MR_CTRL_LOCK_KEY_PASSPHRASE();
        mR_CTRL_LOCK_KEY_PASSPHRASE2.setPassPhrase(null);
        mR_CTRL_LOCK_KEY_PARAMS.setBackUpKeyPassPhrase(mR_CTRL_LOCK_KEY_PASSPHRASE2);
        MR_CTRL_LOCK_KEY_PASSPHRASE mR_CTRL_LOCK_KEY_PASSPHRASE3 = new MR_CTRL_LOCK_KEY_PASSPHRASE();
        if (string3 != null && string3.length() > 0) {
            mR_CTRL_LOCK_KEY_PASSPHRASE3.setPassPhrase(string3.getBytes());
        }
        mR_CTRL_LOCK_KEY_PARAMS.setSecretKey(mR_CTRL_LOCK_KEY_PASSPHRASE3);
        if (string != null && string.length() > 0) {
            mR_CTRL_LOCK_KEY_PARAMS.setKeyId(string.getBytes());
        }
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        boolean bl3 = false;
        int n = 0;
        if (bl3) {
            n = 1;
        }
        int n2 = 0;
        if (this.getInformation().gethwPresent_MR_CTRL_INFO().getTPM() != 0) {
            n2 = 2;
        }
        int n3 = 0;
        if (bl) {
            n3 = 4;
        }
        int n4 = 0;
        if (bl2) {
            n4 = 16;
        }
        nArray[0] = (byte)(n | n2 | n3 | n4);
        sL_DCMD_INPUT_T.setmbox(nArray);
        sL_DCMD_INPUT_T.setpData(mR_CTRL_LOCK_KEY_PARAMS.getByteArray());
        try {
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            int n5 = NetworkToJavaConverter.byteArrayToInt(byArray);
            System.out.println("create Key return val:" + n5 + ":" + byArray.length);
            MR_CTRL_LOCK_KEY_PARAMS mR_CTRL_LOCK_KEY_PARAMS2 = new MR_CTRL_LOCK_KEY_PARAMS(byArray, 32);
            return mR_CTRL_LOCK_KEY_PARAMS2;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            System.out.println(vKOperationFailedException.GetErrorCode());
            return null;
        }
    }

    public MR_CTRL_LOCK_KEY_FROM_ESCROW rekeyController(String string, String string2, String string3, String string4, boolean bl) throws VKOperationFailedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string4);
        if (string2 != null) {
            arrayList.add(string2);
        } else {
            arrayList.add(string);
        }
        if (string3 != null && string3.length() > 0) {
            arrayList.add(string3);
        }
        OperationDetails operationDetails = new OperationDetails(0x1150100, arrayList);
        MR_CTRL_LOCK_KEY_PARAMS mR_CTRL_LOCK_KEY_PARAMS = this.createKey(operationDetails, true, bl);
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(18155264);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        MR_CTRL_LOCK_KEY_PASSPHRASE mR_CTRL_LOCK_KEY_PASSPHRASE = new MR_CTRL_LOCK_KEY_PASSPHRASE();
        if (string != null) {
            mR_CTRL_LOCK_KEY_PASSPHRASE.setPassPhrase(string.getBytes());
        }
        MR_CTRL_LOCK_KEY_FROM_ESCROW mR_CTRL_LOCK_KEY_FROM_ESCROW = new MR_CTRL_LOCK_KEY_FROM_ESCROW();
        mR_CTRL_LOCK_KEY_FROM_ESCROW.setLockKeyPassPhrase(mR_CTRL_LOCK_KEY_PASSPHRASE);
        mR_CTRL_LOCK_KEY_FROM_ESCROW.setEscrow(null);
        sL_DCMD_INPUT_T.setpData(mR_CTRL_LOCK_KEY_FROM_ESCROW.getByteArray());
        byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        System.out.println("re Key return val:" + n);
        MR_CTRL_LOCK_KEY_FROM_ESCROW mR_CTRL_LOCK_KEY_FROM_ESCROW2 = new MR_CTRL_LOCK_KEY_FROM_ESCROW(byArray, 32);
        return mR_CTRL_LOCK_KEY_FROM_ESCROW2;
    }

    public String suggestPassPhrase() {
        String string = null;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(18153984);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[32]);
        try {
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            char[] cArray = new char[32];
            int n = 0;
            for (int i = 32; i < 64; ++i) {
                cArray[n++] = (char)byArray[i];
            }
            string = new String(cArray);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
        return string;
    }

    public boolean destroyLockKey() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(18155776);
        sL_DCMD_INPUT_T.setflags('\u0001');
        sL_DCMD_INPUT_T.setpData(new byte[32]);
        try {
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            return NetworkToJavaConverter.byteArrayToInt(byArray) == 0;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return false;
        }
    }

    public boolean getUseFDEOnly() {
        return this.getInformation().getproperties().getOnOffProperties_MR_CTRL_PROP().getUseFdeOnly();
    }

    public String getKeyIDForDevice(boolean bl, int n) {
        String string = null;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(18154241);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        int[] nArray = new int[3];
        if (n == 65535) {
            if (bl) {
                nArray[0] = -1;
                nArray[2] = 1;
            } else {
                nArray[0] = 65535;
            }
        } else {
            nArray[0] = (short)n;
        }
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            char[] cArray = new char[256];
            int n2 = 0;
            for (int i = 32; i < byArray.length && byArray[i] != 0; ++i) {
                cArray[n2++] = (char)byArray[i];
            }
            string = new String(cArray);
            string = string.trim();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Exception in getKeyIDForDevice() method: " + Integer.toHexString(vKOperationFailedException.GetErrorCode()));
        }
        return string;
    }

    public void setKeyIdForDevice(String string) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(18154242);
        sL_DCMD_INPUT_T.setflags('\u0001');
        byte[] byArray = new byte[256];
        byte[] byArray2 = string.getBytes();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i] = byArray2[i];
        }
        sL_DCMD_INPUT_T.setpData(byArray);
        int[] nArray = new int[3];
        nArray[0] = -1;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            byte[] byArray3 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            char[] cArray = new char[256];
            int n = 0;
            for (int i = 32; i < byArray3.length && byArray3[i] != 0; ++i) {
                cArray[n++] = (char)byArray3[i];
            }
            String string2 = new String(cArray);
            string2 = string2.trim();
            System.out.println("strKeyIdAccepted: " + string2);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            // empty catch block
        }
    }

    public void setPowerState(MR_PD_DEVICEID_LIST mR_PD_DEVICEID_LIST) throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x20D0200);
        sL_DCMD_INPUT_T.setflags('\u0003');
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        sL_DCMD_INPUT_T.setpData(mR_PD_DEVICEID_LIST.getByteArray());
        this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
    }

    public void setLinkSpeed(int n, int n2) throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x7050000);
        sL_DCMD_INPUT_T.setflags('\u0001');
        byte[] byArray = new byte[]{(byte)n, (byte)n2};
        int[] nArray = new int[3];
        nArray[0] = byArray[0] + (byArray[1] << 8);
        sL_DCMD_INPUT_T.setmbox(nArray);
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        try {
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("message=" + vKOperationFailedException.getMessage());
        }
    }

    public boolean authenticate(String string) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x1150500);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        MR_CTRL_LOCK_KEY_PASSPHRASE mR_CTRL_LOCK_KEY_PASSPHRASE = new MR_CTRL_LOCK_KEY_PASSPHRASE();
        mR_CTRL_LOCK_KEY_PASSPHRASE.setPassPhrase(string.getBytes());
        MR_CTRL_LOCK_KEY_FROM_ESCROW mR_CTRL_LOCK_KEY_FROM_ESCROW = new MR_CTRL_LOCK_KEY_FROM_ESCROW();
        mR_CTRL_LOCK_KEY_FROM_ESCROW.setLockKeyPassPhrase(mR_CTRL_LOCK_KEY_PASSPHRASE);
        mR_CTRL_LOCK_KEY_FROM_ESCROW.setEscrow(null);
        sL_DCMD_INPUT_T.setpData(mR_CTRL_LOCK_KEY_FROM_ESCROW.getByteArray());
        try {
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("exp=" + vKOperationFailedException.getMessage());
            return false;
        }
        return true;
    }

    public boolean createConcurrentPITs(byte n, MR_LD_REF[] mR_LD_REFArray, byte[] byArray) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x30F0300);
        sL_DCMD_INPUT_T.setflags('\u0003');
        int[] nArray = new int[3];
        nArray[0] = n;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray2 = new byte[n * 72];
        MR_LD_SNAPSHOT_PIT_VIEW_PARAMS[] mR_LD_SNAPSHOT_PIT_VIEW_PARAMSArray = new MR_LD_SNAPSHOT_PIT_VIEW_PARAMS[n];
        for (int i = 0; i < n; ++i) {
            mR_LD_SNAPSHOT_PIT_VIEW_PARAMSArray[i] = new MR_LD_SNAPSHOT_PIT_VIEW_PARAMS();
            if (byArray != null) {
                mR_LD_SNAPSHOT_PIT_VIEW_PARAMSArray[i].setPITName(byArray);
            }
            mR_LD_SNAPSHOT_PIT_VIEW_PARAMSArray[i].setldRef(mR_LD_REFArray[i]);
            System.arraycopy(mR_LD_SNAPSHOT_PIT_VIEW_PARAMSArray[i].getByteArray(), 0, byArray2, i * 72, 72);
        }
        sL_DCMD_INPUT_T.setpData(byArray2);
        try {
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vkofe.GetErrorCode()  " + vKOperationFailedException.GetErrorCode());
            vKOperationFailedException.printStackTrace();
            if (vKOperationFailedException.GetErrorCode() == 92) {
                JOptionPane.showMessageDialog(null, "Concurrent Pit Creation not Succesful");
            }
            return false;
        }
        return true;
    }

    public MR_LD_TARGETID_LIST getUsedLds() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3010100);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        int[] nArray = new int[3];
        nArray[0] = 2;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST(byArray, 32);
        return mR_LD_TARGETID_LIST;
    }

    public MR_LD_TARGETID_LIST getPeerServerLds() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3010100);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[1] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST(byArray, 32);
        return mR_LD_TARGETID_LIST;
    }

    public MR_LD_TARGETID_LIST getAllSharedLds() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3010100);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        int[] nArray = new int[3];
        nArray[0] = 3;
        nArray[1] = 1;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST(byArray, 32);
        return mR_LD_TARGETID_LIST;
    }

    public MR_LD_TARGETID_LIST getAllExclusiveLds() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3010100);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[256]);
        int[] nArray = new int[3];
        nArray[0] = 3;
        nArray[1] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST(byArray, 32);
        return mR_LD_TARGETID_LIST;
    }

    public MR_PF_LIST getPremiumFeatures() throws VKOperationFailedException {
        MR_PF_LIST mR_PF_LIST = null;
        if (this.isWarhawk()) {
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(10, 28, this.getCtrlID(), 52).getByteArray());
            try {
                ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
                byte[] byArray = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n != 0) {
                    System.out.println("CCoH: SL_WH_PFK_FEATURE_GET failed with Status=" + Integer.toHexString(n));
                }
                mR_PF_LIST = new MR_PF_LIST(byArray, 44);
            }
            catch (Exception exception) {
                System.out.println("CCoH: SL_WH_PFK_FEATURE_GET throws exception");
                exception.printStackTrace();
            }
        } else {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(72);
            sL_DCMD_INPUT_T.setopCode(0x1160100);
            sL_DCMD_INPUT_T.setflags('\u0002');
            int[] nArray = new int[3];
            nArray[0] = 255;
            sL_DCMD_INPUT_T.setmbox(nArray);
            byte[] byArray = new byte[56];
            System.out.println("size=" + byArray.length);
            sL_DCMD_INPUT_T.setpData(byArray);
            byte[] byArray2 = null;
            try {
                byArray2 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                System.out.println("getPremiumFeatures retval= " + byArray2.length);
                mR_PF_LIST = new MR_PF_LIST(byArray2, 32);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                System.out.println("getPremiumFeatures- Exception " + vKOperationFailedException.getMessage());
                System.out.println("getPremiumFeatures Exception " + vKOperationFailedException.GetErrorCode());
                throw vKOperationFailedException;
            }
            catch (Exception exception) {
                System.out.println("getPremiumFeatures Exception2 " + exception.getMessage());
            }
        }
        return mR_PF_LIST;
    }

    public byte[] getFeature() throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setdataTransferLength(72);
        sL_DCMD_INPUT_T.setopCode(17728641);
        sL_DCMD_INPUT_T.setflags('\u0002');
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = new byte[80];
        sL_DCMD_INPUT_T.setpData(byArray);
        byte[] byArray2 = null;
        try {
            byArray2 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            System.out.println("getFeature - " + byArray2.length);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("I am inside getfeature kernel Exception " + vKOperationFailedException.getMessage());
            throw vKOperationFailedException;
        }
        return byArray2;
    }

    public int deactivateTrialKeys() throws VKOperationFailedException {
        System.out.println("I am inside deactivate");
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setdataTransferLength(72);
        sL_DCMD_INPUT_T.setopCode(18220032);
        sL_DCMD_INPUT_T.setflags('\u0002');
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = new byte[2];
        sL_DCMD_INPUT_T.setpData(byArray);
        byte[] byArray2 = null;
        try {
            byArray2 = this.dcmdPassthruPFKeyOperation(sL_DCMD_INPUT_T.getByteArray());
            System.out.println("I am inside deactivate  trial" + byArray2.length);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("I am inside deactivate Exception " + vKOperationFailedException.getMessage());
            System.out.println("I am inside deactivate Exception " + vKOperationFailedException.GetErrorCode());
            throw vKOperationFailedException;
        }
        return NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
    }

    public MR_PF_INFO activateKeyInTrial(String string) throws VKOperationFailedException {
        System.out.println("I am inside activate trial");
        MR_PF_INFO mR_PF_INFO = null;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setdataTransferLength(72);
        sL_DCMD_INPUT_T.setopCode(18219520);
        sL_DCMD_INPUT_T.setflags('\u0003');
        int[] nArray = new int[3];
        nArray[0] = 1;
        sL_DCMD_INPUT_T.setmbox(nArray);
        MR_PREMIUM_FEATURE_SET mR_PREMIUM_FEATURE_SET = new MR_PREMIUM_FEATURE_SET();
        mR_PREMIUM_FEATURE_SET.setPFKey(string);
        sL_DCMD_INPUT_T.setpData(mR_PREMIUM_FEATURE_SET.getBytes());
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruPFKeyOperation(sL_DCMD_INPUT_T.getByteArray());
            System.out.println("I am inside activate trial " + NetworkToJavaConverter.byteArrayToInt(byArray, 0));
            System.out.println("I am inside activate trial " + byArray.length);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("I am inside activate trial Exception " + vKOperationFailedException.getMessage());
            System.out.println("I am inside activate trial Exception " + vKOperationFailedException.GetErrorCode());
            throw vKOperationFailedException;
        }
        int n = 44;
        MR_PREMIUM_FEATURE_SET mR_PREMIUM_FEATURE_SET2 = new MR_PREMIUM_FEATURE_SET(byArray, n + 32);
        System.out.println("I am inside activate trial safeid " + new String(mR_PREMIUM_FEATURE_SET2.getPFKey()));
        mR_PF_INFO = mR_PREMIUM_FEATURE_SET2.getFeatures();
        System.out.println("I am inside activate trial " + mR_PF_INFO.toString());
        return mR_PF_INFO;
    }

    public byte[] activateKeyInReal(String string) throws VKOperationFailedException {
        byte[] byArray = null;
        if (this.isWarhawk()) {
            byte[] byArray2 = new byte[72];
            MR_PREMIUM_FEATURE_SET mR_PREMIUM_FEATURE_SET = new MR_PREMIUM_FEATURE_SET(byArray2, 0);
            mR_PREMIUM_FEATURE_SET.setPFKey(string);
            byte[] byArray3 = new byte[8];
            NetworkToJavaConverter.unsignedShortTobyteArray(this.getSeqNum(), byArray3, 0);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(10, 29, this.getCtrlID(), mR_PREMIUM_FEATURE_SET.getBytes().length, mR_PREMIUM_FEATURE_SET.getBytes()).getByteArray());
            try {
                ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                vKInvalidOperationException.printStackTrace();
                NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            }
            catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
                vivaldiFrameworkProtocolErrorException.printStackTrace();
            }
            byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n != 0) {
                System.out.println("CCoH: SL_WH_ACTIVATE_LICENSE failed with Status=" + Integer.toHexString(n));
                throw new VKOperationFailedException(n);
            }
        } else {
            System.out.println("I am inside activate real");
            Object var3_4 = null;
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(72);
            sL_DCMD_INPUT_T.setopCode(18219520);
            sL_DCMD_INPUT_T.setflags('\u0003');
            int[] nArray = new int[3];
            nArray[0] = 0;
            sL_DCMD_INPUT_T.setmbox(nArray);
            MR_PREMIUM_FEATURE_SET mR_PREMIUM_FEATURE_SET = new MR_PREMIUM_FEATURE_SET();
            mR_PREMIUM_FEATURE_SET.setPFKey(string);
            sL_DCMD_INPUT_T.setpData(mR_PREMIUM_FEATURE_SET.getBytes());
            try {
                byArray = this.dcmdPassthruPFKeyOperation(sL_DCMD_INPUT_T.getByteArray());
                System.out.println("I am inside activate trial " + NetworkToJavaConverter.byteArrayToInt(byArray));
                System.out.println("I am inside activate trial " + byArray.length);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                System.out.println("I am inside activate trial Exception " + vKOperationFailedException.getMessage());
                System.out.println("I am inside activate trial Exception " + vKOperationFailedException.GetErrorCode());
                throw vKOperationFailedException;
            }
        }
        return byArray;
    }

    public MR_PF_INFO convertByteToMR_PF_INFO(byte[] byArray) {
        int n = 44;
        MR_PF_INFO mR_PF_INFO = null;
        MR_PREMIUM_FEATURE_SET mR_PREMIUM_FEATURE_SET = new MR_PREMIUM_FEATURE_SET(byArray, n + 32);
        System.out.println("I am inside activate trial safeid " + new String(mR_PREMIUM_FEATURE_SET.getPFKey()));
        mR_PF_INFO = mR_PREMIUM_FEATURE_SET.getFeatures();
        System.out.println("I am inside activate trial " + mR_PF_INFO.toString());
        return mR_PF_INFO;
    }

    public int securePremiumFeatures() throws VKOperationFailedException {
        int n;
        System.out.println("I am inside secure");
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setdataTransferLength(72);
        sL_DCMD_INPUT_T.setopCode(18220288);
        sL_DCMD_INPUT_T.setflags('\u0002');
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = new byte[2];
        sL_DCMD_INPUT_T.setpData(byArray);
        byte[] byArray2 = null;
        try {
            byArray2 = this.dcmdPassthruPFKeyOperation(sL_DCMD_INPUT_T.getByteArray());
            n = NetworkToJavaConverter.byteArrayToInt(byArray2);
            System.out.println("returnValue: " + n);
            System.out.println("I am inside deactivate  trial" + byArray2.length);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("I am inside secure Exception " + vKOperationFailedException.getMessage());
            System.out.println("I am inside secure Exception " + vKOperationFailedException.GetErrorCode());
            throw vKOperationFailedException;
        }
        return n;
    }

    public String getSafeId() throws VKOperationFailedException {
        byte[] byArray = new byte[40];
        if (this.isWarhawk()) {
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(10, 27, this.getCtrlID(), 40).getByteArray());
            try {
                ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                if (n != 0) {
                    System.out.println("CCoH: SL_WH_PFK_SAFEID_GET failed with Status=" + Integer.toHexString(n));
                }
                System.arraycopy(byArray2, 44, byArray, 0, byArray.length);
                System.out.println("SASAdapter.getSafeId() returns " + new String(byArray));
            }
            catch (Exception exception) {
                System.out.println("CCoH: SL_WH_PFK_SAFEID_GET throws exception");
                exception.printStackTrace();
            }
        } else {
            System.out.println("I am inside getSafeId");
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(72);
            sL_DCMD_INPUT_T.setopCode(18219776);
            sL_DCMD_INPUT_T.setflags('\u0002');
            int[] nArray = new int[3];
            nArray[0] = 0;
            sL_DCMD_INPUT_T.setmbox(nArray);
            sL_DCMD_INPUT_T.setpData(byArray);
            byte[] byArray3 = null;
            try {
                byArray3 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                for (int i = 0; i < 40; ++i) {
                    byArray[i] = byArray3[32 + i];
                }
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                System.out.println("I am inside getSafeId Exception " + vKOperationFailedException.GetErrorCode());
                System.out.println("I am inside getSafeId Exception " + vKOperationFailedException.getMessage());
                throw vKOperationFailedException;
            }
        }
        return new String(byArray);
    }

    public MR_TIME_STAMP getCtrlTime() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x1080101);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[8]);
        int[] nArray = new int[3];
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        MR_TIME_STAMP mR_TIME_STAMP = new MR_TIME_STAMP(byArray, 32);
        return mR_TIME_STAMP;
    }

    public MR_LD_SNAPSHOT_ALL_INFO getSnapshotInfo() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51316736);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(1000);
        sL_DCMD_INPUT_T.setpData(new byte[1000]);
        int[] nArray = new int[3];
        nArray[0] = -1;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        int n = NetworkToJavaConverter.byteArrayToInt(byArray, 32);
        sL_DCMD_INPUT_T.setdataTransferLength(n);
        sL_DCMD_INPUT_T.setpData(new byte[n]);
        byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        MR_LD_SNAPSHOT_ALL_INFO mR_LD_SNAPSHOT_ALL_INFO = new MR_LD_SNAPSHOT_ALL_INFO(byArray, 32);
        return mR_LD_SNAPSHOT_ALL_INFO;
    }

    public MR_SAS_PHY_CONNECTIONS getPhyConnections() {
        MR_SAS_PHY_CONNECTIONS mR_SAS_PHY_CONNECTIONS = null;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x7010000);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[980]);
        try {
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            mR_SAS_PHY_CONNECTIONS = new MR_SAS_PHY_CONNECTIONS(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("SASAdapter.getPhyConnections() :: Operation failed");
        }
        return mR_SAS_PHY_CONNECTIONS;
    }

    public byte[] getRaidKeyMfgInfo() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        Object object;
        MR_MFC_MFG mR_MFC_MFG = null;
        try {
            object = new SL_DCMD_INPUT_T(new byte[32], 0);
            int[] nArray = new int[3];
            nArray[0] = 1;
            ((SL_DCMD_INPUT_T)object).setmbox(nArray);
            ((SL_DCMD_INPUT_T)object).setdataTransferLength(32);
            ((SL_DCMD_INPUT_T)object).setopCode(17695489);
            ((SL_DCMD_INPUT_T)object).setflags('\u0002');
            ((SL_DCMD_INPUT_T)object).setpData(new byte[32]);
            byte[] byArray = this.dcmdPassthruOperation(((SL_DCMD_INPUT_T)object).getByteArray());
            mR_MFC_MFG = new MR_MFC_MFG(byArray, 32);
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            System.out.println("getRaidKeyMfgInfo returnValue: " + n);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            mR_MFC_MFG = null;
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            mR_MFC_MFG = null;
        }
        if (mR_MFC_MFG != null) {
            return mR_MFC_MFG.getsn();
        }
        object = new byte[1];
        return object;
    }

    public byte[] getCtrlMfgInfo() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        Object object;
        MR_MFC_MFG mR_MFC_MFG = null;
        try {
            object = new SL_DCMD_INPUT_T(new byte[32], 0);
            ((SL_DCMD_INPUT_T)object).setdataTransferLength(32);
            ((SL_DCMD_INPUT_T)object).setopCode(17695489);
            ((SL_DCMD_INPUT_T)object).setflags('\u0002');
            ((SL_DCMD_INPUT_T)object).setpData(new byte[32]);
            byte[] byArray = this.dcmdPassthruOperation(((SL_DCMD_INPUT_T)object).getByteArray());
            mR_MFC_MFG = new MR_MFC_MFG(byArray, 32);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            mR_MFC_MFG = null;
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            mR_MFC_MFG = null;
        }
        if (mR_MFC_MFG != null) {
            return mR_MFC_MFG.getsn();
        }
        object = new byte[1];
        return object;
    }

    public MR_TTY_DATA getTtyData(int n, int n2) {
        MR_TTY_DATA mR_TTY_DATA = null;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17367552);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[n]);
        int[] nArray = new int[3];
        nArray[0] = n2;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            byte[] byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 36);
            if (n3 < n) {
                n = n3;
            }
            mR_TTY_DATA = new MR_TTY_DATA(byArray, 32, n);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("SASAdapter.getPhyConnections() :: Operation failed");
        }
        return mR_TTY_DATA;
    }

    public MR_EVT_LIST getEventList(int n, MR_EVT_CLASS_LOCALE mR_EVT_CLASS_LOCALE, int n2) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17040128);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[n2]);
        int[] nArray = new int[3];
        nArray[0] = n;
        nArray[1] = NetworkToJavaConverter.byteArrayToInt(mR_EVT_CLASS_LOCALE.getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vkofe.GetErrorCode " + vKOperationFailedException.GetErrorCode());
            return null;
        }
        MR_EVT_LIST mR_EVT_LIST = new MR_EVT_LIST(byArray, 32);
        return mR_EVT_LIST;
    }

    public boolean suspendPR(boolean bl) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17237504);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = bl ? 1 : 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public MR_EVT_LOG_INFO getAenSequenceInfo() {
        MR_EVT_LOG_INFO mR_EVT_LOG_INFO = null;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.getCtrlID(), 20).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n != 0) {
                System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n));
                return null;
            }
            mR_EVT_LOG_INFO = new MR_EVT_LOG_INFO(byArray, 44);
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            mR_EVT_LOG_INFO = null;
            return null;
        }
        return mR_EVT_LOG_INFO;
    }

    public ArrayList getLdObjectArrayList() {
        return this.ldObjectArrayList;
    }

    private void displayAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        System.out.println("***************** Event Details *****************");
        System.out.println("Argtype: " + mR_EVT_DETAIL.getargType());
        System.out.println("Event code: " + Integer.toHexString(mR_EVT_DETAIL.getcode()));
        System.out.println("Timestamp: " + mR_EVT_DETAIL.gettimeStamp());
        System.out.println("Locale: " + Integer.toHexString(mR_EVT_DETAIL.getcl().getlocale()));
        System.out.println("Description: " + new String(mR_EVT_DETAIL.getdescription()).trim());
        System.out.println("***************** END Event Details **************");
    }

    public boolean isWarhawk() {
        short s;
        boolean bl = false;
        if (this.mrControllerInfo != null && this.getAdapterType() == 3 && (s = this.mrControllerInfo.getpci_MR_CTRL_INFO().getdevId()) == 126) {
            bl = true;
        }
        return bl;
    }

    public SL_WH_DD_INFO getWhDDInfo() {
        return this.dup_whDDInfo;
    }

    public boolean storeLatestSequenceNumber() {
        MR_EVT_LOG_INFO mR_EVT_LOG_INFO = null;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.getCtrlID(), 20).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n != 0) {
                System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n));
                return true;
            }
            mR_EVT_LOG_INFO = new MR_EVT_LOG_INFO(byArray, 44);
            if (this.m_OldSequenceNum == 0) {
                this.m_OldSequenceNum = mR_EVT_LOG_INFO.getnewestSeqNum();
                return true;
            }
            if (this.m_OldSequenceNum != mR_EVT_LOG_INFO.getnewestSeqNum()) {
                this.m_OldSequenceNum = mR_EVT_LOG_INFO.getnewestSeqNum();
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            mR_EVT_LOG_INFO = null;
            return true;
        }
        return false;
    }

    public int getLatestSequenceNumber() {
        int n = -1;
        MR_EVT_LOG_INFO mR_EVT_LOG_INFO = null;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.getCtrlID(), 20).getByteArray());
        try {
            ((SASServer)this.parent()).processCommand(this.getReceiverWWN(), networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n2 != 0) {
                System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n2));
            }
            mR_EVT_LOG_INFO = new MR_EVT_LOG_INFO(byArray, 44);
            n = mR_EVT_LOG_INFO.getnewestSeqNum();
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            mR_EVT_LOG_INFO = null;
            return n;
        }
        return n;
    }

    public MR_CONFIG_DATA getMrConfigData() {
        return this.mrConfigData;
    }

    public MR_CONFIG_ALLOWED_OPS getMrConfigAlloweOps() {
        Object object;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x4070000);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(36);
        sL_DCMD_INPUT_T.setpData(new byte[36]);
        byte[] byArray = null;
        try {
            byArray = object = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        object = new MR_CONFIG_ALLOWED_OPS(byArray, 32);
        return object;
    }

    public MR_BBU_MODES_GET getBbuModes() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[72], 0);
        sL_DCMD_INPUT_T.setopCode(84345088);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(72);
        sL_DCMD_INPUT_T.setpData(new byte[72]);
        byte[] byArray = null;
        int n = 0;
        MR_BBU_MODES_GET mR_BBU_MODES_GET = null;
        try {
            byte[] byArray2 = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            n = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
            byArray = byArray2;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        mR_BBU_MODES_GET = new MR_BBU_MODES_GET(byArray, 32);
        return mR_BBU_MODES_GET;
    }

    public void clearConfiguration() throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x4030000);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = 1;
        sL_DCMD_INPUT_T.setmbox(nArray);
        this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
    }

    public byte[] getAssociatedLdIds() {
        Object object;
        if (this.ldObjectArrayList.size() == 0) {
            return null;
        }
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51380736);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(150);
        sL_DCMD_INPUT_T.setpData(new byte[150]);
        int[] nArray = new int[3];
        nArray[0] = ((SASLogicalDrive)this.ldObjectArrayList.get(0)).getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            object = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            byArray = object;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("SASAdapter.getAssociatedLdIds() failed with retval = " + vKOperationFailedException.GetErrorCode());
            return null;
        }
        object = new MR_LD_TARGETID_LIST(byArray, 32);
        byArray2 = ((MR_LD_TARGETID_LIST)object).getCount() > 0 ? ((MR_LD_TARGETID_LIST)object).getTargetId() : new byte[]{};
        return byArray2;
    }

    public void setAssociatedLdIds(byte[] byArray) throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3100100);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = 255;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray2 = this.getAssociatedLdIds();
        if (byArray2 != null) {
            int n = byArray2.length;
            int n2 = byArray.length;
            int n3 = n + n2;
            byte[] byArray3 = new byte[n3];
            int n4 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                byArray3[n4] = byArray2[n4];
            }
            for (int i = 0; i < n2; ++i) {
                byArray3[n4++] = byArray[i];
            }
            MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST();
            mR_LD_TARGETID_LIST.setCount(n3);
            mR_LD_TARGETID_LIST.setSize(11 + n3);
            mR_LD_TARGETID_LIST.setTargetId(byArray3);
            sL_DCMD_INPUT_T.setpData(mR_LD_TARGETID_LIST.getByteArray());
            this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
    }

    public void setOnlyProvidedLdIds(byte[] byArray) throws VKOperationFailedException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3100100);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = 255;
        sL_DCMD_INPUT_T.setmbox(nArray);
        int n = byArray.length;
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST();
        mR_LD_TARGETID_LIST.setCount(n);
        mR_LD_TARGETID_LIST.setSize(11 + n);
        mR_LD_TARGETID_LIST.setTargetId(byArray);
        sL_DCMD_INPUT_T.setpData(mR_LD_TARGETID_LIST.getByteArray());
        this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
    }

    public void unsetAssociatedLdIds(byte[] byArray) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3100100);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = 255;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray2 = this.getAssociatedLdIds();
        if (byArray2 != null) {
            int n = byArray2.length;
            int n2 = byArray.length;
            int n3 = n - n2;
            byte[] byArray3 = new byte[n3];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                int n5 = 0;
                for (n5 = 0; n5 < n2 && byArray2[i] != byArray[n5]; ++n5) {
                }
                if (n5 != n2) continue;
                byArray3[n4++] = byArray2[i];
            }
            MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST();
            mR_LD_TARGETID_LIST.setCount(n3);
            mR_LD_TARGETID_LIST.setSize(11 + n3);
            mR_LD_TARGETID_LIST.setTargetId(byArray3);
            sL_DCMD_INPUT_T.setpData(mR_LD_TARGETID_LIST.getByteArray());
            try {
                this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                System.out.println("SASLogicalDrive.unsetAssociatedLdIds() failed with retval = " + vKOperationFailedException.GetErrorCode());
            }
        }
    }

    public MR_LD_ALLOWED_OPS_LIST getLDAllowedOpsList() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51052800);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(296);
        sL_DCMD_INPUT_T.setpData(new byte[296]);
        byte[] byArray = null;
        try {
            byArray = this.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("SASAdapter.getLDAllowedOpsList() failed with retval = " + vKOperationFailedException.GetErrorCode());
            return null;
        }
        MR_LD_ALLOWED_OPS_LIST mR_LD_ALLOWED_OPS_LIST = new MR_LD_ALLOWED_OPS_LIST(byArray, 32);
        return mR_LD_ALLOWED_OPS_LIST;
    }

    public boolean isCSA() {
        return this.getInformation().gethwPresent_MR_CTRL_INFO().getSSMSupport() != 0;
    }
}

