/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASLogical;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_LD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.SL_ARRAY_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.DDFRAIDLevelInfo;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;

public class SASArray
extends Observable
implements ISASObject,
AENHandlerInterface {
    private short ID;
    private SASAdapter sasAdapter;
    private MR_ARRAY mrArray;
    private SL_ARRAY_INFO_T m_SL_Array_Info_T = null;

    public SASArray(short s, SASAdapter sASAdapter, MR_ARRAY mR_ARRAY) throws VKNotRespondingException, VKOperationFailedException {
        this.ID = s;
        this.sasAdapter = sASAdapter;
        this.mrArray = mR_ARRAY;
        this.refresh();
    }

    public void setInformation(MR_ARRAY mR_ARRAY) {
        this.mrArray = mR_ARRAY;
    }

    @Override
    public short getID() {
        return this.ID;
    }

    @Override
    public short getSeqNum() {
        return this.getInformation().getarrayRef();
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return this.sasAdapter;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        return false;
    }

    @Override
    public long getSize() {
        return this.getInformation().getsize();
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        return false;
    }

    @Override
    public void notifyMethod(Object object) {
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        return this.parent().processCommand(networkDataPacket);
    }

    public long getSmallestPDSize() {
        return this.getInformation().getsize();
    }

    public byte getPhysicalDriveCount() {
        return (byte)this.getInformation().getnumDrives();
    }

    public short getArrayRef() {
        return this.getInformation().getarrayRef();
    }

    public SASPhysicalDrive[] getPhysicalDriveList() {
        int n;
        ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>();
        pd_MR_ARRAY[] pd_MR_ARRAYArray = this.getInformation().getpd_MR_ARRAY1();
        for (n = 0; n < this.getPhysicalDriveCount(); ++n) {
            SASPhysicalDrive sASPhysicalDrive;
            short s = pd_MR_ARRAYArray[n].getref().getdeviceId();
            if (s == -1 || (sASPhysicalDrive = this.getPhysicalDriveIDinFullList(s)) == null) continue;
            arrayList.add(sASPhysicalDrive);
        }
        n = arrayList.size();
        SASPhysicalDrive[] sASPhysicalDriveArray = new SASPhysicalDrive[n];
        for (int i = 0; i < n; ++i) {
            sASPhysicalDriveArray[i] = (SASPhysicalDrive)arrayList.get(i);
        }
        return sASPhysicalDriveArray;
    }

    public boolean checkForMissingPhysicalDrive() {
        pd_MR_ARRAY[] pd_MR_ARRAYArray = this.getInformation().getpd_MR_ARRAY1();
        for (int i = 0; i < this.getPhysicalDriveCount(); ++i) {
            if (pd_MR_ARRAYArray[i].getref().getdeviceId() != -1) continue;
            return true;
        }
        return false;
    }

    public SASPhysicalDrive[] getPhysicalDriveListforMissingDrives() {
        int n;
        ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>();
        pd_MR_ARRAY[] pd_MR_ARRAYArray = this.getInformation().getpd_MR_ARRAY1();
        for (n = 0; n < this.getPhysicalDriveCount(); ++n) {
            short s = pd_MR_ARRAYArray[n].getref().getdeviceId();
            SASPhysicalDrive sASPhysicalDrive = this.getPhysicalDriveIDinFullList(s);
            arrayList.add(sASPhysicalDrive);
        }
        n = arrayList.size();
        SASPhysicalDrive[] sASPhysicalDriveArray = new SASPhysicalDrive[n];
        for (int i = 0; i < n; ++i) {
            sASPhysicalDriveArray[i] = (SASPhysicalDrive)arrayList.get(i);
        }
        return sASPhysicalDriveArray;
    }

    public ArrayList getPhysicalDriveArrayList() {
        ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>(this.getPhysicalDriveCount());
        pd_MR_ARRAY[] pd_MR_ARRAYArray = this.getInformation().getpd_MR_ARRAY1();
        for (int i = 0; i < this.getPhysicalDriveCount(); ++i) {
            SASPhysicalDrive sASPhysicalDrive = this.getPhysicalDriveIDinFullList(pd_MR_ARRAYArray[i].getref().getdeviceId());
            arrayList.add(sASPhysicalDrive);
        }
        return arrayList;
    }

    public ArrayList getLogicalDriveList() throws VKObjectNotPresentException {
        ArrayList<SASLogicalDrive> arrayList = new ArrayList<SASLogicalDrive>();
        ArrayList arrayList2 = ((SASAdapter)this.parent()).getSASObjectsArrayList((short)8192);
        block0: for (SASLogicalDrive sASLogicalDrive : arrayList2) {
            MR_SPAN[] mR_SPANArray = sASLogicalDrive.getInformation().getldConfig().getspan();
            for (int i = 0; i < sASLogicalDrive.getInformation().getldConfig().getparams().getspanDepth(); ++i) {
                if (mR_SPANArray[i].getarrayRef() != this.getArrayRef()) continue;
                arrayList.add(sASLogicalDrive);
                continue block0;
            }
        }
        return arrayList;
    }

    private SASPhysicalDrive getPhysicalDriveIDinFullList(short s) {
        try {
            ArrayList arrayList = ((SASAdapter)this.parent()).getSASObjectsArrayList((short)4096);
            for (SASPhysicalDrive sASPhysicalDrive : arrayList) {
                if (s != sASPhysicalDrive.getDeviceId()) continue;
                return sASPhysicalDrive;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public MR_ARRAY getInformation() {
        return this.mrArray;
    }

    private NetworkDataPacket storeLibOperation(byte[] byArray, int n, byte[] byArray2, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray3 = new byte[8];
        NetworkToJavaConverter.shortTobyteArray(this.getSeqNum(), byArray3, 0);
        NetworkToJavaConverter.shortTobyteArray(this.getArrayRef(), byArray3, 2);
        try {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(4, (byte)operationDetails.getOpcode(), ((SASAdapter)this.parent()).getCtrlID(), byArray3, byArray, n, byArray2).getByteArray());
            this.processCommand(networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return networkDataPacket;
    }

    public SL_ARRAY_INFO_T getSLArrayInformation() throws VKOperationFailedException {
        if (this.m_SL_Array_Info_T == null) {
            this.updateSLArrayInformation();
        }
        return this.m_SL_Array_Info_T;
    }

    public void updateSLArrayInformation() throws VKOperationFailedException {
        OperationDetails operationDetails = new OperationDetails(8, null);
        try {
            NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 2368, null, operationDetails);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n != 1) {
                this.m_SL_Array_Info_T = new SL_ARRAY_INFO_T(byArray, 44);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            throw new VKOperationFailedException(4096);
        }
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        byte[] byArray = new byte[8];
        int n = 1;
        switch (operationDetails.getOpcode()) {
            case 0x30C0000: {
                try {
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.getLogicalDriveList().get(0);
                    MR_LD_REF mR_LD_REF = sASLogicalDrive.getInformation().getldConfig().getproperties().getldRef();
                    SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                    sL_DCMD_INPUT_T.setopCode(0x30C0000);
                    sL_DCMD_INPUT_T.setflags('\u0001');
                    sL_DCMD_INPUT_T.setpData(mR_LD_REF.getByteArray());
                    int[] nArray = new int[]{NetworkToJavaConverter.byteArrayToInt(mR_LD_REF.getByteArray())};
                    sL_DCMD_INPUT_T.setmbox(nArray);
                    byte[] byArray2 = this.sasAdapter.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                    n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                    break;
                }
                catch (VKObjectNotPresentException vKObjectNotPresentException) {
                    throw new VKOperationFailedException(3);
                }
            }
            case 0x4060000: {
                MR_ARRAY mR_ARRAY = (MR_ARRAY)operationDetails.getParam();
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(0x4060000);
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(mR_ARRAY.getByteArray());
                byte[] byArray3 = this.sasAdapter.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = NetworkToJavaConverter.byteArrayToInt(byArray3);
                break;
            }
            case 51642624: {
                n = this.disablePI();
                break;
            }
            case 0x3110300: {
                n = this.joinMirror(operationDetails.getArgument());
            }
        }
        if (n != 0) {
            System.out.println("SASLogicalDrive.fireOperation()->retval = " + n);
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    private int disablePI() {
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(0);
            sL_DCMD_INPUT_T.setopCode(51642624);
            sL_DCMD_INPUT_T.setflags('\u0000');
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.getLogicalDriveList().get(0);
            MR_LD_REF mR_LD_REF = sASLogicalDrive.getInformation().getldConfig().getproperties().getldRef();
            int[] nArray = new int[3];
            nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_LD_REF.getByteArray());
            sL_DCMD_INPUT_T.setmbox(nArray);
            byte[] byArray = this.sasAdapter.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            return NetworkToJavaConverter.byteArrayToInt(byArray);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
        }
        return 1;
    }

    public ArrayList getDedicatedPhysicalDriveList() {
        ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>();
        try {
            ArrayList arrayList2 = ((SASAdapter)this.parent()).getSASObjectsArrayList((short)4096);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                try {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)iterator.next();
                    MR_SPARE mR_SPARE = sASPhysicalDrive.getDedicatedHotspareInfo();
                    short[] sArray = mR_SPARE.getarrayRef();
                    for (int i = 0; i < mR_SPARE.getarrayCount(); ++i) {
                        if (this.getArrayRef() != sArray[i]) continue;
                        arrayList.add(sASPhysicalDrive);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public DDFRAIDLevelInfo getRAIDLevelInfo() {
        ArrayList arrayList = null;
        try {
            arrayList = this.getLogicalDriveList();
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            return null;
        }
        if (arrayList.size() > 0) {
            return new DDFRAIDLevelInfo(((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getPRL(), ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getSRL(), ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getRLQ());
        }
        return null;
    }

    @Override
    public boolean handleAEN(Object object) {
        this.setChanged();
        this.notifyObservers(object);
        return true;
    }

    private boolean isRebuildInProgressOnThisArray() {
        SASPhysicalDrive[] sASPhysicalDriveArray = this.getPhysicalDriveList();
        for (int i = 0; i < sASPhysicalDriveArray.length; ++i) {
            if (sASPhysicalDriveArray[i].getState() != 20) continue;
            return true;
        }
        return false;
    }

    public boolean isRebuildInProgress() {
        try {
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.getLogicalDriveList().get(0);
            if (sASLogicalDrive.getArrayCount() == 1) {
                return this.isRebuildInProgressOnThisArray();
            }
            ArrayList arrayList = sASLogicalDrive.getSASArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((SASArray)arrayList.get(i)).isRebuildInProgressOnThisArray()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    private int joinMirror(int n) {
        int n2 = 1;
        try {
            SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
            sL_DCMD_INPUT_T.setdataTransferLength(0);
            sL_DCMD_INPUT_T.setopCode(0x3110300);
            sL_DCMD_INPUT_T.setflags('\u0000');
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.getLogicalDriveList().get(0);
            MR_LD_REF mR_LD_REF = sASLogicalDrive.getInformation().getldConfig().getproperties().getldRef();
            int[] nArray = new int[3];
            nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_LD_REF.getByteArray());
            nArray[1] = n;
            sL_DCMD_INPUT_T.setmbox(nArray);
            byte[] byArray = this.sasAdapter.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            n2 = NetworkToJavaConverter.byteArrayToInt(byArray);
            System.out.println("SASArray.joinMirror() returns " + n2);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
        }
        return n2;
    }

    public long getMinimumBlockSize() {
        long l;
        int n = 0;
        if (this.mrArray != null) {
            try {
                ArrayList arrayList = this.getLogicalDriveList();
                if (arrayList != null) {
                    byte by = ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getPRL();
                    ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getnumDrives();
                    switch (by) {
                        case 0: {
                            n = ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getnumDrives();
                            break;
                        }
                        case 1: 
                        case 17: {
                            n = ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getnumDrives() / 2;
                            break;
                        }
                        case 5: {
                            n = ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getnumDrives() - '\u0001';
                            break;
                        }
                        case 6: {
                            n = ((SASLogicalDrive)arrayList.get(0)).getInformation().getldConfig().getparams().getnumDrives() - 2;
                            break;
                        }
                        default: {
                            n = 0;
                        }
                    }
                }
            }
            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                vKObjectNotPresentException.printStackTrace();
            }
        }
        return (l = (long)(n * 8192)) > 2048L ? l : 2048L;
    }
}

