/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASLogical;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_LD_GUID;
import SASKernel.LibraryAPI.StoreLib.MR_LD_GUID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_LD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROGRESS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_LD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_ALL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_ENABLE_PARAMS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_PIT_VIEW_PARAMS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_REPOSITORY_SPACE;
import SASKernel.LibraryAPI.StoreLib.MR_LD_TARGETID_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_LD_VIEW_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_VIEW_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_RECON;
import SASKernel.LibraryAPI.StoreLib.MR_SNAPSHOT_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.DDFRAIDLevelInfo;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASServer;
import Services.KernelConstants;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import Services.UsageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SASLogicalDrive
extends Observable
implements ISASObject,
AENHandlerInterface {
    public static final byte LD_STATE_OPTIMAL = 0;
    public static final byte LD_STATE_DEGRADED = 1;
    public static final byte LD_STATE_DELETED = 2;
    public static final byte LD_STATE_MISSING = 3;
    public static final byte LD_STATE_FAILED = 4;
    public static final byte LD_STRIPE_SIZE_512 = 0;
    public static final byte LD_STRIPE_SIZE_1K = 1;
    public static final byte LD_STRIPE_SIZE_2K = 2;
    public static final byte LD_STRIPE_SIZE_4K = 3;
    public static final byte LD_STRIPE_SIZE_8K = 4;
    public static final byte LD_STRIPE_SIZE_16K = 5;
    public static final byte LD_STRIPE_SIZE_32K = 6;
    public static final byte LD_STRIPE_SIZE_64K = 7;
    public static final byte LD_STRIPE_SIZE_128K = 8;
    public static final byte LD_STRIPE_SIZE_512K = 9;
    public static final byte LD_STRIPE_SIZE_1M = 16;
    public static final byte LD_STRIPE_SIZE_2M = 17;
    public static final byte LD_STRIPE_SIZE_4M = 18;
    public static final int MAX_STRIPE_SIZE_IN_BLOCKS = 8192;
    public static final byte LD_PRL_TYPE_RAID_0 = 0;
    public static final byte LD_PRL_TYPE_RAID_1 = 1;
    public static final byte LD_PRL_TYPE_RAID_3 = 3;
    public static final byte LD_PRL_TYPE_RAID_4 = 4;
    public static final byte LD_PRL_TYPE_RAID_5 = 5;
    public static final byte LD_PRL_TYPE_RAID_1E = 17;
    public static final byte LD_PRL_TYPE_RAID_1E_EVEN = 16;
    public static final byte LD_PRL_TYPE_RAID_JBOD = 15;
    public static final byte LD_PRL_TYPE_RAID_CONCAT = 31;
    public static final byte LD_PRL_TYPE_RAID_5E = 21;
    public static final byte LD_PRL_TYPE_RAID_5EE = 37;
    public static final byte LD_PRL_TYPE_RAID_6 = 6;
    public static final byte LD_SSD_PRL_TYPE_RAID_EC = 7;
    public static final byte LD_RLQ_0 = 0;
    public static final byte LD_RLQ_1 = 1;
    public static final byte LD_RLQ_3 = 3;
    public static final byte LD_SRL_TYPE_STRIPPED = 0;
    public static final byte LD_SRL_TYPE_MIRRORED = 1;
    public static final byte LD_SRL_TYPE_CONCAT = 2;
    public static final byte LD_SRL_TYPE_SPANNED = 3;
    public static final byte LD_GUI_SPAN = 64;
    public static final byte LD_GUI_SPAN_MASK = -65;
    public static final byte LD_GUI_RL_00 = 64;
    public static final byte LD_GUI_RL_10 = 65;
    public static final byte LD_GUI_RL_50 = 69;
    public static final byte LD_GUI_RL_60 = 70;
    public static final byte LD_GUI_RL_1E0 = 81;
    public static final int LD_NAME_MAX_SIZE = 15;
    public static final byte LD_SSCD_TYPE_R1_EC = 2;
    private short ID;
    private byte[] guid;
    MR_LD_GUID[] guiIdList;
    private SASAdapter sasAdapter;
    private MR_LD_INFO m_ldInfo = null;
    private SASLogicalDriveOperationsAllowed m_ldAllowedOperations = null;
    NotifyObject m_notifyObj = null;
    private MR_LD_SNAPSHOT_INFO m_SnapshotInfo = null;
    private byte state = 0;

    public SASLogicalDrive(short s, SASAdapter sASAdapter) throws VKNotRespondingException, VKOperationFailedException {
        this.ID = s;
        this.sasAdapter = sASAdapter;
        this.refresh();
    }

    @Override
    public short getID() {
        return this.ID;
    }

    @Override
    public short getSeqNum() {
        return this.getInformation().getldConfig().getproperties().getldRef().getseqNum();
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return this.sasAdapter;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        this.createInformation();
        if (this.m_ldInfo.getldConfig().getparams().getSnapshotEnabled() == 1) {
            this.createSnapshotInformation();
        }
        return false;
    }

    private void createInformation() throws VKNotRespondingException, VKOperationFailedException {
        byte[] byArray = new byte[8];
        byArray[2] = (byte)this.getID();
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(3, 0, ((SASAdapter)this.parent()).getCtrlID(), byArray, 388).getByteArray());
        try {
            this.processCommand(networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
            if (n != 0) {
                throw new VKOperationFailedException(n);
            }
            if (this.m_ldInfo == null) {
                this.m_ldInfo = new MR_LD_INFO(byArray2, 44);
            } else {
                this.m_ldInfo.update(byArray2, 44);
            }
        }
        catch (IOException iOException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw new VKOperationFailedException(4096);
        }
    }

    @Override
    public long getSize() {
        return this.getInformation().getsize();
    }

    @Override
    public short getState() {
        return (short)this.getInformation().getldConfig().getparams().getstate();
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        return false;
    }

    @Override
    public void notifyMethod(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public String getName() {
        return new String(this.getInformation().getldConfig().getproperties().getname()).trim();
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        return this.parent().processCommand(networkDataPacket);
    }

    public MR_LD_INFO getInformation() {
        return this.m_ldInfo;
    }

    public byte getArrayCount() {
        return (byte)this.getInformation().getldConfig().getparams().getspanDepth();
    }

    public SASArray[] getArrayList() {
        SASArray[] sASArrayArray = new SASArray[this.getInformation().getldConfig().getparams().getspanDepth()];
        int n = 0;
        try {
            ArrayList arrayList = this.getSASArrayList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                sASArrayArray[n++] = (SASArray)iterator.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sASArrayArray;
    }

    public ArrayList getSASArrayList() {
        ArrayList<SASArray> arrayList = new ArrayList<SASArray>(this.getInformation().getldConfig().getparams().getspanDepth());
        try {
            ArrayList arrayList2 = ((SASAdapter)this.parent()).getSASObjectsArrayList((short)16384);
            MR_SPAN[] mR_SPANArray = this.m_ldInfo.getldConfig().getspan();
            block2: for (SASArray sASArray : arrayList2) {
                for (int i = 0; i < this.getArrayCount(); ++i) {
                    if (mR_SPANArray[i].getarrayRef() != sASArray.getArrayRef()) continue;
                    arrayList.add(sASArray);
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public ArrayList getConstituentPDList() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.getSASArrayList();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList3 = ((SASArray)iterator.next()).getPhysicalDriveArrayList();
            arrayList.addAll(arrayList3);
        }
        return arrayList;
    }

    private NetworkDataPacket storeLibOperation(byte[] byArray, int n, byte[] byArray2, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray3 = new byte[8];
        NetworkToJavaConverter.shortTobyteArray(this.getSeqNum(), byArray3, 0);
        byArray3[2] = (byte)this.getInformation().getldConfig().getproperties().getldRef().gettargetId();
        try {
            SASAdapter sASAdapter = (SASAdapter)this.parent();
            networkDataPacket = sASAdapter.isWarhawk() && operationDetails.getOpcode() == 1 ? new NetworkDataPacket(new SimpleCommandPacket(10, (byte)operationDetails.getOpcode(), ((SASAdapter)this.parent()).getCtrlID(), 0).getByteArray()) : new NetworkDataPacket(new SimpleCommandPacket(3, (byte)operationDetails.getOpcode(), ((SASAdapter)this.parent()).getCtrlID(), byArray3, byArray, n, byArray2).getByteArray());
            this.processCommand(networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return networkDataPacket;
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        int n = 1;
        switch (operationDetails.getOpcode()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 0, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 6: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 0, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 9: {
                byte[] byArray = new byte[8];
                byArray[0] = (Boolean)operationDetails.getParam() != false ? (byte)1 : 0;
                NetworkDataPacket networkDataPacket = this.storeLibOperation(byArray, 0, null, operationDetails);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                break;
            }
            case 2: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 32, ((MR_LD_PROPERTIES)operationDetails.getParam()).getByteArray(), operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 14: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 4, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                byte[] byArray3 = new byte[4];
                System.arraycopy(byArray, 44, byArray3, 0, 4);
                operationDetails.setParameter(byArray3);
                break;
            }
            case 8: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 36, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_LD_PROGRESS mR_LD_PROGRESS = new MR_LD_PROGRESS(byArray, 44);
                this.getInformation().setprogInfo(mR_LD_PROGRESS);
                operationDetails.setParameter(mR_LD_PROGRESS);
                break;
            }
            case 12: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 136, ((MR_RECON)operationDetails.getParam()).getByteArray(), operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 13: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 136, null, operationDetails);
                byte[] byArray = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                if (n == 1) break;
                MR_RECON mR_RECON = new MR_RECON(byArray, 44);
                operationDetails.setParameter(mR_RECON);
                break;
            }
            case 0x30E0000: {
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setdataTransferLength(0);
                sL_DCMD_INPUT_T.setopCode(0x30E0000);
                sL_DCMD_INPUT_T.setflags('\u0000');
                int[] nArray = new int[3];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray = this.sasAdapter.dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = NetworkToJavaConverter.byteArrayToInt(byArray);
                break;
            }
            case 0x3130100: {
                MR_LD_REF mR_LD_REF = this.getInformation().getldConfig().getproperties().getldRef();
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(mR_LD_REF.getByteArray());
                int[] nArray = new int[3];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_LD_REF.getByteArray());
                byte[] byArray = new byte[4];
                byArray[0] = (byte)operationDetails.getArgument();
                if (KernelConstants.getBitValue(byArray[0], 7) == 0) {
                    byArray[1] = 100;
                    byArray[2] = 85;
                    byArray[3] = (Byte)operationDetails.getParam();
                }
                nArray[1] = NetworkToJavaConverter.byteArrayToInt(byArray);
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray4 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = 0;
                break;
            }
            case 51577344: {
                MR_LD_REF mR_LD_REF = this.getInformation().getldConfig().getproperties().getldRef();
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(mR_LD_REF.getByteArray());
                int[] nArray = new int[3];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_LD_REF.getByteArray());
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = 0;
                break;
            }
        }
        if (n != 0) {
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    public Vector getGraphicalLayoutInformation() {
        Vector<UsageInfo> vector = new Vector<UsageInfo>(1);
        MR_SPAN[] mR_SPANArray = this.getInformation().getldConfig().getspan();
        ArrayList arrayList = this.getSASArrayList();
        for (int i = 0; i < this.getArrayCount(); ++i) {
            vector.addElement(new UsageInfo(mR_SPANArray[i].getstartBlock(), mR_SPANArray[i].getstartBlock() + mR_SPANArray[i].getnumBlocks(), arrayList.get(i)));
        }
        return vector;
    }

    public void fireGuiId() {
        Object object;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(50397696);
        sL_DCMD_INPUT_T.setflags('\u0002');
        int n = this.sasAdapter.getLdObjectArrayList().size() * 200;
        System.out.println("size" + n);
        sL_DCMD_INPUT_T.setdataTransferLength(n);
        sL_DCMD_INPUT_T.setpData(new byte[n]);
        byte[] byArray = null;
        Object var4_4 = null;
        try {
            object = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            byArray = object;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Error while reading mapped VDS " + byArray[0]);
            System.out.println("Error while reading mapped VDS " + byArray[1]);
            System.out.println("Error while reading mapped VDS " + byArray[2]);
            System.out.println("Error while reading mapped VDS " + byArray[3]);
            vKOperationFailedException.printStackTrace();
        }
        object = new MR_LD_GUID_LIST(byArray, 32);
        this.guiIdList = new MR_LD_GUID[(int)((MR_LD_GUID_LIST)object).getcount()];
        if (((MR_LD_GUID_LIST)object).getcount() > 0L) {
            this.guiIdList = ((MR_LD_GUID_LIST)object).getguidList();
            this.setGuiIdList(this.guiIdList);
        }
    }

    public MR_LD_GUID[] getGuiIdList() {
        return this.guiIdList;
    }

    public void setGuiIdList(MR_LD_GUID[] mR_LD_GUIDArray) {
        this.guiIdList = mR_LD_GUIDArray;
    }

    public byte[] getGuiId() {
        this.fireGuiId();
        MR_LD_GUID[] mR_LD_GUIDArray = this.getGuiIdList();
        for (int i = 0; i < mR_LD_GUIDArray.length; ++i) {
            if (mR_LD_GUIDArray[i].getref().gettargetId() != this.getInformation().getldConfig().getproperties().getldRef().gettargetId()) continue;
            this.guid = mR_LD_GUIDArray[i].getguid();
        }
        return this.guid;
    }

    public SASLogicalDriveOperationsAllowed getAllAllowedOperations() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        this.updateAllAllowedOperations();
        return this.m_ldAllowedOperations;
    }

    public SASLogicalDriveOperationsAllowed getLDAllowedOps() {
        try {
            this.getAllAllowedOperations();
            return this.m_ldAllowedOperations;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void updateAllAllowedOperations() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(14, "", "", null);
        this.fireOperation(operationDetails);
        int n = NetworkToJavaConverter.byteArrayToInt((byte[])operationDetails.getParam());
        if (this.m_ldAllowedOperations == null) {
            this.m_ldAllowedOperations = new SASLogicalDriveOperationsAllowed(this, n);
        } else {
            this.m_ldAllowedOperations.update(this, n);
        }
    }

    public byte getReadPolicy() {
        byte by = (byte)this.getInformation().getldConfig().getproperties().getcurrentCachePolicy();
        byte by2 = 0;
        by2 = 0 != (by & 4) && 0 != (by & 8) ? (byte)12 : (0 != (by & 4) ? (byte)4 : 0);
        return by2;
    }

    public byte getWritePolicy() {
        byte by = (byte)this.getInformation().getldConfig().getproperties().getcurrentCachePolicy();
        byte by2 = 0;
        by2 = 0 != (by & 1) ? (byte)1 : 0;
        return by2;
    }

    public byte getDefaultWritePolicy() {
        byte by = (byte)this.getInformation().getldConfig().getproperties().getdefaultCachePolicy();
        int n = 0;
        if (by == 0) {
            n = 0;
        } else if (0 != (by & 1) && 0 != (by & 2)) {
            n = 2;
        } else if (0 != (by & 1) && 0 != (by & 0x10)) {
            n = 17;
        } else if (0 != (by & 1)) {
            n = 1;
        }
        return (byte)n;
    }

    public byte getDefaultCachePolicy() {
        return (byte)this.getInformation().getldConfig().getproperties().getdefaultCachePolicy();
    }

    public byte getIOCachePolicy() {
        byte by = (byte)this.getInformation().getldConfig().getproperties().getcurrentCachePolicy();
        int n = 0;
        n = 0 != (by & 0x20) && 0 != (by & 0x40) ? 96 : 0;
        return (byte)n;
    }

    public int getSupportLDBBM() {
        return this.sasAdapter.getInformation().getldOperations_MR_CTRL_INFO().getsupportLDBBM();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean handleAEN(Object var1_1) {
        var2_2 = (MR_EVT_DETAIL)var1_1;
        var3_3 = null;
        if (var2_2.getargType() == '\u0007') {
            var3_3 = var2_2.getargs_MR_EVT_DETAIL1().getldProg_args_MR_EVT_DETAIL1().getprog();
        }
        switch (var2_2.getcode()) {
            case 346: {
                try {
                    this.createInformation();
                    if (this.m_ldInfo.getldConfig().getparams().getSnapshotEnabled() != 1) ** GOTO lbl22
                    this.createSnapshotInformation();
                    var4_4 = this.sasAdapter.getLdObjectArrayList();
                    for (var5_10 = 0; var5_10 < var4_4.size(); ++var5_10) {
                        if (((SASLogicalDrive)var4_4.get(var5_10)).getID() != this.m_SnapshotInfo.getParams().getTargetIDforSnapshot()) continue;
                        ((SASLogicalDrive)var4_4.get(var5_10)).handleAEN(var2_2);
                        break;
                    }
                }
                catch (Exception var4_5) {
                    var4_5.printStackTrace();
                    return false;
                }
lbl22:
                // 3 sources

                this.updateAllowedOperations();
                break;
            }
            case 347: {
                try {
                    if (this.m_ldInfo.getldConfig().getparams().getSnapshotEnabled() == 1) {
                        var4_4 = this.sasAdapter.getLdObjectArrayList();
                        for (var5_11 = 0; var5_11 < var4_4.size(); ++var5_11) {
                            if (((SASLogicalDrive)var4_4.get(var5_11)).getID() != this.m_SnapshotInfo.getParams().getTargetIDforSnapshot()) continue;
                            ((SASLogicalDrive)var4_4.get(var5_11)).handleAEN(var2_2);
                            break;
                        }
                    }
                    this.createInformation();
                }
                catch (Exception var4_6) {
                    var4_6.printStackTrace();
                    return false;
                }
                this.updateAllowedOperations();
                break;
            }
            case 387: {
                this.m_ldInfo.getldConfig().setproperties(var2_2.getargs_MR_EVT_DETAIL1().getldProp_args_MR_EVT_DETAIL1().getnewProp());
                try {
                    this.createInformation();
                }
                catch (Exception var4_7) {
                    var4_7.printStackTrace();
                    return false;
                }
                this.updateAllowedOperations();
                break;
            }
            case 335: {
                this.m_ldInfo.getldConfig().getparams().setBadBlocksExist('\u0000');
                this.updateAllowedOperations();
                break;
            }
            case 66: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setcc(1);
                this.updateAllowedOperations();
                break;
            }
            case 65: {
                this.m_ldInfo.getprogInfo().setcc(var3_3);
                break;
            }
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                try {
                    this.createInformation();
                }
                catch (Exception var4_8) {
                    var4_8.printStackTrace();
                    return false;
                }
                this.updateAllowedOperations();
                break;
            }
            case 407: {
                this.m_ldInfo.getprogInfo().getpause_MR_LD_PROGRESS1().setcc(1);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setcc(0);
                this.updateAllowedOperations();
                break;
            }
            case 408: {
                this.m_ldInfo.getprogInfo().getpause_MR_LD_PROGRESS1().setcc(0);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setcc(1);
                this.updateAllowedOperations();
                break;
            }
            case 409: {
                this.m_ldInfo.getprogInfo().getpause_MR_LD_PROGRESS1().setbgi(1);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setbgi(0);
                this.updateAllowedOperations();
                break;
            }
            case 410: {
                this.m_ldInfo.getprogInfo().getpause_MR_LD_PROGRESS1().setbgi(0);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setbgi(1);
                this.updateAllowedOperations();
                break;
            }
            case 411: {
                this.m_ldInfo.getprogInfo().getpause_MR_LD_PROGRESS1().setrecon(1);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setrecon(1);
                this.updateAllowedOperations();
                break;
            }
            case 53: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setbgi(1);
                this.updateAllowedOperations();
                break;
            }
            case 52: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setbgi(1);
                this.m_ldInfo.getprogInfo().setbgi(var3_3);
                break;
            }
            case 48: 
            case 49: {
                this.m_ldInfo.getprogInfo().setbgi(null);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setbgi(0);
                this.m_ldInfo.getldConfig().getparams().setISConsistent('\u0001');
                this.updateAllowedOperations();
                break;
            }
            case 46: 
            case 51: {
                this.m_ldInfo.getprogInfo().setbgi(null);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setbgi(0);
                this.updateAllowedOperations();
                break;
            }
            case 70: 
            case 71: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setfgi(1);
                this.updateAllowedOperations();
                break;
            }
            case 69: {
                this.m_ldInfo.getprogInfo().setfgi(var3_3);
                break;
            }
            case 67: 
            case 68: {
                this.m_ldInfo.getprogInfo().setfgi(null);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setfgi(0);
                this.updateAllowedOperations();
                break;
            }
            case 72: {
                this.m_ldInfo.getprogInfo().setfgi(null);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setfgi(0);
                this.m_ldInfo.getldConfig().getparams().setISConsistent('\u0001');
                this.updateAllowedOperations();
                break;
            }
            case 435: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setdisassociate(1);
                this.updateAllowedOperations();
                break;
            }
            case 438: {
                this.m_ldInfo.getprogInfo().setdisassociate(var3_3);
                break;
            }
            case 436: 
            case 437: 
            case 439: {
                this.m_ldInfo.getprogInfo().setdisassociate(null);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setdisassociate(0);
                this.updateAllowedOperations();
                break;
            }
            case 80: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setrecon(1);
                this.updateAllowedOperations();
                break;
            }
            case 77: {
                this.m_ldInfo.getprogInfo().setrecon(var3_3);
                break;
            }
            case 250: {
                try {
                    this.createInformation();
                }
                catch (Exception var4_9) {
                    var4_9.printStackTrace();
                    return false;
                }
                this.updateAllowedOperations();
                var4_4 = (SASArray)this.getSASArrayList().get(0);
                try {
                    var4_4.updateSLArrayInformation();
                    var4_4.handleAEN(this.m_notifyObj);
                }
                catch (Exception var5_12) {
                    var5_12.printStackTrace();
                }
                break;
            }
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 376: 
            case 380: 
            case 381: {
                this.m_notifyObj = new NotifyObject(0x102000 | var2_2.getcode(), var2_2);
                try {
                    this.createSnapshotInformation();
                }
                catch (Exception var5_13) {
                    var5_13.printStackTrace();
                    return false;
                }
                this.updateAllowedOperations();
                break;
            }
            case 79: 
            case 316: 
            case 317: 
            case 434: 
            case 442: {
                try {
                    this.createInformation();
                }
                catch (Exception var5_14) {
                    var5_14.printStackTrace();
                    return false;
                }
                this.updateAllowedOperations();
                break;
            }
            case 428: {
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setErase(1);
                var5_15 = this.getConstituentPDList();
                for (var6_17 = 0; var6_17 < var5_15.size(); ++var6_17) {
                    var7_18 = (SASPhysicalDrive)var5_15.get(var6_17);
                    if (var7_18.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 0) {
                        var7_18.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().setpatrol(0);
                    }
                    var7_18.setPRStoppedBySecureErase(true);
                }
                this.updateAllowedOperations();
                break;
            }
            case 427: {
                this.m_ldInfo.getprogInfo().seterase(var3_3);
                break;
            }
            case 425: 
            case 426: 
            case 429: {
                this.m_ldInfo.getprogInfo().seterase(null);
                this.m_ldInfo.getprogInfo().getactive_MR_LD_PROGRESS1().setErase(0);
                this.updateAllowedOperations();
                break;
            }
        }
        if (this.m_notifyObj == null) {
            this.m_notifyObj = new NotifyObject(0x102000 | var2_2.getcode(), var2_2);
        } else {
            this.m_notifyObj.update(0x102000 | var2_2.getcode(), var2_2);
        }
        this.notifyMethod(this.m_notifyObj);
        if (var2_2.getcode() == 316 || var2_2.getcode() == 317 || var2_2.getcode() == 387) {
            var4_4 = this.getSASArrayList();
            for (var5_16 = 0; var5_16 < var4_4.size(); ++var5_16) {
                ((SASArray)var4_4.get(var5_16)).handleAEN(this.m_notifyObj);
            }
        }
        return true;
    }

    public void createSnapshotInformation() {
        MR_LD_SNAPSHOT_ALL_INFO mR_LD_SNAPSHOT_ALL_INFO = this.getSnapshotInfo((byte)this.getID());
        this.m_SnapshotInfo = mR_LD_SNAPSHOT_ALL_INFO.getSnapshotInfo()[0];
    }

    public MR_LD_SNAPSHOT_INFO getSnapshotInformation() {
        return this.m_SnapshotInfo;
    }

    public DDFRAIDLevelInfo getRAIDLevelInfo() {
        return new DDFRAIDLevelInfo(this.getInformation().getldConfig().getparams().getPRL(), this.getInformation().getldConfig().getparams().getSRL(), this.getInformation().getldConfig().getparams().getRLQ());
    }

    public SL_PARTITION_INFO_T getPartitionInfo() throws VKOperationFailedException {
        OperationDetails operationDetails = new OperationDetails(12, null);
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = (byte)this.ID;
        operationDetails.setParameter(byArray);
        try {
            ((SASAdapter)this.parent()).fireOperation(operationDetails);
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            throw new VKOperationFailedException(4096);
        }
        SL_DRIVE_DISTRIBUTION_T sL_DRIVE_DISTRIBUTION_T = (SL_DRIVE_DISTRIBUTION_T)operationDetails.getParam();
        int n = -1;
        for (int i = 0; i < sL_DRIVE_DISTRIBUTION_T.getmappedDevicesCount(); ++i) {
            if (sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getdriveId() != this.getID()) continue;
            n = sL_DRIVE_DISTRIBUTION_T.getmappedDriveInfo()[i].getosDriveNumber();
            break;
        }
        if (n == -1) {
            throw new VKOperationFailedException(4125);
        }
        SL_PARTITION_INFO_T sL_PARTITION_INFO_T = null;
        sL_PARTITION_INFO_T = ((SASServer)this.parent().parent()).getPartitionInfo(((SASAdapter)this.parent()).getReceiverWWN(), n, this.getID(), ((SASAdapter)this.parent()).getCtrlID());
        return sL_PARTITION_INFO_T;
    }

    public boolean enableSnapshot(long l, byte by, byte by2, boolean bl) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        MR_LD_SNAPSHOT_ENABLE_PARAMS mR_LD_SNAPSHOT_ENABLE_PARAMS = new MR_LD_SNAPSHOT_ENABLE_PARAMS();
        sL_DCMD_INPUT_T.setopCode(51314944);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        mR_LD_SNAPSHOT_ENABLE_PARAMS.setSize(l);
        mR_LD_SNAPSHOT_ENABLE_PARAMS.settargetIDforSnapshot(by2);
        if (bl) {
            mR_LD_SNAPSHOT_ENABLE_PARAMS.setEnableAutoSnapShot((byte)1);
        }
        sL_DCMD_INPUT_T.setpData(mR_LD_SNAPSHOT_ENABLE_PARAMS.getByteArray());
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vkofe.GetErrorCode()  " + vKOperationFailedException.GetErrorCode());
            if (vKOperationFailedException.GetErrorCode() == 91) {
                JOptionPane.showMessageDialog(null, "No space on the snapshot repository VD");
                if (vKOperationFailedException.GetErrorCode() == 3) {
                    JOptionPane.showMessageDialog(null, "Some input parameters are invalid");
                }
                vKOperationFailedException.printStackTrace();
            } else if (vKOperationFailedException.GetErrorCode() == 24) {
                JOptionPane.showMessageDialog(null, "Unable to Enable MegaRAID Recovery on VD_" + by + " because, Initialization is in progress on VD_" + by2, "Unable to Enable MegaRAID Recovery", 0);
            }
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean disableSnapshot() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51315200);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public MR_LD_SNAPSHOT_ALL_INFO getSnapshotInfo(byte by) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51316736);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(1000);
        sL_DCMD_INPUT_T.setpData(new byte[1000]);
        int[] nArray = new int[3];
        nArray[0] = by;
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        int n = NetworkToJavaConverter.byteArrayToInt(byArray, 32);
        sL_DCMD_INPUT_T.setdataTransferLength(n);
        sL_DCMD_INPUT_T.setpData(new byte[n]);
        byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        MR_LD_SNAPSHOT_ALL_INFO mR_LD_SNAPSHOT_ALL_INFO = new MR_LD_SNAPSHOT_ALL_INFO(byArray, 32);
        return mR_LD_SNAPSHOT_ALL_INFO;
    }

    public boolean createSnapshot(byte by, byte[] byArray) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x30F0300);
        sL_DCMD_INPUT_T.setflags('\u0003');
        int[] nArray = new int[3];
        nArray[0] = by;
        sL_DCMD_INPUT_T.setmbox(nArray);
        MR_LD_SNAPSHOT_PIT_VIEW_PARAMS mR_LD_SNAPSHOT_PIT_VIEW_PARAMS = new MR_LD_SNAPSHOT_PIT_VIEW_PARAMS();
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setPITName(byArray);
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setldRef(this.getInformation().getldConfig().getproperties().getldRef());
        sL_DCMD_INPUT_T.setpData(mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.getByteArray());
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteSnapshot(MR_TIME_STAMP mR_TIME_STAMP) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51315712);
        int[] nArray = new int[3];
        if (mR_TIME_STAMP == null) {
            nArray[1] = 1;
        }
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        if (mR_TIME_STAMP != null) {
            sL_DCMD_INPUT_T.setflags('\u0001');
            sL_DCMD_INPUT_T.setpData(mR_TIME_STAMP.getByteArray());
            sL_DCMD_INPUT_T.setdataTransferLength(8);
        }
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vkofe.GetErrorCode()  " + vKOperationFailedException.GetErrorCode());
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createView(MR_TIME_STAMP mR_TIME_STAMP, byte[] byArray, byte[] byArray2, byte by, long l) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51315968);
        sL_DCMD_INPUT_T.setflags('\u0001');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        MR_LD_SNAPSHOT_PIT_VIEW_PARAMS mR_LD_SNAPSHOT_PIT_VIEW_PARAMS = new MR_LD_SNAPSHOT_PIT_VIEW_PARAMS();
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setViewName(byArray2);
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setPITCreationTime(mR_TIME_STAMP);
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setldRef(this.getInformation().getldConfig().getproperties().getldRef());
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setaccessPolicy(by);
        mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.setViewSize(l);
        sL_DCMD_INPUT_T.setpData(mR_LD_SNAPSHOT_PIT_VIEW_PARAMS.getByteArray());
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vkofe.GetErrorCode()  " + vKOperationFailedException.GetErrorCode());
            vKOperationFailedException.printStackTrace();
            if (vKOperationFailedException.GetErrorCode() == 91) {
                JOptionPane.showMessageDialog(null, "No space on the snapshot repository VD");
            }
            if (vKOperationFailedException.GetErrorCode() == 3) {
                JOptionPane.showMessageDialog(null, "Some input parameters are invalid");
            }
            return false;
        }
        return true;
    }

    public boolean deleteView(MR_TIME_STAMP mR_TIME_STAMP) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51316224);
        sL_DCMD_INPUT_T.setflags('\u0003');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        sL_DCMD_INPUT_T.setpData(mR_TIME_STAMP.getByteArray());
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean pitRollBack(MR_TIME_STAMP mR_TIME_STAMP) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51316480);
        sL_DCMD_INPUT_T.setflags('\u0003');
        int[] nArray = new int[3];
        nArray[0] = this.getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        sL_DCMD_INPUT_T.setpData(mR_TIME_STAMP.getByteArray());
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public MR_LD_VIEW_INFO getSnapshotViewInfo() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51316992);
        sL_DCMD_INPUT_T.setflags('\u0002');
        int[] nArray = new int[3];
        nArray[0] = (byte)this.getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        MR_LD_VIEW_INFO mR_LD_VIEW_INFO = new MR_LD_VIEW_INFO(byArray, 32);
        return mR_LD_VIEW_INFO;
    }

    public MR_LD_VIEW_LIST getSnapshotViewList() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51317248);
        sL_DCMD_INPUT_T.setflags('\u0002');
        int[] nArray = new int[3];
        nArray[0] = (byte)this.getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        MR_LD_VIEW_LIST mR_LD_VIEW_LIST = new MR_LD_VIEW_LIST(byArray, 32);
        return mR_LD_VIEW_LIST;
    }

    public MR_LD_TARGETID_LIST getSnapshotRepositoryLds() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51317504);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(200);
        sL_DCMD_INPUT_T.setpData(new byte[200]);
        int[] nArray = new int[3];
        nArray[0] = (byte)this.getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        MR_LD_TARGETID_LIST mR_LD_TARGETID_LIST = new MR_LD_TARGETID_LIST(byArray, 32);
        sL_DCMD_INPUT_T.setdataTransferLength(mR_LD_TARGETID_LIST.getSize());
        sL_DCMD_INPUT_T.setpData(new byte[mR_LD_TARGETID_LIST.getSize()]);
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        return mR_LD_TARGETID_LIST;
    }

    public MR_LD_SNAPSHOT_REPOSITORY_SPACE getSnapshotRepositorySpace() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51317760);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setdataTransferLength(40);
        sL_DCMD_INPUT_T.setpData(new byte[40]);
        int[] nArray = new int[3];
        nArray[0] = (byte)this.getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        int n = NetworkToJavaConverter.byteArrayToInt(byArray, 32);
        sL_DCMD_INPUT_T.setdataTransferLength(n);
        sL_DCMD_INPUT_T.setpData(new byte[n]);
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return null;
        }
        MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = new MR_LD_SNAPSHOT_REPOSITORY_SPACE(byArray, 32);
        return mR_LD_SNAPSHOT_REPOSITORY_SPACE;
    }

    public boolean SnapshotGarbageCollection(byte by) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51318016);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        nArray[1] = 255;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public void deleteLD(int n) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x3090000);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        nArray[1] = n;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("SASLogicalDrive.deleteLD() failed with retval = " + vKOperationFailedException.GetErrorCode());
        }
    }

    private void updateAllowedOperations() {
        try {
            this.updateAllAllowedOperations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MR_SNAPSHOT_SCHEDULE_PROPERTIES getScheduleProperties() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51318272);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[8]);
        int[] nArray = new int[3];
        nArray[0] = (byte)this.getID();
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        try {
            byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES(byArray, 32);
        return mR_SNAPSHOT_SCHEDULE_PROPERTIES;
    }

    public boolean setScheduleProperties(MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x30F0F00);
        sL_DCMD_INPUT_T.setflags('\u0001');
        if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() != 0) {
            mR_SNAPSHOT_SCHEDULE_PROPERTIES.setState((byte)1);
        } else {
            mR_SNAPSHOT_SCHEDULE_PROPERTIES.setState((byte)0);
        }
        sL_DCMD_INPUT_T.setpData(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getByteArray());
        int[] nArray = new int[3];
        System.out.println("this.getInformation().getldConfig().getproperties().getldRef() " + (short)this.getInformation().getldConfig().getproperties().getldRef().gettargetId());
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("vkofe.GetErrorCode()  " + vKOperationFailedException.GetErrorCode());
            if (vKOperationFailedException.GetErrorCode() == 3) {
                JOptionPane.showMessageDialog(null, "Some input parameters are invalid -- Set Schedule Prop failed");
            }
            return false;
        }
        return true;
    }

    public void clearBlockedAccess() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(50593808);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("SASLogicalDrive.clearBlockedAccess() failed with retval = " + vKOperationFailedException.GetErrorCode());
        }
    }

    public void resetMrLdProgress() {
        MR_LD_PROGRESS mR_LD_PROGRESS = this.m_ldInfo.getprogInfo();
        mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().setcc(0);
        mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().setbgi(0);
        mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().setfgi(0);
        mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().setrecon(0);
        mR_LD_PROGRESS.getactive_MR_LD_PROGRESS1().setdisassociate(0);
        mR_LD_PROGRESS.setcc(null);
        mR_LD_PROGRESS.setbgi(null);
        mR_LD_PROGRESS.setfgi(null);
        mR_LD_PROGRESS.setrecon(null);
        mR_LD_PROGRESS.setdisassociate(null);
    }

    public boolean suspendcc(boolean bl) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51511808);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        nArray[1] = bl ? 1 : 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean suspendRecon(boolean bl) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(51511552);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(this.getInformation().getldConfig().getproperties().getldRef().getByteArray());
        nArray[1] = bl ? 1 : 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }
}

