/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASPhysical;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_LD_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PD_ADDRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_PROGRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_PD_SMART_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PROGRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PR_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_SPAN;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.REGISTER_HOST_TO_DEVICE_FIS_LBA48;
import SASKernel.LibraryAPI.StoreLib.SATA_MODEL_NO;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SL_SCSI_PASSTHRU_T;
import SASKernel.LibraryAPI.StoreLib.SL_STP_PASSTHRU_T;
import SASKernel.LibraryAPI.StoreLib.SL_WH_SSD_INFO;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASArray;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDriveOperationsAllowed;
import SASKernel.SASServer;
import SCSIPassthru.SCSIOperations;
import Services.KernelConstants;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import Services.UsageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class SASPhysicalDrive
extends SASPhysicalDevice
implements ISASObject,
AENHandlerInterface {
    public static final byte PD_STATE_UNCONFIGURED_GOOD = 0;
    public static final byte PD_STATE_UNCONFIGURED_BAD = 1;
    public static final byte PD_STATE_HOT_SPARE = 2;
    public static final byte PD_STATE_OFFLINE = 16;
    public static final byte PD_STATE_FAILED = 17;
    public static final byte PD_STATE_REBUILD = 20;
    public static final byte PD_STATE_ONLINE = 24;
    public static final byte PD_STATE_COPYBACK = 32;
    public static final byte PD_STATE_SYSTEM = 64;
    public static final int PD_STATE_SHIELD_UNCONFIGURED = 128;
    public static final int PD_STATE_SHIELD_HOT_SPARE = 130;
    public static final int PD_STATE_SHIELD_CONFIGURED = 144;
    public static final int PD_STATE_SHIELD_COPYBACK = 192;
    public static final byte PD_PROGRESS_NONE = 0;
    public static final byte PD_PROGRESS_REBUILD = 1;
    public static final byte PD_PROGRESS_PATROLREAD = 2;
    public static final byte PD_PROGRESS_CLEAR = 3;
    public static final byte PD_TYPE_SCSI = 1;
    public static final byte PD_TYPE_SAS = 2;
    public static final byte PD_TYPE_SATA = 3;
    public static final byte PD_TYPE_FC = 4;
    public static final byte MR_PD_MEDIA_TYPE_ROTATIONAL = 0;
    public static final byte MR_PD_MEDIA_TYPE_SSD = 1;
    public static final byte MR_PD_MEDIA_TYPE_SSM_FLASH = 2;
    public static final byte MR_DCMD_CFG_MAKE_SPARE_GLOBAL = 20;
    public static final byte MR_DCMD_CFG_MAKE_SPARE_DEDICATED = 21;
    public static final byte PD_UNCONFIGURED_BAD_TO_UNCONFIGURED_GOOD = 0;
    public static final byte PD_UNCONFIGURED_GOOD_TO_SYSTEM = 1;
    public static final byte PD_SYSTEM_TO_UNCONFIGURED_GOOD = 2;
    NotifyObject m_notifyObj = null;
    SASPhysicalDriveOperationsAllowed m_pdAllowedOperations = null;
    private boolean m_isPRStoppedBySecureErase = false;
    private MR_PR_STATUS pStatus = null;
    private boolean m_supportSMARTInfo = false;
    private MR_PD_SMART_INFO m_objSMARTInfo;

    public SASPhysicalDrive(short s, short s2, ISASObject iSASObject, MR_PD_ADDRESS mR_PD_ADDRESS) throws VKNotRespondingException, VKOperationFailedException {
        super(s, s2, (SASAdapter)iSASObject, mR_PD_ADDRESS);
        this.refresh();
    }

    @Override
    public short getID() {
        return super.getID();
    }

    @Override
    public short getSeqNum() {
        return super.getInformation().getref().getseqNum();
    }

    @Override
    public ISASObject next() {
        return super.next();
    }

    @Override
    public ISASObject previous() {
        return super.previous();
    }

    @Override
    public ISASObject parent() {
        return super.parent();
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        super.refresh();
        SASAdapter sASAdapter = (SASAdapter)this.parent();
        byte[] byArray = new byte[8];
        NetworkToJavaConverter.shortTobyteArray(this.getDeviceId(), byArray, 0);
        try {
            this.updateAllAllowedOperations();
            this.m_supportSMARTInfo = this.m_pdAllowedOperations.isSMARTSupported();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
        }
        if (this.m_supportSMARTInfo) {
            OperationDetails operationDetails = new OperationDetails(0x2020100, this.pdInfo);
            try {
                this.fireOperation(operationDetails);
                this.setSMARTInfo((MR_PD_SMART_INFO)operationDetails.getParam());
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                vKInvalidOperationException.printStackTrace();
            }
        } else if (sASAdapter.isWarhawk()) {
            SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(10, 3, sASAdapter.getCtrlID(), byArray, 24);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
            try {
                this.processCommand(networkDataPacket);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                if (n != 0) {
                    throw new VKOperationFailedException(n);
                }
                this.dup_whSSDInfo = this.whSSDInfo = new SL_WH_SSD_INFO(byArray2, 44);
            }
            catch (IOException iOException) {
                throw new VKOperationFailedException(4096);
            }
            catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                throw new VKOperationFailedException(4096);
            }
            catch (VKInvalidOperationException vKInvalidOperationException) {
                throw new VKOperationFailedException(4096);
            }
        }
        return true;
    }

    @Override
    public long getSize() {
        return super.getInformation().getrawSize();
    }

    public long getcoercedSize() {
        return this.getInformation().getcoercedSize();
    }

    @Override
    public short getState() {
        return super.getInformation().getfwState();
    }

    public boolean isOperationAllowed(byte by) throws IllegalArgumentException {
        return false;
    }

    public boolean isKernelOperationAllowed(int n) {
        byte by = ((SASAdapter)this.parent()).getAdapterType();
        if ((n & 0x8000) != 32768) {
            return false;
        }
        boolean bl = true;
        switch (n) {
            case 33538: {
                if (by != 2 && by != 3 && by != 4 || this.getState() != 0) {
                    return false;
                }
                return this.isModePageSavable((byte)28);
            }
            case 33540: 
            case 33541: {
                int n2;
                if (by != 2 && by != 3 && by != 4 || this.getState() != 0) {
                    return false;
                }
                if (!this.isModePageSavable((byte)8)) {
                    return false;
                }
                byte[] byArray = this.getModePage((byte)8, (byte)64);
                return (byArray[(n2 = SCSIOperations.getPageOffset(byArray)) + 2] & 4) == 0 == (n == 33540);
            }
        }
        return bl;
    }

    @Override
    public void notifyMethod(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    private NetworkDataPacket storeLibOperation(byte[] byArray, int n, byte[] byArray2, OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray3 = new byte[8];
        NetworkToJavaConverter.shortTobyteArray(this.getDeviceId(), byArray3, 0);
        NetworkToJavaConverter.shortTobyteArray(this.getSeqNum(), byArray3, 2);
        try {
            SASAdapter sASAdapter = (SASAdapter)this.parent();
            networkDataPacket = sASAdapter.isWarhawk() && operationDetails.getOpcode() == 0 ? new NetworkDataPacket(new SimpleCommandPacket(10, (byte)operationDetails.getOpcode(), ((SASAdapter)this.parent()).getCtrlID(), byArray3, byArray, n, byArray2).getByteArray()) : new NetworkDataPacket(new SimpleCommandPacket(2, (byte)operationDetails.getOpcode(), ((SASAdapter)this.parent()).getCtrlID(), byArray3, byArray, n, byArray2).getByteArray());
            this.processCommand(networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return networkDataPacket;
    }

    public void storeLibPassThroughOpt(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
        sL_DCMD_INPUT_T.setflags('\u0001');
        sL_DCMD_INPUT_T.setpData(((MR_SPARE)operationDetails.getParam()).getByteArray());
        byte[] byArray = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
    }

    public boolean canCreateSpare() {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x4040000);
        sL_DCMD_INPUT_T.setflags('\u0001');
        MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
        MR_SPARE mR_SPARE = new MR_SPARE(mR_PD_REF);
        sL_DCMD_INPUT_T.setpData(mR_SPARE.getByteArray());
        int[] nArray = new int[3];
        nArray[0] = 1;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        byte[] byArray = new byte[8];
        int n = 1;
        switch (operationDetails.getOpcode()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 0, null, operationDetails);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                break;
            }
            case 0x4040000: {
                this.storeLibPassThroughOpt(operationDetails);
                return 0;
            }
            case 34275584: {
                System.out.println("Inside the case MR_DCMD.MR_DCMD_PD_COPYBACK_START");
                ArrayList arrayList = (ArrayList)operationDetails.getParam();
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(0);
                SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)arrayList.get(1);
                MR_PD_REF mR_PD_REF = new MR_PD_REF(sASPhysicalDrive.getDeviceId(), sASPhysicalDrive.getSeqNum());
                MR_PD_REF mR_PD_REF2 = new MR_PD_REF(sASPhysicalDrive2.getDeviceId(), sASPhysicalDrive2.getSeqNum());
                byte[] byArray3 = mR_PD_REF.getByteArray();
                byte[] byArray4 = mR_PD_REF2.getByteArray();
                byte[] byArray5 = new byte[byArray3.length + byArray4.length];
                System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
                System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(byArray5);
                int[] nArray = new int[]{NetworkToJavaConverter.byteArrayToInt(byArray3), NetworkToJavaConverter.byteArrayToInt(byArray4)};
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray6 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = NetworkToJavaConverter.byteArrayToInt(byArray6);
                System.out.println("returnValue: " + n);
                arrayList.add(new Integer(n));
                operationDetails.setParameter(arrayList);
                return n;
            }
            case 0x20B0200: {
                System.out.println("Inside the case MR_DCMD.MR_DCMD.MR_DCMD_PD_COPYBACK_ABORT");
                System.out.println("deviceID: " + this.getDeviceId());
                System.out.println("seqNum: " + this.getSeqNum());
                MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
                byte[] byArray7 = mR_PD_REF.getByteArray();
                byte[] byArray8 = new byte[byArray7.length];
                System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(byArray8);
                int[] nArray = new int[2];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(byArray7);
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray9 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = NetworkToJavaConverter.byteArrayToInt(byArray9);
                System.out.println("returnValue: " + n);
                return n;
            }
            case 3: {
                byArray = new byte[8];
                byArray[0] = (Byte)((ArrayList)operationDetails.getParam()).get(0);
                byArray[2] = (Byte)((ArrayList)operationDetails.getParam()).get(1);
                NetworkDataPacket networkDataPacket = this.storeLibOperation(byArray, 0, null, operationDetails);
                byte[] byArray10 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray10);
                break;
            }
            case 11: {
                byte[] byArray11 = new byte[33];
                byArray11[0] = (byte)((ArrayList)operationDetails.getParam()).size();
                if (byArray11[0] > 16) {
                    throw new VKOperationFailedException(31);
                }
                for (int i = 0; i < Math.min(byArray11[0], 16); ++i) {
                    NetworkToJavaConverter.shortTobyteArray((Short)((ArrayList)operationDetails.getParam()).get(i), byArray11, 1 + 2 * i);
                }
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, byArray11.length, byArray11, operationDetails);
                byte[] byArray12 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray12);
                break;
            }
            case 19: {
                int n2 = new Byte(operationDetails.getParam().toString()).byteValue();
                if (n2 == 0 || n2 == 2) {
                    n2 = 0;
                } else if (n2 == 1) {
                    n2 = 64;
                }
                byArray[0] = n2;
                NetworkDataPacket networkDataPacket = this.storeLibOperation(byArray, 0, null, operationDetails);
                byte[] byArray13 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray13);
                break;
            }
            case 20: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 4, null, operationDetails);
                byte[] byArray14 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray14);
                if (n == 1) break;
                Integer n3 = new Integer(NetworkToJavaConverter.byteArrayToInt(byArray14, 44));
                operationDetails.setParameter(n3);
                break;
            }
            case 16: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 68, null, operationDetails);
                byte[] byArray15 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray15);
                if (n == 1) break;
                byte[] byArray16 = new byte[68];
                System.arraycopy(byArray15, 44, byArray16, 0, 68);
                operationDetails.setParameter(byArray16);
                break;
            }
            case 12: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 40, null, operationDetails);
                byte[] byArray17 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray17);
                if (n == 1) break;
                MR_SPARE mR_SPARE = new MR_SPARE(byArray17, 44);
                operationDetails.setParameter(mR_SPARE);
                break;
            }
            case 7: {
                NetworkDataPacket networkDataPacket = this.storeLibOperation(null, 32, null, operationDetails);
                byte[] byArray18 = networkDataPacket.getDataBuffer();
                n = NetworkToJavaConverter.byteArrayToInt(byArray18);
                if (n == 1) break;
                MR_PD_PROGRESS mR_PD_PROGRESS = new MR_PD_PROGRESS(byArray18, 44);
                super.getInformation().setprogInfo(mR_PD_PROGRESS);
                operationDetails.setParameter(mR_PD_PROGRESS);
                break;
            }
            case 21: {
                byte[] byArray19 = this.getLogPageTemperature((byte)13, 32);
                if (byArray19 == null) break;
                return byArray19[9] & 0xFF;
            }
            case 33537: {
                byte[] byArray20 = this.getModePage((byte)28, (byte)64);
                if (byArray20 == null) {
                    throw new VKOperationFailedException(-1);
                }
                int n4 = SCSIOperations.getPageOffset(byArray20);
                operationDetails.setParameter(new Byte((byte)(byArray20[n4 + 3] & 0xF)));
                return 0;
            }
            case 33538: {
                byte by = (Byte)operationDetails.getParam();
                byte[] byArray21 = this.getModePage((byte)28, (byte)64);
                int n5 = SCSIOperations.getPageOffset(byArray21);
                byte by2 = (byte)(byArray21[n5] >> 7 & 1);
                byArray21[n5 + 3] = (byte)(byArray21[n5 + 3] & 0xF0 | by & 0xF);
                if (this.setModePage(byArray21, by2)) {
                    return 1;
                }
                return 0;
            }
            case 33539: {
                byte[] byArray22 = this.getModePage((byte)8, (byte)64);
                if (byArray22 == null) {
                    throw new VKOperationFailedException(-1);
                }
                int n6 = SCSIOperations.getPageOffset(byArray22);
                if ((byArray22[n6 + 2] & 4) != 0) {
                    operationDetails.setParameter(new Boolean(true));
                } else {
                    operationDetails.setParameter(new Boolean(false));
                }
                return 0;
            }
            case 33540: 
            case 33541: {
                byte[] byArray23 = this.getModePage((byte)8, (byte)64);
                int n7 = SCSIOperations.getPageOffset(byArray23);
                byte by = (byte)(byArray23[n7] >> 7 & 1);
                byte by3 = byArray23[n7 + 2] = operationDetails.getOpcode() == 33541 ? (byte)(byArray23[n7 + 2] & 0xFB) : (byte)(byArray23[n7 + 2] | 4);
                if (this.setModePage(byArray23, by)) {
                    return 1;
                }
                return 0;
            }
            case 34341120: 
            case 34341632: 
            case 0x20D0000: {
                MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(mR_PD_REF.getByteArray());
                int[] nArray = new int[3];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_PD_REF.getByteArray());
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray24 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = 0;
                break;
            }
            case 34537728: {
                MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(mR_PD_REF.getByteArray());
                int[] nArray = new int[3];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_PD_REF.getByteArray());
                byte[] byArray25 = new byte[4];
                byArray25[0] = (byte)operationDetails.getArgument();
                if (KernelConstants.getBitValue(byArray25[0], 7) == 0) {
                    byArray25[2] = 100;
                    byArray25[3] = 85;
                }
                nArray[1] = NetworkToJavaConverter.byteArrayToInt(byArray25);
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray26 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                System.out.println("SASPhysicalDrive.fireOperation() SUCCESS");
                n = 0;
                break;
            }
            case 0x20F0200: {
                MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0001');
                sL_DCMD_INPUT_T.setpData(mR_PD_REF.getByteArray());
                int[] nArray = new int[3];
                nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_PD_REF.getByteArray());
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray27 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                System.out.println("SASPhysicalDrive.fireOperation() SUCCESS");
                n = 0;
                break;
            }
            case 0x2020100: {
                MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
                SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
                sL_DCMD_INPUT_T.setopCode(operationDetails.getOpcode());
                sL_DCMD_INPUT_T.setflags('\u0002');
                sL_DCMD_INPUT_T.setpData(new byte[32]);
                int[] nArray = new int[3];
                nArray[0] = mR_PD_REF.getdeviceId();
                sL_DCMD_INPUT_T.setmbox(nArray);
                byte[] byArray28 = ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
                n = 0;
                if (byArray28 == null) break;
                MR_PD_SMART_INFO mR_PD_SMART_INFO = new MR_PD_SMART_INFO(byArray28, 32);
                operationDetails.setParameter(mR_PD_SMART_INFO);
                break;
            }
        }
        if (n != 0) {
            System.out.println("SASPhysicalDrive.fireOperation()->retval = " + n);
            throw new VKOperationFailedException(n);
        }
        return n;
    }

    public boolean suspendCopyback(boolean bl) {
        MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x20E0200);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_PD_REF.getByteArray());
        nArray[1] = bl ? 1 : 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean suspendRebuild(boolean bl) {
        MR_PD_REF mR_PD_REF = new MR_PD_REF(this.getDeviceId(), this.getSeqNum());
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(34472192);
        sL_DCMD_INPUT_T.setflags('\u0000');
        int[] nArray = new int[3];
        nArray[0] = NetworkToJavaConverter.byteArrayToInt(mR_PD_REF.getByteArray());
        nArray[1] = bl ? 1 : 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        try {
            ((SASAdapter)this.parent()).dcmdPassthruOperation(sL_DCMD_INPUT_T.getByteArray());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            return false;
        }
        return true;
    }

    public MR_SPARE getDedicatedHotspareInfo() throws VKInvalidOperationException, VKNotRespondingException, VKOperationFailedException {
        if (0 == this.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisSpare()) {
            throw new VKInvalidOperationException(0);
        }
        OperationDetails operationDetails = new OperationDetails(12, null);
        this.fireOperation(operationDetails);
        return (MR_SPARE)operationDetails.getParam();
    }

    public ArrayList getLogicalDriveList() {
        ArrayList<SASLogicalDrive> arrayList;
        block11: {
            block10: {
                arrayList = new ArrayList<SASLogicalDrive>();
                if (this.getState() == 0) break block10;
                if (this.getState() != 1 && this.getState() != 2) break block11;
            }
            return arrayList;
        }
        OperationDetails operationDetails = new OperationDetails(16, null);
        byte[] byArray = null;
        int n = 0;
        try {
            this.fireOperation(operationDetails);
            byArray = (byte[])operationDetails.getParam();
            n = NetworkToJavaConverter.byteArrayToInt(byArray);
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n == 0) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList();
        try {
            arrayList2 = ((SASAdapter)this.parent()).getSASObjectsArrayList((short)8192);
        }
        catch (Exception exception) {
            return arrayList;
        }
        block4: for (int i = 0; i < n; ++i) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)iterator.next();
                if (sASLogicalDrive.getInformation().getldConfig().getproperties().getldRef().gettargetId() != byArray[4 + i]) continue;
                arrayList.add(sASLogicalDrive);
                iterator.remove();
                continue block4;
            }
        }
        return arrayList;
    }

    public Vector getGraphicalLayoutInformation() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException, VKObjectNotPresentException {
        Vector<UsageInfo> vector = new Vector<UsageInfo>();
        ArrayList arrayList = this.getLogicalDriveList();
        if (arrayList.size() == 0) {
            return vector;
        }
        MR_SPAN[] mR_SPANArray = null;
        for (SASLogicalDrive sASLogicalDrive : arrayList) {
            MR_LD_INFO mR_LD_INFO = sASLogicalDrive.getInformation();
            mR_SPANArray = mR_LD_INFO.getldConfig().getspan();
            for (int i = 0; i < mR_LD_INFO.getldConfig().getparams().getspanDepth(); ++i) {
                if (mR_SPANArray[i].getarrayRef() != this.getSASArray().getArrayRef()) continue;
                vector.addElement(new UsageInfo(mR_SPANArray[i].getstartBlock(), mR_SPANArray[i].getstartBlock() + mR_SPANArray[i].getnumBlocks(), sASLogicalDrive));
                break;
            }
            if (this.getSize() <= this.getSASArray().getSmallestPDSize()) continue;
            vector.addElement(new UsageInfo(this.getSASArray().getSmallestPDSize(), this.getSize(), null));
        }
        return vector;
    }

    public SASArray getSASArray() {
        try {
            ArrayList arrayList = ((SASAdapter)this.parent()).getSASObjectsArrayList((short)16384);
            for (SASArray sASArray : arrayList) {
                ArrayList arrayList2 = sASArray.getPhysicalDriveArrayList();
                for (Object e : arrayList2) {
                    if (e == null || ((SASPhysicalDrive)e).getDeviceId() != this.getDeviceId()) continue;
                    return sASArray;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public SASPhysicalDriveOperationsAllowed getAllAllowedOperations() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        if (this.m_pdAllowedOperations == null) {
            this.updateAllAllowedOperations();
        }
        return this.m_pdAllowedOperations;
    }

    public void updateAllowedOperations() {
        try {
            this.updateAllAllowedOperations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateAllAllowedOperations() throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        OperationDetails operationDetails = new OperationDetails(20, "", "", null);
        this.fireOperation(operationDetails);
        int n = (Integer)operationDetails.getParam();
        if (this.m_pdAllowedOperations == null) {
            this.m_pdAllowedOperations = new SASPhysicalDriveOperationsAllowed(n, this);
        } else {
            this.m_pdAllowedOperations.update(n, this);
        }
    }

    public ArrayList getSASPhysicalDriveList() {
        ArrayList arrayList = null;
        try {
            arrayList = ((SASAdapter)this.parent()).getSASPDObjectsArrayList((short)4096);
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public boolean handleAEN(Object object) {
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)object;
        MR_PROGRESS mR_PROGRESS = null;
        if (mR_EVT_DETAIL.getargType() == '\u000e') {
            mR_PROGRESS = mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpdProg_args_MR_EVT_DETAIL1().getprog();
        }
        switch (mR_EVT_DETAIL.getcode()) {
            case 132: {
                this.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().setisSpare((byte)1);
                this.pdInfo.setfwState((short)2);
                break;
            }
            case 133: {
                this.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().setisSpare((byte)0);
                this.pdInfo.setfwState((short)0);
                break;
            }
            case 135: {
                this.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().setisGlobalSpare((byte)1);
                this.pdInfo.setfwState((short)2);
                break;
            }
            case 136: {
                this.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().setisGlobalSpare((byte)0);
                this.pdInfo.setfwState((short)0);
                break;
            }
            case 114: 
            case 115: {
                this.pdInfo.setfwState((short)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getnewState());
                try {
                    this.refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 331: {
                this.pdInfo.setPowerState((byte)mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getpdState_args_MR_EVT_DETAIL1().getnewState());
                try {
                    this.refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 94: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setpatrol(1);
                this.pdInfo.getprogInfo().setpatrol(mR_PROGRESS);
                break;
            }
            case 103: {
                this.pdInfo.getprogInfo().setrbld(mR_PROGRESS);
                break;
            }
            case 84: {
                this.pdInfo.getprogInfo().setclear(mR_PROGRESS);
                break;
            }
            case 113: {
                byte[] byArray = mR_EVT_DETAIL.getargs_MR_EVT_DETAIL1().getcdbSense_args_MR_EVT_DETAIL1().getsense();
                byte by = (byte)(byArray[2] & 0xF);
                byte by2 = byArray[12];
                if (by != 3 || by2 != 17) break;
                this.pdInfo.setMediaErrCount(this.pdInfo.getmediaErrCount() + 1);
                break;
            }
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 107: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setrbld(0);
                break;
            }
            case 105: 
            case 106: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setrbld(1);
                break;
            }
            case 82: 
            case 83: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setclear(0);
                break;
            }
            case 85: 
            case 86: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setclear(1);
                break;
            }
            case 288: 
            case 289: 
            case 300: 
            case 482: 
            case 483: {
                try {
                    this.refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 276: 
            case 281: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setCopyBack(1);
                this.updateAllowedOperations();
                break;
            }
            case 277: 
            case 278: 
            case 282: 
            case 293: 
            case 294: 
            case 295: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setCopyBack(0);
                this.pdInfo.getprogInfo().getpause_MR_PD_PROGRESS1().setCopyBack(0);
                this.updateAllowedOperations();
                break;
            }
            case 319: 
            case 320: {
                this.pdInfo.getSecurity_MR_PD_INFO().setSecured((short)0);
                if (this.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisForeign() != 1) break;
                this.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().setisForeign((byte)0);
                break;
            }
            case 318: {
                this.pdInfo.getSecurity_MR_PD_INFO().setSecured((short)1);
                break;
            }
            case 423: {
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setErase(1);
                this.updateAllowedOperations();
                break;
            }
            case 422: {
                this.pdInfo.getprogInfo().setErase(mR_PROGRESS);
                break;
            }
            case 279: {
                try {
                    this.refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 420: 
            case 421: 
            case 424: {
                this.pdInfo.getprogInfo().setErase(null);
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setErase(0);
                this.updateAllowedOperations();
                break;
            }
            case 412: {
                this.pdInfo.getprogInfo().getpause_MR_PD_PROGRESS1().setrbld(1);
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setrbld(0);
                this.updateAllowedOperations();
                break;
            }
            case 400: 
            case 401: {
                break;
            }
            case 104: {
                this.pdInfo.getprogInfo().getpause_MR_PD_PROGRESS1().setrbld(0);
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setrbld(1);
                this.updateAllowedOperations();
                break;
            }
            case 413: {
                this.pdInfo.getprogInfo().getpause_MR_PD_PROGRESS1().setCopyBack(1);
                this.updateAllowedOperations();
                break;
            }
            case 280: {
                this.pdInfo.getprogInfo().getpause_MR_PD_PROGRESS1().setCopyBack(0);
                this.pdInfo.getprogInfo().getactive_MR_PD_PROGRESS1().setCopyBack(1);
                this.updateAllowedOperations();
                break;
            }
            case 303: {
                ArrayList arrayList = this.getSASPhysicalDriveList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((SASPhysicalDevice)arrayList.get(i)).handleAEN(this.m_notifyObj);
                }
                break;
            }
            case 445: {
                System.out.println("MR_EVT.MR_EVT_PR_ABORTED_ON_PD");
                this.pStatus = ((SASAdapter)this.parent()).createPatrolReadStatus();
                this.pStatus.setstate('\u0000');
                SASAdapter sASAdapter = (SASAdapter)this.parent();
                this.m_notifyObj = new NotifyObject(0x102000 | mR_EVT_DETAIL.getcode(), mR_EVT_DETAIL);
                sASAdapter.notifyMethod(this.m_notifyObj);
            }
        }
        if (this.m_notifyObj == null) {
            this.m_notifyObj = new NotifyObject(0x102000 | mR_EVT_DETAIL.getcode(), mR_EVT_DETAIL);
        } else {
            this.m_notifyObj.update(0x102000 | mR_EVT_DETAIL.getcode(), mR_EVT_DETAIL);
        }
        this.notifyMethod(this.m_notifyObj);
        return true;
    }

    public byte getMediatype() {
        return (byte)this.getInformation().getmediatype();
    }

    public byte getDriveType() {
        if (this.getInformation().getscsiDevType() == '\u0000') {
            return this.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getintf();
        }
        return this.getInformation().getInterfaceType();
    }

    public SL_PARTITION_INFO_T getPartitionInfo(int n) throws VKOperationFailedException {
        SL_PARTITION_INFO_T sL_PARTITION_INFO_T = ((SASServer)this.parent().parent()).getPartitionInfo(((SASAdapter)this.parent()).getReceiverWWN(), n, this.getDeviceId(), ((SASAdapter)this.parent()).getCtrlID());
        return sL_PARTITION_INFO_T;
    }

    public byte[] getModePage(byte by, byte by2) {
        byte[] byArray = new byte[6];
        byArray[0] = 26;
        byArray[2] = (byte)(by & 0x3F | 0);
        byArray[4] = by2;
        SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.getDeviceId(), 1, 0, 2, 6, byArray, by2, new byte[by2]);
        try {
            sL_SCSI_PASSTHRU_T = ((SASAdapter)this.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        return sL_SCSI_PASSTHRU_T.getdata();
    }

    public boolean setModePage(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[6];
        int n = SCSIOperations.getPageOffset(byArray);
        int n2 = n + byArray[n + 1] + 2;
        byArray = SCSIOperations.getModeSelectBuffer((byte)n2, byArray, n);
        byArray2[0] = 21;
        byArray2[1] = (byte)(0x10 | by & 1);
        byArray2[4] = (byte)byArray.length;
        SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.getDeviceId(), 1, 0, 1, 6, byArray2, byArray.length, byArray);
        try {
            ((SASAdapter)this.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return false;
        }
        return true;
    }

    public boolean isModePageSavable(byte by) {
        byte[] byArray = this.getModePage(by, (byte)64);
        if (byArray == null) {
            return false;
        }
        int n = SCSIOperations.getPageOffset(byArray);
        return (byArray[n] & 0x3F) != 0;
    }

    public byte[] getLogPageTemperature(byte by, int n) {
        byte[] byArray;
        byte[] byArray2 = new byte[10];
        byte by2 = (byte)n;
        byArray2[0] = 77;
        byArray2[2] = (byte)(0x40 | by);
        byArray2[7] = (byte)(n >> 8);
        byArray2[8] = (byte)(n & 0xFF);
        SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.getDeviceId(), 1, 0, 2, 10, byArray2, by2, new byte[by2]);
        try {
            SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T2 = ((SASAdapter)this.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
            byArray = sL_SCSI_PASSTHRU_T2.getdata();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return null;
        }
        return byArray;
    }

    public boolean isOSDrive() {
        if (((SASAdapter)this.parent()).getAdapterType() == 3 || ((SASAdapter)this.parent()).getAdapterType() == 2) {
            byte[] byArray;
            byte[] byArray2 = new byte[10];
            byArray2[0] = 40;
            byArray2[8] = 1;
            int n = 512;
            SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.getDeviceId(), 1, 0, 2, 180, byArray2, n, new byte[n]);
            try {
                SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T2 = ((SASAdapter)this.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
                byArray = sL_SCSI_PASSTHRU_T2.getdata();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
                return false;
            }
            boolean bl = false;
            bl = this.CheckForBoot(byArray, sL_SCSI_PASSTHRU_T.getdataSize());
            return bl;
        }
        return false;
    }

    public boolean CheckForBoot(byte[] byArray, int n) {
        for (int i = 446; i < n; i += 16) {
            if (byArray[i] != -128) continue;
            return true;
        }
        return false;
    }

    public byte[] GetPDInquiryData() {
        if (((SASAdapter)this.parent()).getAdapterType() == 1) {
            byte[] byArray;
            byte[] byArray2 = new byte[10];
            byArray2[0] = 18;
            byArray2[4] = 127;
            byArray2[8] = 52;
            int n = 512;
            SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T = new SL_SCSI_PASSTHRU_T(this.getDeviceId(), 1, 0, 2, 6, byArray2, n, new byte[n]);
            try {
                SL_SCSI_PASSTHRU_T sL_SCSI_PASSTHRU_T2 = ((SASAdapter)this.parent()).scsiPassthruOperation(sL_SCSI_PASSTHRU_T);
                byArray = sL_SCSI_PASSTHRU_T2.getdata();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
                return null;
            }
            System.out.println(" Buffer Length " + byArray.length);
            return byArray;
        }
        return null;
    }

    public SATA_MODEL_NO getInquiryDataForSataPD() {
        byte[] byArray;
        Object object;
        REGISTER_HOST_TO_DEVICE_FIS_LBA48 rEGISTER_HOST_TO_DEVICE_FIS_LBA48 = new REGISTER_HOST_TO_DEVICE_FIS_LBA48();
        rEGISTER_HOST_TO_DEVICE_FIS_LBA48.setFISType((byte)39);
        rEGISTER_HOST_TO_DEVICE_FIS_LBA48.setCommandBit((byte)-128);
        rEGISTER_HOST_TO_DEVICE_FIS_LBA48.setCommand((byte)-20);
        SL_STP_PASSTHRU_T sL_STP_PASSTHRU_T = new SL_STP_PASSTHRU_T();
        sL_STP_PASSTHRU_T.setdir((byte)2);
        sL_STP_PASSTHRU_T.settargetId((byte)this.getDeviceId());
        sL_STP_PASSTHRU_T.settimeout((short)10);
        sL_STP_PASSTHRU_T.setstpFlags(17);
        short[] sArray = new short[10];
        int n = 0;
        int n2 = 0;
        while (n < rEGISTER_HOST_TO_DEVICE_FIS_LBA48.getByteArray().length) {
            sArray[n2] = NetworkToJavaConverter.byteArrayToShort(rEGISTER_HOST_TO_DEVICE_FIS_LBA48.getByteArray(), n);
            n += 2;
            ++n2;
        }
        sL_STP_PASSTHRU_T.setfis(sArray);
        sL_STP_PASSTHRU_T.setfisResponseBuffer(new byte[20]);
        sL_STP_PASSTHRU_T.setfisResponseLen(20);
        sL_STP_PASSTHRU_T.setdata(new byte[512]);
        sL_STP_PASSTHRU_T.setdataLen(512);
        try {
            object = ((SASAdapter)this.parent()).stpPassthruOperation(sL_STP_PASSTHRU_T);
            byArray = ((SL_STP_PASSTHRU_T)object).getdata();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Error Code : " + vKOperationFailedException.GetErrorCode());
            vKOperationFailedException.printStackTrace();
            return null;
        }
        object = new byte[40];
        System.arraycopy(byArray, 54, object, 0, 40);
        for (int i = 0; i < 40; i += 2) {
            Object object2 = object[i];
            object[i] = object[i + 1];
            object[i + 1] = object2;
        }
        SATA_MODEL_NO sATA_MODEL_NO = new SATA_MODEL_NO((byte[])object, 0);
        return sATA_MODEL_NO;
    }

    public boolean isPRStoppedBySecureErase() {
        return this.m_isPRStoppedBySecureErase;
    }

    public void setPRStoppedBySecureErase(boolean bl) {
        this.m_isPRStoppedBySecureErase = bl;
    }

    public MR_PD_SMART_INFO getSMARTInfo() {
        return this.m_objSMARTInfo;
    }

    public void setSMARTInfo(MR_PD_SMART_INFO mR_PD_SMART_INFO) {
        this.m_objSMARTInfo = mR_PD_SMART_INFO;
    }
}

