/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASPhysical;

import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Services.NetworkToJavaConverter;

public class SASPhysicalDriveOperationsAllowed {
    private boolean makeOnline = true;
    private boolean makeOffline = true;
    private boolean makeFailed = true;
    private boolean makeBad = true;
    private boolean makeUncofigured = true;
    private boolean makeSpare = true;
    private boolean removeSpare = true;
    private boolean replaceMissing = true;
    private boolean markMissing = true;
    private boolean startRebuild = true;
    private boolean stopRebuild = true;
    private boolean startLocate = true;
    private boolean foreignImportNotAllowed = true;
    private boolean startCopyBack = true;
    private boolean stopCopyBack = true;
    private boolean fwDownloadNotAllowed = true;
    private boolean reprovision = true;
    private boolean makeSystem = true;
    private boolean T10PowerModeSupported;
    private boolean suspendRebuild = true;
    private boolean resumeRebuild = true;
    private boolean suspendCopyback = true;
    private boolean resumeCopyback = true;
    private boolean startSecureEraseNonSED;
    private boolean stopSecureEraseNonSED;
    private boolean isSMARTSupported;
    private SASPhysicalDrive sasPd = null;

    public SASPhysicalDriveOperationsAllowed(int n, SASPhysicalDrive sASPhysicalDrive) {
        this.update(n, sASPhysicalDrive);
    }

    public void update(int n, SASPhysicalDrive sASPhysicalDrive) {
        this.makeOnline = KernelConstants.getBitValue(n, 0) != 0;
        this.makeOffline = KernelConstants.getBitValue(n, 1) != 0;
        this.makeFailed = KernelConstants.getBitValue(n, 2) != 0;
        this.makeBad = KernelConstants.getBitValue(n, 3) != 0;
        this.makeUncofigured = KernelConstants.getBitValue(n, 4) != 0;
        this.makeSpare = KernelConstants.getBitValue(n, 5) != 0;
        this.removeSpare = KernelConstants.getBitValue(n, 6) != 0;
        this.replaceMissing = KernelConstants.getBitValue(n, 7) != 0;
        this.markMissing = KernelConstants.getBitValue(n, 8) != 0;
        this.startRebuild = KernelConstants.getBitValue(n, 9) != 0;
        this.stopRebuild = KernelConstants.getBitValue(n, 10) != 0;
        boolean bl = this.startLocate = KernelConstants.getBitValue(n, 11) != 0;
        if (sASPhysicalDrive.pdInfo.getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisForeign() == 1) {
            this.foreignImportNotAllowed = KernelConstants.getBitValue(n, 13) != 0;
        }
        this.startCopyBack = KernelConstants.getBitValue(n, 14) != 0;
        this.stopCopyBack = KernelConstants.getBitValue(n, 15) != 0;
        this.fwDownloadNotAllowed = KernelConstants.getBitValue(n, 16) != 0;
        this.reprovision = KernelConstants.getBitValue(n, 17) != 0;
        this.makeSystem = KernelConstants.getBitValue(n, 18) != 0;
        this.T10PowerModeSupported = KernelConstants.getBitValue(n, 19) != 0;
        this.suspendRebuild = KernelConstants.getBitValue(n, 20) != 0;
        this.resumeRebuild = KernelConstants.getBitValue(n, 21) != 0;
        this.suspendCopyback = KernelConstants.getBitValue(n, 22) != 0;
        this.resumeCopyback = KernelConstants.getBitValue(n, 23) != 0;
        this.startSecureEraseNonSED = KernelConstants.getBitValue(n, 24) != 0;
        this.stopSecureEraseNonSED = KernelConstants.getBitValue(n, 25) != 0;
        this.isSMARTSupported = KernelConstants.getBitValue(n, 26) != 0;
        this.sasPd = sASPhysicalDrive;
    }

    public boolean isOperationAllowed(int n) {
        SASAdapter sASAdapter = (SASAdapter)this.sasPd.parent();
        if (sASAdapter.isWarhawk()) {
            return n == 0 && this.sasPd.getState() != 24;
        }
        switch (n) {
            case 1: {
                return this.isMakeOnline();
            }
            case 2: {
                return this.isMakeOffline();
            }
            case 4: {
                return this.isMarkMissing();
            }
            case 5: {
                return this.isStartRebuild();
            }
            case 6: {
                return this.isStopRebuild();
            }
            case 7: {
                return true;
            }
            case 8: 
            case 9: {
                return this.isStartLocate();
            }
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                return this.isMakeSpare();
            }
            case 14: 
            case 15: {
                SASAdapter sASAdapter2 = (SASAdapter)this.sasPd.parent();
                if (sASAdapter2.getAdapterType() != 1) {
                    return false;
                }
                if (NetworkToJavaConverter.unsignedIntToLong(this.sasPd.getInformation().getenclDeviceId()) == 65535L) {
                    return false;
                }
                boolean bl = this.isMakeOnline() || this.isMakeOffline() || this.isStopRebuild() || this.isRemoveSpare() || this.isBad();
                return !bl;
            }
            case 3: {
                return this.isReplaceMissing();
            }
            case 19: {
                return false;
            }
            case 13: {
                return this.isRemoveSpare();
            }
            case 34275584: {
                return this.isStartCopyBack();
            }
            case 0x20B0200: {
                return this.isStopCopyBack();
            }
            case 33751296: {
                return this.isMakeSystemSupported();
            }
        }
        return true;
    }

    public boolean isMakeOnline() {
        return this.makeOnline;
    }

    public boolean isMakeOffline() {
        return this.makeOffline;
    }

    public boolean isMakeFailed() {
        return this.makeFailed;
    }

    public boolean isMakeBad() {
        return this.makeBad;
    }

    public boolean isMakeUncofigured() {
        return this.makeUncofigured;
    }

    public boolean isMakeSpare() {
        return this.makeSpare;
    }

    public boolean isRemoveSpare() {
        return this.removeSpare;
    }

    public boolean isReplaceMissing() {
        return this.replaceMissing;
    }

    public boolean isMarkMissing() {
        return this.markMissing;
    }

    public boolean isStartRebuild() {
        return this.startRebuild;
    }

    public boolean isStopRebuild() {
        return this.stopRebuild;
    }

    public boolean isStartLocate() {
        return this.startLocate;
    }

    public boolean isBad() {
        return this.sasPd.getState() == 1;
    }

    public boolean isforeignImportNotAllowed() {
        return this.foreignImportNotAllowed;
    }

    public boolean isStartCopyBack() {
        return this.startCopyBack;
    }

    public boolean isStopCopyBack() {
        return this.stopCopyBack;
    }

    public boolean isFwDownloadNotAllowed() {
        return this.fwDownloadNotAllowed;
    }

    public boolean isReprovisionAllowed() {
        return this.reprovision;
    }

    public boolean isMakeSystemSupported() {
        return this.makeSystem;
    }

    public boolean isT10PowerModeSupported() {
        return this.T10PowerModeSupported;
    }

    public boolean isSuspendRebuild() {
        return this.suspendRebuild;
    }

    public boolean isResumeRebuild() {
        return this.resumeRebuild;
    }

    public boolean isSuspendCopyback() {
        return this.suspendCopyback;
    }

    public boolean isResumeCopyback() {
        return this.resumeCopyback;
    }

    public boolean canStartSecureEraseNonSED() {
        return this.startSecureEraseNonSED;
    }

    public boolean canStopSecureEraseNonSED() {
        return this.stopSecureEraseNonSED;
    }

    public boolean isSMARTSupported() {
        return this.isSMARTSupported;
    }
}

