/*
 * Decompiled with CFR 0.152.
 */
package SASKernel;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import KernelServices.SimpleStatusNotification;
import SASKernel.AENHandlerInterface;
import SASKernel.ClientInfo;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.Operations.OperationDetails;
import SASKernel.PluginInfo;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASKernel;
import SASKernel.SASServerInfo;
import SASKernel.VirtualAdapter;
import Services.LogXMLParser;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

public class SASServer
extends Observable
implements ISASObject,
Observer {
    public static final byte AUTHENTICATION_FAILURE = 0;
    public static final byte BUILTIN_ADMINISTRATOR = 1;
    public static final byte BUILTIN_USER = 2;
    public static final byte USER_NO_GROUP = 3;
    public static final byte FULL_ACCESS = 0;
    public static final byte VIEW_ONLY_ACCESS = 1;
    public static final byte EXTERNAL_LUNCH_AUTHENTICATION_FAILURE = 1;
    public static final int LIBTYPE_SAS_MEGARAID = 0;
    public static final int LIBTYPE_SAS_IR = 0x1000000;
    public static final int LIBTYPE_SAS_IR_2 = 0x2000000;
    public static final int LIBTYPE_SAS_IR_3 = 0x4000000;
    public static final int LIBTYPE_MASK = -16777216;
    private static final int LIB_TYPE_STORELIBMR = 0;
    private static final int LIB_TYPE_STORELIBIR = 1;
    private static final int LIB_TYPE_STORELIBIR_2 = 2;
    private static final int LIB_TYPE_STORELIBIR_3 = 4;
    private boolean m_isCIMOMServer = false;
    private String m_strCIMOMWWN;
    private String m_strCIMOMIP;
    private String m_strCIMOMPort;
    private String m_strCIMOMUserName;
    private String m_strCIMOMPassword;
    private String m_ipAddress;
    private SASServerInfo sasSvrInfo;
    private Vector clientListForAEN = new Vector();
    private String svrWWN;
    private boolean bLogin = false;
    private SASKernel sasKernel = null;
    private byte[] usrName;
    private byte accMode;
    private ArrayList sasAdapterArrayList = null;
    private ArrayList<VirtualAdapter> m_virtualAdaptersArrayList = new ArrayList();
    private PluginInfo[] pluginList = null;
    private ClientInfo[] clientList = null;
    private short ID;
    private boolean isLDAPServer = false;
    private boolean UseSystemCredential = false;
    private String userRole = null;
    private String ldapUserName = null;

    public SASServer(short s, String string, SASKernel sASKernel, String string2) throws VKNotRespondingException, VKOperationFailedException {
        this.svrWWN = string;
        this.sasKernel = sASKernel;
        this.sasKernel.setServerIP(this.svrWWN);
        this.ID = s;
        this.addObserver(this.sasKernel);
        this.m_ipAddress = string2;
        this.refresh();
    }

    public SASServer(short s, String string, SASKernel sASKernel) throws VKNotRespondingException, VKOperationFailedException {
        this.svrWWN = string;
        this.sasKernel = sASKernel;
        this.sasKernel.setServerIP(this.svrWWN);
        this.ID = s;
        this.addObserver(this.sasKernel);
        this.refresh();
    }

    public SASServer(short s, String string, SASKernel sASKernel, boolean bl, String string2) throws VKNotRespondingException, VKOperationFailedException {
        this.svrWWN = string;
        this.sasKernel = sASKernel;
        this.sasKernel.setServerIP(this.svrWWN);
        System.out.println("svrWWN :" + this.svrWWN);
        this.ID = s;
        this.addObserver(this.sasKernel);
        this.setIsCIMOMServer(bl);
        this.setCIMOMWWN(string2);
        this.refresh();
    }

    public boolean isLoggedin() {
        return this.bLogin;
    }

    public void login(String string, String string2, byte by) throws IOException, VKOperationFailedException, VKNotRespondingException {
        this.accMode = by;
        this.login(string.getBytes(), string2.getBytes(), by);
    }

    public void login(byte[] byArray, byte[] byArray2, byte by) throws IOException, VKOperationFailedException, VKNotRespondingException {
        this.usrName = byArray;
        this.accMode = by;
        this.refresh();
        if (!this.isLDAPServer() && !this.isUseSystemCredential()) {
            try {
                short s = this.authenticateUser(byArray, byArray2);
                switch (s) {
                    case 0: {
                        throw new VKOperationFailedException(4122);
                    }
                    case 2: 
                    case 3: {
                        if (0 != this.accMode || this.isSimulationMode()) break;
                        throw new VKOperationFailedException(4096, s);
                    }
                }
            }
            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                // empty catch block
            }
        }
        try {
            this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4100, new Byte(this.accMode))));
            this.requestFrameworkToValidateFullAccess(this.accMode);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        ((SASKernel)this.parent()).updateSasServerArrayListFromCache();
        this.bLogin = true;
    }

    private boolean requestFrameworkToValidateFullAccess(byte by) throws VivaldiFrameworkProtocolErrorException, VKOperationFailedException {
        int n;
        byte[] byArray = new byte[60];
        if (by == 0) {
            NetworkToJavaConverter.intToByteArray(261, byArray, 0);
        } else {
            NetworkToJavaConverter.intToByteArray(266, byArray, 0);
        }
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(4, byArray, 56);
        byte[] byArray2 = new byte[4];
        NetworkToJavaConverter.intToByteArray(0, byArray2, 0);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        try {
            n = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byArray2 = networkDataPacket.getDataBuffer();
        n = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
        if (0 != n) {
            String string = NetworkPacket.convertByteArrayToWWNString(byArray2, 4);
            throw new VKOperationFailedException(4101, string);
        }
        return true;
    }

    public void logout() throws IOException, VKOperationFailedException, VKNotRespondingException {
        if (this.isLoggedin()) {
            this.cleanUpMemory();
        }
        this.bLogin = false;
    }

    @Override
    public short getID() {
        return this.ID;
    }

    @Override
    public short getSeqNum() {
        return 0;
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return this.sasKernel;
    }

    public boolean getSystemCIMPlugin() throws VKNotRespondingException {
        block15: {
            try {
                PluginInfo pluginInfo = null;
                try {
                    pluginInfo = this.getSpecificPlugin(1, 6);
                }
                catch (Exception exception) {
                    System.out.println("got exp sys plugin" + exception.getMessage());
                }
                PluginInfo pluginInfo2 = null;
                try {
                    pluginInfo2 = this.getSpecificPlugin(0, 4);
                }
                catch (Exception exception) {
                    System.out.println("got exp cimplugin" + exception.getMessage());
                }
                int n = 0;
                if (pluginInfo != null) {
                    ++n;
                }
                if (pluginInfo2 != null) {
                    ++n;
                }
                this.pluginList = new PluginInfo[n];
                if (pluginInfo != null) {
                    this.pluginList[--n] = pluginInfo;
                }
                if (pluginInfo2 != null) {
                    this.pluginList[--n] = pluginInfo2;
                }
                if (!this.isCIMOMServer()) {
                    byte[] byArray = new byte[400];
                    short s = 1;
                    NetworkToJavaConverter.shortTobyteArray((short)1, byArray, 0);
                    NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
                    String string = null;
                    try {
                        string = this.getSystemInfoPluginWWN();
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        // empty catch block
                    }
                    try {
                        this.processCommand(string, networkDataPacket, 2);
                        s = NetworkToJavaConverter.byteArrayToShort(networkDataPacket.getDataBuffer(), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sasSvrInfo = new SASServerInfo(this.getSvrWWN(), networkDataPacket.getDataBuffer());
                    this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4099, this.sasSvrInfo)));
                    break block15;
                }
                NetworkDataPacket networkDataPacket = new NetworkDataPacket(new byte[222]);
                this.sasSvrInfo = new SASServerInfo(this.getCIMOMWWN(), networkDataPacket.getDataBuffer());
            }
            catch (Exception exception) {
                System.out.println("got exception" + exception.getMessage());
            }
        }
        return true;
    }

    private PluginInfo getSpecificPlugin(int n, int n2) throws VKNotRespondingException {
        PluginInfo pluginInfo = null;
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(263, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(8, byArray, 56);
        byte[] byArray2 = new byte[8];
        NetworkToJavaConverter.intToByteArray(n, byArray2, 0);
        NetworkToJavaConverter.intToByteArray(n2, byArray2, 4);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        try {
            int n3 = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, 0, networkDataPacket);
            pluginInfo = new PluginInfo(networkDataPacket.getDataBuffer(), 4);
            if (!this.isCIMOMServer()) {
                this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4098, pluginInfo)));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new VKNotRespondingException(4);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
            throw new VKNotRespondingException(4);
        }
        return pluginInfo;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException {
        block9: {
            byte[] byArray = new byte[60];
            NetworkToJavaConverter.intToByteArray(259, byArray, 0);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
            NetworkToJavaConverter.intToByteArray(0, byArray, 56);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket();
            try {
                int n = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, 0, networkDataPacket);
                this.pluginList = new PluginInfo[NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer())];
                for (int i = 0; i < this.pluginList.length; ++i) {
                    this.pluginList[i] = new PluginInfo(networkDataPacket.getDataBuffer(), 4 + i * PluginInfo.PLUGIN_INFO_LENGTH);
                    if (this.isCIMOMServer()) continue;
                    this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4098, this.pluginList[i])));
                }
                if (!this.isCIMOMServer()) {
                    byte[] byArray2 = new byte[400];
                    short s = 1;
                    NetworkToJavaConverter.shortTobyteArray((short)1, byArray2, 0);
                    NetworkDataPacket networkDataPacket2 = new NetworkDataPacket(byArray2);
                    String string = null;
                    try {
                        string = this.getSystemInfoPluginWWN();
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        // empty catch block
                    }
                    try {
                        this.processCommand(string, networkDataPacket2, 2);
                        s = NetworkToJavaConverter.byteArrayToShort(networkDataPacket2.getDataBuffer(), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sasSvrInfo = new SASServerInfo(this.getSvrWWN(), networkDataPacket2.getDataBuffer());
                    this.notifyMethod(new NotifyObject(2101251, new SimpleStatusNotification(this, 4099, this.sasSvrInfo)));
                    break block9;
                }
                NetworkDataPacket networkDataPacket3 = new NetworkDataPacket(new byte[222]);
                this.sasSvrInfo = new SASServerInfo(this.getCIMOMWWN(), networkDataPacket3.getDataBuffer());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new VKNotRespondingException(4);
            }
            catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                vivaldiFrameworkProtocolErrorException.printStackTrace();
                throw new VKNotRespondingException(4);
            }
        }
        return true;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        return false;
    }

    @Override
    public void notifyMethod(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public String getSvrWWN() {
        return this.svrWWN;
    }

    public byte[] getUsrName() {
        return this.usrName;
    }

    public byte getAccMode() {
        return this.accMode;
    }

    public SASAdapter[] getAdapterList() {
        SASAdapter[] sASAdapterArray = new SASAdapter[this.sasAdapterArrayList.size()];
        int n = 0;
        Iterator iterator = this.sasAdapterArrayList.iterator();
        while (iterator.hasNext()) {
            sASAdapterArray[n++] = (SASAdapter)iterator.next();
        }
        return sASAdapterArray;
    }

    public ArrayList getAdapterArrayList() {
        ArrayList<SASAdapter> arrayList = new ArrayList<SASAdapter>();
        Iterator iterator = this.sasAdapterArrayList.iterator();
        while (iterator.hasNext()) {
            arrayList.add((SASAdapter)iterator.next());
        }
        return arrayList;
    }

    public ArrayList<VirtualAdapter> getVirtualAdapterArrayList() {
        return this.m_virtualAdaptersArrayList;
    }

    public VirtualAdapter getCCOHVirtualAdapter() {
        int n = this.m_virtualAdaptersArrayList.size();
        for (int i = 0; i < n; ++i) {
            if (this.m_virtualAdaptersArrayList.get(i).getCtrlID() != 0x2FFFFFF) continue;
            return this.m_virtualAdaptersArrayList.get(i);
        }
        return null;
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException, VKInvalidOperationException {
        throw new VKInvalidOperationException(14);
    }

    public int processCommand(String string, NetworkDataPacket networkDataPacket, int n) throws IOException, VivaldiFrameworkProtocolErrorException, VKInvalidOperationException {
        int n2 = 1;
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(n, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray, 56);
        try {
            n2 = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
        }
        catch (IOException iOException) {
            this.notifyMethod(new NotifyObject(4099, null));
            throw iOException;
        }
        return n2;
    }

    public int processCommand(String string, NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException, VKInvalidOperationException {
        int n = 0;
        try {
            if (this.isCIMPluginPresent() && string.equals(this.getCIMPluginWWN())) {
                byte[] byArray = networkDataPacket.getDataBuffer();
                byte[] byArray2 = new byte[552 + byArray.length];
                int n2 = 0;
                byte[] byArray3 = this.getCIMOMIP().getBytes();
                byte[] byArray4 = this.getCIMOMPort().getBytes();
                byte[] byArray5 = this.getCIMOMUser().getBytes();
                byte[] byArray6 = this.getCIMOMPassword().getBytes();
                NetworkToJavaConverter.intToByteArray(271, byArray2, 0);
                System.arraycopy(byArray3, 0, byArray2, n2 += 4, byArray3.length);
                System.arraycopy(byArray4, 0, byArray2, n2 += 32, byArray4.length);
                System.arraycopy(byArray5, 0, byArray2, n2 += 4, byArray5.length);
                System.arraycopy(byArray6, 0, byArray2, n2 += 256, byArray6.length);
                System.arraycopy(byArray, 0, byArray2, n2 += 256, byArray.length);
                n2 += byArray.length;
                NetworkDataPacket networkDataPacket2 = new NetworkDataPacket(byArray2);
                n = this.processCommand(string, networkDataPacket2, 271);
                networkDataPacket.setDataBuffer(networkDataPacket2.getDataBuffer());
            } else {
                n = this.processCommand(string, networkDataPacket, 6);
            }
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            if (vivaldiFrameworkProtocolErrorException.getErrorCode() == 2) {
                this.notifyMethod(new NotifyObject(0x101002, null));
            }
            throw vivaldiFrameworkProtocolErrorException;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        return n;
    }

    public PluginInfo[] getPluginList() {
        return this.pluginList;
    }

    public ClientInfo[] getClientList() {
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(260, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(0, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket();
        try {
            int n = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
            this.clientList = new ClientInfo[NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer())];
            for (int i = 0; i < this.clientList.length; ++i) {
                this.clientList[i] = new ClientInfo(networkDataPacket.getDataBuffer(), 4 + i * 512);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        return this.clientList;
    }

    public void createAdapters() throws IOException, VKOperationFailedException {
        this.sasAdapterArrayList = new ArrayList();
        this.createSASAdapters();
        this.createLegacyAdapters();
        this.createVirtualAdapters();
    }

    private String getStoreLibPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (1 != this.pluginList[i].getMajorGroup() || 2 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getStoreLibIRPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (1 != this.pluginList[i].getMajorGroup() || 3 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getNCPPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (0 != this.pluginList[i].getMajorGroup() || 2 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getAuthenticationPluginWWN() throws VKOperationFailedException, VKObjectNotPresentException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (0 != this.pluginList[i].getMajorGroup() || 1 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKObjectNotPresentException(-1);
    }

    private String getSystemInfoPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (0 != this.pluginList[i].getMajorGroup() || 4 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getLoggerInfoPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (0 != this.pluginList[i].getMajorGroup() || 3 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getCIMPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (1 != this.pluginList[i].getMajorGroup() || 6 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getMonitorPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (0 != this.pluginList[i].getMajorGroup() || 8 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getCIMOMMonitorPluginWWN() throws VKOperationFailedException {
        for (int i = 0; i < this.pluginList.length; ++i) {
            if (0 != this.pluginList[i].getMajorGroup() || 11 != this.pluginList[i].getMinorGroup()) continue;
            return this.pluginList[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private void createSASAdapters() throws IOException, VKOperationFailedException {
        if (!this.isCIMOMServer()) {
            try {
                this.createStoreLIBManagedAdapters(this.getStoreLibPluginWWN(), (byte)1);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                // empty catch block
            }
            try {
                this.createStoreLIBManagedAdapters(this.getStoreLibIRPluginWWN(), (byte)2);
                this.createStoreLIBManagedAdapters(this.getStoreLibIRPluginWWN(), (byte)3);
                this.createStoreLIBManagedAdapters(this.getStoreLibIRPluginWWN(), (byte)4);
            }
            catch (VKOperationFailedException vKOperationFailedException) {}
        } else {
            this.createAdaptersForCIMOM(this.getCIMPluginWWN());
        }
    }

    private void createLegacyAdapters() {
    }

    private void createVirtualAdapters() {
        this.m_virtualAdaptersArrayList.clear();
        String string = "";
        try {
            string = this.getStoreLibIRPluginWWN();
        }
        catch (Exception exception) {
            return;
        }
        NetworkDataPacket networkDataPacket = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 10, 0x2000000, 68).getByteArray());
        try {
            this.processCommand(string, networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
            int n2 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
            System.out.println("Number of Virtual Controllers Found = " + n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + i * 4);
                System.out.println("Virtual Controller ID =" + n3);
                this.m_virtualAdaptersArrayList.add(new VirtualAdapter(this, n3, string));
            }
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized boolean registerForAEN(AENHandlerInterface aENHandlerInterface) {
        this.clientListForAEN.add(aENHandlerInterface);
        return true;
    }

    public synchronized boolean unRegisterForAEN(AENHandlerInterface aENHandlerInterface) {
        if (this.clientListForAEN == null) {
            return false;
        }
        return this.clientListForAEN.remove(aENHandlerInterface);
    }

    public synchronized boolean callBackAEN(NetworkPacket networkPacket) {
        if (null != this.clientListForAEN) {
            for (int i = 0; i < this.clientListForAEN.size(); ++i) {
                if (!((AENHandlerInterface)this.clientListForAEN.get(i)).handleAEN(networkPacket)) continue;
                this.notifyMethod(new NotifyObject(0x101001, networkPacket));
                return true;
            }
        }
        return false;
    }

    public synchronized boolean callBackCIMOMAEN(NetworkPacket networkPacket) {
        if (null != this.clientListForAEN) {
            for (int i = 0; i < this.clientListForAEN.size(); ++i) {
                if (!((AENHandlerInterface)this.clientListForAEN.get(i)).handleAEN(networkPacket)) continue;
                this.notifyMethod(new NotifyObject(0x101001, networkPacket));
                return true;
            }
        }
        return false;
    }

    private short authenticateUser(String string, String string2) throws IOException, VKObjectNotPresentException {
        return this.authenticateUser(string.getBytes(), string2.getBytes());
    }

    private short authenticateUser(byte[] byArray, byte[] byArray2) throws IOException, VKObjectNotPresentException {
        byte[] byArray3 = new byte[514];
        short s = 1;
        NetworkToJavaConverter.shortTobyteArray((short)1, byArray3, 0);
        System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 258, byArray2.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray3);
        try {
            this.processCommand(this.getAuthenticationPluginWWN(), networkDataPacket, 2);
            s = NetworkToJavaConverter.byteArrayToShort(networkDataPacket.getDataBuffer(), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public SASServerInfo getInformation() {
        return this.sasSvrInfo;
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        int n = 0;
        return n;
    }

    private void cleanUpMemory() {
        this.clientListForAEN.clear();
        if (null != this.sasAdapterArrayList) {
            Iterator iterator = this.sasAdapterArrayList.iterator();
            while (iterator.hasNext()) {
                ((SASAdapter)iterator.next()).cleanUP((short)28672);
                iterator.remove();
            }
            this.sasAdapterArrayList = null;
        }
        int n = this.m_virtualAdaptersArrayList.size();
        for (int i = 0; i < n; ++i) {
            this.m_virtualAdaptersArrayList.get(i).cleanUP();
        }
        this.m_virtualAdaptersArrayList.clear();
        this.cleanUp();
        System.gc();
    }

    private void cleanUp() {
        this.deleteObservers();
        this.addObserver(this.sasKernel);
    }

    public String getFrameworkVersion() {
        byte[] byArray = new byte[60];
        String string = null;
        NetworkToJavaConverter.intToByteArray(265, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(0, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket();
        try {
            int n = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            string = new String(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public int registerLogRecord(byte[] byArray, byte[] byArray2) throws VKOperationFailedException {
        return this.registerKernelLog(0, byArray, byArray2);
    }

    public boolean getFrameworkNCPStatus() {
        byte[] byArray = new byte[60];
        int n = -1;
        NetworkToJavaConverter.intToByteArray(275, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(0, byArray, 56);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket();
        try {
            int n2 = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            String string = new String(byArray2).trim();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            System.out.println("VivaldiFrameworkProtocolErrorException");
            exception.printStackTrace();
        }
        return n == 1;
    }

    public int registerLogRecord(int n, byte[] byArray, byte[] byArray2) throws VKOperationFailedException {
        int n2 = 0;
        byte[] byArray3 = new byte[12];
        NetworkToJavaConverter.intToByteArray(3, byArray3, 0);
        NetworkToJavaConverter.intToByteArray(n, byArray3, 4);
        byArray3[8] = byArray[0];
        byArray3[9] = byArray[1];
        byArray3[10] = byArray2[0];
        byArray3[11] = byArray2[1];
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray3);
        try {
            this.processCommand(this.getLoggerInfoPluginWWN(), networkDataPacket);
            n2 = NetworkToJavaConverter.byteArrayToInt(byArray3, 0);
        }
        catch (Exception exception) {
            n2 = 1;
        }
        return n2;
    }

    public int registerKernelLog(int n, byte[] byArray, byte[] byArray2) throws VKOperationFailedException {
        int n2 = 0;
        byte[] byArray3 = new byte[12];
        NetworkToJavaConverter.intToByteArray(8, byArray3, 0);
        NetworkToJavaConverter.intToByteArray(n, byArray3, 4);
        byArray3[8] = byArray[0];
        byArray3[9] = byArray[1];
        byArray3[10] = byArray2[0];
        byArray3[11] = byArray2[1];
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray3);
        try {
            this.processCommand(this.getLoggerInfoPluginWWN(), networkDataPacket);
            n2 = NetworkToJavaConverter.byteArrayToInt(byArray3, 0);
        }
        catch (Exception exception) {
            n2 = 1;
        }
        return n2;
    }

    public int clearLogRecord() throws VKOperationFailedException {
        int n = 0;
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.intToByteArray(4, byArray, 0);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            this.processCommand(this.getLoggerInfoPluginWWN(), networkDataPacket);
            n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public int clearCIMOMLogRecord() throws VKOperationFailedException {
        byte[] byArray = new byte[32];
        int n = 0;
        NetworkToJavaConverter.intToByteArray(280, byArray, 0);
        byte[] byArray2 = this.getCIMOMIP().getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            String string = "";
            try {
                string = this.getCIMOMMonitorPluginWWN();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 1;
            }
            System.out.println("WWN ==> " + string);
            try {
                this.processCommand(this.getCIMOMMonitorPluginWWN(), networkDataPacket, 280);
            }
            catch (Exception exception) {
                return 1;
            }
            byArray = networkDataPacket.getDataBuffer();
            n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
            if (n == 1) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    public ArrayList readVivaldiLogConfig() {
        byte[] byArray = new byte[4];
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.isCIMOMServer()) {
            NetworkToJavaConverter.intToByteArray(9, byArray, 0);
        } else {
            NetworkToJavaConverter.intToByteArray(277, byArray, 0);
        }
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            if (!this.isCIMOMServer()) {
                this.processCommand(this.getMonitorPluginWWN(), networkDataPacket);
            } else {
                this.processCommand(this.getCIMOMMonitorPluginWWN(), networkDataPacket, 277);
            }
            byArray = networkDataPacket.getDataBuffer();
            n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
            if (n == 1) {
                System.out.println("SASServer.readVivaldiLogConfig() error @ reading vivaldi config");
            }
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 12 + n3);
                String string = new String(byArray, 12 + n3 + 4, n4);
                if (string == null) {
                    System.out.println("SASServer.readVivaldiLogConfig()" + n5 + "th event is null");
                } else {
                    arrayList.add(string);
                }
                ++n5;
                n3 += 4 + n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList readLogRecord(int n, int n2, byte[] byArray, byte[] byArray2) throws VKOperationFailedException {
        Object object;
        byte[] byArray3 = new byte[48];
        int n3 = 0;
        ArrayList<LogXMLParser> arrayList = new ArrayList<LogXMLParser>();
        if (this.isCIMOMServer()) {
            NetworkToJavaConverter.intToByteArray(279, byArray3, 0);
        } else {
            NetworkToJavaConverter.intToByteArray(2, byArray3, 0);
        }
        NetworkToJavaConverter.intToByteArray(n, byArray3, 4);
        NetworkToJavaConverter.intToByteArray(n2, byArray3, 8);
        byArray3[12] = byArray[0];
        byArray3[13] = byArray[1];
        byArray3[14] = byArray2[0];
        byArray3[15] = byArray2[1];
        if (this.isCIMOMServer()) {
            object = this.getCIMOMIP().getBytes();
            System.arraycopy(object, 0, byArray3, 16, ((byte[])object).length);
        } else {
            object = new byte[32];
            System.arraycopy(object, 0, byArray3, 16, ((byte[])object).length);
        }
        object = new NetworkDataPacket(byArray3);
        try {
            if (!this.isCIMOMServer()) {
                this.processCommand(this.getLoggerInfoPluginWWN(), (NetworkDataPacket)object);
            } else {
                String string = "";
                try {
                    string = this.getCIMOMMonitorPluginWWN();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                System.out.println("WWN ==> " + string);
                try {
                    this.processCommand(this.getCIMOMMonitorPluginWWN(), (NetworkDataPacket)object, 279);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            byArray3 = ((NetworkDataPacket)object).getDataBuffer();
            n3 = NetworkToJavaConverter.byteArrayToInt(byArray3, 0);
            if (n3 == 1) {
                throw new VKOperationFailedException(4123);
            }
            int n4 = NetworkToJavaConverter.byteArrayToInt(byArray3, 8);
            LogXMLParser[] logXMLParserArray = new LogXMLParser[n4];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n4) {
                n6 = NetworkToJavaConverter.byteArrayToInt(byArray3, 12 + n5);
                LogXMLParser logXMLParser = new LogXMLParser(byArray3, 12 + n5 + 4, n6);
                if (logXMLParser != null) {
                    logXMLParser.getXML().toString();
                    arrayList.add(logXMLParser);
                }
                ++n7;
                n5 += 4 + n6;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new VKOperationFailedException(4096);
        }
        return arrayList;
    }

    public int writeLogRecord(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[4 + byArray.length];
        NetworkToJavaConverter.intToByteArray(5, byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        try {
            this.processCommand(this.getLoggerInfoPluginWWN(), networkDataPacket, 2);
            n = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public int writeKernelLogRecord(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[4 + byArray.length];
        NetworkToJavaConverter.intToByteArray(7, byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        try {
            this.processCommand(this.getLoggerInfoPluginWWN(), networkDataPacket, 2);
            n = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public int unregisterLog() throws VKOperationFailedException {
        int n = 0;
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.intToByteArray(6, byArray, 0);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            this.processCommand(this.getLoggerInfoPluginWWN(), networkDataPacket, 2);
            n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public int pollLoggedInFramework() {
        int n = 1;
        if (this.isCIMOMServer()) {
            return this.pollLoggedInCIMOM();
        }
        byte[] byArray = new byte[60];
        NetworkToJavaConverter.intToByteArray(267, byArray, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
        NetworkToJavaConverter.intToByteArray(4, byArray, 56);
        byte[] byArray2 = new byte[4];
        NetworkToJavaConverter.intToByteArray(0, byArray2, 0);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray2);
        try {
            int n2 = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
        }
        catch (Exception exception) {
            return n;
        }
        byArray2 = networkDataPacket.getDataBuffer();
        n = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
        return n;
    }

    private int pollLoggedInCIMOM() {
        int n = 1;
        try {
            byte[] byArray = new byte[552];
            int n2 = 0;
            NetworkToJavaConverter.intToByteArray(272, byArray, 0);
            byte[] byArray2 = this.getCIMOMIP().getBytes();
            System.arraycopy(byArray2, 0, byArray, n2 += 4, byArray2.length);
            byte[] byArray3 = this.getCIMOMPort().getBytes();
            System.arraycopy(byArray3, 0, byArray, n2 += 32, byArray3.length);
            byte[] byArray4 = this.getCIMOMUser().getBytes();
            System.arraycopy(byArray4, 0, byArray, n2 += 4, byArray4.length);
            byte[] byArray5 = this.getCIMOMPassword().getBytes();
            System.arraycopy(byArray5, 0, byArray, n2 += 256, byArray5.length);
            n2 += 256;
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
            int n3 = this.processCommand(this.getCIMPluginWWN(), networkDataPacket, 272);
            byte[] byArray6 = networkDataPacket.getDataBuffer();
            n = NetworkToJavaConverter.byteArrayToInt(byArray6, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public synchronized void rescan() throws VKOperationFailedException, IOException {
        if (this.isLoggedin()) {
            this.cleanUpMemory();
            this.createAdapters();
        }
    }

    private void createStoreLIBManagedAdapters(String string, byte by) throws IOException, VKOperationFailedException {
        NetworkDataPacket networkDataPacket = null;
        if (1 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
        } else if (2 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x1000000, 68).getByteArray());
        } else if (3 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x2000000, 68).getByteArray());
        } else if (4 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x4000000, 68).getByteArray());
        }
        try {
            this.processCommand(string, networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
            int n2 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
            System.out.println("Number of Controller Found = " + n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + i * 4);
                System.out.println("Controller ID =" + n3);
                this.sasAdapterArrayList.add(new SASAdapter(n3, n3, this, string, by, this.sasAdapterArrayList.size()));
            }
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            vKNotRespondingException.printStackTrace();
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
        }
    }

    public void RegistrationCommandForAEN() {
        Iterator iterator = this.getAdapterArrayList().iterator();
        while (iterator.hasNext()) {
            ((SASAdapter)iterator.next()).RegistrationCommandForAEN();
        }
        int n = this.m_virtualAdaptersArrayList.size();
        for (int i = 0; i < n; ++i) {
            this.m_virtualAdaptersArrayList.get(i).RegistrationCommandForAEN();
        }
    }

    public SL_PARTITION_INFO_T getPartitionInfo(String string, int n, int n2, int n3) throws VKOperationFailedException {
        NetworkDataPacket networkDataPacket = null;
        SL_PARTITION_INFO_T sL_PARTITION_INFO_T = null;
        SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(0, 8, n3, 14348);
        byte[] byArray = new byte[8];
        byArray[0] = (byte)n;
        NetworkToJavaConverter.intToByteArray(n2, byArray, 1);
        simpleCommandPacket.setCmdParamUsage(byArray);
        networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
        try {
            this.processCommand(string, networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            int n4 = NetworkToJavaConverter.byteArrayToInt(byArray2);
            if (n4 != 1) {
                sL_PARTITION_INFO_T = new SL_PARTITION_INFO_T(byArray2, 44);
            }
        }
        catch (Exception exception) {
            throw new VKOperationFailedException(4096);
        }
        return sL_PARTITION_INFO_T;
    }

    public boolean isSimulationMode() {
        NetworkDataPacket networkDataPacket = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
        try {
            String string = this.getStoreLibPluginWWN();
            this.processCommand(string, networkDataPacket, 2);
            byte[] byArray = networkDataPacket.getDataBuffer();
            byte by = byArray[46];
            if (by == 1) {
                System.out.println("System running under simulation mode");
            }
            return by == 1;
        }
        catch (Exception exception) {
            System.out.println("Exception while determining simulation mode");
            return false;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof NotifyObject)) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        switch (notifyObject.getNotifyCode()) {
            case 2101251: {
                this.notifyMethod(object);
                break;
            }
        }
    }

    public void validatePassKey(String string, byte by) throws Exception {
        byte[] byArray = new byte[514];
        this.accMode = by;
        short s = 1;
        NetworkToJavaConverter.intToByteArray(2, byArray, 0);
        NetworkToJavaConverter.intToByteArray(string.length(), byArray, 4);
        System.arraycopy(string.getBytes(), 0, byArray, 8, 4);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        this.processCommand(this.getAuthenticationPluginWWN(), networkDataPacket, 2);
        s = NetworkToJavaConverter.byteArrayToShort(networkDataPacket.getDataBuffer(), 0);
        switch (s) {
            case 0: {
                throw new VKOperationFailedException(4122);
            }
            case 2: {
                throw new VKOperationFailedException(4127);
            }
            case 3: {
                if (0 != this.accMode || this.isSimulationMode()) break;
                throw new VKOperationFailedException(4096, s);
            }
        }
        this.requestFrameworkToValidateFullAccess(this.accMode);
        ((SASKernel)this.parent()).updateSasServerArrayListFromCache();
        this.bLogin = true;
        this.createAdapters();
    }

    public boolean isCIMOMServer() {
        return this.m_isCIMOMServer;
    }

    public void setIsCIMOMServer(boolean bl) {
        this.m_isCIMOMServer = bl;
    }

    public String getCIMOMWWN() {
        return this.m_strCIMOMWWN;
    }

    public void setCIMOMWWN(String string) {
        this.m_strCIMOMWWN = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_strCIMOMWWN, ":");
        this.m_strCIMOMIP = (String)stringTokenizer.nextElement();
        this.m_strCIMOMPort = (String)stringTokenizer.nextElement();
    }

    public String getCIMOMIP() {
        return this.m_strCIMOMIP;
    }

    public String getCIMOMPort() {
        return this.m_strCIMOMPort;
    }

    public void setCIMOMUserCredentials(String string, String string2) {
        this.m_strCIMOMUserName = string;
        this.m_strCIMOMPassword = string2;
    }

    public String getCIMOMUser() {
        return this.m_strCIMOMUserName;
    }

    public String getCIMOMPassword() {
        return this.m_strCIMOMPassword;
    }

    public ArrayList getCIMOMServers() {
        ArrayList<SASServer> arrayList = new ArrayList<SASServer>();
        String string = this.getSvrWWN();
        this.sasKernel.setServerIP(string);
        try {
            byte[] byArray = new byte[60];
            NetworkToJavaConverter.intToByteArray(269, byArray, 0);
            byte[] byArray2 = new byte[60];
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
            int n = this.processCommand(this.getCIMPluginWWN(), networkDataPacket, 269);
            byArray2 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
            for (int i = 0; i < n2; ++i) {
                int n3 = 4 + i * 24;
                try {
                    String string2 = NetworkPacket.convertByteArrayToWWNString(byArray2, n3);
                    SASServer sASServer = new SASServer((short)i, string, (SASKernel)this.parent(), true, string2);
                    arrayList.add(sASServer);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList getCIMOMServers(String string) {
        ArrayList<SASServer> arrayList = new ArrayList<SASServer>();
        String string2 = this.getSvrWWN();
        try {
            byte[] byArray = new byte[60];
            NetworkToJavaConverter.intToByteArray(269, byArray, 0);
            byte[] byArray2 = new byte[60];
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
            int n = this.processCommand(string, networkDataPacket, 269);
            byArray2 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 0);
            for (int i = 0; i < n2; ++i) {
                int n3 = 4 + i * 24;
                try {
                    String string3 = NetworkPacket.convertByteArrayToWWNString(byArray2, n3);
                    SASServer sASServer = new SASServer((short)i, string2, (SASKernel)this.parent(), true, string3);
                    arrayList.add(sASServer);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void loginToCIMOM(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte by) throws IOException, VKOperationFailedException {
        try {
            byte[] byArray5 = new byte[552];
            int n = 0;
            NetworkToJavaConverter.intToByteArray(270, byArray5, 0);
            System.arraycopy(byArray, 0, byArray5, n += 4, byArray.length);
            System.arraycopy(byArray2, 0, byArray5, n += 32, byArray2.length);
            System.arraycopy(byArray3, 0, byArray5, n += 4, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, n += 256, byArray4.length);
            n += 256;
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray5);
            this.processCommand(this.getCIMPluginWWN(), networkDataPacket, 270);
            byte[] byArray6 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray6, 0);
            if (n2 == 0 || n2 == 2 && by != 0) {
                if (byArray6.length > 4) {
                    byte[] byArray7 = new byte[32];
                    System.arraycopy(byArray6, 4, byArray7, 0, byArray7.length);
                    StringTokenizer stringTokenizer = new StringTokenizer(this.getCIMOMWWN(), ":");
                    String string = (String)stringTokenizer.nextElement();
                    String string2 = (String)stringTokenizer.nextElement();
                    String string3 = (String)stringTokenizer.nextElement();
                    StringBuffer stringBuffer = new StringBuffer(new String(byArray7).trim()).append(":");
                    stringBuffer.append(string2).append(":").append(string3);
                    this.setCIMOMWWN(stringBuffer.toString());
                }
            } else {
                if (n2 == 1) {
                    throw new VKOperationFailedException(4122);
                }
                if (n2 == 2) {
                    throw new VKOperationFailedException(4096);
                }
                throw new VKOperationFailedException(4127);
            }
            this.setCIMOMUserCredentials(new String(byArray3), new String(byArray4));
            ((SASKernel)this.parent()).updateSASServerArrayList(this);
            this.bLogin = true;
            this.createAdapters();
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
        }
    }

    public boolean isCIMPluginPresent() {
        PluginInfo[] pluginInfoArray = this.getPluginList();
        if (pluginInfoArray != null) {
            for (int i = 0; i < pluginInfoArray.length; ++i) {
                if (pluginInfoArray[i].getMajorGroup() != 1 || pluginInfoArray[i].getMinorGroup() != 6) continue;
                return true;
            }
        }
        return false;
    }

    private void createAdaptersForCIMOM(String string) {
        byte[] byArray;
        NetworkDataPacket networkDataPacket = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
        try {
            this.processCommand(string, networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            this.createAdaptersHelper(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x1000000, 68).getByteArray());
        try {
            this.processCommand(string, networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            this.createAdaptersHelper(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x2000000, 68).getByteArray());
        try {
            this.processCommand(string, networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            this.createAdaptersHelper(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x4000000, 68).getByteArray());
        try {
            this.processCommand(string, networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            this.createAdaptersHelper(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createAdaptersHelper(byte[] byArray) {
        byte by = 0;
        int n = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
        for (int i = 0; i < n; ++i) {
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + i * 4);
            if ((n2 & 0xFF000000) == 0) {
                by = 1;
            }
            if ((n2 & 0xFF000000) == 0x1000000) {
                by = 2;
            }
            if ((n2 & 0xFF000000) == 0x2000000) {
                by = 3;
            }
            if ((n2 & 0xFF000000) == 0x4000000) {
                by = 4;
            }
            try {
                this.sasAdapterArrayList.add(new SASAdapter(n2, n2, this, this.getCIMPluginWWN(), by, this.sasAdapterArrayList.size()));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int stopFWDiscovery(boolean bl) {
        float f = Float.parseFloat(this.getFrameworkVersion());
        if (f >= 3.0f) {
            byte[] byArray = new byte[60];
            if (bl) {
                NetworkToJavaConverter.intToByteArray(273, byArray, 0);
            } else {
                NetworkToJavaConverter.intToByteArray(274, byArray, 0);
            }
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(((SASKernel)this.parent()).getClientInfo().getWWN()), 0, byArray, 4, 24);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getSvrWWN()), 0, byArray, 28, 24);
            NetworkToJavaConverter.intToByteArray(0, byArray, 56);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket();
            try {
                int n = ((SASKernel)this.parent()).getNetworkManager().getClientConnectionInstance().processCommand(byArray, networkDataPacket);
                if (n > 0) {
                    return 1;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
            catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                vivaldiFrameworkProtocolErrorException.printStackTrace();
                return -1;
            }
        }
        return 0;
    }

    public boolean isFWSupportedNCPStop() {
        String string = this.getFrameworkVersion();
        float f = 0.0f;
        if (string != null) {
            f = Float.parseFloat(string);
            return f >= 3.0f;
        }
        return false;
    }

    public boolean manageCIMMOMServer() {
        System.out.println("Inside manageCIMOMServer");
        byte[] byArray = new byte[552];
        int n = 0;
        byte[] byArray2 = this.getCIMOMIP().getBytes();
        byte[] byArray3 = this.getCIMOMPort().getBytes();
        byte[] byArray4 = this.getCIMOMUser().getBytes();
        byte[] byArray5 = this.getCIMOMPassword().getBytes();
        System.out.println("CIMOM IP = " + new String(byArray2).trim());
        NetworkToJavaConverter.intToByteArray(276, byArray, 0);
        System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, n += 32, byArray3.length);
        System.arraycopy(byArray4, 0, byArray, n += 4, byArray4.length);
        System.arraycopy(byArray5, 0, byArray, n += 256, byArray5.length);
        n += 256;
        String string = "";
        try {
            string = this.getCIMOMMonitorPluginWWN();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("WWN ==> " + string);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            this.processCommand(this.getCIMOMMonitorPluginWWN(), networkDataPacket, 276);
            byArray = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
            System.out.println("SASServer.manageCIMMOMServer() return value = " + n2);
            if (n2 == 1) {
                System.out.println("Error @ firing SASServer 2 Monitor plugin");
                return false;
            }
            System.out.println("Success @ firing SASServer 2 Monitor plugin");
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception @ firing SASServer 2 Monitor plugin");
            return false;
        }
    }

    private void jbInit() throws Exception {
    }

    public boolean isUseSystemCredential() {
        return this.UseSystemCredential;
    }

    public void setUseSystemCredential(boolean bl) {
        this.UseSystemCredential = bl;
    }

    public String getM_ipAddress() {
        return this.m_ipAddress;
    }

    public void setM_ipAddress(String string) {
        this.m_ipAddress = string;
    }

    public void setLDAPServer(boolean bl) {
        this.isLDAPServer = bl;
    }

    public boolean isLDAPServer() {
        return this.isLDAPServer;
    }

    public void setUserRole(String string) {
        this.userRole = string;
    }

    public void setLDAPUserName(String string) {
        this.ldapUserName = string;
    }

    public String getUserRole() {
        if (this.userRole != null && this.userRole.contains("Administrators")) {
            return "Administrator";
        }
        return "Guest";
    }

    public String getLDAPUserName() {
        return this.ldapUserName;
    }
}

