/*
 * Decompiled with CFR 0.152.
 */
package SASKernel;

import SASKernel.LibraryAPI.StoreLib.MSM_CLUSTERS_INFO;
import SASKernel.LibraryAPI.StoreLib.MSM_CLUSTER_INFO;
import SASKernel.SASKernel;
import Services.NetworkToJavaConverter;
import Services.WWNExtractor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class SASServerInfo {
    private String hostname = null;
    private String IP = null;
    private String OSName = null;
    private String OSVersion = null;
    private String OSArch = null;
    private String cluster = null;
    ArrayList clusterList = new ArrayList();
    private int TotalLD = 0;
    private int TotalLDOnline = 0;
    private int TotalLDFailed = 0;
    private int TotalLDDegraded = 0;
    private byte systemType;
    private boolean clusterSupported = false;
    private boolean maxHaNodes = false;

    public SASServerInfo(String string, byte[] byArray) {
        int[] nArray = new WWNExtractor(string).getIP();
        this.IP = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        System.out.println("data[0] = " + byArray[0]);
        if (0 == NetworkToJavaConverter.byteArrayToShort(byArray, 0)) {
            this.OSName = new String(byArray, 2, 128).trim();
            System.out.println("OSName" + this.OSName);
            this.OSVersion = new String(byArray, 130, 32).trim();
            this.OSArch = new String(byArray, 162, 32).trim();
            MSM_CLUSTERS_INFO mSM_CLUSTERS_INFO = null;
            try {
                mSM_CLUSTERS_INFO = new MSM_CLUSTERS_INFO(byArray, 245);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                mSM_CLUSTERS_INFO = null;
            }
            if (mSM_CLUSTERS_INFO != null) {
                MSM_CLUSTER_INFO[] mSM_CLUSTER_INFOArray = mSM_CLUSTERS_INFO.getClusterinfo();
                for (int i = 0; i < mSM_CLUSTER_INFOArray.length; ++i) {
                    byte[] byArray2 = mSM_CLUSTER_INFOArray[i].getClusterIds();
                    String string2 = "";
                    for (int j = 0; j < byArray2.length; ++j) {
                        string2 = string2 + NetworkToJavaConverter.byteToHex(byArray2[j]);
                    }
                    this.clusterSupported = mSM_CLUSTER_INFOArray[i].isclusterSupported();
                    this.maxHaNodes = mSM_CLUSTER_INFOArray[i].ismaxHaNodes();
                    this.setmaxHaNodes(this.maxHaNodes);
                    if (!this.maxHaNodes) continue;
                    this.clusterList.add(string2);
                    System.out.println("cluster[i].getClusterIds()" + mSM_CLUSTER_INFOArray[i].getClusterIds());
                }
            }
            this.TotalLD = NetworkToJavaConverter.byteArrayToInt(byArray, 194);
            this.TotalLDOnline = NetworkToJavaConverter.byteArrayToInt(byArray, 198);
            this.TotalLDFailed = NetworkToJavaConverter.byteArrayToInt(byArray, 202);
            this.TotalLDDegraded = NetworkToJavaConverter.byteArrayToInt(byArray, 206);
            this.systemType = SASKernel.getOemType() == 2561 ? (byte)4 : (byte)0;
            try {
                this.hostname = new String(byArray, 211, 32).trim();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                try {
                    this.hostname = InetAddress.getByName(this.IP).getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    this.hostname = " ";
                }
            }
        }
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getIP() {
        return this.IP;
    }

    public String OperatingSystemName() {
        return this.OSName;
    }

    public String OperatingSystemVersion() {
        return this.OSVersion;
    }

    public String OperatingSystemArch() {
        return this.OSArch;
    }

    public boolean isFailedLogicalDrivePresent() {
        return this.TotalLDFailed > 0;
    }

    public boolean isDegradedLogicalDrivePresent() {
        return this.TotalLDDegraded > 0;
    }

    public int getLogicalDriveCount() {
        return this.TotalLD;
    }

    public int getLogicalDriveOnlineCount() {
        return this.TotalLDOnline;
    }

    public int getLogicalDriveFailedCount() {
        return this.TotalLDFailed;
    }

    public int getLogicalDriveDegradedCount() {
        return this.TotalLDDegraded;
    }

    public byte getSystemType() {
        return this.systemType;
    }

    public String getClusterId() {
        return this.cluster;
    }

    public ArrayList getClusterList() {
        return this.clusterList;
    }

    public void setClusterList(ArrayList arrayList) {
        this.clusterList = arrayList;
    }

    public boolean isclusterSupported() {
        return this.clusterSupported;
    }

    public void setclusterSupported(boolean bl) {
        System.out.println("support" + this.clusterSupported);
        this.clusterSupported = this.clusterSupported;
    }

    public boolean ismaxHaNodes() {
        return this.maxHaNodes;
    }

    public void setmaxHaNodes(boolean bl) {
        this.maxHaNodes = bl;
    }
}

