/*
 * Decompiled with CFR 0.152.
 */
package Services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LogXMLParser {
    public static final String MESSAGE_ID = "msgid";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String SEQ_NUM = "seqNum";
    public static final String DATE = "dd";
    public static final String MONTH = "month";
    public static final String YEAR = "yyyy";
    public static final String HOUR = "hh";
    public static final String MINUTE = "mm";
    public static final String SECOND = "ss";
    public static final String CLASS = "class";
    public static final String PARAM_COUNT = "paramCount";
    public static final String LANGUAGE_CODE = "languageCode";
    public static final String LOCALIZED_MESSAGE = "localizedMessage";
    public static final String CLIENT_TIME = "clientTime";
    public static final String[] MESSAGE_TYPE = new String[]{"Information", "Warning", "Critical", "Fatal", "Dead"};
    private String date = "";
    private String month = "";
    private String year = "";
    private String hour = "";
    private String minute = "";
    private String second = "";
    private String seqNum = "";
    private Hashtable nodeHash = new Hashtable();

    public LogXMLParser(String string) {
        this(string.getBytes());
    }

    public LogXMLParser(byte[] byArray) {
        this.parseXMLBuffer(new ByteArrayInputStream(byArray));
    }

    public LogXMLParser(byte[] byArray, int n, int n2) {
        this.parseXMLBuffer(new ByteArrayInputStream(byArray, n, n2));
    }

    private void parseXMLBuffer(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            this.hashInsert(this.nodeHash, element);
        }
        catch (SAXException sAXException) {
            System.out.println("Error while parsing...");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("The underlying parser does not support the requested features.");
            parserConfigurationException.printStackTrace();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            System.out.println("Error occurred obtaining Document Builder Factory.");
            factoryConfigurationError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getMessageClass() {
        if (this.getTagValue(CLASS) != null) {
            return Integer.parseInt(this.getTagValue(CLASS).trim());
        }
        return -1;
    }

    public int getEventID() {
        if (this.getTagValue(ID) != null) {
            return Integer.parseInt(this.getTagValue(ID).trim());
        }
        return -1;
    }

    public int getSeqNumber() {
        if (this.getTagValue(SEQ_NUM) != null) {
            return Integer.parseInt(this.getTagValue(SEQ_NUM).trim());
        }
        return -1;
    }

    public String getTagValue(String string) {
        return (String)this.nodeHash.get(string);
    }

    public void setTagValue(String string, String string2) {
        this.nodeHash.put(string, string2);
    }

    public String getXML() {
        OutputStream outputStream = this.constructXML(this.nodeHash);
        return outputStream.toString();
    }

    public String[] getParams() {
        String[] stringArray = null;
        if (this.getTagValue(PARAM_COUNT).trim() != null && Integer.parseInt(this.getTagValue(PARAM_COUNT).trim()) >= 0) {
            stringArray = new String[Integer.parseInt(this.getTagValue(PARAM_COUNT).trim())];
            for (int i = 0; i < Integer.parseInt(this.getTagValue(PARAM_COUNT).trim()); ++i) {
                stringArray[i] = this.getTagValue("param" + (i + 1)) != null ? new String(this.getTagValue("param" + (i + 1))) : "";
            }
        }
        return stringArray;
    }

    private void printNodes(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            System.out.println(string + ":" + string2 + ";");
        }
    }

    private void hashInsert(Hashtable hashtable, Node node) {
        if (node.getNodeType() == 1) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.hashInsert(hashtable, nodeList.item(i));
            }
        } else if (node.getNodeType() == 3) {
            Node node2 = node.getParentNode();
            if (node2.getNodeName() == DATE) {
                this.setDate(node.getNodeValue());
            } else if (node2.getNodeName() == MONTH) {
                this.setMonth(node.getNodeValue());
            } else if (node2.getNodeName() == YEAR) {
                this.setYear(node.getNodeValue());
            } else if (node2.getNodeName() == HOUR) {
                this.setHour(node.getNodeValue());
            } else if (node2.getNodeName() == MINUTE) {
                this.setMinute(node.getNodeValue());
            } else if (node2.getNodeName() == SECOND) {
                this.setSecond(node.getNodeValue());
            }
            hashtable.put(node2.getNodeName(), node.getNodeValue());
        }
    }

    private OutputStream constructXML(Hashtable hashtable) {
        File file = new File("schema.xml");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            Node node = this.getNode(element, "param");
            if (node != null) {
                Node node2 = node.getParentNode();
                String string = (String)hashtable.get(PARAM_COUNT);
                if (string.trim() != null) {
                    for (int i = 0; i < Integer.parseInt(string.trim()); ++i) {
                        node2.appendChild(document.createElement("param" + (i + 1)));
                    }
                }
                this.putValueInTags(element, hashtable);
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                TransformerFactory.newInstance().newTransformer().transform(dOMSource, streamResult);
            }
        }
        catch (SAXException sAXException) {
            System.out.println("Error while parsing...");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("The underlying parser does not support the requested features.");
            parserConfigurationException.printStackTrace();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            System.out.println("Error occurred obtaining Document Builder Factory.");
            factoryConfigurationError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    private int putValueInTags(Node node, Hashtable hashtable) {
        if (hashtable.get(node.getNodeName()) != null) {
            node.appendChild(node.getOwnerDocument().createTextNode((String)hashtable.get(node.getNodeName())));
            return 0;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                i += this.putValueInTags(nodeList.item(i), hashtable);
            }
            return 0;
        }
        node.getParentNode().removeChild(node);
        return -1;
    }

    private Node getNode(Node node, String string) {
        if (node.getNodeName().equals(string)) {
            return node;
        }
        if (node.getChildNodes().getLength() > 0) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (this.getNode(nodeList.item(i), string) == null) continue;
                return nodeList.item(i);
            }
        }
        return null;
    }

    public LogXMLParser() {
    }

    public String getMessageType() {
        if (this.getMessageClass() != -1) {
            return MESSAGE_TYPE[this.getMessageClass()];
        }
        return null;
    }

    public int getAttrCount() {
        return this.nodeHash.size();
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String string) {
        this.month = string;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String string) {
        this.year = string;
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String string) {
        this.hour = string;
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String string) {
        this.minute = string;
    }

    public String getSecond() {
        return this.second;
    }

    public void setSecond(String string) {
        this.second = string;
    }

    public String getTimeStamp() {
        String string = "";
        if (this.getYear() == "" && this.getMonth() == "" && this.getDate() == "" && this.getHour() == "" && this.getMinute() == "" && this.second == "") {
            return "Not available";
        }
        if (this.getYear() == "" && this.getMonth() == "" && this.getDate() == "" && this.getHour() == "" && this.getMinute() == "" && this.second.length() > 0) {
            return this.second + " " + "seconds from Reboot";
        }
        string = this.year + "-" + this.month + "-" + this.date + ", " + this.hour + ":" + this.minute + ":" + this.second;
        return string;
    }
}

