/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Framework.PluginManagers.PluginDataInfo;
import Services.NetworkToJavaConverter;
import Services.WWNExtractor;
import java.util.StringTokenizer;

public class NetworkPacket {
    private int[] senderIP;
    private int senderPort;
    private int senderID;
    private int[] receiverIP;
    private int receiverPort;
    private int receiverID;
    private int frameworkError;
    private int requestLength;
    private byte[] databuffer;
    private int requestType;
    private byte[] originalHeader;
    public static final int HEADER_SIZE = 60;
    private static final int RECEIVER_IP_START = 28;
    private static final int RECEIVER_PORT_START = 44;

    public NetworkPacket(byte[] byArray, byte[] byArray2) {
        this.senderIP = new int[4];
        this.receiverIP = new int[4];
        this.originalHeader = byArray;
        this.setRequestType(NetworkToJavaConverter.byteArrayToInt(byArray));
        this.setSenderIP(byArray);
        this.setSenderPort(NetworkToJavaConverter.byteArrayToInt(byArray, 20));
        this.setSenderID(NetworkToJavaConverter.byteArrayToInt(byArray, 24));
        this.setReceiverIP(byArray);
        this.setReceiverPort(NetworkToJavaConverter.byteArrayToInt(byArray, 44));
        this.setReceiverID(NetworkToJavaConverter.byteArrayToInt(byArray, 48));
        this.setFrameworkError(NetworkToJavaConverter.byteArrayToInt(byArray, 52));
        this.setDatabuffer(byArray2);
    }

    public NetworkPacket(int n, PluginDataInfo pluginDataInfo) {
        WWNExtractor wWNExtractor = new WWNExtractor(pluginDataInfo.getSenderWWN());
        WWNExtractor wWNExtractor2 = new WWNExtractor(pluginDataInfo.getReceiverWWN());
        this.senderIP = wWNExtractor.getIP();
        this.receiverIP = wWNExtractor2.getIP();
        this.originalHeader = null;
        this.setRequestType(n);
        this.setSenderPort(wWNExtractor.getPort());
        this.setSenderID(wWNExtractor.getID());
        this.setReceiverPort(wWNExtractor2.getPort());
        this.setReceiverID(wWNExtractor2.getID());
        this.setFrameworkError(0);
        this.setDatabuffer(pluginDataInfo.getBuffer());
    }

    public void setSenderIP(byte[] byArray) {
        this.senderIP[0] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 4);
        this.senderIP[1] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 6);
        this.senderIP[2] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 8);
        this.senderIP[3] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 10);
    }

    public void setReceiverIP(String string) {
        System.out.println("inside setReceiverIP");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                int n2;
                this.receiverIP[n] = n2 = Integer.parseInt(stringTokenizer.nextToken());
                ++n;
            }
            catch (Exception exception) {}
        }
        System.out.println("setReceiverIP:" + this.receiverIP[0] + this.receiverIP[1] + this.receiverIP[2] + this.receiverIP[3]);
    }

    public void setSenderPort(int n) {
        this.senderPort = n;
    }

    public void setSenderID(int n) {
        this.senderID = n;
    }

    public void setReceiverIP(byte[] byArray) {
        int n = 28;
        this.receiverIP[0] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n);
        this.receiverIP[1] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n += 2);
        this.receiverIP[2] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n += 2);
        this.receiverIP[3] = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n += 2);
        this.receiverIP = this.receiverIP;
    }

    public static String getReceiverIPAsStringFromHeader(byte[] byArray) {
        int n = 28;
        int n2 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n);
        int n3 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n += 2);
        int n4 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n += 2);
        int n5 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n += 2);
        return n2 + "." + n3 + "." + n4 + "." + n5;
    }

    public static int getReceiverPortFromHeader(byte[] byArray) {
        return NetworkToJavaConverter.byteArrayToInt(byArray, 44);
    }

    public void setReceiverPort(int n) {
        this.receiverPort = n;
    }

    public void setReceiverID(int n) {
        this.receiverID = n;
    }

    public void setFrameworkError(int n) {
        this.frameworkError = n;
    }

    public void setDatabuffer(byte[] byArray) {
        this.databuffer = byArray;
        this.requestLength = byArray != null ? byArray.length : 0;
    }

    public void setRequestType(int n) {
        this.requestType = n;
    }

    public int[] getSenderIP() {
        return this.senderIP;
    }

    public int getSenderPort() {
        return this.senderPort;
    }

    public int getSenderID() {
        return this.senderID;
    }

    public int[] getReceiverIP() {
        return this.receiverIP;
    }

    public String getReceiverIPAsString() {
        return this.receiverIP[0] + "." + this.receiverIP[1] + "." + this.receiverIP[2] + "." + this.receiverIP[3];
    }

    public String getSenderIPAsString() {
        return this.senderIP[0] + "." + this.senderIP[1] + "." + this.senderIP[2] + "." + this.senderIP[3];
    }

    public int getReceiverPort() {
        return this.receiverPort;
    }

    public int getReceiverID() {
        return this.receiverID;
    }

    public int getFrameworkError() {
        return this.frameworkError;
    }

    public int getRequestLength() {
        return this.requestLength;
    }

    public byte[] getDatabuffer() {
        return this.databuffer;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public byte[] getOriginalHeader() {
        return this.originalHeader;
    }

    public String getSenderWWN() {
        return new String(this.senderIP[0] + "." + this.senderIP[1] + "." + this.senderIP[2] + "." + this.senderIP[3] + ":" + this.senderPort + ":" + this.senderID);
    }

    public String getReceiverWWN() {
        return new String(this.receiverIP[0] + "." + this.receiverIP[1] + "." + this.receiverIP[2] + "." + this.receiverIP[3] + ":" + this.receiverPort + ":" + this.receiverID);
    }

    public static byte[] convertWWNStringToByteArray(String string) {
        byte[] byArray = new byte[24];
        int n = 0;
        int n2 = 0;
        String[] stringArray = string.split(":");
        String[] stringArray2 = stringArray[0].split("\\.");
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            NetworkToJavaConverter.shortTobyteArray(new Short(stringArray2[n2]), byArray, n);
            n += 2;
        }
        while (n2 < 8) {
            NetworkToJavaConverter.shortTobyteArray((short)0, byArray, n);
            n += 2;
            ++n2;
        }
        NetworkToJavaConverter.intToByteArray(new Integer(stringArray[1]), byArray, n);
        NetworkToJavaConverter.intToByteArray(new Integer(stringArray[2]), byArray, n += 4);
        return byArray;
    }

    public static String convertByteArrayToWWNString(byte[] byArray) {
        return NetworkPacket.convertByteArrayToWWNString(byArray, 0);
    }

    public static String convertByteArrayToWWNString(byte[] byArray, int n) {
        return NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n) + "." + NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n + 2) + "." + NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n + 4) + "." + NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, n + 6) + ":" + NetworkToJavaConverter.byteArrayToInt(byArray, n + 16) + ":" + NetworkToJavaConverter.byteArrayToInt(byArray, n + 20);
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[60 + (this.databuffer != null ? this.databuffer.length : 0)];
        int n = 0;
        NetworkToJavaConverter.intToByteArray(this.requestType, byArray);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[0], byArray, n += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[1], byArray, n += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[2], byArray, n += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.senderIP[3], byArray, n += 2);
        n = 20;
        NetworkToJavaConverter.intToByteArray(this.senderPort, byArray, n);
        NetworkToJavaConverter.intToByteArray(this.senderID, byArray, n += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[0], byArray, n += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[1], byArray, n += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[2], byArray, n += 2);
        NetworkToJavaConverter.shortTobyteArray((short)this.receiverIP[3], byArray, n += 2);
        n += 2;
        n = 44;
        NetworkToJavaConverter.intToByteArray(this.receiverPort, byArray, n);
        NetworkToJavaConverter.intToByteArray(this.receiverID, byArray, n += 4);
        NetworkToJavaConverter.shortTobyteArray((short)this.frameworkError, byArray, n += 4);
        n += 4;
        if (this.databuffer != null) {
            this.requestLength = this.databuffer.length;
            NetworkToJavaConverter.intToByteArray(this.requestLength, byArray, n);
            System.arraycopy(this.databuffer, 0, byArray, n += 4, this.databuffer.length);
        } else {
            this.requestLength = 0;
        }
        return byArray;
    }
}

