/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Services.NetworkToJavaConverter;
import Services.VivaldiByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class VivaldiDataInputStream {
    private VivaldiByteArrayInputStream m_byteArrayIS = null;
    private DataInputStream m_dataIS = null;

    public VivaldiDataInputStream(byte[] byArray) {
        this.m_byteArrayIS = new VivaldiByteArrayInputStream(byArray);
        this.m_dataIS = new DataInputStream(this.m_byteArrayIS);
    }

    public int readInt() throws IOException {
        int n = NetworkToJavaConverter.byteArrayToInt(this.m_byteArrayIS.getBuffer(), this.m_byteArrayIS.getPosition());
        this.m_dataIS.readInt();
        return n;
    }

    public short readShort() throws IOException {
        short s = NetworkToJavaConverter.byteArrayToShort(this.m_byteArrayIS.getBuffer(), this.m_byteArrayIS.getPosition());
        this.m_dataIS.readShort();
        return s;
    }

    public char readChar() throws IOException {
        char c = (char)NetworkToJavaConverter.byteArrayToUnsignedShort(this.m_byteArrayIS.getBuffer(), this.m_byteArrayIS.getPosition());
        this.m_dataIS.readChar();
        return c;
    }

    public byte readByte() throws IOException {
        return this.m_dataIS.readByte();
    }

    public void skipBytes(int n) throws IOException {
        this.m_dataIS.skipBytes(n);
    }

    public int getPosition() {
        return this.m_byteArrayIS.getPosition();
    }
}

