/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_LD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Snapshot.PitDetailPanel;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CreateConcurrentPitDialog
extends VivaldiBaseDialog {
    private AdapterHelper m_helper = null;
    private ArrayList<LogicalDriveHelper> m_ldHelper = null;
    PitDetailPanel pitDetailPanel = null;
    private JPanel mainPanel = new JPanel();
    GridBagConstraints gbc = new GridBagConstraints();
    private JLabel baseVdsLabel = new JLabel();
    private JPanel baseVdPanel = new JPanel();
    private JScrollPane baseVds = null;
    private JCheckBox[] baseVdCheckBox = null;
    private JCheckBox allVdsCheckBox = null;
    private JLabel cTSdescLabel = new JLabel();
    private JLabel snapNameLabel = new JLabel();
    private JTextField snapName = new JTextField(16);
    private JButton createSnapshotButton = new JButton();
    private JPanel tempPanel;
    GridBagConstraints gbcnew = new GridBagConstraints();

    public CreateConcurrentPitDialog(ArrayList<LogicalDriveHelper> arrayList, AdapterHelper adapterHelper) {
        this.m_helper = adapterHelper;
        this.m_ldHelper = arrayList;
        this.buildUI();
    }

    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("PIT related AEN Received: " + new String(mR_EVT_DETAIL.getdescription()).trim());
        }
        try {
            switch (n) {
                case 349: 
                case 350: {
                    this.buildUI();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buildUI() {
        String[] stringArray = null;
        this.mainPanel.setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(10, 10, 0, 10);
        String string = Resource.getString("LDRIVE_OPERATION_CREATE_SNAPSHOT_TITLE", "Create Snapshots");
        this.cTSdescLabel.setText(Resource.getString("CREATE_CTS_DESC", "Create concurrent snapshots across virtual drives by selecting the virtual drives."));
        this.mainPanel.add((Component)this.cTSdescLabel, this.gbc);
        ++this.gbc.gridy;
        stringArray = Resource.getResourceMnemonic(Resource.getString("SNAPSHOT_NAME_TEXT", "(S)napshot name:"));
        this.snapNameLabel.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.snapNameLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.mainPanel.add((Component)this.snapNameLabel, this.gbc);
        ++this.gbc.gridy;
        MR_TIME_STAMP mR_TIME_STAMP = ((SASAdapter)this.m_helper.getDeviceObject()).getCtrlTime();
        this.snapName.setText("SNAP_" + mR_TIME_STAMP.gethour() + ":" + mR_TIME_STAMP.getmin() + ":" + mR_TIME_STAMP.getsec());
        this.mainPanel.add((Component)this.snapName, this.gbc);
        this.snapNameLabel.setLabelFor(this.snapName);
        ++this.gbc.gridy;
        stringArray = Resource.getResourceMnemonic(Resource.getString("SELECT_BASE_VD_TEXT", "(V)irtual drives:"));
        this.baseVdsLabel.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.baseVdsLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.mainPanel.add((Component)this.baseVdsLabel, this.gbc);
        this.baseVdPanel.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.tempPanel = new JPanel(gridBagLayout);
        this.baseVdPanel.add((Component)this.tempPanel, "North");
        this.baseVdCheckBox = new JCheckBox[this.m_ldHelper.size()];
        this.gbcnew.fill = 2;
        this.gbcnew.gridx = 0;
        this.gbcnew.gridy = 0;
        this.gbcnew.weightx = 1.0;
        for (int n = 0; n < this.baseVdCheckBox.length; n = (int)((byte)(n + 1))) {
            this.baseVdCheckBox[n] = new JCheckBox(this.m_ldHelper.get(n).getText());
            this.tempPanel.add((Component)this.baseVdCheckBox[n], this.gbcnew);
            ++this.gbcnew.gridy;
        }
        this.baseVds = new JScrollPane(this.baseVdPanel, 20, 30);
        this.baseVds.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width / 3, MainFrame.SCREEN_SIZE.height / 4));
        ++this.gbc.gridy;
        this.mainPanel.add((Component)this.baseVds, this.gbc);
        this.baseVdsLabel.setLabelFor(this.baseVds);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CHECK_BOX_TEXT_ALL", "(A)ll"));
        this.allVdsCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.allVdsCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        ++this.gbc.gridy;
        this.mainPanel.add((Component)this.allVdsCheckBox, this.gbc);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_OK", "Ok"));
        this.createSnapshotButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.createSnapshotButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.getRootPane().setDefaultButton(this.createSnapshotButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        JButton jButton = new JButton(stringArray[0]);
        jPanel.add(this.createSnapshotButton);
        jPanel.add(jButton);
        this.gbc.gridy += 5;
        this.gbc.insets = new Insets(0, 0, 10, 0);
        this.gbc.anchor = 10;
        this.mainPanel.add((Component)jPanel, this.gbc);
        this.allVdsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (CreateConcurrentPitDialog.this.allVdsCheckBox.isSelected()) {
                    for (n = 0; n < CreateConcurrentPitDialog.this.baseVdCheckBox.length; n = (int)((byte)(n + 1))) {
                        CreateConcurrentPitDialog.this.baseVdCheckBox[n].setSelected(true);
                    }
                }
                if (!CreateConcurrentPitDialog.this.allVdsCheckBox.isSelected()) {
                    for (n = 0; n < CreateConcurrentPitDialog.this.baseVdCheckBox.length; n = (int)((byte)(n + 1))) {
                        CreateConcurrentPitDialog.this.baseVdCheckBox[n].setSelected(false);
                    }
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CreateConcurrentPitDialog.this.warningDialog()) {
                    CreateConcurrentPitDialog.this.dispose();
                }
            }
        });
        this.createSnapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ArrayList arrayList = new ArrayList();
                for (int n2 = 0; n2 < CreateConcurrentPitDialog.this.baseVdCheckBox.length; n2 = (int)((byte)(n2 + 1))) {
                    if (!CreateConcurrentPitDialog.this.baseVdCheckBox[n2].isSelected()) continue;
                    arrayList.add(CreateConcurrentPitDialog.this.m_ldHelper.get(n2));
                }
                if (arrayList.size() == 0 && JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("SNAPSHOT_VD_SELECTION_MANDATORY_MESSAGE"), Resource.getString("SNAPSHOT_VD_SELECTION_MANDATORY"), -1, 2) == 0) {
                    return;
                }
                MR_LD_REF[] mR_LD_REFArray = new MR_LD_REF[arrayList.size()];
                for (int n3 = 0; n3 < mR_LD_REFArray.length; n3 = (int)((byte)(n3 + 1))) {
                    mR_LD_REFArray[n3] = ((SASLogicalDrive)((LogicalDriveHelper)arrayList.get(n3)).getDeviceObject()).getInformation().getldConfig().getproperties().getldRef();
                }
                byte[] byArray = CreateConcurrentPitDialog.this.snapName.getText().getBytes();
                boolean bl = true;
                for (n = 0; n < byArray.length; ++n) {
                    if (byArray[n] == 32) continue;
                    bl = false;
                }
                if ((CreateConcurrentPitDialog.this.snapName.getText().length() == 0 || bl) && JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("SNAPSHOT_NAME_MANDATORY_MESSAGE", "You cannot leave this field blank. Enter a snapshot name to proceed."), Resource.getString("SNAPSHOT_NAME_MANDATORY", "Enter Snapshot Name - Mandatory"), -1, 2) == 0) {
                    return;
                }
                n = ((SASAdapter)CreateConcurrentPitDialog.this.m_helper.getDeviceObject()).createConcurrentPITs((byte)mR_LD_REFArray.length, mR_LD_REFArray, byArray) ? 1 : 0;
                if (n == 1) {
                    JOptionPane.showMessageDialog(null, Resource.getString("CREATE_CONSISTENCY_SET_SUCCESSFUL", "<html>The snapshots were created successfully. Please select the<br>snapshot base to see the corresponding details of the<br>snapshots.<br></html>"), Resource.getString("CONSISTENCY_SET_CREATED_TITLE", "Confirmation Snapshot Created"), 1);
                }
                CreateConcurrentPitDialog.this.dispose();
            }
        });
        this.add((Component)this.mainPanel, "West");
        this.setTitle(string);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }
}

